/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.FilteredEventReader;
import gnu.xml.stream.FilteredStreamReader;
import gnu.xml.stream.XIncludeFilter;
import gnu.xml.stream.XMLEventAllocatorImpl;
import gnu.xml.stream.XMLEventReaderImpl;
import gnu.xml.stream.XMLParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class XMLInputFactoryImpl
extends XMLInputFactory {
    protected XMLResolver resolver;
    protected XMLReporter reporter;
    protected XMLEventAllocator allocator = new XMLEventAllocatorImpl();
    protected boolean validating;
    protected boolean namespaceAware = true;
    protected boolean coalescing;
    protected boolean replacingEntityReferences = true;
    protected boolean externalEntities = true;
    protected boolean supportDTD = true;
    protected boolean xIncludeAware = false;
    protected boolean baseAware = true;
    protected boolean stringInterning = true;

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(null, reader);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        String systemId = source.getSystemId();
        InputStream in = this.getInputStream(source);
        XMLParser ret = new XMLParser(in, systemId, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD, this.baseAware, this.stringInterning, false, this.reporter, this.resolver);
        if (this.xIncludeAware) {
            return new XIncludeFilter(ret, systemId, this.namespaceAware, this.validating, this.replacingEntityReferences);
        }
        return ret;
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return this.createXMLStreamReader(null, in);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return this.createXMLStreamReader(in);
    }

    public XMLStreamReader createXMLStreamReader(String systemId, InputStream in) throws XMLStreamException {
        XMLParser ret = new XMLParser(in, systemId, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD, this.baseAware, this.stringInterning, false, this.reporter, this.resolver);
        if (this.xIncludeAware) {
            return new XIncludeFilter(ret, null, this.namespaceAware, this.validating, this.replacingEntityReferences);
        }
        return ret;
    }

    public XMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        XMLParser ret = new XMLParser(reader, systemId, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD, this.baseAware, this.stringInterning, false, this.reporter, this.resolver);
        if (this.xIncludeAware) {
            return new XIncludeFilter(ret, null, this.namespaceAware, this.validating, this.replacingEntityReferences);
        }
        return ret;
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(reader);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(String systemId, Reader reader) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(systemId, reader);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return new XMLEventReaderImpl(reader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(source);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(in);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream in, String encoding) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(in, encoding);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(String systemId, InputStream in) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(systemId, in);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new FilteredEventReader(reader, filter);
    }

    public XMLResolver getXMLResolver() {
        return this.resolver;
    }

    public void setXMLResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    public XMLReporter getXMLReporter() {
        return this.reporter;
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (name.equals("javax.xml.stream.isNamespaceAware")) {
            this.namespaceAware = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isValidating")) {
            this.validating = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isCoalescing")) {
            this.coalescing = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isReplacingEntityReferences")) {
            this.replacingEntityReferences = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isSupportingExternalEntities")) {
            this.externalEntities = (Boolean)value;
        } else if (name.equals("javax.xml.stream.supportDTD")) {
            this.supportDTD = (Boolean)value;
        } else if (name.equals("javax.xml.stream.reporter")) {
            this.reporter = (XMLReporter)value;
        } else if (name.equals("javax.xml.stream.resolver")) {
            this.resolver = (XMLResolver)value;
        } else if (name.equals("javax.xml.stream.allocator")) {
            this.allocator = (XMLEventAllocator)value;
        } else if (name.equals("gnu.xml.stream.stringInterning")) {
            this.stringInterning = (Boolean)value;
        } else if (name.equals("gnu.xml.stream.baseAware")) {
            this.baseAware = (Boolean)value;
        } else if (name.equals("gnu.xml.stream.xIncludeAware")) {
            this.xIncludeAware = (Boolean)value;
        } else {
            throw new IllegalArgumentException(name);
        }
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name.equals("javax.xml.stream.isNamespaceAware")) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isValidating")) {
            return this.validating ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isCoalescing")) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isReplacingEntityReferences")) {
            return this.replacingEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isSupportingExternalEntities")) {
            return this.externalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.supportDTD")) {
            return this.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.reporter")) {
            return this.reporter;
        }
        if (name.equals("javax.xml.stream.resolver")) {
            return this.resolver;
        }
        if (name.equals("javax.xml.stream.allocator")) {
            return this.allocator;
        }
        if (name.equals("gnu.xml.stream.stringInterning")) {
            return this.stringInterning ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("gnu.xml.stream.baseAware")) {
            return this.baseAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("gnu.xml.stream.xIncludeAware")) {
            return this.xIncludeAware ? Boolean.TRUE : Boolean.FALSE;
        }
        throw new IllegalArgumentException(name);
    }

    public boolean isPropertySupported(String name) {
        return name.equals("javax.xml.stream.isNamespaceAware") || name.equals("javax.xml.stream.isValidating") || name.equals("javax.xml.stream.isCoalescing") || name.equals("javax.xml.stream.isReplacingEntityReferences") || name.equals("javax.xml.stream.isSupportingExternalEntities") || name.equals("javax.xml.stream.supportDTD") || name.equals("javax.xml.stream.reporter") || name.equals("javax.xml.stream.resolver") || name.equals("javax.xml.stream.allocator") || name.equals("gnu.xml.stream.stringInterning") || name.equals("gnu.xml.stream.baseAware") || name.equals("gnu.xml.stream.xIncludeAware");
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.allocator = allocator;
    }

    public XMLEventAllocator getEventAllocator() {
        return this.allocator;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    protected InputStream getInputStream(Source source) throws XMLStreamException {
        InputStream in = null;
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            in = streamSource.getInputStream();
        }
        if (in == null) {
            String systemId = source.getSystemId();
            try {
                URL url = new URL(systemId);
                try {
                    in = url.openStream();
                }
                catch (IOException e2) {
                    XMLStreamException e3 = new XMLStreamException(e2);
                    e3.initCause(e2);
                    throw e3;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (File.separatorChar != '/') {
                    systemId = systemId.replace('/', File.separatorChar);
                }
                try {
                    in = new FileInputStream(systemId);
                }
                catch (FileNotFoundException e2) {
                    XMLStreamException e3 = new XMLStreamException(e2);
                    e3.initCause(e2);
                    throw e3;
                }
            }
        }
        return in;
    }
}

