/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import gnu.javax.security.auth.login.ConfigFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class GnuConfiguration
extends Configuration {
    private static final Logger log = null;
    private Map loginModulesMap = new HashMap();
    private ConfigFileParser cp = new ConfigFileParser();

    public GnuConfiguration() {
        this.init();
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        if (appName == null) {
            return null;
        }
        if ((appName = appName.trim()).length() == 0) {
            return null;
        }
        List loginModules = (List)this.loginModulesMap.get(appName);
        if (loginModules == null || loginModules.size() == 0) {
            return null;
        }
        return loginModules.toArray(new AppConfigurationEntry[0]);
    }

    public void refresh() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("refreshLoginConfiguration"));
        }
        this.loginModulesMap.clear();
        this.init();
    }

    private void init() {
        if (this.processSecurityProperties() || this.processSystemProperty() || this.processUserHome()) {
            // empty if block
        }
    }

    private boolean processSecurityProperties() {
        boolean result = false;
        int counter = 0;
        while (true) {
            try {
                String s;
                while ((s = Security.getProperty("java.security.auth.login.config.url." + ++counter)) != null) {
                    if ((s = s.trim()).length() == 0) continue;
                    this.parseConfig(this.getInputStreamFromURL(s));
                    result = true;
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
        return result;
    }

    private InputStream getInputStreamFromURL(String s) throws IOException {
        InputStream result = null;
        try {
            URL url = new URL(s);
            result = url.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            result = new FileInputStream(s);
        }
        return result;
    }

    private boolean processSystemProperty() {
        boolean result = false;
        try {
            String s = System.getProperty("java.security.auth.login.config");
            if (s != null && (s = s.trim()).length() != 0) {
                this.parseConfig(this.getInputStreamFromURL(s));
                result = true;
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    private boolean processUserHome() {
        boolean result = false;
        try {
            File userHome = this.getUserHome();
            if (userHome == null) {
                return result;
            }
            File jaasFile = this.getConfigFromUserHome(userHome, ".java.login.config");
            if (jaasFile == null) {
                jaasFile = this.getConfigFromUserHome(userHome, "java.login.config");
            }
            if (jaasFile == null) {
                return result;
            }
            FileInputStream fis = new FileInputStream(jaasFile);
            this.parseConfig(fis);
            result = true;
        }
        catch (Throwable throwable) {}
        return result;
    }

    private void parseConfig(InputStream configStream) throws IOException {
        this.cp.parse(new InputStreamReader(configStream, "UTF-8"));
        Map loginModulesMap = this.cp.getLoginModulesMap();
        this.mergeLoginModules(loginModulesMap);
    }

    private void mergeLoginModules(Map otherLoginModules) {
        if (otherLoginModules == null || otherLoginModules.size() < 1) {
            return;
        }
        for (String appName : otherLoginModules.keySet()) {
            List thatListOfACEs = (List)otherLoginModules.get(appName);
            if (thatListOfACEs == null || thatListOfACEs.size() < 1) continue;
            List thisListsOfACEs = (List)this.loginModulesMap.get(appName);
            if (thisListsOfACEs == null) {
                this.loginModulesMap.put(appName, thatListOfACEs);
                continue;
            }
            thisListsOfACEs.addAll(thatListOfACEs);
        }
    }

    private File getUserHome() {
        String uh = System.getProperty("user.home");
        if (uh == null || uh.trim().length() == 0) {
            return null;
        }
        File result = new File(uh = uh.trim());
        if (!result.exists()) {
            return null;
        }
        if (!result.isDirectory()) {
            return null;
        }
        if (!result.canRead()) {
            return null;
        }
        return result;
    }

    private File getConfigFromUserHome(File userHome, String fileName) {
        File result = new File(userHome, fileName);
        if (!result.exists()) {
            return null;
        }
        if (!result.isFile()) {
            return null;
        }
        if (!result.canRead()) {
            return null;
        }
        return result;
    }
}

