/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CompressionMethod;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompressionMethodList
implements Iterable<CompressionMethod> {
    private final ByteBuffer buffer;
    private int modCount;

    public CompressionMethodList(ByteBuffer buffer) {
        this.buffer = buffer;
        this.modCount = 0;
    }

    public int size() {
        return this.buffer.get(0) & 0xFF;
    }

    public CompressionMethod get(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("limit: " + size + "; requested: " + index);
        }
        return CompressionMethod.getInstance(this.buffer.get(1 + index));
    }

    public void put(int index, CompressionMethod method) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("limit: " + size + "; requested: " + index);
        }
        this.buffer.position(1 + index);
        this.buffer.put((byte)method.getValue());
        ++this.modCount;
    }

    public void setSize(int newSize) {
        if (newSize < 0 || newSize > 255) {
            throw new IllegalArgumentException("size must be between 0 and 255");
        }
        if (newSize + 1 > this.buffer.capacity()) {
            throw new IllegalArgumentException("limit: " + this.buffer.capacity() + "; requested: " + newSize);
        }
        this.buffer.put(0, (byte)newSize);
        ++this.modCount;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("[");
        out.print(this.size());
        out.println("] {");
        Iterator it = new Iterator();
        while (it.hasNext()) {
            CompressionMethod method = it.next();
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  ");
            out.print((Object)method);
            if (it.hasNext()) {
                out.print(",");
            }
            out.println();
        }
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("};");
        return str.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompressionMethodList)) {
            return false;
        }
        CompressionMethodList that = (CompressionMethodList)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator it1 = new Iterator();
        Iterator it2 = that.new Iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (it1.next().equals((Object)it2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public java.util.Iterator<CompressionMethod> iterator() {
        return new Iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements ListIterator<CompressionMethod> {
        private int index = 0;
        private final int modCount;

        Iterator() {
            this.modCount = CompressionMethodList.this.modCount;
        }

        @Override
        public void add(CompressionMethod cm) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < CompressionMethodList.this.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public CompressionMethod next() throws NoSuchElementException {
            if (this.modCount != CompressionMethodList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CompressionMethodList.this.get(this.index++);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return this.index + 1;
            }
            return -1;
        }

        @Override
        public CompressionMethod previous() throws NoSuchElementException {
            if (this.index == 0) {
                throw new NoSuchElementException();
            }
            if (this.modCount != CompressionMethodList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            try {
                return CompressionMethodList.this.get(--this.index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(CompressionMethod cm) {
            CompressionMethodList.this.put(this.index, cm);
        }
    }
}

