/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ClientRSA_PSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientRSA_PSKParameters(ByteBuffer buffer) {
        super(buffer);
    }

    public ClientRSA_PSKParameters(String identity, ByteBuffer epms) {
        super(null);
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer idBuf = utf8.encode(identity);
        this.buffer = ByteBuffer.allocate(2 + idBuf.remaining() + epms.remaining());
        this.buffer.putShort((short)idBuf.remaining());
        this.buffer.put(idBuf);
        this.buffer.put(epms);
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    public String identity() {
        Charset utf8 = Charset.forName("UTF-8");
        return utf8.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.identityLength())).toString();
    }

    private int identityLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public int length() {
        return this.identityLength() + this.secret().length();
    }

    public EncryptedPreMasterSecret secret() {
        return new EncryptedPreMasterSecret(((ByteBuffer)this.buffer.duplicate().position(this.identityLength()).limit(this.buffer.capacity())).slice(), ProtocolVersion.TLS_1);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("  identity = ");
        out.print(this.identity());
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("  encrypted_pre_master_secret =");
        out.println(this.secret().toString(prefix != null ? String.valueOf(prefix) + "    " : "    "));
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} ClientRSA_PSKParameters;");
        return str.toString();
    }
}

