/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGComponent;
import java.util.ArrayList;

public class JPEGScan {
    private int maxHeight = 0;
    private int maxWidth = 0;
    private int maxV = 0;
    private int maxH = 0;
    private int numOfComponents = 0;
    private int numOfComponentBlocks = 0;
    private ArrayList components = new ArrayList();

    public JPEGScan() {
    }

    public JPEGScan(int h, int w) {
        this.maxHeight = h;
        this.maxWidth = w;
    }

    private void recalculateDimensions() {
        JPEGComponent comp;
        int i = 0;
        while (i < this.components.size()) {
            comp = (JPEGComponent)this.components.get(i);
            if (comp.factorH > this.maxH) {
                this.maxH = comp.factorH;
            }
            if (comp.factorV > this.maxV) {
                this.maxV = comp.factorV;
            }
            ++i;
        }
        i = 0;
        while (i < this.components.size()) {
            comp = (JPEGComponent)this.components.get(i);
            comp.maxH = this.maxH;
            comp.maxV = this.maxV;
            ++i;
        }
    }

    public void addComponent(byte id, byte factorHorizontal, byte factorVertical, byte quantizationID) {
        JPEGComponent component = new JPEGComponent(id, factorHorizontal, factorVertical, quantizationID);
        this.components.add(component);
        this.recalculateDimensions();
        ++this.numOfComponents;
        this.numOfComponentBlocks += factorHorizontal * factorVertical;
    }

    public JPEGComponent getComponentByID(byte id) {
        JPEGComponent comp = (JPEGComponent)this.components.get(0);
        int i = 0;
        while (i < this.components.size()) {
            comp = (JPEGComponent)this.components.get(i);
            if (comp.component_id == id) break;
            ++i;
        }
        return comp;
    }

    public JPEGComponent get(int id) {
        return (JPEGComponent)this.components.get(id);
    }

    public int getX(byte id) {
        JPEGComponent comp = this.getComponentByID(id);
        return comp.width;
    }

    public int getY(byte id) {
        JPEGComponent comp = this.getComponentByID(id);
        return comp.height;
    }

    public int getMaxV() {
        return this.maxV;
    }

    public int getMaxH() {
        return this.maxH;
    }

    public void setWidth(int w) {
        this.maxWidth = w;
    }

    public void setHeight(int h) {
        this.maxHeight = h;
    }

    public int size() {
        return this.numOfComponents;
    }

    public int sizeComponentBlocks() {
        return this.numOfComponentBlocks;
    }
}

