/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509;

import gnu.java.lang.CPStringBuilder;

public final class Util {
    public static final String HEX = "0123456789abcdef";

    public static String toHexString(byte[] buf, int off, int len) {
        CPStringBuilder str = new CPStringBuilder();
        int i = 0;
        while (i < len) {
            str.append(HEX.charAt(buf[i + off] >>> 4 & 0xF));
            str.append(HEX.charAt(buf[i + off] & 0xF));
            ++i;
        }
        return str.toString();
    }

    public static String toHexString(byte[] buf) {
        return Util.toHexString(buf, 0, buf.length);
    }

    public static String toHexString(byte[] buf, int off, int len, char sep) {
        CPStringBuilder str = new CPStringBuilder();
        int i = 0;
        while (i < len) {
            str.append(HEX.charAt(buf[i + off] >>> 4 & 0xF));
            str.append(HEX.charAt(buf[i + off] & 0xF));
            if (i < len - 1) {
                str.append(sep);
            }
            ++i;
        }
        return str.toString();
    }

    public static String toHexString(byte[] buf, char sep) {
        return Util.toHexString(buf, 0, buf.length, sep);
    }

    public static String hexDump(byte[] buf, int off, int len, String prefix) {
        String nl = System.getProperty("line.separator");
        CPStringBuilder str = new CPStringBuilder();
        int i = 0;
        while (i < len) {
            str.append(prefix);
            str.append(Util.formatInt(i + off, 16, 8));
            str.append("  ");
            String s = Util.toHexString(buf, i + off, Math.min(16, len - i), ' ');
            str.append(s);
            int j = 56 - (56 - s.length());
            while (j < 56) {
                str.append(" ");
                ++j;
            }
            j = 0;
            while (j < Math.min(16, len - i)) {
                if ((buf[i + off + j] & 0xFF) < 32 || (buf[i + off + j] & 0xFF) > 126) {
                    str.append('.');
                } else {
                    str.append((char)(buf[i + off + j] & 0xFF));
                }
                ++j;
            }
            str.append(nl);
            i += 16;
        }
        return str.toString();
    }

    public static String hexDump(byte[] buf, String prefix) {
        return Util.hexDump(buf, 0, buf.length, prefix);
    }

    public static String formatInt(int i, int radix, int len) {
        String s = Integer.toString(i, radix);
        CPStringBuilder buf = new CPStringBuilder();
        int j = 0;
        while (j < len - s.length()) {
            buf.append("0");
            ++j;
        }
        buf.append(s);
        return buf.toString();
    }

    public static byte[] toByteArray(String hex) {
        hex = hex.toLowerCase();
        byte[] buf = new byte[hex.length() / 2];
        int j = 0;
        int i = 0;
        while (i < buf.length) {
            buf[i] = (byte)(Character.digit(hex.charAt(j++), 16) << 4 | Character.digit(hex.charAt(j++), 16));
            ++i;
        }
        return buf;
    }
}

