/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class ChannelWriter
extends Writer {
    private static final int DEFAULT_BUFFER_CAP = 8192;
    private WritableByteChannel byteChannel;
    private CharsetEncoder enc;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;

    private void writeBuffer() throws IOException {
        this.byteBuffer.flip();
        this.byteChannel.write(this.byteBuffer);
    }

    public ChannelWriter(WritableByteChannel ch, CharsetEncoder enc, int minBufferCap) {
        this.byteChannel = ch;
        this.enc = enc;
        if (minBufferCap == -1) {
            minBufferCap = 8192;
        }
        this.byteBuffer = ByteBuffer.allocate((int)((float)minBufferCap * enc.maxBytesPerChar()));
        this.charBuffer = CharBuffer.allocate(minBufferCap);
        this.charBuffer.clear();
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.enc == null) {
                throw new IOException("writer already closed");
            }
            this.byteBuffer.clear();
            this.charBuffer.flip();
            CoderResult res = this.enc.encode(this.charBuffer, this.byteBuffer, true);
            if (res.isError() || res.isMalformed() || res.isUnmappable()) {
                res.throwException();
            }
            this.writeBuffer();
            this.byteBuffer.clear();
            res = this.enc.flush(this.byteBuffer);
            if (res.isError() || res.isMalformed() || res.isUnmappable()) {
                res.throwException();
            }
            this.writeBuffer();
            this.enc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.enc == null) {
                throw new IOException("writer already closed");
            }
            int lastLen = -1;
            while (len > 0) {
                int allowed = Math.min(this.charBuffer.remaining(), len);
                this.charBuffer.put(buf, offset, allowed);
                offset += allowed;
                this.charBuffer.flip();
                if ((len -= allowed) == lastLen) {
                    if (len <= this.charBuffer.remaining()) {
                        this.charBuffer.put(buf, offset, len);
                        this.charBuffer.flip();
                        break;
                    }
                    CharBuffer ncb = CharBuffer.allocate(this.charBuffer.length() + len);
                    ncb.put(this.charBuffer);
                    ncb.put(buf, offset, len);
                    this.charBuffer = ncb;
                    break;
                }
                lastLen = len;
                this.byteBuffer.clear();
                CoderResult res = this.enc.encode(this.charBuffer, this.byteBuffer, false);
                this.charBuffer.compact();
                if (res.isError() || res.isMalformed() || res.isUnmappable()) {
                    res.throwException();
                }
                this.writeBuffer();
            }
        }
    }
}

