/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.gcjlib;

import gnu.gcj.Core;
import gnu.gcj.runtime.SharedLibHelper;
import gnu.java.net.protocol.core.CoreInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

class Connection
extends URLConnection {
    String solib;
    String name;
    Core core;

    public Connection(URL url) throws MalformedURLException {
        super(url);
        int index = url.getFile().indexOf("!/");
        if (index == -1) {
            throw new MalformedURLException("couldn't find !/ in gcjlib URL");
        }
        this.name = url.getFile().substring(index + 2);
        this.solib = url.getFile().substring(0, index);
    }

    public void connect() throws IOException {
        if (this.core != null) {
            return;
        }
        SharedLibHelper helper = SharedLibHelper.findHelper(this.solib);
        if (helper == null) {
            throw new IOException("library not loaded: " + this.solib);
        }
        this.core = helper.findCore(this.name);
        if (this.core == null) {
            throw new IOException("couldn't find core object: " + this.name);
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return new CoreInputStream(this.core);
    }

    public String getHeaderField(String field) {
        try {
            if (!this.connected) {
                this.connect();
            }
            if (field.equals("content-type")) {
                return Connection.guessContentTypeFromName(this.name);
            }
            if (field.equals("content-length")) {
                return Long.toString(this.core.length);
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

