/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

public class PlatformHelper {
    public static final boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    public static final int INITIAL_MAX_PATH = 130;

    public static final int beginWithRootPathPrefix(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            return 1;
        }
        if (!isWindows) {
            return 0;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':' && (path.charAt(2) == '/' || path.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    public static final boolean isRootDirectory(String path) {
        int len = path.length();
        return len > 0 && PlatformHelper.beginWithRootPathPrefix(path) == len;
    }

    public static final boolean endWithSeparator(String path) {
        return path.endsWith("\\") || path.endsWith("/");
    }

    public static final String removeTailSeparator(String path) {
        if (PlatformHelper.endWithSeparator(path) && !PlatformHelper.isRootDirectory(path)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static final int lastIndexOfSeparator(String path) {
        return Math.max(path.lastIndexOf("/"), path.lastIndexOf("\\"));
    }
}

