
/**
 * @file
 * Enables and disables expiration fields to prevent invalid configurations.
 */

/**
 * Disables duration amount when its type is "never".
 */
function _uc_role_expiration_disable_check(granularity, quantity) {
  // 'never' means there's no point in setting a duration.
  if ($(granularity).val() == 'never') {
    $(quantity).attr('disabled', 'disabled').val('');
  }
  // Anything besides 'never' should enable setting a duration.
  else {
    $(quantity).removeAttr('disabled');
  }
}

/**
 * Switch between relative and absolute expiration durations.
 */
function expiration_switcher() {
  if ($('#edit-expiration').val() == 'abs') {
    $("#edit-uc-roles-expire-relative-duration-wrapper").hide();
    $("#edit-uc-roles-expire-relative-granularity-wrapper").hide();
    $("#edit-uc-roles-by-quantity-wrapper").hide();
    $("#edit-uc-roles-expire-absolute-wrapper").show();
  }
  else {
    $("#edit-uc-roles-expire-absolute-wrapper").hide();
    $("#edit-uc-roles-expire-relative-duration-wrapper").show();
    $("#edit-uc-roles-expire-relative-granularity-wrapper").show();
    $("#edit-uc-roles-by-quantity-wrapper").show();
  }
}

/**
 * Set the default state for expiration duration.
 */
function expiration_switcher_default() {
  if ($('#edit-uc-roles-default-end-expiration').val() == 'abs') {
    $("#edit-uc-roles-default-length-wrapper").attr('style', 'display:none;');
    $("#edit-uc-roles-default-granularity-wrapper").attr('style', 'display:none;');
    $("#edit-uc-roles-default-by-quantity-wrapper").attr('style', 'display:none;');
    $("#edit-uc-roles-default-end-time-wrapper").removeAttr('style');
  }
  else {
    $("#edit-uc-roles-default-length-wrapper").removeAttr('style');
    $("#edit-uc-roles-default-granularity-wrapper").removeAttr('style');
    $("#edit-uc-roles-default-by-quantity-wrapper").removeAttr('style');
    $("#edit-uc-roles-default-end-time-wrapper").attr('style', 'display:none;');
  }
}

/**
 * Override the expiration duration default state.
 */
function uc_roles_expiration_default_override() {
  if ($('#edit-end-override').length == 0) {
    return;
  }

  if ($('#edit-end-override').attr('checked')) {
    $('#edit-expiration-wrapper').removeAttr('style');
    $('#edit-uc-roles-expire-absolute-wrapper').removeAttr('style');
    $('#edit-uc-roles-expire-relative-duration-wrapper').removeAttr('style');
    $('#edit-uc-roles-expire-relative-granularity-wrapper').removeAttr('style');
    $('#edit-uc-roles-by-quantity-wrapper').removeAttr('style');
    expiration_switcher();
  }
  else {
    $('#edit-expiration-wrapper').attr('style', 'display:none;');
    $('#edit-uc-roles-expire-relative-duration-wrapper').attr('style', 'display:none;');
    $('#edit-uc-roles-expire-relative-granularity-wrapper').attr('style', 'display:none;');
    $('#edit-uc-roles-by-quantity-wrapper').attr('style', 'display:none;');
    $('#edit-uc-roles-expire-absolute-wrapper').attr('style', 'display:none;');
  }
}

$(document).ready(
  function() {
    _uc_role_expiration_disable_check('#edit-uc-roles-expire-relative-granularity', '#edit-uc-roles-expire-relative-duration');
    _uc_role_expiration_disable_check('#edit-uc-roles-default-granularity', '#edit-uc-roles-default-length');
    _uc_role_expiration_disable_check('#edit-uc-roles-reminder-granularity', '#edit-uc-roles-reminder-length');
    uc_roles_expiration_default_override();
    expiration_switcher_default();
  }
);

// When you change the role expiration time select.
Drupal.behaviors.ucRoleExpirationTime = function(context) {
  $("#edit-expiration:not(.ucRoleExpirationTime-processed)", context).addClass('ucRoleExpirationTime-processed').change(
    function() {
      expiration_switcher();
    }
  );
}

// When you change the default role expiration time select.
Drupal.behaviors.ucRoleDefaultExpirationTimeDefault = function(context) {
  $("#edit-uc-roles-default-end-expiration:not(.ucRoleDefaultExpirationTimeDefault-processed)", context).addClass('ucRoleDefaultExpirationTimeDefault-processed').change(
    function() {
      expiration_switcher_default();
    }
  );
}

// When you change the role expiration time select.
Drupal.behaviors.ucRoleExpirationTimeDefault = function(context) {
  $("#edit-uc-roles-end-expiration:not(.ucRoleExpirationTimeDefault-processed)", context).addClass('ucRoleExpirationTimeDefault-processed').change(
    function() {
      expiration_switcher_default();
    }
  );
}

// When you change the role expiration granularity select.
Drupal.behaviors.ucRoleExpirationGranularity = function(context) {
  $('#edit-uc-roles-expire-relative-granularity:not(.ucRoleExpirationGranularity-processed)', context).addClass('ucRoleExpirationGranularity-processed').change(
    function() {
      _uc_role_expiration_disable_check('#edit-uc-roles-expire-relative-granularity', '#edit-uc-roles-expire-relative-duration');
    }
  );
}

// When you change the default role expiration granularity select.
Drupal.behaviors.ucRoleDefaultExpirationGranularity = function(context) {
  $('#edit-uc-roles-default-granularity:not(.ucRoleDefaultExpirationGranularity-processed)', context).addClass('ucRoleDefaultExpirationGranularity-processed').change(
    function() {
      _uc_role_expiration_disable_check('#edit-uc-roles-default-granularity', '#edit-uc-roles-default-length');
    }
  );
}

// When you change the default role expiration granularity select.
Drupal.behaviors.ucRoleReminderExpirationGranularity = function(context) {
  $('#edit-uc-roles-reminder-granularity:not(.ucRoleReminderExpirationGranularity-processed)', context).addClass('ucRoleReminderExpirationGranularity-processed').change(
    function() {
      _uc_role_expiration_disable_check('#edit-uc-roles-reminder-granularity', '#edit-uc-roles-reminder-length');
    }
  );
}

// When you change the default role expiration granularity select.
Drupal.behaviors.ucRoleExpirationEndOverride = function(context) {
  $('#edit-end-override:not(.ucRoleExpirationEndOverride-processed)', context).addClass('ucRoleExpirationEndOverride-processed').click(
    function() {
      uc_roles_expiration_default_override();
    }
  );
}

