
CREATE TABLE `Article` (
  `linkTitle` varchar(255) default NULL,
  `linkURL` text,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  `storageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Article` VALUES (NULL,NULL,'NK8bqlwVRILJknqeCDPBHg','PBtmpl0000000000000002',1147642515,3600,'0jTuDoyTcQK6ju8cs8a4ew'),(NULL,NULL,'bX5rYxb6tZ9docY6sUhBlw','PBtmpl0000000000000002',1147642514,3600,'r3QdZwvuVK9o9kLb7mpHGQ'),(NULL,NULL,'OhdaFLE7sXOzo_SIP2ZUgA','PBtmpl0000000000000002',1147642513,3600,'GY5wyiuNmZZyLdgFt3zluQ'),(NULL,NULL,'IWFxZDyGhQ3-SLZhELa3qw','PBtmpl0000000000000002',1147642514,3600,'BS9OtDY_8oUnmzStD-wPmg'),(NULL,NULL,'6QuS-0rosuZTdTv11fobig','PBtmpl0000000000000002',1147642515,3600,'qDIYM6Jcmkk_LmWZIqqJ7w'),(NULL,NULL,'FOvmwGC0GtZo5VTxJIL3OA','PBtmpl0000000000000002',1147642515,3600,'OV6RBBiB5cUE45pqGG05jw'),(NULL,NULL,'ix1p0AbwKAz8QWB-T-HHfg','PBtmpl0000000000000002',1147642516,3600,'gU8kZk0nV6SqcwKqSiojQQ'),(NULL,NULL,'iCYOjohB9SKvAPr6bXElKA','PBtmpl0000000000000002',1147642516,3600,'eTxnooflqjFWIwkyfE0nPQ'),(NULL,NULL,'4Yfz9hqBqM8OYMGuQK8oLw','PBtmpl0000000000000002',1147642516,3600,'x4_4U_yb-MAGELG0jxAqpQ'),(NULL,NULL,'Wl8WZ43g2rK5AYr9o4zY7w','PBtmpl0000000000000002',1147642516,3600,'QlXRvOaqkv9X2kY-eAQXKA'),(NULL,NULL,'LBuiKzg2mWwmOPS9AgV3bg','PBtmpl0000000000000002',1147642517,3600,'UYaT3bhIk9HXmX1io5MdlQ'),(NULL,NULL,'jTNggl7AoVSUc_ZzrvuCmw','PBtmpl0000000000000002',1147642517,3600,'NWhmkoojuu9dA4_zv3a4pg');
CREATE TABLE `Calendar` (
  `assetId` varchar(22) NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `defaultDate` enum('current','first','last') default 'current',
  `defaultView` enum('month','week','day') default 'month',
  `visitorCacheTimeout` int(11) unsigned default NULL,
  `templateIdMonth` varchar(22) default 'CalendarMonth000000001',
  `templateIdWeek` varchar(22) default 'CalendarWeek0000000001',
  `templateIdDay` varchar(22) default 'CalendarDay00000000001',
  `templateIdEvent` varchar(22) default 'CalendarEvent000000001',
  `templateIdEventEdit` varchar(22) default 'CalendarEventEdit00001',
  `templateIdSearch` varchar(22) default 'CalendarSearch00000001',
  `templateIdPrintMonth` varchar(22) default 'CalendarPrintMonth0001',
  `templateIdPrintWeek` varchar(22) default 'CalendarPrintWeek00001',
  `templateIdPrintDay` varchar(22) default 'CalendarPrintDay000001',
  `templateIdPrintEvent` varchar(22) default 'CalendarPrintEvent0001',
  `groupIdEventEdit` varchar(22) default '3',
  `groupIdSubscribed` varchar(22) default NULL,
  `subscriberNotifyOffset` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Calendar_feeds` (
  `feedId` varchar(22) NOT NULL,
  `assetId` varchar(22) NOT NULL,
  `url` varchar(255) NOT NULL,
  `lastUpdated` datetime default NULL,
  `lastResult` varchar(255) default NULL,
  `feedType` varchar(30) NOT NULL,
  PRIMARY KEY  (`feedId`,`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Collaboration` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `postGroupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `karmaPerPost` int(11) NOT NULL default '0',
  `collaborationTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `threadTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `postFormTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `searchTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `notificationTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `sortBy` varchar(35) NOT NULL default 'dateUpdated',
  `sortOrder` varchar(4) NOT NULL default 'desc',
  `usePreview` int(11) NOT NULL default '1',
  `addEditStampToPosts` int(11) NOT NULL default '0',
  `editTimeout` int(11) NOT NULL default '3600',
  `attachmentsPerPost` int(11) NOT NULL default '0',
  `filterCode` varchar(30) NOT NULL default 'javascript',
  `useContentFilter` int(11) NOT NULL default '1',
  `threads` int(11) NOT NULL default '0',
  `views` int(11) NOT NULL default '0',
  `replies` int(11) NOT NULL default '0',
  `rating` int(11) NOT NULL default '0',
  `lastPostId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `lastPostDate` bigint(20) default NULL,
  `archiveAfter` int(11) NOT NULL default '31536000',
  `postsPerPage` int(11) NOT NULL default '10',
  `threadsPerPage` int(11) NOT NULL default '30',
  `subscriptionGroupId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `allowReplies` int(11) NOT NULL default '0',
  `displayLastReply` int(11) NOT NULL default '0',
  `richEditor` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'PBrichedit000000000002',
  `karmaRatingMultiplier` int(11) NOT NULL default '0',
  `karmaSpentToRate` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `avatarsEnabled` int(11) NOT NULL default '0',
  `approvalWorkflow` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'pbworkflow000000000003',
  `defaultKarmaScale` int(11) NOT NULL default '1',
  `mailServer` varchar(255) default NULL,
  `mailAccount` varchar(255) default NULL,
  `mailPassword` varchar(255) default NULL,
  `mailAddress` varchar(255) default NULL,
  `mailPrefix` varchar(255) default NULL,
  `getMail` int(11) NOT NULL default '0',
  `getMailInterval` int(11) NOT NULL default '300',
  `getMailCronId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  `autoSubscribeToThread` int(11) NOT NULL default '1',
  `requireSubscriptionForEmailPosting` int(11) NOT NULL default '1',
  `thumbnailSize` int(11) NOT NULL default '0',
  `maxImageSize` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Collaboration` VALUES ('pbproto000000000000001','2',0,'PBtmpl0000000000000121','PBtmpl0000000000000067','PBtmpl0000000000000068','','','dateUpdated','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,31536000,10,30,NULL,0,0,'PBrichedit000000000002',0,0,1147642465,0,'pbworkflow000000000003',1,NULL,NULL,NULL,NULL,NULL,0,300,'CHO6iN9JKNtRBKnFDzO-mA',3600,1,1,0,0),('pbproto000000000000002','2',0,'PBtmpl0000000000000208','PBtmpl0000000000000209','PBtmpl0000000000000210','','','dateUpdated','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,2592000,10,30,NULL,1,0,'PBrichedit000000000002',0,0,1147642465,0,'pbworkflow000000000003',100,NULL,NULL,NULL,NULL,NULL,0,300,'NpRVTSR-NX2sD52LUc520A',3600,1,1,0,0),('pbproto000000000000001','2',0,'PBtmpl0000000000000121','PBtmpl0000000000000067','PBtmpl0000000000000068','','','dateUpdated','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,31536000,10,30,NULL,0,0,'PBrichedit000000000002',0,0,1163019036,0,'pbworkflow000000000003',1,NULL,NULL,NULL,NULL,NULL,0,300,'CHO6iN9JKNtRBKnFDzO-mA',3600,1,1,0,0),('pbproto000000000000002','2',0,'PBtmpl0000000000000208','PBtmpl0000000000000209','PBtmpl0000000000000210','','','dateUpdated','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,2592000,10,30,NULL,1,0,'PBrichedit000000000002',0,0,1163019036,0,'pbworkflow000000000003',100,NULL,NULL,NULL,NULL,NULL,0,300,'NpRVTSR-NX2sD52LUc520A',3600,1,1,0,0);
CREATE TABLE `Dashboard` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `adminsGroupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '4',
  `usersGroupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'DashboardViewTmpl00001',
  `isInitialized` tinyint(3) unsigned NOT NULL default '0',
  `assetsToHide` text,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `DataForm` (
  `acknowledgement` text,
  `mailData` int(11) NOT NULL default '1',
  `emailTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `acknowlegementTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `listTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `defaultView` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `groupToViewEntries` varchar(22) NOT NULL default '7',
  `mailAttachments` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `DataForm` VALUES ('Thank you for telling your friends about WebGUI!',1,'PBtmpl0000000000000085','PBtmpl0000000000000104','PBtmpl0000000000000021','Szs5eev3OMssmnsyLRZmWA','PBtmpl0000000000000020',0,1124395696,'7',0);
CREATE TABLE `DataForm_entry` (
  `DataForm_entryId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `username` varchar(255) default NULL,
  `ipAddress` varchar(255) default NULL,
  `submissionDate` bigint(20) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`DataForm_entryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `DataForm_entryData` (
  `DataForm_entryId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `DataForm_fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `value` text,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`DataForm_entryId`,`DataForm_fieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `DataForm_field` (
  `DataForm_fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `sequenceNumber` int(11) NOT NULL default '0',
  `name` varchar(255) NOT NULL default '',
  `status` varchar(35) default NULL,
  `type` varchar(30) NOT NULL default '',
  `possibleValues` text,
  `defaultValue` text,
  `width` int(11) default NULL,
  `subtext` mediumtext,
  `rows` int(11) default NULL,
  `isMailField` int(11) NOT NULL default '0',
  `label` varchar(255) default NULL,
  `DataForm_tabId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '0',
  `vertical` smallint(1) default '1',
  `extras` varchar(128) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`DataForm_fieldId`),
  KEY `assetId_tabId` (`assetId`,`DataForm_tabId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `DataForm_field` VALUES ('1000',1,'from','required','email','','',0,'',0,1,'Your Email Address','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1001',2,'to','required','email','','',0,'',0,1,'Your Friends Email Address','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1002',3,'cc','hidden','email',NULL,NULL,0,NULL,NULL,1,'Cc','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1003',4,'bcc','hidden','email',NULL,NULL,0,NULL,NULL,1,'Bcc','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1004',5,'subject','hidden','text','','Cool CMS',0,'',0,1,'Subject','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1005',6,'url','visible','url','','http://www.webgui.org',0,'',0,1,'URL','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA'),('1006',7,'message','required','textarea','','Hey I just wanted to tell you about this great program called WebGUI that I found: http://www.webgui.org\r\n\r\nYou should really check it out.',300,'',100,0,'Message','0',1,NULL,'Szs5eev3OMssmnsyLRZmWA');
CREATE TABLE `DataForm_tab` (
  `label` varchar(255) NOT NULL default '',
  `subtext` text,
  `sequenceNumber` int(11) NOT NULL default '0',
  `DataForm_tabId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Event` (
  `assetId` varchar(22) NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL,
  `feedId` varchar(22) default NULL,
  `feedUid` varchar(255) default NULL,
  `startDate` date default NULL,
  `endDate` date default NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `recurId` varchar(22) default NULL,
  `description` longtext,
  `startTime` time default NULL,
  `endTime` time default NULL,
  `relatedLinks` longtext,
  `location` varchar(255) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `displayTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `checkoutTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `managePurchasesTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `viewPurchaseTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `searchTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `paginateAfter` int(11) default '10',
  `groupToAddEvents` varchar(22) character set utf8 collate utf8_bin default NULL,
  `groupToApproveEvents` varchar(22) character set utf8 collate utf8_bin default NULL,
  `globalPrerequisites` tinyint(4) default '1',
  `globalMetadata` tinyint(4) default '1',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_badges` (
  `badgeId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `userId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `createdByUserId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `firstName` varchar(100) default NULL,
  `lastName` varchar(100) default NULL,
  `address` varchar(100) default NULL,
  `city` varchar(100) default NULL,
  `state` varchar(50) default NULL,
  `zipCode` varchar(15) default NULL,
  `country` varchar(255) default NULL,
  `phone` varchar(50) default NULL,
  `email` varchar(255) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`badgeId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_discountPasses` (
  `passId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(100) default NULL,
  `amount` varchar(22) default NULL,
  `type` varchar(10) default NULL,
  PRIMARY KEY  (`passId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_metaData` (
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `productId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `fieldData` text,
  PRIMARY KEY  (`fieldId`,`productId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_metaField` (
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `name` varchar(50) default NULL,
  `label` varchar(100) default NULL,
  `dataType` varchar(20) default NULL,
  `visible` tinyint(4) default '0',
  `required` tinyint(4) default '0',
  `possibleValues` text,
  `defaultValues` text,
  `sequenceNumber` int(5) default NULL,
  `autoSearch` tinyint(4) default '0',
  PRIMARY KEY  (`fieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_prerequisiteEvents` (
  `prerequisiteId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `requiredProductId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`prerequisiteId`,`requiredProductId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_prerequisites` (
  `prerequisiteId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `operator` varchar(100) default NULL,
  `name` varchar(40) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`prerequisiteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_products` (
  `productId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `startDate` bigint(20) default NULL,
  `endDate` bigint(20) default NULL,
  `maximumAttendees` int(11) default NULL,
  `approved` tinyint(4) default NULL,
  `sequenceNumber` int(11) default NULL,
  `imageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `prerequisiteId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `passId` text,
  `passType` varchar(10) default NULL,
  PRIMARY KEY  (`productId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_purchases` (
  `purchaseId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `transactionId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`purchaseId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_registrations` (
  `registrationId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `productId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `purchaseId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `badgeId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `returned` tinyint(4) default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`registrationId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `EventManagementSystem_sessionPurchaseRef` (
  `sessionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `purchaseId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `badgeId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`sessionId`,`purchaseId`,`badgeId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Event_recur` (
  `recurId` varchar(22) NOT NULL,
  `recurType` varchar(16) default NULL,
  `pattern` varchar(255) default NULL,
  `startDate` date default NULL,
  `endDate` varchar(10) default NULL,
  PRIMARY KEY  (`recurId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `FileAsset` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `storageId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `FileAsset` VALUES ('7.0-style0000000000002','_Vo1Pvl3sPPANyxz-IcCtA','body_bg.jpg','PBtmpl0000000000000088',1147642492,3600),('7.0-style0000000000004','Gemp7cEVjh2_M2IicUYs-g','gui_bottom.jpg','PBtmpl0000000000000088',1147642493,3600),('7.0-style0000000000005','ry-yzLVH-vxn71H9byjGXA','header.jpg','PBtmpl0000000000000088',1147642493,3600),('7.0-style0000000000006','VEPa65fhY3dok6vj-beFCA','main_bg.gif','PBtmpl0000000000000088',1147642493,3600),('7.0-style0000000000007','cFay1MNkC-73WKJ7fX_pVw','main_bg.jpg','PBtmpl0000000000000088',1147642493,3600),('7.0-style0000000000008','iEBE--vQb_lxuZd5AP8tuw','nav1_center_on.jpg','PBtmpl0000000000000088',1147642494,3600),('7.0-style0000000000009','XR1Yjf3MkYA53TJlcpRBsw','nav1_off.jpg','PBtmpl0000000000000088',1147642494,3600),('7.0-style0000000000010','sxvAS8na-QAdY_eycd2gKw','nav1_off_center.jpg','PBtmpl0000000000000088',1147642494,3600),('7.0-style0000000000011','2lhmrXW46ZMLvpbaaX2g7Q','nav1_off_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7.0-style0000000000012','sEoRwhmonl877RBgx2nE1w','nav1_off_right.jpg','PBtmpl0000000000000088',1147642495,3600),('7.0-style0000000000013','AoSfRkPI3fl7vAooT4Fj_A','nav1_on.jpg','PBtmpl0000000000000088',1147642495,3600),('7.0-style0000000000014','MgNDJRsghd_zQZ292hqVMQ','nav1_on_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7.0-style0000000000015','aUG1FZaIqHaQHlieZ4_Mkg','nav1_on_right.jpg','PBtmpl0000000000000088',1147642496,3600),('7.0-style0000000000016','HyhLnkaJMfr8eJsLIX8XeA','nav2_center_on.jpg','PBtmpl0000000000000088',1147642496,3600),('7.0-style0000000000017','aledEnWoD-JVNURWSklfdg','nav2_off_center.jpg','PBtmpl0000000000000088',1147642496,3600),('7.0-style0000000000018','Ffd33PToWon9X7mcKZqUAQ','nav2_off_left.jpg','PBtmpl0000000000000088',1147642496,3600),('7.0-style0000000000019','B3TTkcOlr-VzcxRwQXZmyg','nav2_off_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7.0-style0000000000020','RxGSyn-8W4p64SQ-NYzNOg','nav2_on_left.jpg','PBtmpl0000000000000088',1147642497,3600),('7.0-style0000000000021','NciEByP8ssN6qDYyKcoGWw','nav2_on_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7.0-style0000000000022','9OVg_Nxo0gha5pWZsS_dmw','nav_bg.jpg','PBtmpl0000000000000088',1147642497,3600),('7.0-style0000000000023','VKtJGCmBtsMj8ZeAJ6ePNw','nav_on.jpg','PBtmpl0000000000000088',1147642498,3600),('7.0-style0000000000024','RYQb0A4YeEwYZo9hdgrCcw','orange_left01.jpg','PBtmpl0000000000000088',1147642498,3600),('7.0-style0000000000030','coew3C1i9AORof9ezjWLDg','webgui_btn.jpg','PBtmpl0000000000000088',1147642499,3600),('7.0-style0000000000032','HEySmh0CRxpkI-tjzgkDDw','context_bg.jpg','PBtmpl0000000000000088',1147642500,3600),('7.0-style0000000000034','HPn3mVDaMkn8Iu0GAq7cAw','leftCol_header.jpg','PBtmpl0000000000000088',1147642500,3600),('7.0-style0000000000035','IqaSdxJqqN_8C-7OWeyE2g','leftCol_header02.jpg','PBtmpl0000000000000088',1147642501,3600),('7.0-style0000000000036','M0cIcS1GDFIV8lwAw3U2hA','main_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7.0-style0000000000037','77rakTqCXGBihEOXoh4ZXQ','nav_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7.0-style0000000000038','5najYvfJiZBBaiCVxaNkcQ','navbar_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7.0-style0000000000039','27XAOBKNfJ2euexImD73Aw','navbar_left.jpg','PBtmpl0000000000000088',1147642502,3600),('7.0-style0000000000040','sgd1YdmVKj-n6IyIWJicXg','navbar_right.jpg','PBtmpl0000000000000088',1147642502,3600),('7.0-style0000000000041','i1oJph6lb3hxEsTNu_3Y7g','page_title.jpg','PBtmpl0000000000000088',1147642502,3600),('7.0-style0000000000042','qMwO_tp9KOya_N-kyIHDJQ','page_title_bg.jpg','PBtmpl0000000000000088',1147642502,3600),('7.0-style0000000000043','l5hF84u5R9MoqMvS9gpp6g','pb.jpg','PBtmpl0000000000000088',1147642503,3600),('7.0-style0000000000044','Eh4IRmClOEzDAU1IVn5vHQ','pb_wg.jpg','PBtmpl0000000000000088',1147642503,3600),('7.0-style0000000000045','e8yirsGt9FZEgzfeHLgRiw','pb_wg_bg.jpg','PBtmpl0000000000000088',1147642503,3600),('7.0-style0000000000046','hDmN6gu1w_jtrcxgTRN5OQ','rightCol_bg.jpg','PBtmpl0000000000000088',1147642504,3600),('7.0-style0000000000048','_QhSdbnBeA1zio6iAuGIag','wg.jpg','PBtmpl0000000000000088',1147642504,3600),('7.0-style0000000000052','VRqMCZ_-GgaJiDeOrnwlQg','footer_bg.jpg','PBtmpl0000000000000088',1147642505,3600),('7.0-style0000000000053','baxoDEB4C8eLjZbnENMs9w','footer_right.jpg','PBtmpl0000000000000088',1147642505,3600),('7.0-style0000000000054','FlivcrAW0pKW4q_2fvlVpw','header_bg.jpg','PBtmpl0000000000000088',1147642506,3600),('7.0-style0000000000055','5hgdAMRWeSmHDrRFM_qbBw','header_left.jpg','PBtmpl0000000000000088',1147642506,3600),('7.0-style0000000000056','lV6l3Sctxx8J1JmYlXwSDA','header_right.jpg','PBtmpl0000000000000088',1147642506,3600),('7.0-style0000000000057','FKGH2yiNQoC2E_FqbMYebw','main_bg.jpg','PBtmpl0000000000000088',1147642507,3600),('7.0-style0000000000058','UGtgwjDaqCtCPnEkuLPtIw','main_bottom.jpg','PBtmpl0000000000000088',1147642507,3600),('7.0-style0000000000059','CfZRQkCVyLWzRzd0LrK90w','main_top.jpg','PBtmpl0000000000000088',1147642507,3600),('7.0-style0000000000060','XsuCCMz5vyyfC8Xr89pb1Q','main_top_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7.0-style0000000000061','is_6p2ROuy6AhCR1eJ8SdQ','nav_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7.0-style0000000000062','3rpFbJWSV14AWeDZqqPSSw','nav_bg1.jpg','PBtmpl0000000000000088',1147642508,3600),('7.0-style0000000000063','NCTFm_t9rn63ejwtBQnDQw','nav_bg1_on.jpg','PBtmpl0000000000000088',1147642508,3600),('7.0-style0000000000064','XLKBWi6Asbz5CtZdnwzZmg','nav_bg2.jpg','PBtmpl0000000000000088',1147642509,3600),('7.0-style0000000000065','02cdKPH5-SyFEb_Zo_WL8A','nav_bg2_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7.0-style0000000000066','0QQpTB8bi6JZvFrW74SOWg','nav_bg_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7.0-style0000000000067','DdhQHfqGq-yC1ukTdlqoEg','pb.jpg','PBtmpl0000000000000088',1147642509,3600),('7.0-style0000000000068','Y4AWquISZVLcwVQLzd_u7w','spacer.gif','PBtmpl0000000000000088',1147642510,3600),('7.0-style0000000000071','mJOrQFemh2R3xn2HYviQlQ','wg.jpg','PBtmpl0000000000000088',1147642511,3600),('m4YJFaqzultnB_sj1Uq0aw','JX9y6tHiSaAv3-Jq6QXHGw','advert01.swf','pbtmpl0000000000000220',1147642514,3600),('Vzv1pWpg_w6R_o-b0rM2qQ','PMKX5QYkNFvrCD15QVo8Tg','Tutorial.swf','pbtmpl0000000000000221',1147642515,3600);
CREATE TABLE `Folder` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  `sortAlphabetically` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Folder` VALUES ('PBasset000000000000002','PBtmpl0000000000000078',1124395696,3600,0),('7.0-style0000000000001','PBtmpl0000000000000078',1147642492,3600,0),('7.0-style0000000000031','PBtmpl0000000000000078',1147642500,3600,0),('7.0-style0000000000049','PBtmpl0000000000000078',1147642504,3600,0),('PBasset000000000000003','PBtmpl0000000000000078',1147642437,3600,0),('nbSrhXZQuxIjhWFaFPSuVA','PBtmpl0000000000000078',1147642465,3600,0),('TvOZs8U1kRXLtwtmyW75pg','PBtmpl0000000000000078',1147642465,3600,0),('xSmREZO3GNzK3M5PaueOOQ','PBtmpl0000000000000078',1147642466,3600,0),('0bx-xoL8TSXXubFuqKAoVQ','PBtmpl0000000000000078',1147642466,3600,0),('taX2UYkFF21ALpFZY2rhMw','PBtmpl0000000000000078',1147642466,3600,0),('K0q_N885Httqev1VCqUWxg','PBtmpl0000000000000078',1147642466,3600,0),('fq1ZkYhH24R5tb96kuT10Q','PBtmpl0000000000000078',1147642466,3600,0),('oHk7fAFhEEkB7dHzi0QOQA','PBtmpl0000000000000078',1147642466,3600,0),('9M-lrlPQWeeNWfvnDnK_Xg','PBtmpl0000000000000078',1147642466,3600,0),('_gBYAdTcbkiyamnqi2Xskg','PBtmpl0000000000000078',1147642466,3600,0),('GNOAsX98vCsl0JRwfwL-gg','PBtmpl0000000000000078',1147642466,3600,0),('S1A9iAwKcQQ6P20uTqw-Ew','PBtmpl0000000000000078',1147642468,3600,0),('-K8Hj45mbelljN9-0CXZxg','PBtmpl0000000000000078',1147642468,3600,0),('lK9-YMfZ4mpc-Me-UydrFg','PBtmpl0000000000000078',1147642468,3600,0),('j3P_Vvsy0OtvUJZRXC55Nw','PBtmpl0000000000000078',1147642469,3600,0),('XP2W66c8vtDVpxN50Fiwww','PBtmpl0000000000000078',1147642469,3600,0),('JJ-SZb9z2l_N46A0AWW7KA','PBtmpl0000000000000078',1147642469,3600,0),('Cn2TOyQH3qqnQrWDrsGrxg','PBtmpl0000000000000078',1147642469,3600,0),('tXwf1zaOXTvsqPn6yu-GSw','PBtmpl0000000000000078',1147642469,3600,0),('GYaFxnMu9UsEG8oanwB6TA','PBtmpl0000000000000078',1147642470,3600,0),('N13SD1Fpqk00UgBt1Z8ivQ','PBtmpl0000000000000078',1147642470,3600,0),('tPagC0AQErZXjLFZQ6OI1g','PBtmpl0000000000000078',1147642470,3600,0),('VXSsbsfcfht1904EWkb1sw','PBtmpl0000000000000078',1147642470,3600,0),('AFdXZZmGnSKalNSobQMB5w','PBtmpl0000000000000078',1147642470,3600,0),('3uuBf8cYuj1sew2OJXl9tg','PBtmpl0000000000000078',1147642470,3600,0),('aNNC62qLAS6TB-0_MCYjsw','PBtmpl0000000000000078',1147642471,3600,0),('Ov2ssJHwp_1eEWKlDyUKmg','PBtmpl0000000000000078',1147642471,3600,0),('tBL7BWiQRZFed2Y-Zjo9tQ','PBtmpl0000000000000078',1147642471,3600,0),('GdkQpvjRtJqtzOUbwIIQRA','PBtmpl0000000000000078',1147642471,3600,0),('tnc5iYyynX2hfdEs9D3P8w','PBtmpl0000000000000078',1147642472,3600,0),('vgXdBcFTqU7h4wBG1ewdBw','PBtmpl0000000000000078',1147642472,3600,0),('hcFlqnXlsmC1ujN6Id0F0A','PBtmpl0000000000000078',1147642473,3600,0),('eRJR52fvlaxfetv3DQkQYw','PBtmpl0000000000000078',1147642473,3600,0),('5HIDHq5lAWHV5gpYGS0zLg','PBtmpl0000000000000078',1147642473,3600,0),('rYEFwXXo0tkGhQTcbDibvg','PBtmpl0000000000000078',1147642473,3600,0),('V3l5S5TtI7wMm1WpIMhvOA','PBtmpl0000000000000078',1147642473,3600,0),('nqNbSUAhk9Vd1zda2SCz9A','PBtmpl0000000000000078',1147642474,3600,0),('y8XkRdxIperLKkJ3bL5sSQ','PBtmpl0000000000000078',1147642474,3600,0),('e-WvgcKROPCoHwiiHLktCg','PBtmpl0000000000000078',1147642474,3600,0),('LdiozcIUciWuvt3Z-na5Ww','PBtmpl0000000000000078',1147642474,3600,0),('cj2y4papTVGZRFdwTI-_fw','PBtmpl0000000000000078',1147642475,3600,0),('bBzO4CWjqU_ile3gf5Iypw','PBtmpl0000000000000078',1147642475,3600,0),('BFfNj5wA9bDw8H3cnr8pTw','PBtmpl0000000000000078',1147642475,3600,0),('AgyFhx3eXlfZXNp2MkrsiQ','PBtmpl0000000000000078',1147642477,3600,0),('F7MAQ-cpuvQ1KuC7J4P5zQ','PBtmpl0000000000000078',1147642477,3600,0),('jEz8iTGNWEt2I05IhVV19Q','PBtmpl0000000000000078',1147642477,3600,0),('VZK3CRgiMb8r4dBjUmCTgQ','PBtmpl0000000000000078',1147642477,3600,0),('TYo2Bwl7aafzTtdHlS-arQ','PBtmpl0000000000000078',1147642478,3600,0),('9A-mg2gwWmaYi9o_1C7ArQ','PBtmpl0000000000000078',1147642478,3600,0),('yD1SMHelczihzjEmx6eXBA','PBtmpl0000000000000078',1147642478,3600,0),('pV7GnZdpjR3XpZaSINIoeg','PBtmpl0000000000000078',1147642478,3600,0),('71e17KeduiXgODLMlUxiow','PBtmpl0000000000000078',1147642479,3600,0),('Ik9HHky10DIyFTKehUD1dw','PBtmpl0000000000000078',1147642479,3600,0),('f_tn9FfoSfKWX43F83v_3w','PBtmpl0000000000000078',1147642479,3600,0),('Da6KWn805L4B5e4HFgQRQA','PBtmpl0000000000000078',1147642479,3600,0),('GnrXtoFFeXia3vDQuSHojw','PBtmpl0000000000000078',1147642479,3600,0),('k8vxD4fuKKf5cGwNTw0sLw','PBtmpl0000000000000078',1147642480,3600,0),('bbiA9Zq5Gy2oCFBlILO3QA','PBtmpl0000000000000078',1147642480,3600,0),('Efe2W0UgrSRDltNJ87jlfg','PBtmpl0000000000000078',1147642480,3600,0),('RrV4aAPnn4dM0ZcU3OXnlw','PBtmpl0000000000000078',1147642480,3600,0),('5bnNzteN7w3NnK9mF4XiCg','PBtmpl0000000000000078',1147642481,3600,0),('oGfxez5sksyB_PcaAsEm_Q','PBtmpl0000000000000078',1147642482,3600,0),('vTymIDYL2YqEh6PV50F7ew','PBtmpl0000000000000078',1147642482,3600,0),('lo1ac3BsoJx3ijGQ3gR-bQ','PBtmpl0000000000000078',1147642482,3600,0),('huASapWvFDzqwOSbcN-JFQ','PBtmpl0000000000000078',1147642483,3600,0),('9wKWdum0_8z-OhhquWLtSQ','PBtmpl0000000000000078',1147642483,3600,0),('5YAbuwiVFUx-z8hcOAnsdQ','PBtmpl0000000000000078',1147642483,3600,0),('CSN-ZON7Uwv8kxf3F1fh5Q','PBtmpl0000000000000078',1147642484,3600,0),('NYr6iP4pQaPRYqEYMryv4w','PBtmpl0000000000000078',1147642484,3600,0),('TCtybxdqmdwdvRn555zpCQ','PBtmpl0000000000000078',1147642484,3600,0),('sMuqO3Ynl6Lyn5fa2SsGmQ','',1147962058,3600,0),('ImvgaAritVaOLmogG8fCJQ','',1148579524,3600,0),('kDuc6TCa6cWZ_jdrIMFKRg','',1154535074,3600,0),('BmLaN4rmAANkCglXUViEbg','',1157679165,3600,0),('Q4uX_C557arTp6D_jwB1jQ','',1165460175,3600,0),('u2mB-2nJbDsfBinXJyjAcQ','',1166718668,3600,0),('0Q41OuxKgi0aAJd4Xbas2Q','',1171466654,3600,0);
CREATE TABLE `HttpProxy` (
  `proxiedUrl` text,
  `timeout` int(11) default NULL,
  `removeStyle` int(11) default NULL,
  `filterHtml` varchar(30) default NULL,
  `followExternal` int(11) default NULL,
  `followRedirect` int(11) default NULL,
  `cacheHttp` int(11) default '0',
  `useCache` int(11) default '0',
  `debug` int(11) default '0',
  `rewriteUrls` int(11) default NULL,
  `searchFor` varchar(255) default NULL,
  `stopAt` varchar(255) default NULL,
  `cookieJarStorageId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '0',
  `useAmpersand` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `ITransact_recurringStatus` (
  `gatewayId` varchar(128) NOT NULL default '',
  `initDate` bigint(20) NOT NULL default '0',
  `lastTransaction` bigint(20) NOT NULL default '0',
  `status` varchar(10) NOT NULL default '',
  `errorMessage` varchar(128) default NULL,
  `recipe` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`gatewayId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `ImageAsset` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `thumbnailSize` int(11) NOT NULL default '50',
  `parameters` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `ImageAsset` VALUES ('7.0-style0000000000002',50,NULL,1147642492),('7.0-style0000000000004',50,NULL,1147642493),('7.0-style0000000000005',50,NULL,1147642493),('7.0-style0000000000006',50,NULL,1147642493),('7.0-style0000000000007',50,NULL,1147642493),('7.0-style0000000000008',50,NULL,1147642494),('7.0-style0000000000009',50,NULL,1147642494),('7.0-style0000000000010',50,NULL,1147642494),('7.0-style0000000000011',50,NULL,1147642495),('7.0-style0000000000012',50,NULL,1147642495),('7.0-style0000000000013',50,NULL,1147642495),('7.0-style0000000000014',50,NULL,1147642495),('7.0-style0000000000015',50,NULL,1147642496),('7.0-style0000000000016',50,NULL,1147642496),('7.0-style0000000000017',50,NULL,1147642496),('7.0-style0000000000018',50,NULL,1147642496),('7.0-style0000000000019',50,NULL,1147642497),('7.0-style0000000000020',50,NULL,1147642497),('7.0-style0000000000021',50,NULL,1147642497),('7.0-style0000000000022',50,NULL,1147642497),('7.0-style0000000000023',50,NULL,1147642498),('7.0-style0000000000024',50,NULL,1147642498),('7.0-style0000000000030',50,NULL,1147642499),('7.0-style0000000000032',50,NULL,1147642500),('7.0-style0000000000034',50,NULL,1147642500),('7.0-style0000000000035',50,NULL,1147642501),('7.0-style0000000000036',50,NULL,1147642501),('7.0-style0000000000037',50,NULL,1147642501),('7.0-style0000000000038',50,NULL,1147642501),('7.0-style0000000000039',50,NULL,1147642502),('7.0-style0000000000040',50,NULL,1147642502),('7.0-style0000000000041',50,NULL,1147642502),('7.0-style0000000000042',50,NULL,1147642502),('7.0-style0000000000043',50,NULL,1147642503),('7.0-style0000000000044',50,NULL,1147642503),('7.0-style0000000000045',50,NULL,1147642503),('7.0-style0000000000046',50,NULL,1147642504),('7.0-style0000000000048',50,NULL,1147642504),('7.0-style0000000000052',50,NULL,1147642505),('7.0-style0000000000053',50,NULL,1147642505),('7.0-style0000000000054',50,NULL,1147642506),('7.0-style0000000000055',50,NULL,1147642506),('7.0-style0000000000056',50,NULL,1147642506),('7.0-style0000000000057',50,NULL,1147642507),('7.0-style0000000000058',50,NULL,1147642507),('7.0-style0000000000059',50,'alt=\"main_top.jpg\"',1147642507),('7.0-style0000000000060',50,NULL,1147642508),('7.0-style0000000000061',50,NULL,1147642508),('7.0-style0000000000062',50,NULL,1147642508),('7.0-style0000000000063',50,NULL,1147642508),('7.0-style0000000000064',50,NULL,1147642509),('7.0-style0000000000065',50,NULL,1147642509),('7.0-style0000000000066',50,NULL,1147642509),('7.0-style0000000000067',50,NULL,1147642509),('7.0-style0000000000068',50,NULL,1147642510),('7.0-style0000000000071',50,NULL,1147642511);
CREATE TABLE `InOutBoard` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `statusList` text,
  `reportViewerGroup` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `inOutGroup` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `inOutTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'IOB0000000000000000001',
  `reportTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'IOB0000000000000000002',
  `paginateAfter` int(11) NOT NULL default '50',
  `reportPaginateAfter` int(11) NOT NULL default '50',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `InOutBoard_delegates` (
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `delegateUserId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `InOutBoard_status` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `status` varchar(255) default NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `InOutBoard_statusLog` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `status` varchar(255) default NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text,
  `createdBy` varchar(22) character set utf8 collate utf8_bin default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Layout` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `contentPositions` text,
  `assetsToHide` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Layout` VALUES ('68sKwDgf9cGH58-NZcU4lg','PBtmpl0000000000000054','TKzUMeIxRLrZ3NAEez6CXQ,sWVXMZGibxHe2Ekj1DCldA',NULL,1124395696),('_iHetEvMQUOoxS-T2CM0sQ','PBtmpl0000000000000054','x_WjMvFmilhX-jvZuIpinw',NULL,1124395696),('8Bb8gu-me2mhL3ljFyiWLg','PBtmpl0000000000000094','6QuS-0rosuZTdTv11fobig.FOvmwGC0GtZo5VTxJIL3OA,ix1p0AbwKAz8QWB-T-HHfg,iCYOjohB9SKvAPr6bXElKA.4Yfz9hqBqM8OYMGuQK8oLw,Wl8WZ43g2rK5AYr9o4zY7w,LBuiKzg2mWwmOPS9AgV3bg,jTNggl7AoVSUc_ZzrvuCmw.',NULL,1124395696),('2TqQc4OISddWCZmRY1_m8A','PBtmpl0000000000000054','fK-HMSboA3uu0c1KYkYspA',NULL,1124395696),('Swf6L8poXKc7hUaNPkBevw','PBtmpl0000000000000054','Szs5eev3OMssmnsyLRZmWA',NULL,1124395696),('x3OFY6OJh_qsXkZfPwug4A','PBtmpl0000000000000054','pJd5TLAjfWMVXD6sCRLwUg',NULL,1124395696);
CREATE TABLE `Matrix` (
  `detailTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `compareTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `searchTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `ratingDetailTemplateId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `categories` text,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `maxComparisons` int(11) NOT NULL default '10',
  `maxComparisonsPrivileged` int(11) NOT NULL default '10',
  `privilegedGroup` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `groupToRate` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `ratingTimeout` int(11) NOT NULL default '31536000',
  `ratingTimeoutPrivileged` int(11) NOT NULL default '31536000',
  `groupToAdd` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Matrix_field` (
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `category` varchar(255) NOT NULL default '',
  `name` varchar(255) default NULL,
  `label` varchar(255) default NULL,
  `description` text,
  `fieldType` varchar(35) default NULL,
  `defaultValue` varchar(255) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`fieldId`),
  KEY `categoryIndex` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Matrix_listing` (
  `listingId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `maintainerId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `forumId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `productName` varchar(255) default NULL,
  `productUrl` text,
  `manufacturerName` varchar(255) default NULL,
  `manufacturerUrl` text,
  `description` text,
  `lastUpdated` int(11) default NULL,
  `versionNumber` varchar(30) default NULL,
  `views` int(11) NOT NULL default '0',
  `compares` int(11) NOT NULL default '0',
  `clicks` int(11) NOT NULL default '0',
  `status` varchar(30) NOT NULL default 'pending',
  `clicksLastIp` varchar(16) default NULL,
  `viewsLastIp` varchar(16) default NULL,
  `comparesLastIp` varchar(16) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `approvalMessageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `storageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `filename` varchar(255) default NULL,
  PRIMARY KEY  (`listingId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Matrix_listingData` (
  `listingId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `value` varchar(255) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`listingId`,`fieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Matrix_rating` (
  `timeStamp` int(11) NOT NULL default '0',
  `category` varchar(255) default NULL,
  `rating` int(11) NOT NULL default '1',
  `listingId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ipAddress` varchar(15) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Matrix_ratingSummary` (
  `listingId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `category` varchar(255) NOT NULL default '',
  `meanValue` decimal(3,2) default NULL,
  `medianValue` int(11) default NULL,
  `countValue` int(11) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`listingId`,`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `MessageBoard` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `MultiSearch` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'MultiSearchTmpl0000001',
  `predefinedSearches` text,
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Navigation` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetsToInclude` text,
  `startType` varchar(35) default NULL,
  `startPoint` varchar(255) default NULL,
  `descendantEndPoint` int(11) NOT NULL default '55',
  `showSystemPages` int(11) NOT NULL default '0',
  `showHiddenPages` int(11) NOT NULL default '0',
  `showUnprivilegedPages` int(11) NOT NULL default '0',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ancestorEndPoint` int(11) NOT NULL default '55',
  `revisionDate` bigint(20) NOT NULL default '0',
  `mimeType` varchar(50) default 'text/html',
  `reversePageLoop` tinyint(1) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Navigation` VALUES ('pJd5TLAjfWMVXD6sCRLwUg','descendants','specificUrl','root',55,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000001','self\nancestors','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000093',55,1124395696,'text/html',0),('PBnav00000000000000014','pedigree','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000015','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000016','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000017','self\nsiblings','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000018','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000019','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000020','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000021','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000002','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000006','descendants','specificUrl','home',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000007','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000008','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000009','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000124',55,1124395696,'text/html',0),('PBnav00000000000000010',NULL,'relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000011','self\ndescendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000130',55,1124395696,'text/html',0),('PBnav00000000000000012','descendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000134',55,1124395696,'text/html',0),('PBnav00000000000000013','self\ndescendants','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000136',55,1124395696,'text/html',0),('7.0-style0000000000025','descendants','relativeToRoot','1',1,0,0,0,'stevenav00000000000001',55,1147642498,'text/html',0),('7.0-style0000000000026','descendants','relativeToRoot','2',1,0,0,0,'PBnav000000style01lvl2',55,1147642499,'text/html',0),('7.0-style0000000000070','descendants','relativeToRoot','1',55,0,0,0,'stevecoolmenu000000001',55,1147642510,'text/html',0);
CREATE TABLE `PM_project` (
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `name` varchar(255) NOT NULL,
  `description` text,
  `startDate` bigint(20) default NULL,
  `endDate` bigint(20) default NULL,
  `projectManager` varchar(22) character set utf8 collate utf8_bin default NULL,
  `durationUnits` enum('hours','days') default 'hours',
  `hoursPerDay` float default NULL,
  `targetBudget` float(15,2) default '0.00',
  `percentComplete` float NOT NULL default '0',
  `parentId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdatedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `projectObserver` varchar(22) character set utf8 collate utf8_bin default '7',
  PRIMARY KEY  (`projectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `PM_task` (
  `taskId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `taskName` varchar(255) NOT NULL,
  `duration` bigint(20) default '0',
  `startDate` bigint(20) default NULL,
  `endDate` bigint(20) default NULL,
  `dependants` varchar(50) default NULL,
  `parentId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `percentComplete` float default NULL,
  `sequenceNumber` int(11) NOT NULL default '1',
  `creationDate` bigint(20) NOT NULL,
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdatedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `lagTime` bigint(20) default '0',
  `taskType` enum('timed','progressive','milestone') NOT NULL default 'timed',
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `PM_taskResource` (
  `taskResourceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `taskId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `resourceKind` enum('user','group') NOT NULL,
  `resourceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`taskResourceId`),
  UNIQUE KEY `taskId` (`taskId`,`resourceKind`,`resourceId`),
  UNIQUE KEY `taskId_2` (`taskId`,`sequenceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `PM_wobject` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `projectDashboardTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0001',
  `projectDisplayTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0002',
  `ganttChartTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0003',
  `editTaskTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0004',
  `groupToAdd` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `revisionDate` bigint(20) NOT NULL,
  `resourcePopupTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0005',
  `resourceListTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'ProjectManagerTMPL0006',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Poll` (
  `active` int(11) NOT NULL default '1',
  `graphWidth` int(11) NOT NULL default '150',
  `voteGroup` varchar(22) default NULL,
  `question` varchar(255) default NULL,
  `a1` varchar(255) default NULL,
  `a2` varchar(255) default NULL,
  `a3` varchar(255) default NULL,
  `a4` varchar(255) default NULL,
  `a5` varchar(255) default NULL,
  `a6` varchar(255) default NULL,
  `a7` varchar(255) default NULL,
  `a8` varchar(255) default NULL,
  `a9` varchar(255) default NULL,
  `a10` varchar(255) default NULL,
  `a11` varchar(255) default NULL,
  `a12` varchar(255) default NULL,
  `a13` varchar(255) default NULL,
  `a14` varchar(255) default NULL,
  `a15` varchar(255) default NULL,
  `a16` varchar(255) default NULL,
  `a17` varchar(255) default NULL,
  `a18` varchar(255) default NULL,
  `a19` varchar(255) default NULL,
  `a20` varchar(255) default NULL,
  `karmaPerVote` int(11) NOT NULL default '0',
  `randomizeAnswers` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `graphConfiguration` blob,
  `generateGraph` tinyint(1) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Poll_answer` (
  `answer` char(3) default NULL,
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ipAddress` varchar(50) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Post` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `threadId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `dateSubmitted` bigint(20) default NULL,
  `dateUpdated` bigint(20) default NULL,
  `username` varchar(30) default NULL,
  `content` mediumtext,
  `views` int(11) NOT NULL default '0',
  `contentType` varchar(35) NOT NULL default 'mixed',
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `storageId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `rating` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `originalEmail` mediumtext,
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `threadId_rating` (`threadId`,`rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Post_rating` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ipAddress` varchar(15) NOT NULL default '',
  `dateOfRating` bigint(20) default NULL,
  `rating` int(11) NOT NULL default '0',
  KEY `assetId_userId` (`assetId`,`userId`),
  KEY `assetId_ipAddress` (`assetId`,`ipAddress`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product` (
  `image1` varchar(255) default NULL,
  `image2` varchar(255) default NULL,
  `image3` varchar(255) default NULL,
  `brochure` varchar(255) default NULL,
  `manual` varchar(255) default NULL,
  `warranty` varchar(255) default NULL,
  `price` varchar(255) default NULL,
  `productNumber` varchar(255) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product_accessory` (
  `sequenceNumber` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `accessoryAssetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`assetId`,`accessoryAssetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product_benefit` (
  `Product_benefitId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `benefit` varchar(255) default NULL,
  `sequenceNumber` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`Product_benefitId`),
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product_feature` (
  `Product_featureId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `feature` varchar(255) default NULL,
  `sequenceNumber` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`Product_featureId`),
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product_related` (
  `sequenceNumber` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `relatedAssetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`assetId`,`relatedAssetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Product_specification` (
  `Product_specificationId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `name` varchar(255) default NULL,
  `value` varchar(255) default NULL,
  `units` varchar(255) default NULL,
  `sequenceNumber` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`Product_specificationId`),
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `RSSCapable` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `rssCapableRssEnabled` int(11) NOT NULL default '1',
  `rssCapableRssTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'PBtmpl0000000000000142',
  `rssCapableRssFromParentId` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `RSSCapable` VALUES ('pbproto000000000000001',1147642465,0,'PBtmpl0000000000000142',NULL),('pbproto000000000000002',1147642465,0,'PBtmpl0000000000000142',NULL),('pbproto000000000000001',1163019036,0,'PBtmpl0000000000000142',NULL),('pbproto000000000000002',1163019036,0,'PBtmpl0000000000000142',NULL);
CREATE TABLE `RSSFromParent` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `RichEdit` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `askAboutRichEdit` int(11) NOT NULL default '0',
  `preformatted` int(11) NOT NULL default '0',
  `editorWidth` int(11) NOT NULL default '0',
  `editorHeight` int(11) NOT NULL default '0',
  `sourceEditorWidth` int(11) NOT NULL default '0',
  `sourceEditorHeight` int(11) NOT NULL default '0',
  `useBr` int(11) NOT NULL default '0',
  `nowrap` int(11) NOT NULL default '0',
  `removeLineBreaks` int(11) NOT NULL default '0',
  `npwrap` int(11) NOT NULL default '0',
  `directionality` char(3) NOT NULL default 'ltr',
  `toolbarLocation` varchar(6) NOT NULL default 'bottom',
  `cssFile` varchar(255) default NULL,
  `validElements` mediumtext,
  `toolbarRow1` text,
  `toolbarRow2` text,
  `toolbarRow3` text,
  `enableContextMenu` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `disableRichEditor` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `RichEdit` VALUES ('PBrichedit000000000001',0,0,0,0,600,500,0,0,0,0,'ltr','bottom',NULL,'*[*]','bold\nitalic\njustifyleft\njustifyright\njustifycenter\njustifyfull\nindent\noutdent\nsub\nsup\nformatselect\nremoveformat','bullist\nnumlist\nlink\npagetree\nanchor\nunlink\nadvhr\nimage\ninsertImage\ncharmap\ncollateral','tablecontrols\nvisualaid\npreview\ncode\ncleanup\nreplace',1,1124395696,0),('PBrichedit000000000002',0,0,0,0,0,0,0,0,0,0,'ltr','bottom',NULL,'a[name|href|target|title],strong/b[class],em/i[class],strike[class],u[class],p[dir|class|align],ol,ul,li,br,img[class|src|border=0|alt|title|hspace|vspace|width|height|align],sub,sup,blockquote[dir|style],table[border=0|cellspacing|cellpadding|width|height|class|align],tr[class|rowspan|width|height|align|valign],td[dir|class|colspan|rowspan|width|height|align|valign],div[dir|class|align],span[class|align],pre[class|align],address[class|align],h1[dir|class|align],h2[dir|class|align],h3[dir|class|align],h4[dir|class|align],h5[dir|class|align],h6[dir|class|align],hr','bold\nitalic\nbullist\nnumlist\nlink\nunlink\nemotions',NULL,NULL,0,1124395696,0);
CREATE TABLE `SQLForm` (
  `assetId` varchar(22) NOT NULL default '',
  `formId` varchar(22) default NULL,
  `tableName` varchar(255) default NULL,
  `defaultView` varchar(22) default NULL,
  `searchTemplateId` varchar(22) default NULL,
  `editTemplateId` varchar(22) default NULL,
  `submitGroupId` varchar(22) default NULL,
  `alterGroupId` varchar(22) default NULL,
  `databaseLinkId` varchar(22) default '0',
  `maxFileSize` bigint(20) default NULL,
  `sendMailTo` varchar(255) default NULL,
  `showMetaData` tinyint(1) default '1',
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `SQLForm_fieldDefinitions` (
  `fieldId` varchar(22) NOT NULL default '',
  `assetId` varchar(22) NOT NULL default '',
  `property` varchar(255) NOT NULL default '',
  `value` text,
  UNIQUE KEY `fieldId` (`fieldId`,`property`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `SQLForm_fieldOrder` (
  `assetId` varchar(22) NOT NULL default '',
  `fieldId` varchar(22) NOT NULL default '',
  `rank` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `SQLForm_fieldTypes` (
  `fieldTypeId` varchar(22) NOT NULL default '',
  `dbFieldType` varchar(22) NOT NULL default '',
  `formFieldType` varchar(22) NOT NULL default '',
  PRIMARY KEY  (`fieldTypeId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `SQLForm_regexes` (
  `regexId` varchar(22) default NULL,
  `name` varchar(255) NOT NULL default '',
  `regex` varchar(255) NOT NULL default '',
  UNIQUE KEY `regex` (`regex`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `SQLForm_regexes` VALUES ('defaultText','Text','^[\\w\\d\\s]*$'),('defaultUnsigned','Unsigned integer','^\\d+$'),('defaultSigned','Signed integer','^-?\\d+$'),('defaultFloat','Floating point number','^-?\\d+(.\\d+)?$');
CREATE TABLE `SQLReport` (
  `dbQuery1` text,
  `paginateAfter` int(11) NOT NULL default '50',
  `preprocessMacros1` int(11) default '0',
  `debugMode` int(11) NOT NULL default '0',
  `databaseLinkId1` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `placeholderParams1` text,
  `preprocessMacros2` int(11) default '0',
  `dbQuery2` text,
  `placeholderParams2` text,
  `databaseLinkId2` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `preprocessMacros3` int(11) default '0',
  `dbQuery3` text,
  `placeholderParams3` text,
  `databaseLinkId3` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `preprocessMacros4` int(11) default '0',
  `dbQuery4` text,
  `placeholderParams4` text,
  `databaseLinkId4` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `preprocessMacros5` int(11) default '0',
  `dbQuery5` text,
  `placeholderParams5` text,
  `databaseLinkId5` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '0',
  `prequeryStatements1` text,
  `prequeryStatements2` text,
  `prequeryStatements3` text,
  `prequeryStatements4` text,
  `prequeryStatements5` text,
  `downloadType` varchar(255) default NULL,
  `downloadFilename` varchar(255) default NULL,
  `downloadTemplateId` varchar(22) default NULL,
  `downloadMimeType` varchar(255) default NULL,
  `downloadUserGroup` varchar(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Shortcut` (
  `overrideTitle` int(11) NOT NULL default '0',
  `overrideDescription` int(11) NOT NULL default '0',
  `overrideTemplate` int(11) NOT NULL default '0',
  `overrideDisplayTitle` int(11) NOT NULL default '0',
  `overrideTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `shortcutByCriteria` int(11) NOT NULL default '0',
  `resolveMultiples` varchar(30) default 'mostRecent',
  `shortcutCriteria` text NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `shortcutToAssetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `disableContentLock` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `prefFieldsToShow` text,
  `prefFieldsToImport` text,
  `showReloadIcon` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Shortcut_overrides` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `fieldName` varchar(255) NOT NULL default '',
  `newValue` text,
  PRIMARY KEY  (`assetId`,`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `StockData` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'StockListTMPL000000001',
  `displayTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'StockListTMPL000000002',
  `defaultStocks` text,
  `source` varchar(50) default 'usa',
  `failover` int(11) default '1',
  `revisionDate` int(11) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey` (
  `questionOrder` varchar(30) default NULL,
  `groupToTakeSurvey` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `groupToViewReports` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `mode` varchar(30) default NULL,
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `anonymous` char(1) NOT NULL default '0',
  `questionsPerPage` int(11) NOT NULL default '1',
  `responseTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `overviewTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `maxResponsesPerUser` int(11) NOT NULL default '1',
  `questionsPerResponse` int(11) NOT NULL default '9999999',
  `gradebookTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `defaultSectionId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey_answer` (
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_questionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_answerId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `sequenceNumber` int(11) NOT NULL default '1',
  `gotoQuestion` varchar(22) character set utf8 collate utf8_bin default NULL,
  `answer` varchar(255) default NULL,
  `isCorrect` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Survey_answerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey_question` (
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_questionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `question` text,
  `sequenceNumber` int(11) NOT NULL default '1',
  `allowComment` int(11) NOT NULL default '0',
  `randomizeAnswers` int(11) NOT NULL default '0',
  `answerFieldType` varchar(35) default NULL,
  `gotoQuestion` varchar(22) default NULL,
  `Survey_sectionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`Survey_questionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey_questionResponse` (
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_questionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_answerId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_responseId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `response` text,
  `comment` text,
  `dateOfResponse` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`Survey_questionId`,`Survey_answerId`,`Survey_responseId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey_response` (
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_responseId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) default NULL,
  `username` varchar(255) default NULL,
  `ipAddress` varchar(15) default NULL,
  `startDate` bigint(20) NOT NULL default '0',
  `endDate` bigint(20) NOT NULL default '0',
  `isComplete` int(11) NOT NULL default '0',
  PRIMARY KEY  (`Survey_responseId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Survey_section` (
  `Survey_id` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `Survey_sectionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `sectionName` text,
  `sequenceNumber` int(11) NOT NULL default '1',
  PRIMARY KEY  (`Survey_sectionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `SyndicatedContent` (
  `rssUrl` text,
  `maxHeadlines` int(11) NOT NULL default '0',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `displayMode` varchar(20) NOT NULL default 'interleaved',
  `hasTerms` varchar(255) NOT NULL default '',
  `cacheTimeout` int(11) NOT NULL default '3600',
  `processMacroInRssUrl` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `SyndicatedContent` VALUES ('http://www.plainblack.com/news/news?func=viewRSS',3,'fK-HMSboA3uu0c1KYkYspA','GNvjCFQWjY2AF2uf0aCM8Q',1124395696,'interleaved','',3600,0);
CREATE TABLE `TT_projectList` (
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `projectName` varchar(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdatedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`projectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `TT_projectResourceList` (
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `resourceId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`projectId`,`resourceId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `TT_projectTasks` (
  `taskId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `taskName` varchar(255) NOT NULL,
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `TT_report` (
  `reportId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` varchar(22) NOT NULL,
  `startDate` varchar(10) NOT NULL,
  `endDate` varchar(10) NOT NULL,
  `reportComplete` int(11) NOT NULL default '0',
  `resourceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdatedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `TT_timeEntry` (
  `entryId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `projectId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `taskId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `taskDate` varchar(10) NOT NULL,
  `hours` float default '0',
  `comments` text,
  `reportId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`entryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `TT_wobject` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `userViewTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'TimeTrackingTMPL000001',
  `managerViewTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'TimeTrackingTMPL000002',
  `timeRowTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'TimeTrackingTMPL000003',
  `pmAssetId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `groupToManage` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `revisionDate` bigint(20) NOT NULL,
  `pmIntegration` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Thread` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `replies` int(11) NOT NULL default '0',
  `lastPostId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `lastPostDate` bigint(20) default NULL,
  `isLocked` int(11) NOT NULL default '0',
  `isSticky` int(11) NOT NULL default '0',
  `subscriptionGroupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `karma` int(11) NOT NULL default '0',
  `karmaScale` int(11) NOT NULL default '1',
  `karmaRank` float(11,6) default NULL,
  `threadRating` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Thread_read` (
  `threadId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  KEY `threadId_userId` (`threadId`,`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `WSClient` (
  `callMethod` text,
  `uri` varchar(255) NOT NULL default '',
  `proxy` varchar(255) NOT NULL default '',
  `preprocessMacros` int(11) NOT NULL default '0',
  `paginateAfter` int(11) NOT NULL default '50',
  `paginateVar` varchar(35) default NULL,
  `debugMode` int(11) NOT NULL default '0',
  `params` text,
  `execute_by_default` tinyint(4) NOT NULL default '1',
  `decodeUtf8` tinyint(3) unsigned NOT NULL default '0',
  `httpHeader` varchar(50) default NULL,
  `sharedCache` tinyint(3) unsigned NOT NULL default '0',
  `cacheTTL` smallint(5) unsigned NOT NULL default '60',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `WeatherData` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WeatherDataTmpl0000001',
  `locations` text,
  `partnerId` varchar(100) default NULL,
  `licenseKey` varchar(100) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `WikiMaster` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToEditPages` varchar(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `groupToAdminister` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `richEditor` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'PBrichedit000000000002',
  `frontPageTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiFrontTmpl000000001',
  `pageTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiPageTmpl0000000001',
  `pageEditTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiPageEditTmpl000001',
  `recentChangesTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiRCTmpl000000000001',
  `mostPopularTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiMPTmpl000000000001',
  `pageHistoryTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiPHTmpl000000000001',
  `searchTemplateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'WikiSearchTmpl00000001',
  `recentChangesCount` int(11) NOT NULL default '50',
  `recentChangesCountFront` int(11) NOT NULL default '10',
  `mostPopularCount` int(11) NOT NULL default '50',
  `mostPopularCountFront` int(11) NOT NULL default '10',
  `thumbnailSize` int(11) NOT NULL default '0',
  `maxImageSize` int(11) NOT NULL default '0',
  `approvalWorkflow` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'pbworkflow000000000003',
  `useContentFilter` int(11) default '0',
  `filterCode` varchar(30) default 'javascript',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `WikiPage` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `content` mediumtext,
  `storageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `views` bigint(20) NOT NULL default '0',
  `isProtected` int(11) NOT NULL default '0',
  `actionTaken` varchar(35) NOT NULL,
  `actionTakenBy` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `Workflow` (
  `workflowId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `title` varchar(255) NOT NULL default 'Untitled',
  `description` text,
  `enabled` int(11) NOT NULL default '0',
  `isSerial` int(11) NOT NULL default '0',
  `isSingleton` int(11) NOT NULL default '0',
  `type` varchar(255) NOT NULL default 'None',
  PRIMARY KEY  (`workflowId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `Workflow` VALUES ('pbworkflow000000000001','Daily Maintenance Tasks','This workflow runs daily maintenance tasks such as cleaning up old temporary files and cache.',1,0,0,'None'),('pbworkflow000000000002','Weekly Maintenance Tasks','This workflow runs once per week to perform maintenance tasks like cleaning up log files.',1,0,0,'None'),('pbworkflow000000000004','Hourly Maintenance Tasks','This workflow runs once per hour to perform maintenance tasks like deleting expired user sessions.',1,0,0,'None'),('pbworkflow000000000003','Commit Without Approval','This workflow commits all the assets in this version tag without asking for any approval.',1,0,0,'WebGUI::VersionTag'),('pbworkflow000000000005','Commit With Approval','This workflow commits all the assets in this version tag after getting approval from content managers.',1,0,0,'WebGUI::VersionTag'),('pbworkflow000000000006','Unlock Version Tag and Notify Owner','This workflow is used when a version tag approval is denied. It unlocks the version tag, making it available for editing, and notifies the tag owner.',1,0,0,'WebGUI::VersionTag'),('pbworkflow000000000007','Send Queued Email Messages','Sends all the messages in the mail queue.',1,0,1,'None'),('csworkflow000000000001','Get CS Mail','Retrieves mail from a POP3 account for the given Collaboration System.',1,0,1,'WebGUI::Asset::Wobject::Collaboration'),('EMSworkflow00000000001','EMS Precache','Precaches EMS event prerequisites',1,1,0,'none'),('AuthLDAPworkflow000001','Synchronize Profile To LDAP','Synchronizes a users LDAP information to their WebGUI User Profile',1,0,0,'WebGUI::User'),('DPWwf20061030000000001','Do Nothing on Deletion','Does nothing extra.  Default for deletion workflow settings.',1,0,0,'None'),('DPWwf20061030000000002','Delete Exported Files','Deletes exported files from an asset being deleted or moved.',1,0,0,'None');
CREATE TABLE `WorkflowActivity` (
  `activityId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `workflowId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `title` varchar(255) NOT NULL default 'Untitled',
  `description` text,
  `sequenceNumber` int(11) NOT NULL default '1',
  `className` varchar(255) default NULL,
  PRIMARY KEY  (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `WorkflowActivity` VALUES ('pbwfactivity0000000001','pbworkflow000000000001','Delete temp files older than 24 hours',NULL,1,'WebGUI::Workflow::Activity::CleanTempStorage'),('pbwfactivity0000000013','pbworkflow000000000001','Process Recurring Payments',NULL,2,'WebGUI::Workflow::Activity::ProcessRecurringPayments'),('pbwfactivity0000000002','pbworkflow000000000001','Prune file cache larger than 100MB',NULL,3,'WebGUI::Workflow::Activity::CleanFileCache'),('pbwfactivity0000000022','pbworkflow000000000001','Prune database cache larger than 100MB',NULL,4,'WebGUI::Workflow::Activity::CleanDatabaseCache'),('pbwfactivity0000000005','pbworkflow000000000001','Archive old CS threads',NULL,5,'WebGUI::Workflow::Activity::ArchiveOldThreads'),('pbwfactivity0000000006','pbworkflow000000000003','Commit Assets',NULL,1,'WebGUI::Workflow::Activity::CommitVersionTag'),('pbwfactivity0000000007','pbworkflow000000000001','deal with user groupings that have expired',NULL,6,'WebGUI::Workflow::Activity::ExpireGroupings'),('pbwfactivity0000000011','pbworkflow000000000001','Expire old subscription codes',NULL,7,'WebGUI::Workflow::Activity::ExpireSubscriptionCodes'),('pbwfactivity0000000014','pbworkflow000000000001','Summarize Passive Profiling Data',NULL,8,'WebGUI::Workflow::Activity::SummarizePassiveProfileLog'),('pbwfactivity0000000015','pbworkflow000000000001','Sync User Profiles With LDAP',NULL,9,'WebGUI::Workflow::Activity::SyncProfilesToLdap'),('pbwfactivity0000000003','pbworkflow000000000002','Delete login entries older than 90 days',NULL,1,'WebGUI::Workflow::Activity::CleanLoginHistory'),('pbwfactivity0000000004','pbworkflow000000000002','Move clipboard items older than 30 days to trash',NULL,2,'WebGUI::Workflow::Activity::TrashClipboard'),('pbwfactivity0000000008','pbworkflow000000000002','delete asset revisions older than a year from the database',NULL,3,'WebGUI::Workflow::Activity::PurgeOldAssetRevisions'),('pbwfactivity0000000010','pbworkflow000000000002','delete assets from trash that have been sitting around for 30 days',NULL,4,'WebGUI::Workflow::Activity::PurgeOldTrash'),('pbwfactivity0000000009','pbworkflow000000000004','delete expired sessions',NULL,1,'WebGUI::Workflow::Activity::DeleteExpiredSessions'),('pbwfactivity0000000012','pbworkflow000000000004','Get syndicated content',NULL,2,'WebGUI::Workflow::Activity::GetSyndicatedContent'),('pbwfactivity0000000017','pbworkflow000000000005','Get Approval from Content Managers',NULL,1,'WebGUI::Workflow::Activity::RequestApprovalForVersionTag'),('pbwfactivity0000000016','pbworkflow000000000005','Commit Assets',NULL,2,'WebGUI::Workflow::Activity::CommitVersionTag'),('pbwfactivity0000000018','pbworkflow000000000005','Notify Committer of Approval',NULL,3,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('pbwfactivity0000000019','pbworkflow000000000006','Unlock Version Tag',NULL,1,'WebGUI::Workflow::Activity::UnlockVersionTag'),('pbwfactivity0000000020','pbworkflow000000000006','Notify Committer of Denial',NULL,2,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('pbwfactivity0000000021','pbworkflow000000000007','Send Queued Messages',NULL,1,'WebGUI::Workflow::Activity::SendQueuedMailMessages'),('csactivity000000000001','csworkflow000000000001','Get the mail',NULL,1,'WebGUI::Workflow::Activity::GetCsMail'),('EMSactivity00000000001','EMSworkflow00000000001','Precache EMS prerequisites',NULL,1,'WebGUI::Workflow::Activity::CacheEMSPrereqs'),('Dl_3P-4y1OoOTf3cRwQ7EA','AuthLDAPworkflow000001','Synchronize Profile To LDAP',NULL,1,'WebGUI::Workflow::Activity::SyncProfileToLdap'),('DPWwfa2006103000000002','DPWwf20061030000000002','Delete Exported Files',NULL,1,'WebGUI::Workflow::Activity::DeleteExportedFiles'),('SWHs3shndnc8LuLpmLeeNw','pbworkflow000000000004','Update Calendar Feeds','This activity imports calendar events from calendar feeds',3,'WebGUI::Workflow::Activity::CalendarUpdateFeeds');
CREATE TABLE `WorkflowActivityData` (
  `activityId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY  (`activityId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `WorkflowActivityData` VALUES ('pbwfactivity0000000001','storageTimeout','86400'),('pbwfactivity0000000002','sizeLimit','1000000000'),('pbwfactivity0000000022','sizeLimit','1000000000'),('pbwfactivity0000000006','trashAfter','2592000'),('pbwfactivity0000000003','ageToDelete','7776000'),('pbwfactivity0000000004','trashAfter','2592000'),('pbwfactivity0000000008','purgeAfter','31536000'),('pbwfactivity0000000010','purgeAfter','2592000'),('pbwfactivity0000000017','groupToApprove','4'),('pbwfactivity0000000017','message','A new version tag awaits your approval.'),('pbwfactivity0000000017','doOnDeny','pbworkflow000000000006'),('pbwfactivity0000000018','message','Your version tag was approved.'),('pbwfactivity0000000018','who','committer'),('pbwfactivity0000000020','message','Your version tag was denied. Please take corrective actions and recommit your changes.'),('pbwfactivity0000000020','who','committer');
CREATE TABLE `WorkflowInstance` (
  `instanceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `workflowId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `currentActivityId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `priority` int(11) NOT NULL default '2',
  `className` varchar(255) default NULL,
  `methodName` varchar(255) default NULL,
  `parameters` text,
  `runningSince` bigint(20) default NULL,
  `lastUpdate` bigint(20) default NULL,
  `lastStatus` varchar(15) default NULL,
  PRIMARY KEY  (`instanceId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `WorkflowInstance` VALUES ('5ozLPq8sAe5l7Vp0csOvUQ','DPWwf20061030000000001','',2,NULL,NULL,NULL,1165460176,1165460176,NULL);
CREATE TABLE `WorkflowInstanceScratch` (
  `instanceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY  (`instanceId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `WorkflowInstanceScratch` VALUES ('5ozLPq8sAe5l7Vp0csOvUQ','Workflow_Activity_DeleteExportedFiles_deleteFiles','1234\0\0\0\0');
CREATE TABLE `WorkflowSchedule` (
  `taskId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `title` varchar(255) NOT NULL default 'Untitled',
  `enabled` int(11) NOT NULL default '0',
  `runOnce` int(11) NOT NULL default '0',
  `minuteOfHour` varchar(25) NOT NULL default '0',
  `hourOfDay` varchar(25) NOT NULL default '*',
  `dayOfMonth` varchar(25) NOT NULL default '*',
  `monthOfYear` varchar(25) NOT NULL default '*',
  `dayOfWeek` varchar(25) NOT NULL default '*',
  `workflowId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `className` varchar(255) default NULL,
  `methodName` varchar(255) default NULL,
  `priority` int(11) NOT NULL default '2',
  `parameters` text,
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `WorkflowSchedule` VALUES ('pbcron0000000000000001','Daily Maintenance',1,0,'30','23','*','*','*','pbworkflow000000000001',NULL,NULL,3,NULL),('pbcron0000000000000002','Weekly Maintenance',1,0,'30','1','*','*','0','pbworkflow000000000002',NULL,NULL,3,NULL),('pbcron0000000000000003','Hourly Maintenance',1,0,'15','*','*','*','*','pbworkflow000000000004',NULL,NULL,3,NULL),('pbcron0000000000000004','Send Queued Email Messages Every 5 Minutes',1,0,'*/5','*','*','*','*','pbworkflow000000000007',NULL,NULL,3,NULL),('CHO6iN9JKNtRBKnFDzO-mA','Photo Gallery Mail',0,0,'*/5','*','*','*','*','csworkflow000000000001','WebGUI::Asset::Wobject::Collaboration','new',2,'{\n    \"parameters\" : \"pbproto000000000000001\"\n}'),('NpRVTSR-NX2sD52LUc520A','Request Tracker Mail',0,0,'*/5','*','*','*','*','csworkflow000000000001','WebGUI::Asset::Wobject::Collaboration','new',2,'{\n    \"parameters\" : \"pbproto000000000000002\"\n}');
CREATE TABLE `ZipArchiveAsset` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `showPage` varchar(255) NOT NULL default 'index.html',
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `adSpace` (
  `adSpaceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(35) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `costPerImpression` decimal(11,2) NOT NULL default '0.00',
  `minimumImpressions` int(11) NOT NULL default '1000',
  `costPerClick` decimal(11,2) NOT NULL default '0.00',
  `minimumClicks` int(11) NOT NULL default '1000',
  `width` int(11) NOT NULL default '468',
  `height` int(11) NOT NULL default '60',
  `groupToPurchase` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  PRIMARY KEY  (`adSpaceId`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `advertisement` (
  `adId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `adSpaceId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `ownerUserId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `isActive` int(11) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `type` varchar(15) NOT NULL default 'text',
  `storageId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `adText` varchar(255) default NULL,
  `url` text,
  `richMedia` text,
  `borderColor` varchar(7) NOT NULL default '#000000',
  `textColor` varchar(7) NOT NULL default '#000000',
  `backgroundColor` varchar(7) NOT NULL default '#ffffff',
  `clicks` int(11) NOT NULL default '0',
  `clicksBought` int(11) NOT NULL default '0',
  `impressions` int(11) NOT NULL default '0',
  `impressionsBought` int(11) NOT NULL default '0',
  `priority` int(11) NOT NULL default '0',
  `nextInPriority` bigint(20) NOT NULL default '0',
  `renderedAd` text,
  PRIMARY KEY  (`adId`),
  KEY `adSpaceId_isActive` (`adSpaceId`,`isActive`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `asset` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `parentId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `lineage` varchar(255) NOT NULL default '',
  `state` varchar(35) NOT NULL default '',
  `className` varchar(255) NOT NULL default '',
  `creationDate` bigint(20) NOT NULL default '997995720',
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `stateChanged` varchar(22) NOT NULL default '997995720',
  `stateChangedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `isLockedBy` varchar(22) character set utf8 collate utf8_bin default NULL,
  `isSystem` int(11) NOT NULL default '0',
  `lastExportedAs` varchar(255) default NULL,
  PRIMARY KEY  (`assetId`),
  UNIQUE KEY `lineage` (`lineage`),
  KEY `parentId` (`parentId`),
  KEY `state_parentId_lineage` (`state`,`parentId`,`lineage`),
  KEY `isPrototype_className_assetId` (`className`,`assetId`),
  KEY `className_assetId_state` (`className`,`assetId`,`state`),
  KEY `state_lineage` (`state`,`lineage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `asset` VALUES ('PBasset000000000000001','infinity','000001','published','WebGUI::Asset',1124395696,'3','997995720','3',NULL,1,NULL),('PBasset000000000000002','PBasset000000000000001','000001000001','published','WebGUI::Asset::Wobject::Folder',1124395696,'3','997995720','3',NULL,1,NULL),('68sKwDgf9cGH58-NZcU4lg','PBasset000000000000001','000001000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('iCYOjohB9SKvAPr6bXElKA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000004','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('ix1p0AbwKAz8QWB-T-HHfg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000003','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('_iHetEvMQUOoxS-T2CM0sQ','68sKwDgf9cGH58-NZcU4lg','000001000002000003','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('FOvmwGC0GtZo5VTxJIL3OA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000002','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('8Bb8gu-me2mhL3ljFyiWLg','68sKwDgf9cGH58-NZcU4lg','000001000002000004','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('m4YJFaqzultnB_sj1Uq0aw','68sKwDgf9cGH58-NZcU4lg','000001000002000009','published','WebGUI::Asset::File',1147642514,'3','997995720','3',NULL,0,NULL),('IWFxZDyGhQ3-SLZhELa3qw','68sKwDgf9cGH58-NZcU4lg','000001000002000010','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('bX5rYxb6tZ9docY6sUhBlw','_iHetEvMQUOoxS-T2CM0sQ','000001000002000003000001','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('Vzv1pWpg_w6R_o-b0rM2qQ','_iHetEvMQUOoxS-T2CM0sQ','000001000002000003000002','published','WebGUI::Asset::File',1147642515,'3','997995720','3',NULL,0,NULL),('NK8bqlwVRILJknqeCDPBHg','_iHetEvMQUOoxS-T2CM0sQ','000001000002000003000003','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('6QuS-0rosuZTdTv11fobig','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000001','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('2TqQc4OISddWCZmRY1_m8A','68sKwDgf9cGH58-NZcU4lg','000001000002000005','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('fK-HMSboA3uu0c1KYkYspA','2TqQc4OISddWCZmRY1_m8A','000001000002000005000001','published','WebGUI::Asset::Wobject::SyndicatedContent',1124395696,'3','997995720','3',NULL,0,NULL),('Swf6L8poXKc7hUaNPkBevw','68sKwDgf9cGH58-NZcU4lg','000001000002000006','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('Szs5eev3OMssmnsyLRZmWA','Swf6L8poXKc7hUaNPkBevw','000001000002000006000001','published','WebGUI::Asset::Wobject::DataForm',1124395696,'3','997995720','3',NULL,0,NULL),('x3OFY6OJh_qsXkZfPwug4A','68sKwDgf9cGH58-NZcU4lg','000001000002000007','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('pJd5TLAjfWMVXD6sCRLwUg','x3OFY6OJh_qsXkZfPwug4A','000001000002000007000001','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000003','7.0-style0000000000001','000001000001000088000002','published','WebGUI::Asset::Snippet',1147642492,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000001','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000011','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000014','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000012','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000015','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000013','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000016','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000014','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000017','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000015','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000018','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000016','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000019','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000017','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000020','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000018','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000021','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000019','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000002','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000020','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000006','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000021','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000007','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000022','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000008','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000023','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000009','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000024','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000010','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000025','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000011','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000026','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000012','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000027','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000013','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000028','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('Wl8WZ43g2rK5AYr9o4zY7w','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000006','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('4Yfz9hqBqM8OYMGuQK8oLw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000005','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000005','7.0-style0000000000001','000001000001000088000004','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000006','7.0-style0000000000001','000001000001000088000005','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000103','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000105','Cn2TOyQH3qqnQrWDrsGrxg','000001000001000035000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000086','Cn2TOyQH3qqnQrWDrsGrxg','000001000001000035000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000084','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000002','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000115','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000066','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000080','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000097','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000112','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000121','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000067','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000026','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000128','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000079','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000009','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000083','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000010','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000082','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000011','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000056','TYo2Bwl7aafzTtdHlS-arQ','000001000001000065000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000095','TYo2Bwl7aafzTtdHlS-arQ','000001000001000065000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000110','TYo2Bwl7aafzTtdHlS-arQ','000001000001000065000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000135','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000131','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000119','TYo2Bwl7aafzTtdHlS-arQ','000001000001000065000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000054','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000024','tXwf1zaOXTvsqPn6yu-GSw','000001000001000036000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000088','tPagC0AQErZXjLFZQ6OI1g','000001000001000039000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000078','GYaFxnMu9UsEG8oanwB6TA','000001000001000037000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000125','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000118','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000109','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000094','aNNC62qLAS6TB-0_MCYjsw','000001000001000043000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000133','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000012','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000065','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000055','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000064000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000020','-K8Hj45mbelljN9-0CXZxg','000001000001000030000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000085','-K8Hj45mbelljN9-0CXZxg','000001000001000030000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000104','-K8Hj45mbelljN9-0CXZxg','000001000001000030000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000021','-K8Hj45mbelljN9-0CXZxg','000001000001000030000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000033','N13SD1Fpqk00UgBt1Z8ivQ','000001000001000038000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000047','cj2y4papTVGZRFdwTI-_fw','000001000001000058000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000029','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000013','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000032','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000014','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000027','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000015','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000031','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000016','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('jTNggl7AoVSUc_ZzrvuCmw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000008','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('LBuiKzg2mWwmOPS9AgV3bg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000004000007','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('GNvjCFQWjY2AF2uf0aCM8Q','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000068','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000017','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000099','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000018','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000114','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000019','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000092','V3l5S5TtI7wMm1WpIMhvOA','000001000001000053000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000044','V3l5S5TtI7wMm1WpIMhvOA','000001000001000053000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000059','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000075000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000206','VXSsbsfcfht1904EWkb1sw','000001000001000040000001','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000207','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000007','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000051','AgyFhx3eXlfZXNp2MkrsiQ','000001000001000061000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000052','F7MAQ-cpuvQ1KuC7J4P5zQ','000001000001000062000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000002','TCtybxdqmdwdvRn555zpCQ','000001000001000087000002','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000063','5bnNzteN7w3NnK9mF4XiCg','000001000001000078000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000062','5bnNzteN7w3NnK9mF4XiCg','000001000001000078000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000061','5bnNzteN7w3NnK9mF4XiCg','000001000001000078000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000064','5bnNzteN7w3NnK9mF4XiCg','000001000001000078000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000116','-K8Hj45mbelljN9-0CXZxg','000001000001000030000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000069','5YAbuwiVFUx-z8hcOAnsdQ','000001000001000084000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000100','5YAbuwiVFUx-z8hcOAnsdQ','000001000001000084000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000007','7.0-style0000000000001','000001000001000088000006','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000090','Ov2ssJHwp_1eEWKlDyUKmg','000001000001000044000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000093','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000048','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000108','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000117','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000124','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000130','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000134','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000009','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000034','AFdXZZmGnSKalNSobQMB5w','000001000001000041000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000077','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000020','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000098','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000021','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000122','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000022','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000136','BFfNj5wA9bDw8H3cnr8pTw','000001000001000060000010','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000013','9M-lrlPQWeeNWfvnDnK_Xg','000001000001000026000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000010','K0q_N885Httqev1VCqUWxg','000001000001000023000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000011','fq1ZkYhH24R5tb96kuT10Q','000001000001000024000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000014','_gBYAdTcbkiyamnqi2Xskg','000001000001000027000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000012','oHk7fAFhEEkB7dHzi0QOQA','000001000001000025000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000006','taX2UYkFF21ALpFZY2rhMw','000001000001000022000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000004','xSmREZO3GNzK3M5PaueOOQ','000001000001000020000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000005','0bx-xoL8TSXXubFuqKAoVQ','000001000001000021000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000057','Ik9HHky10DIyFTKehUD1dw','000001000001000070000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000060','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000077000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('pbrobot000000000000001','PBasset000000000000002','000001000001000091','published','WebGUI::Asset::Snippet',1147642511,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000111','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000077000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000137','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000077000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000132','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000077000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000123','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000129','TvOZs8U1kRXLtwtmyW75pg','000001000001000019000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000081','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000023','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000101','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000024','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000065','7.0-style0000000000049','000001000001000090000016','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('OhdaFLE7sXOzo_SIP2ZUgA','68sKwDgf9cGH58-NZcU4lg','000001000002000008','published','WebGUI::Asset::Wobject::Article',1147642513,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000113','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000026','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000037','GdkQpvjRtJqtzOUbwIIQRA','000001000001000046000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000038','tnc5iYyynX2hfdEs9D3P8w','000001000001000047000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000036','tBL7BWiQRZFed2Y-Zjo9tQ','000001000001000045000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000039','vgXdBcFTqU7h4wBG1ewdBw','000001000001000048000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000091','vgXdBcFTqU7h4wBG1ewdBw','000001000001000048000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000107','vgXdBcFTqU7h4wBG1ewdBw','000001000001000048000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000040','hcFlqnXlsmC1ujN6Id0F0A','000001000001000049000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000041','eRJR52fvlaxfetv3DQkQYw','000001000001000050000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000042','5HIDHq5lAWHV5gpYGS0zLg','000001000001000051000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000045','y8XkRdxIperLKkJ3bL5sSQ','000001000001000055000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000043','rYEFwXXo0tkGhQTcbDibvg','000001000001000052000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000064','7.0-style0000000000049','000001000001000090000015','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000001','TCtybxdqmdwdvRn555zpCQ','000001000001000087000001','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000053','jEz8iTGNWEt2I05IhVV19Q','000001000001000063000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000046','e-WvgcKROPCoHwiiHLktCg','000001000001000056000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000018','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000016','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000019','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000015','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000017','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000018000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000140','Da6KWn805L4B5e4HFgQRQA','000001000001000072000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000141','-K8Hj45mbelljN9-0CXZxg','000001000001000030000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000066','7.0-style0000000000049','000001000001000090000017','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000062','7.0-style0000000000049','000001000001000090000013','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000060','7.0-style0000000000049','000001000001000090000011','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000061','7.0-style0000000000049','000001000001000090000012','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000057','7.0-style0000000000049','000001000001000090000008','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000058','7.0-style0000000000049','000001000001000090000009','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000059','7.0-style0000000000049','000001000001000090000010','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000056','7.0-style0000000000049','000001000001000090000007','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000052','7.0-style0000000000049','000001000001000090000003','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000053','7.0-style0000000000049','000001000001000090000004','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000054','7.0-style0000000000049','000001000001000090000005','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000055','7.0-style0000000000049','000001000001000090000006','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('stevecoolmenu000000001','7.0-style0000000000049','000001000001000090000001','published','WebGUI::Asset::Template',1147642505,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000051','7.0-style0000000000049','000001000001000090000002','published','WebGUI::Asset::Snippet',1147642505,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000049','PBasset000000000000002','000001000001000090','published','WebGUI::Asset::Wobject::Folder',1147642504,'3','997995720','3',NULL,0,NULL),('stevestyle000000000002','7.0-style0000000000031','000001000001000089000016','published','WebGUI::Asset::Template',1147642504,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000048','7.0-style0000000000031','000001000001000089000017','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000046','7.0-style0000000000031','000001000001000089000015','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000044','7.0-style0000000000031','000001000001000089000013','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000045','7.0-style0000000000031','000001000001000089000014','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000043','7.0-style0000000000031','000001000001000089000012','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000041','7.0-style0000000000031','000001000001000089000010','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000042','7.0-style0000000000031','000001000001000089000011','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000038','7.0-style0000000000031','000001000001000089000007','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000039','7.0-style0000000000031','000001000001000089000008','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000040','7.0-style0000000000031','000001000001000089000009','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000036','7.0-style0000000000031','000001000001000089000005','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000037','7.0-style0000000000031','000001000001000089000006','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000034','7.0-style0000000000031','000001000001000089000003','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000035','7.0-style0000000000031','000001000001000089000004','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000032','7.0-style0000000000031','000001000001000089000001','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000033','7.0-style0000000000031','000001000001000089000002','published','WebGUI::Asset::Snippet',1147642500,'3','997995720','3',NULL,0,NULL),('PBnav000000style01lvl2','7.0-style0000000000001','000001000001000088000028','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000030','7.0-style0000000000001','000001000001000088000029','published','WebGUI::Asset::File::Image',1147642499,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000031','PBasset000000000000002','000001000001000089','published','WebGUI::Asset::Wobject::Folder',1147642500,'3','997995720','3',NULL,0,NULL),('stevenav00000000000001','7.0-style0000000000001','000001000001000088000027','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000025','7.0-style0000000000001','000001000001000088000024','published','WebGUI::Asset::Wobject::Navigation',1147642498,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000026','7.0-style0000000000001','000001000001000088000025','published','WebGUI::Asset::Wobject::Navigation',1147642499,'3','997995720','3',NULL,0,NULL),('stevestyle000000000001','7.0-style0000000000001','000001000001000088000026','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000023','7.0-style0000000000001','000001000001000088000022','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000024','7.0-style0000000000001','000001000001000088000023','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000022','7.0-style0000000000001','000001000001000088000021','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000021','7.0-style0000000000001','000001000001000088000020','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000018','7.0-style0000000000001','000001000001000088000017','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000019','7.0-style0000000000001','000001000001000088000018','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000020','7.0-style0000000000001','000001000001000088000019','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000017','7.0-style0000000000001','000001000001000088000016','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000016','7.0-style0000000000001','000001000001000088000015','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000015','7.0-style0000000000001','000001000001000088000014','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000014','7.0-style0000000000001','000001000001000088000013','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000012','7.0-style0000000000001','000001000001000088000011','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000013','7.0-style0000000000001','000001000001000088000012','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000010','7.0-style0000000000001','000001000001000088000009','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000011','7.0-style0000000000001','000001000001000088000010','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000009','7.0-style0000000000001','000001000001000088000008','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000008','7.0-style0000000000001','000001000001000088000007','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('PBtmplCP00000000000001','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000067','7.0-style0000000000049','000001000001000090000018','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBtmplCSSM000000000001','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmplVSC0000000000001','NYr6iP4pQaPRYqEYMryv4w','000001000001000086000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmplHelp000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000018000002','published','WebGUI::Asset::Template',1124395706,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000001','PBasset000000000000002','000001000001000088','published','WebGUI::Asset::Wobject::Folder',1147642492,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000001','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000004','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000002','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000005','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000003','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000006','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000004','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000007','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('DPUROtmpl0000000000001','oGfxez5sksyB_PcaAsEm_Q','000001000001000079000003','published','WebGUI::Asset::Template',1124395707,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000063','7.0-style0000000000049','000001000001000090000014','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000142','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000027','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('stevestyle000000000003','7.0-style0000000000049','000001000001000090000020','published','WebGUI::Asset::Template',1147642510,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000002','LdiozcIUciWuvt3Z-na5Ww','000001000001000057000001','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000001','LdiozcIUciWuvt3Z-na5Ww','000001000001000057000002','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000003','LdiozcIUciWuvt3Z-na5Ww','000001000001000057000003','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000004','LdiozcIUciWuvt3Z-na5Ww','000001000001000057000004','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000005','LdiozcIUciWuvt3Z-na5Ww','000001000001000057000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000004','7.0-style0000000000001','000001000001000088000003','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000002','3uuBf8cYuj1sew2OJXl9tg','000001000001000042000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000001','3uuBf8cYuj1sew2OJXl9tg','000001000001000042000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('PBtmplBlankStyle000001','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000077000007','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('DashboardViewTmpl00001','S1A9iAwKcQQ6P20uTqw-Ew','000001000001000029000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('WeatherDataTmpl0000001','9wKWdum0_8z-OhhquWLtSQ','000001000001000083000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000002','Efe2W0UgrSRDltNJ87jlfg','000001000001000076000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000001','Efe2W0UgrSRDltNJ87jlfg','000001000001000076000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('MultiSearchTmpl0000001','bBzO4CWjqU_ile3gf5Iypw','000001000001000059000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000068','7.0-style0000000000049','000001000001000090000019','published','WebGUI::Asset::File::Image',1147642510,'3','997995720','3',NULL,0,NULL),('ZipArchiveTMPL00000001','CSN-ZON7Uwv8kxf3F1fh5Q','000001000001000085000001','published','WebGUI::Asset::Template',1133743240,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000002','7.0-style0000000000001','000001000001000088000001','published','WebGUI::Asset::File::Image',1147642492,'3','997995720','3',NULL,0,NULL),('WVtmpl0000000000000001','nqNbSUAhk9Vd1zda2SCz9A','000001000001000054000001','published','WebGUI::Asset::Template',1133743240,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000205','VXSsbsfcfht1904EWkb1sw','000001000001000040000002','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000208','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000028','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000209','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000029','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000210','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000030','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('SQLFormEditTmpl0000001','GnrXtoFFeXia3vDQuSHojw','000001000001000073000001','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('SQLFormSearchTmpl00001','k8vxD4fuKKf5cGwNTw0sLw','000001000001000074000001','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000003','lK9-YMfZ4mpc-Me-UydrFg','000001000001000031000001','published','WebGUI::Asset::Template',1147642412,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000004','j3P_Vvsy0OtvUJZRXC55Nw','000001000001000032000001','published','WebGUI::Asset::Template',1147642412,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000006','XP2W66c8vtDVpxN50Fiwww','000001000001000033000001','published','WebGUI::Asset::Template',1147642412,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000001','lK9-YMfZ4mpc-Me-UydrFg','000001000001000031000004','published','WebGUI::Asset::Template',1147642413,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000002','lK9-YMfZ4mpc-Me-UydrFg','000001000001000031000005','published','WebGUI::Asset::Template',1147642413,'3','997995720','3',NULL,0,NULL),('EventManagerTmpl000005','JJ-SZb9z2l_N46A0AWW7KA','000001000001000034000001','published','WebGUI::Asset::Template',1147642413,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0004','yD1SMHelczihzjEmx6eXBA','000001000001000067000001','published','WebGUI::Asset::Template',1147642415,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0003','pV7GnZdpjR3XpZaSINIoeg','000001000001000068000001','published','WebGUI::Asset::Template',1147642415,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0002','71e17KeduiXgODLMlUxiow','000001000001000069000001','published','WebGUI::Asset::Template',1147642415,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0001','9A-mg2gwWmaYi9o_1C7ArQ','000001000001000066000001','published','WebGUI::Asset::Template',1147642415,'3','997995720','3',NULL,0,NULL),('TimeTrackingTMPL000002','vTymIDYL2YqEh6PV50F7ew','000001000001000080000001','published','WebGUI::Asset::Template',1147642417,'3','997995720','3',NULL,0,NULL),('TimeTrackingTMPL000003','lo1ac3BsoJx3ijGQ3gR-bQ','000001000001000081000001','published','WebGUI::Asset::Template',1147642417,'3','997995720','3',NULL,0,NULL),('TimeTrackingTMPL000001','huASapWvFDzqwOSbcN-JFQ','000001000001000082000001','published','WebGUI::Asset::Template',1147642417,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000200','f_tn9FfoSfKWX43F83v_3w','000001000001000071000001','published','WebGUI::Asset::Template',1147642427,'3','997995720','3',NULL,0,NULL),('PBasset000000000000003','PBasset000000000000001','000001000003','published','WebGUI::Asset::Wobject::Folder',1147642437,'3','997995720','3',NULL,1,NULL),('pbproto000000000000001','GNOAsX98vCsl0JRwfwL-gg','000001000001000028000031','published','WebGUI::Asset::Wobject::Collaboration',1147642465,'3','997995720','3',NULL,0,NULL),('pbproto000000000000002','PBasset000000000000002','000001000001000015','published','WebGUI::Asset::Wobject::Collaboration',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000220','tXwf1zaOXTvsqPn6yu-GSw','000001000001000036000002','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000221','tXwf1zaOXTvsqPn6yu-GSw','000001000001000036000003','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('nbSrhXZQuxIjhWFaFPSuVA','PBasset000000000000002','000001000001000018','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('TvOZs8U1kRXLtwtmyW75pg','PBasset000000000000002','000001000001000019','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('xSmREZO3GNzK3M5PaueOOQ','PBasset000000000000002','000001000001000020','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('0bx-xoL8TSXXubFuqKAoVQ','PBasset000000000000002','000001000001000021','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('taX2UYkFF21ALpFZY2rhMw','PBasset000000000000002','000001000001000022','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('K0q_N885Httqev1VCqUWxg','PBasset000000000000002','000001000001000023','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('fq1ZkYhH24R5tb96kuT10Q','PBasset000000000000002','000001000001000024','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('oHk7fAFhEEkB7dHzi0QOQA','PBasset000000000000002','000001000001000025','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('9M-lrlPQWeeNWfvnDnK_Xg','PBasset000000000000002','000001000001000026','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('_gBYAdTcbkiyamnqi2Xskg','PBasset000000000000002','000001000001000027','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('GNOAsX98vCsl0JRwfwL-gg','PBasset000000000000002','000001000001000028','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('S1A9iAwKcQQ6P20uTqw-Ew','PBasset000000000000002','000001000001000029','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('-K8Hj45mbelljN9-0CXZxg','PBasset000000000000002','000001000001000030','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('lK9-YMfZ4mpc-Me-UydrFg','PBasset000000000000002','000001000001000031','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('j3P_Vvsy0OtvUJZRXC55Nw','PBasset000000000000002','000001000001000032','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('XP2W66c8vtDVpxN50Fiwww','PBasset000000000000002','000001000001000033','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('JJ-SZb9z2l_N46A0AWW7KA','PBasset000000000000002','000001000001000034','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('Cn2TOyQH3qqnQrWDrsGrxg','PBasset000000000000002','000001000001000035','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('tXwf1zaOXTvsqPn6yu-GSw','PBasset000000000000002','000001000001000036','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('GYaFxnMu9UsEG8oanwB6TA','PBasset000000000000002','000001000001000037','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('N13SD1Fpqk00UgBt1Z8ivQ','PBasset000000000000002','000001000001000038','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('tPagC0AQErZXjLFZQ6OI1g','PBasset000000000000002','000001000001000039','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('VXSsbsfcfht1904EWkb1sw','PBasset000000000000002','000001000001000040','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('AFdXZZmGnSKalNSobQMB5w','PBasset000000000000002','000001000001000041','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('3uuBf8cYuj1sew2OJXl9tg','PBasset000000000000002','000001000001000042','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('aNNC62qLAS6TB-0_MCYjsw','PBasset000000000000002','000001000001000043','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('Ov2ssJHwp_1eEWKlDyUKmg','PBasset000000000000002','000001000001000044','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('tBL7BWiQRZFed2Y-Zjo9tQ','PBasset000000000000002','000001000001000045','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('GdkQpvjRtJqtzOUbwIIQRA','PBasset000000000000002','000001000001000046','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('tnc5iYyynX2hfdEs9D3P8w','PBasset000000000000002','000001000001000047','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','997995720','3',NULL,0,NULL),('vgXdBcFTqU7h4wBG1ewdBw','PBasset000000000000002','000001000001000048','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','997995720','3',NULL,0,NULL),('hcFlqnXlsmC1ujN6Id0F0A','PBasset000000000000002','000001000001000049','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','997995720','3',NULL,0,NULL),('eRJR52fvlaxfetv3DQkQYw','PBasset000000000000002','000001000001000050','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','997995720','3',NULL,0,NULL),('5HIDHq5lAWHV5gpYGS0zLg','PBasset000000000000002','000001000001000051','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','997995720','3',NULL,0,NULL),('rYEFwXXo0tkGhQTcbDibvg','PBasset000000000000002','000001000001000052','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','997995720','3',NULL,0,NULL),('V3l5S5TtI7wMm1WpIMhvOA','PBasset000000000000002','000001000001000053','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','997995720','3',NULL,0,NULL),('nqNbSUAhk9Vd1zda2SCz9A','PBasset000000000000002','000001000001000054','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('y8XkRdxIperLKkJ3bL5sSQ','PBasset000000000000002','000001000001000055','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('e-WvgcKROPCoHwiiHLktCg','PBasset000000000000002','000001000001000056','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('LdiozcIUciWuvt3Z-na5Ww','PBasset000000000000002','000001000001000057','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('cj2y4papTVGZRFdwTI-_fw','PBasset000000000000002','000001000001000058','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('bBzO4CWjqU_ile3gf5Iypw','PBasset000000000000002','000001000001000059','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('BFfNj5wA9bDw8H3cnr8pTw','PBasset000000000000002','000001000001000060','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('AgyFhx3eXlfZXNp2MkrsiQ','PBasset000000000000002','000001000001000061','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('F7MAQ-cpuvQ1KuC7J4P5zQ','PBasset000000000000002','000001000001000062','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('jEz8iTGNWEt2I05IhVV19Q','PBasset000000000000002','000001000001000063','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('VZK3CRgiMb8r4dBjUmCTgQ','PBasset000000000000002','000001000001000064','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('TYo2Bwl7aafzTtdHlS-arQ','PBasset000000000000002','000001000001000065','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('9A-mg2gwWmaYi9o_1C7ArQ','PBasset000000000000002','000001000001000066','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('yD1SMHelczihzjEmx6eXBA','PBasset000000000000002','000001000001000067','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('pV7GnZdpjR3XpZaSINIoeg','PBasset000000000000002','000001000001000068','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('71e17KeduiXgODLMlUxiow','PBasset000000000000002','000001000001000069','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('Ik9HHky10DIyFTKehUD1dw','PBasset000000000000002','000001000001000070','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('f_tn9FfoSfKWX43F83v_3w','PBasset000000000000002','000001000001000071','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('Da6KWn805L4B5e4HFgQRQA','PBasset000000000000002','000001000001000072','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('GnrXtoFFeXia3vDQuSHojw','PBasset000000000000002','000001000001000073','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('k8vxD4fuKKf5cGwNTw0sLw','PBasset000000000000002','000001000001000074','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('bbiA9Zq5Gy2oCFBlILO3QA','PBasset000000000000002','000001000001000075','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('Efe2W0UgrSRDltNJ87jlfg','PBasset000000000000002','000001000001000076','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('RrV4aAPnn4dM0ZcU3OXnlw','PBasset000000000000002','000001000001000077','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('5bnNzteN7w3NnK9mF4XiCg','PBasset000000000000002','000001000001000078','published','WebGUI::Asset::Wobject::Folder',1147642481,'3','997995720','3',NULL,0,NULL),('oGfxez5sksyB_PcaAsEm_Q','PBasset000000000000002','000001000001000079','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('vTymIDYL2YqEh6PV50F7ew','PBasset000000000000002','000001000001000080','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('lo1ac3BsoJx3ijGQ3gR-bQ','PBasset000000000000002','000001000001000081','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('huASapWvFDzqwOSbcN-JFQ','PBasset000000000000002','000001000001000082','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('9wKWdum0_8z-OhhquWLtSQ','PBasset000000000000002','000001000001000083','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('5YAbuwiVFUx-z8hcOAnsdQ','PBasset000000000000002','000001000001000084','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('CSN-ZON7Uwv8kxf3F1fh5Q','PBasset000000000000002','000001000001000085','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('NYr6iP4pQaPRYqEYMryv4w','PBasset000000000000002','000001000001000086','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('TCtybxdqmdwdvRn555zpCQ','PBasset000000000000002','000001000001000087','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000070','7.0-style0000000000049','000001000001000090000021','published','WebGUI::Asset::Wobject::Navigation',1147642510,'3','997995720','3',NULL,0,NULL),('7.0-style0000000000071','7.0-style0000000000049','000001000001000090000022','published','WebGUI::Asset::File::Image',1147642511,'3','997995720','3',NULL,0,NULL),('sMuqO3Ynl6Lyn5fa2SsGmQ','PBasset000000000000002','000001000001000092','published','WebGUI::Asset::Wobject::Folder',1147962058,'3','997995720','3',NULL,0,NULL),('ImvgaAritVaOLmogG8fCJQ','PBasset000000000000002','000001000001000093','published','WebGUI::Asset::Wobject::Folder',1148579524,'3','997995720','3',NULL,0,NULL),('PBnav00000000000bullet','ImvgaAritVaOLmogG8fCJQ','000001000001000093000001','published','WebGUI::Asset::Template',1148579524,'3','997995720','3',NULL,0,NULL),('PBnav00000000indentnav','ImvgaAritVaOLmogG8fCJQ','000001000001000093000002','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table125','ImvgaAritVaOLmogG8fCJQ','000001000001000093000003','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table094','ImvgaAritVaOLmogG8fCJQ','000001000001000093000004','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table131','ImvgaAritVaOLmogG8fCJQ','000001000001000093000005','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table135','ImvgaAritVaOLmogG8fCJQ','000001000001000093000006','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table118','ImvgaAritVaOLmogG8fCJQ','000001000001000093000007','published','WebGUI::Asset::Template',1148579525,'3','997995720','3',NULL,0,NULL),('kDuc6TCa6cWZ_jdrIMFKRg','PBasset000000000000002','000001000001000094','published','WebGUI::Asset::Wobject::Folder',1154535074,'3','997995720','3',NULL,0,NULL),('PBtmpl000000000table54','kDuc6TCa6cWZ_jdrIMFKRg','000001000001000094000001','published','WebGUI::Asset::Template',1154535074,'3','997995720','3',NULL,0,NULL),('PBtmpl00000000table109','kDuc6TCa6cWZ_jdrIMFKRg','000001000001000094000002','published','WebGUI::Asset::Template',1154535074,'3','997995720','3',NULL,0,NULL),('BmLaN4rmAANkCglXUViEbg','PBasset000000000000002','000001000001000095','published','WebGUI::Asset::Wobject::Folder',1157679165,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0006','BmLaN4rmAANkCglXUViEbg','000001000001000095000001','published','WebGUI::Asset::Template',1157679165,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0005','BmLaN4rmAANkCglXUViEbg','000001000001000095000002','published','WebGUI::Asset::Template',1157679165,'3','997995720','3',NULL,0,NULL),('Q4uX_C557arTp6D_jwB1jQ','PBasset000000000000002','000001000001000096','published','WebGUI::Asset::Wobject::Folder',1165460175,'3','997995720','3',NULL,0,NULL),('WikiRCTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000001','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiFrontTmpl000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000002','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiSearchTmpl00000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000003','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiPHTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000004','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiPageTmpl0000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000005','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiPageEditTmpl000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000006','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarWeek0000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000007','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('WikiMPTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000008','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarDay00000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000009','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarEvent000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000010','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarEventEdit00001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000011','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarMonth000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000012','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('CalendarSearch00000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000096000013','published','WebGUI::Asset::Template',1165460175,'3','997995720','3',NULL,0,NULL),('u2mB-2nJbDsfBinXJyjAcQ','PBasset000000000000002','000001000001000097','published','WebGUI::Asset::Wobject::Folder',1166718668,'3','997995720','3',NULL,0,NULL),('CalendarPrintEvent0001','u2mB-2nJbDsfBinXJyjAcQ','000001000001000097000001','published','WebGUI::Asset::Template',1166718668,'3','997995720','3',NULL,0,NULL),('CalendarPrintMonth0001','u2mB-2nJbDsfBinXJyjAcQ','000001000001000097000002','published','WebGUI::Asset::Template',1166718668,'3','997995720','3',NULL,0,NULL),('CalendarPrintWeek00001','u2mB-2nJbDsfBinXJyjAcQ','000001000001000097000003','published','WebGUI::Asset::Template',1166718668,'3','997995720','3',NULL,0,NULL),('CalendarPrintDay000001','u2mB-2nJbDsfBinXJyjAcQ','000001000001000097000004','published','WebGUI::Asset::Template',1166718668,'3','997995720','3',NULL,0,NULL),('0Q41OuxKgi0aAJd4Xbas2Q','PBasset000000000000002','000001000001000098','published','WebGUI::Asset::Wobject::Folder',1171466654,'3','997995720','3',NULL,0,NULL),('SQLReportDownload0001','0Q41OuxKgi0aAJd4Xbas2Q','000001000001000098000001','published','WebGUI::Asset::Template',1171466654,'3','997995720','3',NULL,0,NULL);
CREATE TABLE `assetData` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `revisedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `tagId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `status` varchar(35) NOT NULL default 'pending',
  `title` varchar(255) NOT NULL default 'untitled',
  `menuTitle` varchar(255) NOT NULL default 'untitled',
  `url` varchar(255) NOT NULL default '',
  `ownerUserId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupIdView` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupIdEdit` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `synopsis` text,
  `newWindow` int(11) NOT NULL default '0',
  `isHidden` int(11) NOT NULL default '0',
  `isPackage` int(11) NOT NULL default '0',
  `isPrototype` int(11) NOT NULL default '0',
  `encryptPage` int(11) NOT NULL default '0',
  `assetSize` int(11) NOT NULL default '0',
  `extraHeadTags` text,
  `skipNotification` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `assetId_url` (`assetId`,`url`),
  KEY `assetId_revisionDate_status_tagId` (`assetId`,`revisionDate`,`status`,`tagId`),
  KEY `url` (`url`),
  KEY `assetId_status_tagId_revisionDate` (`assetId`,`status`,`tagId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `assetData` VALUES ('PBasset000000000000001',1124395696,'3','pbversion0000000000001','approved','Root','Root','root','3','7','3',NULL,0,1,0,0,0,142,NULL,0),('PBasset000000000000002',1124395696,'3','pbversion0000000000001','approved','Import Node','Import','root/import','3','7','12',NULL,0,1,0,0,0,269,NULL,0),('68sKwDgf9cGH58-NZcU4lg',1124395696,'3','pbversion0000000000001','approved','Home','Home','home','3','7','3',NULL,0,0,0,0,0,532,'',0),('_iHetEvMQUOoxS-T2CM0sQ',1124395696,'3','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started','3','7','3','',0,0,0,0,0,567,'',0),('8Bb8gu-me2mhL3ljFyiWLg',1124395696,'3','pbversion0000000000001','approved','What should you do next?','Your Next Step','your_next_step','3','7','3','',0,0,0,0,0,478,'',0),('Vzv1pWpg_w6R_o-b0rM2qQ',1147642515,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Ad','Ad','home/ad2','3','7','4',NULL,0,1,0,0,0,247,NULL,0),('NK8bqlwVRILJknqeCDPBHg',1147642515,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Getting Started (part 2)','Getting Started (part 2)','getting_started/getting-started-part2','3','7','4',NULL,0,1,0,0,0,523,NULL,0),('6QuS-0rosuZTdTv11fobig',1147642515,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Talk to the Experts','Talk to the Experts','yns/experts','3','7','4',NULL,0,1,0,0,0,668,NULL,0),('FOvmwGC0GtZo5VTxJIL3OA',1147642515,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Documentation','Get Documentation','yns/docs','3','7','4',NULL,0,1,0,0,0,697,NULL,0),('ix1p0AbwKAz8QWB-T-HHfg',1147642516,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Support','Get Support','yns/support','3','7','4',NULL,0,1,0,0,0,701,NULL,0),('iCYOjohB9SKvAPr6bXElKA',1147642516,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Hosting','Get Hosting','yns/hosting','3','7','4',NULL,0,1,0,0,0,688,NULL,0),('4Yfz9hqBqM8OYMGuQK8oLw',1147642516,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Features','Get Features','yns/features','3','7','4',NULL,0,1,0,0,0,737,NULL,0),('Wl8WZ43g2rK5AYr9o4zY7w',1147642516,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Style','Get Style','yns/style','3','7','4',NULL,0,1,0,0,0,570,NULL,0),('LBuiKzg2mWwmOPS9AgV3bg',1147642517,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Translated','Get Translated','yns/translated','3','7','4',NULL,0,1,0,0,0,693,NULL,0),('jTNggl7AoVSUc_ZzrvuCmw',1147642517,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Get Promoted','Get Promoted','yns/promotion','3','7','4',NULL,0,1,0,0,0,686,NULL,0),('2TqQc4OISddWCZmRY1_m8A',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news','3','7','3','',0,0,0,0,0,569,'',0),('fK-HMSboA3uu0c1KYkYspA',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news/the_latest_news','3','7','3',NULL,0,1,0,0,0,552,NULL,0),('Swf6L8poXKc7hUaNPkBevw',1124395696,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend','3','7','3','',0,0,0,0,0,563,'',0),('Szs5eev3OMssmnsyLRZmWA',1124395696,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend/tell_a_friend','3','7','3',NULL,0,1,0,0,0,472,NULL,0),('x3OFY6OJh_qsXkZfPwug4A',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map','3','7','3','',0,0,0,0,0,548,'',0),('pJd5TLAjfWMVXD6sCRLwUg',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map/site_map','3','7','3',NULL,0,1,0,0,0,440,NULL,0),('7.0-style0000000000003',1147642492,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','css01.css','css01.css','style1/css01.css','3','7','12',NULL,0,0,0,0,0,4896,NULL,0),('PBnav00000000000000001',1124395696,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail','3','7','12',NULL,0,1,0,0,0,516,NULL,0),('PBnav00000000000000014',1124395696,'3','pbversion0000000000001','approved','FlexMenu','FlexMenu','flexmenu','3','7','12',NULL,0,1,0,0,0,498,NULL,0),('PBnav00000000000000015',1124395696,'3','pbversion0000000000001','approved','currentMenuVertical','currentMenuVertical','currentmenuvertical','3','7','12',NULL,0,1,0,0,0,539,NULL,0),('PBnav00000000000000016',1124395696,'3','pbversion0000000000001','approved','currentMenuHorizontal','currentMenuHorizontal','currentmenuhorizontal','3','7','12',NULL,0,1,0,0,0,545,NULL,0),('PBnav00000000000000017',1124395696,'3','pbversion0000000000001','approved','PreviousDropMenu','PreviousDropMenu','previousdropmenu','3','7','12',NULL,0,1,0,0,0,533,NULL,0),('PBnav00000000000000018',1124395696,'3','pbversion0000000000001','approved','previousMenuVertical','previousMenuVertical','previousmenuvertical','3','7','12',NULL,0,1,0,0,0,543,NULL,0),('PBnav00000000000000019',1124395696,'3','pbversion0000000000001','approved','previousMenuHorizontal','previousMenuHorizontal','previousmenuhorizontal','3','7','12',NULL,0,1,0,0,0,549,NULL,0),('PBnav00000000000000020',1124395696,'3','pbversion0000000000001','approved','rootmenu','rootmenu','rootmenu','3','7','12',NULL,0,1,0,0,0,500,NULL,0),('PBnav00000000000000021',1124395696,'3','pbversion0000000000001','approved','SpecificDropMenu','SpecificDropMenu','specificdropmenu','3','7','12',NULL,0,1,0,0,0,524,NULL,0),('PBnav00000000000000002',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuVertical','SpecificSubMenuVertical','specificsubmenuvertical','3','7','12',NULL,0,1,0,0,0,545,NULL,0),('PBnav00000000000000006',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal','specificsubmenuhorizontal','3','7','12',NULL,0,1,0,0,0,551,NULL,0),('PBnav00000000000000007',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuVertical','TopLevelMenuVertical','toplevelmenuvertical','3','7','12',NULL,0,1,0,0,0,536,NULL,0),('PBnav00000000000000008',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuHorizontal','TopLevelMenuHorizontal','toplevelmenuhorizontal','3','7','12',NULL,0,1,0,0,0,542,NULL,0),('PBnav00000000000000009',1124395696,'3','pbversion0000000000001','approved','RootTab','RootTab','roottab','3','7','12',NULL,0,1,0,0,0,497,NULL,0),('PBnav00000000000000010',1124395696,'3','pbversion0000000000001','approved','TopDropMenu','TopDropMenu','topdropmenu','3','7','12',NULL,0,1,0,0,0,483,NULL,0),('PBnav00000000000000011',1124395696,'3','pbversion0000000000001','approved','dtree','dtree','dtree','3','7','12',NULL,0,1,0,0,0,497,NULL,0),('PBnav00000000000000012',1124395696,'3','pbversion0000000000001','approved','coolmenu','coolmenu','coolmenu','3','7','12',NULL,0,1,0,0,0,501,NULL,0),('PBnav00000000000000013',1124395696,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis','3','7','12',NULL,0,1,0,0,0,512,NULL,0),('7.0-style0000000000006',1147642493,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_bg.gif','main_bg.gif','style1/main_bg.gif','3','7','12',NULL,0,0,0,0,0,1990,NULL,0),('PBtmpl0000000000000210',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Request Tracker','Request Tracker','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,2800,NULL,0),('PBtmpl0000000000000209',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Request Tracker Post','Request Tracker Post','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,10633,NULL,0),('PBrichedit000000000002',1124395696,'3','pbversion0000000000001','approved','Forum Rich Edit','Forum Rich Edit','forum_rich_edit','3','7','12',NULL,0,0,0,0,0,246,NULL,0),('PBtmpl0000000000000207',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Article with Files','Article with Files','article-with-files','3','7','12',NULL,0,0,0,0,0,1644,NULL,0),('PBrichedit000000000001',1124395696,'3','pbversion0000000000001','approved','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit','content_managers_rich_edit','3','7','12',NULL,0,0,0,0,0,487,NULL,0),('7.0-style0000000000068',1147642510,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','spacer.gif','spacer.gif','style3/spacer.gif','3','7','12',NULL,0,0,0,0,0,362,NULL,0),('7.0-style0000000000066',1147642509,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg_on.jpg','nav_bg_on.jpg','style3/nav_bg_on.jpg','3','7','12',NULL,0,0,0,0,0,950,NULL,0),('7.0-style0000000000067',1147642509,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','pb.jpg','pb.jpg','style3/pb.jpg','3','7','12',NULL,0,0,0,0,0,49620,NULL,0),('7.0-style0000000000062',1147642508,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg1.jpg','nav_bg1.jpg','style3/nav_bg1.jpg','3','7','12',NULL,0,0,0,0,0,986,NULL,0),('7.0-style0000000000063',1147642508,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg1_on.jpg','nav_bg1_on.jpg','style3/nav_bg1_on.jpg','3','7','12',NULL,0,0,0,0,0,996,NULL,0),('7.0-style0000000000064',1147642509,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg2.jpg','nav_bg2.jpg','style3/nav_bg2.jpg','3','7','12',NULL,0,0,0,0,0,992,NULL,0),('7.0-style0000000000065',1147642509,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg2_on.jpg','nav_bg2_on.jpg','style3/nav_bg2_on.jpg','3','7','12',NULL,0,0,0,0,0,1006,NULL,0),('7.0-style0000000000061',1147642508,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg.jpg','nav_bg.jpg','style3/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,984,NULL,0),('7.0-style0000000000057',1147642507,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_bg.jpg','main_bg.jpg','style3/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,920,NULL,0),('7.0-style0000000000058',1147642507,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_bottom.jpg','main_bottom.jpg','style3/main_bottom.jpg','3','7','12',NULL,0,0,0,0,0,4884,NULL,0),('7.0-style0000000000059',1147642507,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_top.jpg','main_top.jpg','style3/main_top.jpg','3','7','12',NULL,0,0,0,0,0,8992,NULL,0),('7.0-style0000000000060',1147642508,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_top_bg.jpg','main_top_bg.jpg','style3/main_top_bg.jpg','3','7','12',NULL,0,0,0,0,0,1000,NULL,0),('7.0-style0000000000054',1147642506,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','header_bg.jpg','header_bg.jpg','style3/header_bg.jpg','3','7','12',NULL,0,0,0,0,0,1064,NULL,0),('7.0-style0000000000055',1147642506,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','header_left.jpg','header_left.jpg','style3/header_left.jpg','3','7','12',NULL,0,0,0,0,0,47588,NULL,0),('7.0-style0000000000056',1147642506,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','header_right.jpg','header_right.jpg','style3/header_right.jpg','3','7','12',NULL,0,0,0,0,0,49132,NULL,0),('7.0-style0000000000053',1147642505,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','footer_right.jpg','footer_right.jpg','style3/footer_right.jpg','3','7','12',NULL,0,0,0,0,0,5392,NULL,0),('stevecoolmenu000000001',1147642505,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Newer Coolmenu','Newer Coolmenu','newer-coolmenu','3','7','12',NULL,0,0,0,0,0,7085,NULL,0),('7.0-style0000000000051',1147642505,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,2613,NULL,0),('7.0-style0000000000052',1147642505,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','footer_bg.jpg','footer_bg.jpg','style3/footer_bg.jpg','3','7','12',NULL,0,0,0,0,0,994,NULL,0),('7.0-style0000000000048',1147642504,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','wg.jpg','wg.jpg','style2/wg.jpg','3','7','12',NULL,0,0,0,0,0,41300,NULL,0),('7.0-style0000000000049',1147642504,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','WebGUI 7 Style 3','WebGUI 7 Style 3','root/import/webgui-7-style-3','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('7.0-style0000000000046',1147642504,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','rightCol_bg.jpg','rightCol_bg.jpg','style2/rightcol_bg.jpg','3','7','12',NULL,0,0,0,0,0,1118,NULL,0),('stevestyle000000000002',1147642504,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style 02','Style 02','style_02','3','7','12',NULL,0,0,0,0,0,2597,NULL,0),('7.0-style0000000000043',1147642503,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','pb.jpg','pb.jpg','style2/pb.jpg','3','7','12',NULL,0,0,0,0,0,45606,NULL,0),('7.0-style0000000000044',1147642503,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','pb_wg.jpg','pb_wg.jpg','style2/pb_wg.jpg','3','7','12',NULL,0,0,0,0,0,5140,NULL,0),('7.0-style0000000000040',1147642502,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','navbar_right.jpg','navbar_right.jpg','style2/navbar_right.jpg','3','7','12',NULL,0,0,0,0,0,1594,NULL,0),('7.0-style0000000000041',1147642502,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','page_title.jpg','page_title.jpg','style2/page_title.jpg','3','7','12',NULL,0,0,0,0,0,49390,NULL,0),('7.0-style0000000000042',1147642502,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','page_title_bg.jpg','page_title_bg.jpg','style2/page_title_bg.jpg','3','7','12',NULL,0,0,0,0,0,1110,NULL,0),('7.0-style0000000000038',1147642501,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','navbar_bg.jpg','navbar_bg.jpg','style2/navbar_bg.jpg','3','7','12',NULL,0,0,0,0,0,936,NULL,0),('7.0-style0000000000039',1147642502,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','navbar_left.jpg','navbar_left.jpg','style2/navbar_left.jpg','3','7','12',NULL,0,0,0,0,0,1004,NULL,0),('7.0-style0000000000036',1147642501,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_bg.jpg','main_bg.jpg','style2/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1222,NULL,0),('7.0-style0000000000037',1147642501,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg.jpg','nav_bg.jpg','style2/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,902,NULL,0),('7.0-style0000000000033',1147642500,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','css02.css','css02.css','style2/css02.css','3','7','12',NULL,0,0,0,0,0,3061,NULL,0),('7.0-style0000000000034',1147642500,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','leftCol_header.jpg','leftCol_header.jpg','style2/leftcol_header.jpg','3','7','12',NULL,0,0,0,0,0,21636,NULL,0),('7.0-style0000000000035',1147642501,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','leftCol_header02.jpg','leftCol_header02.jpg','style2/leftcol_header02.jpg','3','7','12',NULL,0,0,0,0,0,8868,NULL,0),('7.0-style0000000000030',1147642499,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','webgui_btn.jpg','webgui_btn.jpg','style1/webgui_btn.jpg','3','7','12',NULL,0,0,0,0,0,10040,NULL,0),('7.0-style0000000000031',1147642500,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','WebGUI 7 Style 2','WebGUI 7 Style 2','root/import/webgui-7-style-2','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('7.0-style0000000000032',1147642500,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','context_bg.jpg','context_bg.jpg','style2/context_bg.jpg','3','7','12',NULL,0,0,0,0,0,1004,NULL,0),('PBnav000000style01lvl2',1147642499,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style 01 Nav lvl2','untitled','style1_nav_lvl2','3','7','12',NULL,0,0,0,0,0,1001,NULL,0),('7.0-style0000000000026',1147642499,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','RootTab Level 1','RootTab Level 1','roottab_level1','3','7','12',NULL,0,0,0,0,0,317,NULL,0),('stevestyle000000000001',1147642499,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style 01','Style 01','style_01','3','7','12',NULL,0,0,0,0,0,1612,NULL,0),('stevenav00000000000001',1147642499,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style 01 Nav','Style 01 Nav','style1_nav','3','7','12',NULL,0,0,0,0,0,981,NULL,0),('7.0-style0000000000025',1147642498,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','RootTab Level 0','RootTab Level 0','roottab_level0','3','7','12',NULL,0,0,0,0,0,317,NULL,0),('7.0-style0000000000022',1147642497,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_bg.jpg','nav_bg.jpg','style1/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,1914,NULL,0),('7.0-style0000000000023',1147642498,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav_on.jpg','nav_on.jpg','style1/nav_on.jpg','3','7','12',NULL,0,0,0,0,0,1536,NULL,0),('7.0-style0000000000024',1147642498,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','orange_left01.jpg','orange_left01.jpg','style1/orange_left01.jpg','3','7','12',NULL,0,0,0,0,0,5810,NULL,0),('7.0-style0000000000018',1147642496,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_off_left.jpg','nav2_off_left.jpg','style1/nav2_off_left.jpg','3','7','12',NULL,0,0,0,0,0,1174,NULL,0),('7.0-style0000000000019',1147642497,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_off_right.jpg','nav2_off_right.jpg','style1/nav2_off_right.jpg','3','7','12',NULL,0,0,0,0,0,1162,NULL,0),('7.0-style0000000000017',1147642496,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_off_center.jpg','nav2_off_center.jpg','style1/nav2_off_center.jpg','3','7','12',NULL,0,0,0,0,0,1336,NULL,0),('7.0-style0000000000015',1147642496,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_on_right.jpg','nav1_on_right.jpg','style1/nav1_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1936,NULL,0),('7.0-style0000000000014',1147642495,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_on_left.jpg','nav1_on_left.jpg','style1/nav1_on_left.jpg','3','7','12',NULL,0,0,0,0,0,2062,NULL,0),('7.0-style0000000000013',1147642495,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_on.jpg','nav1_on.jpg','style1/nav1_on.jpg','3','7','12',NULL,0,0,0,0,0,4544,NULL,0),('7.0-style0000000000011',1147642495,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_off_left.jpg','nav1_off_left.jpg','style1/nav1_off_left.jpg','3','7','12',NULL,0,0,0,0,0,2128,NULL,0),('7.0-style0000000000012',1147642495,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_off_right.jpg','nav1_off_right.jpg','style1/nav1_off_right.jpg','3','7','12',NULL,0,0,0,0,0,2020,NULL,0),('7.0-style0000000000010',1147642494,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_off_center.jpg','nav1_off_center.jpg','style1/nav1_off_center.jpg','3','7','12',NULL,0,0,0,0,0,2596,NULL,0),('7.0-style0000000000009',1147642494,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_off.jpg','nav1_off.jpg','style1/nav1_off.jpg','3','7','12',NULL,0,0,0,0,0,4870,NULL,0),('7.0-style0000000000007',1147642493,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','main_bg.jpg','main_bg.jpg','style1/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1752,NULL,0),('7.0-style0000000000001',1147642492,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','WebGUI 7 Style 1','WebGUI 7 Style 1','root/import/webgui-7-style-1','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('SynConXSLT000000000001',1124395707,'3','pbversion0000000000002','approved','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT','xslt/rss0.9.xsl','3','7','12',NULL,0,0,0,0,0,2646,NULL,0),('SynConXSLT000000000002',1124395707,'3','pbversion0000000000002','approved','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT','xslt/rss0.91.xsl','3','7','12',NULL,0,0,0,0,0,2485,NULL,0),('SynConXSLT000000000003',1124395707,'3','pbversion0000000000002','approved','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT','xslt/rss1.0.xsl','3','7','12',NULL,0,0,0,0,0,2718,NULL,0),('SynConXSLT000000000004',1124395707,'3','pbversion0000000000002','approved','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT','xslt/rss2.0.xsl','3','7','12',NULL,0,0,0,0,0,2551,NULL,0),('PBtmpl0000000000000090',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','DHTML Admin Bar','DHTML Admin Bar','dhtml_admin_bar','3','7','12',NULL,0,1,0,0,0,856,NULL,0),('PBtmpl0000000000000014',1129049185,'3','pbversion0000000000002','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,1148,NULL,0),('PBtmpl0000000000000015',1129049185,'3','pbversion0000000000002','approved','Default cancel checkout template','Default cancel checkout template','default_cancel_checkout_template','3','7','12',NULL,0,1,0,0,0,340,NULL,0),('PBtmpl0000000000000016',1129049185,'3','pbversion0000000000002','approved','Default checkout confirmation template','Default checkout confirmation template','default_checkout_confirmation_template','3','7','12',NULL,0,1,0,0,0,2085,NULL,0),('PBtmpl0000000000000027',1129049185,'3','pbversion0000000000002','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,362,NULL,0),('PBtmpl0000000000000036',1129049186,'3','pbversion0000000000002','approved','Default Admin Toggle Macro','Default Admin Toggle Macro','default_admin_toggle_macro','3','7','12',NULL,0,1,0,0,0,354,NULL,0),('PBtmpl0000000000000037',1129049186,'3','pbversion0000000000002','approved','Default Account Macro','Default Account Macro','default_account_macro','3','7','12',NULL,0,1,0,0,0,361,NULL,0),('PBtmpl0000000000000038',1129049186,'3','pbversion0000000000002','approved','Default Editable Toggle Macro','Default Editable Toggle Macro','default_editable_toggle_macro','3','7','12',NULL,0,1,0,0,0,366,NULL,0),('PBtmpl0000000000000040',1129049186,'3','pbversion0000000000002','approved','Default Group Add Macro','Default Group Add Macro','default_group_add_macro','3','7','12',NULL,0,1,0,0,0,340,NULL,0),('PBtmpl0000000000000041',1129049186,'3','pbversion0000000000002','approved','Default Group Delete Macro','Default Group Delete Macro','default_group_delete_macro','3','7','12',NULL,0,1,0,0,0,352,NULL,0),('PBtmpl0000000000000042',1129049186,'3','pbversion0000000000002','approved','Default Homelink','Default Homelink','default_homelink','3','7','12',NULL,0,1,0,0,0,344,NULL,0),('PBtmpl0000000000000043',1129049186,'3','pbversion0000000000002','approved','Default LoginToggle','Default LoginToggle','default_logintoggle','3','7','12',NULL,0,1,0,0,0,357,NULL,0),('PBtmpl0000000000000045',1129049186,'3','pbversion0000000000002','approved','Default Make Printable','Default Make Printable','default_make_printable','3','7','12',NULL,0,1,0,0,0,374,NULL,0),('PBtmpl0000000000000206',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Inbox','Default Inbox','default_inbox','3','7','12',NULL,0,0,0,0,0,1258,NULL,0),('PBtmpl0000000000000205',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Inbox Message','Default Inbox Message','default_inbox_message','3','7','12',NULL,0,0,0,0,0,553,NULL,0),('PBtmpl0000000000000208',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Request Tracker','Request Tracker','request-tracker-template','3','7','12',NULL,0,0,0,0,0,3606,NULL,0),('PBtmpl0000000000000053',1129049187,'3','pbversion0000000000002','approved','Subscription code redemption','Subscription code redemption','subscription_code_redemption','3','7','12',NULL,0,1,0,0,0,435,NULL,0),('PBtmpl0000000000000085',1129049188,'3','pbversion0000000000002','approved','Default Email','Default Email','default_email','3','7','12',NULL,0,1,0,0,0,376,NULL,0),('PBtmpl0000000000000091',1129049189,'3','pbversion0000000000002','approved','File no icon','File no icon','file_no_icon','3','7','12',NULL,0,1,0,0,0,301,NULL,0),('PBtmpl0000000000000132',1129049190,'3','pbversion0000000000002','approved','Empty','Empty','empty','3','7','12',NULL,0,1,0,0,0,244,NULL,0),('PBtmplVSC0000000000001',1129049191,'3','pbversion0000000000002','approved','Default Shopping Cart Template','Default Shopping Cart Template','default-shoppingcart-template','3','7','12',NULL,0,0,0,0,0,1583,NULL,0),('PBtmpl0000000000000140',1129573244,'3','pbversion0000000000002','approved','Default Shortcut','Default Shortcut','pbtmpl0000000000000140','3','7','12',NULL,0,1,0,0,0,993,NULL,0),('PBtmpl0000000000000125',1129573245,'3','pbversion0000000000002','approved','Left Column','Left Column','left_column','3','7','12',NULL,0,1,0,0,0,2108,NULL,0),('PBtmplHelp000000000001',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Help','Help','help','3','7','12',NULL,0,0,0,0,0,1283,NULL,0),('PBtmpl0000000000000034',1129573247,'3','pbversion0000000000002','approved','Default Search','Default Search','default_search','3','7','12',NULL,0,1,0,0,0,2413,NULL,0),('7.0-style0000000000071',1147642511,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','wg.jpg','wg.jpg','style3/wg.jpg','3','7','12',NULL,0,0,0,0,0,54656,NULL,0),('7.0-style0000000000070',1147642510,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style3 Coolmenu','Style3 Coolmenu','style3_coolmenu','3','7','12',NULL,0,0,0,0,0,319,NULL,0),('PBtmpl0000000000000142',1133743238,'3','pbversion0000000000002','approved','Default Forum RSS','Default Forum RSS','PBtmpl0000000000000142','3','7','12',NULL,0,1,0,0,0,718,NULL,0),('7.0-style0000000000004',1147642493,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','gui_bottom.jpg','gui_bottom.jpg','style1/gui_bottom.jpg','3','7','12',NULL,0,0,0,0,0,21700,NULL,0),('StockDataTMPL000000002',1133743239,'3','pbversion0000000000002','approved','StockData Default Display','StockData Default Display','StockDataTMPL000000002','3','7','12',NULL,0,1,0,0,0,10333,NULL,0),('ZipArchiveTMPL00000001',1133743240,'3','pbversion0000000000002','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,775,NULL,0),('7.0-style0000000000002',1147642492,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','body_bg.jpg','body_bg.jpg','style1/body_bg.jpg','3','7','12',NULL,0,0,0,0,0,890,NULL,0),('SQLFormEditTmpl0000001',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default SQLForm Edit template','Default SQLForm Edit template','default_sqlform_edit_template','3','7','12',NULL,0,0,0,0,0,846,NULL,0),('SQLFormSearchTmpl00001',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default SQLForm Search template','Default SQLForm Search template','default_sqlform_search_template','3','7','12',NULL,0,0,0,0,0,2117,NULL,0),('PBtmpl0000000000000109',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','One Over Three','One Over Three','one_over_three','3','7','12',NULL,0,1,0,0,0,3397,NULL,0),('PBtmpl0000000000000001',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,2715,NULL,0),('PBtmpl0000000000000095',1147642410,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Benefits Showcase','Benefits Showcase','benefits_showcase','3','7','12',NULL,0,1,0,0,0,2969,NULL,0),('PBtmpl0000000000000105',1147642411,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Calendar Month (Small)','Calendar Month (Small)','calendar_month_small','3','7','12',NULL,0,1,0,0,0,3219,NULL,0),('PBtmpl0000000000000084',1147642411,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Center Image','Center Image','center_image','3','7','12',NULL,0,1,0,0,0,1760,NULL,0),('PBtmpl0000000000000128',1147642411,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Classifieds','Classifieds','classifieds','3','7','12',NULL,0,1,0,0,0,1817,NULL,0),('PBtmpl0000000000000134',1147642411,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Cool Menus','Cool Menus','cool_menus','3','7','12',NULL,0,1,0,0,0,6577,NULL,0),('PBtmpl0000000000000093',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','crumbTrail','crumbTrail','crumbtrail2','3','7','12',NULL,0,1,0,0,0,760,NULL,0),('DashboardViewTmpl00001',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Dashboard Default View','Dashboard Default View','dashboard-default-view-template','3','7','12','',0,0,0,0,0,8565,'',0),('PBtmpl0000000000000021',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Data List','Data List','data_list','3','7','12',NULL,0,1,0,0,0,1122,NULL,0),('PBtmpl0000000000000104',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Acknowledgement','Default Acknowledgement','default_acknowledgement','3','7','12',NULL,0,1,0,0,0,1035,NULL,0),('PBtmpl0000000000000002',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Article','Default Article','default_article','3','7','12',NULL,0,1,0,0,0,1928,NULL,0),('PBtmpl0000000000000141',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default DataForm','Default DataForm','pbtmpl0000000000000141','3','7','12',NULL,0,1,0,0,0,3131,NULL,0),('PBtmpl0000000000000051',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Edit Profile Template','Default Edit Profile Template','default_edit_profile_template','3','7','12',NULL,0,1,0,0,0,1621,NULL,0),('EventManagerTmpl000003',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System Checkout','Default Event Management System Checkout','default-ems-template-checkout','3','7','12',NULL,0,0,0,0,0,3367,NULL,0),('EventManagerTmpl000004',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System Manage Purchases','Default Event Management System Manage Purchases','default-ems-template-manage-purchases','3','7','12',NULL,0,0,0,0,0,1199,NULL,0),('EventManagerTmpl000006',1147642412,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System Search','Default Event Management System Search','default-ems-search-template','3','7','12',NULL,0,0,0,0,0,6338,NULL,0),('EventManagerTmpl000001',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System','Default Event Management System','default-ems-template','3','7','12',NULL,0,0,0,0,0,2255,NULL,0),('EventManagerTmpl000002',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System Event','Default Event Management System Event','default-ems-template-event','3','7','12',NULL,0,0,0,0,0,1982,NULL,0),('EventManagerTmpl000005',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Event Management System View Purchase','Default Event Management System View Purchase','default-ems-template-view-purchase','3','7','12',NULL,0,0,0,0,0,2478,NULL,0),('PBtmpl0000000000000039',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default File Macro','Default File Macro','default_file_macro','3','7','12',NULL,0,1,0,0,0,422,NULL,0),('PBtmpl0000000000000026',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Forum','Default Forum','default_forum','3','7','12',NULL,0,1,0,0,0,3842,NULL,0),('PBtmpl0000000000000031',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Forum Search','Default Forum Search','default_forum_search','3','7','12',NULL,0,1,0,0,0,2124,NULL,0),('PBtmpl0000000000000062',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Gradebook Report','Default Gradebook Report','default_gradebook_report','3','7','12',NULL,0,1,0,0,0,2378,NULL,0),('DPUROtmpl0000000000001',1147642413,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Grouped Aggregate Feeds','Default Grouped Aggregate Feeds','templates/syndicatedcontent/default_grouped_feeds','3','7','12',NULL,0,1,0,0,0,1463,NULL,0),('PBtmpl0000000000000033',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default HTTP Proxy','Default HTTP Proxy','default_http_proxy','3','7','12',NULL,0,1,0,0,0,1130,NULL,0),('PBtmpl0000000000000004',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default LDAP Account Display Template','Default LDAP Account Display Template','default_ldap_account_display_template','3','7','12',NULL,0,1,0,0,0,760,NULL,0),('PBtmpl0000000000000005',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template','default_ldap_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,1513,NULL,0),('PBtmpl0000000000000006',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default LDAP Login Template','Default LDAP Login Template','default_ldap_login_template','3','7','12',NULL,0,1,0,0,0,1166,NULL,0),('PBtmpl0000000000000044',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Login Box','Default Login Box','default_login_box','3','7','12',NULL,0,1,0,0,0,1066,NULL,0),('PBtmpl0000000000000047',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Message Board','Default Message Board','default_message_board','3','7','12',NULL,0,1,0,0,0,3067,NULL,0),('PBtmpl0000000000000063',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Overview Report','Default Overview Report','default_overview_report','3','7','12',NULL,0,1,0,0,0,3515,NULL,0),('PBtmpl0000000000000054',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Page','Default Page','default_page','3','7','12',NULL,0,1,0,0,0,1142,NULL,0),('PBtmpl0000000000000017',1147642414,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default payment gateway selection template','Default payment gateway selection template','default_payment_gateway_selection_template','3','7','12',NULL,0,1,0,0,0,831,NULL,0),('ProjectManagerTMPL0004',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,2376,NULL,0),('ProjectManagerTMPL0003',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,2137,NULL,0),('ProjectManagerTMPL0002',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,20498,NULL,0),('ProjectManagerTMPL0001',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,4090,NULL,0),('PBtmpl0000000000000055',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Poll','Default Poll','default_poll','3','7','12',NULL,0,1,0,0,0,1684,NULL,0),('PBtmpl0000000000000029',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Post Form','Default Post Form','default_post_form','3','7','12',NULL,0,1,0,0,0,1882,NULL,0),('PBtmpl0000000000000056',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Product','Default Product','default_product','3','7','12',NULL,0,1,0,0,0,5773,NULL,0),('PBtmplCP00000000000001',1147642415,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Product Template','Default Product Template','default_product_template','3','7','12',NULL,0,0,0,0,0,779,NULL,0),('PBtmpl0000000000000052',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Profile Display Template','Default Profile Display Template','default_profile_display_template','3','7','12',NULL,0,1,0,0,0,1205,NULL,0),('PBtmpl0000000000000064',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Response','Default Response','default_response','3','7','12',NULL,0,1,0,0,0,1924,NULL,0),('PBtmplCSSM000000000001',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Select Shipping Method Template','Default Select Shipping Method Template','default-select-shipping-method-template','3','7','12',NULL,0,0,0,0,0,822,NULL,0),('PBtmpl0000000000000059',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default SQL Report','Default SQL Report','default_sql_report','3','7','12',NULL,0,1,0,0,0,4209,NULL,0),('PBtmpl0000000000000067',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,10964,NULL,0),('PBtmpl0000000000000068',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Submission Form','Default Submission Form','default_submission_form','3','7','12',NULL,0,1,0,0,0,2621,NULL,0),('PBtmpl0000000000000061',1147642416,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Survey','Default Survey','default_survey','3','7','12',NULL,0,1,0,0,0,4640,NULL,0),('PBtmpl0000000000000065',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Syndicated Content','Default Syndicated Content','default_syndicated_content','3','7','12',NULL,0,1,0,0,0,1034,NULL,0),('PBtmpl0000000000000032',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,7705,NULL,0),('PBtmpl0000000000000018',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default transaction error template','Default transaction error template','default_transaction_error_template','3','7','12',NULL,0,1,0,0,0,818,NULL,0),('TimeTrackingTMPL000002',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Time Tracking Manager View','Default Time Tracking Manager View','default-tt-template-manager','3','7','12',NULL,0,0,0,0,0,360,NULL,0),('TimeTrackingTMPL000003',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,1795,NULL,0),('TimeTrackingTMPL000001',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,1267,NULL,0),('PBtmpl0000000000000066',1147642417,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default USS','Default USS','default_uss','3','7','12',NULL,0,1,0,0,0,2681,NULL,0),('PBtmpl0000000000000019',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default view purchase history template','Default view purchase history template','default_view_purchase_history_template','3','7','12',NULL,0,1,0,0,0,886,NULL,0),('PBtmpl0000000000000010',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default WebGUI Account Display Template','Default WebGUI Account Display Template','default_webgui_account_display_template','3','7','12',NULL,0,1,0,0,0,1462,NULL,0),('PBtmpl0000000000000011',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template','default_webgui_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,1936,NULL,0),('PBtmpl0000000000000013',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default WebGUI Login Template','Default WebGUI Login Template','default_webgui_login_template','3','7','12',NULL,0,1,0,0,0,1320,NULL,0),('PBtmpl0000000000000012',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template','default_webgui_password_reset_template','3','7','12',NULL,0,1,0,0,0,1260,NULL,0),('PBtmpl0000000000000057',1147642418,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt','default_webgui_yes/no_prompt','3','7','12',NULL,0,1,0,0,0,554,NULL,0),('PBtmpl0000000000000117',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','DropMenu','DropMenu','dropmenu','3','7','12',NULL,0,1,0,0,0,1031,NULL,0),('PBtmpl0000000000000130',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','dtree','dtree','dtree2','3','7','12',NULL,0,1,0,0,0,1136,NULL,0),('PBtmpl0000000000000086',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Events List','Events List','events_list','3','7','12',NULL,0,1,0,0,0,2370,NULL,0),('PBtmpl0000000000000060',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Fail Safe','Fail Safe','fail_safe','3','7','12',NULL,0,1,0,0,0,1239,NULL,0),('PBtmpl0000000000000080',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','FAQ','FAQ','faq','3','7','12','',0,1,0,0,0,2056,'',0),('PBtmpl0000000000000099',1147642419,'3','0TD-_gW8MXYYY1elfaIq8A','approved','FAQ Submission Form','FAQ Submission Form','faq_submission_form','3','7','12',NULL,0,1,0,0,0,2160,NULL,0),('PBtmpl0000000000000024',1147642420,'3','0TD-_gW8MXYYY1elfaIq8A','approved','File','File','file','3','7','12',NULL,0,1,0,0,0,470,NULL,0),('PBtmpl0000000000000078',1147642420,'3','0TD-_gW8MXYYY1elfaIq8A','approved','File Folder','File Folder','file_folder','3','7','12','',0,1,0,0,0,1947,'',0),('PBtmpl0000000000000107',1147642420,'3','0TD-_gW8MXYYY1elfaIq8A','approved','File with size','File with size','file_with_size','3','7','12',NULL,0,1,0,0,0,459,NULL,0),('PBtmpl0000000000000100',1147642420,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Google: doGoogleSearch','Google: doGoogleSearch','google_dogooglesearch','3','7','12',NULL,0,1,0,0,0,1646,NULL,0),('PBtmpl0000000000000133',1147642420,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Guest Book','Guest Book','guest_book','3','7','12',NULL,0,1,0,0,0,1525,NULL,0),('PBtmpl0000000000000092',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Horizontal Login Box','Horizontal Login Box','horizontal_login_box','3','7','12',NULL,0,1,0,0,0,1152,NULL,0),('PBtmpl0000000000000108',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','horizontalMenu','horizontalMenu','horizontalmenu','3','7','12',NULL,0,1,0,0,0,778,NULL,0),('PBtmpl0000000000000088',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Image','Image','image','3','7','12',NULL,0,1,0,0,0,393,NULL,0),('IOB0000000000000000002',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default InOutBoard Report Template','Default InOutBoard Report Template','iob-report-template','3','7','12',NULL,0,0,0,0,0,1593,NULL,0),('IOB0000000000000000001',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,2120,NULL,0),('PBtmpl0000000000000123',1147642421,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Item','Item','item','3','7','12',NULL,0,1,0,0,0,890,NULL,0),('PBtmpl0000000000000129',1147642422,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Item w/pop-up Links','Item w/pop-up Links','item_w/pop-up_links','3','7','12',NULL,0,1,0,0,0,963,NULL,0),('PBtmpl0000000000000098',1147642422,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,10015,NULL,0),('PBtmpl0000000000000077',1147642422,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Job Listing','Job Listing','job_listing','3','7','12',NULL,0,1,0,0,0,2544,NULL,0),('PBtmpl0000000000000122',1147642422,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Job Submission Form','Job Submission Form','job_submission_form','3','7','12',NULL,0,1,0,0,0,3266,NULL,0),('PBtmpl0000000000000103',1147642422,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Left Align Image','Left Align Image','left_align_image','3','7','12',NULL,0,1,0,0,0,1948,NULL,0),('PBtmpl0000000000000119',1147642423,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Left Column Collateral','Left Column Collateral','left_column_collateral','3','7','12',NULL,0,1,0,0,0,3265,NULL,0),('PBtmpl0000000000000113',1147642423,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,9607,NULL,0),('PBtmpl0000000000000083',1147642423,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Link List','Link List','link_list','3','7','12',NULL,0,1,0,0,0,1994,NULL,0),('PBtmpl0000000000000114',1147642423,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Link List Submission Form','Link List Submission Form','link_list_submission_form','3','7','12',NULL,0,1,0,0,0,2767,NULL,0),('PBtmpl0000000000000115',1147642423,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Linked Image with Caption','Linked Image with Caption','linked_image_with_caption','3','7','12',NULL,0,1,0,0,0,2134,NULL,0),('PBtmpl0000000000000020',1147642424,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Mail Form','Mail Form','mail_form','3','7','12',NULL,0,1,0,0,0,2239,NULL,0),('PBtmpl0000000000000111',1147642424,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Make Page Printable','Make Page Printable','make_page_printable','3','7','12',NULL,0,1,0,0,0,2080,NULL,0),('matrixtmpl000000000002',1147642424,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Matrix Default Compare','Matrix Default Compare','matrix-default-compare-template','3','7','12',NULL,0,0,0,0,0,2224,NULL,0),('matrixtmpl000000000003',1147642424,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,2992,NULL,0),('matrixtmpl000000000001',1147642424,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Matrix Default View','Matrix Default View','matrix-default-view-template','3','7','12',NULL,0,0,0,0,0,4231,NULL,0),('matrixtmpl000000000004',1147642425,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Matrix Default Rating Detail','Matrix Default Rating Detail','matrix-rating-detail-template','3','7','12',NULL,0,0,0,0,0,925,NULL,0),('matrixtmpl000000000005',1147642425,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Matrix Default Search','Matrix Default Search','matrix-search-template','3','7','12',NULL,0,0,0,0,0,2470,NULL,0),('MultiSearchTmpl0000001',1147642425,'3','0TD-_gW8MXYYY1elfaIq8A','approved','MultiSearch Default Display','MultiSearch Default Display','multisearchtmpl0000001','3','7','12',NULL,0,1,0,0,0,1885,NULL,0),('PBtmpl0000000000000094',1147642425,'3','0TD-_gW8MXYYY1elfaIq8A','approved','News','News','news','3','7','12',NULL,0,1,0,0,0,3021,NULL,0),('PBtmpl0000000000000101',1147642426,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Ordered List','Ordered List','ordered_list','3','7','12',NULL,0,1,0,0,0,2020,NULL,0),('PBtmpl0000000000000121',1147642426,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Photo Gallery','Photo Gallery','photo_gallery','3','7','12',NULL,0,1,0,0,0,1745,NULL,0),('PBtmpl0000000000000081',1147642426,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Q and A','Q and A','q_and_a','3','7','12',NULL,0,1,0,0,0,2262,NULL,0),('WVtmpl0000000000000001',1147642426,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Random Thread Macro Default Template','Random Thread Macro Default Template','randomthread-template','3','7','12',NULL,0,0,0,0,0,4763,NULL,0),('PBtmpl0000000000000131',1147642426,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Right Column','Right Column','right_column','3','7','12',NULL,0,1,0,0,0,2126,NULL,0),('PBtmpl0000000000000200',1147642427,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Default Search','Default Search','default_search2','3','7','12',NULL,0,0,0,0,0,1019,NULL,0),('PBtmpl0000000000000135',1147642427,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Side By Side','Side By Side','side_by_side','3','7','12',NULL,0,1,0,0,0,1983,NULL,0),('StockDataTMPL000000001',1147642427,'3','0TD-_gW8MXYYY1elfaIq8A','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,4953,NULL,0),('PBtmpl0000000000000137',1147642427,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Admin Console','Admin Console','admin_console','3','7','12',NULL,0,1,0,0,0,734,NULL,0),('PBtmpl0000000000000046',1147642428,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Subscriptionitem default template','Subscriptionitem default template','subscriptionitem_default_template','3','7','12',NULL,0,1,0,0,0,481,NULL,0),('GNvjCFQWjY2AF2uf0aCM8Q',1147642428,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Syndicated Articles','Syndicated Articles','syndicated_articles','3','7','12',NULL,0,1,0,0,0,1032,NULL,0),('PBtmpl0000000000000136',1147642428,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Synopsis','Synopsis','synopsis2','3','7','12',NULL,0,1,0,0,0,845,NULL,0),('PBtmpl0000000000000116',1147642428,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Tab Form','Tab Form','tab_form','3','7','12',NULL,0,1,0,0,0,2945,NULL,0),('PBtmpl0000000000000124',1147642429,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Tabs','Tabs','tabs','3','7','12',NULL,0,1,0,0,0,770,NULL,0),('PBtmpl0000000000000110',1147642429,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Three Columns','Three Columns','three_columns','3','7','12',NULL,0,1,0,0,0,4933,NULL,0),('PBtmpl0000000000000118',1147642429,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Three Over One','Three Over One','three_over_one','3','7','12',NULL,0,1,0,0,0,3359,NULL,0),('PBtmpl0000000000000079',1147642430,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Topics','Topics','topics','3','7','12',NULL,0,1,0,0,0,2575,NULL,0),('PBtmpl0000000000000097',1147642430,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,3494,NULL,0),('PBtmpl0000000000000082',1147642430,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Unordered List','Unordered List','unordered_list','3','7','12',NULL,0,1,0,0,0,2407,NULL,0),('PBtmpl0000000000000048',1147642431,'3','0TD-_gW8MXYYY1elfaIq8A','approved','verticalMenu','verticalMenu','verticalmenu','3','7','12',NULL,0,1,0,0,0,782,NULL,0),('WeatherDataTmpl0000001',1147642431,'3','0TD-_gW8MXYYY1elfaIq8A','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,1124,NULL,0),('PBtmplBlankStyle000001',1147642431,'3','0TD-_gW8MXYYY1elfaIq8A','approved','WebGUI 6 Blank Style','WebGUI 6 Blank Style','pbtmplblankstyle000001','3','7','12',NULL,0,1,0,0,0,847,NULL,0),('PBtmpl0000000000000112',1147642431,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Weblog','Weblog','weblog','3','7','12',NULL,0,1,0,0,0,2645,NULL,0),('PBtmpl0000000000000069',1147642432,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Xmethods: getTemp','Xmethods: getTemp','xmethods_gettemp','3','7','12',NULL,0,1,0,0,0,652,NULL,0),('7.0-style0000000000005',1147642493,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','header.jpg','header.jpg','style1/header.jpg','3','7','12',NULL,0,0,0,0,0,89722,NULL,0),('7.0-style0000000000008',1147642494,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav1_center_on.jpg','nav1_center_on.jpg','style1/nav1_center_on.jpg','3','7','12',NULL,0,0,0,0,0,2428,NULL,0),('pbrobot000000000000001',1147642511,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','robots.txt','robots.txt','robots.txt','3','7','12',NULL,0,0,0,0,0,292,NULL,0),('bX5rYxb6tZ9docY6sUhBlw',1147642514,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Getting Started','Getting Started','getting_started/getting-started','3','7','4',NULL,0,1,0,0,0,1413,NULL,0),('IWFxZDyGhQ3-SLZhELa3qw',1147642514,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Key Benefits','Key Benefits','home/key-benefits','3','7','4',NULL,0,1,0,0,0,2017,NULL,0),('m4YJFaqzultnB_sj1Uq0aw',1147642514,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Ad','Ad','home/ad','3','7','4',NULL,0,1,0,0,0,238,NULL,0),('stevestyle000000000003',1147642510,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Style 03','Style 03','style_03','3','7','12',NULL,0,0,0,0,0,1575,NULL,0),('7.0-style0000000000045',1147642503,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','pb_wg_bg.jpg','pb_wg_bg.jpg','style2/pb_wg_bg.jpg','3','7','12',NULL,0,0,0,0,0,43126,NULL,0),('7.0-style0000000000021',1147642497,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_on_right.jpg','nav2_on_right.jpg','style1/nav2_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1110,NULL,0),('7.0-style0000000000020',1147642497,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_on_left.jpg','nav2_on_left.jpg','style1/nav2_on_left.jpg','3','7','12',NULL,0,0,0,0,0,1138,NULL,0),('7.0-style0000000000016',1147642496,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','nav2_center_on.jpg','nav2_center_on.jpg','style1/nav2_center_on.jpg','3','7','12',NULL,0,0,0,0,0,1280,NULL,0),('PBasset000000000000003',1147642437,'3','0TD-_gW8MXYYY1elfaIq8A','approved','Media','Media','media','3','7','12',NULL,0,0,0,0,0,258,NULL,0),('OhdaFLE7sXOzo_SIP2ZUgA',1147642513,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Welcome','Welcome','home/welcome','3','7','4',NULL,0,1,0,0,0,1828,NULL,0),('pbproto000000000000001',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Photo Gallery','Photo Gallery','photo-gallery-prototype','3','7','12',NULL,0,0,0,1,0,482,NULL,0),('pbproto000000000000002',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Request Tracker','Request Tracker','request-tracker-prototype','3','7','12',NULL,0,0,0,1,0,483,NULL,0),('pbtmpl0000000000000220',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Flash Template','Flash Template','flash-template','3','7','12',NULL,0,0,0,0,0,822,NULL,0),('pbtmpl0000000000000221',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Flash Tutorial Template','Flash Tutorial Template','flash-tutorial-template','3','7','12',NULL,0,0,0,0,0,962,NULL,0),('nbSrhXZQuxIjhWFaFPSuVA',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','AdminConsole','AdminConsole','root/import/adminconsole','3','7','12',NULL,0,0,0,0,0,275,NULL,0),('TvOZs8U1kRXLtwtmyW75pg',1147642465,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Article','Article','root/import/article','3','7','12',NULL,0,0,0,0,0,260,NULL,0),('xSmREZO3GNzK3M5PaueOOQ',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/LDAP/Account','Auth/LDAP/Account','root/import/auth/ldap/account','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('0bx-xoL8TSXXubFuqKAoVQ',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/LDAP/Create','Auth/LDAP/Create','root/import/auth/ldap/create','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('taX2UYkFF21ALpFZY2rhMw',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/LDAP/Login','Auth/LDAP/Login','root/import/auth/ldap/login','3','7','12',NULL,0,0,0,0,0,284,NULL,0),('K0q_N885Httqev1VCqUWxg',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/WebGUI/Account','Auth/WebGUI/Account','root/import/auth/webgui/account','3','7','12',NULL,0,0,0,0,0,296,NULL,0),('fq1ZkYhH24R5tb96kuT10Q',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/WebGUI/Create','Auth/WebGUI/Create','root/import/auth/webgui/create','3','7','12',NULL,0,0,0,0,0,293,NULL,0),('oHk7fAFhEEkB7dHzi0QOQA',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/WebGUI/Expired','Auth/WebGUI/Expired','root/import/auth/webgui/expired','3','7','12',NULL,0,0,0,0,0,296,NULL,0),('9M-lrlPQWeeNWfvnDnK_Xg',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/WebGUI/Login','Auth/WebGUI/Login','root/import/auth/webgui/login','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('_gBYAdTcbkiyamnqi2Xskg',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Auth/WebGUI/Recovery','Auth/WebGUI/Recovery','root/import/auth/webgui/recovery','3','7','12',NULL,0,0,0,0,0,299,NULL,0),('GNOAsX98vCsl0JRwfwL-gg',1147642466,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Collaboration','Collaboration','root/import/collaboration','3','7','12',NULL,0,0,0,0,0,278,NULL,0),('S1A9iAwKcQQ6P20uTqw-Ew',1147642468,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Dashboard','Dashboard','root/import/dashboard','3','7','12',NULL,0,0,0,0,0,266,NULL,0),('-K8Hj45mbelljN9-0CXZxg',1147642468,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','DataForm','DataForm','root/import/dataform','3','7','12',NULL,0,0,0,0,0,263,NULL,0),('lK9-YMfZ4mpc-Me-UydrFg',1147642468,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','EventManagementSystem','EventManagementSystem','root/import/eventmanagementsystem','3','7','12',NULL,0,0,0,0,0,302,NULL,0),('j3P_Vvsy0OtvUJZRXC55Nw',1147642469,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','EventManagementSystem_managePurchas','EventManagementSystem_managePurchas','root/import/eventmanagementsystem_managepurchas','3','7','12',NULL,0,0,0,0,0,344,NULL,0),('XP2W66c8vtDVpxN50Fiwww',1147642469,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','EventManagementSystem_search','EventManagementSystem_search','root/import/eventmanagementsystem_search','3','7','12',NULL,0,0,0,0,0,323,NULL,0),('JJ-SZb9z2l_N46A0AWW7KA',1147642469,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','EventManagementSystem_viewPurchase','EventManagementSystem_viewPurchase','root/import/eventmanagementsystem_viewpurchase','3','7','12',NULL,0,0,0,0,0,341,NULL,0),('Cn2TOyQH3qqnQrWDrsGrxg',1147642469,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','EventsCalendar','EventsCalendar','root/import/eventscalendar','3','7','12',NULL,0,0,0,0,0,281,NULL,0),('tXwf1zaOXTvsqPn6yu-GSw',1147642469,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','FileAsset','FileAsset','root/import/fileasset','3','7','12',NULL,0,0,0,0,0,266,NULL,0),('GYaFxnMu9UsEG8oanwB6TA',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Folder','Folder','root/import/folder','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('N13SD1Fpqk00UgBt1Z8ivQ',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','HttpProxy','HttpProxy','root/import/httpproxy','3','7','12',NULL,0,0,0,0,0,266,NULL,0),('tPagC0AQErZXjLFZQ6OI1g',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ImageAsset','ImageAsset','root/import/imageasset','3','7','12',NULL,0,0,0,0,0,269,NULL,0),('VXSsbsfcfht1904EWkb1sw',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Inbox','Inbox','root/import/inbox','3','7','12',NULL,0,0,0,0,0,254,NULL,0),('AFdXZZmGnSKalNSobQMB5w',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','IndexedSearch','IndexedSearch','root/import/indexedsearch','3','7','12',NULL,0,0,0,0,0,278,NULL,0),('3uuBf8cYuj1sew2OJXl9tg',1147642470,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','InOutBoard','InOutBoard','root/import/inoutboard','3','7','12',NULL,0,0,0,0,0,269,NULL,0),('aNNC62qLAS6TB-0_MCYjsw',1147642471,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Layout','Layout','root/import/layout','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('Ov2ssJHwp_1eEWKlDyUKmg',1147642471,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/AdminBar','Macro/AdminBar','root/import/macro/adminbar','3','7','12',NULL,0,0,0,0,0,281,NULL,0),('tBL7BWiQRZFed2Y-Zjo9tQ',1147642471,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/AdminToggle','Macro/AdminToggle','root/import/macro/admintoggle','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('GdkQpvjRtJqtzOUbwIIQRA',1147642471,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/a_account','Macro/a_account','root/import/macro/a_account','3','7','12',NULL,0,0,0,0,0,284,NULL,0),('tnc5iYyynX2hfdEs9D3P8w',1147642472,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/EditableToggle','Macro/EditableToggle','root/import/macro/editabletoggle','3','7','12',NULL,0,0,0,0,0,299,NULL,0),('vgXdBcFTqU7h4wBG1ewdBw',1147642472,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/File','Macro/File','root/import/macro/file','3','7','12',NULL,0,0,0,0,0,269,NULL,0),('hcFlqnXlsmC1ujN6Id0F0A',1147642473,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/GroupAdd','Macro/GroupAdd','root/import/macro/groupadd','3','7','12',NULL,0,0,0,0,0,281,NULL,0),('eRJR52fvlaxfetv3DQkQYw',1147642473,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/GroupDelete','Macro/GroupDelete','root/import/macro/groupdelete','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('5HIDHq5lAWHV5gpYGS0zLg',1147642473,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/H_homeLink','Macro/H_homeLink','root/import/macro/h_homelink','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('rYEFwXXo0tkGhQTcbDibvg',1147642473,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/LoginToggle','Macro/LoginToggle','root/import/macro/logintoggle','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('V3l5S5TtI7wMm1WpIMhvOA',1147642473,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/L_loginBox','Macro/L_loginBox','root/import/macro/l_loginbox','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('nqNbSUAhk9Vd1zda2SCz9A',1147642474,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/RandomThread','Macro/RandomThread','root/import/macro/randomthread','3','7','12',NULL,0,0,0,0,0,293,NULL,0),('y8XkRdxIperLKkJ3bL5sSQ',1147642474,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/r_printable','Macro/r_printable','root/import/macro/r_printable','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('e-WvgcKROPCoHwiiHLktCg',1147642474,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Macro/SubscriptionItem','Macro/SubscriptionItem','root/import/macro/subscriptionitem','3','7','12',NULL,0,0,0,0,0,305,NULL,0),('LdiozcIUciWuvt3Z-na5Ww',1147642474,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Matrix','Matrix','root/import/matrix','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('cj2y4papTVGZRFdwTI-_fw',1147642475,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','MessageBoard','MessageBoard','root/import/messageboard','3','7','12',NULL,0,0,0,0,0,275,NULL,0),('bBzO4CWjqU_ile3gf5Iypw',1147642475,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','MultiSearch','MultiSearch','root/import/multisearch','3','7','12',NULL,0,0,0,0,0,272,NULL,0),('BFfNj5wA9bDw8H3cnr8pTw',1147642475,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Navigation','Navigation','root/import/navigation','3','7','12',NULL,0,0,0,0,0,269,NULL,0),('AgyFhx3eXlfZXNp2MkrsiQ',1147642477,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Operation/Profile/Edit','Operation/Profile/Edit','root/import/operation/profile/edit','3','7','12',NULL,0,0,0,0,0,305,NULL,0),('F7MAQ-cpuvQ1KuC7J4P5zQ',1147642477,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Operation/Profile/View','Operation/Profile/View','root/import/operation/profile/view','3','7','12',NULL,0,0,0,0,0,305,NULL,0),('jEz8iTGNWEt2I05IhVV19Q',1147642477,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Operation/RedeemSubscription','Operation/RedeemSubscription','root/import/operation/redeemsubscription','3','7','12',NULL,0,0,0,0,0,323,NULL,0),('VZK3CRgiMb8r4dBjUmCTgQ',1147642477,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Poll','Poll','root/import/poll','3','7','12',NULL,0,0,0,0,0,251,NULL,0),('TYo2Bwl7aafzTtdHlS-arQ',1147642478,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Product','Product','root/import/product','3','7','12',NULL,0,0,0,0,0,260,NULL,0),('9A-mg2gwWmaYi9o_1C7ArQ',1147642478,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ProjectManager_dashboard','ProjectManager_dashboard','root/import/projectmanager_dashboard','3','7','12',NULL,0,0,0,0,0,311,NULL,0),('yD1SMHelczihzjEmx6eXBA',1147642478,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ProjectManager_editTask','ProjectManager_editTask','root/import/projectmanager_edittask','3','7','12',NULL,0,0,0,0,0,308,NULL,0),('pV7GnZdpjR3XpZaSINIoeg',1147642478,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ProjectManager_gantt','ProjectManager_gantt','root/import/projectmanager_gantt','3','7','12',NULL,0,0,0,0,0,299,NULL,0),('71e17KeduiXgODLMlUxiow',1147642479,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ProjectManager_project','ProjectManager_project','root/import/projectmanager_project','3','7','12',NULL,0,0,0,0,0,305,NULL,0),('Ik9HHky10DIyFTKehUD1dw',1147642479,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','prompt','prompt','root/import/prompt','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('f_tn9FfoSfKWX43F83v_3w',1147642479,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Search','Search','root/import/search','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('Da6KWn805L4B5e4HFgQRQA',1147642479,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Shortcut','Shortcut','root/import/shortcut','3','7','12',NULL,0,0,0,0,0,263,NULL,0),('GnrXtoFFeXia3vDQuSHojw',1147642479,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','SQLForm/Edit','SQLForm/Edit','root/import/sqlform/edit','3','7','12',NULL,0,0,0,0,0,275,NULL,0),('k8vxD4fuKKf5cGwNTw0sLw',1147642480,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','SQLForm/Search','SQLForm/Search','root/import/sqlform/search','3','7','12',NULL,0,0,0,0,0,281,NULL,0),('bbiA9Zq5Gy2oCFBlILO3QA',1147642480,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','SQLReport','SQLReport','root/import/sqlreport','3','7','12',NULL,0,0,0,0,0,266,NULL,0),('Efe2W0UgrSRDltNJ87jlfg',1147642480,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','StockData','StockData','root/import/stockdata','3','7','12',NULL,0,0,0,0,0,266,NULL,0),('RrV4aAPnn4dM0ZcU3OXnlw',1147642480,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','style','style','root/import/style','3','7','12',NULL,0,0,0,0,0,254,NULL,0),('5bnNzteN7w3NnK9mF4XiCg',1147642481,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Survey','Survey','root/import/survey','3','7','12',NULL,0,0,0,0,0,257,NULL,0),('oGfxez5sksyB_PcaAsEm_Q',1147642482,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','SyndicatedContent','SyndicatedContent','root/import/syndicatedcontent','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('vTymIDYL2YqEh6PV50F7ew',1147642482,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','TimeTracking_manager','TimeTracking_manager','root/import/timetracking_manager','3','7','12',NULL,0,0,0,0,0,299,NULL,0),('lo1ac3BsoJx3ijGQ3gR-bQ',1147642482,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','TimeTracking_row','TimeTracking_row','root/import/timetracking_row','3','7','12',NULL,0,0,0,0,0,287,NULL,0),('huASapWvFDzqwOSbcN-JFQ',1147642483,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','TimeTracking_user','TimeTracking_user','root/import/timetracking_user','3','7','12',NULL,0,0,0,0,0,290,NULL,0),('9wKWdum0_8z-OhhquWLtSQ',1147642483,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','WeatherData','WeatherData','root/import/weatherdata','3','7','12',NULL,0,0,0,0,0,272,NULL,0),('5YAbuwiVFUx-z8hcOAnsdQ',1147642483,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','WSClient','WSClient','root/import/wsclient','3','7','12',NULL,0,0,0,0,0,263,NULL,0),('CSN-ZON7Uwv8kxf3F1fh5Q',1147642484,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','ZipArchiveAsset','ZipArchiveAsset','root/import/ziparchiveasset','3','7','12',NULL,0,0,0,0,0,284,NULL,0),('NYr6iP4pQaPRYqEYMryv4w',1147642484,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','Commerce','Commerce','root/import/commerce','3','7','12',NULL,0,0,0,0,0,263,NULL,0),('TCtybxdqmdwdvRn555zpCQ',1147642484,'3','hR5vR1-3bS1SRjIJbdFfmA','approved','RichEdit','RichEdit','root/import/richedit','3','7','12',NULL,0,0,0,0,0,263,NULL,0),('sMuqO3Ynl6Lyn5fa2SsGmQ',1147962058,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','7.0.0 New Templates','7.0.0 New Templates','7_0_0_new_templates','3','12','12',NULL,0,0,0,0,0,263,NULL,0),('PBtmpl0000000000000200',1147962058,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Default Search','Default Search','default_search2','3','7','12',NULL,0,0,0,0,0,1027,NULL,0),('PBtmpl0000000000000027',1147962059,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,690,NULL,0),('PBtmpl0000000000000067',1147962059,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,10972,NULL,0),('PBtmpl0000000000000032',1147962059,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,8044,NULL,0),('PBtmpl0000000000000098',1147962059,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,10112,NULL,0),('PBtmpl0000000000000113',1147962059,'3','7fIc-1XRhOhRhD-0dKTyhQ','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,9573,NULL,0),('PBtmpl0000000000000207',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Article with Files','Article with Files','article-with-files','3','7','12',NULL,0,0,0,0,0,1644,NULL,0),('PBtmpl0000000000000044',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Login Box','Default Login Box','default_login_box','3','7','12',NULL,0,1,0,0,0,1137,NULL,0),('PBtmpl0000000000000092',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Horizontal Login Box','Horizontal Login Box','horizontal_login_box','3','7','12',NULL,0,1,0,0,0,1223,NULL,0),('ImvgaAritVaOLmogG8fCJQ',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','6.99.2 New Templates','6.99.2 New Templates','6.99.2_new_templates','3','12','12',NULL,0,0,0,0,0,266,NULL,0),('PBnav00000000000bullet',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Bulleted List','Bulleted List','bulleted_list','3','7','12',NULL,0,0,0,0,0,1253,NULL,0),('PBtmpl0000000000000085',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Email','Default Email','default_email','3','7','12',NULL,0,1,0,0,0,665,NULL,0),('PBtmpl0000000000000027',1148579524,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,2215,NULL,0),('ProjectManagerTMPL0002',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,21253,NULL,0),('PBtmpl0000000000000067',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,10962,NULL,0),('TimeTrackingTMPL000003',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,2761,NULL,0),('TimeTrackingTMPL000001',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,8900,NULL,0),('pbtmpl0000000000000220',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Flash Template','Flash Template','flash-template','3','7','12',NULL,0,0,0,0,0,583,NULL,0),('PBnav00000000indentnav',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Indent Nav','Indent Nav','indent_nav','3','7','12',NULL,0,0,0,0,0,1243,NULL,0),('PBtmpl0000000000000209',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Request Tracker Post','Request Tracker Post','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,10954,NULL,0),('PBtmpl00000000table125',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Left Column (Table)','Left Column (Table)','left_column_table','3','7','12',NULL,0,0,0,0,0,2205,NULL,0),('PBtmpl00000000table094',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','News (Table)','News (Table)','news_table','3','7','12',NULL,0,0,0,0,0,3405,NULL,0),('PBtmpl00000000table131',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Right Column (Table)','Right Column (Table)','right_column_table','3','7','12',NULL,0,0,0,0,0,2267,NULL,0),('PBtmpl00000000table135',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Side By Side (Table)','Side By Side (Table)','side_by_side_table','3','7','12',NULL,0,0,0,0,0,2130,NULL,0),('PBtmpl00000000table118',1148579525,'3','FXmcPafYROBrRl_v_jfgTA','approved','Three Over One (Table)','Three Over One (Table)','three_over_one_table','3','7','12',NULL,0,0,0,0,0,3702,NULL,0),('EventManagerTmpl000006',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System Search','Default Event Management System Search','default-ems-search-template','3','7','12',NULL,0,0,0,0,0,25071,NULL,0),('EventManagerTmpl000002',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System Event','Default Event Management System Event','default-ems-template-event','3','7','12',NULL,0,0,0,0,0,10228,NULL,0),('EventManagerTmpl000004',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System Manage Purchases','Default Event Management System Manage Purchases','default-ems-template-manage-purchases','3','7','12',NULL,0,0,0,0,0,1384,NULL,0),('EventManagerTmpl000005',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System View Purchase','Default Event Management System View Purchase','default-ems-template-view-purchase','3','7','12',NULL,0,0,0,0,0,4392,NULL,0),('EventManagerTmpl000001',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System','Default Event Management System','default-ems-template','3','7','12',NULL,0,0,0,0,0,6505,NULL,0),('EventManagerTmpl000003',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Event Management System Checkout','Default Event Management System Checkout','default-ems-template-checkout','3','7','12',NULL,0,0,0,0,0,3317,NULL,0),('PBtmpl0000000000000080',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','FAQ','FAQ','faq','3','7','12','',0,1,0,0,0,2117,'',0),('PBtmpl0000000000000133',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Guest Book','Guest Book','guest_book','3','7','12',NULL,0,1,0,0,0,1586,NULL,0),('PBtmpl0000000000000083',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Link List','Link List','link_list','3','7','12',NULL,0,1,0,0,0,2033,NULL,0),('PBtmpl0000000000000101',1149286278,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Ordered List','Ordered List','ordered_list','3','7','12',NULL,0,1,0,0,0,2081,NULL,0),('PBtmpl0000000000000121',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Photo Gallery','Photo Gallery','photo_gallery','3','7','12',NULL,0,1,0,0,0,1776,NULL,0),('PBtmpl0000000000000081',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Q and A','Q and A','q_and_a','3','7','12',NULL,0,1,0,0,0,2421,NULL,0),('PBtmpl0000000000000079',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Topics','Topics','topics','3','7','12',NULL,0,1,0,0,0,2682,NULL,0),('PBtmpl0000000000000097',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,4490,NULL,0),('PBtmpl0000000000000082',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Unordered List','Unordered List','unordered_list','3','7','12',NULL,0,1,0,0,0,2555,NULL,0),('PBtmpl0000000000000112',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Weblog','Weblog','weblog','3','7','12',NULL,0,1,0,0,0,2736,NULL,0),('PBtmpl0000000000000027',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,1537,NULL,0),('ProjectManagerTMPL0001',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,4142,NULL,0),('PBtmpl0000000000000067',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,11580,NULL,0),('PBtmpl0000000000000032',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,8907,NULL,0),('TimeTrackingTMPL000003',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,3051,NULL,0),('TimeTrackingTMPL000001',1149286279,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,9577,NULL,0),('PBtmpl0000000000000098',1149286280,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,10113,NULL,0),('PBtmpl0000000000000113',1149286280,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,9641,NULL,0),('PBtmpl0000000000000209',1149286280,'3','8xT0hPEb637VAv7rHh7xtQ','approved','Request Tracker Post','Request Tracker Post','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,11459,NULL,0),('7.0-style0000000000051',1149286280,'3','8xT0hPEb637VAv7rHh7xtQ','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,3346,NULL,0),('PBtmpl0000000000000001',1150476306,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,2952,NULL,0),('PBtmpl0000000000000016',1150476306,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Default checkout confirmation template','Default checkout confirmation template','default_checkout_confirmation_template','3','7','12',NULL,0,1,0,0,0,2456,NULL,0),('PBtmpl0000000000000021',1150476306,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Data List','Data List','data_list','3','7','12',NULL,0,1,0,0,0,2142,NULL,0),('PBtmpl0000000000000141',1150476306,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Default DataForm','Default DataForm','pbtmpl0000000000000141','3','7','12',NULL,0,1,0,0,0,3469,NULL,0),('PBtmpl0000000000000067',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,12318,NULL,0),('PBtmpl0000000000000032',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,9359,NULL,0),('PBtmpl0000000000000098',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,10842,NULL,0),('PBtmpl0000000000000113',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,10351,NULL,0),('PBtmpl0000000000000020',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Mail Form','Mail Form','mail_form','3','7','12',NULL,0,1,0,0,0,2412,NULL,0),('PBtmpl0000000000000209',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Request Tracker Post','Request Tracker Post','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,11864,NULL,0),('PBtmpl0000000000000210',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Request Tracker','Request Tracker','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,2931,NULL,0),('PBtmpl0000000000000116',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Tab Form','Tab Form','tab_form','3','7','12',NULL,0,1,0,0,0,3045,NULL,0),('ProjectManagerTMPL0002',1150476307,'3','4Il2HjD0io01Ha4_M-7wnQ','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,21494,NULL,0),('PBtmpl0000000000000001',1151102418,'3','zvS8XcBr1fSFTQs_Tc5SgQ','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,2952,NULL,0),('EventManagerTmpl000006',1151102418,'3','zvS8XcBr1fSFTQs_Tc5SgQ','approved','Default Event Management System Search','Default Event Management System Search','default-ems-search-template','3','7','12',NULL,0,0,0,0,0,25105,NULL,0),('PBtmpl0000000000000210',1151102418,'3','zvS8XcBr1fSFTQs_Tc5SgQ','approved','Request Tracker','Request Tracker','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,2931,NULL,0),('PBtmpl0000000000000210',1152740956,'3','xqjzTDK0mlusPHUe_cyYIg','approved','Request Tracker','Request Tracker','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,2963,NULL,0),('PBtmpl0000000000000016',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default checkout confirmation template','Default checkout confirmation template','default_checkout_confirmation_template','3','7','12',NULL,0,1,0,0,0,2465,NULL,0),('EventManagerTmpl000006',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Event Management System Search','Default Event Management System Search','default-ems-search-template','3','7','12',NULL,0,0,0,0,0,24186,NULL,0),('EventManagerTmpl000001',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Event Management System','Default Event Management System','default-ems-template','3','7','12',NULL,0,0,0,0,0,6512,NULL,0),('EventManagerTmpl000005',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Event Management System View Purchase','Default Event Management System View Purchase','default-ems-template-view-purchase','3','7','12',NULL,0,0,0,0,0,4431,NULL,0),('PBtmpl0000000000000039',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default File Macro','Default File Macro','default_file_macro','3','7','12',NULL,0,1,0,0,0,444,NULL,0),('ProjectManagerTMPL0003',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,2158,NULL,0),('ProjectManagerTMPL0002',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,19749,NULL,0),('ProjectManagerTMPL0001',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,3993,NULL,0),('PBtmpl0000000000000055',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Poll','Default Poll','default_poll','3','7','12',NULL,0,1,0,0,0,1689,NULL,0),('PBtmplVSC0000000000001',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Shopping Cart Template','Default Shopping Cart Template','default-shoppingcart-template','3','7','12',NULL,0,0,0,0,0,1587,NULL,0),('PBtmpl0000000000000067',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,11968,NULL,0),('PBtmpl0000000000000032',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,9109,NULL,0),('TimeTrackingTMPL000003',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,3080,NULL,0),('PBtmpl0000000000000014',1154535073,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,1100,NULL,0),('PBtmpl0000000000000130',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','dtree','dtree','dtree2','3','7','12',NULL,0,1,0,0,0,1134,NULL,0),('PBtmpl0000000000000086',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Events List','Events List','events_list','3','7','12',NULL,0,1,0,0,0,2173,NULL,0),('PBtmpl0000000000000098',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,10523,NULL,0),('PBtmpl0000000000000111',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Make Page Printable','Make Page Printable','make_page_printable','3','7','12',NULL,0,1,0,0,0,2014,NULL,0),('matrixtmpl000000000003',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,2945,NULL,0),('MultiSearchTmpl0000001',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','MultiSearch Default Display','MultiSearch Default Display','multisearchtmpl0000001','3','7','12',NULL,0,1,0,0,0,1885,NULL,0),('PBtmpl0000000000000209',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Request Tracker Thread','Request Tracker Thread','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,11869,NULL,0),('SQLFormSearchTmpl00001',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default SQLForm Search template','Default SQLForm Search template','default_sqlform_search_template','3','7','12',NULL,0,0,0,0,0,2164,NULL,0),('StockDataTMPL000000001',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,4978,NULL,0),('StockDataTMPL000000002',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','StockData Default Display','StockData Default Display','stockdatatmpl000000002','3','7','12',NULL,0,1,0,0,0,10519,NULL,0),('PBtmpl0000000000000053',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Subscription code redemption','Subscription code redemption','subscription_code_redemption','3','7','12',NULL,0,1,0,0,0,446,NULL,0),('PBtmpl0000000000000046',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Subscriptionitem default template','Subscriptionitem default template','subscriptionitem_default_template','3','7','12',NULL,0,1,0,0,0,478,NULL,0),('kDuc6TCa6cWZ_jdrIMFKRg',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','7.0.3 New Templates','7.0.3 New Templates','7.0.3_new_templates','3','12','12',NULL,0,0,0,0,0,263,NULL,0),('PBtmpl000000000table54',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Default Page (Table)','Default Page (Table)','default_page_table','3','7','12',NULL,0,0,0,0,0,1200,NULL,0),('PBtmpl00000000table109',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','One Over Three (Table)','One Over Three (Table)','one_over_three_table','3','7','12',NULL,0,0,0,0,0,3579,NULL,0),('PBtmpl0000000000000097',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,3586,NULL,0),('WeatherDataTmpl0000001',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,1137,NULL,0),('PBnav00000000indentnav',1154535074,'3','o3w3zEzXxhahfR_0C4jRVw','approved','Indent Nav','Indent Nav','indent_nav','3','7','12',NULL,0,0,0,0,0,1192,NULL,0),('ProjectManagerTMPL0002',1154535080,'3','DdfT0fzgaP678I5DZVoKJg','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,21017,NULL,0),('ProjectManagerTMPL0002',1155139634,'3','dec7vItPNcyxRXFWu653oQ','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,21540,NULL,0),('PBtmpl0000000000000001',1157679164,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,3044,NULL,0),('matrixtmpl000000000003',1157679164,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,3083,NULL,0),('ProjectManagerTMPL0004',1157679164,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,3878,NULL,0),('ProjectManagerTMPL0003',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,2195,NULL,0),('ProjectManagerTMPL0002',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,6846,NULL,0),('BmLaN4rmAANkCglXUViEbg',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','7.0.7 New Templates','7.0.7 New Templates','7.0.7_new_templates','3','12','12',NULL,0,0,0,0,0,263,NULL,0),('ProjectManagerTMPL0006',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Default Resource List','Default Resource List','default-pm-resource-list','3','7','12',NULL,0,0,0,0,0,1080,NULL,0),('ProjectManagerTMPL0005',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','Default Resource Popup','Default Resource Popup','default-pm-resource-popup','3','7','12',NULL,0,0,0,0,0,1948,NULL,0),('StockDataTMPL000000001',1157679165,'3','8uegNg3dX5WZnkFuyvyS5g','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,4983,NULL,0),('PBtmpl0000000000000032',1159392394,'3','MjXDt6rl9B1Qxe0C7vAZWQ','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,6125,NULL,0),('WeatherDataTmpl0000001',1159392394,'3','MjXDt6rl9B1Qxe0C7vAZWQ','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,1333,NULL,0),('ProjectManagerTMPL0004',1159989349,'3','rDtVlQclQrHui7JGOW8S0w','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,4515,NULL,0),('PBtmpl0000000000000002',1159989349,'3','rDtVlQclQrHui7JGOW8S0w','approved','Default Article','Default Article','default_article','3','7','12',NULL,0,1,0,0,0,1494,NULL,0),('ProjectManagerTMPL0002',1159989349,'3','rDtVlQclQrHui7JGOW8S0w','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,6915,NULL,0),('ProjectManagerTMPL0003',1159989349,'3','rDtVlQclQrHui7JGOW8S0w','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,2117,NULL,0),('ProjectManagerTMPL0002',1160607410,'3','KrvQquBmM-aDZJrdX4rMnA','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,6968,NULL,0),('PBtmpl0000000000000059',1160607411,'3','KrvQquBmM-aDZJrdX4rMnA','approved','Default SQL Report','Default SQL Report','default_sql_report','3','7','12',NULL,0,1,0,0,0,4302,NULL,0),('ProjectManagerTMPL0004',1160607411,'3','KrvQquBmM-aDZJrdX4rMnA','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,4539,NULL,0),('matrixtmpl000000000001',1162436690,'3','kadRWN5alZwkWth8FkQsug','approved','Matrix Default View','Matrix Default View','matrix-default-view-template','3','7','12',NULL,0,0,0,0,0,4235,NULL,0),('PBtmpl0000000000000016',1163019035,'3','LJTFKlkCFgtWcowvAiKJfA','approved','Default checkout confirmation template','Default checkout confirmation template','default_checkout_confirmation_template','3','7','12',NULL,0,1,0,0,0,3000,NULL,0),('EventManagerTmpl000003',1163019035,'3','LJTFKlkCFgtWcowvAiKJfA','approved','Default Event Management System Checkout','Default Event Management System Checkout','default-ems-template-checkout','3','7','12',NULL,0,0,0,0,0,3432,NULL,0),('ProjectManagerTMPL0001',1163019035,'3','LJTFKlkCFgtWcowvAiKJfA','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,3756,NULL,0),('PBtmpl0000000000000142',1163019036,'3','oduMWYaceKv0eoNwkIG-Ew','approved','Default RSS','Default RSS','pbtmpl0000000000000142','3','7','12',NULL,0,1,0,0,0,718,NULL,0),('pbproto000000000000001',1163019036,'3','cKmp6fMMG3fvvkJCQPQn6w','approved','Photo Gallery','Photo Gallery','photo-gallery-prototype','3','7','12',NULL,0,0,0,1,0,487,NULL,0),('pbproto000000000000002',1163019036,'3','cKmp6fMMG3fvvkJCQPQn6w','approved','Request Tracker','Request Tracker','request-tracker-prototype','3','7','12',NULL,0,0,0,1,0,488,NULL,0),('PBtmpl0000000000000207',1163630222,'3','OW7KlRUcs3LuPfvsJ95m1g','approved','Article with Files','Article with Files','article-with-files','3','7','12',NULL,0,0,0,0,0,1658,NULL,0),('PBtmpl0000000000000019',1164270974,'3','9ps7W3vKUeOq8JZZ0ruQng','approved','Default view purchase history template','Default view purchase history template','default_view_purchase_history_template','3','7','12',NULL,0,1,0,0,0,879,NULL,0),('Q4uX_C557arTp6D_jwB1jQ',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','7.3.0 New Templates','7.3.0 New Templates','7.3.0_new_templates','3','12','12',NULL,0,0,0,0,0,263,NULL,0),('WikiRCTmpl000000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Recent Changes','Default Recent Changes','default-wiki-recent-changes','3','7','12',NULL,0,0,0,0,0,734,NULL,0),('WikiFrontTmpl000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Wiki Front Page','Default Wiki Front Page','default-wiki-front-page','3','7','12',NULL,0,0,0,0,0,1076,NULL,0),('WikiSearchTmpl00000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Wiki Search','Default Wiki Search','default-wiki-search','3','7','12',NULL,0,0,0,0,0,1344,NULL,0),('WikiPHTmpl000000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Page History','Default Page History','default-wiki-page-history','3','7','12',NULL,0,0,0,0,0,472,NULL,0),('WikiPageTmpl0000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Wiki Page','Default Wiki Page','default-wiki-page','3','7','12',NULL,0,0,0,0,0,3804,NULL,0),('WikiPageEditTmpl000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Wiki Page Edit','Default Wiki Page Edit','default-wiki-page-edit','3','7','12',NULL,0,0,0,0,0,1074,NULL,0),('CalendarWeek0000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Week','Default Calendar Week','default-calendar-week','3','7','12',NULL,0,0,0,0,0,4812,NULL,0),('WikiMPTmpl000000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Most Popular','Default Most Popular','default-wiki-most-popular','3','7','12',NULL,0,0,0,0,0,661,NULL,0),('CalendarDay00000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Day','Default Calendar Day','default-calendar-day','3','7','12',NULL,0,0,0,0,0,5946,NULL,0),('CalendarEvent000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Event','Default Calendar Event','default-calendar-event','3','7','12',NULL,0,0,0,0,0,4855,NULL,0),('PBtmpl0000000000000014',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,1662,NULL,0),('CalendarEventEdit00001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Event Edit','Default Calendar Event Edit','default-calendar-event-edit','3','7','12',NULL,0,0,0,0,0,4929,NULL,0),('CalendarMonth000000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Month','Default Calendar Month','default-calendar-month','3','7','12',NULL,0,0,0,0,0,7418,NULL,0),('CalendarSearch00000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Calendar Search','Default Calendar Search','default-calendar-search','3','7','12',NULL,0,0,0,0,0,6214,NULL,0),('EventManagerTmpl000001',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Event Management System','Default Event Management System','default-ems-template','3','7','12',NULL,0,0,0,0,0,6594,NULL,0),('PBtmpl0000000000000137',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Admin Console','Admin Console','admin_console','3','7','12',NULL,0,1,0,0,0,757,NULL,0),('EventManagerTmpl000002',1165460175,'3','v5poIPxyL6nOpaQVlYnZKw','approved','Default Event Management System Event','Default Event Management System Event','default-ems-template-event','3','7','12',NULL,0,0,0,0,0,9891,NULL,0),('IOB0000000000000000002',1166019641,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default InOutBoard Report Template','Default InOutBoard Report Template','iob-report-template','3','7','12',NULL,0,0,0,0,0,1596,NULL,0),('IOB0000000000000000001',1166019641,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,2152,NULL,0),('CalendarWeek0000000001',1166019641,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default Calendar Week','Default Calendar Week','default-calendar-week','3','7','12',NULL,0,0,0,0,0,6015,NULL,0),('CalendarDay00000000001',1166019641,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default Calendar Day','Default Calendar Day','default-calendar-day','3','7','12',NULL,0,0,0,0,0,5886,NULL,0),('CalendarEvent000000001',1166019641,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default Calendar Event','Default Calendar Event','default-calendar-event','3','7','12',NULL,0,0,0,0,0,4826,NULL,0),('CalendarSearch00000001',1166019642,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default Calendar Search','Default Calendar Search','default-calendar-search','3','7','12',NULL,0,0,0,0,0,6399,NULL,0),('CalendarEventEdit00001',1166019642,'3','Y7Q6fC8nEMqRnYLq6XMZBA','approved','Default Calendar Event Edit','Default Calendar Event Edit','default-calendar-event-edit','3','7','12',NULL,0,0,0,0,0,5155,NULL,0),('u2mB-2nJbDsfBinXJyjAcQ',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','7.3.2 New Templates','7.3.2 New Templates','7.3.2_new_templates','3','12','12',NULL,0,0,0,0,0,263,NULL,0),('CalendarPrintEvent0001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Print Event','Default Calendar Print Event','default-calendar-print-event','3','7','12',NULL,0,0,0,0,0,2171,NULL,0),('CalendarWeek0000000001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Week','Default Calendar Week','default-calendar-week','3','7','12',NULL,0,0,0,0,0,6066,NULL,0),('CalendarDay00000000001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Day','Default Calendar Day','default-calendar-day','3','7','12',NULL,0,0,0,0,0,5869,NULL,0),('CalendarPrintMonth0001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Print Month','Default Calendar Print Month','default-calendar-print-month','3','7','12',NULL,0,0,0,0,0,1397,NULL,0),('CalendarEvent000000001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Event','Default Calendar Event','default-calendar-event','3','7','12',NULL,0,0,0,0,0,4870,NULL,0),('CalendarPrintWeek00001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Print Week','Default Calendar Print Week','default-calendar-print-week','3','7','12',NULL,0,0,0,0,0,1495,NULL,0),('CalendarMonth000000001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Month','Default Calendar Month','default-calendar-month','3','7','12',NULL,0,0,0,0,0,7197,NULL,0),('CalendarPrintDay000001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default Calendar Print Day','Default Calendar Print Day','default-calendar-print-day','3','7','12',NULL,0,0,0,0,0,1363,NULL,0),('SQLFormSearchTmpl00001',1166718668,'3','2S0fqMYn0WoEYMOFOE4loA','approved','Default SQLForm Search template','Default SQLForm Search template','default_sqlform_search_template','3','7','12',NULL,0,0,0,0,0,2167,NULL,0),('CalendarSearch00000001',1168480840,'3','1a-hOOWg44cBy5s1TaRgiw','approved','Default Calendar Search','Default Calendar Search','default-calendar-search','3','7','12',NULL,0,0,0,0,0,8717,NULL,0),('PBtmpl0000000000000032',1168480840,'3','1a-hOOWg44cBy5s1TaRgiw','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,6178,NULL,0),('WikiSearchTmpl00000001',1168480840,'3','1a-hOOWg44cBy5s1TaRgiw','approved','Default Wiki Search','Default Wiki Search','default-wiki-search','3','7','12',NULL,0,0,0,0,0,1377,NULL,0),('CalendarMonth000000001',1168480840,'3','1a-hOOWg44cBy5s1TaRgiw','approved','Default Calendar Month','Default Calendar Month','default-calendar-month','3','7','12',NULL,0,0,0,0,0,8141,NULL,0),('CalendarDay00000000001',1168480840,'3','1a-hOOWg44cBy5s1TaRgiw','approved','Default Calendar Day','Default Calendar Day','default-calendar-day','3','7','12',NULL,0,0,0,0,0,7945,NULL,0),('WikiRCTmpl000000000001',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default Recent Changes','Default Recent Changes','default-wiki-recent-changes','3','7','12',NULL,0,0,0,0,0,990,NULL,0),('ProjectManagerTMPL0002',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,6979,NULL,0),('CalendarMonth000000001',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default Calendar Month','Default Calendar Month','default-calendar-month','3','7','12',NULL,0,0,0,0,0,9819,NULL,0),('WikiPageEditTmpl000001',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default Wiki Page Edit','Default Wiki Page Edit','default-wiki-page-edit','3','7','12',NULL,0,0,0,0,0,1140,NULL,0),('PBtmpl0000000000000142',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default RSS','Default RSS','pbtmpl0000000000000142','3','7','12',NULL,0,1,0,0,0,746,NULL,0),('WikiFrontTmpl000000001',1169092823,'3','wR9izZZqRmB0tBX_skb1Jw','approved','Default Wiki Front Page','Default Wiki Front Page','default-wiki-front-page','3','7','12',NULL,0,0,0,0,0,1184,NULL,0),('ZipArchiveTMPL00000001',1169449940,'3','kNGLOnk_SxFheyTumDoonA','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,701,NULL,0),('PBtmpl0000000000000068',1169449940,'3','kNGLOnk_SxFheyTumDoonA','approved','Default Submission Form','Default Submission Form','default_submission_form','3','7','12',NULL,0,1,0,0,0,2396,NULL,0),('PBtmpl0000000000000122',1169449940,'3','kNGLOnk_SxFheyTumDoonA','approved','Job Submission Form','Job Submission Form','job_submission_form','3','7','12',NULL,0,1,0,0,0,3080,NULL,0),('ZipArchiveTMPL00000001',1169738426,'3','l8iHMRK1c6M77KEGmQSD6Q','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,693,NULL,0),('IOB0000000000000000001',1169795123,'3','kMDcFwjlRiJEnR5UdKQiZA','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,2151,NULL,0),('ProjectManagerTMPL0004',1169795123,'3','kMDcFwjlRiJEnR5UdKQiZA','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,4757,NULL,0),('PBtmpl0000000000000142',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','Default RSS','Default RSS','pbtmpl0000000000000142','3','7','12',NULL,0,1,0,0,0,719,NULL,0),('PBtmpl0000000000000080',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','FAQ','FAQ','faq','3','7','12','',0,1,0,0,0,2147,'',0),('0Q41OuxKgi0aAJd4Xbas2Q',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','7.3.9 New Templates','7.3.9 New Templates','7.3.9_new_templates','3','12','12',NULL,0,0,0,0,0,264,NULL,0),('SQLReportDownload0001',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','SQLReport Download Default Template','untitled','SQLReportDownload0001','3','7','12',NULL,0,0,0,0,0,3650,NULL,0),('CalendarEvent000000001',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','Default Calendar Event','Default Calendar Event','default-calendar-event','3','7','12',NULL,0,0,0,0,0,5194,NULL,0),('EventManagerTmpl000003',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','Default Event Management System Checkout','Default Event Management System Checkout','default-ems-template-checkout','3','7','12',NULL,0,0,0,0,0,3657,NULL,0),('ProjectManagerTMPL0004',1171466654,'3','erNgmvmqLafaeM_ST1Rs-A','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,4754,NULL,0),('PBtmpl0000000000000011',1172072639,'3','AsHgU4Hce_E7M1ovudnVkA','approved','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template','default_webgui_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,1989,NULL,0),('PBtmpl0000000000000125',1173889335,'3','50kwzDShUy6V7B2bidpMww','approved','Left Column','Left Column','left_column','3','7','12',NULL,0,1,0,0,0,2107,NULL,0),('PBtmpl0000000000000114',1174490121,'3','oZT1Uk6f32a6it_RJQLDXQ','approved','Link List Submission Form','Link List Submission Form','link_list_submission_form','3','7','12',NULL,0,1,0,0,0,2760,NULL,0),('CalendarDay00000000001',1175702683,'3','bo1kUdYl2He5wsSufnhPWA','approved','Default Calendar Day','Default Calendar Day','default-calendar-day','3','7','12',NULL,0,0,0,0,0,7991,NULL,0),('CalendarMonth000000001',1175702683,'3','bo1kUdYl2He5wsSufnhPWA','approved','Default Calendar Month','Default Calendar Month','default-calendar-month','3','7','12',NULL,0,0,0,0,0,9850,NULL,0),('CalendarWeek0000000001',1175702683,'3','bo1kUdYl2He5wsSufnhPWA','approved','Default Calendar Week','Default Calendar Week','default-calendar-week','3','7','12',NULL,0,0,0,0,0,6114,NULL,0),('stevestyle000000000003',1178723413,'3','Vdv2VqUAjlFlpO5_qpEORg','approved','Style 03','Style 03','style_03','3','7','12',NULL,0,0,0,0,0,1635,NULL,0),('7.0-style0000000000051',1178723414,'3','Vdv2VqUAjlFlpO5_qpEORg','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,3414,NULL,0),('PBtmpl0000000000000207',1184192509,'3','H_re2ZLDlCyIEijzkqevsQ','approved',' Article with Files','Article with Files','article-with-files','3','7','12',NULL,0,0,0,0,0,1652,NULL,0);
CREATE TABLE `assetHistory` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `dateStamp` bigint(20) NOT NULL default '0',
  `actionTaken` varchar(255) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `assetIndex` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `title` varchar(255) default NULL,
  `synopsis` text,
  `url` varchar(255) default NULL,
  `creationDate` bigint(20) default NULL,
  `revisionDate` bigint(20) default NULL,
  `ownerUserId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `groupIdView` varchar(22) character set utf8 collate utf8_bin default NULL,
  `groupIdEdit` varchar(22) character set utf8 collate utf8_bin default NULL,
  `className` varchar(255) default NULL,
  `isPublic` int(11) NOT NULL default '1',
  `keywords` mediumtext,
  `lineage` varchar(255) default NULL,
  PRIMARY KEY  (`assetId`),
  FULLTEXT KEY `keywords` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `assetIndex` VALUES ('PBasset000000000000003','Media','Media Media  media ','media',1147642437,1147642437,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Media\'\'Media\'\'media','000001000003'),('PBtmpl0000000000000069','Xmethods: getTemp','Xmethods: getTemp Xmethods: getTemp  xmethods gettemp ','xmethods_gettemp',1124395696,1147642432,'3','7','12','WebGUI::Asset::Template',1,'Xmethods\'\':\'\'getTemp\'\'Xmethods\'\':\'\'getTemp\'\'xmethods\'\'gettemp WSClient','000001000001000084000001'),('PBtmpl0000000000000112','Weblog','Weblog Weblog  weblog ','weblog',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Weblog\'\'Weblog\'\'weblog Collaboration','000001000001000028000004'),('PBtmplBlankStyle000001','WebGUI 6 Blank Style','WebGUI 6 Blank Style WebGUI 6 Blank Style  pbtmplblankstyle000001 ','pbtmplblankstyle000001',1133743239,1147642431,'3','7','12','WebGUI::Asset::Template',1,'WebGUI\'\'6\'\'Blank\'\'Style\'\'WebGUI\'\'6\'\'Blank\'\'Style\'\'pbtmplblankstyle000001 style','000001000001000077000007'),('PBtmpl0000000000000048','verticalMenu','verticalMenu verticalMenu  verticalmenu ','verticalmenu',1124395696,1147642431,'3','7','12','WebGUI::Asset::Template',1,'verticalMenu\'\'verticalMenu\'\'verticalmenu Navigation','000001000001000060000004'),('PBtmpl0000000000000079','Topics','Topics Topics  topics ','topics',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Topics\'\'Topics\'\'topics Collaboration','000001000001000028000009'),('PBtmpl0000000000000097','Traditional with Thumbnails','Traditional with Thumbnails Traditional with Thumbnails  traditional with thumbnails ','traditional_with_thumbnails',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Traditional\'\'with\'\'Thumbnails\'\'Traditional\'\'with\'\'Thumbnails\'\'traditional\'\'with\'\'thumbnails Collaboration','000001000001000028000003'),('PBtmpl0000000000000082','Unordered List','Unordered List Unordered List  unordered list ','unordered_list',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Unordered\'\'List\'\'Unordered\'\'List\'\'unordered\'\'list Collaboration','000001000001000028000011'),('PBtmpl0000000000000118','Three Over One','Three Over One Three Over One  three over one ','three_over_one',1124395696,1147642429,'3','7','12','WebGUI::Asset::Template',1,'Three\'\'Over\'\'One\'\'Three\'\'Over\'\'One\'\'three\'\'over\'\'one Layout','000001000001000043000005'),('PBtmpl0000000000000110','Three Columns','Three Columns Three Columns  three columns ','three_columns',1124395696,1147642429,'3','7','12','WebGUI::Asset::Template',1,'Three\'\'Columns\'\'Three\'\'Columns\'\'three\'\'columns Product','000001000001000065000003'),('PBtmpl0000000000000124','Tabs','Tabs Tabs  tabs ','tabs',1124395696,1147642429,'3','7','12','WebGUI::Asset::Template',1,'Tabs\'\'Tabs\'\'tabs Navigation','000001000001000060000007'),('GNvjCFQWjY2AF2uf0aCM8Q','Syndicated Articles','Syndicated Articles Syndicated Articles  syndicated articles ','syndicated_articles',1124395696,1147642428,'3','7','12','WebGUI::Asset::Template',1,'Syndicated\'\'Articles\'\'Syndicated\'\'Articles\'\'syndicated\'\'articles SyndicatedContent','000001000001000079000002'),('PBtmpl0000000000000136','Synopsis','Synopsis Synopsis  synopsis2 ','synopsis2',1124395696,1147642428,'3','7','12','WebGUI::Asset::Template',1,'Synopsis\'\'Synopsis\'\'synopsis2 Navigation','000001000001000060000010'),('PBtmpl0000000000000116','Tab Form','Tab Form Tab Form  tab form ','tab_form',1124395696,1150476307,'3','7','12','WebGUI::Asset::Template',1,'Tab\'\'Form\'\'Tab\'\'Form\'\'tab\'\'form DataForm','000001000001000030000005'),('PBtmpl0000000000000046','Subscriptionitem default template','Subscriptionitem default template Subscriptionitem default template  subscriptionitem default template ','subscriptionitem_default_template',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Subscriptionitem\'\'default\'\'template\'\'Subscriptionitem\'\'default\'\'template\'\'subscriptionitem\'\'default\'\'template Macro\'\'/\'\'SubscriptionItem','000001000001000056000001'),('PBtmpl0000000000000137','Admin Console','Admin Console Admin Console  admin console ','admin_console',1124395696,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Admin\'\'Console\'\'Admin\'\'Console\'\'admin\'\'console style','000001000001000077000005'),('StockDataTMPL000000001','StockData Default View','StockData Default View StockData Default View  stockdatatmpl000000001 ','stockdatatmpl000000001',1133743239,1157679165,'3','7','12','WebGUI::Asset::Template',1,'StockData\'\'Default\'\'View\'\'StockData\'\'Default\'\'View\'\'stockdatatmpl000000001 StockData','000001000001000076000002'),('PBtmpl0000000000000135','Side By Side','Side By Side Side By Side  side by side ','side_by_side',1124395696,1147642427,'3','7','12','WebGUI::Asset::Template',1,'Side\'\'By\'\'Side\'\'Side\'\'By\'\'Side\'\'side\'\'by\'\'side Layout','000001000001000043000001'),('PBtmpl0000000000000200','Default Search','Default Search Default Search  default search2 ','default_search2',1147642427,1147962058,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Search\'\'Default\'\'Search\'\'default\'\'search2 Search','000001000001000071000001'),('PBtmpl0000000000000101','Ordered List','Ordered List Ordered List  ordered list ','ordered_list',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Ordered\'\'List\'\'Ordered\'\'List\'\'ordered\'\'list Collaboration','000001000001000028000024'),('PBtmpl0000000000000121','Photo Gallery','Photo Gallery Photo Gallery  photo gallery ','photo_gallery',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Photo\'\'Gallery\'\'Photo\'\'Gallery\'\'photo\'\'gallery Collaboration','000001000001000028000005'),('PBtmpl0000000000000081','Q and A','Q and A Q and A  q and a ','q_and_a',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Q\'\'and\'\'A\'\'Q\'\'and\'\'A\'\'q\'\'and\'\'a Collaboration','000001000001000028000023'),('WVtmpl0000000000000001','Random Thread Macro Default Template','Random Thread Macro Default Template Random Thread Macro Default Template  randomthread template ','randomthread-template',1133743240,1147642426,'3','7','12','WebGUI::Asset::Template',1,'Random\'\'Thread\'\'Macro\'\'Default\'\'Template\'\'Random\'\'Thread\'\'Macro\'\'Default\'\'Template\'\'randomthread\'\'template Macro\'\'/\'\'RandomThread','000001000001000054000001'),('PBtmpl0000000000000131','Right Column','Right Column Right Column  right column ','right_column',1124395696,1147642426,'3','7','12','WebGUI::Asset::Template',1,'Right\'\'Column\'\'Right\'\'Column\'\'right\'\'column Layout','000001000001000043000002'),('PBtmpl0000000000000094','News','News News  news ','news',1124395696,1147642425,'3','7','12','WebGUI::Asset::Template',1,'News\'\'News\'\'news Layout','000001000001000043000007'),('matrixtmpl000000000004','Matrix Default Rating Detail','Matrix Default Rating Detail Matrix Default Rating Detail  matrix rating detail template ','matrix-rating-detail-template',1133743239,1147642425,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Rating\'\'Detail\'\'Matrix\'\'Default\'\'Rating\'\'Detail\'\'matrix\'\'rating\'\'detail\'\'template Matrix\'\'/\'\'RatingDetail','000001000001000057000004'),('matrixtmpl000000000005','Matrix Default Search','Matrix Default Search Matrix Default Search  matrix search template ','matrix-search-template',1133743239,1147642425,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Search\'\'Matrix\'\'Default\'\'Search\'\'matrix\'\'search\'\'template Matrix\'\'/\'\'Search','000001000001000057000005'),('MultiSearchTmpl0000001','MultiSearch Default Display','MultiSearch Default Display MultiSearch Default Display  multisearchtmpl0000001 ','multisearchtmpl0000001',1133743239,1154535074,'3','7','12','WebGUI::Asset::Template',1,'MultiSearch\'\'Default\'\'Display\'\'MultiSearch\'\'Default\'\'Display\'\'multisearchtmpl0000001 MultiSearch','000001000001000059000001'),('matrixtmpl000000000001','Matrix Default View','Matrix Default View Matrix Default View  matrix default view template ','matrix-default-view-template',1133743238,1162436690,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'View\'\'Matrix\'\'Default\'\'View\'\'matrix\'\'default\'\'view\'\'template Matrix','000001000001000057000002'),('matrixtmpl000000000003','Matrix Default Detailed Listing','Matrix Default Detailed Listing Matrix Default Detailed Listing  matrix default detailed listing ','matrix-default-detailed-listing',1133743238,1157679164,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Detailed\'\'Listing\'\'Matrix\'\'Default\'\'Detailed\'\'Listing\'\'matrix\'\'default\'\'detailed\'\'listing Matrix\'\'/\'\'Detail','000001000001000057000003'),('matrixtmpl000000000002','Matrix Default Compare','Matrix Default Compare Matrix Default Compare  matrix default compare template ','matrix-default-compare-template',1133743238,1147642424,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Compare\'\'Matrix\'\'Default\'\'Compare\'\'matrix\'\'default\'\'compare\'\'template Matrix\'\'/\'\'Compare','000001000001000057000001'),('PBtmpl0000000000000111','Make Page Printable','Make Page Printable Make Page Printable  make page printable ','make_page_printable',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Make\'\'Page\'\'Printable\'\'Make\'\'Page\'\'Printable\'\'make\'\'page\'\'printable style','000001000001000077000004'),('PBtmpl0000000000000020','Mail Form','Mail Form Mail Form  mail form ','mail_form',1124395696,1150476307,'3','7','12','WebGUI::Asset::Template',1,'Mail\'\'Form\'\'Mail\'\'Form\'\'mail\'\'form DataForm','000001000001000030000001'),('PBtmpl0000000000000119','Left Column Collateral','Left Column Collateral Left Column Collateral  left column collateral ','left_column_collateral',1124395696,1147642423,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Column\'\'Collateral\'\'Left\'\'Column\'\'Collateral\'\'left\'\'column\'\'collateral Product','000001000001000065000004'),('PBtmpl0000000000000113','Link','Link Link  link ','link',1124395696,1150476307,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'Link\'\'link Collaboration\'\'/\'\'Thread','000001000001000028000026'),('PBtmpl0000000000000083','Link List','Link List Link List  link list ','link_list',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'List\'\'Link\'\'List\'\'link\'\'list Collaboration','000001000001000028000010'),('PBtmpl0000000000000114','Link List Submission Form','Link List Submission Form Link List Submission Form  link list submission form ','link_list_submission_form',1124395696,1174490121,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'List\'\'Submission\'\'Form\'\'Link\'\'List\'\'Submission\'\'Form\'\'link\'\'list\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000028000019'),('PBtmpl0000000000000115','Linked Image with Caption','Linked Image with Caption Linked Image with Caption  linked image with caption ','linked_image_with_caption',1124395696,1147642423,'3','7','12','WebGUI::Asset::Template',1,'Linked\'\'Image\'\'with\'\'Caption\'\'Linked\'\'Image\'\'with\'\'Caption\'\'linked\'\'image\'\'with\'\'caption Article','000001000001000019000004'),('PBtmpl0000000000000129','Item w/pop-up Links','Item w/pop-up Links Item w/pop-up Links  item w pop up links ','item_w/pop-up_links',1124395696,1147642422,'3','7','12','WebGUI::Asset::Template',1,'Item\'\'w\'\'/\'\'pop\'\'-\'\'up\'\'Links\'\'Item\'\'w\'\'/\'\'pop\'\'-\'\'up\'\'Links\'\'item\'\'w\'\'pop\'\'up\'\'links Article','000001000001000019000006'),('PBtmpl0000000000000098','Job','Job Job  job ','job',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Job\'\'job Collaboration\'\'/\'\'Thread','000001000001000028000021'),('PBtmpl0000000000000077','Job Listing','Job Listing Job Listing  job listing ','job_listing',1124395696,1147642422,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Listing\'\'Job\'\'Listing\'\'job\'\'listing Collaboration','000001000001000028000020'),('PBtmpl0000000000000122','Job Submission Form','Job Submission Form Job Submission Form  job submission form ','job_submission_form',1124395696,1169449940,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Submission\'\'Form\'\'Job\'\'Submission\'\'Form\'\'job\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000028000022'),('PBtmpl0000000000000103','Left Align Image','Left Align Image Left Align Image  left align image ','left_align_image',1124395696,1147642422,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Align\'\'Image\'\'Left\'\'Align\'\'Image\'\'left\'\'align\'\'image Article','000001000001000019000001'),('PBtmpl0000000000000092','Horizontal Login Box','Horizontal Login Box Horizontal Login Box  horizontal login box ','horizontal_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Horizontal\'\'Login\'\'Box\'\'Horizontal\'\'Login\'\'Box\'\'horizontal\'\'login\'\'box Macro\'\'/\'\'L_loginBox','000001000001000053000001'),('PBtmpl0000000000000108','horizontalMenu','horizontalMenu horizontalMenu  horizontalmenu ','horizontalmenu',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'horizontalMenu\'\'horizontalMenu\'\'horizontalmenu Navigation','000001000001000060000005'),('PBtmpl0000000000000088','Image','Image Image  image ','image',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'Image\'\'Image\'\'image ImageAsset','000001000001000039000001'),('IOB0000000000000000002','Default InOutBoard Report Template','Default InOutBoard Report Template Default InOutBoard Report Template  iob report template ','iob-report-template',1133743239,1166019641,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'InOutBoard\'\'Report\'\'Template\'\'Default\'\'InOutBoard\'\'Report\'\'Template\'\'iob\'\'report\'\'template InOutBoard\'\'/\'\'Report','000001000001000042000001'),('IOB0000000000000000001','Default InOutBoard Template','Default InOutBoard Template Default InOutBoard Template  iob template ','iob-template',1133743239,1169795123,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'InOutBoard\'\'Template\'\'Default\'\'InOutBoard\'\'Template\'\'iob\'\'template InOutBoard','000001000001000042000002'),('PBtmpl0000000000000123','Item','Item Item  item ','item',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'Item\'\'Item\'\'item Article','000001000001000019000005'),('PBtmpl0000000000000024','File','File File  file ','file',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'File\'\'file FileAsset','000001000001000036000001'),('PBtmpl0000000000000078','File Folder','File Folder File Folder  file folder ','file_folder',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'Folder\'\'File\'\'Folder\'\'file\'\'folder Folder','000001000001000037000001'),('PBtmpl0000000000000107','File with size','File with size File with size  file with size ','file_with_size',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'with\'\'size\'\'File\'\'with\'\'size\'\'file\'\'with\'\'size Macro\'\'/\'\'File','000001000001000048000003'),('PBtmpl0000000000000100','Google: doGoogleSearch','Google: doGoogleSearch Google: doGoogleSearch  google dogooglesearch ','google_dogooglesearch',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'Google\'\':\'\'doGoogleSearch\'\'Google\'\':\'\'doGoogleSearch\'\'google\'\'dogooglesearch WSClient','000001000001000084000002'),('PBtmpl0000000000000133','Guest Book','Guest Book Guest Book  guest book ','guest_book',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Guest\'\'Book\'\'Guest\'\'Book\'\'guest\'\'book Collaboration','000001000001000028000012'),('PBtmpl0000000000000117','DropMenu','DropMenu DropMenu  dropmenu ','dropmenu',1124395696,1147642419,'3','7','12','WebGUI::Asset::Template',1,'DropMenu\'\'DropMenu\'\'dropmenu Navigation','000001000001000060000006'),('PBtmpl0000000000000130','dtree','dtree dtree  dtree2 ','dtree2',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'dtree\'\'dtree\'\'dtree2 Navigation','000001000001000060000008'),('PBtmpl0000000000000086','Events List','Events List Events List  events list ','events_list',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Events\'\'List\'\'Events\'\'List\'\'events\'\'list EventsCalendar','000001000001000035000003'),('PBtmpl0000000000000060','Fail Safe','Fail Safe Fail Safe  fail safe ','fail_safe',1124395696,1147642419,'3','7','12','WebGUI::Asset::Template',1,'Fail\'\'Safe\'\'Fail\'\'Safe\'\'fail\'\'safe style','000001000001000077000001'),('PBtmpl0000000000000080','FAQ','FAQ FAQ  faq ','faq',1124395696,1171466654,'3','7','12','WebGUI::Asset::Template',1,'FAQ\'\'FAQ\'\'faq Collaboration','000001000001000028000002'),('PBtmpl0000000000000099','FAQ Submission Form','FAQ Submission Form FAQ Submission Form  faq submission form ','faq_submission_form',1124395696,1147642419,'3','7','12','WebGUI::Asset::Template',1,'FAQ\'\'Submission\'\'Form\'\'FAQ\'\'Submission\'\'Form\'\'faq\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000028000018'),('PBtmpl0000000000000019','Default view purchase history template','Default view purchase history template Default view purchase history template  default view purchase history template ','default_view_purchase_history_template',1124395696,1164270974,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'view\'\'purchase\'\'history\'\'template\'\'Default\'\'view\'\'purchase\'\'history\'\'template\'\'default\'\'view\'\'purchase\'\'history\'\'template Commerce\'\'/\'\'ViewPurchaseHistory','000001000001000086000007'),('PBtmpl0000000000000010','Default WebGUI Account Display Template','Default WebGUI Account Display Template Default WebGUI Account Display Template  default webgui account display template ','default_webgui_account_display_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Account\'\'Display\'\'Template\'\'Default\'\'WebGUI\'\'Account\'\'Display\'\'Template\'\'default\'\'webgui\'\'account\'\'display\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Account','000001000001000023000001'),('PBtmpl0000000000000011','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template Default WebGUI Anonymous Registration Template  default webgui anonymous registration template ','default_webgui_anonymous_registration_template',1124395696,1172072639,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Anonymous\'\'Registration\'\'Template\'\'Default\'\'WebGUI\'\'Anonymous\'\'Registration\'\'Template\'\'default\'\'webgui\'\'anonymous\'\'registration\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Create','000001000001000024000001'),('PBtmpl0000000000000013','Default WebGUI Login Template','Default WebGUI Login Template Default WebGUI Login Template  default webgui login template ','default_webgui_login_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Login\'\'Template\'\'Default\'\'WebGUI\'\'Login\'\'Template\'\'default\'\'webgui\'\'login\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Login','000001000001000026000001'),('PBtmpl0000000000000012','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template Default WebGUI Password Reset Template  default webgui password reset template ','default_webgui_password_reset_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Password\'\'Reset\'\'Template\'\'Default\'\'WebGUI\'\'Password\'\'Reset\'\'Template\'\'default\'\'webgui\'\'password\'\'reset\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Expired','000001000001000025000001'),('PBtmpl0000000000000057','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt Default WebGUI Yes/No Prompt  default webgui yes no prompt ','default_webgui_yes/no_prompt',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Yes\'\'/\'\'No\'\'Prompt\'\'Default\'\'WebGUI\'\'Yes\'\'/\'\'No\'\'Prompt\'\'default\'\'webgui\'\'yes\'\'no\'\'prompt prompt','000001000001000070000001'),('PBtmpl0000000000000066','Default USS','Default USS Default USS  default uss ','default_uss',1124395696,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'USS\'\'Default\'\'USS\'\'default\'\'uss Collaboration','000001000001000028000001'),('TimeTrackingTMPL000001','Default Time Tracking User View','Default Time Tracking User View Default Time Tracking User View  default tt template user ','default-tt-template-user',1147642417,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'User\'\'View\'\'Default\'\'Time\'\'Tracking\'\'User\'\'View\'\'default\'\'tt\'\'template\'\'user TimeTracking_user','000001000001000082000001'),('TimeTrackingTMPL000003','Default Time Tracking Row Template','Default Time Tracking Row Template Default Time Tracking Row Template  default tt template row ','default-tt-template-row',1147642417,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'Row\'\'Template\'\'Default\'\'Time\'\'Tracking\'\'Row\'\'Template\'\'default\'\'tt\'\'template\'\'row TimeTracking_row','000001000001000081000001'),('TimeTrackingTMPL000002','Default Time Tracking Manager View','Default Time Tracking Manager View Default Time Tracking Manager View  default tt template manager ','default-tt-template-manager',1147642417,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'Manager\'\'View\'\'Default\'\'Time\'\'Tracking\'\'Manager\'\'View\'\'default\'\'tt\'\'template\'\'manager TimeTracking_manager','000001000001000080000001'),('PBtmpl0000000000000018','Default transaction error template','Default transaction error template Default transaction error template  default transaction error template ','default_transaction_error_template',1124395696,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'transaction\'\'error\'\'template\'\'Default\'\'transaction\'\'error\'\'template\'\'default\'\'transaction\'\'error\'\'template Commerce\'\'/\'\'TransactionError','000001000001000086000006'),('PBtmpl0000000000000065','Default Syndicated Content','Default Syndicated Content Default Syndicated Content  default syndicated content ','default_syndicated_content',1124395696,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Syndicated\'\'Content\'\'Default\'\'Syndicated\'\'Content\'\'default\'\'syndicated\'\'content SyndicatedContent','000001000001000079000001'),('PBtmpl0000000000000052','Default Profile Display Template','Default Profile Display Template Default Profile Display Template  default profile display template ','default_profile_display_template',1124395696,1147642416,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Profile\'\'Display\'\'Template\'\'Default\'\'Profile\'\'Display\'\'Template\'\'default\'\'profile\'\'display\'\'template Operation\'\'/\'\'Profile\'\'/\'\'View','000001000001000062000001'),('PBtmpl0000000000000064','Default Response','Default Response Default Response  default response ','default_response',1124395696,1147642416,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Response\'\'Default\'\'Response\'\'default\'\'response Survey\'\'/\'\'Response','000001000001000078000004'),('PBtmplCSSM000000000001','Default Select Shipping Method Template','Default Select Shipping Method Template Default Select Shipping Method Template  default select shipping method template ','default-select-shipping-method-template',1124395696,1147642416,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Select\'\'Shipping\'\'Method\'\'Template\'\'Default\'\'Select\'\'Shipping\'\'Method\'\'Template\'\'default\'\'select\'\'shipping\'\'method\'\'template Commerce\'\'/\'\'SelectShippingMethod','000001000001000086000005'),('PBtmpl0000000000000059','Default SQL Report','Default SQL Report Default SQL Report  default sql report ','default_sql_report',1124395696,1160607411,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'SQL\'\'Report\'\'Default\'\'SQL\'\'Report\'\'default\'\'sql\'\'report SQLReport','000001000001000075000001'),('PBtmpl0000000000000067','Default Submission','Default Submission Default Submission  default submission ','default_submission',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Submission\'\'Default\'\'Submission\'\'default\'\'submission Collaboration\'\'/\'\'Thread','000001000001000028000006'),('PBtmpl0000000000000068','Default Submission Form','Default Submission Form Default Submission Form  default submission form ','default_submission_form',1124395696,1169449940,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Submission\'\'Form\'\'Default\'\'Submission\'\'Form\'\'default\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000028000017'),('PBtmpl0000000000000061','Default Survey','Default Survey Default Survey  default survey ','default_survey',1124395696,1147642416,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Survey\'\'Default\'\'Survey\'\'default\'\'survey Survey','000001000001000078000003'),('ProjectManagerTMPL0004','Default Project Manager Edit Task','Default Project Manager Edit Task Default Project Manager Edit Task  default pm template edit task ','default-pm-template-edit-task',1147642415,1171466654,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Manager\'\'Edit\'\'Task\'\'Default\'\'Project\'\'Manager\'\'Edit\'\'Task\'\'default\'\'pm\'\'template\'\'edit\'\'task ProjectManager_editTask','000001000001000067000001'),('ProjectManagerTMPL0003','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart Default Project Manager Gantt Chart  default pm template gantt chart ','default-pm-template-gantt-chart',1147642415,1159989349,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Manager\'\'Gantt\'\'Chart\'\'Default\'\'Project\'\'Manager\'\'Gantt\'\'Chart\'\'default\'\'pm\'\'template\'\'gantt\'\'chart ProjectManager_gantt','000001000001000068000001'),('ProjectManagerTMPL0001','Default Project Management System Dashboard','Default Project Management System Dashboard Default Project Management System Dashboard  default pm template dashboard ','default-pm-template-dashboard',1147642415,1163019035,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Management\'\'System\'\'Dashboard\'\'Default\'\'Project\'\'Management\'\'System\'\'Dashboard\'\'default\'\'pm\'\'template\'\'dashboard ProjectManager_dashboard','000001000001000066000001'),('PBtmpl0000000000000055','Default Poll','Default Poll Default Poll  default poll ','default_poll',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Poll\'\'Default\'\'Poll\'\'default\'\'poll Poll','000001000001000064000001'),('PBtmpl0000000000000029','Default Post Form','Default Post Form Default Post Form  default post form ','default_post_form',1124395696,1147642415,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Post\'\'Form\'\'Default\'\'Post\'\'Form\'\'default\'\'post\'\'form Collaboration\'\'/\'\'PostForm','000001000001000028000013'),('PBtmpl0000000000000056','Default Product','Default Product Default Product  default product ','default_product',1124395696,1147642415,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Product\'\'Default\'\'Product\'\'default\'\'product Product','000001000001000065000001'),('PBtmplCP00000000000001','Default Product Template','Default Product Template Default Product Template  default product template ','default_product_template',1124395696,1147642415,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Product\'\'Template\'\'Default\'\'Product\'\'Template\'\'default\'\'product\'\'template Commerce\'\'/\'\'Product','000001000001000086000003'),('PBtmpl0000000000000033','Default HTTP Proxy','Default HTTP Proxy Default HTTP Proxy  default http proxy ','default_http_proxy',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'HTTP\'\'Proxy\'\'Default\'\'HTTP\'\'Proxy\'\'default\'\'http\'\'proxy HttpProxy','000001000001000038000001'),('PBtmpl0000000000000004','Default LDAP Account Display Template','Default LDAP Account Display Template Default LDAP Account Display Template  default ldap account display template ','default_ldap_account_display_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Account\'\'Display\'\'Template\'\'Default\'\'LDAP\'\'Account\'\'Display\'\'Template\'\'default\'\'ldap\'\'account\'\'display\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Account','000001000001000020000001'),('PBtmpl0000000000000005','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template Default LDAP Anonymous Registration Template  default ldap anonymous registration template ','default_ldap_anonymous_registration_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Anonymous\'\'Registration\'\'Template\'\'Default\'\'LDAP\'\'Anonymous\'\'Registration\'\'Template\'\'default\'\'ldap\'\'anonymous\'\'registration\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Create','000001000001000021000001'),('PBtmpl0000000000000006','Default LDAP Login Template','Default LDAP Login Template Default LDAP Login Template  default ldap login template ','default_ldap_login_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Login\'\'Template\'\'Default\'\'LDAP\'\'Login\'\'Template\'\'default\'\'ldap\'\'login\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Login','000001000001000022000001'),('PBtmpl0000000000000044','Default Login Box','Default Login Box Default Login Box  default login box ','default_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Login\'\'Box\'\'Default\'\'Login\'\'Box\'\'default\'\'login\'\'box Macro\'\'/\'\'L_loginBox','000001000001000053000002'),('PBtmpl0000000000000047','Default Message Board','Default Message Board Default Message Board  default message board ','default_message_board',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Message\'\'Board\'\'Default\'\'Message\'\'Board\'\'default\'\'message\'\'board MessageBoard','000001000001000058000001'),('PBtmpl0000000000000063','Default Overview Report','Default Overview Report Default Overview Report  default overview report ','default_overview_report',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Overview\'\'Report\'\'Default\'\'Overview\'\'Report\'\'default\'\'overview\'\'report Survey\'\'/\'\'Overview','000001000001000078000001'),('PBtmpl0000000000000054','Default Page','Default Page Default Page  default page ','default_page',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'Default\'\'Page\'\'default\'\'page Layout','000001000001000043000003'),('PBtmpl0000000000000017','Default payment gateway selection template','Default payment gateway selection template Default payment gateway selection template  default payment gateway selection template ','default_payment_gateway_selection_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'payment\'\'gateway\'\'selection\'\'template\'\'Default\'\'payment\'\'gateway\'\'selection\'\'template\'\'default\'\'payment\'\'gateway\'\'selection\'\'template Commerce\'\'/\'\'SelectPaymentGateway','000001000001000086000004'),('EventManagerTmpl000001','Default Event Management System','Default Event Management System Default Event Management System  default ems template ','default-ems-template',1147642413,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'Default\'\'Event\'\'Management\'\'System\'\'default\'\'ems\'\'template EventManagementSystem','000001000001000031000004'),('EventManagerTmpl000002','Default Event Management System Event','Default Event Management System Event Default Event Management System Event  default ems template event ','default-ems-template-event',1147642413,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'Event\'\'Default\'\'Event\'\'Management\'\'System\'\'Event\'\'default\'\'ems\'\'template\'\'event EventManagementSystem_product','000001000001000031000005'),('EventManagerTmpl000005','Default Event Management System View Purchase','Default Event Management System View Purchase Default Event Management System View Purchase  default ems template view purchase ','default-ems-template-view-purchase',1147642413,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'View\'\'Purchase\'\'Default\'\'Event\'\'Management\'\'System\'\'View\'\'Purchase\'\'default\'\'ems\'\'template\'\'view\'\'purchase EventManagementSystem_viewPurchase','000001000001000034000001'),('Q4uX_C557arTp6D_jwB1jQ','7.3.0 New Templates','7.3.0 New Templates 7.3.0 New Templates  7.3.0 new templates ','7.3.0_new_templates',1165460175,1165460175,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'3\'\'.\'\'0\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'0\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'0\'\'new\'\'templates','000001000001000096'),('PBtmpl0000000000000039','Default File Macro','Default File Macro Default File Macro  default file macro ','default_file_macro',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'File\'\'Macro\'\'Default\'\'File\'\'Macro\'\'default\'\'file\'\'macro Macro\'\'/\'\'File','000001000001000048000001'),('PBtmpl0000000000000026','Default Forum','Default Forum Default Forum  default forum ','default_forum',1124395696,1147642413,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Default\'\'Forum\'\'default\'\'forum Collaboration','000001000001000028000007'),('PBtmpl0000000000000031','Default Forum Search','Default Forum Search Default Forum Search  default forum search ','default_forum_search',1124395696,1147642413,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Search\'\'Default\'\'Forum\'\'Search\'\'default\'\'forum\'\'search Collaboration\'\'/\'\'Search','000001000001000028000016'),('PBtmpl0000000000000062','Default Gradebook Report','Default Gradebook Report Default Gradebook Report  default gradebook report ','default_gradebook_report',1124395696,1147642413,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Gradebook\'\'Report\'\'Default\'\'Gradebook\'\'Report\'\'default\'\'gradebook\'\'report Survey\'\'/\'\'Gradebook','000001000001000078000002'),('DPUROtmpl0000000000001','Default Grouped Aggregate Feeds','Default Grouped Aggregate Feeds Default Grouped Aggregate Feeds  templates syndicatedcontent default grouped feeds ','templates/syndicatedcontent/default_grouped_feeds',1124395707,1147642413,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Grouped\'\'Aggregate\'\'Feeds\'\'Default\'\'Grouped\'\'Aggregate\'\'Feeds\'\'templates\'\'syndicatedcontent\'\'default\'\'grouped\'\'feeds SyndicatedContent','000001000001000079000003'),('PBtmpl0000000000000093','crumbTrail','crumbTrail crumbTrail  crumbtrail2 ','crumbtrail2',1124395696,1147642412,'3','7','12','WebGUI::Asset::Template',1,'crumbTrail\'\'crumbTrail\'\'crumbtrail2 Navigation','000001000001000060000003'),('DashboardViewTmpl00001','Dashboard Default View','Dashboard Default View Dashboard Default View  dashboard default view template ','dashboard-default-view-template',1133743239,1147642412,'3','7','12','WebGUI::Asset::Template',1,'Dashboard\'\'Default\'\'View\'\'Dashboard\'\'Default\'\'View\'\'dashboard\'\'default\'\'view\'\'template Dashboard','000001000001000029000001'),('PBtmpl0000000000000021','Data List','Data List Data List  data list ','data_list',1124395696,1150476306,'3','7','12','WebGUI::Asset::Template',1,'Data\'\'List\'\'Data\'\'List\'\'data\'\'list DataForm\'\'/\'\'List','000001000001000030000004'),('PBtmpl0000000000000104','Default Acknowledgement','Default Acknowledgement Default Acknowledgement  default acknowledgement ','default_acknowledgement',1124395696,1147642412,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Acknowledgement\'\'Default\'\'Acknowledgement\'\'default\'\'acknowledgement DataForm','000001000001000030000003'),('PBtmpl0000000000000002','Default Article','Default Article Default Article  default article ','default_article',1124395696,1159989349,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Article\'\'Default\'\'Article\'\'default\'\'article Article','000001000001000019000003'),('PBtmpl0000000000000141','Default DataForm','Default DataForm Default DataForm  pbtmpl0000000000000141 ','pbtmpl0000000000000141',1124395696,1150476306,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'DataForm\'\'Default\'\'DataForm\'\'pbtmpl0000000000000141 DataForm','000001000001000030000006'),('PBtmpl0000000000000051','Default Edit Profile Template','Default Edit Profile Template Default Edit Profile Template  default edit profile template ','default_edit_profile_template',1124395696,1147642412,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Edit\'\'Profile\'\'Template\'\'Default\'\'Edit\'\'Profile\'\'Template\'\'default\'\'edit\'\'profile\'\'template Operation\'\'/\'\'Profile\'\'/\'\'Edit','000001000001000061000001'),('EventManagerTmpl000003','Default Event Management System Checkout','Default Event Management System Checkout Default Event Management System Checkout  default ems template checkout ','default-ems-template-checkout',1147642412,1171466654,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'Checkout\'\'Default\'\'Event\'\'Management\'\'System\'\'Checkout\'\'default\'\'ems\'\'template\'\'checkout EventManagementSystem_checkout','000001000001000031000001'),('EventManagerTmpl000004','Default Event Management System Manage Purchases','Default Event Management System Manage Purchases Default Event Management System Manage Purchases  default ems template manage purchases ','default-ems-template-manage-purchases',1147642412,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'Manage\'\'Purchases\'\'Default\'\'Event\'\'Management\'\'System\'\'Manage\'\'Purchases\'\'default\'\'ems\'\'template\'\'manage\'\'purchases EventManagementSystem_managePurchas','000001000001000032000001'),('EventManagerTmpl000006','Default Event Management System Search','Default Event Management System Search Default Event Management System Search  default ems search template ','default-ems-search-template',1147642412,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Event\'\'Management\'\'System\'\'Search\'\'Default\'\'Event\'\'Management\'\'System\'\'Search\'\'default\'\'ems\'\'search\'\'template EventManagementSystem_search','000001000001000033000001'),('WikiRCTmpl000000000001','Default Recent Changes','Default Recent Changes Default Recent Changes  default wiki recent changes ','default-wiki-recent-changes',1165460175,1169092823,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Recent\'\'Changes\'\'Default\'\'Recent\'\'Changes\'\'default\'\'wiki\'\'recent\'\'changes WikiMaster_recentChanges','000001000001000096000001'),('PBtmpl0000000000000105','Calendar Month (Small)','Calendar Month (Small) Calendar Month (Small)  calendar month small ','calendar_month_small',1124395696,1147642411,'3','7','12','WebGUI::Asset::Template',1,'Calendar\'\'Month\'\'(\'\'Small\'\')\'\'Calendar\'\'Month\'\'(\'\'Small\'\')\'\'calendar\'\'month\'\'small EventsCalendar','000001000001000035000001'),('PBtmpl0000000000000084','Center Image','Center Image Center Image  center image ','center_image',1124395696,1147642411,'3','7','12','WebGUI::Asset::Template',1,'Center\'\'Image\'\'Center\'\'Image\'\'center\'\'image Article','000001000001000019000002'),('PBtmpl0000000000000128','Classifieds','Classifieds Classifieds  classifieds ','classifieds',1124395696,1147642411,'3','7','12','WebGUI::Asset::Template',1,'Classifieds\'\'Classifieds\'\'classifieds Collaboration','000001000001000028000008'),('PBtmpl0000000000000134','Cool Menus','Cool Menus Cool Menus  cool menus ','cool_menus',1124395696,1147642411,'3','7','12','WebGUI::Asset::Template',1,'Cool\'\'Menus\'\'Cool\'\'Menus\'\'cool\'\'menus Navigation','000001000001000060000009'),('PBtmplHelp000000000001','Help','Help Help  help ','help',1124395706,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Help\'\'Help\'\'help AdminConsole','000001000001000018000002'),('PBtmpl0000000000000208','Request Tracker','Request Tracker Request Tracker  request tracker template ','request-tracker-template',1147642410,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'template Collaboration','000001000001000028000028'),('PBtmpl0000000000000205','Default Inbox Message','Default Inbox Message Default Inbox Message  default inbox message ','default_inbox_message',1147642410,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'Message\'\'Default\'\'Inbox\'\'Message\'\'default\'\'inbox\'\'message Inbox\'\'/\'\'Message','000001000001000040000002'),('PBtmpl0000000000000206','Default Inbox','Default Inbox Default Inbox  default inbox ','default_inbox',1147642410,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'Default\'\'Inbox\'\'default\'\'inbox Inbox','000001000001000040000001'),('PBtmpl0000000000000090','DHTML Admin Bar','DHTML Admin Bar DHTML Admin Bar  dhtml admin bar ','dhtml_admin_bar',1124395696,1147642410,'3','7','12','WebGUI::Asset::Template',1,'DHTML\'\'Admin\'\'Bar\'\'DHTML\'\'Admin\'\'Bar\'\'dhtml\'\'admin\'\'bar Macro\'\'/\'\'AdminBar','000001000001000044000001'),('PBtmpl0000000000000207',' Article with Files',' Article with Files Article with Files  article with files ','article-with-files',1147642410,1184192509,'3','7','12','WebGUI::Asset::Template',1,'Article\'\'with\'\'Files\'\'Article\'\'with\'\'Files\'\'article\'\'with\'\'files Article','000001000001000019000007'),('PBtmpl0000000000000209','Request Tracker Thread','Request Tracker Thread Request Tracker Thread  request tracker post template ','request-tracker-post-template',1147642410,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Thread\'\'Request\'\'Tracker\'\'Thread\'\'request\'\'tracker\'\'post\'\'template Collaboration\'\'/\'\'Thread','000001000001000028000029'),('PBtmpl0000000000000210','Request Tracker','Request Tracker Request Tracker  request tracker template2 ','request-tracker-template2',1147642410,1152740956,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'template2 Collaboration\'\'/\'\'PostForm','000001000001000028000030'),('SQLFormEditTmpl0000001','Default SQLForm Edit template','Default SQLForm Edit template Default SQLForm Edit template  default sqlform edit template ','default_sqlform_edit_template',1147642410,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'SQLForm\'\'Edit\'\'template\'\'Default\'\'SQLForm\'\'Edit\'\'template\'\'default\'\'sqlform\'\'edit\'\'template SQLForm\'\'/\'\'Edit','000001000001000073000001'),('SQLFormSearchTmpl00001','Default SQLForm Search template','Default SQLForm Search template Default SQLForm Search template  default sqlform search template ','default_sqlform_search_template',1147642410,1166718668,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'SQLForm\'\'Search\'\'template\'\'Default\'\'SQLForm\'\'Search\'\'template\'\'default\'\'sqlform\'\'search\'\'template SQLForm\'\'/\'\'Search','000001000001000074000001'),('PBtmpl0000000000000109','One Over Three','One Over Three One Over Three  one over three ','one_over_three',1124395696,1147642410,'3','7','12','WebGUI::Asset::Template',1,'One\'\'Over\'\'Three\'\'One\'\'Over\'\'Three\'\'one\'\'over\'\'three Layout','000001000001000043000006'),('PBtmpl0000000000000001','Admin Console','Admin Console Admin Console  admin console2 ','admin_console2',1124395696,1157679164,'3','7','12','WebGUI::Asset::Template',1,'Admin\'\'Console\'\'Admin\'\'Console\'\'admin\'\'console2 AdminConsole','000001000001000018000001'),('PBtmpl0000000000000095','Benefits Showcase','Benefits Showcase Benefits Showcase  benefits showcase ','benefits_showcase',1124395696,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Benefits\'\'Showcase\'\'Benefits\'\'Showcase\'\'benefits\'\'showcase Product','000001000001000065000002'),('LBuiKzg2mWwmOPS9AgV3bg','Get Translated','Let our team of professional translators bring your site to new customers by translating your content into additional languages. Our translation services are never machine automated. They\'re always done by professional translators that have years of exper','yns/translated',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Translated\'\'Get\'\'Translated\'\'yns\'\'translated\'\'Let\'\'our\'\'team\'\'of\'\'professional\'\'translators\'\'bring\'\'your\'\'site\'\'to\'\'new\'\'customers\'\'by\'\'translating\'\'your\'\'content\'\'into\'\'additional\'\'languages\'\'.\'\'Our\'\'translation\'\'services\'\'are\'\'never\'\'machine\'\'automated\'\'.\'\'They\'\'\'\'\'re\'\'always\'\'done\'\'by\'\'professional\'\'translators\'\'that\'\'have\'\'years\'\'of\'\'experience\'\'reading\'\',\'\'writing\'\',\'\'and\'\'speaking\'\'many\'\'languages\'\'.  ','000001000002000004000007'),('jTNggl7AoVSUc_ZzrvuCmw','Get Promoted','Now that you have a brilliant WebGUI site, you need to get people to visit it. We can help there too. Our marketing specialists can work with you to develop and execute the right combination of search engine placement, advertising buys, and affilliate pro','yns/promotion',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Promoted\'\'Get\'\'Promoted\'\'yns\'\'promotion\'\'Now\'\'that\'\'you\'\'have\'\'a\'\'brilliant\'\'WebGUI\'\'site\'\',\'\'you\'\'need\'\'to\'\'get\'\'people\'\'to\'\'visit\'\'it\'\'.\'\'We\'\'can\'\'help\'\'there\'\'too\'\'.\'\'Our\'\'marketing\'\'specialists\'\'can\'\'work\'\'with\'\'you\'\'to\'\'develop\'\'and\'\'execute\'\'the\'\'right\'\'combination\'\'of\'\'search\'\'engine\'\'placement\'\',\'\'advertising\'\'buys\'\',\'\'and\'\'affilliate\'\'programs\'\'to\'\'ensure\'\'your\'\'site\'\'gets\'\'the\'\'traffic\'\'it\'\'needs\'\'.  ','000001000002000004000008'),('Wl8WZ43g2rK5AYr9o4zY7w','Get Style','Not a designer? No problem! Plain Black\'s professional design team can make your site look great. Our team is fast, easy to work with, and can even migrate your existing content into your new WebGUI site. ','yns/style',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Style\'\'Get\'\'Style\'\'yns\'\'style\'\'Not\'\'a\'\'designer\'\'?\'\'No\'\'problem\'\'!\'\'Plain\'\'Black\'\'\'\'\'s\'\'professional\'\'design\'\'team\'\'can\'\'make\'\'your\'\'site\'\'look\'\'great\'\'.\'\'Our\'\'team\'\'is\'\'fast\'\',\'\'easy\'\'to\'\'work\'\'with\'\',\'\'and\'\'can\'\'even\'\'migrate\'\'your\'\'existing\'\'content\'\'into\'\'your\'\'new\'\'WebGUI\'\'site\'\'.  ','000001000002000004000006'),('ix1p0AbwKAz8QWB-T-HHfg','Get Support','Plain Black provides support packages to fit any budget or need. Start out with online support which costs only $500 per year! And grow support as your needs grow. We build custom support packages to match our client\'s needs. And no matter what level of s','yns/support',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Support\'\'Get\'\'Support\'\'yns\'\'support\'\'Plain\'\'Black\'\'provides\'\'support\'\'packages\'\'to\'\'fit\'\'any\'\'budget\'\'or\'\'need\'\'.\'\'Start\'\'out\'\'with\'\'online\'\'support\'\'which\'\'costs\'\'only\'\'$\'\'500\'\'per\'\'year\'\'!\'\'And\'\'grow\'\'support\'\'as\'\'your\'\'needs\'\'grow\'\'.\'\'We\'\'build\'\'custom\'\'support\'\'packages\'\'to\'\'match\'\'our\'\'client\'\'\'\'\'s\'\'needs\'\'.\'\'And\'\'no\'\'matter\'\'what\'\'level\'\'of\'\'support\'\'you\'\'purchase\'\',\'\'you\'\'get\'\'WebGUI\'\'Documentation\'\'included\'\'in\'\'your\'\'purchase\'\'.  ','000001000002000004000003'),('iCYOjohB9SKvAPr6bXElKA','Get Hosting','Who better to host your WebGUI sites than Plain Black. Let us deal with upgrades, security, and server management. Doing so lets you focus on building your WebGUI site, which is where your time and expertise should be spent. And when you sign up with host','yns/hosting',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Hosting\'\'Get\'\'Hosting\'\'yns\'\'hosting\'\'Who\'\'better\'\'to\'\'host\'\'your\'\'WebGUI\'\'sites\'\'than\'\'Plain\'\'Black\'\'.\'\'Let\'\'us\'\'deal\'\'with\'\'upgrades\'\',\'\'security\'\',\'\'and\'\'server\'\'management\'\'.\'\'Doing\'\'so\'\'lets\'\'you\'\'focus\'\'on\'\'building\'\'your\'\'WebGUI\'\'site\'\',\'\'which\'\'is\'\'where\'\'your\'\'time\'\'and\'\'expertise\'\'should\'\'be\'\'spent\'\'.\'\'And\'\'when\'\'you\'\'sign\'\'up\'\'with\'\'hosting\'\',\'\'online\'\'support\'\'is\'\'included\'\'!  ','000001000002000004000004'),('4Yfz9hqBqM8OYMGuQK8oLw','Get Features','What\'s that you say? WebGUI\'s thousands of features are still missing some important ones? No problem, our professional development team can add any features you need for your site. We\'ve built hundreds of custom apps for people. From simple macros, to cu','yns/features',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Features\'\'Get\'\'Features\'\'yns\'\'features\'\'What\'\'\'\'\'s\'\'that\'\'you\'\'say\'\'?\'\'WebGUI\'\'\'\'\'s\'\'thousands\'\'of\'\'features\'\'are\'\'still\'\'missing\'\'some\'\'important\'\'ones\'\'?\'\'No\'\'problem\'\',\'\'our\'\'professional\'\'development\'\'team\'\'can\'\'add\'\'any\'\'features\'\'you\'\'need\'\'for\'\'your\'\'site\'\'.\'\'We\'\'\'\'\'ve\'\'built\'\'hundreds\'\'of\'\'custom\'\'apps\'\'for\'\'people\'\'.\'\'From\'\'simple\'\'macros\'\',\'\'to\'\'custom\'\'single\'\'sign\'\'on\'\'systems\'\',\'\'to\'\'applications\'\'that\'\'will\'\'manage\'\'your\'\'entire\'\'company\'\',\'\'our\'\'team\'\'can\'\'do\'\'it\'\'.  ','000001000002000004000005'),('Vzv1pWpg_w6R_o-b0rM2qQ','Ad','Ad Ad  home ad2 ','home/ad2',1147642515,1147642515,'3','7','4','WebGUI::Asset::File',1,'Ad\'\'Ad\'\'home\'\'ad2','000001000002000003000002'),('FOvmwGC0GtZo5VTxJIL3OA','Get Documentation','WebGUI Documentation is the ultimate compendium to WebGUI. It is more than just documentation, it\'s also a library of hundreds of videos that show you exactly how to get stuff done. This is a must for anyone working in WebGUI, and Plain Black offers vast ','yns/docs',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Documentation\'\'Get\'\'Documentation\'\'yns\'\'docs\'\'WebGUI\'\'Documentation\'\'is\'\'the\'\'ultimate\'\'compendium\'\'to\'\'WebGUI\'\'.\'\'It\'\'is\'\'more\'\'than\'\'just\'\'documentation\'\',\'\'it\'\'\'\'\'s\'\'also\'\'a\'\'library\'\'of\'\'hundreds\'\'of\'\'videos\'\'that\'\'show\'\'you\'\'exactly\'\'how\'\'to\'\'get\'\'stuff\'\'done\'\'.\'\'This\'\'is\'\'a\'\'must\'\'for\'\'anyone\'\'working\'\'in\'\'WebGUI\'\',\'\'and\'\'Plain\'\'Black\'\'offers\'\'vast\'\'bulk\'\'discounts\'\'so\'\'you\'\'can\'\'give\'\'it\'\'to\'\'everyone\'\'in\'\'your\'\'organization\'\'.  ','000001000002000004000002'),('6QuS-0rosuZTdTv11fobig','Talk to the Experts','Plain Black&reg; created the WebGUI Content Engine&reg; and is here to answer your questions and provide you with services to make sure your WebGUI implementation is entirely successful. We bend over backwards to make sure you\'re a success. Contact us tod','yns/experts',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Talk\'\'to\'\'the\'\'Experts\'\'Talk\'\'to\'\'the\'\'Experts\'\'yns\'\'experts\'\'Plain\'\'Black\'\'&\'\'reg\'\';\'\'created\'\'the\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'and\'\'is\'\'here\'\'to\'\'answer\'\'your\'\'questions\'\'and\'\'provide\'\'you\'\'with\'\'services\'\'to\'\'make\'\'sure\'\'your\'\'WebGUI\'\'implementation\'\'is\'\'entirely\'\'successful\'\'.\'\'We\'\'bend\'\'over\'\'backwards\'\'to\'\'make\'\'sure\'\'you\'\'\'\'\'re\'\'a\'\'success\'\'.\'\'Contact\'\'us\'\'today\'\'to\'\'see\'\'how\'\'we\'\'can\'\'help\'\'you\'\'.  ','000001000002000004000001'),('NK8bqlwVRILJknqeCDPBHg','Getting Started (part 2)','\n\nNow you should log in and go into admin mode. The default username is \"admin\" and the default password is \"123qwe\", but you probably customized both of those when you visited this site for the very first time.\n \n\nNow that you\'re logged in, we recommend ','getting_started/getting-started-part2',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting\'\'Started\'\'(\'\'part\'\'2\'\')\'\'Getting\'\'Started\'\'(\'\'part\'\'2\'\')\'\'getting\'\'started\'\'getting\'\'started\'\'part2\'\'Now\'\'you\'\'should\'\'log\'\'in\'\'and\'\'go\'\'into\'\'admin\'\'mode\'\'.\'\'The\'\'default\'\'username\'\'is\'\'\"\'\'admin\'\'\"\'\'and\'\'the\'\'default\'\'password\'\'is\'\'\"\'\'123qwe\'\'\"\'\',\'\'but\'\'you\'\'probably\'\'customized\'\'both\'\'of\'\'those\'\'when\'\'you\'\'visited\'\'this\'\'site\'\'for\'\'the\'\'very\'\'first\'\'time\'\'.\'\'Now\'\'that\'\'you\'\'\'\'\'re\'\'logged\'\'in\'\',\'\'we\'\'recommend\'\'that\'\'you\'\'add\'\'a\'\'new\'\'user\'\'for\'\'yourself\'\'with\'\'admin\'\'privileges\'\'just\'\'in\'\'case\'\'you\'\'forget\'\'the\'\'login\'\'information\'\'for\'\'your\'\'primary\'\'admin\'\'account\'\'.\'\'Don\'\'\'\'\'t\'\'worry\'\'if\'\'you\'\'lock\'\'yourself\'\'out\'\',\'\'you\'\'can\'\'always\'\'contact\'\'Plain\'\'Black\'\'&\'\'reg\'\';\'\'support\'\'to\'\'get\'\'instructions\'\'to\'\'get\'\'back\'\'in\'\'.\'\'NOTE\'\':\'\'If\'\'you\'\'appear\'\'to\'\'be\'\'get\'\'logged\'\'out\'\'while\'\'moving\'\'between\'\'pages\'\',\'\'this\'\'is\'\'most\'\'likely\'\'your\'\'browser\'\'displaying\'\'a\'\'cached\'\'version\'\'of\'\'the\'\'page\'\'.\'\'Click\'\'on\'\'your\'\'browser\'\'\'\'\'s\'\'refresh\'\'button\'\'to\'\'correct\'\'the\'\'problem\'\'.\'\'No\'\'doubt\'\'after\'\'you\'\'enabled\'\'admin\'\'mode\'\'you\'\'saw\'\'a\'\'menu\'\'along\'\'the\'\'left\'\'side\'\'of\'\'the\'\'screen\'\',\'\'that\'\'\'\'\'s\'\'called\'\'the\'\'Admin\'\'Bar\'\'.\'\'Use\'\'that\'\'to\'\'add\'\'content\'\'and\'\'access\'\'administrative\'\'functions\'\'.\'\'You\'\'\'\'\'re\'\'now\'\'ready\'\'to\'\'begin\'\'exploring\'\'your\'\'new\'\'WebGUI\'\'site\'\'.\'\'For\'\'more\'\'information\'\'about\'\'services\'\'related\'\'to\'\'WebGUI\'\'click\'\'here\'\'.\'\'Enjoy\'\'your\'\'new\'\'WebGUI\'\'site\'\'!  ','000001000002000003000003'),('m4YJFaqzultnB_sj1Uq0aw','Ad','Ad Ad  home ad ','home/ad',1147642514,1147642514,'3','7','4','WebGUI::Asset::File',1,'Ad\'\'Ad\'\'home\'\'ad','000001000002000009'),('IWFxZDyGhQ3-SLZhELa3qw','Key Benefits','\n\nEasy To Use - WebGUI is absolutely easy to use. WebGUI 7 has a completely revamped user interface to make it even easier to use. There are lots of visual cues, consistent icons, helper apps, and a huge repository of built-in help files.\n \n\nWorkflow &amp','home/key-benefits',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Key\'\'Benefits\'\'Key\'\'Benefits\'\'home\'\'key\'\'benefits\'\'Easy\'\'To\'\'Use\'\'-\'\'WebGUI\'\'is\'\'absolutely\'\'easy\'\'to\'\'use\'\'.\'\'WebGUI\'\'7\'\'has\'\'a\'\'completely\'\'revamped\'\'user\'\'interface\'\'to\'\'make\'\'it\'\'even\'\'easier\'\'to\'\'use\'\'.\'\'There\'\'are\'\'lots\'\'of\'\'visual\'\'cues\'\',\'\'consistent\'\'icons\'\',\'\'helper\'\'apps\'\',\'\'and\'\'a\'\'huge\'\'repository\'\'of\'\'built\'\'-\'\'in\'\'help\'\'files\'\'.\'\'Workflow\'\'&\'\'amp\'\';\'\'Versioning\'\'-\'\'Never\'\'again\'\'worry\'\'about\'\'content\'\'getting\'\'put\'\'on\'\'your\'\'site\'\'that\'\'you\'\'don\'\'\'\'\'t\'\'want\'\'there\'\'.\'\'Never\'\'again\'\'lose\'\'your\'\'old\'\'content\'\'after\'\'making\'\'an\'\'edit\'\'.\'\'And\'\'never\'\'again\'\'push\'\'out\'\'new\'\'changes\'\'until\'\'you\'\'\'\'\'re\'\'absolutely\'\'ready\'\'to\'\'release\'\'them\'\'.\'\'WebGUI\'\'\'\'\'s\'\'workflow\'\'and\'\'versioning\'\'system\'\'is\'\'fast\'\',\'\'flexible\'\',\'\'powerful\'\',\'\'and\'\'easy\'\'to\'\'use\'\'.\'\'Everything\'\'\'\'\'s\'\'a\'\'Template\'\'-\'\'Worry\'\'nevermore\'\'about\'\'your\'\'CMS\'\'forcing\'\'you\'\'into\'\'a\'\'mould\'\'that\'\'doesn\'\'\'\'\'t\'\'suit\'\'you\'\'.\'\'With\'\'WebGUI\'\'everything\'\'a\'\'site\'\'visitor\'\'can\'\'see\'\'is\'\'a\'\'customizable\'\'template\'\',\'\'so\'\'you\'\'can\'\'make\'\'it\'\'look\'\'exactly\'\'how\'\'you\'\'want\'\'.\'\'Moreover\'\'if\'\'you\'\'\'\'\'re\'\'the\'\'type\'\'that\'\'strives\'\'for\'\'excellence\'\'rest\'\'in\'\'the\'\'knowledge\'\'that\'\'all\'\'the\'\'templates\'\'that\'\'come\'\'with\'\'WebGUI\'\'are\'\'XHTML\'\'1\'\'.\'\'0\'\'strict\'\'compliant\'\'.\'\'Localization\'\'-\'\'WebGUI\'\'\'\'\'s\'\'entire\'\'user\'\'interface\'\'is\'\'set\'\'up\'\'to\'\'be\'\'internationalized\'\'.\'\'Visit\'\'one\'\'of\'\'the\'\'WebGUI\'\'Worldwide\'\'member\'\'sites\'\'to\'\'get\'\'translations\'\'for\'\'your\'\'language\'\'.\'\'Stay\'\'there\'\'to\'\'get\'\'support\'\'and\'\'services\'\'in\'\'your\'\'native\'\'language\'\'.\'\'Feel\'\'confident\'\'in\'\'the\'\'knowledge\'\'that\'\'WebGUI\'\'will\'\'work\'\'with\'\'your\'\'native\'\'characters\'\'because\'\'it\'\'\'\'\'s\'\'UTF\'\'-\'\'8\'\'compliant\'\'.\'\'On\'\'top\'\'of\'\'that\'\'WebGUI\'\'allows\'\'you\'\'to\'\'customize\'\'dates\'\',\'\'currency\'\',\'\'and\'\'weights\'\'to\'\'match\'\'your\'\'locale\'\'.\'\'Pluggable\'\'By\'\'Design\'\'-\'\'With\'\'WebGUI\'\'7\'\'you\'\'have\'\'many\'\'plug\'\'-\'\'in\'\'points\'\'to\'\'add\'\'your\'\'own\'\'functionality\'\'.\'\'And\'\'best\'\'of\'\'all\'\',\'\'the\'\'API\'\'is\'\'stable\'\'and\'\'standardized\'\'.\'\'Write\'\'it\'\'today\'\'and\'\'it\'\'will\'\'still\'\'work\'\'years\'\'from\'\'now\'\'and\'\'survive\'\'all\'\'upgrades\'\'.  ','000001000002000010'),('bX5rYxb6tZ9docY6sUhBlw','Getting Started','\n\nIf you\'re reading this message that means you\'ve successfully installed and configured the WebGUI Content Engine&reg;. Great job! To get started with managing content, watch the short instructional video below.\n \nNOTE: Click on the green start icon on t','getting_started/getting-started',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting\'\'Started\'\'Getting\'\'Started\'\'getting\'\'started\'\'getting\'\'started\'\'If\'\'you\'\'\'\'\'re\'\'reading\'\'this\'\'message\'\'that\'\'means\'\'you\'\'\'\'\'ve\'\'successfully\'\'installed\'\'and\'\'configured\'\'the\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'.\'\'Great\'\'job\'\'!\'\'To\'\'get\'\'started\'\'with\'\'managing\'\'content\'\',\'\'watch\'\'the\'\'short\'\'instructional\'\'video\'\'below\'\'.\'\'NOTE\'\':\'\'Click\'\'on\'\'the\'\'green\'\'start\'\'icon\'\'on\'\'the\'\'video\'\'to\'\'begin\'\'your\'\'tutorial\'\'.  ','000001000002000003000001'),('Szs5eev3OMssmnsyLRZmWA','Tell A Friend','Tell a friend about WebGUI.','tell_a_friend/tell_a_friend',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::DataForm',1,'Tell\'\'A\'\'Friend\'\'Tell\'\'A\'\'Friend\'\'tell\'\'a\'\'friend\'\'tell\'\'a\'\'friend\'\'Tell\'\'a\'\'friend\'\'about\'\'WebGUI\'\'.','000001000002000006000001'),('OhdaFLE7sXOzo_SIP2ZUgA','Welcome','The WebGUI Content Engine&reg; is a powerful and easy to use system for managing web sites, and building web applications. It provides thousands of features out of the box, and lots of plug-in points so you can extend it to match your needs. It\'s easy eno','home/welcome',1147642513,1147642513,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Welcome\'\'Welcome\'\'home\'\'welcome\'\'The\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'is\'\'a\'\'powerful\'\'and\'\'easy\'\'to\'\'use\'\'system\'\'for\'\'managing\'\'web\'\'sites\'\',\'\'and\'\'building\'\'web\'\'applications\'\'.\'\'It\'\'provides\'\'thousands\'\'of\'\'features\'\'out\'\'of\'\'the\'\'box\'\',\'\'and\'\'lots\'\'of\'\'plug\'\'-\'\'in\'\'points\'\'so\'\'you\'\'can\'\'extend\'\'it\'\'to\'\'match\'\'your\'\'needs\'\'.\'\'It\'\'\'\'\'s\'\'easy\'\'enough\'\'for\'\'the\'\'average\'\'business\'\'user\'\',\'\'but\'\'powerful\'\'enough\'\'for\'\'any\'\'large\'\'enterprise\'\'.\'\'There\'\'are\'\'thousands\'\'of\'\'small\'\'and\'\'large\'\'businesses\'\',\'\'schools\'\',\'\'universities\'\',\'\'governments\'\',\'\'associations\'\',\'\'clubs\'\',\'\'churches\'\',\'\'projects\'\',\'\'and\'\'communities\'\'using\'\'WebGUI\'\'all\'\'over\'\'the\'\'world\'\'today\'\'.\'\'A\'\'brief\'\'list\'\'of\'\'some\'\'of\'\'them\'\'can\'\'be\'\'found\'\'here\'\'.\'\'Your\'\'site\'\'should\'\'be\'\'on\'\'that\'\'list\'\'.\'\'If\'\'you\'\'\'\'\'re\'\'new\'\'to\'\'WebGUI\'\',\'\'click\'\'here\'\'to\'\'learn\'\'how\'\'to\'\'get\'\'started\'\'.\'\'If\'\'you\'\'\'\'\'re\'\'getting\'\'up\'\'to\'\'speed\'\',\'\'check\'\'out\'\'some\'\'ways\'\'you\'\'can\'\'do\'\'more\'\'faster\'\'.\'\'If\'\'this\'\'is\'\'all\'\'old\'\'hat\'\'to\'\'you\'\',\'\'then\'\'check\'\'out\'\'the\'\'latest\'\'news\'\'.\'\'No\'\'matter\'\'what\'\'level\'\'you\'\'\'\'\'re\'\'at\'\'tell\'\'your\'\'friends\'\'about\'\'WebGUI\'\'.  ','000001000002000008'),('pbrobot000000000000001','robots.txt','robots.txt robots.txt  robots.txt ','robots.txt',1147642511,1147642511,'3','7','12','WebGUI::Asset::Snippet',1,'robots\'\'.\'\'txt\'\'robots\'\'.\'\'txt\'\'robots\'\'.\'\'txt User\'\'-\'\'agent\'\':\'\'googlebot\'\'Disallow\'\':\'\'*\'\'?\'\'op\'\'=\'\'displayLogin\'\'Disallow\'\':\'\'*\'\'?\'\'op\'\'=\'\'makePrintable','000001000001000091'),('7.0-style0000000000071','wg.jpg','wg.jpg wg.jpg  style3 wg.jpg ','style3/wg.jpg',1147642511,1147642511,'3','7','12','WebGUI::Asset::File::Image',1,'wg\'\'.\'\'jpg\'\'wg\'\'.\'\'jpg\'\'style3\'\'wg\'\'.\'\'jpg','000001000001000090000022'),('7.0-style0000000000068','spacer.gif','spacer.gif spacer.gif  style3 spacer.gif ','style3/spacer.gif',1147642510,1147642510,'3','7','12','WebGUI::Asset::File::Image',1,'spacer\'\'.\'\'gif\'\'spacer\'\'.\'\'gif\'\'style3\'\'spacer\'\'.\'\'gif','000001000001000090000019'),('7.0-style0000000000070','Style3 Coolmenu','Style3 Coolmenu Style3 Coolmenu  style3 coolmenu ','style3_coolmenu',1147642510,1147642510,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3\'\'Coolmenu\'\'Style3\'\'Coolmenu\'\'style3\'\'coolmenu','000001000001000090000021'),('stevestyle000000000003','Style 03','Style 03 Style 03  style 03 ','style_03',1147642510,1178723413,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'03\'\'Style\'\'03\'\'style\'\'03 style','000001000001000090000020'),('7.0-style0000000000066','nav_bg_on.jpg','nav_bg_on.jpg nav_bg_on.jpg  style3 nav bg on.jpg ','style3/nav_bg_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg_on\'\'.\'\'jpg\'\'nav_bg_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg\'\'on\'\'.\'\'jpg','000001000001000090000017'),('7.0-style0000000000064','nav_bg2.jpg','nav_bg2.jpg nav_bg2.jpg  style3 nav bg2.jpg ','style3/nav_bg2.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2\'\'.\'\'jpg\'\'nav_bg2\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg2\'\'.\'\'jpg','000001000001000090000015'),('7.0-style0000000000065','nav_bg2_on.jpg','nav_bg2_on.jpg nav_bg2_on.jpg  style3 nav bg2 on.jpg ','style3/nav_bg2_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2_on\'\'.\'\'jpg\'\'nav_bg2_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg2\'\'on\'\'.\'\'jpg','000001000001000090000016'),('7.0-style0000000000067','pb.jpg','pb.jpg pb.jpg  style3 pb.jpg ','style3/pb.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'pb\'\'.\'\'jpg\'\'pb\'\'.\'\'jpg\'\'style3\'\'pb\'\'.\'\'jpg','000001000001000090000018'),('7.0-style0000000000063','nav_bg1_on.jpg','nav_bg1_on.jpg nav_bg1_on.jpg  style3 nav bg1 on.jpg ','style3/nav_bg1_on.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1_on\'\'.\'\'jpg\'\'nav_bg1_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg1\'\'on\'\'.\'\'jpg','000001000001000090000014'),('7.0-style0000000000060','main_top_bg.jpg','main_top_bg.jpg main_top_bg.jpg  style3 main top bg.jpg ','style3/main_top_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'main_top_bg\'\'.\'\'jpg\'\'main_top_bg\'\'.\'\'jpg\'\'style3\'\'main\'\'top\'\'bg\'\'.\'\'jpg','000001000001000090000011'),('7.0-style0000000000062','nav_bg1.jpg','nav_bg1.jpg nav_bg1.jpg  style3 nav bg1.jpg ','style3/nav_bg1.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1\'\'.\'\'jpg\'\'nav_bg1\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg1\'\'.\'\'jpg','000001000001000090000013'),('7.0-style0000000000061','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style3 nav bg.jpg ','style3/nav_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000090000012'),('7.0-style0000000000059','main_top.jpg','main_top.jpg main_top.jpg  style3 main top.jpg ','style3/main_top.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_top\'\'.\'\'jpg\'\'main_top\'\'.\'\'jpg\'\'style3\'\'main\'\'top\'\'.\'\'jpg','000001000001000090000010'),('7.0-style0000000000057','main_bg.jpg','main_bg.jpg main_bg.jpg  style3 main bg.jpg ','style3/main_bg.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style3\'\'main\'\'bg\'\'.\'\'jpg','000001000001000090000008'),('7.0-style0000000000058','main_bottom.jpg','main_bottom.jpg main_bottom.jpg  style3 main bottom.jpg ','style3/main_bottom.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bottom\'\'.\'\'jpg\'\'main_bottom\'\'.\'\'jpg\'\'style3\'\'main\'\'bottom\'\'.\'\'jpg','000001000001000090000009'),('7.0-style0000000000055','header_left.jpg','header_left.jpg header_left.jpg  style3 header left.jpg ','style3/header_left.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_left\'\'.\'\'jpg\'\'header_left\'\'.\'\'jpg\'\'style3\'\'header\'\'left\'\'.\'\'jpg','000001000001000090000006'),('7.0-style0000000000056','header_right.jpg','header_right.jpg header_right.jpg  style3 header right.jpg ','style3/header_right.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_right\'\'.\'\'jpg\'\'header_right\'\'.\'\'jpg\'\'style3\'\'header\'\'right\'\'.\'\'jpg','000001000001000090000007'),('7.0-style0000000000054','header_bg.jpg','header_bg.jpg header_bg.jpg  style3 header bg.jpg ','style3/header_bg.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_bg\'\'.\'\'jpg\'\'header_bg\'\'.\'\'jpg\'\'style3\'\'header\'\'bg\'\'.\'\'jpg','000001000001000090000005'),('7.0-style0000000000052','footer_bg.jpg','footer_bg.jpg footer_bg.jpg  style3 footer bg.jpg ','style3/footer_bg.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_bg\'\'.\'\'jpg\'\'footer_bg\'\'.\'\'jpg\'\'style3\'\'footer\'\'bg\'\'.\'\'jpg','000001000001000090000003'),('stevecoolmenu000000001','Newer Coolmenu','Newer Coolmenu Newer Coolmenu  newer coolmenu ','newer-coolmenu',1147642505,1147642505,'3','7','12','WebGUI::Asset::Template',1,'Newer\'\'Coolmenu\'\'Newer\'\'Coolmenu\'\'newer\'\'coolmenu Navigation','000001000001000090000001'),('7.0-style0000000000053','footer_right.jpg','footer_right.jpg footer_right.jpg  style3 footer right.jpg ','style3/footer_right.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_right\'\'.\'\'jpg\'\'footer_right\'\'.\'\'jpg\'\'style3\'\'footer\'\'right\'\'.\'\'jpg','000001000001000090000004'),('7.0-style0000000000046','rightCol_bg.jpg','rightCol_bg.jpg rightCol_bg.jpg  style2 rightcol bg.jpg ','style2/rightcol_bg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'rightCol_bg\'\'.\'\'jpg\'\'rightCol_bg\'\'.\'\'jpg\'\'style2\'\'rightcol\'\'bg\'\'.\'\'jpg','000001000001000089000015'),('stevestyle000000000002','Style 02','Style 02 Style 02  style 02 ','style_02',1147642504,1147642504,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'02\'\'Style\'\'02\'\'style\'\'02 style','000001000001000089000016'),('7.0-style0000000000049','WebGUI 7 Style 3','WebGUI 7 Style 3 WebGUI 7 Style 3  root import webgui 7 style 3 ','root/import/webgui-7-style-3',1147642504,1147642504,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'3\'\'WebGUI\'\'7\'\'Style\'\'3\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'3','000001000001000090'),('7.0-style0000000000048','wg.jpg','wg.jpg wg.jpg  style2 wg.jpg ','style2/wg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'wg\'\'.\'\'jpg\'\'wg\'\'.\'\'jpg\'\'style2\'\'wg\'\'.\'\'jpg','000001000001000089000017'),('7.0-style0000000000045','pb_wg_bg.jpg','pb_wg_bg.jpg pb_wg_bg.jpg  style2 pb wg bg.jpg ','style2/pb_wg_bg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg_bg\'\'.\'\'jpg\'\'pb_wg_bg\'\'.\'\'jpg\'\'style2\'\'pb\'\'wg\'\'bg\'\'.\'\'jpg','000001000001000089000014'),('7.0-style0000000000044','pb_wg.jpg','pb_wg.jpg pb_wg.jpg  style2 pb wg.jpg ','style2/pb_wg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg\'\'.\'\'jpg\'\'pb_wg\'\'.\'\'jpg\'\'style2\'\'pb\'\'wg\'\'.\'\'jpg','000001000001000089000013'),('7.0-style0000000000043','pb.jpg','pb.jpg pb.jpg  style2 pb.jpg ','style2/pb.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb\'\'.\'\'jpg\'\'pb\'\'.\'\'jpg\'\'style2\'\'pb\'\'.\'\'jpg','000001000001000089000012'),('7.0-style0000000000042','page_title_bg.jpg','page_title_bg.jpg page_title_bg.jpg  style2 page title bg.jpg ','style2/page_title_bg.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title_bg\'\'.\'\'jpg\'\'page_title_bg\'\'.\'\'jpg\'\'style2\'\'page\'\'title\'\'bg\'\'.\'\'jpg','000001000001000089000011'),('7.0-style0000000000041','page_title.jpg','page_title.jpg page_title.jpg  style2 page title.jpg ','style2/page_title.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title\'\'.\'\'jpg\'\'page_title\'\'.\'\'jpg\'\'style2\'\'page\'\'title\'\'.\'\'jpg','000001000001000089000010'),('7.0-style0000000000040','navbar_right.jpg','navbar_right.jpg navbar_right.jpg  style2 navbar right.jpg ','style2/navbar_right.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_right\'\'.\'\'jpg\'\'navbar_right\'\'.\'\'jpg\'\'style2\'\'navbar\'\'right\'\'.\'\'jpg','000001000001000089000009'),('7.0-style0000000000039','navbar_left.jpg','navbar_left.jpg navbar_left.jpg  style2 navbar left.jpg ','style2/navbar_left.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_left\'\'.\'\'jpg\'\'navbar_left\'\'.\'\'jpg\'\'style2\'\'navbar\'\'left\'\'.\'\'jpg','000001000001000089000008'),('7.0-style0000000000036','main_bg.jpg','main_bg.jpg main_bg.jpg  style2 main bg.jpg ','style2/main_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style2\'\'main\'\'bg\'\'.\'\'jpg','000001000001000089000005'),('7.0-style0000000000038','navbar_bg.jpg','navbar_bg.jpg navbar_bg.jpg  style2 navbar bg.jpg ','style2/navbar_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_bg\'\'.\'\'jpg\'\'navbar_bg\'\'.\'\'jpg\'\'style2\'\'navbar\'\'bg\'\'.\'\'jpg','000001000001000089000007'),('7.0-style0000000000035','leftCol_header02.jpg','leftCol_header02.jpg leftCol_header02.jpg  style2 leftcol header02.jpg ','style2/leftcol_header02.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header02\'\'.\'\'jpg\'\'leftCol_header02\'\'.\'\'jpg\'\'style2\'\'leftcol\'\'header02\'\'.\'\'jpg','000001000001000089000004'),('7.0-style0000000000037','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style2 nav bg.jpg ','style2/nav_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style2\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000089000006'),('7.0-style0000000000032','context_bg.jpg','context_bg.jpg context_bg.jpg  style2 context bg.jpg ','style2/context_bg.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'context_bg\'\'.\'\'jpg\'\'context_bg\'\'.\'\'jpg\'\'style2\'\'context\'\'bg\'\'.\'\'jpg','000001000001000089000001'),('7.0-style0000000000031','WebGUI 7 Style 2','WebGUI 7 Style 2 WebGUI 7 Style 2  root import webgui 7 style 2 ','root/import/webgui-7-style-2',1147642500,1147642500,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'2\'\'WebGUI\'\'7\'\'Style\'\'2\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'2','000001000001000089'),('7.0-style0000000000033','css02.css','css02.css css02.css  style2 css02.css ','style2/css02.css',1147642500,1147642500,'3','7','12','WebGUI::Asset::Snippet',1,'css02\'\'.\'\'css\'\'css02\'\'.\'\'css\'\'style2\'\'css02\'\'.\'\'css body\'\',\'\'html\'\'{\'\'height\'\':\'\'100\'\'%\'\';\'\'}\'\'body\'\'{\'\'background\'\':\'\'#\'\'7c9ab0\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'main_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'.\'\'rightColumn\'\'{\'\'width\'\':\'\'20\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'background\'\':\'\'#\'\'eeeeee\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'rightCol_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'pb_wg_bg\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'pb_wg_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'pb_wg\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'pb_wg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'left\'\'no\'\'-\'\'repeat\'\';\'\'height\'\':\'\'53px\'\';\'\'}\'\'.\'\'leftColumn\'\'{\'\'width\'\':\'\'80\'\'%\'\';\'\'background\'\':\'\'white\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'context_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'background\'\':\'\'#\'\'7c9ab0\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'leftCol_header\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'right\'\'no\'\'-\'\'repeat\'\';\'\'height\'\':\'\'86px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title\'\',\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title_bg\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'36pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'variant\'\':\'\'small\'\'-\'\'caps\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'12px\'\';\'\'top\'\':\'\'15px\'\';\'\'left\'\':\'\'5px\'\';\'\'position\'\':\'\'absolute\'\';\'\'z\'\'-\'\'index\'\':\'\'10\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title_bg\'\'{\'\'color\'\':\'\'black\'\';\'\'z\'\'-\'\'index\'\':\'\'5\'\';\'\'top\'\':\'\'17px\'\';\'\'left\'\':\'\'7px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'{\'\'/\'\'*\'\'background\'\':\'\'#\'\'fff\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'context_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'*\'\'/\'\'width\'\':\'\'95\'\'%\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'color\'\':\'\'#\'\'242424\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'position\'\':\'\'relative\'\';\'\'padding\'\'-\'\'left\'\':\'\'1\'\'%\'\';\'\'padding\'\'-\'\'right\'\':\'\'1\'\'%\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'15px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'a\'\'{\'\'color\'\':\'\'#\'\'7C9AB0\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'page_title_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'#\'\'pageTitle\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'page_title\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'right\'\'no\'\'-\'\'repeat\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'50px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'#\'\'pageTitle\'\'h2\'\'{\'\'font\'\'-\'\'size\'\':\'\'14pt\'\';\'\'color\'\':\'\'#\'\'696969\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\'-\'\'top\'\':\'\'2px\'\';\'\'padding\'\'-\'\'left\'\':\'\'25px\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'3px\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'{\'\'width\'\':\'\'85\'\'%\'\';\'\'background\'\':\'\'#\'\'b5b5b5\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'nav_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'#\'\'848484\'\'1px\'\';\'\'margin\'\'-\'\'left\'\':\'\'auto\'\';\'\'margin\'\'-\'\'right\'\':\'\'auto\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'padding\'\'-\'\'left\'\':\'\'3px\'\';\'\'padding\'\'-\'\'top\'\':\'\'7px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'7px\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'line\'\'-\'\'height\'\':\'\'8pt\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'.\'\'selectedMenuItem\'\'{\'\'color\'\':\'\'yellow\'\';\'\'}\'\'#\'\'loginStyles\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'25px\'\';\'\'}\'\'#\'\'loginStyles\'\'a\'\'{\'\'color\'\':\'\'#\'\'89ACCF\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'transparent\'\'2px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'loginStyles\'\'a\'\':\'\'hover\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dotted\'\'#\'\'B2C9D9\'\'2px\'\';\'\'}\'\'.\'\'copyright\'\'{\'\'border\'\'-\'\'top\'\':\'\'solid\'\'silver\'\'3px\'\';\'\'background\'\'-\'\'color\'\':\'\'gray\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'color\'\':\'\'silver\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}','000001000001000089000002'),('7.0-style0000000000034','leftCol_header.jpg','leftCol_header.jpg leftCol_header.jpg  style2 leftcol header.jpg ','style2/leftcol_header.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header\'\'.\'\'jpg\'\'leftCol_header\'\'.\'\'jpg\'\'style2\'\'leftcol\'\'header\'\'.\'\'jpg','000001000001000089000003'),('stevenav00000000000001','Style 01 Nav','Style 01 Nav Style 01 Nav  style1 nav ','style1_nav',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Nav\'\'Style\'\'01\'\'Nav\'\'style1\'\'nav Navigation','000001000001000088000027'),('PBnav000000style01lvl2','Style 01 Nav lvl2','Style 01 Nav lvl2 untitled  style1 nav lvl2 ','style1_nav_lvl2',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Nav\'\'lvl2\'\'untitled\'\'style1\'\'nav\'\'lvl2 Navigation','000001000001000088000028'),('7.0-style0000000000030','webgui_btn.jpg','webgui_btn.jpg webgui_btn.jpg  style1 webgui btn.jpg ','style1/webgui_btn.jpg',1147642499,1147642499,'3','7','12','WebGUI::Asset::File::Image',1,'webgui_btn\'\'.\'\'jpg\'\'webgui_btn\'\'.\'\'jpg\'\'style1\'\'webgui\'\'btn\'\'.\'\'jpg','000001000001000088000029'),('stevestyle000000000001','Style 01','Style 01 Style 01  style 01 ','style_01',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Style\'\'01\'\'style\'\'01 style','000001000001000088000026'),('7.0-style0000000000026','RootTab Level 1','RootTab Level 1 RootTab Level 1  roottab level1 ','roottab_level1',1147642499,1147642499,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'Level\'\'1\'\'RootTab\'\'Level\'\'1\'\'roottab\'\'level1','000001000001000088000025'),('7.0-style0000000000024','orange_left01.jpg','orange_left01.jpg orange_left01.jpg  style1 orange left01.jpg ','style1/orange_left01.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'orange_left01\'\'.\'\'jpg\'\'orange_left01\'\'.\'\'jpg\'\'style1\'\'orange\'\'left01\'\'.\'\'jpg','000001000001000088000023'),('7.0-style0000000000023','nav_on.jpg','nav_on.jpg nav_on.jpg  style1 nav on.jpg ','style1/nav_on.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'nav_on\'\'.\'\'jpg\'\'nav_on\'\'.\'\'jpg\'\'style1\'\'nav\'\'on\'\'.\'\'jpg','000001000001000088000022'),('7.0-style0000000000025','RootTab Level 0','RootTab Level 0 RootTab Level 0  roottab level0 ','roottab_level0',1147642498,1147642498,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'Level\'\'0\'\'RootTab\'\'Level\'\'0\'\'roottab\'\'level0','000001000001000088000024'),('7.0-style0000000000019','nav2_off_right.jpg','nav2_off_right.jpg nav2_off_right.jpg  style1 nav2 off right.jpg ','style1/nav2_off_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_right\'\'.\'\'jpg\'\'nav2_off_right\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'right\'\'.\'\'jpg','000001000001000088000018'),('7.0-style0000000000020','nav2_on_left.jpg','nav2_on_left.jpg nav2_on_left.jpg  style1 nav2 on left.jpg ','style1/nav2_on_left.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_left\'\'.\'\'jpg\'\'nav2_on_left\'\'.\'\'jpg\'\'style1\'\'nav2\'\'on\'\'left\'\'.\'\'jpg','000001000001000088000019'),('7.0-style0000000000022','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style1 nav bg.jpg ','style1/nav_bg.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style1\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000088000021'),('7.0-style0000000000021','nav2_on_right.jpg','nav2_on_right.jpg nav2_on_right.jpg  style1 nav2 on right.jpg ','style1/nav2_on_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_right\'\'.\'\'jpg\'\'nav2_on_right\'\'.\'\'jpg\'\'style1\'\'nav2\'\'on\'\'right\'\'.\'\'jpg','000001000001000088000020'),('7.0-style0000000000017','nav2_off_center.jpg','nav2_off_center.jpg nav2_off_center.jpg  style1 nav2 off center.jpg ','style1/nav2_off_center.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_center\'\'.\'\'jpg\'\'nav2_off_center\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'center\'\'.\'\'jpg','000001000001000088000016'),('7.0-style0000000000016','nav2_center_on.jpg','nav2_center_on.jpg nav2_center_on.jpg  style1 nav2 center on.jpg ','style1/nav2_center_on.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_center_on\'\'.\'\'jpg\'\'nav2_center_on\'\'.\'\'jpg\'\'style1\'\'nav2\'\'center\'\'on\'\'.\'\'jpg','000001000001000088000015'),('7.0-style0000000000018','nav2_off_left.jpg','nav2_off_left.jpg nav2_off_left.jpg  style1 nav2 off left.jpg ','style1/nav2_off_left.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_left\'\'.\'\'jpg\'\'nav2_off_left\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'left\'\'.\'\'jpg','000001000001000088000017'),('7.0-style0000000000015','nav1_on_right.jpg','nav1_on_right.jpg nav1_on_right.jpg  style1 nav1 on right.jpg ','style1/nav1_on_right.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_right\'\'.\'\'jpg\'\'nav1_on_right\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'right\'\'.\'\'jpg','000001000001000088000014'),('7.0-style0000000000014','nav1_on_left.jpg','nav1_on_left.jpg nav1_on_left.jpg  style1 nav1 on left.jpg ','style1/nav1_on_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_left\'\'.\'\'jpg\'\'nav1_on_left\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'left\'\'.\'\'jpg','000001000001000088000013'),('7.0-style0000000000013','nav1_on.jpg','nav1_on.jpg nav1_on.jpg  style1 nav1 on.jpg ','style1/nav1_on.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on\'\'.\'\'jpg\'\'nav1_on\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'.\'\'jpg','000001000001000088000012'),('7.0-style0000000000011','nav1_off_left.jpg','nav1_off_left.jpg nav1_off_left.jpg  style1 nav1 off left.jpg ','style1/nav1_off_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_left\'\'.\'\'jpg\'\'nav1_off_left\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'left\'\'.\'\'jpg','000001000001000088000010'),('7.0-style0000000000012','nav1_off_right.jpg','nav1_off_right.jpg nav1_off_right.jpg  style1 nav1 off right.jpg ','style1/nav1_off_right.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_right\'\'.\'\'jpg\'\'nav1_off_right\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'right\'\'.\'\'jpg','000001000001000088000011'),('7.0-style0000000000009','nav1_off.jpg','nav1_off.jpg nav1_off.jpg  style1 nav1 off.jpg ','style1/nav1_off.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off\'\'.\'\'jpg\'\'nav1_off\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'.\'\'jpg','000001000001000088000008'),('7.0-style0000000000010','nav1_off_center.jpg','nav1_off_center.jpg nav1_off_center.jpg  style1 nav1 off center.jpg ','style1/nav1_off_center.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_center\'\'.\'\'jpg\'\'nav1_off_center\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'center\'\'.\'\'jpg','000001000001000088000009'),('7.0-style0000000000008','nav1_center_on.jpg','nav1_center_on.jpg nav1_center_on.jpg  style1 nav1 center on.jpg ','style1/nav1_center_on.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_center_on\'\'.\'\'jpg\'\'nav1_center_on\'\'.\'\'jpg\'\'style1\'\'nav1\'\'center\'\'on\'\'.\'\'jpg','000001000001000088000007'),('7.0-style0000000000006','main_bg.gif','main_bg.gif main_bg.gif  style1 main bg.gif ','style1/main_bg.gif',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'gif\'\'main_bg\'\'.\'\'gif\'\'style1\'\'main\'\'bg\'\'.\'\'gif','000001000001000088000005'),('7.0-style0000000000007','main_bg.jpg','main_bg.jpg main_bg.jpg  style1 main bg.jpg ','style1/main_bg.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style1\'\'main\'\'bg\'\'.\'\'jpg','000001000001000088000006'),('7.0-style0000000000004','gui_bottom.jpg','gui_bottom.jpg gui_bottom.jpg  style1 gui bottom.jpg ','style1/gui_bottom.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'gui_bottom\'\'.\'\'jpg\'\'gui_bottom\'\'.\'\'jpg\'\'style1\'\'gui\'\'bottom\'\'.\'\'jpg','000001000001000088000003'),('7.0-style0000000000005','header.jpg','header.jpg header.jpg  style1 header.jpg ','style1/header.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'header\'\'.\'\'jpg\'\'header\'\'.\'\'jpg\'\'style1\'\'header\'\'.\'\'jpg','000001000001000088000004'),('7.0-style0000000000001','WebGUI 7 Style 1','WebGUI 7 Style 1 WebGUI 7 Style 1  root import webgui 7 style 1 ','root/import/webgui-7-style-1',1147642492,1147642492,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'1\'\'WebGUI\'\'7\'\'Style\'\'1\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'1','000001000001000088'),('7.0-style0000000000002','body_bg.jpg','body_bg.jpg body_bg.jpg  style1 body bg.jpg ','style1/body_bg.jpg',1147642492,1147642492,'3','7','12','WebGUI::Asset::File::Image',1,'body_bg\'\'.\'\'jpg\'\'body_bg\'\'.\'\'jpg\'\'style1\'\'body\'\'bg\'\'.\'\'jpg','000001000001000088000001'),('7.0-style0000000000003','css01.css','css01.css css01.css  style1 css01.css ','style1/css01.css',1147642492,1147642492,'3','7','12','WebGUI::Asset::Snippet',1,'css01\'\'.\'\'css\'\'css01\'\'.\'\'css\'\'style1\'\'css01\'\'.\'\'css body\'\',\'\'html\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'494949\'\';\'\'}\'\'#\'\'main\'\'{\'\'width\'\':\'\'800px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'main_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'margin\'\'-\'\'left\'\':\'\'auto\'\';\'\'margin\'\'-\'\'right\'\':\'\'auto\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'body\'\'>\'\'#\'\'main\'\'{\'\'height\'\':\'\'auto\'\';\'\'min\'\'-\'\'height\'\':\'\'100\'\'%\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'{\'\'width\'\':\'\'800px\'\';\'\'height\'\':\'\'133px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'header\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'top\'\'left\'\'no\'\'-\'\'repeat\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'#\'\'title\'\'{\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'23px\'\';\'\'left\'\':\'\'145px\'\';\'\'font\'\'-\'\'size\'\':\'\'32pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'#\'\'title\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'orange_left01\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'left\'\'top\'\'no\'\'-\'\'repeat\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'border\'\':\'\'solid\'\'red\'\'0px\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainContent\'\'{\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'min\'\'-\'\'height\'\':\'\'500px\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainContent\'\'>\'\'p\'\'{\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'#\'\'mainText\'\'a\'\':\'\'link\'\'{\'\'color\'\':\'\'#\'\'FF7F23\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'#\'\'mainText\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'#\'\'D25900\'\';\'\'}\'\'/\'\'*\'\'LEVEL\'\'1\'\'AND\'\'2\'\'NAVIGATION\'\'*\'\'/\'\'#\'\'main\'\'.\'\'mainNav_1\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dashed\'\'#\'\'DADADA\'\'1px\'\';\'\'width\'\':\'\'621px\'\';\'\'height\'\':\'\'25px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'position\'\':\'\'relative\'\';\'\'margin\'\'-\'\'left\'\':\'\'137px\'\';\'\'clear\'\':\'\'both\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'visited\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'top\'\':\'\'5px\'\';\'\'position\'\':\'\'relative\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'hover\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'hover\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'left\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'left\'\'{\'\'width\'\':\'\'12px\'\';\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'center\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'center\'\'{\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_center\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\',\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_center\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'right\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'right\'\'{\'\'width\'\':\'\'10px\'\';\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_on_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_center_on\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_on_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_on_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_center_on\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_on_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'visited\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'/\'\'*\'\'ENDOF\'\'LEVEL\'\'1\'\'AND\'\'2\'\'NAVIGATION\'\'*\'\'/\'\'#\'\'main\'\'#\'\'crumbTrail\'\'{\'\'margin\'\'-\'\'left\'\':\'\'177px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'color\'\':\'\'gray\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'visited\'\',\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'link\'\'{\'\'color\'\':\'\'silver\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'}\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'hover\'\'{\'\'color\'\':\'\'gray\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainText\'\'{\'\'padding\'\'-\'\'left\'\':\'\'150px\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'width\'\':\'\'600px\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'{\'\'bottom\'\':\'\'0px\'\';\'\'left\'\':\'\'0px\'\';\'\'position\'\':\'\'absolute\'\';\'\'width\'\':\'\'135px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'color\'\':\'\'black\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'{\'\'padding\'\'-\'\'right\'\':\'\'12px\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'width\'\':\'\'100px\'\';\'\'float\'\':\'\'right\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'.\'\'loginBoxField\'\'{\'\'width\'\':\'\'75px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'.\'\'loginBoxButton\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'D65501\'\';\'\'color\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'white\'\'2px\'\';\'\'margin\'\'-\'\'top\'\':\'\'4px\'\';\'\'font\'\'-\'\'variant\'\':\'\'small\'\'-\'\'caps\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'copyright\'\'{\'\'color\'\':\'\'#\'\'fff\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'110px\'\';\'\'right\'\':\'\'40px\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'2D2D2D\'\';\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'-\'\'moz\'\'-\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'-\'\'khtml\'\'-\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'padding\'\':\'\'2px\'\';\'\'}\'\'*\'\'html\'\'#\'\'copyright\'\'{\'\'background\'\':\'\'transparent\'\';\'\'}','000001000001000088000002'),('NYr6iP4pQaPRYqEYMryv4w','Commerce','Commerce Commerce  root import commerce ','root/import/commerce',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Commerce\'\'Commerce\'\'root\'\'import\'\'commerce','000001000001000086'),('CSN-ZON7Uwv8kxf3F1fh5Q','ZipArchiveAsset','ZipArchiveAsset ZipArchiveAsset  root import ziparchiveasset ','root/import/ziparchiveasset',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ZipArchiveAsset\'\'ZipArchiveAsset\'\'root\'\'import\'\'ziparchiveasset','000001000001000085'),('TCtybxdqmdwdvRn555zpCQ','RichEdit','RichEdit RichEdit  root import richedit ','root/import/richedit',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RichEdit\'\'RichEdit\'\'root\'\'import\'\'richedit','000001000001000087'),('huASapWvFDzqwOSbcN-JFQ','TimeTracking_user','TimeTracking_user TimeTracking_user  root import timetracking user ','root/import/timetracking_user',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking_user\'\'TimeTracking_user\'\'root\'\'import\'\'timetracking\'\'user','000001000001000082'),('9wKWdum0_8z-OhhquWLtSQ','WeatherData','WeatherData WeatherData  root import weatherdata ','root/import/weatherdata',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WeatherData\'\'WeatherData\'\'root\'\'import\'\'weatherdata','000001000001000083'),('5YAbuwiVFUx-z8hcOAnsdQ','WSClient','WSClient WSClient  root import wsclient ','root/import/wsclient',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WSClient\'\'WSClient\'\'root\'\'import\'\'wsclient','000001000001000084'),('lo1ac3BsoJx3ijGQ3gR-bQ','TimeTracking_row','TimeTracking_row TimeTracking_row  root import timetracking row ','root/import/timetracking_row',1147642482,1147642482,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking_row\'\'TimeTracking_row\'\'root\'\'import\'\'timetracking\'\'row','000001000001000081'),('vTymIDYL2YqEh6PV50F7ew','TimeTracking_manager','TimeTracking_manager TimeTracking_manager  root import timetracking manager ','root/import/timetracking_manager',1147642482,1147642482,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking_manager\'\'TimeTracking_manager\'\'root\'\'import\'\'timetracking\'\'manager','000001000001000080'),('oGfxez5sksyB_PcaAsEm_Q','SyndicatedContent','SyndicatedContent SyndicatedContent  root import syndicatedcontent ','root/import/syndicatedcontent',1147642482,1147642482,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SyndicatedContent\'\'SyndicatedContent\'\'root\'\'import\'\'syndicatedcontent','000001000001000079'),('5bnNzteN7w3NnK9mF4XiCg','Survey','Survey Survey  root import survey ','root/import/survey',1147642481,1147642481,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Survey\'\'Survey\'\'root\'\'import\'\'survey','000001000001000078'),('Efe2W0UgrSRDltNJ87jlfg','StockData','StockData StockData  root import stockdata ','root/import/stockdata',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'StockData\'\'StockData\'\'root\'\'import\'\'stockdata','000001000001000076'),('k8vxD4fuKKf5cGwNTw0sLw','SQLForm/Search','SQLForm/Search SQLForm/Search  root import sqlform search ','root/import/sqlform/search',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLForm\'\'/\'\'Search\'\'SQLForm\'\'/\'\'Search\'\'root\'\'import\'\'sqlform\'\'search','000001000001000074'),('bbiA9Zq5Gy2oCFBlILO3QA','SQLReport','SQLReport SQLReport  root import sqlreport ','root/import/sqlreport',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLReport\'\'SQLReport\'\'root\'\'import\'\'sqlreport','000001000001000075'),('RrV4aAPnn4dM0ZcU3OXnlw','style','style style  root import style ','root/import/style',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'style\'\'style\'\'root\'\'import\'\'style','000001000001000077'),('71e17KeduiXgODLMlUxiow','ProjectManager_project','ProjectManager_project ProjectManager_project  root import projectmanager project ','root/import/projectmanager_project',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager_project\'\'ProjectManager_project\'\'root\'\'import\'\'projectmanager\'\'project','000001000001000069'),('Ik9HHky10DIyFTKehUD1dw','prompt','prompt prompt  root import prompt ','root/import/prompt',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'prompt\'\'prompt\'\'root\'\'import\'\'prompt','000001000001000070'),('f_tn9FfoSfKWX43F83v_3w','Search','Search Search  root import search ','root/import/search',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Search\'\'Search\'\'root\'\'import\'\'search','000001000001000071'),('Da6KWn805L4B5e4HFgQRQA','Shortcut','Shortcut Shortcut  root import shortcut ','root/import/shortcut',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shortcut\'\'Shortcut\'\'root\'\'import\'\'shortcut','000001000001000072'),('GnrXtoFFeXia3vDQuSHojw','SQLForm/Edit','SQLForm/Edit SQLForm/Edit  root import sqlform edit ','root/import/sqlform/edit',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLForm\'\'/\'\'Edit\'\'SQLForm\'\'/\'\'Edit\'\'root\'\'import\'\'sqlform\'\'edit','000001000001000073'),('pV7GnZdpjR3XpZaSINIoeg','ProjectManager_gantt','ProjectManager_gantt ProjectManager_gantt  root import projectmanager gantt ','root/import/projectmanager_gantt',1147642478,1147642478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager_gantt\'\'ProjectManager_gantt\'\'root\'\'import\'\'projectmanager\'\'gantt','000001000001000068'),('yD1SMHelczihzjEmx6eXBA','ProjectManager_editTask','ProjectManager_editTask ProjectManager_editTask  root import projectmanager edittask ','root/import/projectmanager_edittask',1147642478,1147642478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager_editTask\'\'ProjectManager_editTask\'\'root\'\'import\'\'projectmanager\'\'edittask','000001000001000067'),('9A-mg2gwWmaYi9o_1C7ArQ','ProjectManager_dashboard','ProjectManager_dashboard ProjectManager_dashboard  root import projectmanager dashboard ','root/import/projectmanager_dashboard',1147642478,1147642478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager_dashboard\'\'ProjectManager_dashboard\'\'root\'\'import\'\'projectmanager\'\'dashboard','000001000001000066'),('TYo2Bwl7aafzTtdHlS-arQ','Product','Product Product  root import product ','root/import/product',1147642478,1147642478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Product\'\'Product\'\'root\'\'import\'\'product','000001000001000065'),('F7MAQ-cpuvQ1KuC7J4P5zQ','Operation/Profile/View','Operation/Profile/View Operation/Profile/View  root import operation profile view ','root/import/operation/profile/view',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation\'\'/\'\'Profile\'\'/\'\'View\'\'Operation\'\'/\'\'Profile\'\'/\'\'View\'\'root\'\'import\'\'operation\'\'profile\'\'view','000001000001000062'),('AgyFhx3eXlfZXNp2MkrsiQ','Operation/Profile/Edit','Operation/Profile/Edit Operation/Profile/Edit  root import operation profile edit ','root/import/operation/profile/edit',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation\'\'/\'\'Profile\'\'/\'\'Edit\'\'Operation\'\'/\'\'Profile\'\'/\'\'Edit\'\'root\'\'import\'\'operation\'\'profile\'\'edit','000001000001000061'),('VZK3CRgiMb8r4dBjUmCTgQ','Poll','Poll Poll  root import poll ','root/import/poll',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Poll\'\'Poll\'\'root\'\'import\'\'poll','000001000001000064'),('jEz8iTGNWEt2I05IhVV19Q','Operation/RedeemSubscription','Operation/RedeemSubscription Operation/RedeemSubscription  root import operation redeemsubscription ','root/import/operation/redeemsubscription',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation\'\'/\'\'RedeemSubscription\'\'Operation\'\'/\'\'RedeemSubscription\'\'root\'\'import\'\'operation\'\'redeemsubscription','000001000001000063'),('BFfNj5wA9bDw8H3cnr8pTw','Navigation','Navigation Navigation  root import navigation ','root/import/navigation',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Navigation\'\'Navigation\'\'root\'\'import\'\'navigation','000001000001000060'),('bBzO4CWjqU_ile3gf5Iypw','MultiSearch','MultiSearch MultiSearch  root import multisearch ','root/import/multisearch',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MultiSearch\'\'MultiSearch\'\'root\'\'import\'\'multisearch','000001000001000059'),('cj2y4papTVGZRFdwTI-_fw','MessageBoard','MessageBoard MessageBoard  root import messageboard ','root/import/messageboard',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MessageBoard\'\'MessageBoard\'\'root\'\'import\'\'messageboard','000001000001000058'),('e-WvgcKROPCoHwiiHLktCg','Macro/SubscriptionItem','Macro/SubscriptionItem Macro/SubscriptionItem  root import macro subscriptionitem ','root/import/macro/subscriptionitem',1147642474,1147642474,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'SubscriptionItem\'\'Macro\'\'/\'\'SubscriptionItem\'\'root\'\'import\'\'macro\'\'subscriptionitem','000001000001000056'),('nqNbSUAhk9Vd1zda2SCz9A','Macro/RandomThread','Macro/RandomThread Macro/RandomThread  root import macro randomthread ','root/import/macro/randomthread',1147642474,1147642474,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'RandomThread\'\'Macro\'\'/\'\'RandomThread\'\'root\'\'import\'\'macro\'\'randomthread','000001000001000054'),('y8XkRdxIperLKkJ3bL5sSQ','Macro/r_printable','Macro/r_printable Macro/r_printable  root import macro r printable ','root/import/macro/r_printable',1147642474,1147642474,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'r_printable\'\'Macro\'\'/\'\'r_printable\'\'root\'\'import\'\'macro\'\'r\'\'printable','000001000001000055'),('LdiozcIUciWuvt3Z-na5Ww','Matrix','Matrix Matrix  root import matrix ','root/import/matrix',1147642474,1147642474,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Matrix\'\'Matrix\'\'root\'\'import\'\'matrix','000001000001000057'),('V3l5S5TtI7wMm1WpIMhvOA','Macro/L_loginBox','Macro/L_loginBox Macro/L_loginBox  root import macro l loginbox ','root/import/macro/l_loginbox',1147642473,1147642473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'L_loginBox\'\'Macro\'\'/\'\'L_loginBox\'\'root\'\'import\'\'macro\'\'l\'\'loginbox','000001000001000053'),('rYEFwXXo0tkGhQTcbDibvg','Macro/LoginToggle','Macro/LoginToggle Macro/LoginToggle  root import macro logintoggle ','root/import/macro/logintoggle',1147642473,1147642473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'LoginToggle\'\'Macro\'\'/\'\'LoginToggle\'\'root\'\'import\'\'macro\'\'logintoggle','000001000001000052'),('5HIDHq5lAWHV5gpYGS0zLg','Macro/H_homeLink','Macro/H_homeLink Macro/H_homeLink  root import macro h homelink ','root/import/macro/h_homelink',1147642473,1147642473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'H_homeLink\'\'Macro\'\'/\'\'H_homeLink\'\'root\'\'import\'\'macro\'\'h\'\'homelink','000001000001000051'),('eRJR52fvlaxfetv3DQkQYw','Macro/GroupDelete','Macro/GroupDelete Macro/GroupDelete  root import macro groupdelete ','root/import/macro/groupdelete',1147642473,1147642473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'GroupDelete\'\'Macro\'\'/\'\'GroupDelete\'\'root\'\'import\'\'macro\'\'groupdelete','000001000001000050'),('hcFlqnXlsmC1ujN6Id0F0A','Macro/GroupAdd','Macro/GroupAdd Macro/GroupAdd  root import macro groupadd ','root/import/macro/groupadd',1147642473,1147642473,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'GroupAdd\'\'Macro\'\'/\'\'GroupAdd\'\'root\'\'import\'\'macro\'\'groupadd','000001000001000049'),('tnc5iYyynX2hfdEs9D3P8w','Macro/EditableToggle','Macro/EditableToggle Macro/EditableToggle  root import macro editabletoggle ','root/import/macro/editabletoggle',1147642472,1147642472,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'EditableToggle\'\'Macro\'\'/\'\'EditableToggle\'\'root\'\'import\'\'macro\'\'editabletoggle','000001000001000047'),('vgXdBcFTqU7h4wBG1ewdBw','Macro/File','Macro/File Macro/File  root import macro file ','root/import/macro/file',1147642472,1147642472,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'File\'\'Macro\'\'/\'\'File\'\'root\'\'import\'\'macro\'\'file','000001000001000048'),('GdkQpvjRtJqtzOUbwIIQRA','Macro/a_account','Macro/a_account Macro/a_account  root import macro a account ','root/import/macro/a_account',1147642471,1147642471,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'a_account\'\'Macro\'\'/\'\'a_account\'\'root\'\'import\'\'macro\'\'a\'\'account','000001000001000046'),('tBL7BWiQRZFed2Y-Zjo9tQ','Macro/AdminToggle','Macro/AdminToggle Macro/AdminToggle  root import macro admintoggle ','root/import/macro/admintoggle',1147642471,1147642471,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'AdminToggle\'\'Macro\'\'/\'\'AdminToggle\'\'root\'\'import\'\'macro\'\'admintoggle','000001000001000045'),('Ov2ssJHwp_1eEWKlDyUKmg','Macro/AdminBar','Macro/AdminBar Macro/AdminBar  root import macro adminbar ','root/import/macro/adminbar',1147642471,1147642471,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'/\'\'AdminBar\'\'Macro\'\'/\'\'AdminBar\'\'root\'\'import\'\'macro\'\'adminbar','000001000001000044'),('aNNC62qLAS6TB-0_MCYjsw','Layout','Layout Layout  root import layout ','root/import/layout',1147642471,1147642471,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Layout\'\'Layout\'\'root\'\'import\'\'layout','000001000001000043'),('GYaFxnMu9UsEG8oanwB6TA','Folder','Folder Folder  root import folder ','root/import/folder',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Folder\'\'Folder\'\'root\'\'import\'\'folder','000001000001000037'),('N13SD1Fpqk00UgBt1Z8ivQ','HttpProxy','HttpProxy HttpProxy  root import httpproxy ','root/import/httpproxy',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'HttpProxy\'\'HttpProxy\'\'root\'\'import\'\'httpproxy','000001000001000038'),('tPagC0AQErZXjLFZQ6OI1g','ImageAsset','ImageAsset ImageAsset  root import imageasset ','root/import/imageasset',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ImageAsset\'\'ImageAsset\'\'root\'\'import\'\'imageasset','000001000001000039'),('3uuBf8cYuj1sew2OJXl9tg','InOutBoard','InOutBoard InOutBoard  root import inoutboard ','root/import/inoutboard',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'InOutBoard\'\'InOutBoard\'\'root\'\'import\'\'inoutboard','000001000001000042'),('AFdXZZmGnSKalNSobQMB5w','IndexedSearch','IndexedSearch IndexedSearch  root import indexedsearch ','root/import/indexedsearch',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'IndexedSearch\'\'IndexedSearch\'\'root\'\'import\'\'indexedsearch','000001000001000041'),('VXSsbsfcfht1904EWkb1sw','Inbox','Inbox Inbox  root import inbox ','root/import/inbox',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Inbox\'\'Inbox\'\'root\'\'import\'\'inbox','000001000001000040'),('j3P_Vvsy0OtvUJZRXC55Nw','EventManagementSystem_managePurchas','EventManagementSystem_managePurchas EventManagementSystem_managePurchas  root import eventmanagementsystem managepurchas ','root/import/eventmanagementsystem_managepurchas',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EventManagementSystem_managePurchas\'\'EventManagementSystem_managePurchas\'\'root\'\'import\'\'eventmanagementsystem\'\'managepurchas','000001000001000032'),('XP2W66c8vtDVpxN50Fiwww','EventManagementSystem_search','EventManagementSystem_search EventManagementSystem_search  root import eventmanagementsystem search ','root/import/eventmanagementsystem_search',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EventManagementSystem_search\'\'EventManagementSystem_search\'\'root\'\'import\'\'eventmanagementsystem\'\'search','000001000001000033'),('JJ-SZb9z2l_N46A0AWW7KA','EventManagementSystem_viewPurchase','EventManagementSystem_viewPurchase EventManagementSystem_viewPurchase  root import eventmanagementsystem viewpurchase ','root/import/eventmanagementsystem_viewpurchase',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EventManagementSystem_viewPurchase\'\'EventManagementSystem_viewPurchase\'\'root\'\'import\'\'eventmanagementsystem\'\'viewpurchase','000001000001000034'),('Cn2TOyQH3qqnQrWDrsGrxg','EventsCalendar','EventsCalendar EventsCalendar  root import eventscalendar ','root/import/eventscalendar',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EventsCalendar\'\'EventsCalendar\'\'root\'\'import\'\'eventscalendar','000001000001000035'),('tXwf1zaOXTvsqPn6yu-GSw','FileAsset','FileAsset FileAsset  root import fileasset ','root/import/fileasset',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'FileAsset\'\'FileAsset\'\'root\'\'import\'\'fileasset','000001000001000036'),('lK9-YMfZ4mpc-Me-UydrFg','EventManagementSystem','EventManagementSystem EventManagementSystem  root import eventmanagementsystem ','root/import/eventmanagementsystem',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EventManagementSystem\'\'EventManagementSystem\'\'root\'\'import\'\'eventmanagementsystem','000001000001000031'),('S1A9iAwKcQQ6P20uTqw-Ew','Dashboard','Dashboard Dashboard  root import dashboard ','root/import/dashboard',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Dashboard\'\'Dashboard\'\'root\'\'import\'\'dashboard','000001000001000029'),('-K8Hj45mbelljN9-0CXZxg','DataForm','DataForm DataForm  root import dataform ','root/import/dataform',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'DataForm\'\'DataForm\'\'root\'\'import\'\'dataform','000001000001000030'),('fq1ZkYhH24R5tb96kuT10Q','Auth/WebGUI/Create','Auth/WebGUI/Create Auth/WebGUI/Create  root import auth webgui create ','root/import/auth/webgui/create',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'WebGUI\'\'/\'\'Create\'\'Auth\'\'/\'\'WebGUI\'\'/\'\'Create\'\'root\'\'import\'\'auth\'\'webgui\'\'create','000001000001000024'),('0bx-xoL8TSXXubFuqKAoVQ','Auth/LDAP/Create','Auth/LDAP/Create Auth/LDAP/Create  root import auth ldap create ','root/import/auth/ldap/create',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'LDAP\'\'/\'\'Create\'\'Auth\'\'/\'\'LDAP\'\'/\'\'Create\'\'root\'\'import\'\'auth\'\'ldap\'\'create','000001000001000021'),('taX2UYkFF21ALpFZY2rhMw','Auth/LDAP/Login','Auth/LDAP/Login Auth/LDAP/Login  root import auth ldap login ','root/import/auth/ldap/login',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'LDAP\'\'/\'\'Login\'\'Auth\'\'/\'\'LDAP\'\'/\'\'Login\'\'root\'\'import\'\'auth\'\'ldap\'\'login','000001000001000022'),('xSmREZO3GNzK3M5PaueOOQ','Auth/LDAP/Account','Auth/LDAP/Account Auth/LDAP/Account  root import auth ldap account ','root/import/auth/ldap/account',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'LDAP\'\'/\'\'Account\'\'Auth\'\'/\'\'LDAP\'\'/\'\'Account\'\'root\'\'import\'\'auth\'\'ldap\'\'account','000001000001000020'),('K0q_N885Httqev1VCqUWxg','Auth/WebGUI/Account','Auth/WebGUI/Account Auth/WebGUI/Account  root import auth webgui account ','root/import/auth/webgui/account',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'WebGUI\'\'/\'\'Account\'\'Auth\'\'/\'\'WebGUI\'\'/\'\'Account\'\'root\'\'import\'\'auth\'\'webgui\'\'account','000001000001000023'),('oHk7fAFhEEkB7dHzi0QOQA','Auth/WebGUI/Expired','Auth/WebGUI/Expired Auth/WebGUI/Expired  root import auth webgui expired ','root/import/auth/webgui/expired',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'WebGUI\'\'/\'\'Expired\'\'Auth\'\'/\'\'WebGUI\'\'/\'\'Expired\'\'root\'\'import\'\'auth\'\'webgui\'\'expired','000001000001000025'),('9M-lrlPQWeeNWfvnDnK_Xg','Auth/WebGUI/Login','Auth/WebGUI/Login Auth/WebGUI/Login  root import auth webgui login ','root/import/auth/webgui/login',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'WebGUI\'\'/\'\'Login\'\'Auth\'\'/\'\'WebGUI\'\'/\'\'Login\'\'root\'\'import\'\'auth\'\'webgui\'\'login','000001000001000026'),('_gBYAdTcbkiyamnqi2Xskg','Auth/WebGUI/Recovery','Auth/WebGUI/Recovery Auth/WebGUI/Recovery  root import auth webgui recovery ','root/import/auth/webgui/recovery',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'/\'\'WebGUI\'\'/\'\'Recovery\'\'Auth\'\'/\'\'WebGUI\'\'/\'\'Recovery\'\'root\'\'import\'\'auth\'\'webgui\'\'recovery','000001000001000027'),('GNOAsX98vCsl0JRwfwL-gg','Collaboration','Collaboration Collaboration  root import collaboration ','root/import/collaboration',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Collaboration\'\'Collaboration\'\'root\'\'import\'\'collaboration','000001000001000028'),('pbproto000000000000001','Photo Gallery','Photo Gallery Photo Gallery  photo gallery prototype ','photo-gallery-prototype',1147642465,1163019036,'3','7','12','WebGUI::Asset::Wobject::Collaboration',1,'Photo\'\'Gallery\'\'Photo\'\'Gallery\'\'photo\'\'gallery\'\'prototype','000001000001000028000031'),('pbproto000000000000002','Request Tracker','Request Tracker Request Tracker  request tracker prototype ','request-tracker-prototype',1147642465,1163019036,'3','7','12','WebGUI::Asset::Wobject::Collaboration',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'prototype','000001000001000015'),('pbtmpl0000000000000220','Flash Template','Flash Template Flash Template  flash template ','flash-template',1147642465,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Flash\'\'Template\'\'Flash\'\'Template\'\'flash\'\'template FileAsset','000001000001000036000002'),('pbtmpl0000000000000221','Flash Tutorial Template','Flash Tutorial Template Flash Tutorial Template  flash tutorial template ','flash-tutorial-template',1147642465,1147642465,'3','7','12','WebGUI::Asset::Template',1,'Flash\'\'Tutorial\'\'Template\'\'Flash\'\'Tutorial\'\'Template\'\'flash\'\'tutorial\'\'template FileAsset','000001000001000036000003'),('nbSrhXZQuxIjhWFaFPSuVA','AdminConsole','AdminConsole AdminConsole  root import adminconsole ','root/import/adminconsole',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminConsole\'\'AdminConsole\'\'root\'\'import\'\'adminconsole','000001000001000018'),('TvOZs8U1kRXLtwtmyW75pg','Article','Article Article  root import article ','root/import/article',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Article\'\'Article\'\'root\'\'import\'\'article','000001000001000019'),('PBtmpl0000000000000027','Default Forum Notification','Default Forum Notification Default Forum Notification  default forum notification ','default_forum_notification',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Notification\'\'Default\'\'Forum\'\'Notification\'\'default\'\'forum\'\'notification Collaboration\'\'/\'\'Notification','000001000001000028000015'),('sMuqO3Ynl6Lyn5fa2SsGmQ','7.0.0 New Templates','7.0.0 New Templates 7.0.0 New Templates  7 0 0 new templates ','7_0_0_new_templates',1147962058,1147962058,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'0\'\'.\'\'0\'\'New\'\'Templates\'\'7\'\'.\'\'0\'\'.\'\'0\'\'New\'\'Templates\'\'7\'\'0\'\'0\'\'new\'\'templates','000001000001000092'),('PBtmpl00000000table118','Three Over One (Table)','Three Over One (Table) Three Over One (Table)  three over one table ','three_over_one_table',1148579525,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Three\'\'Over\'\'One\'\'(\'\'Table\'\')\'\'Three\'\'Over\'\'One\'\'(\'\'Table\'\')\'\'three\'\'over\'\'one\'\'table Layout','000001000001000093000007'),('PBtmpl00000000table135','Side By Side (Table)','Side By Side (Table) Side By Side (Table)  side by side table ','side_by_side_table',1148579525,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Side\'\'By\'\'Side\'\'(\'\'Table\'\')\'\'Side\'\'By\'\'Side\'\'(\'\'Table\'\')\'\'side\'\'by\'\'side\'\'table Layout','000001000001000093000006'),('PBtmpl00000000table131','Right Column (Table)','Right Column (Table) Right Column (Table)  right column table ','right_column_table',1148579525,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Right\'\'Column\'\'(\'\'Table\'\')\'\'Right\'\'Column\'\'(\'\'Table\'\')\'\'right\'\'column\'\'table Layout','000001000001000093000005'),('PBtmpl00000000table094','News (Table)','News (Table) News (Table)  news table ','news_table',1148579525,1148579525,'3','7','12','WebGUI::Asset::Template',1,'News\'\'(\'\'Table\'\')\'\'News\'\'(\'\'Table\'\')\'\'news\'\'table Layout','000001000001000093000004'),('PBtmpl00000000table125','Left Column (Table)','Left Column (Table) Left Column (Table)  left column table ','left_column_table',1148579525,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Column\'\'(\'\'Table\'\')\'\'Left\'\'Column\'\'(\'\'Table\'\')\'\'left\'\'column\'\'table Layout','000001000001000093000003'),('PBnav00000000indentnav','Indent Nav','Indent Nav Indent Nav  indent nav ','indent_nav',1148579525,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Indent\'\'Nav\'\'Indent\'\'Nav\'\'indent\'\'nav Navigation','000001000001000093000002'),('PBtmpl0000000000000085','Default Email','Default Email Default Email  default email ','default_email',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Email\'\'Default\'\'Email\'\'default\'\'email DataForm','000001000001000030000002'),('PBnav00000000000bullet','Bulleted List','Bulleted List Bulleted List  bulleted list ','bulleted_list',1148579524,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Bulleted\'\'List\'\'Bulleted\'\'List\'\'bulleted\'\'list Navigation','000001000001000093000001'),('ImvgaAritVaOLmogG8fCJQ','6.99.2 New Templates','6.99.2 New Templates 6.99.2 New Templates  6.99.2 new templates ','6.99.2_new_templates',1148579524,1148579524,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'6\'\'.\'\'99\'\'.\'\'2\'\'New\'\'Templates\'\'6\'\'.\'\'99\'\'.\'\'2\'\'New\'\'Templates\'\'6\'\'.\'\'99\'\'.\'\'2\'\'new\'\'templates','000001000001000093'),('PBtmpl0000000000000016','Default checkout confirmation template','Default checkout confirmation template Default checkout confirmation template  default checkout confirmation template ','default_checkout_confirmation_template',1124395696,1163019035,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'checkout\'\'confirmation\'\'template\'\'Default\'\'checkout\'\'confirmation\'\'template\'\'default\'\'checkout\'\'confirmation\'\'template Commerce\'\'/\'\'ConfirmCheckout','000001000001000086000002'),('StockDataTMPL000000002','StockData Default Display','StockData Default Display StockData Default Display  stockdatatmpl000000002 ','stockdatatmpl000000002',1133743239,1154535074,'3','7','12','WebGUI::Asset::Template',1,'StockData\'\'Default\'\'Display\'\'StockData\'\'Default\'\'Display\'\'stockdatatmpl000000002 StockData\'\'/\'\'Display','000001000001000076000001'),('PBtmpl0000000000000053','Subscription code redemption','Subscription code redemption Subscription code redemption  subscription code redemption ','subscription_code_redemption',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Subscription\'\'code\'\'redemption\'\'Subscription\'\'code\'\'redemption\'\'subscription\'\'code\'\'redemption Operation\'\'/\'\'RedeemSubscription','000001000001000063000001'),('kDuc6TCa6cWZ_jdrIMFKRg','7.0.3 New Templates','7.0.3 New Templates 7.0.3 New Templates  7.0.3 new templates ','7.0.3_new_templates',1154535074,1154535074,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'0\'\'.\'\'3\'\'New\'\'Templates\'\'7\'\'.\'\'0\'\'.\'\'3\'\'New\'\'Templates\'\'7\'\'.\'\'0\'\'.\'\'3\'\'new\'\'templates','000001000001000094'),('PBtmpl000000000table54','Default Page (Table)','Default Page (Table) Default Page (Table)  default page table ','default_page_table',1154535074,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'(\'\'Table\'\')\'\'Default\'\'Page\'\'(\'\'Table\'\')\'\'default\'\'page\'\'table Layout','000001000001000094000001'),('PBtmpl00000000table109','One Over Three (Table)','One Over Three (Table) One Over Three (Table)  one over three table ','one_over_three_table',1154535074,1154535074,'3','7','12','WebGUI::Asset::Template',1,'One\'\'Over\'\'Three\'\'(\'\'Table\'\')\'\'One\'\'Over\'\'Three\'\'(\'\'Table\'\')\'\'one\'\'over\'\'three\'\'table Layout','000001000001000094000002'),('ProjectManagerTMPL0002','Default Project Display','Default Project Display Default Project Display  default pm template project display ','default-pm-template-project-display',1147642415,1169092823,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Display\'\'Default\'\'Project\'\'Display\'\'default\'\'pm\'\'template\'\'project\'\'display ProjectManager_project','000001000001000069000001'),('PBtmplVSC0000000000001','Default Shopping Cart Template','Default Shopping Cart Template Default Shopping Cart Template  default shoppingcart template ','default-shoppingcart-template',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Shopping\'\'Cart\'\'Template\'\'Default\'\'Shopping\'\'Cart\'\'Template\'\'default\'\'shoppingcart\'\'template Commerce\'\'/\'\'ViewShoppingCart','000001000001000086000008'),('PBtmpl0000000000000014','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template Default WebGUI Password Recovery Template  default webgui password recovery template ','default_webgui_password_recovery_template',1124395696,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Password\'\'Recovery\'\'Template\'\'Default\'\'WebGUI\'\'Password\'\'Recovery\'\'Template\'\'default\'\'webgui\'\'password\'\'recovery\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Recovery2','000001000001000027000001'),('BmLaN4rmAANkCglXUViEbg','7.0.7 New Templates','7.0.7 New Templates 7.0.7 New Templates  7.0.7 new templates ','7.0.7_new_templates',1157679165,1157679165,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'0\'\'.\'\'7\'\'New\'\'Templates\'\'7\'\'.\'\'0\'\'.\'\'7\'\'New\'\'Templates\'\'7\'\'.\'\'0\'\'.\'\'7\'\'new\'\'templates','000001000001000095'),('ProjectManagerTMPL0006','Default Resource List','Default Resource List Default Resource List  default pm resource list ','default-pm-resource-list',1157679165,1157679165,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Resource\'\'List\'\'Default\'\'Resource\'\'List\'\'default\'\'pm\'\'resource\'\'list ProjectManager_resourceList','000001000001000095000001'),('ProjectManagerTMPL0005','Default Resource Popup','Default Resource Popup Default Resource Popup  default pm resource popup ','default-pm-resource-popup',1157679165,1157679165,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Resource\'\'Popup\'\'Default\'\'Resource\'\'Popup\'\'default\'\'pm\'\'resource\'\'popup ProjectManager_resourcePopup','000001000001000095000002'),('PBtmpl0000000000000032','Default Thread','Default Thread Default Thread  default thread ','default_thread',1124395696,1168480840,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thread\'\'Default\'\'Thread\'\'default\'\'thread Collaboration\'\'/\'\'Thread','000001000001000028000014'),('WeatherDataTmpl0000001','WeatherData Default View','WeatherData Default View WeatherData Default View  weatherdatatmpl0000001 ','weatherdatatmpl0000001',1133743239,1159392394,'3','7','12','WebGUI::Asset::Template',1,'WeatherData\'\'Default\'\'View\'\'WeatherData\'\'Default\'\'View\'\'weatherdatatmpl0000001 WeatherData','000001000001000083000001'),('PBasset000000000000001','Root','Root Root  root ','root',1124395696,1124395696,'3','7','3','WebGUI::Asset',1,'Root\'\'Root\'\'root','000001'),('PBrichedit000000000001','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit Content Manager\'s Rich Edit  content managers rich edit ','content_managers_rich_edit',1124395696,1124395696,'3','7','12','WebGUI::Asset::RichEdit',1,'Content\'\'Manager\'\'\'\'\'s\'\'Rich\'\'Edit\'\'Content\'\'Manager\'\'\'\'\'s\'\'Rich\'\'Edit\'\'content\'\'managers\'\'rich\'\'edit','000001000001000087000001'),('PBrichedit000000000002','Forum Rich Edit','Forum Rich Edit Forum Rich Edit  forum rich edit ','forum_rich_edit',1124395696,1124395696,'3','7','12','WebGUI::Asset::RichEdit',1,'Forum\'\'Rich\'\'Edit\'\'Forum\'\'Rich\'\'Edit\'\'forum\'\'rich\'\'edit','000001000001000087000002'),('SynConXSLT000000000001','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT Stylesheet RSS 0.9 XSLT  xslt rss0.9.xsl ','xslt/rss0.9.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'0\'\'.\'\'9\'\'XSLT\'\'Stylesheet\'\'RSS\'\'0\'\'.\'\'9\'\'XSLT\'\'xslt\'\'rss0\'\'.\'\'9\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'0\'\'.\'\'9\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.','000001000001000079000004'),('SynConXSLT000000000002','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT Stylesheet RSS 0.91 XSLT  xslt rss0.91.xsl ','xslt/rss0.91.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'0\'\'.\'\'91\'\'XSLT\'\'Stylesheet\'\'RSS\'\'0\'\'.\'\'91\'\'XSLT\'\'xslt\'\'rss0\'\'.\'\'91\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'0\'\'.\'\'91\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.','000001000001000079000005'),('SynConXSLT000000000003','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT Stylesheet RSS 1.0 XSLT  xslt rss1.0.xsl ','xslt/rss1.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'1\'\'.\'\'0\'\'XSLT\'\'Stylesheet\'\'RSS\'\'1\'\'.\'\'0\'\'XSLT\'\'xslt\'\'rss1\'\'.\'\'0\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'1\'\'.\'\'0\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.\'\'(\'\')','000001000001000079000006'),('SynConXSLT000000000004','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT Stylesheet RSS 2.0 XSLT  xslt rss2.0.xsl ','xslt/rss2.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'2\'\'.\'\'0\'\'XSLT\'\'Stylesheet\'\'RSS\'\'2\'\'.\'\'0\'\'XSLT\'\'xslt\'\'rss2\'\'.\'\'0\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'2\'\'.\'\'0\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.\'\'(\'\')','000001000001000079000007'),('PBtmpl0000000000000015','Default cancel checkout template','Default cancel checkout template Default cancel checkout template  default cancel checkout template ','default_cancel_checkout_template',1124395696,1129049185,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'cancel\'\'checkout\'\'template\'\'Default\'\'cancel\'\'checkout\'\'template\'\'default\'\'cancel\'\'checkout\'\'template Commerce\'\'/\'\'CheckoutCanceled','000001000001000086000001'),('PBtmpl0000000000000034','Default Search','Default Search Default Search  default search ','default_search',1124395696,1129573247,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Search\'\'Default\'\'Search\'\'default\'\'search IndexedSearch','000001000001000041000001'),('PBtmpl0000000000000036','Default Admin Toggle Macro','Default Admin Toggle Macro Default Admin Toggle Macro  default admin toggle macro ','default_admin_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Admin\'\'Toggle\'\'Macro\'\'Default\'\'Admin\'\'Toggle\'\'Macro\'\'default\'\'admin\'\'toggle\'\'macro Macro\'\'/\'\'AdminToggle','000001000001000045000001'),('PBtmpl0000000000000037','Default Account Macro','Default Account Macro Default Account Macro  default account macro ','default_account_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Account\'\'Macro\'\'Default\'\'Account\'\'Macro\'\'default\'\'account\'\'macro Macro\'\'/\'\'a_account','000001000001000046000001'),('PBtmpl0000000000000038','Default Editable Toggle Macro','Default Editable Toggle Macro Default Editable Toggle Macro  default editable toggle macro ','default_editable_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Editable\'\'Toggle\'\'Macro\'\'Default\'\'Editable\'\'Toggle\'\'Macro\'\'default\'\'editable\'\'toggle\'\'macro Macro\'\'/\'\'EditableToggle','000001000001000047000001'),('PBtmpl0000000000000040','Default Group Add Macro','Default Group Add Macro Default Group Add Macro  default group add macro ','default_group_add_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Group\'\'Add\'\'Macro\'\'Default\'\'Group\'\'Add\'\'Macro\'\'default\'\'group\'\'add\'\'macro Macro\'\'/\'\'GroupAdd','000001000001000049000001'),('PBtmpl0000000000000041','Default Group Delete Macro','Default Group Delete Macro Default Group Delete Macro  default group delete macro ','default_group_delete_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Group\'\'Delete\'\'Macro\'\'Default\'\'Group\'\'Delete\'\'Macro\'\'default\'\'group\'\'delete\'\'macro Macro\'\'/\'\'GroupDelete','000001000001000050000001'),('PBtmpl0000000000000042','Default Homelink','Default Homelink Default Homelink  default homelink ','default_homelink',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Homelink\'\'Default\'\'Homelink\'\'default\'\'homelink Macro\'\'/\'\'H_homeLink','000001000001000051000001'),('PBtmpl0000000000000043','Default LoginToggle','Default LoginToggle Default LoginToggle  default logintoggle ','default_logintoggle',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LoginToggle\'\'Default\'\'LoginToggle\'\'default\'\'logintoggle Macro\'\'/\'\'LoginToggle','000001000001000052000001'),('PBtmpl0000000000000045','Default Make Printable','Default Make Printable Default Make Printable  default make printable ','default_make_printable',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Make\'\'Printable\'\'Default\'\'Make\'\'Printable\'\'default\'\'make\'\'printable Macro\'\'/\'\'r_printable','000001000001000055000001'),('PBtmpl0000000000000091','File no icon','File no icon File no icon  file no icon ','file_no_icon',1124395696,1129049189,'3','7','12','WebGUI::Asset::Template',1,'File\'\'no\'\'icon\'\'File\'\'no\'\'icon\'\'file\'\'no\'\'icon Macro\'\'/\'\'File','000001000001000048000002'),('PBtmpl0000000000000125','Left Column','Left Column Left Column  left column ','left_column',1124395696,1173889335,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Column\'\'Left\'\'Column\'\'left\'\'column Layout','000001000001000043000004'),('PBtmpl0000000000000132','Empty','Empty Empty  empty ','empty',1124395696,1129049190,'3','7','12','WebGUI::Asset::Template',1,'Empty\'\'Empty\'\'empty style','000001000001000077000006'),('PBtmpl0000000000000140','Default Shortcut','Default Shortcut Default Shortcut  pbtmpl0000000000000140 ','pbtmpl0000000000000140',1124395696,1129573244,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Shortcut\'\'Default\'\'Shortcut\'\'pbtmpl0000000000000140 Shortcut','000001000001000072000001'),('PBtmpl0000000000000142','Default RSS','Default RSS Default RSS  pbtmpl0000000000000142 ','pbtmpl0000000000000142',1133743238,1171466654,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'RSS\'\'Default\'\'RSS\'\'pbtmpl0000000000000142 RSSCapable\'\'/\'\'RSS','000001000001000028000027'),('ZipArchiveTMPL00000001','Default Zip Archive Template','Default Zip Archive Template Default Zip Archive Template  zip archive template ','zip-archive-template',1133743240,1169738426,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Zip\'\'Archive\'\'Template\'\'Default\'\'Zip\'\'Archive\'\'Template\'\'zip\'\'archive\'\'template ZipArchiveAsset','000001000001000085000001'),('PBasset000000000000002','Import Node','Import Node Import  root import ','root/import',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Import\'\'Node\'\'Import\'\'root\'\'import','000001000001'),('2TqQc4OISddWCZmRY1_m8A','The Latest News','The Latest News The Latest News  the latest news ','the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'The\'\'Latest\'\'News\'\'The\'\'Latest\'\'News\'\'the\'\'latest\'\'news','000001000002000005'),('68sKwDgf9cGH58-NZcU4lg','Home','Home Home  home ','home',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Home\'\'Home\'\'home','000001000002'),('8Bb8gu-me2mhL3ljFyiWLg','What should you do next?','What should you do next? Your Next Step  your next step ','your_next_step',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'What\'\'should\'\'you\'\'do\'\'next\'\'?\'\'Your\'\'Next\'\'Step\'\'your\'\'next\'\'step','000001000002000004'),('Swf6L8poXKc7hUaNPkBevw','Tell A Friend','Tell A Friend Tell A Friend  tell a friend ','tell_a_friend',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Tell\'\'A\'\'Friend\'\'Tell\'\'A\'\'Friend\'\'tell\'\'a\'\'friend','000001000002000006'),('_iHetEvMQUOoxS-T2CM0sQ','Getting Started','Getting Started Getting Started  getting started ','getting_started',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Getting\'\'Started\'\'Getting\'\'Started\'\'getting\'\'started','000001000002000003'),('x3OFY6OJh_qsXkZfPwug4A','Site Map','Site Map Site Map  site map ','site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Site\'\'Map\'\'Site\'\'Map\'\'site\'\'map','000001000002000007'),('PBnav00000000000000001','crumbTrail','crumbTrail crumbTrail  crumbtrail ','crumbtrail',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'crumbTrail\'\'crumbTrail\'\'crumbtrail','000001000001000060000011'),('PBnav00000000000000002','SpecificSubMenuVertical','SpecificSubMenuVertical SpecificSubMenuVertical  specificsubmenuvertical ','specificsubmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuVertical\'\'SpecificSubMenuVertical\'\'specificsubmenuvertical','000001000001000060000020'),('PBnav00000000000000006','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal SpecificSubMenuHorizontal  specificsubmenuhorizontal ','specificsubmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuHorizontal\'\'SpecificSubMenuHorizontal\'\'specificsubmenuhorizontal','000001000001000060000021'),('PBnav00000000000000007','TopLevelMenuVertical','TopLevelMenuVertical TopLevelMenuVertical  toplevelmenuvertical ','toplevelmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuVertical\'\'TopLevelMenuVertical\'\'toplevelmenuvertical','000001000001000060000022'),('PBnav00000000000000008','TopLevelMenuHorizontal','TopLevelMenuHorizontal TopLevelMenuHorizontal  toplevelmenuhorizontal ','toplevelmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuHorizontal\'\'TopLevelMenuHorizontal\'\'toplevelmenuhorizontal','000001000001000060000023'),('PBnav00000000000000009','RootTab','RootTab RootTab  roottab ','roottab',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'RootTab\'\'roottab','000001000001000060000024'),('PBnav00000000000000010','TopDropMenu','TopDropMenu TopDropMenu  topdropmenu ','topdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopDropMenu\'\'TopDropMenu\'\'topdropmenu','000001000001000060000025'),('PBnav00000000000000011','dtree','dtree dtree  dtree ','dtree',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'dtree\'\'dtree\'\'dtree','000001000001000060000026'),('PBnav00000000000000012','coolmenu','coolmenu coolmenu  coolmenu ','coolmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'coolmenu\'\'coolmenu\'\'coolmenu','000001000001000060000027'),('PBnav00000000000000013','Synopsis','Synopsis Synopsis  synopsis ','synopsis',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Synopsis\'\'Synopsis\'\'synopsis','000001000001000060000028'),('PBnav00000000000000014','FlexMenu','FlexMenu FlexMenu  flexmenu ','flexmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'FlexMenu\'\'FlexMenu\'\'flexmenu','000001000001000060000012'),('PBnav00000000000000015','currentMenuVertical','currentMenuVertical currentMenuVertical  currentmenuvertical ','currentmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuVertical\'\'currentMenuVertical\'\'currentmenuvertical','000001000001000060000013'),('PBnav00000000000000016','currentMenuHorizontal','currentMenuHorizontal currentMenuHorizontal  currentmenuhorizontal ','currentmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuHorizontal\'\'currentMenuHorizontal\'\'currentmenuhorizontal','000001000001000060000014'),('PBnav00000000000000017','PreviousDropMenu','PreviousDropMenu PreviousDropMenu  previousdropmenu ','previousdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'PreviousDropMenu\'\'PreviousDropMenu\'\'previousdropmenu','000001000001000060000015'),('PBnav00000000000000018','previousMenuVertical','previousMenuVertical previousMenuVertical  previousmenuvertical ','previousmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuVertical\'\'previousMenuVertical\'\'previousmenuvertical','000001000001000060000016'),('PBnav00000000000000019','previousMenuHorizontal','previousMenuHorizontal previousMenuHorizontal  previousmenuhorizontal ','previousmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuHorizontal\'\'previousMenuHorizontal\'\'previousmenuhorizontal','000001000001000060000017'),('PBnav00000000000000020','rootmenu','rootmenu rootmenu  rootmenu ','rootmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'rootmenu\'\'rootmenu\'\'rootmenu','000001000001000060000018'),('PBnav00000000000000021','SpecificDropMenu','SpecificDropMenu SpecificDropMenu  specificdropmenu ','specificdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificDropMenu\'\'SpecificDropMenu\'\'specificdropmenu','000001000001000060000019'),('pJd5TLAjfWMVXD6sCRLwUg','Site Map','Site Map Site Map  site map site map ','site_map/site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Site\'\'Map\'\'Site\'\'Map\'\'site\'\'map\'\'site\'\'map','000001000002000007000001'),('fK-HMSboA3uu0c1KYkYspA','The Latest News','This is the latest news from Plain Black and WebGUI pulled directly from the site every hour.','the_latest_news/the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::SyndicatedContent',1,'The\'\'Latest\'\'News\'\'The\'\'Latest\'\'News\'\'the\'\'latest\'\'news\'\'the\'\'latest\'\'news\'\'This\'\'is\'\'the\'\'latest\'\'news\'\'from\'\'Plain\'\'Black\'\'and\'\'WebGUI\'\'pulled\'\'directly\'\'from\'\'the\'\'site\'\'every\'\'hour\'\'.','000001000002000005000001'),('WikiFrontTmpl000000001','Default Wiki Front Page','Default Wiki Front Page Default Wiki Front Page  default wiki front page ','default-wiki-front-page',1165460175,1169092823,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Front\'\'Page\'\'Default\'\'Wiki\'\'Front\'\'Page\'\'default\'\'wiki\'\'front\'\'page WikiMaster_front','000001000001000096000002'),('WikiSearchTmpl00000001','Default Wiki Search','Default Wiki Search Default Wiki Search  default wiki search ','default-wiki-search',1165460175,1168480840,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Search\'\'Default\'\'Wiki\'\'Search\'\'default\'\'wiki\'\'search WikiMaster_search','000001000001000096000003'),('WikiPHTmpl000000000001','Default Page History','Default Page History Default Page History  default wiki page history ','default-wiki-page-history',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'History\'\'Default\'\'Page\'\'History\'\'default\'\'wiki\'\'page\'\'history WikiPage_pageHistory','000001000001000096000004'),('WikiPageTmpl0000000001','Default Wiki Page','Default Wiki Page Default Wiki Page  default wiki page ','default-wiki-page',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Page\'\'Default\'\'Wiki\'\'Page\'\'default\'\'wiki\'\'page WikiPage','000001000001000096000005'),('WikiPageEditTmpl000001','Default Wiki Page Edit','Default Wiki Page Edit Default Wiki Page Edit  default wiki page edit ','default-wiki-page-edit',1165460175,1169092823,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Page\'\'Edit\'\'Default\'\'Wiki\'\'Page\'\'Edit\'\'default\'\'wiki\'\'page\'\'edit WikiPage_edit','000001000001000096000006'),('CalendarWeek0000000001','Default Calendar Week','Default Calendar Week Default Calendar Week  default calendar week ','default-calendar-week',1165460175,1175702683,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Week\'\'Default\'\'Calendar\'\'Week\'\'default\'\'calendar\'\'week Calendar\'\'/\'\'Week','000001000001000096000007'),('WikiMPTmpl000000000001','Default Most Popular','Default Most Popular Default Most Popular  default wiki most popular ','default-wiki-most-popular',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Most\'\'Popular\'\'Default\'\'Most\'\'Popular\'\'default\'\'wiki\'\'most\'\'popular WikiMaster_mostPopular','000001000001000096000008'),('CalendarDay00000000001','Default Calendar Day','Default Calendar Day Default Calendar Day  default calendar day ','default-calendar-day',1165460175,1175702683,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Day\'\'Default\'\'Calendar\'\'Day\'\'default\'\'calendar\'\'day Calendar\'\'/\'\'Day','000001000001000096000009'),('CalendarEvent000000001','Default Calendar Event','Default Calendar Event Default Calendar Event  default calendar event ','default-calendar-event',1165460175,1171466654,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Event\'\'Default\'\'Calendar\'\'Event\'\'default\'\'calendar\'\'event Calendar\'\'/\'\'Event','000001000001000096000010'),('CalendarEventEdit00001','Default Calendar Event Edit','Default Calendar Event Edit Default Calendar Event Edit  default calendar event edit ','default-calendar-event-edit',1165460175,1166019642,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Event\'\'Edit\'\'Default\'\'Calendar\'\'Event\'\'Edit\'\'default\'\'calendar\'\'event\'\'edit Calendar\'\'/\'\'EventEdit','000001000001000096000011'),('CalendarMonth000000001','Default Calendar Month','Default Calendar Month Default Calendar Month  default calendar month ','default-calendar-month',1165460175,1175702683,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Month\'\'Default\'\'Calendar\'\'Month\'\'default\'\'calendar\'\'month Calendar\'\'/\'\'Month','000001000001000096000012'),('CalendarSearch00000001','Default Calendar Search','Default Calendar Search Default Calendar Search  default calendar search ','default-calendar-search',1165460175,1168480840,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Search\'\'Default\'\'Calendar\'\'Search\'\'default\'\'calendar\'\'search Calendar\'\'/\'\'Search','000001000001000096000013'),('u2mB-2nJbDsfBinXJyjAcQ','7.3.2 New Templates','7.3.2 New Templates 7.3.2 New Templates  7.3.2 new templates ','7.3.2_new_templates',1166718668,1166718668,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'3\'\'.\'\'2\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'2\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'2\'\'new\'\'templates','000001000001000097'),('CalendarPrintEvent0001','Default Calendar Print Event','Default Calendar Print Event Default Calendar Print Event  default calendar print event ','default-calendar-print-event',1166718668,1166718668,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Event\'\'Default\'\'Calendar\'\'Print\'\'Event\'\'default\'\'calendar\'\'print\'\'event Calendar\'\'/\'\'Print\'\'/\'\'Event','000001000001000097000001'),('CalendarPrintMonth0001','Default Calendar Print Month','Default Calendar Print Month Default Calendar Print Month  default calendar print month ','default-calendar-print-month',1166718668,1166718668,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Month\'\'Default\'\'Calendar\'\'Print\'\'Month\'\'default\'\'calendar\'\'print\'\'month Calendar\'\'/\'\'Print\'\'/\'\'Month','000001000001000097000002'),('CalendarPrintWeek00001','Default Calendar Print Week','Default Calendar Print Week Default Calendar Print Week  default calendar print week ','default-calendar-print-week',1166718668,1166718668,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Week\'\'Default\'\'Calendar\'\'Print\'\'Week\'\'default\'\'calendar\'\'print\'\'week Calendar\'\'/\'\'Print\'\'/\'\'Week','000001000001000097000003'),('CalendarPrintDay000001','Default Calendar Print Day','Default Calendar Print Day Default Calendar Print Day  default calendar print day ','default-calendar-print-day',1166718668,1166718668,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Day\'\'Default\'\'Calendar\'\'Print\'\'Day\'\'default\'\'calendar\'\'print\'\'day Calendar\'\'/\'\'Print\'\'/\'\'Day','000001000001000097000004'),('0Q41OuxKgi0aAJd4Xbas2Q','7.3.9 New Templates','7.3.9 New Templates 7.3.9 New Templates  7.3.9 new templates ','7.3.9_new_templates',1171466654,1171466654,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'7\'\'.\'\'3\'\'.\'\'9\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'9\'\'New\'\'Templates\'\'7\'\'.\'\'3\'\'.\'\'9\'\'new\'\'templates','000001000001000098'),('SQLReportDownload0001','SQLReport Download Default Template','SQLReport Download Default Template untitled  SQLReportDownload0001 ','SQLReportDownload0001',1171466654,1171466654,'3','7','12','WebGUI::Asset::Template',1,'SQLReport\'\'Download\'\'Default\'\'Template\'\'untitled\'\'SQLReportDownload0001 SQLReport\'\'/\'\'Download','000001000001000098000001'),('7.0-style0000000000051','css03.css','css03.css css03.css  style3 css03.css ','style3/css03.css',1147642505,1178723414,'3','7','12','WebGUI::Asset::Snippet',1,'css03\'\'.\'\'css\'\'css03\'\'.\'\'css\'\'style3\'\'css03\'\'.\'\'css body\'\',\'\'html\'\'{\'\'margin\'\':\'\'0px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'b53018\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'body\'\'a\'\'{\'\'color\'\':\'\'#\'\'EE963E\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'1px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'main\'\'{\'\'width\'\':\'\'98\'\'%\'\';\'\'/\'\'*\'\'min\'\'-\'\'width\'\':\'\'790px\'\';\'\'*\'\'/\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'padding\'\'-\'\'top\'\':\'\'20px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'header\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'115px\'\';\'\'}\'\'#\'\'headerTitle\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'left\'\'top\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'#\'\'headerRight\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\'top\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'headerRight\'\'#\'\'title\'\'{\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'25px\'\';\'\'left\'\':\'\'20px\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'#\'\'title\'\'h1\'\'{\'\'text\'\'-\'\'transform\'\':\'\'uppercase\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'font\'\'-\'\'size\'\':\'\'26pt\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'title\'\'h1\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'size\'\':\'\'26pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'}\'\'#\'\'title\'\'h2\'\'{\'\'margin\'\':\'\'0px\'\';\'\'font\'\'-\'\'size\'\':\'\'12pt\'\';\'\'color\'\':\'\'#\'\'bebebe\'\';\'\'padding\'\'-\'\'left\'\':\'\'20px\'\';\'\'}\'\'#\'\'title\'\'img\'\'{\'\'z\'\'-\'\'index\'\':\'\'5\'\';\'\'}\'\'#\'\'login\'\'{\'\'position\'\':\'\'absolute\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'top\'\':\'\'45\'\'%\'\';\'\'right\'\':\'\'150px\'\';\'\'color\'\':\'\'white\'\';\'\'z\'\'-\'\'index\'\':\'\'6\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'}\'\'#\'\'login\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'0px\'\';\'\'}\'\'.\'\'loginBox\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'margin\'\':\'\'0px\'\';\'\'display\'\':\'\'inline\'\';\'\'}\'\'.\'\'loginBox\'\'input\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'mainBody\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'500px\'\';\'\'background\'\':\'\'#\'\'fff\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'0\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainBody\'\'{\'\'height\'\':\'\'auto\'\';\'\'min\'\'-\'\'height\'\':\'\'500px\'\';\'\'}\'\'#\'\'contentArea\'\'{\'\'z\'\'-\'\'index\'\':\'\'2\'\';\'\'position\'\':\'\'relative\'\';\'\'padding\'\'-\'\'top\'\':\'\'50px\'\';\'\'padding\'\'-\'\'left\'\':\'\'10px\'\';\'\'padding\'\'-\'\'right\'\':\'\'20px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'}\'\'html\'\'#\'\'main\'\'#\'\'mainBody\'\'#\'\'contentArea\'\'{\'\'height\'\':\'\'1\'\'%\'\';\'\'}\'\'#\'\'topCorner\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'214px\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'0px\'\';\'\'left\'\':\'\'0px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'main_top_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'z\'\'-\'\'index\'\':\'\'1\'\';\'\'}\'\'#\'\'bottomCorner\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'211px\'\';\'\'position\'\':\'\'absolute\'\';\'\'bottom\'\':\'\'59px\'\';\'\'right\'\':\'\'0px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'main_bottom\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\';\'\'z\'\'-\'\'index\'\':\'\'1\'\';\'\'}\'\'*\'\'html\'\'#\'\'bottomCorner\'\'{\'\'bottom\'\':\'\'58px\'\';\'\'}\'\'#\'\'footer\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'background\'\':\'\'#\'\'000\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'footer_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\'top\'\';\'\'height\'\':\'\'57px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'B53018\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'0\'\';\'\'}\'\'#\'\'footer\'\'#\'\'copyright\'\'{\'\'color\'\':\'\'#\'\'3b3b3b\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'20px\'\';\'\'left\'\':\'\'30px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}','000001000001000090000002');
CREATE TABLE `assetVersionTag` (
  `tagId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `name` varchar(255) NOT NULL default '',
  `isCommitted` int(11) NOT NULL default '0',
  `creationDate` bigint(20) NOT NULL default '0',
  `createdBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `commitDate` bigint(20) NOT NULL default '0',
  `committedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `isLocked` int(11) NOT NULL default '0',
  `lockedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupToUse` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `workflowId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `workflowInstanceId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `comments` text,
  PRIMARY KEY  (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `assetVersionTag` VALUES ('pbversion0000000000001','Initial Import',1,1124395696,'3',1124395696,'3',0,'','','',NULL,NULL),('pbversion0000000000002','Auto Commit',1,1124395696,'3',1124395696,'3',0,'','','',NULL,NULL),('0TD-_gW8MXYYY1elfaIq8A','Upgrade to 6.99.0',1,1147642408,'3',1147642463,'3',0,'','12','',NULL,NULL),('hR5vR1-3bS1SRjIJbdFfmA','Stuff just for 7.0 installs',1,1147642465,'3',1147642540,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('7fIc-1XRhOhRhD-0dKTyhQ','Upgrade to 6.99.1',1,1147962058,'3',1147962059,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('FXmcPafYROBrRl_v_jfgTA','Upgrade to 6.99.2',1,1148579524,'3',1148579527,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('8xT0hPEb637VAv7rHh7xtQ','Upgrade to 6.99.3',1,1149286277,'3',1149286281,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('4Il2HjD0io01Ha4_M-7wnQ','Upgrade to 6.99.4',1,1150476306,'3',1150476308,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('zvS8XcBr1fSFTQs_Tc5SgQ','Upgrade to 6.99.5',1,1151102417,'3',1151102418,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('HESizovvhumfDntihrQUIA','Upgrade to 7.0.0',1,1152740952,'3',1152740952,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('xqjzTDK0mlusPHUe_cyYIg','Upgrade to 7.0.1',1,1152740956,'3',1152740956,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('seCjYB-6Ul2xpKXvi0OKLg','Upgrade to 7.0.2',1,1153362203,'3',1153362203,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('o3w3zEzXxhahfR_0C4jRVw','Upgrade to 7.0.3',1,1154535072,'3',1154535075,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('DdfT0fzgaP678I5DZVoKJg','Upgrade to 7.0.4',1,1154535080,'3',1154535080,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('dec7vItPNcyxRXFWu653oQ','Upgrade to 7.0.5',1,1155139634,'3',1155139634,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('NfQ0_jt_jnfLbmsl-NMx2g','Upgrade to 7.0.6',1,1155766521,'3',1155766521,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('8uegNg3dX5WZnkFuyvyS5g','Upgrade to 7.0.7',1,1157679164,'3',1157679165,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('MjXDt6rl9B1Qxe0C7vAZWQ','Upgrade to 7.0.8',1,1159392394,'3',1159392394,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('rDtVlQclQrHui7JGOW8S0w','Upgrade to 7.0.9',1,1159989349,'3',1159989349,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('KrvQquBmM-aDZJrdX4rMnA','Upgrade to 7.1.0',1,1160607410,'3',1160607411,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('1GIr3XGOaTqoiwybvhcV1w','Upgrade to 7.1.1',1,1161211642,'3',1161211642,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('A6pWuHTOzEgLrHY-PYuXlg','Upgrade to 7.1.2',1,1161891000,'3',1161891000,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('kadRWN5alZwkWth8FkQsug','Upgrade to 7.1.3',1,1162436690,'3',1162436695,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('LJTFKlkCFgtWcowvAiKJfA','Upgrade to 7.2.0',1,1163019035,'3',1163019036,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('oduMWYaceKv0eoNwkIG-Ew','7.2.0 RSS template update',1,1163019036,'3',1163019036,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('cKmp6fMMG3fvvkJCQPQn6w','7.2.0 Collaboration RSS update',1,1163019036,'3',1163019036,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('OW7KlRUcs3LuPfvsJ95m1g','Upgrade to 7.2.1',1,1163630221,'3',1163630222,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('9ps7W3vKUeOq8JZZ0ruQng','Upgrade to 7.2.2',1,1164270974,'3',1164270975,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('8sXvLoprobPcniICsMvzLg','Upgrade to 7.2.3',1,1164849104,'3',1164849104,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('v5poIPxyL6nOpaQVlYnZKw','Upgrade to 7.3.0',1,1165460175,'3',1165460176,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('Y7Q6fC8nEMqRnYLq6XMZBA','Upgrade to 7.3.1',1,1166019641,'3',1166019642,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('2S0fqMYn0WoEYMOFOE4loA','Upgrade to 7.3.2',1,1166718668,'3',1166718669,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('Al2rPocT6__qJSOz0phuJQ','Upgrade to 7.3.3',1,1167871635,'3',1167871635,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('1a-hOOWg44cBy5s1TaRgiw','Upgrade to 7.3.4',1,1168480840,'3',1168480840,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('wR9izZZqRmB0tBX_skb1Jw','Upgrade to 7.3.5',1,1169092823,'3',1169092824,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('kNGLOnk_SxFheyTumDoonA','Upgrade to 7.3.6',1,1169449940,'3',1169449941,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('l8iHMRK1c6M77KEGmQSD6Q','Upgrade to 7.3.7',1,1169738426,'3',1169738426,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('kMDcFwjlRiJEnR5UdKQiZA','Upgrade to 7.3.8',1,1169795123,'3',1169795123,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('erNgmvmqLafaeM_ST1Rs-A','Upgrade to 7.3.9',1,1171466654,'3',1171466654,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('AsHgU4Hce_E7M1ovudnVkA','Upgrade to 7.3.10',1,1172072639,'3',1172072639,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('WIQhoDJpDWGEFPjaxz2_hg','Upgrade to 7.3.11',1,1172681103,'3',1172681103,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('50kwzDShUy6V7B2bidpMww','Upgrade to 7.3.12',1,1173889335,'3',1173889335,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('oZT1Uk6f32a6it_RJQLDXQ','Upgrade to 7.3.13',1,1174490121,'3',1174490121,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('bo1kUdYl2He5wsSufnhPWA','Upgrade to 7.3.14',1,1175702683,'3',1175702683,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('dF5PtzM35sWi-Etb_NTwbg','Upgrade to 7.3.15',1,1177518212,'3',1177518212,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('Vdv2VqUAjlFlpO5_qpEORg','Upgrade to 7.3.16',1,1178723412,'3',1178723414,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('w5xjrxMimIzhVLrOwnpAFw','Upgrade to 7.3.17',1,1178723416,'3',1178723416,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('KgbL840VqI4L4H9kke4yDQ','Upgrade to 7.3.18',1,1179942104,'3',1179942104,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('H_re2ZLDlCyIEijzkqevsQ','Upgrade to 7.3.19',1,1184192509,'3',1184192510,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('F64ClalNGkzGLBR-lMIfIA','Upgrade to 7.3.20',1,1184192515,'3',1184192515,'3',0,'','12','pbworkflow000000000003',NULL,NULL),('SgQftv9CGxlpiNhP8qhNPg','Upgrade to 7.3.21',1,1184785340,'3',1184785340,'3',0,'','12','pbworkflow000000000003',NULL,NULL);
CREATE TABLE `authentication` (
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `authMethod` varchar(30) NOT NULL default '',
  `fieldName` varchar(128) NOT NULL default '',
  `fieldData` text,
  PRIMARY KEY  (`userId`,`authMethod`,`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `authentication` VALUES ('1','LDAP','ldapUrl',NULL),('3','LDAP','ldapUrl',''),('1','LDAP','connectDN',NULL),('3','LDAP','connectDN',''),('1','WebGUI','identifier','No Login'),('3','WebGUI','identifier','RvlMjeFPs2aAhQdo/xt/Kg'),('1','WebGUI','passwordLastUpdated','1078704037'),('1','WebGUI','passwordTimeout','3122064000'),('1','WebGUI','changeUsername','1'),('1','WebGUI','changePassword','1'),('3','WebGUI','passwordLastUpdated','1078704037'),('3','WebGUI','passwordTimeout','3122064000'),('3','WebGUI','changeUsername','1'),('3','WebGUI','changePassword','1');
CREATE TABLE `cache` (
  `namespace` varchar(128) NOT NULL,
  `cachekey` varchar(128) NOT NULL,
  `expires` bigint(20) NOT NULL,
  `size` int(11) NOT NULL,
  `content` mediumtext,
  PRIMARY KEY  (`namespace`,`cachekey`),
  KEY `namespace_cachekey_size` (`namespace`,`cachekey`,`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `commerceSalesTax` (
  `commerceSalesTaxId` varchar(22) NOT NULL,
  `regionIdentifier` varchar(50) NOT NULL,
  `salesTax` float NOT NULL,
  PRIMARY KEY  (`commerceSalesTaxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `commerceSettings` (
  `fieldName` varchar(64) NOT NULL default '',
  `fieldValue` varchar(255) NOT NULL default '',
  `namespace` varchar(64) NOT NULL default '',
  `type` varchar(10) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `databaseLink` (
  `databaseLinkId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `title` varchar(255) default NULL,
  `DSN` varchar(255) default NULL,
  `username` varchar(255) default NULL,
  `identifier` varchar(255) default NULL,
  `allowedKeywords` text,
  PRIMARY KEY  (`databaseLinkId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `groupGroupings` (
  `groupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `inGroup` varchar(22) character set utf8 collate utf8_bin NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `groupGroupings` VALUES ('4','12'),('6','12'),('8','12'),('11','12'),('3','2'),('3','4'),('3','5'),('3','6'),('3','7'),('3','8'),('3','13'),('3','11'),('3','12'),('3','14'),('3','pbgroup000000000000015'),('3','pbgroup000000000000016'),('3','pbgroup000000000000017'),('3','1');
CREATE TABLE `groupings` (
  `groupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `expireDate` bigint(20) NOT NULL default '2114402400',
  `groupAdmin` int(11) NOT NULL default '0',
  PRIMARY KEY  (`groupId`,`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `groupings` VALUES ('1','1',2114402400,0),('3','3',2114402400,0),('7','1',2114402400,0),('7','3',2114402400,0),('2','3',2114402400,0);
CREATE TABLE `groups` (
  `groupId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupName` varchar(30) default NULL,
  `description` varchar(255) default NULL,
  `expireOffset` int(11) NOT NULL default '314496000',
  `karmaThreshold` int(11) NOT NULL default '1000000000',
  `ipFilter` text,
  `dateCreated` int(11) NOT NULL default '997938000',
  `lastUpdated` int(11) NOT NULL default '997938000',
  `deleteOffset` int(11) NOT NULL default '14',
  `expireNotifyOffset` int(11) NOT NULL default '-14',
  `expireNotifyMessage` text,
  `expireNotify` int(11) NOT NULL default '0',
  `scratchFilter` text,
  `autoAdd` int(11) NOT NULL default '0',
  `autoDelete` int(11) NOT NULL default '0',
  `databaseLinkId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupCacheTimeout` int(11) NOT NULL default '3600',
  `dbQuery` text,
  `isEditable` int(11) NOT NULL default '1',
  `showInForms` int(11) NOT NULL default '1',
  `ldapGroup` varchar(255) default NULL,
  `ldapGroupProperty` varchar(255) default NULL,
  `ldapRecursiveProperty` varchar(255) default NULL,
  `ldapLinkId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `ldapRecursiveFilter` mediumtext,
  PRIMARY KEY  (`groupId`),
  KEY `groupName` (`groupName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `groups` VALUES ('1','Visitors','This is the public group that has no privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL),('2','Registered Users','All registered users belong to this group automatically. There are no associated privileges other than that the user has an account and is logged in.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL),('3','Admins','Anyone who belongs to this group has privileges to do anything and everything.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('4','Content Managers','Users that have privileges to edit content on this site. The user still needs to be added to a group that has editing privileges on specific pages.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('6','Package Managers','Users that have privileges to add, edit, and delete packages of wobjects and pages to deploy.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('7','Everyone','A group that automatically includes all users including Visitors.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL),('8','Template Managers','Users that have privileges to edit templates for this site.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('13','Export Managers','Users in this group can export pages to disk.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('11','Secondary Admins','Users that have limited administrative privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('12','Turn Admin On','These users can enable admin mode.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('wP1Lt8NIySq9MS8xPGnAsQ','pSygeMG7bSL1Za0SNqfUbw','The group to store subscriptions for the thread pSygeMG7bSL1Za0SNqfUbw',314496000,1000000000,NULL,1109194980,1109194980,14,-14,NULL,0,NULL,0,0,'',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL),('OL-d6C93EeUr4Rja-q3-yQ','mdIaXozmVNE_Rga2BY0mxA','The group to store subscriptions for the thread mdIaXozmVNE_Rga2BY0mxA',314496000,1000000000,NULL,1109194980,1109194980,14,-14,NULL,0,NULL,0,0,'',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL),('YPCggIxdKT3AMMlML-CAuw','9kDcFufTKbMTkeAHyP36fw','The group to store subscriptions for the thread 9kDcFufTKbMTkeAHyP36fw',314496000,1000000000,NULL,1109194980,1109194980,14,-14,NULL,0,NULL,0,0,'',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL),('C02CXMw3c42EJJR_nktyMw','5Y8eOI2u_HOvkzrRuLdz1g','The group to store subscriptions for the thread 5Y8eOI2u_HOvkzrRuLdz1g',314496000,1000000000,NULL,1109194980,1109194980,14,-14,NULL,0,NULL,0,0,'',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL),('zZmjNsD1FhaSFkgXvnCQUg','ImmYJRWOPFedzI4Bg1k6GA','The group to store subscriptions for the thread ImmYJRWOPFedzI4Bg1k6GA',314496000,1000000000,NULL,1109194980,1109194980,14,-14,NULL,0,NULL,0,0,'',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL),('14','Product Managers','The group that is allowed to edit, delete and create products.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('pbgroup000000000000015','Workflow Managers','People who can create, edit, and delete workflows.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('pbgroup000000000000016','Version Tag Managers','People who can create, edit, and delete special version tags.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL),('pbgroup000000000000017','Ad Manager','These users will be able to manage advertisements.',314496000,1000000000,NULL,1147642437,1147642437,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL);
CREATE TABLE `imageColor` (
  `colorId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(255) NOT NULL default 'untitled',
  `fillTriplet` char(7) NOT NULL default '#000000',
  `fillAlpha` char(2) NOT NULL default '00',
  `strokeTriplet` char(7) NOT NULL default '#000000',
  `strokeAlpha` char(2) NOT NULL default '00',
  PRIMARY KEY  (`colorId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `imageColor` VALUES ('UVL-iDSq7VTks3RCH2FEWg','Green','#31ca31','99','#31ca31','00'),('3Tf0W_tkAjR902FJcGZxCg','Blue','#007dff','99','#007dff','00'),('fuFripVJ4es4bUBPOq3ENQ','Yellow','#ffda08','99','#ffda08','00'),('n3yfk8JGilmChSer2xuZ0w','Orange','#FF8000','99','#FF8000','00'),('W683fO6r8uHgZ-Z-VodY7w','Red','#FF2000','99','#FF2000','00'),('pSnxDIInB9r0n06q6kKV3w','Purple','#FF00B0','99','#FF00B0','00');
CREATE TABLE `imageFont` (
  `fontId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(255) default NULL,
  `storageId` varchar(22) default NULL,
  `filename` varchar(255) default NULL,
  PRIMARY KEY  (`fontId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `imageFont` VALUES ('defaultFont','WebGUI default font',NULL,'default.ttf');
CREATE TABLE `imagePalette` (
  `paletteId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `name` varchar(255) NOT NULL default 'untitled',
  PRIMARY KEY  (`paletteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `imagePalette` VALUES ('defaultPalette','Default palette');
CREATE TABLE `imagePaletteColors` (
  `paletteId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `colorId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `paletteOrder` int(11) NOT NULL,
  PRIMARY KEY  (`paletteId`,`paletteOrder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `imagePaletteColors` VALUES ('defaultPalette','UVL-iDSq7VTks3RCH2FEWg',1),('defaultPalette','3Tf0W_tkAjR902FJcGZxCg',2),('defaultPalette','fuFripVJ4es4bUBPOq3ENQ',3),('defaultPalette','n3yfk8JGilmChSer2xuZ0w',4),('defaultPalette','W683fO6r8uHgZ-Z-VodY7w',5),('defaultPalette','pSnxDIInB9r0n06q6kKV3w',6);
CREATE TABLE `inbox` (
  `messageId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `status` varchar(15) NOT NULL default 'pending',
  `dateStamp` bigint(20) NOT NULL,
  `completedOn` bigint(20) default NULL,
  `completedBy` varchar(22) character set utf8 collate utf8_bin default NULL,
  `userId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `groupId` varchar(22) character set utf8 collate utf8_bin default NULL,
  `subject` varchar(255) NOT NULL default 'No Subject',
  `message` mediumtext,
  PRIMARY KEY  (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `incrementer` (
  `incrementerId` varchar(50) NOT NULL default '',
  `nextValue` int(11) NOT NULL default '1',
  PRIMARY KEY  (`incrementerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `karmaLog` (
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `amount` int(11) NOT NULL default '1',
  `source` varchar(255) default NULL,
  `description` text,
  `dateModified` bigint(20) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `ldapLink` (
  `ldapLinkId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ldapLinkName` varchar(255) NOT NULL default '',
  `ldapUrl` varchar(255) NOT NULL default '',
  `connectDn` varchar(255) NOT NULL default '',
  `identifier` varchar(255) NOT NULL default '',
  `ldapUserRDN` varchar(255) default NULL,
  `ldapIdentity` varchar(255) default NULL,
  `ldapIdentityName` varchar(255) default NULL,
  `ldapPasswordName` varchar(255) default NULL,
  `ldapSendWelcomeMessage` char(2) default NULL,
  `ldapWelcomeMessage` text,
  `ldapAccountTemplate` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ldapCreateAccountTemplate` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ldapLoginTemplate` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `ldapGlobalRecursiveFilter` mediumtext,
  PRIMARY KEY  (`ldapLinkId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `ldapLink` VALUES ('1uBbhUm686mkFZ1ghv7Lag','Default LDAP Connection','ldap://ldap.mycompany.com:389/o=MyCompany','','','cn','shortname','LDAP Shortname','LDAP Password','0','Welcome to our site.','PBtmpl0000000000000004','PBtmpl0000000000000005','PBtmpl0000000000000006',NULL);
CREATE TABLE `mailQueue` (
  `messageId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `message` mediumtext,
  `toGroup` varchar(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `metaData_properties` (
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `fieldName` varchar(100) NOT NULL default '',
  `description` mediumtext NOT NULL,
  `fieldType` varchar(30) default NULL,
  `possibleValues` text,
  `defaultValue` varchar(100) default NULL,
  PRIMARY KEY  (`fieldId`),
  UNIQUE KEY `field_unique` (`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `metaData_values` (
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `value` varchar(100) default NULL,
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`fieldId`,`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `passiveProfileAOI` (
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `fieldId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `value` varchar(100) NOT NULL default '',
  `count` int(11) default NULL,
  PRIMARY KEY  (`userId`,`fieldId`,`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `passiveProfileLog` (
  `passiveProfileLogId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `userId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `sessionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `dateOfEntry` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`passiveProfileLogId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `productParameterOptions` (
  `optionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `parameterId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `value` varchar(64) NOT NULL default '',
  `priceModifier` decimal(10,2) default '0.00',
  `weightModifier` decimal(6,2) default '0.00',
  `skuModifier` varchar(64) default NULL,
  PRIMARY KEY  (`optionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `productParameters` (
  `parameterId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `productId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `name` varchar(64) NOT NULL default '',
  PRIMARY KEY  (`parameterId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `productVariants` (
  `variantId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `productId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `composition` mediumtext NOT NULL,
  `sku` varchar(255) default NULL,
  `price` decimal(12,2) default '0.00',
  `weight` decimal(8,3) default '0.000',
  `skuOverride` tinyint(1) default '0',
  `priceOverride` tinyint(1) default '0',
  `weightOverride` tinyint(1) default '0',
  `available` tinyint(1) default '1',
  PRIMARY KEY  (`variantId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `products` (
  `productId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `description` mediumtext,
  `price` decimal(12,2) NOT NULL default '0.00',
  `weight` decimal(8,3) NOT NULL default '0.000',
  `sku` varchar(255) NOT NULL default '',
  `skuTemplate` varchar(255) default NULL,
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `groupId` varchar(22) default NULL,
  `groupExpiresOffset` varchar(16) default NULL,
  `useSalesTax` int(11) default '0',
  PRIMARY KEY  (`productId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `redirect` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `redirectUrl` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `replacements` (
  `replacementId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `searchFor` varchar(255) default NULL,
  `replaceWith` text,
  PRIMARY KEY  (`replacementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `replacements` VALUES ('1','[quote]','<blockquote><i>'),('2','[/quote]','</i></blockquote>'),('3','[image]','<img src=\"'),('4','[/image]','\" border=\"0\" / >'),('5','shit','crap'),('6','fuck','farg'),('7','asshole','icehole'),('8','nigger','guy'),('9','[b]','<b>'),('10','[/b]','</b>'),('11','[i]','<i>'),('12','[/i]','</i>');
CREATE TABLE `search` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `classLimiter` text,
  `searchRoot` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'PBasset000000000000001',
  `templateId` varchar(22) character set utf8 collate utf8_bin NOT NULL default 'PBtmpl0000000000000200',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `settings` (
  `name` varchar(255) NOT NULL default '',
  `value` text,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `settings` VALUES ('maxAttachmentSize','10000'),('sessionTimeout','3600'),('smtpServer','localhost'),('companyEmail','info@mycompany.com'),('companyName','My Company'),('companyURL','http://www.mycompany.com'),('authMethod','WebGUI'),('anonymousRegistration','0'),('notFoundPage','68sKwDgf9cGH58-NZcU4lg'),('webguiRecoverPasswordEmail','Someone (probably you) requested your account information be sent. Your password has been reset. The following represents your new account information:'),('profileName','1'),('profileExtraContact','1'),('profileMisc','1'),('profileHome','0'),('profileWork','0'),('preventProxyCache','0'),('thumbnailSize','50'),('textBoxSize','30'),('defaultPage','68sKwDgf9cGH58-NZcU4lg'),('defaultVersionTagWorkflow','pbworkflow000000000003'),('useKarma','0'),('karmaPerLogin','1'),('runOnRegistration',''),('maxImageSize','100000'),('showDebug','0'),('richEditor','PBrichedit000000000001'),('selfDeactivation','1'),('snippetsPreviewLength','30'),('mailFooter','^c;\n^e;\n^u;\n'),('webguiSendWelcomeMessage','0'),('webguiWelcomeMessage','Welcome to our site.'),('encryptLogin','0'),('hostToUse','HTTP_HOST'),('webguiExpirePasswordOnCreation','0'),('webguiPasswordLength','0'),('webguiPasswordRecovery','0'),('webguiPasswordTimeout','3122064000'),('commerceCheckoutCanceledTemplateId','PBtmpl0000000000000015'),('webguiChangePassword','1'),('webguiChangeUsername','1'),('metaDataEnabled','0'),('passiveProfilingEnabled','0'),('urlExtension',''),('commerceConfirmCheckoutTemplateId','PBtmpl0000000000000016'),('commercePaymentPlugin','PayFlowPro'),('commerceSelectPaymentGatewayTemplateId','PBtmpl0000000000000017'),('commerceTransactionErrorTemplateId','PBtmpl0000000000000018'),('AdminConsoleTemplate','PBtmpl0000000000000001'),('userFunctionStyleId','stevestyle000000000003'),('webguiValidateEmail','0'),('webguiUseCaptcha','1'),('webguiAccountTemplate','PBtmpl0000000000000010'),('webguiCreateAccountTemplate','PBtmpl0000000000000011'),('webguiExpiredPasswordTemplate','PBtmpl0000000000000012'),('webguiLoginTemplate','PBtmpl0000000000000013'),('webguiPasswordRecoveryTemplate','PBtmpl0000000000000014'),('ldapConnection','1uBbhUm686mkFZ1ghv7Lag'),('commerceSelectShippingMethodTemplateId','PBtmplCSSM000000000001'),('commerceViewShoppingCartTemplateId','PBtmplVSC0000000000001'),('commerceSendDailyReportTo',''),('debugIp',''),('showPerformanceIndicators','0'),('mailReturnPath',NULL),('commercePurchaseHistoryTemplateId','PBtmpl0000000000000019'),('webguiNonWordCharacters','0'),('webguiRequiredMixedCase','0'),('webguiRequiredDigits','0'),('automaticLDAPRegistration','0'),('commerceEnableSalesTax','0'),('trashWorkflow','DPWwf20061030000000001'),('purgeWorkflow','DPWwf20061030000000001'),('changeUrlWorkflow','DPWwf20061030000000001'),('webguiPasswordRecoveryRequireUsername','1'),('specialState','init');
CREATE TABLE `shoppingCart` (
  `sessionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `itemId` varchar(64) character set utf8 collate utf8_bin NOT NULL default '',
  `itemType` varchar(40) NOT NULL default '',
  `quantity` int(4) NOT NULL default '0',
  PRIMARY KEY  (`sessionId`,`itemId`,`itemType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `snippet` (
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `snippet` mediumtext,
  `processAsTemplate` int(11) NOT NULL default '0',
  `mimeType` varchar(50) NOT NULL default 'text/html',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `snippet` VALUES ('SynConXSLT000000000001','<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('SynConXSLT000000000002','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://backend.userland.com/rss091\">RSS version 0.91 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('SynConXSLT000000000003','<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n  Title: RSS 1.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 1.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n  xmlns:foo=\"http://purl.org/rss/1.0/\">\n  	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://web.resource.org/rss/1.0/\">RSS version 1.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"foo:title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{foo:link}\" title=\"{foo:description}\">\n				<xsl:value-of select=\"foo:title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n						(\n				<xsl:value-of select=\"dc:date\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>\n',0,'application/xml',1124395707,3600),('SynConXSLT000000000004','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 2.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 2.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://blogs.law.harvard.edu/tech/rss\">RSS version 2.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n		 		(<xsl:value-of select=\"pubDate\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('7.0-style0000000000003','body, html\n{\n	text-align:center;\n	margin:0px;\n	height:100%;	\n	background-color:#494949;\n}\n\n#main\n{\n	width:800px;\n	background: url(\'^FileUrl(style1/main_bg.jpg);\') repeat-y;\n	height:100%;\n	margin-left:auto;\n	margin-right:auto;\n	margin-top:0px;\n	margin-bottom:0px;\n	position:relative;\n}\nbody > #main\n{\n	height:auto;\n	min-height:100%;\n}\n\n#main #mainHeader\n{\n	width:800px;\n	height:133px;\n	background: url(\'^FileUrl(style1/header.jpg);\') top left no-repeat;\n	margin-bottom:0px;\n	position:relative;\n}\n#main #mainHeader #title\n{\n	position:absolute;\n	top:23px;\n	left:145px;\n	font-size:32pt;\n	font-family:arial;\n	color:white;\n	font-weight:bold;\n}\n#main #mainHeader #title a {\n	color:white;\n	text-decoration:none;\n}\n\n#main #mainContent\n{\n	background: url(\'^FileUrl(style1/orange_left01.jpg);\') left top no-repeat;\n	width:100%;\n	height:100%;			\n	margin-top:0px;\n	text-align:left;\n	border:solid red 0px;\n}\n#main > #mainContent\n{\n	margin-top:0px;\n	min-height:500px;\n}\n#main > #mainContent > p {\n	margin-top:0px;\n}\n#main #mainContent #mainText a:link {\n	color:#FF7F23;\n}\n#main #mainContent #mainText a:visited {\n	color:#D25900;\n}\n\n/* LEVEL 1 AND 2 NAVIGATION */\n#main .mainNav_1, #main .mainNav_2 {\n	border-bottom:dashed #DADADA 1px;			\n	width:621px;\n	height:25px;\n	text-align:left;\n	position:relative;\n	margin-left:137px;	\n	clear:both;\n}\n#main .mainNav_1 a:link, #main .mainNav_1 a:visited, #main .mainNav_2 a:link, #main .mainNav_2 a:visited {\n	color:white;\n	text-decoration:none;\n	top:5px;\n	position:relative;\n	-moz-box-sizing:border-box;\n}\n#main .mainNav_1 a:hover,#main .mainNav_2 a:hover {\n	color:black;\n}\n#main .mainNav_1 div .left, #main .mainNav_2 div .left {\n	width:12px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .left {\n	background: url(\'^FileUrl(style1/nav2_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div .center, #main .mainNav_2 div .center {			\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_center.jpg);\') repeat-x top left;\n	color:white;\n	font-family:arial, verdana;\n	font-size:8pt;\n}\n#main .mainNav_2 div .center {\n	background: url(\'^FileUrl(style1/nav2_off_center.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div .right, #main .mainNav_2 div .right {\n	width:10px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .right {\n	background: url(\'^FileUrl(style1/nav2_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav1_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav1_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav1_on_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav2_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav2_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_2 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav2_on_right.jpg);\') no-repeat top left;\n}		\n#main .mainNav_1 div.navOn a:link, #main .mainNav_1 div.navOn a:visited, #main .mainNav_2 div.navOn a:link, #main .mainNav_2 div.navOn a:visited {\n	color:black;\n}\n/* ENDOF LEVEL 1 AND 2 NAVIGATION */\n\n#main #crumbTrail {\n	margin-left:177px;\n	margin-bottom:0px;\n	color:gray;\n	font-size:8pt;\n	font-weight:bold;\n}\n#main #crumbTrail a.crumbTrail:visited, #main #crumbTrail a.crumbTrail:link {\n	color:silver;\n	font-size:8pt;			\n	font-family:arial;\n	text-decoration:none;\n	font-weight:normal;\n}\n#main #crumbTrail a.crumbTrail:hover {\n	color:gray;\n}\n\n#main #mainText\n{\n	padding-left:150px;\n	font-family:verdana;\n	font-size:9pt;\n	width:600px;\n	margin-top:0px;\n}\n\n#main #gui\n{\n	bottom:0px;\n	left:0px;\n	position:absolute;\n	width:135px;\n	font-size:8pt;\n	color:black;\n	font-family:arial;\n	text-align:right;\n}\n#main #gui .loginBox {\n	padding-right:12px;\n	-moz-box-sizing:border-box;\n	width:100px;			\n	float:right;\n	margin-bottom:10px;\n}\n#main #gui .loginBox .loginBoxField {\n	width:75px;\n}\n#main #gui .loginBox .loginBoxButton {\n	background-color:#D65501;\n	color:white;\n	border:solid white 2px;\n	margin-top:4px;\n	font-variant:small-caps;\n}\n#main #gui a\n{\n	color:white;			\n}\n#copyright {\n	color:#fff;\n	position:absolute;\n	top:110px;\n	right:40px;\n	font-family:verdana;\n	font-size:8pt;\n	font-weight:bold;\n	background-color:#2D2D2D;\n	opacity:0.4;\n	-moz-opacity:0.4;\n	-khtml-opacity:0.4;	\n	padding:2px;\n}\n* html #copyright {\n	background: transparent;\n}\n',1,'text/css',1147642492,3600),('7.0-style0000000000033','body, html {			\n	height:100%;			\n}\nbody {\n	background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg);\') repeat-y right; \n	margin:0px;\n}\n.rightColumn {\n	width:20%;\n	height:100%;\n	background: #eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg);\') repeat-y right;			\n	text-align:center;	\n}\n.rightColumn #pb_wg_bg {\n	background: url(\'^FileUrl(style2/pb_wg_bg.jpg);\') repeat-x;\n	width:100%;\n	text-align:left;			\n}\n.rightColumn #pb_wg {\n	background: url(\'^FileUrl(style2/pb_wg.jpg);\') left no-repeat;\n	height:53px;\n}\n.leftColumn {			\n	width:80%;				\n	background: white url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; \n}		\n.leftColumn #header {\n	width:100%;\n	background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg);\') right no-repeat; \n	height:86px;\n	position:relative;\n}\n.leftColumn #header #title, .leftColumn #header #title_bg  {\n	color:white;\n	font-size:36pt;\n	font-weight:bold;\n	font-family:arial;\n	font-variant:small-caps;\n	letter-spacing:12px;\n	top:15px;\n	left:5px;\n	position:absolute;\n	z-index:10;\n}\n.leftColumn #header #title a {\n	color:white;\n	text-decoration:none;\n}\n.leftColumn #header #title_bg  {\n	color:black;\n	z-index:5;\n	top:17px;\n	left:7px;\n}\n.leftColumn #context {\n	/*background: #fff url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; */\n	width:95%;\n	font-family:verdana;\n	font-size:9pt;\n	color:#242424;\n	-moz-box-sizing:border-box;			\n	position:relative;\n	padding-left:1%;\n	padding-right:1%;\n	padding-bottom:15px;\n}\n.leftColumn #context a {\n	color:#7C9AB0;\n	font-weight:bold;\n}\n.leftColumn #context a:hover {\n	text-decoration:none;\n}\n.leftColumn #pageTitleBG {\n	background: url(\'^FileUrl(style2/page_title_bg.jpg);\') repeat-x; \n	width:100%;\n}\n.leftColumn #pageTitleBG #pageTitle {\n	background: url(\'^FileUrl(style2/page_title.jpg);\') right no-repeat; \n	width:100%;\n	height:50px;\n}		\n.leftColumn #pageTitleBG #pageTitle h2 {\n	font-size:14pt;\n	color:#696969;\n	font-family:arial;\n	font-weight:normal;\n	margin:0px;\n	padding-top:2px;\n	padding-left:25px;\n	letter-spacing:3px;\n}\n.rightColumn #nav {\n	width:85%;\n	background: #b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg);\') repeat-x top;			\n	border-right:solid #848484 1px;\n	margin-left:auto;\n	margin-right:auto;\n	text-align:left;\n	padding-left:3px;\n	padding-top:7px;\n	padding-bottom:7px;\n}\n.rightColumn #nav a {\n	color:white;\n	font-size:8pt;\n	font-weight:bold;\n	text-decoration:none;\n	font-family:arial;\n	line-height:8pt;			\n}		\n.rightColumn #nav .selectedMenuItem {\n	color:yellow;\n}\n#loginStyles {\n	font-size:8pt;\n	font-family:arial;\n	padding-bottom:25px;\n}\n#loginStyles a {\n	color:#89ACCF;\n	font-weight:bold;			\n	border-bottom:solid transparent 2px;\n	text-decoration:none;\n}\n#loginStyles a:hover {\n	border-bottom:dotted #B2C9D9 2px;\n}	\n\n.copyright {\n	border-top:solid silver 3px;\n	background-color:gray;\n	font-family:arial;\n	font-size:9pt;\n	color:silver;	\n	text-align:center;\n}\n',0,'text/css',1147642500,3600),('7.0-style0000000000051','body, html {\n	margin:0px;\n	background-color:#b53018;\n	padding:0px;\n}\n#main {\n	width:98%;\n	/*min-width:790px;*/\n	margin:0px;\n	padding:0px;\n	padding-top:20px;\n	padding-bottom:20px;\n	position:relative;\n}\n#header { \n	background: url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;\n	width:100%;\n	margin:0px;			\n	height:115px;\n}\n#headerTitle {\n	background: url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;\n	height:100%;\n	width:100%;\n}\n#headerRight {\n	background: url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;\n	width:100%;\n	height:100%;\n	text-align:right;\n	position:relative;\n}\n#headerRight #title {\n	position:absolute;\n	top:25px;\n	left:20px;\n	font-family:arial;\n	text-align:left;\n}\n#title h1 {\n	text-transform:uppercase;			\n	margin-bottom:0px;	\n	font-weight:normal;\n	font-size:26pt;\n	margin-top:0px;\n	color:white;\n}\n#title h1 a {\n	color:white;\n	text-decoration:none;\n}\n#title h2 {\n	margin:0px;\n	font-size:12pt;\n	color:#bebebe;\n	padding-left:20px;\n}\n#title img {\n	z-index:5;\n}\n#login {\n	position:absolute;\n	font-size:8pt;\n	top:45%;\n	right:150px;			\n	color:white;\n	z-index:6;\n	font-family:arial;\n}\n#login a {\n	color:white;\n}\n.loginBox {\n	font-size:8pt;\n	margin:0px;\n	display:inline;\n}\n.loginBox input {\n	font-size:8pt;\n}\n\n#mainBody {\n	width:100%;\n	margin:0px;\n	height:500px;\n	background: #fff;\n	position:relative;\n}	\n#main > #mainBody {\n	height:auto;\n	min-height:500px;\n}\n#contentArea {\n	z-index:2;\n	position:relative;\n	padding-top:50px;\n	padding-left:10px;\n	padding-right:20px;\n	padding-bottom:20px;\n	-moz-box-sizing:border:box;\n	font-family:verdana;\n	font-size:9pt;\n\n}\nhtml #main #mainBody #contentArea {\n	height:1%;\n}\n#contentArea a {\n	color:#EE963E;\n	font-weight:bold;\n	letter-spacing:1px;\n	font-size:8pt;\n}\n#topCorner {\n	width:100%;\n	height:214px;\n	position:absolute;\n	top:0px;\n	left:0px;\n	background: url(\'^FileUrl(style3/main_top_bg.jpg);\') repeat-x;\n	z-index:1;\n}\n#bottomCorner {\n	width:100%;\n	height:211px;\n	position:absolute;\n	bottom:0px;\n	right:0px;\n	background: url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;\n	z-index:1;\n}		\n\n#footer {\n	width:100%;\n	margin:0px;\n	background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;\n	height:57px;\n	border-top:solid #B53018 2px;\n	text-align:right;\n	position:relative;\n}		\n#footer #copyright {\n	color:#3b3b3b;\n	font-family:arial;\n	position:absolute;\n	top:20px;\n	left:30px;\n	font-size:8pt;\n}\n\n',0,'text/css',1147642505,3600),('pbrobot000000000000001','User-agent: googlebot\nDisallow: *?op=displayLogin\nDisallow: *?op=makePrintable\n',0,'text/plain',1147642511,3600),('7.0-style0000000000051','body, html {\n        margin:0px;\n        background-color:#b53018;\n        padding:0px;\n}\nbody a {\n        color:#EE963E;font-weight:bold;\n letter-spacing:1px;\n font-size:8pt;\n}\n#main {\n        width:98%;\n        /*min-width:790px;*/\n        margin:0px;\n        padding:0px;\n        padding-top:20px;\n        padding-bottom:20px;\n        position:relative;\n}\n#header { \n        background: url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;\n        width:100%;\n        margin:0px;\n        height:115px;\n}\n#headerTitle {\n        background: url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;\n        height:100%;\n        width:100%;\n}\n#headerRight {\n        background: url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;\n        width:100%;\n        height:100%;\n        text-align:right;\n        position:relative;\n}\n#headerRight #title {\n        position:absolute;\n        top:25px;\n        left:20px;\n        font-family:arial;\n        text-align:left;\n}\n#title h1 {\n        text-transform:uppercase;\n        margin-bottom:0px;\n        font-weight:normal;\n        font-size:26pt;\n        margin-top:0px;\n        color:white;\n}\n#title h1 a {\n        color:white;\n        text-decoration:none; font-size: 26pt; font-weight: normal; \n}\n#title h2 {\n        margin:0px;\n        font-size:12pt;\n        color:#bebebe;\n        padding-left:20px;\n}\n#title img {\n        z-index:5;\n}\n#login {\n        position:absolute;\n        font-size:8pt;\n        top:45%;\n        right:150px;\n        color:white;\n        z-index:6;\n        font-family:arial;\n}\n#login a {\n        color:white; font-weight: normal; letter-spacing: 0px;\n}\n.loginBox {\n        font-size:8pt;\n        margin:0px;\n        display:inline;\n}\n.loginBox input {\n        font-size:8pt;\n}\n\n#mainBody {\n        width:100%;\n        margin:0px;\n        height:500px;\n        background: #fff;\n        position:relative;\n}\n#main > #mainBody {\n        height:auto;\n        min-height:500px;\n}\n#contentArea {\n        z-index:2;\n        position:relative;\n        padding-top:50px;\n        padding-left:10px;\n        padding-right:20px;\n        padding-bottom:20px;\n        -moz-box-sizing:border-box;\n        font-family:verdana;\n        font-size:9pt;\n\n}\nhtml #main #mainBody #contentArea {\n        height:1%;\n}\n#topCorner {\n        width:100%;\n        height:214px;\n        position:absolute;\n        top:0px;\n        left:0px;\n        background: url(\'^FileUrl(style3/main_top_bg.jpg);\') repeat-x;\n        z-index:1;\n}\n#bottomCorner {\n        width:100%;\n        height:211px;\n        position:absolute;\n        bottom:0px;\n        right:0px;\n        background: url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;\n        z-index:1;\n}\n\n#footer {\n        width:100%;\n        margin:0px;\n        background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;\n        height:57px;\n        border-top:solid #B53018 2px;\n        text-align:right;\n        position:relative;\n}\n#footer #copyright {\n        color:#3b3b3b;\n        font-family:arial;\n        position:absolute;\n        top:20px;\n        left:30px;\n        font-size:8pt;\n}\n',0,'text/css',1149286280,3600),('7.0-style0000000000051','body, html {\n        margin:0px;\n        background-color:#b53018;\n        padding:0px;\n}\nbody a {\n        color:#EE963E;font-weight:bold;\n letter-spacing:1px;\n font-size:8pt;\n}\n#main {\n        width:98%;\n        /*min-width:790px;*/\n        margin:0px;\n        padding:0px;\n        padding-top:20px;\n        padding-bottom:20px;\n        position:relative;\n}\n#header { \n        background: url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;\n        width:100%;\n        margin:0px;\n        height:115px;\n}\n#headerTitle {\n        background: url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;\n        height:100%;\n        width:100%;\n}\n#headerRight {\n        background: url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;\n        width:100%;\n        height:100%;\n        text-align:right;\n        position:relative;\n}\n#headerRight #title {\n        position:absolute;\n        top:25px;\n        left:20px;\n        font-family:arial;\n        text-align:left;\n}\n#title h1 {\n        text-transform:uppercase;\n        margin-bottom:0px;\n        font-weight:normal;\n        font-size:26pt;\n        margin-top:0px;\n        color:white;\n}\n#title h1 a {\n        color:white;\n        text-decoration:none; font-size: 26pt; font-weight: normal; \n}\n#title h2 {\n        margin:0px;\n        font-size:12pt;\n        color:#bebebe;\n        padding-left:20px;\n}\n#title img {\n        z-index:5;\n}\n#login {\n        position:absolute;\n        font-size:8pt;\n        top:45%;\n        right:150px;\n        color:white;\n        z-index:6;\n        font-family:arial;\n}\n#login a {\n        color:white; font-weight: normal; letter-spacing: 0px;\n}\n.loginBox {\n        font-size:8pt;\n        margin:0px;\n        display:inline;\n}\n.loginBox input {\n        font-size:8pt;\n}\n\n#mainBody {\n        width:100%;\n        margin:0px;\n        height:500px;\n        background: #fff;\n        position:relative;\n	z-index:0;\n}\n#main > #mainBody {\n        height:auto;\n        min-height:500px;\n}\n#contentArea {\n        z-index:2;\n        position:relative;\n        padding-top:50px;\n        padding-left:10px;\n        padding-right:20px;\n        padding-bottom:20px;\n        -moz-box-sizing:border-box;\n        font-family:verdana;\n        font-size:9pt;\n\n}\nhtml #main #mainBody #contentArea {\n        height:1%;\n}\n#topCorner {\n        width:100%;\n        height:214px;\n        position:absolute;\n        top:0px;\n        left:0px;\n        background: url(\'^FileUrl(style3/main_top_bg.jpg);\') repeat-x;\n        z-index:1;\n}\n#bottomCorner {\n        width:100%;\n        height:211px;\n        position:absolute;\n        bottom:59px;\n        right:0px;\n        background: url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;\n        z-index:1;\n}\n* html #bottomCorner {\n	bottom:58px;\n}\n\n#footer {\n        width:100%;\n        margin:0px;\n        background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;\n        height:57px;\n        border-top:solid #B53018 2px;\n        text-align:right;\n        position:relative;\n		z-index:0;\n}\n#footer #copyright {\n        color:#3b3b3b;\n        font-family:arial;\n        position:absolute;\n        top:20px;\n        left:30px;\n        font-size:8pt;\n}\n\n',0,'text/css',1178723414,3600);
CREATE TABLE `storageTranslation` (
  `guidValue` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `hexValue` varchar(32) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`guidValue`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `subscription` (
  `subscriptionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `name` varchar(128) default NULL,
  `price` float default '0',
  `description` mediumtext,
  `subscriptionGroup` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `duration` varchar(12) NOT NULL default 'Monthly',
  `executeOnSubscription` varchar(128) default NULL,
  `karma` int(4) default '0',
  `deleted` int(1) default '0',
  `useSalesTax` int(11) default '0',
  PRIMARY KEY  (`subscriptionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `subscriptionCode` (
  `batchId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `code` varchar(64) character set utf8 collate utf8_bin NOT NULL default '',
  `status` varchar(10) NOT NULL default 'Unused',
  `dateCreated` int(11) NOT NULL default '0',
  `dateUsed` int(11) NOT NULL default '0',
  `expires` int(11) NOT NULL default '0',
  `usedBy` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `subscriptionCodeBatch` (
  `batchId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `name` varchar(128) default NULL,
  `description` mediumtext NOT NULL,
  `subscriptionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  PRIMARY KEY  (`batchId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `subscriptionCodeSubscriptions` (
  `code` varchar(64) character set utf8 collate utf8_bin NOT NULL default '',
  `subscriptionId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  UNIQUE KEY `code` (`code`,`subscriptionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `template` (
  `template` mediumtext,
  `namespace` varchar(35) NOT NULL default 'Page',
  `isEditable` int(11) NOT NULL default '1',
  `showInForms` int(11) NOT NULL default '1',
  `assetId` varchar(22) character set utf8 collate utf8_bin NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `parser` varchar(255) NOT NULL default 'WebGUI::Asset::Template::HTMLTemplate',
  `headBlock` text,
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `namespace_showInForms` (`namespace`,`showInForms`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `template` VALUES ('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n	<tmpl_if linkUrl>\n	<tmpl_if linkTitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n	</tmpl_if>\n	<tmpl_loop attachment_loop>\n		<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var url>\"><img src=\"<tmpl_var icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var filename>\" /> <tmpl_var filename></a></p><br />\n	</tmpl_loop>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<p>\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td>\n	</tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000207',1147642410,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h1>\n   <tmpl_var title>\n</h1>\n\r\n\r\n<tmpl_if recover.message>\r\n   <tmpl_var recover.message>\r\n</tmpl_if>\r\n\r\n<tmpl_var recover.form.header>\r\n<table >\r\n<tmpl_var recover.form.hidden>\r\n<tr>\r\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var recover.form.email.label></td>\r\n   <td class=\"tableData\"><tmpl_var recover.form.email></td>\r\n</tr>\r\n<tr>\r\n   <td class=\"formDescription\" valign=\"top\"></td>\r\n   <td class=\"tableData\"><tmpl_var recover.form.submit></td>\r\n</tr>\r\n</table>\r\n<tmpl_var recover.form.footer>\r\n\r\n\r\n<div class=\"accountOptions\">\r\n   <ul>\n       <tmpl_if anonymousRegistration.isAllowed>\n	     <li><a href=\"<tmpl_var createAccount.url>\"><tmpl_var createAccount.label></a></li>\n	  </tmpl_if>\n         <li><a href=\"<tmpl_var login.url>\"><tmpl_var login.label></a></li>\n      \r\n   </ul>\r\n</div>','Auth/WebGUI/Recovery',1,1,'PBtmpl0000000000000014',1129049185,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_var message>','Commerce/CheckoutCanceled',1,1,'PBtmpl0000000000000015',1129049185,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var viewShoppingCart.url>\"><tmpl_var viewShoppingCart.label></a> &middot;\n<a href=\"<tmpl_var changePayment.url>\"><tmpl_var changePayment.label></a> &middot; \n<a href=\"<tmpl_var changeShipping.url>\"><tmpl_var changeShipping.label></a><br>\n<br>\n\n<tmpl_var title><br>\n<ul>\n<tmpl_loop errorLoop>\n<li><tmpl_var message></li>\n</tmpl_loop>\n</ul>\n\n<table> <tr align=\"left\">\n      <th style=\"border-bottom: 2px solid black\">Product</th>\n      <th style=\"border-bottom: 2px solid black\">Quantity</th>\n      <th style=\"border-bottom: 2px solid black\">Price</th>\n      <th style=\"border-bottom: 2px solid black\">Each</th>\n  </tr>\n\n  <tmpl_if normalItems>\n  </tmpl_if>\n\n  <tmpl_loop normalItemsLoop>\n  <tr>\n      <td align=\"left\"><tmpl_var name></td>\n      <td align=\"center\"><tmpl_var quantity></td>\n      <td align=\"right\"><tmpl_var totalPrice></td>\n  </tr>\n  </tmpl_loop>\n\n  <tmpl_loop recurringItemsLoop>\n  <tr>\n      <td align=\"left\"><tmpl_var name></td>\n      <td align=\"center\"><tmpl_var quantity></td>\n      <td align=\"right\"><tmpl_var totalPrice></td>\n      <td align=\"left\"><tmpl_var period></td>\n  </tr>\n</tmpl_loop>\n  <tr style=\"border-top: 1px solid black\">\n      <td style=\"border-top: 1px solid black\">&nbsp;</td>\n      <td align=\"right\" style=\"border-top: 1px solid black\"><b>Subtotal</b></td>\n      <td align=\"right\" style=\"border-top: 1px solid black\"><b><tmpl_var subtotal></b></td>\n  </tr>\n  <tr>\n      <td colspan=\"2\" align=\"right\">Shipping</td>\n      <td align=\"right\"><tmpl_var shippingCost></td>\n  <tr>\n      <td colspan=\"2\" align=\"right\" style=\"border-top: 1px solid black\"><b>Total</b></td>\n      <td align=\"right\" style=\"border-top: 1px solid black\"><b><tmpl_var total></b></td>\n\n</table>\n\n<br><br>\n\n<tmpl_var form>','Commerce/ConfirmCheckout',1,1,'PBtmpl0000000000000016',1129049185,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_var notify.subscription.message>\r\n\r\n<tmpl_var url>','Collaboration/Notification',1,1,'PBtmpl0000000000000027',1129049185,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/AdminToggle',1,1,'PBtmpl0000000000000036',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a class=\"myAccountLink\" href=\"<tmpl_var account.url>\"><tmpl_var account.text></a>','Macro/a_account',1,1,'PBtmpl0000000000000037',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/EditableToggle',1,1,'PBtmpl0000000000000038',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var group.url>\"><tmpl_var group.text></a>','Macro/GroupAdd',1,1,'PBtmpl0000000000000040',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var group.url>\"><tmpl_var group.text></a>','Macro/GroupDelete',1,1,'PBtmpl0000000000000041',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a class=\"homeLink\" href=\"<tmpl_var homeLink.url>\"><tmpl_var homeLink.text></a>','Macro/H_homeLink',1,1,'PBtmpl0000000000000042',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a class=\"loginToggleLink\" href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/LoginToggle',1,1,'PBtmpl0000000000000043',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a class=\"makePrintableLink\" href=\"<tmpl_var printable.url>\"><tmpl_var printable.text></a>','Macro/r_printable',1,1,'PBtmpl0000000000000045',1129049186,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if batchDescription>\r\nBatch: <tmpl_var batchDescription>\r\n</tmpl_if>\r\n\r\n<tmpl_var message><br>\r\n<tmpl_var codeForm>','Operation/RedeemSubscription',1,1,'PBtmpl0000000000000053',1129049187,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_loop field_loop><tmpl_unless field.isMailField><tmpl_var field.label>:	 <tmpl_var field.value>\n</tmpl_unless></tmpl_loop>','DataForm',1,1,'PBtmpl0000000000000085',1129049188,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var file.url>\"><tmpl_var file.name></a>','Macro/File',1,1,'PBtmpl0000000000000091',1129049189,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_var body.content>','style',0,0,'PBtmpl0000000000000132',1129049190,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if cartEmpty>\n<tmpl_var cartEmpty.message>\n<tmpl_else>\n\n<tmpl_var updateForm.header>\n<table>	\n	<tr align=\"left\">\n		<th></th>\n		<th style=\"border-bottom: 2px solid black\">Product</th>\n		<th style=\"border-bottom: 2px solid black\">Quantity</th>\n		<th style=\"border-bottom: 2px solid black\">Price</th>\n	</tr>\n\n	<tmpl_if normalItems>\n	</tmpl_if>\n\n	<tmpl_loop normalItemsLoop>\n	<tr>\n		<td><tmpl_var deleteIcon></td>\n		<td align=\"left\"><tmpl_var name></td>\n		<td align=\"center\"><tmpl_var quantity.form></td>\n		<td align=\"right\"><tmpl_var totalPrice></td>\n	</tr>\n	</tmpl_loop>\n\n	<tmpl_loop recurringItemsLoop>\n	<tr>\n		<td><tmpl_var deleteIcon></td>\n		<td align=\"left\"><tmpl_var name></td>\n		<td align=\"center\"><tmpl_var quantity.form></td>\n		<td align=\"right\"><tmpl_var totalPrice></td>\n	</tr>\n</tmpl_loop>\n	<tr style=\"border-top: 1px solid black\">\n		<td></td>\n		<td style=\"border-top: 1px solid black\">&nbsp;</td>\n		<td align=\"right\" style=\"border-top: 1px solid black\"><b>Total</b></td>\n		<td align=\"right\" colspan=\"3\" style=\"border-top: 1px solid black\"><b><tmpl_var total></b></td>\n	</tr>\n\n</table>\n\n<tmpl_var updateForm.button>\n<tmpl_var updateForm.footer>\n\n<tmpl_var checkoutForm.header>\n<tmpl_var checkoutForm.button>\n<tmpl_var checkoutForm.footer> \n\n</tmpl_if>','Commerce/ViewShoppingCart',1,1,'PBtmplVSC0000000000001',1129049191,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n	<div style=\"width: 100%; border: 1px groove black;\">\n		<div style=\"width: 100%; background-image: url(<tmpl_var session.config.extrasURL>/opaque.gif);\">\n			<div style=\"text-align: center; font-weight: bold;\"><a href=\"<tmpl_var originalURL>\"><tmpl_var shortcut.label></a></div>\n		</div>\n</tmpl_if>\n<tmpl_var shortcut.content>\n<tmpl_if session.var.adminOn>\n		<div style=\"width: 100%; background-image: url(<tmpl_var session.config.extrasURL>/opaque.gif);\">\n			<div style=\"text-align: center; font-weight: bold;\"><a href=\"<tmpl_var originalURL>\"><tmpl_var shortcut.label></a></div>\n		</div>\n	</div>\n</tmpl_if>\n','Shortcut',1,1,'PBtmpl0000000000000140',1129573244,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if showAdmin>\n<p><tmpl_var controls></p>\n</tmpl_if>\n\n^RawHeadTags(<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: auto;\n        max-width: 65%;\n}\n.endFloat {\n clear: both;\n}\n</style>);\n\n<tmpl_if displayTitle>\n  <h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 1 -->\n\n<!-- begin position 2 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n            <tmpl_var dragger.init>\n</tmpl_if>\n\n','Layout',1,1,'PBtmpl0000000000000125',1129573245,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description><p />\n</tmpl_if>\n\n<table class=\"tableMenu\" width=\"100%\">\n	<tbody>\n	<tr>\n	<td align=\"center\" width=\"15%\"><h1><tmpl_var int.search></h1></td>\n	<td valign=\"top\" align=\"middle\">\n	<table>\n	<form method=\"post\" action=\"<tmpl_var actionURL>\">\n	<tbody>\n	<tr>\n	<td colspan=\"2\" class=\"tableData\">\n		<input maxLength=\"255\" size=\"30\" value=\'<tmpl_var query>\' name=\"query\">\n	</td>\n	<td class=\"tableData\"><tmpl_var submit></td>\n	</tr>\n	<tr>\n	<td class=\"tableData\" valign=\"top\"></td>\n	<td class=\"tableData\" valign=\"top\">\n	   <tmpl_loop contentTypesSimple>\n	     <tmpl_unless __FIRST__>\n	     	<input type=\"checkbox\" name=\"contentTypes\" value=\"<tmpl_var value>\"\n		<tmpl_if type_content>\n		   <tmpl_if query>\n			<tmpl_if selected>checked=\"1\"</tmpl_if>\n		   <tmpl_else>\n			checked=\"1\"\n		   </tmpl_if>\n		<tmpl_else>\n		   <tmpl_if selected>checked=\"1\"</tmpl_if>\n		</tmpl_if>\n		><tmpl_var name>\n		<br />\n	     </tmpl_unless>\n	   </tmpl_loop>\n	</td>\n        <td></td>\n      </tbody>\n      </form>\n      </table>\n      </td>\n    </tr>\n  </tbody>\n</table>\n\n<p />\n<tmpl_if numberOfResults>\n	<p>Results <tmpl_var startNr> - <tmpl_var endNr> of about <tmpl_var numberOfResults>\n	containing <b>\"<tmpl_var queryHighlighted>\"</b>. Search took <b><tmpl_var duration></b> seconds.</p>\n	<ol style=\"Margin-Top: 0px; Margin-Bottom: 0px;\" start=\"<tmpl_var startNr>\">\n	<tmpl_loop resultsLoop>\n		<li>\n			<a href=\"<tmpl_var location>\"><tmpl_if header><tmpl_var header><tmpl_else>No Title</tmpl_if></a>\n			<div>\n			<tmpl_if \"body\">\n				<span class=\"preview\"><tmpl_var \"body\"></span><br />\n			</tmpl_if>\n			<span style=\"color:#666666;\">Location: <tmpl_var crumbTrail></span>\n			<br />\n			<br />\n			</div>\n		</li>\n	</tmpl_loop>\n	</ol>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo20> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','IndexedSearch',1,1,'PBtmpl0000000000000034',1129573247,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<script type=\"text/javascript\">\n//<![CDATA[\n	var slider = new createSlidePanelBar(\"WebGUIAdminBar\");\n	var panel;\n	<tmpl_loop adminbar_loop>\n		panel = new createPanel(\"<tmpl_var name>\", \"<tmpl_var label>\");\n		<tmpl_loop items>\n			panel.addLink(\"<tmpl_var icon>\", \"<tmpl_var title escape=JS>\", \"<tmpl_var url escape=JS>\");\n		</tmpl_loop>\n		slider.addPanel(panel);\n	</tmpl_loop>\n	slider.draw();\n\n//]]>\n</script>\n','Macro/AdminBar',1,1,'PBtmpl0000000000000090',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<script src=\"^Extras(slidePanel/slidePanel.js);\" type=\"text/javascript\"></script>\n<link href=\"^Extras(slidePanel/slidePanel.css);\" rel=\"stylesheet\" type=\"text/css\" />\n'),('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rss version=\"2.0\">\n<channel>\n<title><tmpl_var title></title>\n<link><tmpl_var link></link>\n<description><tmpl_var description></description>\n<tmpl_loop item_loop>\n<item>\n<title><tmpl_var title></title>\n<link><tmpl_var link></link>\n<description><tmpl_var description></description>\n<guid isPermaLink=\"true\"><tmpl_var guid></guid>\n<pubDate><tmpl_var pubDate></pubDate>\n</item>\n</tmpl_loop>\n</channel>\n</rss>\n','Collaboration/RSS',1,1,'PBtmpl0000000000000142',1133743238,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\n<head>\n<style>\n	.qmmt_tab\n	{\n	    background-color: #eeeeee;\n	    border-top-color: #cccccc;\n	    border-right: 1px solid #cccccc;	    \n	}\n	.qmmt_tabactive\n	{\n	    border-right: 1px solid #cccccc;	    \n	}\n</style>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"<tmpl_var extrasFolder>/tools.css\" />\n</head>\n<body bgcolor=\"#f1f1f1\" text=\"#000000\" link=\"#0000cc\" vlink=\"#0000cc\" alink=\"#FF0000\">\n<a name=\"<tmpl_var assetId>\"></a> \n<script type=\"text/javascript\">\n   var symbol = \"<tmpl_var stocks.symbol>\";\n   function isIE() {\n      var ua = navigator.userAgent.toLowerCase();\n	  var isIE = ( (ua.indexOf(\"msie\") != -1) && (ua.indexOf(\"opera\") == -1) && (ua.indexOf(\"webtv\") == -1) );\n	  return (isIE);      \n   }\n   \n   function enableTab(obj, scale){    \n      for (i=0; i < 7; i++)    {        \n	     document.getElementById(\'qm_ch_tab\' + i + \'_9350\').className = (i == obj) ? \'qmmt_tabactive\' : \'qmmt_tab\';\n		 document.getElementById(\'qm_ch_tab\' + i + \'_9350\').style.cursor = (i == obj) ? \'default\' : (isIE()) ? \'hand\': \'pointer\';\n		 document.getElementById(\'qm_ch_tab\' + i + \'_9350\').style.borderTop = (i == obj) ? \'0px\' : \'1px solid\';    \n	  }\n	  document.getElementById(\'chartimg\').src = \"http://ichart.finance.yahoo.com/z?s=\" + symbol + \"&t=\" + scale + \"&q=l&l=off&z=s&p=s\";\n   }\n</script>\n\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"qmmt_main\" width=\"650\"> \n  <tr>  \n     <td style=\"text-align: center;\">  \n	    <div class=\"qmmt_header_bar\" style=\"padding-bottom: 1px; border-bottom-width: 1px; \">  \n		   <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">   \n		      <tr>    \n			     <td><span class=\"qmmt_header_text\" style=\"padding-left:5px;\"><tmpl_var stocks.name> (<tmpl_var stocks.symbol>)</span></td>    \n				 <td align=\"right\" style=\"padding-right:3px;\">\n				    <span class=\"qmmt_header_text\" style=\"text-align: right; font-weight:normal;\">\n					<div nowrap id=\"qm_textChange_5920\">1:23 PM EDT</div>\n					<script type=\"text/javascript\">\n					   function qm_UpdateText_5920(phase){    \n					      switch (phase)    {        \n						     case 1: \n							    document.getElementById(\'qm_textChange_5920\').innerHTML = \'<span class=\"qmmt_header_text\" style=\"font-weight:normal;\">Delayed</span>\'; \n                                setTimeout(\"qm_UpdateText_5920(2)\", 5000); \n								break;        \n						     case 2: \n							    document.getElementById(\'qm_textChange_5920\').innerHTML = \'<span class=\"qmmt_header_text\" style=\"font-weight:normal;\">1:23 PM EDT</span>\'; \n                                setTimeout(\"qm_UpdateText_5920(3)\", 5000); \n								break;        \n							 case 3: \n							    document.getElementById(\'qm_textChange_5920\').innerHTML = \'<a href=\"http://finance.yahoo.com/\" target=\"_top\" style=\"text-decoration:none;\"><span class=\"qmmt_header_text\" style=\"font-weight:normal;\">Yahoo Finance</span></a>\'; \n                                 setTimeout(\"qm_UpdateText_5920(1)\", 5000); \n								 break;            \n						  }        \n					   }\n					   qm_UpdateText_5920(2);\n				    </script>    \n					</span>\n				 </td>\n			  </tr>  \n		   </table>\n		</div>\n     </td>\n  </tr> \n  <tr>  \n     <td style=\"text-align: center;\">  \n	    <table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"100%\">   \n		   <tr>\n		      <td style=\"text-align: center;\" width=\"40%\">    \n			     <img align=\"center\" id=\"chartimg\" width=\"350\" height=\"205\" src=\"http://ichart.finance.yahoo.com/z?s=<tmpl_var stocks.symbol>&t=1d&q=l&l=off&z=s&p=s\">    \n                     <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">  \n					    <tr>\n						   <td width=\"14%\" id=\"qm_ch_tab0_9350\" class=\"qmmt_tabactive\" onclick=\"enableTab(\'0\', \'1d\')\" style=\"cursor: default; border-left: 0px; border-bottom: 0px; border-top: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">Today</td>\n                           <td width=\"14%\" id=\"qm_ch_tab1_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'1\', \'5d\')\" style=\"cursor: default; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">5d</td>\n                           <td width=\"14%\" id=\"qm_ch_tab2_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'2\', \'1m\')\" style=\"cursor: default; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">1m</td>\n                           <td width=\"14%\" id=\"qm_ch_tab3_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'3\', \'3m\')\" style=\"cursor: default; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">3m</td>\n                           <td width=\"14%\" id=\"qm_ch_tab4_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'4\', \'1y\')\" style=\"cursor: default; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">1y</td>\n                           <td width=\"14%\" id=\"qm_ch_tab5_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'5\', \'5y\')\" style=\"cursor: default; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">5y</td>\n						   <td width=\"14%\" id=\"qm_ch_tab6_9350\" class=\"qmmt_tab\" onclick=\"enableTab(\'6\', \'my\')\" style=\"cursor: default; border-right: 0px; border-bottom: 0px; padding-top:1px; padding-bottom:1px; font-weight: normal;\">20y</td>\n                        </tr>\n					 </table>    \n			      </td>\n				  <td align=\"center\" width=\"30%\">\n				     <table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"95%\">\n					    <tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\">Last Price</td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.last></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Market Cap </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.cap></td>\n						</tr>           \n						<tr class=\"qmmt_main\"><td class=\"qmmt_text\"> Change </td>\n						   <td class=\"qmmt_text<tmpl_if stocks.net.isUp>_up<tmpl_else><tmpl_if stocks.net.isDown>_down</tmpl_if></tmpl_if>\" style=\"text-align: right; font-weight: bold;\">\n						      <img align=\'center\' src=\'<tmpl_var extrasFolder>/<tmpl_var stocks.net.icon>\'> <tmpl_var stocks.net>\n						   </td>\n                        </tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Open </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.open></td>\n						</tr>\n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> Day High </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.high></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\">Bid</td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.bid></td>\n						</tr>    \n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> 52 Wk High </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.year_high></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> E.P.S. </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.eps></td>\n						</tr>    \n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> Ex-Div Date </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.ex_div></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Yield </td>\n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.yield></td>\n						</tr>\n				     </table>\n				  </td>\n				  <td align=\"center\" width=\"30%\">\n				     <table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" width=\"95%\">\n					    <tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> Last Trade </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var lastUpdate.us></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Volume </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.volume.millions> m</td>\n						</tr>\n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\">% Change </td>\n						   <td class=\"qmmt_text<tmpl_if stocks.net.isUp>_up<tmpl_else><tmpl_if stocks.net.isDown>_down</tmpl_if></tmpl_if>\"  style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.p_change>%</td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Prev Close </td>\n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.close></td>\n						</tr>\n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> Day Low </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.low></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Ask </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.ask></td>\n						</tr>\n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> 52 Wk Low </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.year_low></td>\n						</tr>\n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> P/E Ratio </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.pe></td>\n						</tr>    \n						<tr class=\"qmmt_main\">\n						   <td class=\"qmmt_text\"> Dividend </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.div></td>\n						</tr>     \n						<tr class=\"qmmt_cycle\">\n						   <td class=\"qmmt_text\"> Exchange </td> \n						   <td class=\"qmmt_text\" style=\"text-align: right; font-weight: bold;\"><tmpl_var stocks.exchange></td>\n						</tr>\n				     </table>\n				  </td>\n			   </tr>\n			</table>\n	     </td>\n	  </tr>\n   </table>\n   \n<div align=\"center\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"650\">\n<tr>\n   <td>\n      <div class=\"qmmt_text\" align=\"right\"><br><a href=\"javascript:window.close()\" style=\"color:#0000cc\">CLOSE</a></div>\n   </td>\n</tr>\n</table>\n</div>\n</body>\n','StockData/Display',1,1,'StockDataTMPL000000002',1133743239,'WebGUI::Asset::Template::HTMLTemplate',NULL),('#assetId=ZipArchiveTMPL00000001\n#title=Default Zip Archive Template\n#namespace=ZipArchiveAsset\n\n<tmpl_if session.var.adminOn>\n   <tmpl_if controls>\n      <p><tmpl_var controls></p>\n   </tmpl_if>\n</tmpl_if>\n\n<tmpl_if error>\n<ul>\n  <li><tmpl_var error></li>\n</ul>\n</tmpl_if>\n\n<tmpl_if fileUrl>\n   <a href=\"<tmpl_var fileUrl>\"><tmpl_var title></a>\n<tmpl_else>\n  <tmpl_if pageError>\n      Error:  No initial page specified\n  <tmpl_else>\n      Error:  No file specified\n  </tmpl_if>\n</tmpl_if>	\n','ZipArchiveAsset',1,1,'ZipArchiveTMPL00000001',1133743240,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<p><tmpl_var body></p>\n\n<tmpl_if fields>\n<dl>\n	<tmpl_loop fields>\n   		<dt><tmpl_var title></dt>\n	        <dd><tmpl_var description>\n			<tmpl_if uiLevel> <br /><i><tmpl_var uiLevelLabel>:</i><tmpl_var uiLevel><br /> </tmpl_if>\n		</dd>\n        </tmpl_loop>\n</dl>\n</tmpl_if>\n\n<tmpl_if variable_loop1>\n	<dl> <tmpl_loop variable_loop1>\n		<dt><tmpl_var title></dt>\n		<dd><tmpl_var description>\n		<tmpl_if variable_loop2>\n			<dl> <tmpl_loop variable_loop2>\n				<dt><tmpl_var title></dt>\n				<dd><tmpl_var description>\n				<tmpl_if variable_loop3>\n					<dl> <tmpl_loop variable_loop3>\n						<dt><tmpl_var title></dt>\n						<dd><tmpl_var description>\n						<tmpl_if variable_loop4>\n							<dl> <tmpl_loop variable_loop4>\n								<dt><tmpl_var title></dt>\n								<dd><tmpl_var description></dd>\n							</tmpl_loop> </dl>\n						</tmpl_if></dd>\n					</tmpl_loop> </dl>\n				</tmpl_if></dd>\n			</tmpl_loop> </dl>\n		</tmpl_if></dd>\n	</tmpl_loop> </dl>\n</tmpl_if>\n\n','AdminConsole',1,1,'PBtmplHelp000000000001',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ndd {\n	margin-bottom: 15px;\n}\n\ndt {\n	font-weight: bold;	\n}\n</style>\n\n'),('<h1><tmpl_var title></h1>\n\n<table width=\"100%\" cellspacing=\"1\" cellpadding=\"2\" border=\"0\">\n<tr>\n   <td class=\"tableHeader\">\n      <tmpl_var subject.label>\n   </td>\n   <td class=\"tableHeader\">\n      <tmpl_var status.label>\n   </td>\n   <td class=\"tableHeader\">\n      <tmpl_var dateStamp.label>\n   </td>\n</tr>\n<tmpl_if noresults>\n   <tr>\n       <td class=\"tableData\">\n          <tmpl_var noresults>\n       </td>\n       <td class=\"tableData\">\n          &nbsp;\n       </td>\n       <td class=\"tableData\">\n          &nbsp;\n       </td>\n   </tr>\n<tmpl_else>\n   <tmpl_loop messages>\n      <tr>\n         <td class=\"tableData\">\n            <tmpl_var subject>\n         </td>\n         <td class=\"tableData\">\n            <tmpl_var status>\n         </td>\n         <td class=\"tableData\">\n            <tmpl_var dateStamp>\n         </td>\n     </tr>\n  </tmpl_loop>\n</tmpl_if>\n</table>\n   <ul class=\"accountOptions\">\n      <tmpl_loop accountOptions>\n         <li><tmpl_var options.display>\n      </tmpl_loop>\n   </ul>\n','Inbox',1,1,'PBtmpl0000000000000206',1147642410,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h1><tmpl_var title></h1>\n<b><tmpl_var subject></b><br />\n<tmpl_var dateStamp><br />\n<tmpl_var status><br /><br />\n<p> <tmpl_var message></p>\n\n<ul class=\"accountOptions\">\n	<tmpl_loop accountOptions><li><tmpl_var options.display></li>\n        </tmpl_loop>\n</ul>\n\n','Inbox/Message',1,1,'PBtmpl0000000000000205',1147642410,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var subject.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var user.label></a></td>\n<tmpl_if karmaIsEnabled>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.karmaRank.url>\"><tmpl_var karmaRank.label></a></td>\n</tmpl_if karmaIsEnabled>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.rating.url>\"><tmpl_var rating.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<tmpl_if displayLastReply>\n		<td class=\"forumHead\"><a href=\"<tmpl_var sortby.lastreply.url>\"><tmpl_var lastReply.label></a></td>\n	</tmpl_if>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n	<tmpl_if user.isVisitor>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n	<tmpl_else>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n	</tmpl_if>\n<tmpl_if karmaIsEnabled>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var karmaRank></td>\n</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var rating></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n	<tmpl_if displayLastReply>\n		<td  class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"font-size: 11px;\">\n			<a href=\"<tmpl_var lastReply.url>\"><tmpl_var lastReply.title></a>\n			by\n			<tmpl_if lastReply.user.isVisitor>\n				<tmpl_var lastReply.username>\n			<tmpl_else>\n				<a href=\"<tmpl_var lastReply.userProfile.url>\"><tmpl_var lastReply.username></a>\n			</tmpl_if>\n			on <tmpl_var lastReply.dateSubmitted.human> @ <tmpl_var lastReply.timeSubmitted.human>\n		</td>\n	</tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n','Collaboration',1,1,'PBtmpl0000000000000208',1147642410,'WebGUI::Asset::Template::HTMLTemplate','\n<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<div class=\"defaultSubmissionDetails\">\n	<b><tmpl_var user.label>:</b> \n		<tmpl_if user.isVisitor>\n			<tmpl_var username>\n		<tmpl_else>\n			<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n		</tmpl_if>\n		<br />\n	<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n	<b><tmpl_var severity.label>:</b> <tmpl_var userDefined1><br />\n	<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n	<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n		<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n		</tmpl_unless>\n		<br />\n	<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var unarchive.url>\"><tmpl_var open.label></a> <tmpl_else> <tmpl_var open.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var archive.url>\"><tmpl_var close.label></a></tmpl_if> ]<br />\n	<tmpl_else>	\n		<tmpl_if user.isPoster>\n			<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> <tmpl_else> <tmpl_var open.label></tmpl_if><br />\n		</tmpl_if>	\n	</tmpl_if>	\n<tmpl_if karmaIsEnabled>\n	<b><tmpl_var karmaRank.label>:</b> <tmpl_var karmaRank><br />\n<b><tmpl_var transferkarma.label>:</b>\n<tmpl_var transfer.karma.form>\n</tmpl_if>	\n</div>\n\n<div class=\"collaborationThreadContent\">\n	<tmpl_var content>\n</div>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n\n\n<tmpl_if repliesAllowed>\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n\n														</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n																<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n																</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>\n	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a>				\n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000209',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n\n.postControls a\n{\n	color:white;\n}\n\n.collaborationThreadContent\n{\n	height:100px;\n	font-family:arial;\n	font-size:9pt;\n}\n\n#mainText > .collaborationThreadContent\n{\n	height:auto;\n	min-height:100px;\n}\n\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if preview.title>\n	<p><b><tmpl_var preview.title></b></p>\n</tmpl_if>\n\n<tmpl_if preview.content>\n	<p><tmpl_var preview.content></p>\n</tmpl_if>\n\n<h2><tmpl_var message.header.label></h2>\n\n<tmpl_var form.header>\n<table class=\"defaultPostForm\">\n	<tmpl_if isNewPost>\n		<tmpl_if user.isVisitor>\n			<tr>\n				<td><tmpl_var visitorName.label></td>\n				<td><tmpl_var visitorName.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td><tmpl_var subject.label></td>\n		<td><tmpl_var title.form></td>\n	</tr>\n	<tr>\n		<td><tmpl_var severity.label></td>\n		<td><select id=\"myCustomField1\" name=\"userDefined1\">\n<option value=\"<tmpl_var cosmetic.label>\"><tmpl_var cosmetic.label></option>\n<option value=\"<tmpl_var minor.label>\"><tmpl_var minor.label></option>\n<option value=\"<tmpl_var critical.label>\"><tmpl_var critical.label></option>\n<option value=\"<tmpl_var fatal.label>\"><tmpl_var fatal.label></option>\n</select>\n<script type=\"text/javascript\">\n  var value = \'<tmpl_var name=\"userDefined1\" escape=\"JS\">\';\n  var field = document.getElementById(\"myCustomField1\");\n  for (var i = 0; i < field.options.length; i++) {\n    if (field.options[i].value == value)  {\n       field.selectedIndex = i;\n    }  \n  }\n</script>\n</td>\n	</tr>\n	<tr>\n		<td><tmpl_var description.label></td>\n		<td><tmpl_var content.form></td>\n	</tr>\n	<tmpl_if attachment.form>\n		<tr>\n			<td><tmpl_var attachment.label></td>\n			<td><tmpl_var attachment.form></td>\n		</tr>\n	</tmpl_if>\n<tmpl_if user.isModerator><tmpl_if karmaIsEnabled><tmpl_if isThread>\n				<tr>\n					<td><tmpl_var karmaScale.label></td>\n					<td><tmpl_var karmaScale.form></td>\n				</tr>\n</tmpl_if></tmpl_if></tmpl_if>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<p><b><tmpl_var reply.title></b></p>\n	<tmpl_var reply.content>\n</tmpl_if>\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000210',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n\n'),('<a name=\"id<tmpl_var assetId>\"></a>\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<div class=\"SQLForm-contentBox\">\n<tmpl_if displayTitle>\n	<h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_unless isNew>\n	<a href=\"<tmpl_var viewHistory.url>\"><tmpl_var viewHistory.label></a><br /><br />\n</tmpl_unless>\n\n<tmpl_if errorOccurred>\n	<h1>Some errors occurred</h1>\n	<ul>\n	<tmpl_loop errorLoop>\n		<li><tmpl_var error.message></li>\n	</tmpl_loop>\n	</ul>\n</tmpl_if>\n\n<tmpl_var managementLinks>\n\n<tmpl_var completeForm>\n</div>\n','SQLForm/Edit',1,1,'SQLFormEditTmpl0000001',1147642410,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\"></a>\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<div class=\"SQLForm-contentBox\">\n\n<tmpl_if displayTitle>\n	<h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_var managementLinks>\n\n<h2>Search records</h2>\n<a href=\"<tmpl_var superSearch.url>\"><tmpl_var superSearch.label></a><br>\n\n<tmpl_if errorOccurred>\nSome error(s) occurred:\n<ul>\n	<tmpl_loop errorLoop>\n	<li><tmpl_var error.message></li>\n	</tmpl_loop>\n</ul>\n</tmpl_if>\n\n<tmpl_var searchForm>\n\n<tmpl_if showFieldsDefined>\n<tmpl_var searchResults.header>\n<tmpl_var searchResults.actionButtons>\n<table border=\"0\">\n	<tr>\n		<th></th>\n		<tmpl_if showMetaData>\n		<th>Last update</th>\n		<th>Last update by</th>\n		</tmpl_if>\n	<tmpl_loop headerLoop>\n		<th <tmpl_if\nheader.sort.onThis>color=\"red\"</tmpl_if>>\n			<a href=\"<tmpl_var header.sort.url>\">\n			<tmpl_var header.title> \n			<tmpl_if header.sort.onThis><tmpl_if header.sort.ascending>(asc)<tmpl_else>(desc)</tmpl_if></tmpl_if></a></th>\n	</tmpl_loop>\n	</tr>\n	<tmpl_loop searchResults.recordLoop>\n	<tr>\n		<td><tmpl_var record.controls></td>\n		<tmpl_if showMetaData>\n		<td><tmpl_var record.updateDate></td>\n		<td><tmpl_var record.updatedBy></td>\n		</tmpl_if>\n		<tmpl_loop record.valueLoop>\n		<td>\n		<tmpl_if record.value.isFile>\n			<tmpl_if record.value>\n				<a href=\"<tmpl_var record.value.downloadUrl>\">\n				<tmpl_if record.value.isImage>\n					<img width=\"100\" src=\"<tmpl_var record.value.downloadUrl>\">\n				<tmpl_else>\n					Click here for file\n				</tmpl_if>\n				</a>\n			</tmpl_if>\n		<tmpl_else>\n			<tmpl_var record.value>\n		</tmpl_if>\n		</td>\n		</tmpl_loop>\n	</tr>\n	</tmpl_loop>\n</table>\n<tmpl_var searchResults.actionButtons>\n<tmpl_var searchResults.footer>\n<tmpl_else>\nNo fields are defined to be shown in the search results.\n</tmpl_if>\n\n</div>\n','SQLForm/Search',1,1,'SQLFormSearchTmpl00001',1147642410,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n<p><tmpl_var controls></p>\n</tmpl_if>\n\n\n<tmpl_if displayTitle>\n  <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div>\n<!-- end position 1 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<!-- begin position 2 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<!-- begin position 3 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position3\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position3_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 3 -->\n\n<!-- begin position 4 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position4\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position4_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 4 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n            <tmpl_var dragger.init>\n</tmpl_if>\n\n','Layout',1,1,'PBtmpl0000000000000109',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: 33%;\n}\n.thirdColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n'),('\n\n<div id=\"application_title\">\n	<tmpl_var application.title>\n</div>\n<div id=\"application_workarea\">\n	<tmpl_var application.workArea>\n</div>\n<div id=\"console_workarea\">\n	<div class=\"adminConsoleSpacer\">\n		&#160;\n	</div>\n	<tmpl_loop application_loop>\n		<tmpl_if canUse>\n			<div class=\"adminConsoleApplication\">\n				<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var icon>\" style=\"border-style:none;\" title=\"<tmpl_var title>\" alt=\"<tmpl_var title>\" /></a><br />\n				<a href=\"<tmpl_var url>\"><tmpl_var title></a>\n			</div>\n		</tmpl_if>\n	</tmpl_loop>\n	<div class=\"adminConsoleSpacer\">\n		&#160;\n	</div>\n</div>\n<div class=\"adminConsoleMenu\">\n	<div id=\"adminConsoleMainMenu\" class=\"adminConsoleMainMenu\">\n		<div id=\"console_toggle_on\">\n			<a href=\"#\" onclick=\"toggleAdminConsole()\"><tmpl_var toggle.on.label></a><br />\n		</div>\n		<div id=\"console_toggle_off\">\n			<a href=\"#\" onclick=\"toggleAdminConsole()\"><tmpl_var toggle.off.label></a><br />\n		</div>\n	</div>\n	<div id=\"adminConsoleApplicationSubmenu\" class=\"adminConsoleApplicationSubmenu\">\n		<tmpl_loop submenu_loop>\n			<a href=\"<tmpl_var url>\" <tmpl_var extras>><tmpl_var label></a><br />\n		</tmpl_loop>\n	</div>\n	<div id=\"adminConsoleUtilityMenu\" class=\"adminConsoleUtilityMenu\">\n		<a href=\"<tmpl_var backtosite.url>\"><tmpl_var backtosite.label></a><br />\n		^AdminToggle;<br />\n		^LoginToggle;<br />\n	</div>\n</div>\n<div id=\"console_title\">\n	<tmpl_var console.title>\n</div>\n<div id=\"application_help\">\n	<tmpl_if help.url>\n		<a href=\"<tmpl_var help.url>\"><img src=\"^Extras(adminConsole/small/help.gif);\" alt=\"?\" style=\"border-style:none;\" /></a>\n	</tmpl_if>\n</div>\n<div id=\"application_icon\">\n	<img src=\"<tmpl_var application.icon>\" style=\"border-style:none;\" title=\"<tmpl_var application.title>\" alt=\"<tmpl_var application.title>\" />\n</div>\n<div class=\"adminConsoleTitleIconMedalian\">\n<img src=\"^Extras(adminConsole/medalian.gif);\" style=\"border-style:none;\" alt=\"*\" />\n</div>\n<div id=\"console_icon\">\n	<img src=\"<tmpl_var console.icon>\" style=\"border-style:none;\" title=\"<tmpl_var console.title>\" alt=\"<tmpl_var console.title>\" />\n</div>\n<script type=\"text/javascript\" defer=\"defer\">\n	initAdminConsole(<tmpl_if application.title>true<tmpl_else>false</tmpl_if>,<tmpl_if submenu_loop>true<tmpl_else>false</tmpl_if>);\n</script>\n\n','AdminConsole',1,1,'PBtmpl0000000000000001',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if image1>\n	<img src=\"<tmpl_var image1>\" alt=\"<tmpl_var image1>\" class=\"noBorder\" />\n	<br />\n</tmpl_if>\n\n<table width=\"100%\" cellpadding=\"3\" cellspacing=\"3\" border=\"0\" class=\"benefitsShowcase\">\n<tr>\n	<td class=\"content\" valign=\"top\">\n		<tmpl_if description>\n			<tmpl_var description>\n			<p />\n		</tmpl_if>\n		<b>Benefits</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addBenefit.url>\"><tmpl_var addBenefit.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop benefit_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var benefit.controls></tmpl_if><tmpl_var benefit.benefit><br />\n		</tmpl_loop>\n	</td>\n	<td valign=\"top\" width=\"34%\" class=\"benefitsShowcase2\">\n		<tmpl_if thumbnail2>\n			<a href=\"<tmpl_var image2>\"><img src=\"<tmpl_var thumbnail2>\" alt=\"<tmpl_var thumbnail2>\" class=\"noBorder\" /></a>\n			<p />\n		</tmpl_if>\n		<b>Specifications</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addSpecification.url>\"><tmpl_var addSpecification.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop specification_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var specification.controls></tmpl_if><b><tmpl_var specification.label>:</b> <tmpl_var specification.specification> <tmpl_var specification.units><br />\n		</tmpl_loop>\n		<b>Options</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addaccessory.url>\"><tmpl_var addaccessory.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop accessory_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var accessory.controls></tmpl_if><a href=\"<tmpl_var accessory.url>\"><tmpl_var accessory.title></a><br />\n		</tmpl_loop>\n		<b>Other Products</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addRelatedProduct.url>\"><tmpl_var addRelatedProduct.label></a>\n			<p />\n\n\n		</tmpl_if>\n		<tmpl_loop relatedproduct_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var RelatedProduct.controls></tmpl_if><a href=\"<tmpl_var relatedproduct.url>\"><tmpl_var relatedproduct.title></a><br />\n		</tmpl_loop>\n	</td>\n</tr>\n</table>\n\n\n','Product',1,1,'PBtmpl0000000000000095',1147642410,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.productOptions {\n	font-family: arial;\n	font-size: 11px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.noBorder {\n	border:none;\n}\n.benefitsShowcase {\n	border:solid gray 1px;\n}\n.benefitsShowcase td {\n	font-family:arial;\n	font-size:9pt;\n}\n.benefitsShowcase2 {\n	border:solid gray 1px;\n	width:34%;\n	font-size:8pt;\n	font-family:arial;\n}\n.benefitsShowcase a {\n	color:#29587E;\n}\n.benefitsShowcase .content {\n	font-size:9pt;\n	width:66%;\n}\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var addevent.url>\"><tmpl_var addevent.label></a>\n	<p />\n</tmpl_if>\n\n<tmpl_loop month_loop>\n	<table border=\"0\" class=\"calendarSmall\">\n	<tr><td colspan=7 class=\"tableHeader\"><tmpl_var month> <tmpl_var year></td></tr>\n	<tr>\n	<tmpl_if session.user.firstDayOfWeek>\n		<th class=\"tableData\"><tmpl_var monday.label.short></th>\n		<th class=\"tableData\"><tmpl_var tuesday.label.short></th>\n		<th class=\"tableData\"><tmpl_var wednesday.label.short></th>\n		<th class=\"tableData\"><tmpl_var thursday.label.short></th>\n		<th class=\"tableData\"><tmpl_var friday.label.short></th>\n		<th class=\"tableData\"><tmpl_var saturday.label.short></th>\n		<th class=\"tableData\"><tmpl_var sunday.label.short></th>\n	<tmpl_else>\n		<th class=\"tableData\"><tmpl_var sunday.label.short></th>\n		<th class=\"tableData\"><tmpl_var monday.label.short></th>\n		<th class=\"tableData\"><tmpl_var tuesday.label.short></th>\n		<th class=\"tableData\"><tmpl_var wednesday.label.short></th>\n		<th class=\"tableData\"><tmpl_var thursday.label.short></th>\n		<th class=\"tableData\"><tmpl_var friday.label.short></th>\n		<th class=\"tableData\"><tmpl_var saturday.label.short></th>\n	</tmpl_if>\n	</tr><tr>\n	<tmpl_loop prepad_loop>\n		<td>&nbsp;</td>\n	</tmpl_loop>\n 	<tmpl_loop day_loop>\n		<tmpl_if isStartOfWeek>\n			<tr>\n		</tmpl_if>\n		<td class=\"table<tmpl_if isToday>Today<tmpl_else>Data</tmpl_if>\" valign=\"top\" align=\"left\"><p><b>\n				<tmpl_if hasEvents>\n					<a href=\"<tmpl_var url>\"><tmpl_var day></a>\n				<tmpl_else>\n					<tmpl_var day>\n				</tmpl_if>\n		</b></p></td>\n		<tmpl_if isEndOfWeek>\n			</tr>\n		</tmpl_if>\n	</tmpl_loop>\n	<tmpl_loop postpad_loop>\n		<td>&nbsp;</td>\n	</tmpl_loop>\n	</tr>\n	</table>\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo20> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','EventsCalendar',1,1,'PBtmpl0000000000000105',1147642411,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:330px;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n\n.pagination a\n{\n	color:white;\n}\n\n.fontSettings\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\nh2\n{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n\n.calendarSmall\n{\n	width:330px;\n}\n\n.calendarSmall .tableHeader\n{\n	text-align:center;\n	font-size:13pt;\n	letter-spacing:2px;\n	background-color:#DADADA;\n}\n\n.calendarSmall .tableData\n{\n	width:14%;\n}\n\n.calendarSmall .tableToday\n{\n	font-size:9pt;\n	font-family:arial;\n	background-color:#DADADA;\n}	\n\n.calendarSmall .tableToday a\n{\n	color:#29587E;\n}\n\n.calendarSmall td\n{\n	border:solid silver 1px;\n}\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	<div align=\"center\"><img src=\"<tmpl_var image.url>\" alt=\"<tmpl_var image.url>\" border=\"0\" /></div>\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if linkurl>\n	<tmpl_if linktitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n</tmpl_if>\n	<tmpl_if attachment.name><p><p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /> <tmpl_var attachment.name></a></p></p></tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr>\n	<td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td>\n	</tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000084',1147642411,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n\n<br />\n\n<tmpl_loop post_loop>\n	<div class=\"ad\">\n		<div style=\"text-align: center;\">\n			<b><a href=\"<tmpl_var url>\"><tmpl_var title></a></b><br />\n			<tmpl_if user.isPoster>(<tmpl_var status>)</tmpl_if>\n			<tmpl_if thumbnail>\n				<div style=\"margin: 3px;\">\n					<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" alt=\"<tmpl_var thumbnail>\" border=\"0\" /></a>\n				</div>\n			</tmpl_if>\n		</div>\n		<tmpl_var synopsis>\n	</div>\n</tmpl_loop>\n\n<div style=\"clear: both;\"></div>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000128',1147642411,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.ad {\n	border: 1px dotted #aaaaaa;\n	padding: 10px;\n	margin: 0px;\n	float: left;\n	width: 140px;\n	font-size: 12px;\n	height: 175px;\n	overflow: hidden;\n}\n</style>\n\n'),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n\n<script type=\"text/javascript\">\n/*****************************************************************************\nCopyright (c) 2001 Thomas Brattli (webmaster@dhtmlcentral.com)\n\nDHTML coolMenus - Get it at coolmenus.dhtmlcentral.com\nVersion 4.0_beta\nThis script can be used freely as long as all copyright messages are\nintact.\n\nExtra info - Coolmenus reference/help - Extra links to help files ****\nCSS help: http://coolmenus.dhtmlcentral.com/projects/coolmenus/reference.asp?m=37\nGeneral: http://coolmenus.dhtmlcentral.com/reference.asp?m=35\nMenu properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=47\nLevel properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=48\n\nBackground bar properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=49\nItem properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=50\n******************************************************************************/\n\n/***\nThis is the menu creation code - place it right after you body tag\nFeel free to add this to a stand-alone js file and link it to your page.\n**/\n\n//Menu object creation\ncoolmenu=new makeCM(\"coolmenu\") //Making the menu object. Argument: menuname\n\ncoolmenu.frames = 0\n\n//Menu properties\ncoolmenu.onlineRoot=\"\"\ncoolmenu.pxBetween=2\ncoolmenu.fromLeft=200	//200\ncoolmenu.fromTop=100	//100\ncoolmenu.rows=1\ncoolmenu.menuPlacement=\"center\"   //The whole menu alignment, left, center, or right\n\ncoolmenu.resizeCheck=1\ncoolmenu.wait=250\ncoolmenu.fillImg=\"cm_fill.gif\"\ncoolmenu.zIndex=100\n\n//Background bar properties\ncoolmenu.useBar=0\ncoolmenu.barWidth=\"100%\"\ncoolmenu.barHeight=\"menu\"\ncoolmenu.barClass=\"cBar\"\ncoolmenu.barX=0\ncoolmenu.barY=0\ncoolmenu.barBorderX=0\ncoolmenu.barBorderY=0\ncoolmenu.barBorderClass=\"\"\n\n//Level properties - ALL properties have to be spesified in level 0\ncoolmenu.level[0]=new cm_makeLevel() //Add this for each new level\ncoolmenu.level[0].width=110\ncoolmenu.level[0].height=51\ncoolmenu.level[0].regClass=\"cLevel0\"\ncoolmenu.level[0].overClass=\"cLevel0over\"\ncoolmenu.level[0].borderX=1\ncoolmenu.level[0].borderY=1\ncoolmenu.level[0].borderClass=\"cLevel0border\"\n\ncoolmenu.level[0].offsetX=0\ncoolmenu.level[0].offsetY=0\ncoolmenu.level[0].rows=0\ncoolmenu.level[0].arrow=0\ncoolmenu.level[0].arrowWidth=0\ncoolmenu.level[0].arrowHeight=0\ncoolmenu.level[0].align=\"bottom\"\n\n//EXAMPLE SUB LEVEL[1] PROPERTIES - You have to specify the properties you want different from LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[1]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[1].width=coolmenu.level[0].width+20\ncoolmenu.level[1].height=25\ncoolmenu.level[1].regClass=\"cLevel1\"\ncoolmenu.level[1].overClass=\"cLevel1over\"\ncoolmenu.level[1].borderX=1\ncoolmenu.level[1].borderY=1\ncoolmenu.level[1].align=\"right\"\ncoolmenu.level[1].offsetX=0\ncoolmenu.level[1].offsetY=0\ncoolmenu.level[1].borderClass=\"cLevel1border\"\n\n//EXAMPLE SUB LEVEL[2] PROPERTIES - You have to specify the properties you want different from LEVEL[1] OR LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[2]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[2].width=coolmenu.level[0].width+20\ncoolmenu.level[2].height=25\ncoolmenu.level[2].offsetX=0\ncoolmenu.level[2].offsetY=0\ncoolmenu.level[2].regClass=\"cLevel2\"\ncoolmenu.level[2].overClass=\"cLevel2over\"\ncoolmenu.level[2].borderClass=\"cLevel2border\"\n\n//EXAMPLE SUB LEVEL[2] PROPERTIES - You have to specify the properties you want different from LEVEL[1] OR LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[3]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[3].width=coolmenu.level[0].width+20\ncoolmenu.level[3].height=25\ncoolmenu.level[3].offsetX=0\ncoolmenu.level[3].offsetY=0\ncoolmenu.level[3].regClass=\"cLevel2\"\ncoolmenu.level[3].overClass=\"cLevel2over\"\ncoolmenu.level[3].borderClass=\"cLevel2border\"\n\n<tmpl_loop page_loop>\ncoolmenu.makeMenu(\'coolmenu_<tmpl_var page.assetId escape=JS>\'.replace(/\\-/g,\"a\"),\'coolmenu_<tmpl_var page.parent.assetId escape=JS>\'.replace(/\\-/g,\"a\"),\"<tmpl_var page.menuTitle escape=JS>\",\'<tmpl_var page.url escape=JS>\'<tmpl_if page.newWindow>,\'_blank\'</tmpl_if>);\n</tmpl_loop>\n\ncoolmenu.construct();\n\n</script>\n','Navigation',1,1,'PBtmpl0000000000000134',1147642411,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n/* CoolMenus 4 - default styles - do not edit */\n.cCMAbs {\n	position: absolute;\n	visibility: hidden;\n	left: 0;\n	top: 0;\n}\n/* CoolMenus 4 - default styles - end */\n\n/*Styles for level 0*/\n.cLevel0,.cLevel0over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 12px;\n	font-weight: bold;\n}\n\n.cLevel0 {\n	background-color: navy;\n	layer-background-color: navy;\n	color: white;\n	text-align: center;\n}\n\n.cLevel0over {\n	background-color: orange;\n	layer-background-color: navy;\n	color: white;\n	cursor: pointer;\n	cursor: pointer;\n	text-align: center;\n}\n\n.cLevel0border {\n	position: absolute;\n	visibility: hidden;\n	background-color: #569635;\n	layer-background-color: #006699;\n}\n\n/*Styles for level 1*/\n.cLevel1, .cLevel1over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 11px;\n	font-weight:bold;\n}\n\n.cLevel1 {\n	background-color: navy;\n	layer-background-color: navy;\n	color: white;\n}\n\n.cLevel1over {\n	background-color: #336699;\n	layer-background-color: #336699;\n	color: yellow;\n	cursor: pointer;\n	cursor: pointer;\n}\n\n.cLevel1border {\n	position: absolute;\n	visibility: hidden;\n	background-color: #006699;\n	layer-background-color: #006699;\n}\n\n/*Styles for level 2*/\n.cLevel2, .cLevel2over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 10px;\n	font-weight: bold;\n}\n\n.cLevel2 {\n	background-color: navy;\n	layer-background-color: navy;\n	color:white;\n}\n\n.cLevel2over {\n	background-color: #0099cc;\n	layer-background-color: #0099cc;\n	color: yellow;\n	cursor:pointer;\n	cursor:hand;\n}\n\n.cLevel2border {\n	position: absolute;\n	visibility: hidden;\n	background-color: #006699;\n	layer-background-color: #006699;\n}\n\n</style>\n<script src=\"^Extras(coolmenus/coolmenus4.js);\" type=\"text/javascript\"></script>\n\n'),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<span class=\"crumbTrail\">\n<tmpl_loop page_loop>\n<a class=\"crumbTrail\" \n    <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   <tmpl_unless \"__last__\"> &gt; </tmpl_unless>\n</tmpl_loop>\n</span>','Navigation',1,1,'PBtmpl0000000000000093',1147642412,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div id=\"dashboardContainer\" style=\"background-color:white;\">\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\">\n</a>\n<table id=\"dashboardChooserContainer\" width=\"100%\" border=\"0\">\n<tr>\n<td id=\"leftBox\">\n<div style=\"display:none;cursor: pointer;\" id=\"hideNewContentButton\" onclick=\"makeInactive(this);makeInactive(document.getElementById(\'availableBox\'));makeActive(document.getElementById(\'showNewContentButton\'));\">Hide New Content List</div>\n<div id=\"availableBox\"><div id=\"availableBox2\">\n<div id=\"availableDashlets\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"position1\" class=\"dashboardColumn\">\n<tbody class=\"availableDashlet\">\n<tmpl_loop position1_loop><tr id=\"td<tmpl_var id>\"><td><div id=\"td<tmpl_var id>_div\" class=\"dragable\"><div class=\"dragTrigger\"><div class=\"dragTitle\"><span class=\"headerTitle\" id=\"hdrtd<tmpl_var id>_span\"><tmpl_var dashletTitle></span><span class=\"options\" onmouseover=\"this.className=\'options optionsHoverIE\'\" onmouseout=\"this.className=\'options\'\"><tmpl_if canEditUserPrefs><a onclick=\"dashboard_toggleEditForm(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/edit_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><a onclick=\"dragable_deleteContent(event,this<tmpl_if canPersonalize>,\'true\'</tmpl_if>);this.parentNode.onmouseout();\"><img src=\"^Extras(wobject/Dashboard/delete_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a><tmpl_if showReloadIcon><a onclick=\"dashboard_reloadDashlet(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/reload.gif);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><br /></span></div></div>\n<div class=\"content\" id=\"ct<tmpl_var id>_div\"><tmpl_var content></div></div></td></tr></tmpl_loop>\n</tbody></table>\n</div></div></div>\n</td>\n<td id=\"rightBox\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">\n<tr><td style=\"width:80px;\">			<div id=\"showNewContentButton\"  onclick=\"makeInactive(this);makeActive(document.getElementById(\'availableBox\'));makeActive(document.getElementById(\'hideNewContentButton\'));\">Add New Content</div></td><td>\n<tmpl_if showAdmin>\n<p>\n<tmpl_var controls>\n</p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n<h2 style=\"text-align:center\">\n<tmpl_var title>\n</h2>\n</tmpl_if>\n\n\n\n<tmpl_if description>\n<p>\n<tmpl_var description>\n</p>\n</tmpl_if>\n</td><td valign=\"top\" class=\"login\">^L(\"17\",\"\",\"PBtmpl0000000000000092\"); ^AdminToggle(Modify the Default User\'s Perspective,Leave Default User Perspective (Admin Mode));</td></tr></table>\n<script type=\"text/javascript\" src=\"^Extras(js/at/AjaxRequest.js);\"></script>\n<script type=\"text/javascript\">\nfunction submitForm(theform,idToReplace,shortcutUrl) {\n\nvar status = AjaxRequest.submit(\ntheform\n,{\n\'parameters\':{\n},\n\'onSuccess\':function(req){\nvar myArray = req.responseText.split(/beginDebug/mg,1);\ndocument.getElementById(\"ct\" + idToReplace + \"_div\").innerHTML = myArray[0];\nvar existingForm = document.getElementById(\"form\" + idToReplace + \"_div\");\nthrowAway = existingForm.parentNode.removeChild(existingForm);\nvar hoopla = AjaxRequest.get(\n		{\n			\'url\':shortcutUrl\n			,\'parameters\':{\n				\'func\':\"getNewTitle\"\n			}\n			,\'onSuccess\':function(req){\n				var myArr557 = req.responseText.split(/beginDebug/mg,1);\n				document.getElementById(\"hdrtd\" + idToReplace + \"_span\").innerHTML = myArr557[0];\n			}\n		}\n	);\n	}\n	}\n);\nreturn status;\n	}\nfunction makeActive(o) { o.style.display = \"inline\"; }\nfunction makeInactive(o) { o.style.display = \"none\"; }\nfunction AjaxRequestBegin() {  }\nfunction AjaxRequestEnd() {  }\n</script>\n<div id=\"columnsContainerDiv\">\n<table cellpadding=\"0\" cellspacing=\"8\" border=\"0\" id=\"columnsContainerTable\" width=\"100%\">\n<tr>\n<td style=\"width:33%;\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"position2\" class=\"dashboardColumn\" width=\"100%\">\n<tbody>\n	<tmpl_loop position2_loop><tr id=\"td<tmpl_var id>\"><td><div id=\"td<tmpl_var id>_div\" class=\"dragable\"><div class=\"dragTrigger\"><div class=\"dragTitle\"><span class=\"headerTitle\" id=\"hdrtd<tmpl_var id>_span\"><tmpl_var dashletTitle></span></span><span class=\"options\" onmouseover=\"this.className=\'options optionsHoverIE\'\" onmouseout=\"this.className=\'options\'\"><tmpl_if canEditUserPrefs><a onclick=\"dashboard_toggleEditForm(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/edit_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><a onclick=\"dragable_deleteContent(event,this<tmpl_if canPersonalize>,\'true\'</tmpl_if>);this.parentNode.onmouseout();\"><img src=\"^Extras(wobject/Dashboard/delete_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a><tmpl_if showReloadIcon><a onclick=\"dashboard_reloadDashlet(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/reload.gif);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><br /></span></div></div>\n	<div class=\"content\" id=\"ct<tmpl_var id>_div\"><tmpl_var content></div></div></td></tr></tmpl_loop>\n</tbody>\n</table>\n</td>\n<td style=\"height:500px;background-color:gray;width:2px;\">\n</td>\n<td style=\"width:33%;\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"position3\" class=\"dashboardColumn\" width=\"100%\">\n<tbody>\n<tmpl_loop position3_loop><tr id=\"td<tmpl_var id>\"><td><div id=\"td<tmpl_var id>_div\" class=\"dragable\"><div class=\"dragTrigger\"><div class=\"dragTitle\"><span class=\"headerTitle\"><span class=\"headerTitle\" id=\"hdrtd<tmpl_var id>_span\"><tmpl_var dashletTitle></span></span><span class=\"options\" onmouseover=\"this.className=\'options optionsHoverIE\'\" onmouseout=\"this.className=\'options\'\"><tmpl_if canEditUserPrefs><a onclick=\"dashboard_toggleEditForm(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/edit_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><a onclick=\"dragable_deleteContent(event,this<tmpl_if canPersonalize>,\'true\'</tmpl_if>);this.parentNode.onmouseout();\"><img src=\"^Extras(wobject/Dashboard/delete_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a><tmpl_if showReloadIcon><a onclick=\"dashboard_reloadDashlet(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/reload.gif);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><br /></span></div></div>\n<div class=\"content\" id=\"ct<tmpl_var id>_div\"><tmpl_var content></div></div></td></tr></tmpl_loop>\n</tbody>\n</table>\n</td>\n<td style=\"height:500px;background-color:gray;width:2px;\"></td>\n<td style=\"width:33%;\">\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" id=\"position4\" class=\"dashboardColumn\" width=\"100%\">\n<tbody>\n<tmpl_loop position4_loop><tr id=\"td<tmpl_var id>\"><td><div id=\"td<tmpl_var id>_div\" class=\"dragable\"><div class=\"dragTrigger\"><div class=\"dragTitle\"><span class=\"headerTitle\"><span class=\"headerTitle\" id=\"hdrtd<tmpl_var id>_span\"><tmpl_var dashletTitle></span></span><span class=\"options\" onmouseover=\"this.className=\'options optionsHoverIE\'\" onmouseout=\"this.className=\'options\'\"><tmpl_if canEditUserPrefs><a onclick=\"dashboard_toggleEditForm(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/edit_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><a onclick=\"dragable_deleteContent(event,this<tmpl_if canPersonalize>,\'true\'</tmpl_if>);this.parentNode.onmouseout();\"><img src=\"^Extras(wobject/Dashboard/delete_btn.jpg);\" style=\"border-style:none;\" alt=\"\" /></a><tmpl_if showReloadIcon><a onclick=\"dashboard_reloadDashlet(event,\'<tmpl_var id>\',\'<tmpl_var shortcutUrl>\')\"><img src=\"^Extras(wobject/Dashboard/reload.gif);\" style=\"border-style:none;\" alt=\"\" /></a></tmpl_if><br /></span></div></div>\n<div class=\"content\" id=\"ct<tmpl_var id>_div\"><tmpl_var content></div></div></td></tr></tmpl_loop>\n</tbody>\n</table>\n</td>\n</tr>\n</table>\n</div>\n<table class=\"blankTable\"><tr id=\"blank\" class=\"hidden\"><td class=\"blankColumn\"><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n<tmpl_var dragger.init>\n</td></tr></table></div>\n','Dashboard',1,1,'DashboardViewTmpl00001',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/draggable.css);\"; </style>\n<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/dashboard.css);\"; </style>\n<script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>\n<!--[if IE]>\n<style type=\"text/css\">\ndiv.dragTitle\n{\n	overflow-x:hidden;\n}\n</style>\n<![endif]-->\n'),('<a href=\"<tmpl_var back.url>\"><tmpl_var back.label></a>\n<tmpl_if session.var.adminOn>\n<p><tmpl_var controls></p>\n</tmpl_if><p />\n<table width=\"100%\">\n<tr>\n<td class=\"tableHeader\">Entry ID</td>\n<tmpl_loop field_loop>\n  <tmpl_unless field.isMailField>\n    <td class=\"tableHeader\"><tmpl_var field.label></td>\n  </tmpl_unless field.isMailField>\n</tmpl_loop field_loop>\n<td class=\"tableHeader\">Submission Date</td>\n</tr>\n<tmpl_loop record_loop>\n<tr>\n  <td class=\"tableData\"><a href=\"<tmpl_var record.edit.url>\"><tmpl_var record.entryId></a></td>\n  <tmpl_loop record.data_loop>\n    <tmpl_unless record.data.isMailField>\n       <td class=\"tableData\"><tmpl_var record.data.value></td>\n     </tmpl_unless record.data.isMailField>\n  </tmpl_loop record.data_loop>\n  <td class=\"tableData\"><tmpl_var record.submissionDate.human></td>\n</tr>\n</tmpl_loop record_loop>\n</table>','DataForm/List',1,1,'PBtmpl0000000000000021',1147642412,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<div class=\"acknowledgement\">\n	<tmpl_var acknowledgement>\n</div>\n\n<table border=\"0\" class=\"acknowledgement\">\n<tmpl_loop field_loop>\n<tmpl_unless field.isMailField><tmpl_unless field.isHidden>\n	<tr><td class=\"tableHeader\"><tmpl_var field.label></td>\n	<td class=\"tableData\"><tmpl_var field.value></td></tr>\n</tmpl_unless></tmpl_unless>\n</tmpl_loop>\n</table>\n<p />\n<a href=\"<tmpl_var back.url>\" class=\"backLabel\"><tmpl_var back.label></a>\n\n\n','DataForm',1,1,'PBtmpl0000000000000104',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.acknowledgement\n{\n	margin-top:5px;\n}\n.acknowledgement td\n{\n	font-size:9pt;\n	font-family:arial;\n}\n\na.blackLabel\n{\n	color:#29587E;\n}\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"content\">\n	<img src=\"<tmpl_var image.url>\" align=\"right\" border=\"0\" alt=\"<tmpl_var image.url>\" />\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n	<tmpl_if linkUrl>\n	<tmpl_if linkTitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n	</tmpl_if>\n	<tmpl_if attachment.name><p><p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /> <tmpl_var attachment.name></a></p></p></tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	</td></tr></table>\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<p>\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td>\n	</tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000002',1147642412,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if error_loop>\n	<ul class=\"errors\">\n		<tmpl_loop error_loop>\n			<li><b><tmpl_var error.message></b></li>\n		</tmpl_loop>\n	</ul>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if canEdit>\n	<div class=\"dataControls\">\n		<a href=\"<tmpl_var entryList.url>\"><tmpl_var entryList.label></a>\n		&bull; <a href=\"<tmpl_var export.tab.url>\"><tmpl_var export.tab.label></a>\n		<tmpl_if entryId>\n			&bull; <a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n			&bull; <a href=\"<tmpl_var addField.url>\"><tmpl_var addField.label></a>\n			&bull; <a href=\"<tmpl_var addTab.url>\"><tmpl_var addTab.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_if>\n<tmpl_var form.start>\n<table class=\"defaultData\">\n        <tmpl_loop field_loop>\n                <tmpl_unless field.isHidden>\n                        <tr>\n                                <td class=\"formDescription\" valign=\"top\">\n                                        <tmpl_if session.var.adminOn>\n                                                <tmpl_if canEdit>\n                                                        <tmpl_var field.controls>\n                                                </tmpl_if>\n                                        </tmpl_if>\n                                        <tmpl_var field.label>\n                                </td>\n                                <td class=\"tableData\" valign=\"top\">\n                                        <tmpl_if field.isDisplayed>\n                                                <tmpl_var field.value>\n                                        <tmpl_else>\n                                                <tmpl_var field.form>\n                                        </tmpl_if>\n                                        <tmpl_if field.isRequired>*</tmpl_if>\n                                        <span class=\"formSubtext\">\n                                                <br />\n                                                <tmpl_var field.subtext>\n                                        </span>\n                                </td>\n                        </tr>\n                </tmpl_unless>\n        </tmpl_loop>\n</table>\n<br />\n<tmpl_var form.save>\n<tmpl_var form.end>\n\n\n','DataForm',1,1,'PBtmpl0000000000000141',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n\n.dataControls a\n{\n	color:white;\n}\n</style>'),('<h2><tmpl_var displayTitle></h2>\n\n<tmpl_if profile.message>\n   <tmpl_var profile.message>\n</tmpl_if>\n\n<tmpl_var profile.form.header>\n<tmpl_var profile.form.hidden>\n<table >\n<tmpl_loop profile.form.elements>\n     <tr>\n       <td class=\"tableHeader\" valign=\"top\" colspan=\"2\">\n         <tmpl_var profile.form.category>\n       </td>\n     </tr>\n \n <tmpl_loop profile.form.category.loop>\n   <tr>\n    <td class=\"formDescription\" valign=\"top\">\n      <tmpl_var profile.form.element.label>\n    </td>\n    <td class=\"tableData\">\n      <tmpl_var profile.form.element>\n      <tmpl_if profile.form.element.subtext>\n        <span class=\"formSubtext\">\n         <tmpl_var profile.form.element.subtext>\n        </span>\n      </tmpl_if>\n    </td>\n   </tr>\n </tmpl_loop>\n</tmpl_loop>\n<tmpl_loop create.form.profile>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var profile.formElement.label></td>\n   <td class=\"tableData\"><tmpl_var profile.formElement></td>\n</tr>\n</tmpl_loop>\n<tr>\n <td class=\"formDescription\" valign=\"top\"></td>\n <td class=\"tableData\">\n     <tmpl_var profile.form.submit>\n </td>\n</tr>\n</table>\n<tmpl_var profile.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n      <tmpl_loop profile.accountOptions>\n         <li><tmpl_var options.display></li>\n      </tmpl_loop>\n   </ul>\n</div>','Operation/Profile/Edit',1,1,'PBtmpl0000000000000051',1147642412,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if resolveConflicts>\n<tmpl_var form.header>\n<table width=\"100%\" border=\"0\">\n<tr><td><tmpl_var message></td></tr>\n\n<tr>\n	<td>\n		<table width=\"100%\">\n <tmpl_loop conflict_loop>\n		<tr<tmpl_unless __ODD__> class=\"evenRow\"<tmpl_else> class=\"oddRow\"</tmpl_unless>>\n			<td><tmpl_var form.deleteControl></td>\n			<td><tmpl_var title></td>\n			<td><tmpl_var description></td>\n			<td><tmpl_var price></td>\n		</tr>\n </tmpl_loop>\n		</table>\n	</td>\n</tr> \n<tr><td><tmpl_var form.submit></td></tr>\n</table>\n<tmpl_var form.footer>\n</tmpl_if>\n\n\n\n\n<tmpl_if registration>\n  <tmpl_var form.header>\n  <tmpl_var form.message>\n  <tmpl_var form.chooserJS>\n  <table style=\"border-top:solid gray 1px;width:100%;margin-top:5px;\">\n  <tr><td><tmpl_var form.chooser.label></td><td><tmpl_var form.chooser></td></tr>\n  <tr><td><tmpl_var form.firstName.label></td><td><tmpl_var form.firstName></td></tr>\n<tr><td><tmpl_var form.lastName.label></td><td><tmpl_var form.lastName></td></tr>\n<tr><td><tmpl_var form.address.label></td><td><tmpl_var form.address></td></tr>\n<tr><td><tmpl_var form.city.label></td><td><tmpl_var form.city></td></tr>\n<tr><td><tmpl_var form.state.label></td><td><tmpl_var form.state></td></tr>\n<tr><td><tmpl_var form.zipcode.label></td><td><tmpl_var form.zipcode></td></tr>\n<tr><td><tmpl_var form.country.label></td><td><tmpl_var form.country></td></tr>\n<tr><td><tmpl_var form.phoneNumber.label></td><td><tmpl_var form.phoneNumber></td></tr>\n<tr><td><tmpl_var form.email.label></td><td><tmpl_var form.email></td></tr>\n<tr><td><tmpl_var form.badgeId.label></td><td><tmpl_var form.badgeId></td></tr>\n<tr><td colspan=\"2\"><br /><tmpl_var form.submit></td></tr>\n</table>\n<script type=\"text/javascript\">\n\nfunction swapBadgeInfo(badgeId) {\n	var selector = document.getElementById(\'badgeId_formId\');\n	for (var i in badges[badgeId]) {\n		var field = document.getElementById(i+\'_formId\');\n		if (field && badges[badgeId][i]) {\n			field.value=badges[badgeId][i];\n		} else {\n			if (field) field.value=\'\';\n		}\n	}\n}	\n\nvar selector1 = document.getElementById(\'badgeId_formId\');\nif (selector1) {\n	swapBadgeInfo(selector1.value);\n}\n\n</script>\n<tmpl_var form.footer>\n</tmpl_if>\n\n<tmpl_if prereqsAreMissing>\n<tmpl_var form.header>\n<table border=\"1\">\n\n<tmpl_loop message_loop>\n<tr>\n	<td colspan=\"4\"><strong><tmpl_var title> requires all of the following:</strong></td>\n</tr>\n<tr>\n	<td colspan=\"4\">\n		<ul>\n<tmpl_loop messageLoop>\n			<li><tmpl_var reqmessage></li>\n</tmpl_loop>\n		</ul>\n	</td>\n</tr>\n</tmpl_loop>\n\n<tmpl_loop missingEvents_loop>\n<tr<tmpl_unless __ODD__> class=\"evenRow\"<tmpl_else> class=\"oddRow\"</tmpl_unless>><td><tmpl_var form.checkBox></td><td><tmpl_var title></td><td><tmpl_var description></td><td><tmpl_var price></td></tr>\n</tmpl_loop>\n<tr><td colspan=\"4\"><br /><tmpl_var form.submit></td></tr>\n</table>\n<tmpl_var form.footer>\n\n</tmpl_if>\n','EventManagementSystem_checkout',1,1,'EventManagerTmpl000003',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntr.oddRow td {\n	background-color:#DADADA;\n	border-right:solid gray 1px;\n}\ntr.evenRow td {\n	background-color:#E8E8E8;\n	border-right:solid gray 1px;\n}\n</style>'),('<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<h2><tmpl_var managePurchasesTitle></h2>\n<table width=\"100%\" cellspacing=\"0\" cellpadding=\"2\">\n<tr>\n	<td><tmpl_var purchaseId.label></td>\n	<td><tmpl_var datePurchasedHuman.label></td>\n</tr>\n<tmpl_if purchasesLoop>\n	<tmpl_loop purchasesLoop>\n	<tr<tmpl_unless __ODD__> class=\"evenRow\"<tmpl_else> class=\"oddRow\"</tmpl_unless>>\n		<td><strong><tmpl_var __COUNT__></strong></td>\n		<td>&nbsp;<a href=\"<tmpl_var purchaseUrl>\"><tmpl_var purchaseId></a></td>\n		<td>&nbsp;<tmpl_var datePurchasedHuman></td>\n	</tr>\n	</tmpl_loop>\n<tmpl_else>\n<tr>\n	<td><tmpl_var noPurchasesMessage></td>\n</tr>\n</tmpl_if>\n</table>\n','EventManagementSystem_managePurchas',1,1,'EventManagerTmpl000004',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntr.oddRow td {\r\n	background-color:#DADADA;	\r\n}\r\ntr.evenRow td {\r\n	background-color:#E8E8E8;	\r\n}\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<ul>\n<tmpl_if canManageEvents>\n   <li><a href=\'<tmpl_var addEvent.url>\'><tmpl_var addEvent.label></a></li>\n   <li><a href=\'<tmpl_var manageEvents.url>\'><tmpl_var manageEvents.label></a></li>\n</tmpl_if>\n<li><a href=\'<tmpl_var managePurchases.url>\'><tmpl_var managePurchases.label></a></li>\n</ul>\n<tmpl_var calendarJS>\n<tmpl_unless noSearchDialog>\n<script type=\"text/javascript\" src=\"<tmpl_var ems.wobject.dir>/script/dynamicForms.js\"></script>\n<script type=\"text/javascript\">\n   <tmpl_var search.filters.options>\n   var advanced = 0;\n   var filterCount = 0;\n\n	function setSelectValue(selObj,newValue) {\n		for (var i=0; i<selObj.options.length; i++) {\n			selObj.options[i].selected = (selObj.options[i].value==newValue)?true:false;\n		}\n	}\n	\n   function toggleAdvanced() {\n      var ids = [\"cParams\",\"cResults\",\"cSearch\"];\n	  var toggle = \"\";\n	  for (var i = 0; i < ids.length; i++) {\n	     if(advanced == 1) {\n		    toggle = \"none\";\n		 }\n		 document.getElementById(ids[i]).style.display=toggle;\n	  }\n	  advanced = (advanced == 1)?0:1;\n	  return false;\n   }\n   \n   function toggleTitle(obj) {\n      if (obj.checked) {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'inline\';\n	  } else {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'none\';\n	  }\n   }\n   \n   function openWin (url, name, param) {\n      var newwin = window.open(url, name, param);\n      newwin.focus();\n   }\n   \n   function buildFilterList() {\n      return \"Custom Filter\";\n   }\n   \n   function stripDelim(value,delim) {\n      value = value.replace(/delim/g,\"\");\n	  return value;\n   }\n\n	function unset(array, valueToUnset){\n		var output=new Array(0);\n		for(var i in array){\n			if(i==valueToUnset){continue;}\n			output[i]=array[i];\n		}\n		return output;\n	}\n	function advSearch() {\n		var mee = document.getElementById(\'basicSearch\')\n		if (mee) mee.style.display=\'none\';\n		var pee = document.getElementById(\'advSearchDiv\');\n		if (pee) pee.style.display=\'block\';\n	}\n	function basicSearch() {\n		var vee = document.getElementById(\'basicSearch\');\n		if (vee) vee.style.display=\'block\';\n		var dee = document.getElementById(\'advSearchDiv\');\n		if (dee) dee.style.display=\'none\';\n	}\n</script>\n\n<div id=\"basicSearch\">\n<tmpl_var advSearch.formHeader>\n<table width=\"100%\" border=\"0\" padding=\"1\" style=\"border-bottom:double gray 5px;border-top:solid gray 1px;margin-bottom:5px;margin-top:5px;\">\n   <tbody id=\"filterbody\">\n   <tr>\n      <td style=\"font-weight:bold;width:40%;\">Search Keywords:</td>\n	  <td style=\"width:60%;\"><input name=\"searchKeywords\" style=\"width:100%;\" /></td>\n   </tr>\n   \n   </tbody>\n</table>\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n<tr>\n	<td align=\"left\"><tmpl_var search.formSubmit></td>\n	<td align=\"right\" valign=\"top\"><a href=\"javascript:void(addField())\">Add a custom filter</a></td>\n</tr>\n</table>\n<tmpl_var search.formFooter>\n</div>\n\n</tmpl_unless>\n<br /><br />\n\n<tmpl_if managePrereqs><p><tmpl_var managePrereqsMessage></p><tmpl_var prereqForm.header></tmpl_if>\n<p><tmpl_var message></p>\n<p>Your search returned <tmpl_var numberOfSearchResults> results.</p>\n<p><tmpl_var addToBadgeMessage></p>\n\n<table width=\"100%\" border=\"0\" cellpadding=\"8\" cellspacing=\"0\" style=\"border-top:solid gray 2px;border-bottom:solid gray 2px;\">\n<tr>\n<tmpl_if managePrereqs><th>&nbsp;</th></tmpl_if>\n<th><tmpl_var name.label></th>\n<th><tmpl_var starts.label></th>\n<th><tmpl_var ends.label></th>\n<th><tmpl_var seats.label></th>\n<th><tmpl_var price.label></th>\n<th><tmpl_var requirement.label></th>\n<th><tmpl_var addToCart.label></th></tr>\n<tmpl_loop events_loop>\n  <tr<tmpl_unless __ODD__> class=\"oddRow\"<tmpl_else> class=\"evenRow\"</tmpl_unless>>\n\n  <tmpl_if managePrereqs><td><tmpl_var prereqForm.checkbox></td></tmpl_if>\n  <td nowrap><tmpl_if canManageEvents><tmpl_var manageToolbar>&nbsp;</tmpl_if><tmpl_var title>\n  </td><td><tmpl_var startDate.human>\n  </td><td><tmpl_var endDate.human>\n  </td><td><tmpl_var seatsRemaining>\n  </td><td><tmpl_var price>\n  </td><td><tmpl_var requirement>\n  </td><td><tmpl_unless eventIsFull><a href=\"<tmpl_var purchase.url>\"><tmpl_var purchase.label></a><tmpl_else><tmpl_var purchase.label><br /></tmpl_unless>\n  </td></tr>\n</tmpl_loop>\n<tmpl_if managePrereqs><tr><td><tmpl_var prereqForm.operator></td></tr></tmpl_if>\n</table>\n<tmpl_if managePrereqs><tmpl_var prereqForm.submit><tmpl_var prereqForm.footer></tmpl_if>\n\n<table width=\"100%\">\n<tr><td align=\"right\"><a href=\'<tmpl_var continue.url>\'><tmpl_var continue.label></a></td></tr>\n</table>\n<tmpl_var paginateBar>\n\n\n','EventManagementSystem_search',1,1,'EventManagerTmpl000006',1147642412,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntr.oddRow td {\n	background-color:#DADADA;\n	border-right:solid gray 1px;\n}\ntr.evenRow td {\n	background-color:#E8E8E8;\n	border-right:solid gray 1px;\n}\n.manageEvents {\n	margin-top:5px;\n	margin-bottom:5px;\n}\n.datacardtitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:13px;\n}\n\n.leftnav{\n	padding: 1px 1px 1px 1px;\n	background: white;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.leftnavon{\n	padding: 1px 1px 1px 1px;\n	background: yellow;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.calendartitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n}\n.filter-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 105px;\n}\n.compare-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 76px;\n}\n.filter-text {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 114px;\n}\n.smLink {\n   font-family: verdana;\n   font-size: 10px;\n   font-weight: normal;\n   color: blue;\n}\n\n\n</style>\n\n<link href=\"^Extras(calendar/calendar-win2k-1.css);\" rel=\"stylesheet\" type=\"text/css\" />\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<ul>\n<tmpl_if canManageEvents>\n   <li><a href=\'<tmpl_var manageEvents.url>\'><tmpl_var manageEvents.label></a></li>\n</tmpl_if>\n<li><a href=\'<tmpl_var managePurchases.url>\'><tmpl_var managePurchases.label></a></li>\n<li><a href=\"<tmpl_var checkout.url>\"><tmpl_var checkout.label></a></li>\n</ul>\n\n<table width=\"100%\" border=\"1\" cellpadding=\"8\" cellspacing=\"0\" style=\"border-top:solid gray 2px;border-bottom:solid gray 2px;\">\n<tmpl_loop events_loop>\n<tr>\n	<td valign=\"top\" colspan=\"7\"><tmpl_var event></td>\n</tr>\n</tmpl_loop>\n</table>\n<tmpl_var paginateBar>\n	\n','EventManagementSystem',1,1,'EventManagerTmpl000001',1147642413,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntr.oddRow td {\n	background-color:#DADADA;\n	border-right:solid gray 1px;\n}\ntr.evenRow td {\n	background-color:#E8E8E8;\n	border-right:solid gray 1px;\n}\n.manageEvents {\n	margin-top:5px;\n	margin-bottom:5px;\n}\n.datacardtitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:13px;\n}\n\n.leftnav{\n	padding: 1px 1px 1px 1px;\n	background: white;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.leftnavon{\n	padding: 1px 1px 1px 1px;\n	background: yellow;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.calendartitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n}\n.filter-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 105px;\n}\n.compare-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 76px;\n}\n.filter-text {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 114px;\n}\n.smLink {\n   font-family: verdana;\n   font-size: 10px;\n   font-weight: normal;\n   color: blue;\n}\n\n\n</style>\n'),('<h2 class=\"productTitle\"><a href=\'<tmpl_var title.url>\'><tmpl_var title></a></h2>\n\n<table class=\"productDetails\" cellpadding=\"3\" cellspacing=\"0\">\n<tr>\n	<td class=\"description\" valign=\"top\"><tmpl_var description></td>\n	<td class=\"price\" valign=\"top\"><tmpl_var price></td>\n</tr>\n<tr class=\"softGray\">\n	<td colspan=\"2\"><strong>Max Attendees:</strong> <tmpl_var maximumAttendees></td>\n</tr>\n<tr class=\"softGray\">	\n	<td colspan=\"2\"><strong>Seats Remaining:</strong> <tmpl_var seatsRemaining></td>\n</tr>	\n<tr class=\"softGray\">	\n	<td colspan=\"2\"><strong>Number Registered:</strong> <tmpl_var numberRegistered></td>\n</tr>\n<tr class=\"softGray\">	\n	<td colspan=\"2\"><strong>Event Full?:</strong> <tmpl_var eventIsFull></td>\n</tr>\n<tr class=\"softGray\">\n	<td  colspan=\"2\" class=\"purchase\">\n	<tmpl_unless eventIsFull>\n		<a style=\"cursor:pointer;\" href=\"javascript:void(window.location=(confirm(\'<tmpl_var purchase.message>\'))?\'<tmpl_var purchase.wantToSearch.url>\':\'<tmpl_var purchase.wantToContinue.url>\')\"><tmpl_var purchase.label></a>\n	<tmpl_else>\n		<tmpl_var purchase.label><br />\n	</tmpl_unless>	\n	</td>\n</tr>\n</table>\n\n','EventManagementSystem_product',1,1,'EventManagerTmpl000002',1147642413,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	td.description {\n		width:80%;\n		text-align:left;\n		border-bottom:solid silver 1px;\n		font-style:italic;		\n	}\n	td.price {\n		width:20%;\n		text-align:right;\n		font-weight:bold;\n		border-bottom:solid silver 1px;\n	}\n	h2.productTitle {\n		margin-bottom:3px;\n		border-bottom:solid gray 1px;\n	}\n	table.productDetails {\n		padding-left:10px;\n		-moz-box-sizing:border-box;\n		width:100%;\n	}\n	tr.softGray td {\n		background-color:#F0F0F0;\n	}\n	td.purchase {\n		border:solid silver 1px;\n		text-align:center;\n	}\n</style>\n'),('<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<h2><tmpl_var viewPurchaseTitle></h2>\n\n<tmpl_if canReturn><tmpl_if canReturnTransaction>\n	<div style=\"text-align:right;\">\n		(<a href=\"<tmpl_var appUrl>?func=returnItem;tid=<tmpl_var transactionId>\">Return Entire Purchase</a>)\n	</div>\n</tmpl_if></tmpl_if>\n\n<tmpl_loop purchasesLoop>\n<table width=\"100%\" border=\"0\" class=\"viewPurchase\">\n<tr>\n	<td class=\"badgeTitle\">Badge Name</td>\n	<td class=\"itinerary\">\n	Itinerary&nbsp;&nbsp;<tmpl_if canReturn><tmpl_if canReturnItinerary>(<a href=\"<tmpl_var appUrl>?func=returnItem;pid=<tmpl_var purchaseId>\">Return Entire Itinerary</a>)</tmpl_if></tmpl_if>\n	</td>\n</tr>\n<tr>\n	<td class=\"badgeName\" valign=\"top\">\n		<tmpl_var firstName> <tmpl_var lastName><br /><br />\n		<tmpl_if canAddEvents><tmpl_if canReturnItinerary><a href=\"<tmpl_var appUrl>?func=addEventsToBadge;bid=<tmpl_var badgeId>\">Add Events To Badge</a></tmpl_if></tmpl_if>\n	</td>\n	<td valign=\"top\">\n		<table width=\"100%\">\n		<tr>\n			<td><strong>Event Title</strong></td>\n			<td><strong>Event Dates</strong></td>\n		<tmpl_if canReturn>\n			<td><strong>Return Registration</strong></td>\n		</tmpl_if>\n		</tr>\n	<tmpl_loop regLoop>\n		<tr<tmpl_unless __ODD__> class=\"evenRow\"<tmpl_else> class=\"oddRow\"</tmpl_unless>>\n			<td><tmpl_var title></td>\n			<td><tmpl_var startDateHuman> - <tmpl_var endDateHuman></td>\n		<tmpl_if canReturn>\n			<td><tmpl_if returned>RETURNED<tmpl_else><a href=\"<tmpl_var appUrl>?func=returnItem;rid=<tmpl_var registrationId>\">Return This Registration</a></tmpl_if></td>\n		</tmpl_if>\n		</tr>\n	</tmpl_loop>\n		</table>\n	</td>\n</tr>\n</table>\n</tmpl_loop>\n','EventManagementSystem_viewPurchase',1,1,'EventManagerTmpl000005',1147642413,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.viewPurchase {\n	border-bottom:solid silver 2px;\n}\n.viewPurchase td {\n	font-size:10pt;\n}\ntr.oddRow td {\n	background-color:#DADADA;\n	border-right:solid gray 1px;\n}\ntr.evenRow td {\n	background-color:#E8E8E8;\n	border-right:solid gray 1px;\n}\ntd.badgeTitle, td.itinerary   {\n	font-size:9pt;\n	font-weight:bold;	\n	border-bottom:solid gray 1px;\n}\ntd.badgeName {\n	font-size:9pt;\n	font-style:italic;\n}\nh2 {\n	margin-bottom:3px;\n}\n</style>'),('<a href=\"<tmpl_var file.url>\"><img src=\"<tmpl_var file.icon>\" style=\"border-style:none;vertical-align:middle;\" /><tmpl_var file.name></a>','Macro/File',1,1,'PBtmpl0000000000000039',1147642413,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><tmpl_var subject.label></td>\n	<td class=\"forumHead\"><tmpl_var user.label></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.views.url>\"><tmpl_var views.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.replies.url>\"><tmpl_var replies.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.rating.url>\"><tmpl_var rating.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<tmpl_if displayLastReply>\n		<td class=\"forumHead\"><a href=\"<tmpl_var sortby.lastreply.url>\"><tmpl_var lastReply.label></a></td>\n	</tmpl_if>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n	<tmpl_if user.isVisitor>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n	<tmpl_else>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var views></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var replies></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var rating></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n	<tmpl_if displayLastReply>\n		<td  class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"font-size: 11px;\">\n			<a href=\"<tmpl_var lastReply.url>\"><tmpl_var lastReply.title></a>\n			by\n			<tmpl_if lastReply.user.isVisitor>\n				<tmpl_var lastReply.username>\n			<tmpl_else>\n				<a href=\"<tmpl_var lastReply.userProfile.url>\"><tmpl_var lastReply.username></a>\n			</tmpl_if>\n			on <tmpl_var lastReply.dateSubmitted.human> @ <tmpl_var lastReply.timeSubmitted.human>\n		</td>\n	</tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000026',1147642413,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if><tmpl_var form.header>\n\n<h2><tmpl_var search.label></h2>\n<tmpl_var query.form><tmpl_var form.search>\n<tmpl_var form.footer>\n<tmpl_if doit>\n	<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"0\" class=\"searchResults\">\n	<tr>\n		<td class=\"tableHeader\"><tmpl_var title.label></td>\n		<td class=\"tableHeader\"><tmpl_var user.label></td>\n		<td class=\"tableHeader\"><tmpl_var date.label></td>\n	</tr>\n	<tmpl_loop post_loop>\n		<tr>\n			<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n			<tmpl_if user.isVisitor>\n				<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><tmpl_var username></td>\n			<tmpl_else>\n				<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n			</tmpl_if>\n			<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n		</tr>\n	</tmpl_loop>\n	</table>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration/Search',1,1,'PBtmpl0000000000000031',1147642413,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2{\n	font-family:arial;\n}\n.searchResults{\n	border:solid silver 1px;\n	margin-top:5px;\n}\n.searchResults td{\n	font-family:arial;\n	font-size:9pt;\n}\n.searchResults td a{\n	color:#29587E;\n}\n.searchResults td.odd{\n	background-color:#DADADA;\n}\n.searchResults td.tableHeader{\n	background-color:gray;\n	color:white;\n	border-bottom:double solid silver 3px;\n	font-weight:bold;\n}\n.pagination\n{\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}\n\n</style>'),('<h2><tmpl_var title></h2>\n\n<tmpl_if user.canViewReports>\n<table cellspacing=\"2\" cellpadding=\"1\" style=\"border:solid silver 1px;\">\n<tr>\n	<td colspan=\"4\">\n		<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\">\n		<tr>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.gradebook.url>\"><tmpl_var report.gradebook.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.overview.url>\"><tmpl_var report.overview.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var delete.all.responses.url>\"><tmpl_var delete.all.responses.label></a></td>\n		</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.answers.url>\"><tmpl_var export.answers.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.questions.url>\"><tmpl_var export.questions.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.responses.url>\"><tmpl_var export.responses.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.composite.url>\"><tmpl_var export.composite.label></a></td>\n</tr>\n</table> \n</tmpl_if>\n\n<br /> <br />\n\n<table class=\"tableData\">\n<tr class=\"tableHeader\"><td style=\"width:60%\"><tmpl_var response.user.label></td>\n                <td style=\"width:20%\"><tmpl_var response.count.label></td>\n                <td style=\"width:20%\"><tmpl_var response.percent.label></td></tr>\n<tmpl_loop response_loop>\n<tr>\n	<td><a href=\"<tmpl_var response.url>\"><tmpl_var response.user.name></a></td>\n	<td><tmpl_var response.count.correct>/<tmpl_var question.count></td>\n             <td><tmpl_var response.percent>%</td>\n</tr>\n</tmpl_loop>\n</table>\n\n\n<tmpl_if pagination.pageCount.isMultiple>\n  <div class=\"pagination\">\n    <tmpl_var pagination.previousPage>  &middot; <tmpl_var pagination.pageList.upTo20> &middot; <tmpl_var pagination.nextPage>\n  </div>\n</tmpl_if>\n','Survey/Gradebook',1,1,'PBtmpl0000000000000062',1147642413,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<p>\n<a href=\"<tmpl_var rss.url.0.9>\">RSS 0.90</a>\n<a href=\"<tmpl_var rss.url.0.91>\">RSS 0.91</a>\n<a href=\"<tmpl_var rss.url.1.0>\">RSS 1.0</a>\n<a href=\"<tmpl_var rss.url.2.0>\">RSS 2.0</a>\n</p>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<h2>\n<tmpl_if channel.link>\n	<a href=\"<tmpl_var channel.link>\" target=\"_blank\"><tmpl_var channel.title></a>\n<tmpl_else>\n	<tmpl_var channel.title>\n</tmpl_if>\n</h2>\n\n<tmpl_if channel.description>\n	<tmpl_var channel.description><p />\n</tmpl_if>\n\n<ul>\n<tmpl_loop item_loop>\n\n<tmpl_if new_rss_site>\n<!-- We\'re in a new RSS group. Output the header. -->\n<h2><a href=\"<tmpl_var site_link>\" target=\"_blank\"><tmpl_var site_title></a></h2>\n</tmpl_if>\n\n<li>\n	<tmpl_if link>\n		<a href=\"<tmpl_var link>\"><tmpl_var title></a>\n	<tmpl_else>\n		<tmpl_var title>\n	</tmpl_if>\n	<tmpl_if description>\n		- <tmpl_var description>\n	</tmpl_if>\n<b><tmpl_var site_title></b>\n</li>\n</tmpl_loop>\n</ul>\n','SyndicatedContent',1,1,'DPUROtmpl0000000000001',1147642413,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if search.for>\n	<tmpl_if content>\n		<!-- Display search string. Remove if unwanted -->\n		<tmpl_var search.for>\n	<tmpl_else>\n		<!-- Error: Starting point not found -->\n		<b>Error: Search string <i><tmpl_var search.for></i> not found in content.</b>\n	</tmpl_if>\n</tmpl_if>\n\n<tmpl_var content>\n\n<tmpl_if stop.at>\n	<tmpl_if content.trailing>\n		<!-- Display stop search string. Remove if unwanted -->\n		<tmpl_var stop.at>\n	<tmpl_else>\n		<!-- Warning: End point not found -->\n		<b>Warning: Ending search point <i><tmpl_var stop.at></i> not found in content.</b>\n	</tmpl_if>\n</tmpl_if>\n','HttpProxy',1,1,'PBtmpl0000000000000033',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>\n	<tmpl_var title>\n</h2>\n\n<tmpl_var account.message>\n<tmpl_if account.form.karma>\n<br /><br />\n<table>\n<tr>\n	<td class=\"formDescription\">\n		<tmpl_var account.form.karma.label>\n	</td>\n	<td class=\"tableData\">\n	 	<tmpl_var account.form.karma>\n	</td>\n</tr>\n</table>\n</tmpl_if>\n\n<div class=\"accountOptions\">\n	<ul>\n		<tmpl_loop account.options>\n			<li><tmpl_var options.display></li>\n		</tmpl_loop>\n	</ul>\n</div>\n','Auth/LDAP/Account',1,1,'PBtmpl0000000000000004',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>\n   <tmpl_var title>\n</h2>\n<tmpl_if create.message>\n   <tmpl_var create.message>\n</tmpl_if>\n\n<tmpl_var create.form.header>\n<table>\n<tmpl_var create.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.ldapConnection.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.ldapConnection></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.ldapId.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.ldapId></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.password></td>\n</tr>\n<tmpl_loop create.form.profile>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var profile.formElement.label></td>\n   <td class=\"tableData\"><tmpl_var profile.formElement></td>\n</tr>\n</tmpl_loop>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\"><tmpl_var create.form.submit></td>\n</tr>\n</table>\n<tmpl_var create.form.footer>\n\n\n<div class=\"accountOptions\">\n   <ul>\n     <li><a href=\"<tmpl_var login.url>\"><tmpl_var login.label></a></li>\n \n  </ul>\n</div>','Auth/LDAP/Create',1,1,'PBtmpl0000000000000005',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>\n   <tmpl_var title>\n</h2>\n<tmpl_if login.message>\n   <tmpl_var login.message>\n</tmpl_if>\n\n<tmpl_var login.form.header>\n<table >\n<tmpl_var login.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.username.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.username></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.password></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\"><tmpl_var login.form.submit></td>\n</tr>\n</table>\n<tmpl_var login.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n             <tmpl_if anonymousRegistration.isAllowed>\n	     <li><a href=\"<tmpl_var createAccount.url>\"><tmpl_var createAccount.label></a></li>\n	  </tmpl_if>\n\n   </ul>\n</div>','Auth/LDAP/Login',1,1,'PBtmpl0000000000000006',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n             <tmpl_var username.label><br />\n             <tmpl_var username.form><br />\n             <tmpl_var password.label><br />\n             <tmpl_var password.form><br />\n             <tmpl_var form.login>\n	<tmpl_var form.footer>\n	<tmpl_if session.setting.anonymousRegistration>\n                        <p><a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a></p>\n	</tmpl_if>	\n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000044',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var forum.add.url>\"><tmpl_var forum.add.label></a>\n	<p />\n</tmpl_if>\n\n<tmpl_if areMultipleForums>\n	<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"defaultMessageBoard\">\n		<tr>\n			<tmpl_if session.var.adminOn>\n				<td></td>\n			</tmpl_if>\n			<td class=\"tableHeader\"><tmpl_var title.label></td>\n			<td class=\"tableHeader\"><tmpl_var views.label></td>\n			<td class=\"tableHeader\"><tmpl_var rating.label></td>\n			<td class=\"tableHeader\"><tmpl_var threads.label></td>\n			<td class=\"tableHeader\"><tmpl_var replies.label></td>\n			<td class=\"tableHeader\"><tmpl_var lastpost.label></td>\n		</tr>\n		<tmpl_loop forum_loop>			\n			<tr>\n				<tmpl_if session.var.adminOn>\n					<td><tmpl_var forum.controls></td>\n				</tmpl_if>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if>>\n					<a href=\"<tmpl_var forum.url>\"><tmpl_var forum.title></a><br />\n					<span style=\"font-size: 10px;\"><tmpl_var forum.description></span>\n				</td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.views></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.rating></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.threads></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.replies></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if>><span style=\"font-size: 10px;\">\n					<a href=\"<tmpl_var forum.lastpost.url>\"><tmpl_var forum.lastpost.subject></a>\n					by\n					<tmpl_if forum.lastpost.user.isVisitor>\n						<tmpl_var forum.lastpost.user.name>\n					<tmpl_else>\n						<a href=\"<tmpl_var forum.lastpost.user.profile>\"><tmpl_var forum.lastpost.user.name></a>\n					</tmpl_if>\n					on <tmpl_var forum.lastpost.date> @ <tmpl_var forum.lastpost.time>\n				</span></td>\n			</tr>\n		</tmpl_loop>\n	</table>\n<tmpl_else>\n	<h2><tmpl_var default.title></h2>\n	<tmpl_if session.var.adminOn>\n		<tmpl_var default.controls><br />\n	</tmpl_if>\n	<tmpl_var default.description>\n	<p />\n	<tmpl_var default.listing>\n</tmpl_if>\n\n\n','MessageBoard',1,1,'PBtmpl0000000000000047',1147642414,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultMessageBoard {\n\n}\n.defaultMessageBoard .tableHeader{\n	font-weight:bold;\n	border-bottom:solid gray 3px;\n	text-align:center;\n}\n.defaultMessageBoard td {\n	font-family:arial;\n	font-size:9pt;\n	border-bottom:solid gray 1px;\n}\n.defaultMessageBoard td a {\n	color:#29587E;\n}\n.defaultMessageBoard td.even {\n	background-color:#DADADA;\n	border-bottom:solid gray 1px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n</style>'),('\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.canViewReports>\n<table cellspacing=\"2\" cellpadding=\"1\" style=\"border:solid silver 1px;\">\n<tr>\n	<td colspan=\"4\">\n		<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\">\n		<tr>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.gradebook.url>\"><tmpl_var report.gradebook.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.overview.url>\"><tmpl_var report.overview.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var delete.all.responses.url>\"><tmpl_var delete.all.responses.label></a></td>\n		</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.answers.url>\"><tmpl_var export.answers.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.questions.url>\"><tmpl_var export.questions.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.responses.url>\"><tmpl_var export.responses.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.composite.url>\"><tmpl_var export.composite.label></a></td>\n</tr>\n</table>\n</tmpl_if>\n\n<br />\n<br />\n\n<script type=\"text/javascript\" defer=\"defer\">\n<!--\nfunction toggleDiv(divId) {\n   if (document.getElementById(divId).style.visibility == \"none\") {\n	document.getElementById(divId).style.display = \"block\";\n   } else {\n	document.getElementById(divId).style.display = \"none\";\n   }\n}\n//-->\n</script>\n\n<tmpl_loop question_loop>\n	<b><tmpl_var question></b>\n	<tmpl_if question.isRadioList>\n		<table class=\"tableData\">\n		<tr class=\"tableHeader\"><td style=\"width:60%\"><tmpl_var answer.label></td>\n		<td style=\"width:20%\"><tmpl_var response.count.label></td>\n		<td style=\"width:20%\"><tmpl_var response.percent.label></td></tr>\n		<tmpl_loop answer_loop>\n			<tmpl_if answer.isCorrect>\n				<tr class=\"highlight\">\n			<tmpl_else>\n				<tr>\n			</tmpl_if>\n			<td><tmpl_var answer></td>\n			<td><tmpl_var answer.response.count></td>\n			<td><tmpl_var answer.response.percent></td>\n			<tmpl_if allowComment>\n				<td><a href=\"#\" onclick=\"toggle(\'comment<tmpl_var answer.id>\');\"><tmpl_var show.comments.label></a></td>\n			</tmpl_if>\n			</tr>\n			<tmpl_if question.allowComment>\n				<tr id=\"comment<tmpl_var answer.id>\">\n				<td colspan=\"3\">\n				<tmpl_loop comment_loop>\n					<p><tmpl_var answer.comment></p>\n				</tmpl_loop>\n				</td>\n				</tr>\n			</tmpl_if>\n		</tmpl_loop>\n		</table>\n	<tmpl_else>\n		<br />\n		<a href=\"#\" onclick=\"toggle(\'response<tmpl_var question.id>\');\"><tmpl_var show.answers.label></a>\n		<br />\n		<div id=\"response<tmpl_var question.id>\">\n		<tmpl_loop answer_loop>\n			<p><tmpl_var answer.response></p>\n			<tmpl_if question.allowComment>\n				<blockquote><tmpl_var answer.comment></blockquote>\n			</tmpl_if>\n		</tmpl_loop>\n		</div>\n	</tmpl_if>\n	<br /><br /><br />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo20> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Survey/Overview',1,1,'PBtmpl0000000000000063',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\"><td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td></tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div>\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n	<tmpl_var dragger.init>\n</tmpl_if>\n','Layout',1,1,'PBtmpl0000000000000054',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if pluginsAvailable>\n   <tmpl_var message><br />\n    <tmpl_var formHeader>\n       <table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n    <tmpl_loop pluginLoop>\n            <tr>\n                        <td><tmpl_var formElement></td>\n                     <td align=\"left\"><tmpl_var name></td>\n           </tr>\n       </tmpl_loop>\n        </table>\n    <tmpl_var formSubmit>\n    <tmpl_var formFooter>\n<tmpl_else>\n <tmpl_var noPluginsMessage>\n</tmpl_if>','Commerce/SelectPaymentGateway',1,1,'PBtmpl0000000000000017',1147642414,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\n<tmpl_var form.header>\n<table class=\"popUp\" cellspacing=\"0\" cellpadding=\"3\" border=\"0\">\n<tbody>\n<tr>\n	<td align=\"right\" style=\"width:25%;\" class=\"header\">Task Name&nbsp;</td>\n	<td style=\"width:75%;\"><tmpl_var form.name></td>\n</tr>	\n<tr>\n	<td colspan=\"2\">\n		<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n		<tbody>\n		<tr class=\"clear\">\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Start&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.start></td>\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Finish&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.end></td>\n		</tr>\n		</tbody>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td colspan=\"2\">\n		<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n		<tbody>\n		<tr class=\"clear\">\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Duration&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.duration>&nbsp;<tmpl_var form.duration.units></td>\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Is Milestone&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.milestone></td>\n		</tr>\n		</tbody>\n		</table>\n	</td>\n</tr>	\n<tr>\n	<td colspan=\"2\">\n		<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n		<tbody>\n		<tr class=\"clear\">\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Predecessor&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.dependants></td>\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">% Complete&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.percentComplete></td>\n		</tr>\n		</tbody>\n		</table>\n	</td>\n</tr>	\n<tr>\n	<td colspan=\"2\">\n		<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n		<tbody>\n		<tr class=\"clearNoBG\">\n			<td style=\"width:25%;\" align=\"right\" class=\"header\">Resource&nbsp;</td>\n			<td style=\"width:25%;\"><tmpl_var form.resource></td>\n			<td style=\"width:25%;\">&nbsp;</td>\n			<td style=\"width:25%;\" align=\"right\" class=\"header\"><a href=\"javascript:void(checkEditTaskForm(document.editTaskForm))\" class=\"saveBtn\">Save</a></td>\n		</tr>\n		</tbody>\n		</table>\n	</td>		\n</tr>	\n</tbody>\n</table>\n<tmpl_var form.footer>\n\n','ProjectManager_editTask',1,1,'ProjectManagerTMPL0004',1147642415,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<script>\n   var taskArray=<tmpl_var project.task.array>;\n</script>\n<div class=\"barPositions\">\n   <tmpl_loop task.div.loop>\n      <tmpl_if task.isMilestone>      \n	     <div class=\"milestone\" style=\"left:<tmpl_var task.div.left>px;top:<tmpl_var task.div.top>px;\">&diams;</div>\n	  <tmpl_else>\n	     <div class=\"projectBar\" style=\"left:<tmpl_var task.div.left>px;top:<tmpl_var task.div.top>px;width:<tmpl_var task.div.width>px;\">	 \n		    <div class=\"statusBar\" style=\"width:<tmpl_var task.div.percentComplete>%;\"></div>\n            <tmpl_if task.hasPredecessor>   \n		       <div class=\"projectLineH\" style=\"top:4px;left:50px;width:75px;height:28px;\">\n	              <div class=\"projectLineV\"></div>\n		       </div>\n	        </tmpl_if>\n	        <tmpl_if task.hasResource>\n		       <div class=\"projectLabel\" style=\"left:<tmpl_var task.div.label.left>px;top:3px;margin-top:-3px;\">\n		          <tmpl_var task.resource.name>			\n		       </div>\n	        </tmpl_if> \n		 </div>\n	  </tmpl_if>	  \n   </tmpl_loop>\n   <a name=\"<tmpl_var project.table.width>\" id=\"projectTableWidth\"></a>\n   <a name=\"<tmpl_var project.scroll.percentWidth>\" id=\"projectScrollPercentWidth\"></a>\n   <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:<tmpl_var scrollWidth>px;z-index:1;\">\n      <tr class=\"monthNames\">\n	     <tmpl_loop months.loop>\n		    <td colspan=\"<tmpl_var month.colspan>\" class=\"monthName\" style=\"height:20px;\"><tmpl_var month.name></td>\n		 </tmpl_loop>\n	  </tr>	\n	  <tr class=\"dates\">\n	     <tmpl_loop days.loop>\n		    <td  align=\"center\" style=\"width:23px\"><tmpl_var day.number></td>\n		 </tmpl_loop>\n	  </tr>\n	  <tmpl_loop task.count.loop>\n	     <tr>\n		    <td colspan=\"<tmpl_var total.colspan>\" class=\"empty\" style=\"height:21px;\">&nbsp;</td>\n	     </tr>\n	  </tmpl_loop>\n   </table>\n   <br />\n</div>\n\n','ProjectManager_gantt',1,1,'ProjectManagerTMPL0003',1147642415,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<script type=\"text/javascript\" src=\"<tmpl_var extras.base>/js/at/AjaxRequest.js\"></script>\n<script type=\"text/javascript\" src=\"<tmpl_var extras.base>/js/modal/modal.js\"></script>\n\n<script src=\"<tmpl_var extras.base>/calendar/calendar.js\" type=\"text/javascript\"></script>\n<script src=\"<tmpl_var extras.base>/contextMenu/contextMenu.js\" type=\"text/javascript\"></script>\n<script src=\"<tmpl_var extras.base>/calendar/lang/calendar-en.js\" type=\"text/javascript\"></script>\n<script src=\"<tmpl_var extras.base>/calendar/calendar-setup.js\" type=\"text/javascript\"></script>\n\n<script type=\"text/javascript\">\n    var dayMS = 86400000;\n	\n	var popTitle = \"Add/Edit Task\";\n	\n	var dunits = \"<tmpl_var project.durationUnits>\";\n	var hoursPerDay = <tmpl_var project.hoursPerDay>;\n	var taskLength=<tmpl_var project.task.length>;\n	\n   //--------------------------------------------------------------------------------------	\n	function doCalendar (fieldId) {\n	   Calendar.setup({ \n                         inputField : fieldId, \n                         ifFormat : \"%Y-%m-%d\", \n                         showsTime : false, \n                         step : 1,\n                         timeFormat : \"12\",\n                         firstDay : false\n                    }); \n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function closeImage() {\n       return \'<tmpl_var extras>/close.gif\';\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function configureMilestone(box) {\n	   var form = box.form;\n	   if(box.checked==true) { \n	      form.end.value=form.start.value; \n		  form.duration.value=0; \n		  form.duration.disabled=true; \n		  form.end.disabled=true;\n		  form.dependants.disabled=true;\n		  form.resource.disabled=true;\n		  form.percentComplete.disabled=true;\n		  form.percentComplete.value=0;\n	   } else { \n	      form.end.disabled=false; \n		  form.duration.disabled=false; \n		  form.dependants.disabled=false;\n		  form.resource.disabled=false;\n		  form.percentComplete.disabled=false;\n		  form.duration.value = (dunits == \"hrs\")?hoursPerDay:1;\n	   }\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function checkEditTaskForm (form) {\n	   if(form.name.value == \"\") {\n	      alert(\"<tmpl_var form.name.error>\");\n		  return;\n	   } else if(form.start.value == \"\") {\n	      alert(\"<tmpl_var form.start.error>\");\n		  return;\n	   } else if(form.milestone.checked==false && form.end.value == \"\") {\n	      alert(\"<tmpl_var form.end.error>\");\n		  return;\n	   }\n	   form.submit();\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function intlDate(dateObj) {\n	   return dateObj.getFullYear()+\"-\"+pad((dateObj.getMonth()+1))+\"-\"+pad(dateObj.getDate());\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function toDateObj(date) {\n	   var to = date.split(\"-\");\n	   var dateObj = new Date(to[0],(to[1]-1),to[2],0,0,1,0);\n	   return dateObj;\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function adjustTaskTimeFromDuration(start, end, duration, isTaskForm, predecessor, origStart, origEnd, seqNum) {\n	   //set the form element\n	   var form = duration.form;\n	   \n	   //get today\'s date\n	   var today = new Date();\n	   var todayIntl = intlDate(today);\n	   //set start and end date if not already set\n	   if(start.value == \"\") start.value = todayIntl;\n	   if(end.value == \"\") end.value = todayIntl;\n	   	   \n	   //Convert predecessor hours to days\n	   var taskDuration = duration.value;\n	   if(dunits == \"hrs\") taskDuration = taskDuration / hoursPerDay;\n	   var durationFloor = Math.floor(taskDuration);\n	   \n	   //Handle task form and main form seperately due to differences in the forms\n	   if(isTaskForm && taskDuration <= 0) {\n	      //Convert to milestone if task is less or equal to zero\n	      if(confirm(\"Zero duration tasks are considered Milestones.  Do you wish to change this task to a milestone?\")) {\n		     form.milestone.checked = true;\n			 configureMilestone(form.milestone);\n		  } else {\n			 duration.value = form.orig_duration.value;\n	      }\n		  return;\n	   } else if (taskDuration <= 0){\n	      //Do not let users zero out tasks\n		  alert(\"Zero duration tasks are considered Milestones.  Please edit the task by clicking the link if you wish to change this task to a milestone\");\n		  return;\n	   }\n	   \n	   //create the start date \n	   var aTo = start.value.split(\"-\");\n	   var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n       \n	   //add new duration days to the start date\n       toDate.setDate(toDate.getDate() + durationFloor);\n			  \n	   //set end date to this date\n	   end.value = intlDate(toDate);\n	   \n	   //Set new duration in taskArray\n	   taskArray[seqNum][\"duration\"] = duration.value;\n	   //Adjust time based on new end date\n	   adjustTaskTimeFromDate(start, end, duration, end, isTaskForm, predecessor, origStart, origEnd, seqNum);\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function adjustTaskTimeFromDate (start, end, duration, element, isTaskForm, predecessor, origStart, origEnd, seqNum) {\n	   //set the form element\n	   var form = element.form;\n	   //set original duration from task form to determine whether or not to continue to set duration\n	   var orig_duration;\n	   \n	   if(isTaskForm) {\n	      if(form.milestone.checked == true) return;\n          orig_duration = form.orig_duration.value;\n	   }\n	   \n	   if (end.value == \"\") end.value = start.value;\n	   else if(start.value == \"\") start.value = end.value;\n	   \n	   if(isTaskForm && orig_duration == \"\") {\n	      //Set duration if this is a new record\n		  //Check to make sure start date comes before end date\n		  var startcomp = start.value.replace(/-/g,\"\");\n	      var endcomp = end.value.replace(/-/g,\"\");\n	      if(startcomp > endcomp) {\n	         alert(\"<tmpl_var form.greaterthan.error>\");\n		     if(element.name == \"start\") {\n		        end.value = element.value;\n		     } else {\n		        start.value = element.value;\n		     }\n		     duration.value = (dunits == \"hrs\")?hoursPerDay:1;\n		     return;\n	      }\n	   \n	      var d = getDaysInterval(start.value,end.value);\n		  if(d == 0) d = 1;\n	      if(dunits == \"hrs\") {\n	         d = d * hoursPerDay;\n	      }\n	      duration.value = d;\n	   } else {\n	      //Set start/end if duration has been saved\n		  var d = duration.value; \n		  if(dunits == \"hrs\") {\n		     //Convert to days\n		     d = d / hoursPerDay;\n		  }\n	      //Round off duration or set it to zero if less than 1;\n		  //alert(\"d = \" + d + \" floor = \" + Math.floor(d));\n		  if(d < 1) d = 0;\n		  else d = Math.floor(d);\n		  \n		  if(element.name.indexOf(\"start\") > -1) {\n		     //create the date \n			  var aTo = start.value.split(\"-\");\n			  var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n             //add duration days to the start date\n              toDate.setDate(toDate.getDate() + d);\n			  //set end date to this date\n			  end.value = intlDate(toDate);\n		  } else if(element.name.indexOf(\"end\") > -1) {\n		      //create the date\n			  var aFrom = end.value.split(\"-\");\n			  var fromDate = new Date(aFrom[0],(aFrom[1]-1),aFrom[2],0,0,1,0);\n			  //subtract duration days from the end date\n			  fromDate.setDate(fromDate.getDate() - d);\n			  //set start date to this date\n			  start.value = intlDate(fromDate);\n		  }\n	   }\n	   \n	   //Check Predecessors before moving stuff\n	   var pred = predecessor.value;\n	   if(pred != \"\") {\n		  //Check to make sure that the dependency requirement for this task is still valid\n		  //Get the predecessor end date\n	      var taskStart = toDateObj(start.value);\n		  var predTaskEnd;\n		  if(isTaskForm) {\n		     predTaskEnd = toDateObj(taskArray[pred][\"end\"]);\n		  } else {\n		     var predTaskEndId = \"end_\"+taskArray[pred][\"id\"]+\"_formId\"\n		     predTaskEnd = toDateObj(document.getElementById(predTaskEndId).value);\n		  }\n		  \n		  if(taskStart.getTime() < predTaskEnd.getTime()) {\n		     alert(\"<tmpl_var form.invalidMove.error>\");\n			 start.value = origStart.value;\n			 end.value = origEnd.value;\n			 return;\n		  }\n	   }\n	   \n	   //Check all tasks past this one and move them forward if necessary (this only needs to happen on the main form)\n	   if(!isTaskForm) {\n	      arrangePredecessors(element,seqNum);\n	   }\n	   //reset orig start and end values\n	   origStart.value = start.value;\n	   origEnd.value = end.value;\n	   \n	   if(!isTaskForm) {\n	      //Adjust task form for \n	      paintGanttChart();\n	   }\n	}\n   \n   //--------------------------------------------------------------------------------------\n   function trim(str) {\n      return str.replace(/^\\s+|\\s+$/, \'\');\n   }\n	\n   //--------------------------------------------------------------------------------------\n   function arrangePredecessors (element,seqNum) {\n  	  \n	  for (var i = 1; i <= taskLength; i++) {\n	     var seq = i;\n		 var task = taskArray[seq];\n		 var taskId = task[\"id\"];\n		 //Calculate duration and duraiton floor\n		 var durationInDays = parseFloat(task[\"duration\"]);\n		 if(dunits == \"hrs\") durationInDays = durationInDays / hoursPerDay;\n		 var durationFloor = Math.floor(durationInDays);\n		 //alert(\"Duration Floor is: \"+durationFloor);\n		 //Get the current elements\n		 var currElementStart = document.getElementById(\"start_\"+taskId+\"_formId\");\n	     var currElementEnd = document.getElementById(\"end_\"+taskId+\"_formId\");\n		 //alert(\"Current Start Date: \"+currElementStart.value+\"   Current End Date: \"+currElementEnd.value);\n		 //Skip the first record as it is the record that was changed\n		 if(seq > 1) {\n		    var predecessor = task[\"predecessor\"];\n			//alert(\"predecessor for \"+i+\" is \"+predecessor);\n			if(predecessor != \"\") {\n			   var pred = taskArray[predecessor];\n			   var predEndDate = toDateObj(pred[\"end\"]);\n			   var startDate = toDateObj(task[\"start\"]);\n			   //alert (\"Pred End Date: \"+intlDate(predEndDate));\n			   //Make sure start date of this task is greater than the end date of the predecessor\n			   if(startDate.getTime() <= predEndDate.getTime()) {\n			      //Change the start and end dates of the task\n				  //Get the day part of the predecessor\n				  var predDayPart = parseFloat(pred[\"dayPart\"]);\n				  //alert(\"predDayPart: \"+predDayPart);\n				  if(predDayPart > 0) {\n				     //The previous task took up part of a day.  Add the additional day part to the duration\n					 durationInDays += predDayPart;\n					 durationFloor = Math.floor(durationInDays);\n				  }\n				  //alert(\"Duration in Days: \"+durationInDays+\" Duration Floor: \"+durationFloor);\n				  //Set the start date of this task to the end date of the predecessor\n				  currElementStart.value = pred[\"end\"];\n				  //Adjust end date for change in start date and update the object - start date is actually predEndDate now, so use the existing date object\n				  predEndDate.setDate(predEndDate.getDate() + durationFloor);\n				  currElementEnd.value = intlDate(predEndDate);\n				 //alert(\"Set seq \"+i+\" to start: \"+pred[\"end\"]+\" end: \"+intlDate(predEndDate));\n			   }\n			}\n		 }\n		  \n		 //Update task array with new start/end values\n		 taskArray[seq][\"start\"] = currElementStart.value;\n		 taskArray[seq][\"end\"] = currElementEnd.value;\n		 taskArray[seq][\"dayPart\"] = (durationInDays - Math.floor(durationInDays));\n	  }\n   }\n	\n   //--------------------------------------------------------------------------------------	\n	function getDaysInterval(from,to) {\n       var aFrom = from.split(\"-\");\n	   var aTo = to.split(\"-\");\n	   var fromDate = new Date(aFrom[0],(aFrom[1]-1),aFrom[2],0,0,1,0);\n	   var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n	   var fromEpoch = fromDate.getTime();\n	   var toEpoch = toDate.getTime();\n	  \n	   var seconds = toEpoch - fromEpoch;\n	   if(seconds == 0) return 0;\n	   return (seconds/dayMS);\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function pad(date) {\n       var str = \"\"+date;\n       if(str.length == 1) {\n	      str = \"0\"+str;\n	   }\n	   return str;\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function paintGanttChart () {\n	   var status = AjaxRequest.submit(document.forms[\'editAll\'],{\n                                      \'onSuccess\':function(req){ document.getElementById(\'gantt\').innerHTML = req.responseText; }\n                                     });\n       \n	   var mwidth = document.getElementById(\"projectTableWidth\").name + \"px\";\n	   var swidth = document.getElementById(\"projectScrollPercentWidth\").name + \"%\";\n	   document.getElementById(\"mastertable\").style.width=mwidth;\n	   document.getElementById(\"scrolltd\").style.width=swidth;\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function validateDependant(field,origField,seqNum,start,end,duration,isTaskForm,origStart,origEnd) {\n	   var pred = field.value;\n	   var newTask = false;\n	   if(pred != \"\") {\n	      if(seqNum == \"\") seqNum = taskLenth+1;\n		  if(pred < 1) {\n	         alert(\"<tmpl_var form.noPredecessor.error>\");\n		     field.value=origField.value;\n		     return;\n	      }\n	      if(pred == seqNum) {\n	         alert(\"<tmpl_var form.samePredecessor.error>\");\n		     field.value=origField.value;\n		     return;\n	      }\n	      if(pred > seqNum) {\n	         alert(\"<tmpl_var form.previousPredecessor.error>\");\n		     field.value = origField.value;\n		     return; \n	      }\n		  \n	      //Set defaults if it\'s a new record and one of the other options hasn\'t been checked.\n	      if(start.value == \"\" || end.value == \"\") {\n             //get today\'s date\n			 newTask = true;\n			 duration.value = (dunits == \"hrs\")?hoursPerDay:1; \n		  }\n	      //Get the predecessor end date and decide where the new start date belongs\n	      var taskStart = start.value;\n		  var taskStartObj = toDateObj(taskStart);\n		  var predTaskEnd = taskArray[pred][\"end\"];\n		  var predTaskEndObj = toDateObj(predTaskEnd);\n		  \n		  //Change start date if it comes before predecessor end date\n		  if(newTask || (taskStartObj.getTime() < predTaskEndObj.getTime())) {\n		     \n			 //Convert predecessor hours to days\n	         var taskDuration = duration.value;\n			 if(dunits == \"hrs\") taskDuration = taskDuration / hoursPerDay;\n			 var durationFloor = Math.floor(taskDuration);\n			 \n			 //Get the predecessor dayPart\n			 var predDayPart = parseFloat(pred[\"dayPart\"]);\n		     if(predDayPart > 0) {\n		        //The previous task took up part of a day.  Add the additional day part to the duration\n			    taskDuration += predDayPart;\n				durationFloor = Math.floor(durationInDays);\n			 }\n	         \n			 //Set the start date of this task to the end date of the predecessor\n		     start.value = predTaskEnd;\n			 //Adjust end date for change in start date\n	         adjustTaskTimeFromDate(start,end,duration,start,isTaskForm,field,origStart,origEnd,seqNum);\n			 return;\n		  }\n	   }\n	   \n	   //Set new predecessor in taskArray\n	   taskArray[seqNum][\"predecessor\"] = pred;\n	   \n	   //Repaint\n	   if(!isTaskForm) {\n	      paintGanttChart();\n	   }\n	}\n   \n    addEvent(window, \"load\", initPopUp);\n</script>\n<tmpl_var form.header>\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"project\" id=\"mastertable\" style=\"width:<tmpl_var project.table.width>px;\">\n<tr>\n	<td style=\"width:20px;height:20px;\">&nbsp;</td>\n	<td style=\"width:300px;\" align=\"center\">Task Name</td>\n	<td style=\"width:70px;\" align=\"center\">Duration</td>\n	<td style=\"width:70px;\" align=\"center\">Start</td>\n	<td style=\"width:70px;\" align=\"center\">Finish</td>\n	<td style=\"width:30px;\" align=\"center\">Pred</td>\n	<td rowspan=\"<tmpl_var project.gaant.rowspan>\" valign=\"top\" id=\"scrolltd\" style=\"border-style:none;width:<tmpl_var project.scroll.percentWidth>%;\">\n		<div class=\"scroller\" id=\"gantt\">\n			<tmpl_var project.ganttChart>\n		</div>\n	</td>\n</tr>\n<tr>\n	<td colspan=\"6\">&nbsp;</td>\n</tr>\n<tmpl_loop task.loop>\n   <tr>\n	   <td align=\"center\" style=\"height:20px\"><tmpl_var task.number></td>\n	   <td align=\"left\" style=\"height:20px\">\n	      <tmpl_if task.canAdd>\n		     <a href=\"<tmpl_var task.edit.url>\" class=\"submodal\"><tmpl_var task.name></a>\n		  <tmpl_else>\n		     <tmpl_var task.name>\n		  </tmpl_if>\n	   </td>\n	   <td align=\"center\" style=\"height:20px\"><tmpl_var task.duration> <tmpl_var task.duration.units></td>\n	   <td align=\"center\" style=\"height:20px\"><tmpl_var task.start></td>\n	   <td align=\"center\" style=\"height:20px\"><tmpl_var task.end></td>\n	   <td align=\"center\" style=\"height:20px\"><tmpl_var task.dependants></td>	\n   </tr>\n</tmpl_loop>\n<tr>\n	<td colspan=\"6\" style=\"border-style:none;\">&nbsp;</td>\n</tr>\n<tr>\n	<td colspan=\"6\" style=\"border-style:none;\">&nbsp;</td>\n</tr>\n</table>\n<tmpl_var form.footer>\n\n<div id=\"links\">\n<!-- 	<tmpl_if project.canEdit><a href=\"<tmpl_var task.resources.url>\"><tmpl_var task.resources.label></a>&nbsp;|&nbsp;</tmpl_if> -->\n	<tmpl_if task.canAdd><a href=\"<tmpl_var task.add.url>\" class=\"submodal\"><tmpl_var task.add.label></a>&nbsp;|&nbsp;</tmpl_if>\n	<a href=\"<tmpl_var task.back.url>\"><tmpl_var task.back.label></a>\n</div>\n\n','ProjectManager_project',1,1,'ProjectManagerTMPL0002',1147642415,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	body, html {\n		margin:0px;\n		padding:0px;\n	}\n	.project {\n		position:relative;\n		margin-top:5px;\n		margin-left:5px;\n	}\n	.project td {\n		border:solid silver 1px;\n		border-bottom:solid gray 1px;\n		font-size:9pt;\n		font-family:arial;		\n	}\n	.project a {\n	    color:#000000;\n		font-weight: normal;\n		font-size: 9pt;\n		text-decoration: none;\n	}\n	\n	.project a:hover {\n	    color:#7AB7E9;\n		font-weight: normal;\n		font-size: 9pt;\n		text-decoration: none;\n	}\n	\n	.taskname {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 295px;\n    }\n	.taskduration {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 25px;\n	}\n	.taskdate {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 68px;\n	}\n	.taskdependant {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 20px;\n	}\n	tr.monthNames td {		\n		text-align:center;		\n	}\n	tr.dates td {\n		width:16px;\n	}\n	div.scroller {		\n		overflow:scroll;		\n		position:relative;\n		width:400px;		\n	}\n	\n	* html div.scroller {\n		overflow-x:scroll;\n	}\n	\n	td.empty {\n		background-color:transparent;\n		border-style:none;\n		height:20px;\n	}\n	\n	div.barPositions {\n		position:relative;\n	}\n	div.projectBar {\n		background-color:#7AB7E9;\n		position:absolute;\n		height:10px;\n		z-index:2;\n		padding:0px;\n		margin:0px;\n		font-size:1pt;\n	}\n	div.statusBar {	\n		background-color:#000;\n		position:absolute;	\n		height:5px;\n		z-index:3;\n		padding:0px;\n		top:2px;\n		margin:0px;		\n		font-size:1pt;		\n	}\n	\n	div.projectLineH {		\n		background: url(\'images/dot.gif\') top repeat-x;		\n		font-size:1pt;\n		text-align:right;\n		position:absolute;\n	}		\n	div.projectLineV {\n		width:1px;\n		background-color:black;\n		position:relative;\n		font-size:1pt;	\n		height:100%;\n		float:right;\n	}\n	\n	div.projectLabel {\n		position:absolute;\n		margin-top:-3px;\n		white-space:nowrap;\n		font-family: verdana;\n		font-size:8px;\n	}\n	\n	div.milestone {\n		color:#000000;\n		position:absolute;\n		z-index:4;\n		margin:0px;\n		padding:0px;		\n		margin-top:-3px;\n		font-size: 10px;\n		font-family: times;\n	}\n	\n	#links {\n		margin-top:7px;\n		margin-left:5px;\n		font-family:arial;\n		font-size:9pt;\n	}\n	\n	#links a {\n		color:#7AB7E9;\n	}\n</style>\n\n<style>\n.popUp {\n			width:100%;\n			border:solid black 0px;\n			background-color:#F5F5F5;\n		}\n		.popUp td {\n			font-size:9pt;	\n			font-family:arial;\n			border-top:solid #E0E0E0 1px;\n		}	\n		.popUp tr.clear td {\n			border-style:none;\n			background-color:#F0F0F0;\n		}\n		.popUp tr.clearNoBG td {\n			border-style:none;\n		}\n		.popUp td.header {\n			font-weight:bold;\n		}\n		a.saveBtn {\n			width:40px;\n			height:15px;\n			background-color:silver;\n			padding:1px;\n			padding-left:5px;\n			padding-right:5px;\n			color:white;\n			border:solid gray 1px;\n			text-decoration:none;\n			font-weight:bold;\n			display:block;\n			float:right;\n			text-align:center;\n		}\n		a.saveBtn:hover {\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n</style>'),('<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<script>\n   function doDelete(url) {\n      if( confirm(\'<tmpl_var project.delete.warning>\') ) {\n	     location.href=url;\n	  }\n   }\n</script>\n\n<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\" class=\"projectView\">\n   <tr>\n	   <td colspan=\"3\" style=\"border-style:none;text-align:left;\" valign=\"bottom\">\n		   <a href=\"<tmpl_var project.create>\"><tmpl_var project.create.label></a>\n	   </td>\n	   <td style=\"border-style:none;text-align:right\" colspan=\"3\">\n	      <form action=\"\" style=\"margin:0px;\">\n		     <p style=\"margin:0px;\">\n			    <select>\n				   <option>All Projects</option>\n				</select>			\n			 </p>\n		  </form>\n	   </td>\n    </tr>\n\n    <tr class=\"header\">\n	   <td><tmpl_var project.name.label></td>\n	   <td><tmpl_var project.startDate.label></td>\n	   <td><tmpl_var project.endDate.label></td>\n	   <td><tmpl_var project.cost.label></td>\n	   <td><tmpl_var project.complete.label></td>\n	   <tmpl_if canEditProjects>\n	      <td><tmpl_var project.actions.label></td>\n	   </tmpl_if>\n    </tr>\n	<tmpl_if noProjects>\n	   <tr><td class=\"projectNames\" colspan=\"<tmpl_var empty.colspan>\"><tmpl_var noProjects></td></tr>\n	<tmpl_else>\n	   <tmpl_loop project.loop>\n	      <tr class=\"alt\">\n	         <td class=\"projectNames\">\n			    <a href=\"<tmpl_var project.view.url>\"><tmpl_var project.name.data></a>\n			 </td>\n	         <td><tmpl_var project.startDate.data></td>\n	         <td><tmpl_var project.endDate.data></td>\n	         <td><tmpl_var project.cost.data.int></td>\n	         <td>\n		        <div class=\"completeContainer\">\n			       <div class=\"completeBar\" style=\"width:<tmpl_var project.complete.data.int>%;\"></div>\n			       <div class=\"completeText\"><tmpl_var project.complete.data.float>%</div>\n		        </div>	\n	         </td>\n			 <tmpl_if canEditProjects>\n	            <td>\n			        <!-- <a href=\"#\"><img src=\"<tmpl_var extras>/add.gif\" style=\"border-style:none;\" alt=\"\" /></a>&nbsp; -->\n				   <a href=\"<tmpl_var project.edit.url>\"><img src=\"<tmpl_var extras>/edit.gif\" style=\"border-style:none;\" title=\"<tmpl_var project.edit.title>\" /></a>&nbsp;\n				   <a href=\"javascript:void(doDelete(\'<tmpl_var project.delete.url>\'));\"><img src=\"<tmpl_var extras>/delete.gif\" style=\"border-style:none;\" title=\"<tmpl_var project.delete.title>\" /></a>\n			    </td>\n             </tmpl_if>\n		  </tr>\n	   </tmpl_loop>\n	</tmpl_if>\n</table>\n\n','ProjectManager_dashboard',1,1,'ProjectManagerTMPL0001',1147642415,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n   .fontSettings {\n	 font-family:arial;\n	 font-size:9pt;\n   }\n   \n   .projectView td {\n      border:solid silver 1px;\n	  border-bottom:solid gray 1px;\n	  font-size:9pt;\n	  font-family:arial;			\n   }\n   .projectView a {\n	  color:#3391DD;\n   }\n   tr.header td {\n	  font-weight:bold;\n   }\n   td.projectNames {\n	  white-space:nowrap;			\n   }\n   td.projectNames a {\n	  display:block;\n	  color:#3391DD;\n   }\n   td.projectNames a.level1 {\n	  margin:0 10px;			\n   }\n   td.projectNames a.level2 {\n	  margin:0px 10px 0px 20px;\n   }\n   td.projectNames a.level3 {\n	  margin:0px 10px 0px 30px;			\n   }	\n   td.projectNames a.level4 {\n	  margin:0px 10px 0px 40px;			\n   }		\n   td.projectNames a.level5 {\n      margin:0px 10px 0px 50px;			\n   }		\n   tr.alt td {\n	  background-color:#F0F0F0;\n   }\n   div.completeContainer {\n	  position:relative;\n	  z-index:0;\n	  background: #000;\n	  color:white;\n	  text-align:center;\n   }\n   div.completeBar {\n	  position:absolute;\n	  height:100%;\n	  top:0px;\n	  left:0px;\n	  background: #7AB7E9;\n	  z-index:1;\n   }\n   div.completeText {\n	  position:relative;\n	  height:100%;\n	  top:0px;\n	  left:0px;			\n	  z-index:2;			\n   }\n</style>'),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<div class=\"fontSettings\">\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<span class=\"pollQuestion\"><tmpl_var question></span><br />\n\n<tmpl_if canVote>\n	<tmpl_var form.start>\n	<tmpl_loop answer_loop>\n		<tmpl_var answer.form> <tmpl_var answer.text><br />\n	</tmpl_loop>\n	<p />\n	<tmpl_var form.submit>\n	<tmpl_var form.end>\n<tmpl_else>\n	<tmpl_if hasImageGraph>\n		<img src=\"<tmpl_var graphUrl>\" />\n	<tmpl_else>\n		<tmpl_loop answer_loop>\n			<span class=\"pollAnswer\"><tmpl_var answer.text><br /></span>\n			<table cellpadding=0 cellspacing=0 border=0>\n			<tr>\n				<td width=\"<tmpl_var answer.graphWidth>\" class=\"pollColor\">^Spacer(1,1);</td>\n				<td class=\"pollAnswer\">&nbsp;&nbsp;<tmpl_var answer.percent>% (<tmpl_var answer.total>)</td>\n			</tr>\n			</table>\n		</tmpl_loop>\n		<span class=\"pollAnswer\"><hr size=\"1\"><b><tmpl_var responses.label>:</b> <tmpl_var responses.total></span>\n	</tmpl_if>\n</tmpl_if>\n</div>\n\n\n','Poll',1,1,'PBtmpl0000000000000055',1147642415,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.pollQuestion {\n	border-bottom:solid gray 1px;\n	font-family:arial;\n	font-size:10pt;\n	font-weight:bold;				\n}\n.pollColor {\n	background-color:gray;\n}\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if preview.title>\n	<p><b><tmpl_var preview.title></b></p>\n</tmpl_if>\n\n<tmpl_if preview.content>\n	<p><tmpl_var preview.content></p>\n</tmpl_if>\n\n<h2><tmpl_var message.header.label></h2>\n\n<tmpl_var form.header>\n<table class=\"defaultPostForm\">\n	<tmpl_if isNewPost>\n		<tmpl_if user.isVisitor>\n			<tr>\n				<td><tmpl_var visitorName.label></td>\n				<td><tmpl_var visitorName.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td><tmpl_var subject.label></td>\n		<td><tmpl_var title.form></td>\n	</tr>\n	<tr>\n		<td><tmpl_var message.label></td>\n		<td><tmpl_var content.form></td>\n	</tr>\n	<tmpl_if attachment.form>\n		<tr>\n			<td><tmpl_var attachment.label></td>\n			<td><tmpl_var attachment.form></td>\n		</tr>\n	</tmpl_if>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<p><b><tmpl_var reply.title></b></p>\n	<tmpl_var reply.content>\n</tmpl_if>\n\n\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000029',1147642415,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<table width=\"100%\" cellpadding=\"3\" cellspacing=\"3\" class=\"defaultProduct\">\n<tr>\n	<td class=\"content\" valign=\"top\">\n		<tmpl_if description><tmpl_var description><p /></tmpl_if>\n		<tmpl_if price><b>Price:</b> <tmpl_var price><br /></tmpl_if>\n		<tmpl_if productnumber><b>Product Number:</b> <tmpl_var productNumber><br /></tmpl_if>\n		<br />\n		<tmpl_if brochure.url><a href=\"<tmpl_var brochure.url>\"><img src=\"<tmpl_var brochure.icon>\" alt=\"<tmpl_var brochure.icon>\" border=0 align=\"absmiddle\" /><tmpl_var brochure.label></a><br /></tmpl_if>\n		<tmpl_if manual.url><a href=\"<tmpl_var manual.url>\"><img src=\"<tmpl_var manual.icon>\" alt=\"<tmpl_var manual.icon>\" border=0 align=\"absmiddle\" /><tmpl_var manual.label></a><br /></tmpl_if>\n		<tmpl_if warranty.url><a href=\"<tmpl_var warranty.url>\"><img src=\"<tmpl_var warranty.icon>\" alt=\"<tmpl_var warranty.icon>\" border=0 align=\"absmiddle\" /><tmpl_var warranty.label></a><br /></tmpl_if>\n	</td>\n	<td valign=\"top\" class=\"defaultProduct\">\n		<tmpl_if thumbnail1><a href=\"<tmpl_var image1>\"><img src=\"<tmpl_var thumbnail1>\" alt=\"<tmpl_var thumbnail1>\" class=\"noBorder\" /></a><p /></tmpl_if>\n		<tmpl_if thumbnail2><a href=\"<tmpl_var image2>\"><img src=\"<tmpl_var thumbnail2>\" alt=\"<tmpl_var thumbnail2>\" class=\"noBorder\" /></a><p /></tmpl_if>\n		<tmpl_if thumbnail3><a href=\"<tmpl_var image3>\"><img src=\"<tmpl_var thumbnail3>\" alt=\"<tmpl_var thumbnail3>\" class=\"noBorder\" /></a><p /></tmpl_if>\n	</td>\n</tr>\n</table>\n\n<table border=\"0\" cellpadding=\"3\" cellspacing=\"5\" class=\"defaultProduct\">\n<tr>\n	<td valign=\"top\" class=\"productFeature\">\n		<div class=\"productFeatureHeader\">Features</div>\n		<tmpl_if session.var.adminOn><a href=\"<tmpl_var addfeature.url>\"><tmpl_var addfeature.label></a><p /></tmpl_if>\n		<tmpl_loop feature_loop>\n			<tmpl_if session.var.adminOn><tmpl_var feature.controls></tmpl_if>\n			<tmpl_var feature.feature><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td valign=\"top\" class=\"productBenefit\">\n		<div class=\"productBenefitHeader\">Benefits</div>\n		<tmpl_if session.var.adminOn><a href=\"<tmpl_var addBenefit.url>\"><tmpl_var addBenefit.label></a><p /></tmpl_if>\n		<tmpl_loop benefit_loop>\n			<tmpl_if session.var.adminOn><tmpl_var benefit.controls></tmpl_if>\n			<tmpl_var benefit.benefit><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td valign=\"top\" class=\"productSpecification\">\n		<div class=\"productSpecificationHeader\">Specifications</div>\n		<tmpl_if session.var.adminOn><a href=\"<tmpl_var addSpecification.url>\"><tmpl_var addSpecification.label></a><p /></tmpl_if>\n		<tmpl_loop specification_loop>\n			<tmpl_if session.var.adminOn><tmpl_var specification.controls></tmpl_if>\n			<b><tmpl_var specification.label>:</b> <tmpl_var specification.specification> <tmpl_var specification.units><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td valign=\"top\" class=\"productAccessory\">\n		<div class=\"productAccessoryHeader\">Accessories</div>\n		<tmpl_if session.var.adminOn><a href=\"<tmpl_var addaccessory.url>\"><tmpl_var addaccessory.label></a><p /></tmpl_if>\n		<tmpl_loop accessory_loop>\n			<tmpl_if session.var.adminOn><tmpl_var accessory.controls></tmpl_if>\n			<a href=\"<tmpl_var accessory.url>\"><tmpl_var accessory.title></a><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td valign=\"top\" class=\"productRelated\">\n		<div class=\"productRelatedHeader\">Related Products</div>\n		<tmpl_if session.var.adminOn><a href=\"<tmpl_var addRelatedProduct.url>\"><tmpl_var addRelatedProduct.label></a><p /></tmpl_if>\n		<tmpl_loop relatedproduct_loop>\n			<tmpl_if session.var.adminOn><tmpl_var RelatedProduct.controls></tmpl_if>\n			<a href=\"<tmpl_var relatedproduct.url>\"><tmpl_var relatedproduct.title></a><br />\n		</tmpl_loop>\n	</td>\n</tr>\n</table>\n\n\n','Product',1,1,'PBtmpl0000000000000056',1147642415,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.productFeatureHeader {\n	font-weight: bold;\n	font-size: 15px;\n	width:100%;\n	border-bottom:solid gray 1px;\n	background-color:#DADADA;\n	padding-left:3px;\n	-moz-box-sizing:border-box;\n}\n.productSpecificationHeader {\n	font-weight: bold;\n	font-size: 15px;\n	width:100%;\n	border-bottom:solid gray 1px;\n	background-color:#DADADA;\n	padding-left:3px;\n	-moz-box-sizing:border-box;\n}\n.productRelatedHeader {\n	font-weight: bold;\n	font-size: 15px;\n	width:100%;\n	border-bottom:solid gray 1px;\n	background-color:#DADADA;\n	padding-left:3px;\n	-moz-box-sizing:border-box;\n}\n.productAccessoryHeader{\n	font-weight: bold;\n	font-size: 15px;\n	width:100%;\n	border-bottom:solid gray 1px;\n	background-color:#DADADA;\n	padding-left:3px;\n	-moz-box-sizing:border-box;\n}\n.productBenefitHeader {\n	font-weight: bold;\n	font-size: 15px;\n	width:100%;\n	border-bottom:solid gray 1px;\n	background-color:#DADADA;\n	padding-left:3px;\n	-moz-box-sizing:border-box;\n}\n.productFeature {\n	font-size: 12px;\n	border-right:solid gray 1px;\n	width:20%;\n}\n.productSpecification {\n	font-size: 12px;\n	border-right:solid gray 1px;\n	width:20%;\n}\n.productRelated {\n	font-size: 12px;\n	border-right:solid gray 1px;\n	width:20%;\n}\n.productAccessory {\n	font-size: 12px;\n	border-right:solid gray 1px;\n	width:20%;\n}\n.productBenefit {\n	font-size: 12px;\n	border-right:solid gray 1px;\n	width:20%;\n}\n.productAttributeSeperator {\n	background-color: black;\n}\n.noBorder {\n	border:none;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.defaultProduct {\n	border:solid gray 1px;\n}\n.defaultProduct td {\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultProduct a {\n	color:#29587E;\n}\n</style>'),('<h2><tmpl_var title></h2>\n<tmpl_var description><br />\n<br />\n<tmpl_var variants.message><br />\n\n<table>\n	<tmpl_loop variantLoop>\n	<tr>\n		<td style=\"text-indent: 40px;\">\n		<tmpl_loop variant.compositionLoop>\n			<tmpl_var parameter>: <tmpl_var value><tmpl_unless __LAST__>,</tmpl_unless>\n		</tmpl_loop>\n		</td>\n		<td>$ <tmpl_var variant.price></td>\n		<td><a href=\"<tmpl_var variant.addToCart.url>\"><tmpl_var variant.addToCart.label></a></td>\n	</tr>\n	</tmpl_loop>\n</table>','Commerce/Product',1,1,'PBtmplCP00000000000001',1147642415,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2><tmpl_var displayTitle></h2>\n\n<table>\n  <tmpl_loop profile.elements>\n\n    <tmpl_if profile.category>\n	<tr>\n	  <td colspan=\"2\">&nbsp;</td>\n	</tr>\n	<tr>\n      <td colspan=\"2\" class=\"tableHeader\">\n        <tmpl_var profile.category>\n      </td>\n	</tr>\n    <tmpl_else>\n	<tr>\n      <td class=\"tableCategory\">\n         <tmpl_var profile.label>\n      </td>\n      <td class=\"tableData\">\n         <tmpl_var profile.value>\n      </td>    \n	</tr>\n    </tmpl_if>   \n\n  </tmpl_loop>\n</table>\n<div class=\"accountOptions\">\n   <ul>\n      <tmpl_loop profile.accountOptions>\n         <li><tmpl_var options.display></li>\n      </tmpl_loop>\n   </ul>\n</div>\n','Operation/Profile/View',1,1,'PBtmpl0000000000000052',1147642416,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.tableHeader {\n	background-color:#F0F0F0;\n	border-bottom:solid gray 1px;\n	font-weight:bold;	\n}\n.tableCategory {\n	background-color:#F0F0F0;	\n}\n.tableData {\n	border-bottom:solid #F0F0F0 1px;\n}\n</style>\n'),('\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.canViewReports>\n	<a href=\"<tmpl_var survey.url>\"><tmpl_var survey.label></a> \n	&bull;\n	<a href=\"<tmpl_var report.overview.url>\"><tmpl_var report.overview.label></a> \n	&bull;\n	<a href=\"<tmpl_var report.gradebook.url>\"><tmpl_var report.gradebook.label></a> \n</tmpl_if>\n<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a><p/>\n<b><tmpl_var start.date.label>:</b> <tmpl_var start.date.human> <tmpl_var start.time.human><br />\n<b><tmpl_var end.date.label>:</b> <tmpl_var end.date.human> <tmpl_var end.time.human><br />\n<b><tmpl_var duration.label>:</b> <tmpl_var duration.minutes> <tmpl_var duration.minutes.label> <tmpl_var duration.seconds> <tmpl_var duration.seconds.label>\n\n<p/>\n<tmpl_loop question_loop>\n\n               <b><tmpl_var question></b><br />\n                  <table class=\"tableData\" width=\"100%\">\n<tmpl_if question.isRadioList>\n               \n    <tr><td valign=\"top\" class=\"tableHeader\" style=\"width:25%;\">\n                               <tmpl_var answer.label></td><td style=\"width:75%\">\n                   <tmpl_var question.answer>                       \n</td></tr>\n        </tmpl_if>\n               <tr><td style=\"width:25%\" valign=\"top\" class=\"tableHeader\"><tmpl_var response.label></td>\n               \n<td style=\"width:75%\"><tmpl_var question.response></td></tr>\n                <tmpl_if question.comment>\n                        <tr><td valign=\"top\" class=\"tableHeader\">\n                                <tmpl_var comment.label> </td>\n                                <td><tmpl_var question.comment></td></tr>\n               </tmpl_if>\n\n       </table><p/>\n</tmpl_loop>','Survey/Response',1,1,'PBtmpl0000000000000064',1147642416,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if pluginsAvailable>\n   <tmpl_var message><br />\n    <tmpl_var formHeader>\n       <table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n    <tmpl_loop pluginLoop>\n            <tr>\n                        <td><tmpl_var formElement></td>\n                     <td align=\"left\"><tmpl_var name></td>\n           </tr>\n       </tmpl_loop>\n        </table>\n    <tmpl_var formSubmit>\n    <tmpl_var formFooter>\n<tmpl_else>\n <tmpl_var noPluginsMessage>\n</tmpl_if>','Commerce/SelectShippingMethod',1,1,'PBtmplCSSM000000000001',1147642416,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if debugMode>\n	<ul>\n	<tmpl_loop debug_loop>\n		<li><tmpl_var debug.output></li>\n	</tmpl_loop>\n	</ul>\n</tmpl_if>\n\n<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n<tr>\n<tmpl_loop columns_loop>\n	<td class=\"tableHeader\"><tmpl_var column.name></td>\n</tmpl_loop>\n</tr>\n<tmpl_loop rows_loop>\n	<tr>\n	<tmpl_loop row.field_loop>\n		<td class=\"tableData\"><tmpl_var field.value></td>\n	</tmpl_loop>\n	</tr>\n	<!-- Handle nested query2 -->\n	<tmpl_if hasNest>\n		<tr>\n		<td colspan=\"<tmpl_var columns.count>\">\n		<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n		<tr>\n		<td width=\"20\">&nbsp;</td>\n		<td>\n		<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n		<tr>\n		<tmpl_loop query2.columns_loop>\n			<td class=\"tableHeader\"><tmpl_var column.name></td>\n		</tmpl_loop>\n		</tr>\n		<tmpl_loop query2.rows_loop>\n			<tr>\n			<tmpl_loop query2.row.field_loop>\n				<td class=\"tableData\"><tmpl_var field.value></td>\n			</tmpl_loop>\n			</tr>\n			<!-- Handle nested query3 -->\n			<tmpl_if query2.hasNest>\n				<tr>\n				<td colspan=\"<tmpl_var query2.columns.count>\">\n				<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n				<tr>\n				<td style=\"width:20px;\">&nbsp;</td>\n				<td>\n				<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n				<tr>\n				<tmpl_loop query3.columns_loop>\n					<td class=\"tableHeader\"><tmpl_var column.name></td>\n				</tmpl_loop>\n				</tr>\n				<tmpl_loop query3.rows_loop>\n					<tr>\n					<tmpl_loop query3.row.field_loop>\n						<td class=\"tableData\"><tmpl_var field.value></td>\n					</tmpl_loop>\n					</tr>\n		   			<!-- Handle nested query4 -->\n					<tmpl_if query3.hasNest>\n						<tr>\n						<td colspan=\"<tmpl_var query3.columns.count>\">\n						<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n						<tr>\n						<td style=\"width:20px;\">&nbsp;</td>\n						<td>\n						<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n						<tr>\n						<tmpl_loop query4.columns_loop>\n							<td class=\"tableHeader\"><tmpl_var column.name></td>\n						</tmpl_loop>\n						</tr>\n						<tmpl_loop query4.rows_loop>\n							<tr>\n							<tmpl_loop query4.row.field_loop>\n								<td class=\"tableData\"><tmpl_var field.value></td>\n							</tmpl_loop>\n				   			<!-- Handle nested query5 -->\n							<tmpl_if query4.hasNest>\n								<tr>\n								<td colspan=\"<tmpl_var query4.columns.count>\">\n								<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n								<tr>\n								<td style=\"width:20px;\">&nbsp;</td>\n								<td>\n								<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n								<tr>\n								<tmpl_loop query5.columns_loop>\n									<td class=\"tableHeader\"><tmpl_var column.name></td>\n								</tmpl_loop>\n								</tr>\n								<tmpl_loop query5.rows_loop>\n									<tr>\n									<tmpl_loop query5.row.field_loop>\n										<td class=\"tableData\"><tmpl_var field.value></td>\n									</tmpl_loop>\n									</tr>\n								</tmpl_loop>\n								</table>\n								</td>\n								</tr>\n								</table>\n						        	</td>\n				        			</tr>\n							</tmpl_if>\n							</tr>\n						</tmpl_loop>\n						</table>\n						</td>\n						</tr>\n						</table>\n				        	</td>\n				        	</tr>\n					</tmpl_if>\n				</tmpl_loop>\n				</table>\n				</td>\n				</tr>\n				</table>\n			        </td>\n			        </tr>\n			</tmpl_if>\n		</tmpl_loop>\n		</table>\n		</td>\n		</tr>\n		</table>\n		</td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> <tmpl_var pagination.pageList.upTo20> <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','SQLReport',1,1,'PBtmpl0000000000000059',1147642416,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<div class=\"defaultSubmissionDetails\">\n	<b><tmpl_var user.label>:</b> \n		<tmpl_if user.isVisitor>\n			<tmpl_var username>\n		<tmpl_else>\n			<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n		</tmpl_if>\n		<br />\n	<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n	<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n	<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n		<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n		</tmpl_unless>\n		<br />\n	<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n	<tmpl_else>	\n		<tmpl_if user.isPoster>\n			<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n		</tmpl_if>	\n	</tmpl_if>	\n</div>\n\n<div class=\"collaborationThreadContent\">\n	<tmpl_var content>\n</div>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n<tmpl_if userDefined1>\n	<p><tmpl_var userDefined1></p>\n</tmpl_if>\n\n<tmpl_if userDefined2>\n	<p><tmpl_var userDefined2></p>\n</tmpl_if>\n	\n<tmpl_if userDefined3>\n	<p><tmpl_var userDefined3></p>\n</tmpl_if>\n\n<tmpl_if userDefined4>\n	<p><tmpl_var userDefined4></p>\n</tmpl_if>\n\n<tmpl_if userDefined5>\n	<p><tmpl_var userDefined5></p>\n</tmpl_if>\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<tmpl_if repliesAllowed>\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n								<br />\n								<tmpl_if user.isPoster>\n									<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n								</tmpl_if>	\n						</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n								<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n									<tmpl_if user.isPoster>\n										<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n									</tmpl_if>	\n							</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>\n	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a>				\n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n\n\n','Collaboration/Thread',1,1,'PBtmpl0000000000000067',1147642416,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n\n.postControls a\n{\n	color:white;\n}\n\n.collaborationThreadContent\n{\n	height:100px;\n	font-family:arial;\n	font-size:9pt;\n}\n\n#mainText > .collaborationThreadContent\n{\n	height:auto;\n	min-height:100px;\n}\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if preview.title><p><b><tmpl_var preview.title></b></p></tmpl_if>\n<tmpl_unless isReply><tmpl_if preview.synopsis><p><i><tmpl_var preview.synopsis></i></p></tmpl_if></tmpl_unless>\n<tmpl_if preview.content><p><tmpl_var preview.content></p></tmpl_if>\n\n<tmpl_if isReply>\n	<h1><tmpl_var message.header.label></h1>\n<tmpl_else>\n	<h1><tmpl_var submission.header.label></h1>\n</tmpl_if>\n\n<tmpl_var form.header>\n<table class=\"defaultSubmissionForm\">\n	<tmpl_if isNewPost>\n		<tmpl_if user.isVisitor>\n			<tr>\n				<td><tmpl_var visitorName.label></td>\n				<td><tmpl_var visitorName.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td><tmpl_var title.label></td>\n		<td><tmpl_var title.form></td>\n	</tr>\n	<tmpl_unless isReply>\n		<tr>\n			<td><tmpl_var synopsis.label></td>\n			<td><tmpl_var synopsis.form></td>\n		</tr>\n	</tmpl_unless>\n	<tr>\n		<td><tmpl_var body.label></td>\n		<td><tmpl_var content.form></td>\n	</tr>\n	<tmpl_unless isReply>\n		<tmpl_if attachment.form>\n			<tr>\n				<td><tmpl_var attachment.label></td>\n				<td><tmpl_var attachment.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless isReply>\n		<tr>\n			<td><tmpl_var startDate.label></td>\n			<td><tmpl_var startDate.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var endDate.label></td>\n			<td><tmpl_var endDate.form></td>\n		</tr>\n	</tmpl_unless>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<div class=\"defaultSubmissionFormContent\">\n	<b><tmpl_var reply.title></b><br /><br />\n	<tmpl_var reply.content>\n	</div>\n</tmpl_if>\n\n\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000068',1147642416,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.defaultSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n'),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if user.canTakeSurvey>\n	<tmpl_if response.isComplete>\n		<tmpl_if mode.isSurvey>\n			<tmpl_var thanks.survey.label>\n		<tmpl_else>\n			<tmpl_var thanks.quiz.label>\n			<div align=\"center\">\n				<b><tmpl_var questions.correct.count.label>:</b> <tmpl_var questions.correct.count> / <tmpl_var questions.total>\n				<br />\n				<b><tmpl_var questions.correct.percent.label>:</b><tmpl_var questions.correct.percent>%\n			</div>\n		</tmpl_if>\n		<tmpl_if user.canRespondAgain>\n			<br /><br /><a href=\"<tmpl_var start.newResponse.url>\"><tmpl_var start.newResponse.label></a>\n		</tmpl_if>\n	<tmpl_else>\n		<tmpl_if response.id>\n			<tmpl_var form.header>\n			<table width=\"50%\" cellpadding=\"3\" cellspacing=\"0\" border=\"0\" class=\"content\">\n				<tr>\n					<td valign=\"top\">\n					<tmpl_loop question_loop>\n						<p><tmpl_var question.question></p>\n						<tmpl_var question.answer.label><br />\n						<tmpl_var question.answer.field><br />\n						<br />\n						<tmpl_if question.allowComment>\n							<tmpl_var question.comment.label><br />\n							<tmpl_var question.comment.field><br />\n						</tmpl_if>\n					</tmpl_loop>\n					</td>\n					<td valign=\"top\" style=\"white-space:nowrap;\">\n						<b><tmpl_var questions.sofar.label>:</b> <tmpl_var questions.sofar.count> / <tmpl_var questions.total> <br />\n						<tmpl_unless mode.isSurvey>\n							<b><tmpl_var questions.correct.count.label>:</b> <tmpl_var questions.correct.count> / <tmpl_var questions.sofar.count><br />\n							<b><tmpl_var questions.correct.percent.label>:</b><tmpl_var questions.correct.percent>% / 100%<br />\n						</tmpl_unless>\n					</td>\n				</tr>\n				<tr>\n					<td align=\"right\" colspan=\"2\"><tmpl_var form.submit></td>\n				</tr>\n			</table>\n			\n			<tmpl_var form.footer>\n		<tmpl_else>\n			<a href=\"<tmpl_var start.newResponse.url>\"><tmpl_var start.newResponse.label></a>\n		</tmpl_if>\n	</tmpl_if>\n<tmpl_else>\n	<tmpl_if mode.isSurvey>\n		<tmpl_var survey.noprivs.label>\n	<tmpl_else>\n		<tmpl_var quiz.noprivs.label>\n	</tmpl_if>\n</tmpl_if>\n<br />\n<br />\n<tmpl_if user.canViewReports>\n<table cellspacing=\"2\" cellpadding=\"1\" style=\"border:solid silver 1px;\">\n<tr>\n	<td colspan=\"4\">\n		<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\">\n		<tr>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.gradebook.url>\"><tmpl_var report.gradebook.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var report.overview.url>\"><tmpl_var report.overview.label></a></td>\n			<td style=\"width:33%;text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var delete.all.responses.url>\"><tmpl_var delete.all.responses.label></a></td>\n		</tr>\n		</table>\n	</td>\n</tr>\n<tr>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.answers.url>\"><tmpl_var export.answers.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.questions.url>\"><tmpl_var export.questions.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.responses.url>\"><tmpl_var export.responses.label></a></td>\n	<td style=\"text-align:center;background-color:#F0F0F0;\"><a href=\"<tmpl_var export.composite.url>\"><tmpl_var export.composite.label></a></td>\n</tr>\n</table>\n	\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<p style=\"border:solid silver 1px;width:150px;padding:2px;text-align:center;margin-bottom:2px;\"><a style=\"text-align:center;background-color:#F0F0F0;width:100%;display:block;\" href=\"<tmpl_var section.add.url>\"><tmpl_var section.add.label></a></p>\n	<p style=\"border:solid silver 1px;width:150px;padding:2px;text-align:center;margin-top:2px;\"><a style=\"text-align:center;background-color:#F0F0F0;width:100%;display:block;\" href=\"<tmpl_var question.add.url>\"><tmpl_var question.add.label></a></p>\n<tmpl_loop section.edit_loop>\n<tmpl_var section.edit.controls>\n<tmpl_var section.edit.sectionName><br /><br />\n	<tmpl_loop section.questions_loop>\n		&nbsp;&nbsp;<tmpl_var question.edit.controls>\n          	<tmpl_var question.edit.question>\n		<br />\n        </tmpl_loop>\n</tmpl_loop>\n<br /><br />\n</tmpl_if>\n','Survey',1,1,'PBtmpl0000000000000061',1147642416,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<h2>\n<tmpl_if channel.link>\n	<a href=\"<tmpl_var channel.link>\"><tmpl_var channel.title></a>\n<tmpl_else>\n	<tmpl_var channel.title>\n</tmpl_if>\n</h2>\n\n<tmpl_if channel.description>\n	<tmpl_var channel.description>\n	<p />\n</tmpl_if>\n\n<ul>\n<tmpl_loop item_loop>\n<li>\n	<tmpl_if link>\n		<a href=\"<tmpl_var link>\"><tmpl_var title></a>\n	<tmpl_else>\n		<tmpl_var title>\n	</tmpl_if>\n	<tmpl_if description>\n		- <tmpl_var description>\n	</tmpl_if>\n</li>	\n</tmpl_loop>\n</ul>','SyndicatedContent',1,1,'PBtmpl0000000000000065',1147642417,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n	\n<div style=\"float: left; width: 70%\">\n	<h2><a href=\"<tmpl_var collaboration.url>\"><tmpl_var collaboration.title></a></h2>\n</div>\n<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n</div>\n<div style=\"clear: both;\"></div>\n\n<tmpl_if layout.isFlat>\n<!-- begin flat layout -->\n	<tmpl_loop post_loop>\n		<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n			<a name=\"<tmpl_var assetId>\"></a>\n			<div class=\"postSubject\">\n				<tmpl_var title>\n			</div>\n			<div class=\"postData\">\n				<div style=\"float: left; width: 50%\">\n					<b><tmpl_var user.label>:</b> \n						<tmpl_if user.isVisitor>\n							<tmpl_var username>\n						<tmpl_else>\n							<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n						</tmpl_if>\n						<br />\n					<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n				</div>	\n				<div>\n					<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n					<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n						<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n						</tmpl_unless>\n						<br />\n					<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n					<tmpl_else>	\n						<tmpl_if user.isPoster>\n							<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n						</tmpl_if>	\n					</tmpl_if>	\n				</div>	\n			</div>\n			<div class=\"postMessage\">\n				<tmpl_var content>\n<tmpl_loop attachment_loop>\n	<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n</tmpl_loop>\n<div style=\"clear: both;\"></div>\n\n			</div>\n			<tmpl_unless isLocked>\n				<div class=\"postControls\">\n					<tmpl_if user.canReply>\n						<a href=\"<tmpl_var reply.url>\">[<tmpl_var reply.label>]</a>\n					</tmpl_if>\n					<tmpl_if user.canEdit>\n						<a href=\"<tmpl_var edit.url>\">[<tmpl_var edit.label>]</a>\n						<a href=\"<tmpl_var delete.url>\">[<tmpl_var delete.label>]</a>\n					</tmpl_if>\n				</div>\n			</tmpl_unless>\n		</div>\n	</tmpl_loop>\n<!-- end flat layout -->\n</tmpl_if>\n\n<tmpl_if layout.isNested>\n<!-- begin nested layout -->\n	<tmpl_loop post_loop>\n		<div style=\"margin-left: <tmpl_var depthX10>px;\">\n			<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n				<a name=\"<tmpl_var assetId>\"></a>\n				<div class=\"postSubject\">\n					<tmpl_var title>\n				</div>\n				<div class=\"postData\">\n					<div style=\"float: left; width: 50%\">\n						<b><tmpl_var user.label>:</b> \n							<tmpl_if user.isVisitor>\n								<tmpl_var username>\n							<tmpl_else>\n								<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n							</tmpl_if>\n							<br />\n						<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n					</div>	\n					<div>\n						<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n						<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n							<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n							</tmpl_unless>\n							<br />\n							<tmpl_if user.isPoster>\n								<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n							</tmpl_if>	\n					</div>	\n				</div>\n				<div class=\"postMessage\">\n					<tmpl_var content>\n<tmpl_loop attachment_loop>\n	<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n</tmpl_loop>\n<div style=\"clear: both;\"></div>\n\n				</div>\n				<tmpl_unless isLocked>\n					<div class=\"postControls\">\n						<tmpl_if user.canReply>\n							<a href=\"<tmpl_var reply.url>\">[<tmpl_var reply.label>]</a>\n						</tmpl_if>\n						<tmpl_if user.canEdit>\n							<a href=\"<tmpl_var edit.url>\">[<tmpl_var edit.label>]</a>\n							<a href=\"<tmpl_var delete.url>\">[<tmpl_var delete.label>]</a>\n						</tmpl_if>\n					</div>\n				</tmpl_unless>\n			</div>\n		</div>\n	</tmpl_loop>\n<!-- end nested layout -->\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\" style=\"margin-top: 20px;\">\n		[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n	</div>\n</tmpl_if>\n\n<div style=\"margin-top: 20px;\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\">[<tmpl_var previous.label>]</a> \n	</tmpl_if>	\n	<tmpl_if next.url>\n		<a href=\"<tmpl_var next.url>\">[<tmpl_var next.label>]</a> \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\">[<tmpl_var unstick.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\">[<tmpl_var stick.label>]</a>\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\">[<tmpl_var unlock.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\">[<tmpl_var lock.label>]</a>\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000032',1147642417,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	.postBorder {\n		border: 1px solid #cccccc;\n		margin-bottom: 10px;\n	}\n 	.postBorderCurrent {\n		border: 3px dotted black;\n		margin-bottom: 10px;\n	}\n	.postSubject {\n		border-bottom: 1px solid #cccccc;\n		font-weight: bold;\n		padding: 3px;\n	}\n	.postData {\n		border-bottom: 1px solid #cccccc;\n		font-size: 11px;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.postControls {\n		border-top: 1px solid #cccccc;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.postMessage {\n		padding: 3px;\n	}\n	.currentThread {\n		background-color: #eeeeee;\n	}\n	.threadHead {\n		font-weight: bold;\n		border-bottom: 1px solid #cccccc;\n		font-size: 11px;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.threadData {\n		font-size: 11px;\n		padding: 3px;\n	}\n</style>\n\n'),('<table border=\"1\" cellpadding=\"5\" cellspacing=\"0\">\n  <tr>\n    <th>Transaction description</th>\n    <th>Price</th>\n    <th>Status</th>\n    <th>Error</th>\n  </tr>\n<tmpl_loop resultLoop>\n  <tr>\n    <td align=\"left\"><tmpl_var purchaseDescription></td>\n    <td align=\"right\"><tmpl_var purchaseAmount></td>\n    <td><tmpl_var status></td>\n    <td align=\"left\"><tmpl_var error> (<tmpl_var errorCode>)</td>\n  </tr>\n</tmpl_loop>\n</table><br />\n<br />\n\n<tmpl_var statusExplanation>','Commerce/TransactionError',1,1,'PBtmpl0000000000000018',1147642417,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\nThis is the Manager\'s View\n\n','TimeTracking_manager',1,1,'TimeTrackingTMPL000002',1147642417,'WebGUI::Asset::Template::HTMLTemplate','	'),('\n<table class=\"timeTracking02\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr class=\"title\">\n      <td colspan=\"4\" align=\"left\"><tmpl_var time.report.header></td>\n	  <td colspan=\"2\" align=\"right\"><tmpl_var time.report.hours.label> <b style=\"color:red;\">0</b></td>\n   </tr>\n   <tr class=\"header\" id=\"header\">\n      <td width=\"10%\"><tmpl_var time.report.date.label></td>\n	  <td width=\"20%\"><tmpl_var time.report.project.label></td>\n	  <td width=\"20%\"><tmpl_var time.report.task.label></td>\n	  <td width=\"10%\"><tmpl_var time.report.hours.label></td>\n	  <td width=\"40%\"><tmpl_var time.report.comments.label></td>\n	  <td>&#160;</td>\n   </tr>\n   <tmpl_loop time.entry.loop>\n      <tr id=\"<tmpl_var row.id>\">\n         <td class=\"cell\"><tmpl_var form.date></td>\n         <td class=\"cell\"><tmpl_var form.project></td>\n         <td class=\"cell\"><tmpl_var form.task></td>\n         <td class=\"cell\"><tmpl_var form.hours></td>\n         <td class=\"cell\"><tmpl_var form.comments></td>\n         <td><img src=\"<tmpl_var extras>/delete.gif\" /></td>\n      </tr>\n   </tmpl_loop>\n   <tr class=\"empty\">\n      <td colspan=\"6\" style=\"border-top:solid gray 2px;\">\n	      <table width=\"100%\">\n		     <tr>\n			    <td width=\"60%\" align=\"left\">\n				   Report Complete<input type=\"checkbox\" /> \n				</td>\n				<td width=\"40%\" align=\"right\">\n					<input type=\"button\" value=\"Add Row\" /> &#160; <input type=\"button\" value=\"Save\" />\n			    </td>			\n		     </tr>\n	      </table>		\n	   </td>\n   </tr>\n</table>\n\n\n\n\n','TimeTracking_row',1,1,'TimeTrackingTMPL000003',1147642417,'WebGUI::Asset::Template::HTMLTemplate','	'),('<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<script language=\"JavaScript\">\n   var rowTotal = <tmpl_var time.report.rows.total>;\n</script>\n\n<p><tmpl_if project.manage.url><a href=\"<tmpl_var project.manage.url>\"><tmpl_var project.manage.label></a></tmpl_if></p>\n<tmpl_var form.header>\n<tmpl_var form.timetracker>\n<tmpl_var form.footer>\n\n','TimeTracking_user',1,1,'TimeTrackingTMPL000001',1147642417,'WebGUI::Asset::Template::HTMLTemplate','	<style type=\"text/css\">\n		.timeTracking02 {			\n			width:750px;\n		}\n		.timeTracking02 td {\n			border:solid silver 1px;\n			border-bottom:solid gray 1px;\n			font-size:9pt;\n			font-family:arial;			\n		}\n		tr.title td {\n			font-weight:bold;			\n			background-color:#F0F0F0;\n			border-style:none;\n			font-size:11pt;\n		}\n		tr.header td {\n			font-weight:bold;\n			text-align:center;		\n		}\n		tr.empty td {\n			border-style:none;\n		}\n	</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var title.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var by.label></a></td>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateUpdated.human></td>\n	<tmpl_if user.isVisitor>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n	<tmpl_else>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n	</tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000066',1147642417,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n\n</style>\n\n\n'),('<table border=\"0\">\n<tmpl_loop purchaseHistoryLoop>\n	<tr>\n		<td><b><tmpl_var initDate></b></td>\n		<td><b><tmpl_var completionDate></b></td>\n		<td align=\"right\"><b>$ <tmpl_var amount></b></td>\n		<td><b><tmpl_var status></b></td>\n		<td><tmpl_if canCancel><a href=\"<tmpl_var cancelUrl>\">Cancel</a></tmpl_if></td>\n	</tr>\n	<tmpl_loop itemLoop>\n	<tr>\n		<td \"align=right\"><tmpl_var quantity> x </td>\n		<td \"align=left\"><tmpl_var itemName></td>\n		<td \"align=right\">$ <tmpl_var amount></td>\n	</tr>\n	</tmpl_loop>\n</tmpl_loop>\n</table>','Commerce/ViewPurchaseHistory',1,1,'PBtmpl0000000000000019',1147642418,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2><tmpl_var title></h2>\n\n<tmpl_if account.message>\n	<tmpl_var account.message>\n</tmpl_if>\n\n<tmpl_var account.form.header>\n<table>\n<tmpl_if account.form.karma>\n<tr>\n	<td class=\"formDescription\" valign=\"top\"><tmpl_var account.form.karma.label></td>\n	<td class=\"tableData\"><tmpl_var account.form.karma></td>\n</tr>\n</tmpl_if>\n<tr>\n	<td class=\"formDescription\" valign=\"top\"><tmpl_var account.form.username.label></td>\n	<td class=\"tableData\"><tmpl_var account.form.username></td>\n</tr>\n<tr>\n	<td class=\"formDescription\" valign=\"top\"><tmpl_var account.form.password.label></td>\n	<td class=\"tableData\"><tmpl_var account.form.password></td>\n</tr>\n<tr>\n	<td class=\"formDescription\" valign=\"top\"><tmpl_var account.form.passwordConfirm.label></td>\n	<td class=\"tableData\"><tmpl_var account.form.passwordConfirm></td>\n</tr>\n<tr>\n	<td class=\"formDescription\" valign=\"top\"></td>\n	<td class=\"tableData\"><tmpl_var account.form.submit></td>\n</tr>\n</table>\n<tmpl_var account.form.footer>\n\n<div class=\"accountOptions\">\n	<ul>\n		<tmpl_loop account.options>\n			<li><tmpl_var options.display></li>\n		</tmpl_loop>\n	</ul>\n</div>\n','Auth/WebGUI/Account',1,1,'PBtmpl0000000000000010',1147642418,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2><tmpl_var title></h2>\n\n<tmpl_if create.message>\n   <tmpl_var create.message>\n</tmpl_if>\n\n<tmpl_var create.form.header>\n<table >\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.username.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.username></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.password></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.passwordConfirm.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.passwordConfirm></td>\n</tr>\n<tmpl_loop create.form.profile>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var profile.formElement.label></td>\n   <td class=\"tableData\"><tmpl_var profile.formElement></td>\n</tr>\n</tmpl_loop>\n<tmpl_if useCaptcha>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var create.form.captcha.label></td>\n   <td class=\"tableData\"><tmpl_var create.form.captcha></td>\n</tr>\n</tmpl_if>\n<tr>\n	<td colspan=\"2\">&nbsp;</td>\n</tr>\n<tr>\n   <td class=\"submitData\" colspan=\"2\"><tmpl_var create.form.submit></td>\n</tr>\n</table>\n<tmpl_var create.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n      <li><a href=\"<tmpl_var login.url>\"><tmpl_var login.label></a></li>\n      <tmpl_if recoverPassword.isAllowed>\n	     <li><a href=\"<tmpl_var recoverPassword.url>\"><tmpl_var recoverPassword.label></a></li>\n	  </tmpl_if>\n   </ul>\n</div>\n','Auth/WebGUI/Create',1,1,'PBtmpl0000000000000011',1147642418,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	.submitData {\n		text-align:right;\n		border-top:solid gray 1px;\n	}\n</style>\n'),('<h2>\n   <tmpl_var title>\n</h2>\n\n<tmpl_if login.message>\n   <tmpl_var login.message>\n</tmpl_if>\n\n<tmpl_var login.form.header>\n<table >\n<tmpl_var login.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.username.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.username></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.password></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\"><tmpl_var login.form.submit></td>\n</tr>\n</table>\n<tmpl_var login.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n     <tmpl_if recoverPassword.isAllowed>\n	     <li><a href=\"<tmpl_var recoverPassword.url>\"><tmpl_var recoverPassword.label></a></li>\n	  </tmpl_if>\n           <tmpl_if anonymousRegistration.isAllowed>\n	     <li><a href=\"<tmpl_var createAccount.url>\"><tmpl_var createAccount.label></a></li>\n	  </tmpl_if>\n   </ul>\n</div>','Auth/WebGUI/Login',1,1,'PBtmpl0000000000000013',1147642418,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>\n   <tmpl_var title>\n</h2>\n\n<tmpl_if expired.message>\n   <tmpl_var expired.message>\n</tmpl_if>\n\n<tmpl_var expired.form.header>\n<table >\n<tmpl_var expired.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n      <tmpl_var expired.form.oldPassword.label>\n   </td>\n   <td class=\"tableData\">\n      <tmpl_var expired.form.oldPassword>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n      <tmpl_var expired.form.password.label>\n   </td>\n   <td class=\"tableData\">\n      <tmpl_var expired.form.password>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n  <tmpl_var expired.form.passwordConfirm.label>\n   </td>\n   <td class=\"tableData\">\n   <tmpl_var expired.form.passwordConfirm>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\">\n   <tmpl_var expired.form.submit>\n   </td>\n</tr>\n</table>\n<tmpl_var expired.form.footer>','Auth/WebGUI/Expired',1,1,'PBtmpl0000000000000012',1147642418,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2><tmpl_var title></h2>\n\n<p>\n<tmpl_var question>\n</p>\n\n<div style=\"text-align:center\">\n\n<a href=\"<tmpl_var yes.url>\"><tmpl_var yes.label></a>\n\n&nbsp;  &nbsp; &nbsp; &nbsp; &nbsp; \n\n<a href=\"<tmpl_var no.url>\"><tmpl_var no.label></a>\n\n</div>\n','prompt',1,1,'PBtmpl0000000000000057',1147642418,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<script type=\"text/javascript\" defer=\"defer\">\n<!--\nfunction go(formObj) {\n	if (formObj.chooser.options[formObj.chooser.selectedIndex].value != \"none\") {\n		location = formObj.chooser.options[formObj.chooser.selectedIndex].value;\n	}\n}\n//-->\n</script>\n\n<form action=\"#\">\n<tmpl_if session.var.adminOn><tmpl_var controls></tmpl_if>\n<p style=\"margin:0px;\">\n<select name=\"chooser\" size=\"1\" onchange=\"go(this.form)\">\n<option value=\"none\">Where do you want to go?</option>\n<tmpl_loop page_loop>\n	<option value=\"<tmpl_var page.url>\"><tmpl_loop page.indent_loop>&nbsp;&nbsp;</tmpl_loop>- <tmpl_var page.menuTitle></option>\n</tmpl_loop>\n</select>\n</p>\n</form>\n','Navigation',1,1,'PBtmpl0000000000000117',1147642419,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<div class=\"dtree\">\n<script type=\"text/javascript\">\n<!--\n	// Path to dtree directory\n	_dtree_url = \"^Extras(Navigation/dtree/);\";\n\n	d = new dTree(\'d\');\n	<tmpl_loop page_loop>\n	d.add(\n		\'<tmpl_var page.assetId escape=JS>\',\n		<tmpl_if __first__>-99<tmpl_else>\'<tmpl_var page.parentId escape=JS>\'</tmpl_if>,\n		\'<tmpl_var page.menuTitle escape=JS>\',\n		\'<tmpl_var page.url escape=JS>\',\n		\'<tmpl_var page.synopsis escape=JS>\'\n		<tmpl_if page.newWindow>,\'_blank\'</tmpl_if>\n	);\n	</tmpl_loop>\n	document.write(d);\n//-->\n</script>\n</div>\n','Navigation',1,1,'PBtmpl0000000000000130',1147642419,'WebGUI::Asset::Template::HTMLTemplate','<link href=\"^Extras(Navigation/dtree/dtree.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script src=\"^Extras(Navigation/dtree/dtree.js);\" type=\"text/javascript\"></script>\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var addevent.url>\"><tmpl_var addevent.label></a>\n	<p />\n</tmpl_if>\n\n<tmpl_loop month_loop>\n	<tmpl_loop day_loop>\n		<tmpl_loop event_loop>\n			<tmpl_if isFirstDayOfEvent>\n			<div class=\"eventsList\">\n				<tmpl_unless dateIsSameAsPrevious>\n					<b>\n						<tmpl_var start.day.dayOfWeek> <tmpl_var start.month> <tmpl_var start.day><tmpl_unless startEndYearMatch>, <tmpl_ start.year> -\n						<tmpl_var end.day.dayOfWeek> <tmpl_var end.month> <tmpl_var end.day></tmpl_unless><tmpl_unless startEndMonthMatch> - <tmpl_var end.day.dayOfWeek> <tmpl_var end.month> <tmpl_var end.day><tmpl_else><tmpl_unless startEndDayMatch> - <tmpl_var end.day></tmpl_unless></tmpl_unless>, <tmpl_var end.year>\n					</b>\n				</tmpl_unless>\n					&#160;&#160;&#160;\n					<tmpl_if session.var.adminOn>\n						<a href=\"<tmpl_var url>\">\n					</tmpl_if>\n					<i><tmpl_var name></i>\n					<tmpl_if session.var.adminOn>\n						</a>\n					</tmpl_if>\n					<tmpl_if description>\n						- <tmpl_var description>\n					</tmpl_if description>\n				</div>\n			</tmpl_if>\n		</tmpl_loop>\n	</tmpl_loop>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo20> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','EventsCalendar',1,1,'PBtmpl0000000000000086',1147642419,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}	\n.eventsList {\n	font-family:arial;\n	font-size:9pt;		\n}\n.eventsList a {\n	color:#29587E;\n}\n.eventsList b {\n	margin-top:7px;\n	margin-bottom:1px;\n	display:block;\n}\n\n\n</style>'),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>^Page(\"title\"); - WebGUI</title>\n	<tmpl_var head.tags>\n</head>\n<body>\n	^AdminBar;\n	<div class=\"topwrapper\">\n\n	<div class=\"menu\">\n		^AssetProxy(flexmenu);\n	</div>\n\n	<div class=\"contentArea\">\n		<tmpl_var body.content>\n		<br />\n		<br />\n		<hr />\n		^LoginToggle; &nbsp; ^a(^@;); &nbsp; ^H; &nbsp; ^AdminToggle;\n	</div>\n\n	</div>\n\n</body>\n</html>\n','style',0,1,'PBtmpl0000000000000060',1147642419,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n\ndiv.topwrapper {\n	position: relative;\n}\n\n.menu {\n	position: absolute;\n	top: 25px;\n	left: 10px;\n	width: 180px;\n	font-family: helvetica, arial;\n	font-size: 12px;\n}\n\n.contentArea {\n	border: 1px solid #cccccc;\n	margin: 25px 10px 10px 190px;\n	padding: 5px;\n	font-family: helvetica, arial;\n	min-height: 400px;\n}\n\n/* Hides from non-ie: the holly hack \\*/\n* html .adminConsoleWorkArea {\n	zoom: 1.00;\n	display: inline;\n}\n/* End hide from non-ie */\n\n	</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<ul>\n	<tmpl_loop post_loop>\n	   <li><a href=\"#id<tmpl_var assetId>\"><span class=\"faqQuestion\"><tmpl_var title></span></a></li>\n	</tmpl_loop>\n</ul>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<div>[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]</div>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<div>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n		</div>\n	</tmpl_if>\n	<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a><span class=\"faqQuestion\"><tmpl_var title></span><br />\n	<tmpl_var content>\n	<p><a href=\"#top\">[top]</a></p>\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000080',1147642419,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if preview.title><p><b><tmpl_var preview.title></b></p></tmpl_if>\n<tmpl_if preview.content><p><tmpl_var preview.content></p></tmpl_if>\n\n<tmpl_if isReply>\n	<h2><tmpl_var message.header.label></h2>\n<tmpl_else>\n	<h2><tmpl_var question.header.label></h2>\n</tmpl_if>\n\n<tmpl_var form.header>\n<table class=\"faqSubmissionForm\">\n	<tmpl_if isReply>\n		<tr>\n			<td><tmpl_var subject.label></td>\n			<td><tmpl_var title.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var message.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n	<tmpl_else>\n		<tr>\n			<td><tmpl_var question.label></td>\n			<td><tmpl_var title.form.textarea></td>\n		</tr>\n		<tr>\n			<td><tmpl_var answer.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n		<tmpl_if attachment.form>\n			<tr>\n				<td><tmpl_var attachment.label></td>\n				<td><tmpl_var attachment.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<div class=\"faqSubmissionFormContent\">\n		<b><tmpl_var reply.title></b><br /><br />\n		<tmpl_var reply.content>\n	</div>\n</tmpl_if>\n\n\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000099',1147642419,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.faqSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.faqSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n'),('<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if><a href=\"<tmpl_var fileUrl>\"><img src=\"<tmpl_var fileIcon>\" alt=\"<tmpl_var title>\" style=\"border-style:none;\" /><tmpl_var filename></a>','FileAsset',1,1,'PBtmpl0000000000000024',1147642420,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn> <p><tmpl_var controls></p> </tmpl_if>\n	\n<tmpl_if displayTitle> <h2><tmpl_var title></h2> </tmpl_if>\n		\n<tmpl_if description> <tmpl_var description> </tmpl_if>\n			\n<tmpl_if session.var.adminOn> <p><a href=\"<tmpl_var addFile.url>\"><tmpl_var addFile.label></a></p> </tmpl_if>\n				\n<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"content\"> \n<tmpl_loop subfolder_loop> \n\n <tr>\n <td class=\"tableData\" valign=\"top\">\n<tmpl_if canView>\n	<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n	<a href=\"<tmpl_var url>\"><tmpl_var title></a>\n<tmpl_else>\n	<img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /><tmpl_var title>\n</tmpl_if>\n </td>\n <td class=\"tableData\" valign=\"top\" colspan=\"3\">\n <tmpl_var synopsis>\n </td>\n </tr>\n</tmpl_loop>\n				    								\n<tmpl_loop file_loop>\n <tr>\n <td valign=\"top\" class=\"tableData\">\n <tmpl_if session.var.adminOn>\n  <tmpl_if canEdit>\n   <tmpl_var controls>\n  </tmpl_if>\n </tmpl_if>\n<tmpl_if canView>\n <a href=\"<tmpl_if isFile><tmpl_var file.url><tmpl_else><tmpl_var url></tmpl_if>\"><img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n <a href=\"<tmpl_if isFile><tmpl_var file.url><tmpl_else><tmpl_var url></tmpl_if>\"><tmpl_var title></a>\n<tmpl_else>\n <img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /><tmpl_var title>\n</tmpl_if>\n</td> <td class=\"tableData\" valign=\"top\">\n <tmpl_var synopsis></td><td class=\"tableData\" valign=\"top\">^D(\"%z %Z\",<tmpl_var date.epoch>);</td>\n <td class=\"tableData\" valign=\"top\"><tmpl_var size></td></tr>\n</tmpl_loop>\n</table>\n','Folder',1,1,'PBtmpl0000000000000078',1147642420,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a href=\"<tmpl_var file.url>\"><img src=\"<tmpl_var file.icon>\" alt=\"<tmpl_var file.icon>\" style=\"border-style:none;vertical-align:middle;\" /><tmpl_var file.name></a>(<tmpl_var file.size>)','Macro/File',1,1,'PBtmpl0000000000000107',1147642420,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if description>\n	<tmpl_var description><br /><br />\n</tmpl_if>\n\n<form method=\"post\">\n	<input type=\"hidden\" name=\"func\" value=\"view\" />\n	<input type=\"hidden\" name=\"wid\" value=\"<tmpl_var wobjectId>\" />\n	<input type=\"hidden\" name=\"targetWobjects\" value=\"doGoogleSearch\" />\n	<input type=\"text\" name=\"q\"><input type=\"submit\" value=\"Search\" />\n</form>\n\n<tmpl_if results>\n	<tmpl_loop results>\n		<tmpl_if resultElements>\n			<p>You searched for <b><tmpl_var searchQuery></b>. We found around <tmpl_var estimatedTotalResultsCount> matching records.</p>\n		</tmpl_if>\n\n		<tmpl_loop resultElements>\n			<a href=\"<tmpl_var URL>\">\n			<tmpl_if title>\n				<tmpl_var title>\n			<tmpl_else>\n				<tmpl_var url>\n			</tmpl_if>\n			</a><br />\n			<tmpl_if snippet>\n				<tmpl_var snippet><br />\n			</tmpl_if>\n			<div class=\"googleDetail\">\n			<tmpl_if summary>\n				<b>Description:</b> <tmpl_var summary><br />\n			</tmpl_if>\n			<a href=\"<tmpl_var URL>\"><tmpl_var URL></a>\n			<tmpl_if cachedSize>\n				- <tmpl_var cachedSize>\n			</tmpl_if>\n			</div><br />\n		</tmpl_loop>\n	</tmpl_loop>\n<tmpl_else>\n	Could not retrieve results from Google.\n</tmpl_if>\n','WSClient',1,1,'PBtmpl0000000000000100',1147642420,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.googleDetail {\n	font-size: 9px;\n}\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n\n<div><b>On <tmpl_var dateSubmitted.human> <a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a> from <a href=\"<tmpl_var url>\">the \'<tmpl_var title>\' department</a> wrote</b></div>\n<div><i><tmpl_var synopsis></i></div>\n<div><a href=\"<tmpl_var url>\"><tmpl_var readmore.label></a></div>\n<p />\n\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000133',1147642420,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n	<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n	<tr>\n		<td><tmpl_var username.form></td>\n		<td><tmpl_var password.form></td>\n		<td><tmpl_var form.login></td>\n	</tr>\n	<tr>\n		<td><tmpl_var username.label></td>\n		<td><tmpl_var password.label></td>\n		<td></td>\n	</tr>\n	</table>             	<tmpl_if session.setting.anonymousRegistration>\n                        <a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a>\n	</tmpl_if>		<tmpl_var form.footer> \n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<br /><tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000092',1147642421,'WebGUI::Asset::Template::HTMLTemplate',NULL),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<span class=\"horizontalMenu\">\n<tmpl_loop page_loop>\n<a class=\"horizontalMenu\" <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   <tmpl_unless \"__last__\"> &middot; </tmpl_unless>\n</tmpl_loop>\n</span>','Navigation',1,1,'PBtmpl0000000000000108',1147642421,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if><img src=\"<tmpl_var fileUrl>\" <tmpl_var parameters> />','ImageAsset',1,1,'PBtmpl0000000000000088',1147642421,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\n<h2>In/Out Board Report</h2>\n<div class=\"iob\">\n   <tmpl_var form><br />\n   <tmpl_if showReport>\n   <table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr>\n   <th><tmpl_var username.label></th>\n   <th><tmpl_var status.label></th>\n   <th><tmpl_var date.label></th>\n   <th><tmpl_var message.label></th>\n   <th><tmpl_var updatedBy.label></th>\n   </tr>\n   <tmpl_loop rows_loop>\n   <tmpl_if deptHasChanged>\n   <tr><td colspan=\"5\"><b><tmpl_var department></b></td></tr>\n   </tmpl_if>\n   <tr>\n   <td><tmpl_var username></td>\n   <td><tmpl_var status></td>\n   <td><tmpl_var dateStamp></td>\n   <td><tmpl_var message></td>\n   <td><tmpl_var createdBy></td>\n   </tr>\n   </tmpl_loop>\n   <tr><td colspan=\"5\"><tmpl_var paginateBar></td></tr>\n   </table>\n   </tmpl_if>\n</div>\n\n\n','InOutBoard/Report',1,1,'IOB0000000000000000002',1147642421,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob a {\n	color:#29587E;\n}\n.iob .formDescription {\n	background-color:#DADADA;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n<tmpl_if session.var.adminOn>\n   <p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle> \n   <h2><tmpl_var title></h2> \n</tmpl_if> \n\n<div class=\"fontSettings\">\n	<tmpl_var description>\n	<br /><br />\n</div>\n\n<div class=\"pagination\">\n<tmpl_if selectDelegatesURL>\n   <a href=\"<tmpl_var selectDelegatesURL>\">Select delegates</a>\n</tmpl_if>\n<tmpl_if canViewReport>\n   <tmpl_if selectDelegatesURL>\n      &nbsp;&middot;&nbsp;\n   </tmpl_if>\n   <a href=\"<tmpl_var viewReportURL>\">View Report</a>\n</tmpl_if>\n</div>\n\n<tmpl_if displayForm>	\n	<div class=\"fontSettings\">\n		<tmpl_var form>\n	</div>	\n</tmpl_if>\n   \n   <table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"iob\">\n   <tmpl_loop rows_loop>\n   <tmpl_if deptHasChanged>\n   <tr><td colspan=\"4\" class=\"noBorder\"><br /><b><tmpl_var department></b></td></tr>\n   </tmpl_if>\n   <tr>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var username></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var status></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var dateStamp></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var message></td>\n   </tr>\n   </tmpl_loop>\n   <tr><td colspan=\"4\"><tmpl_var paginateBar></td></tr>\n   </table>\n   \n   \n','InOutBoard',1,1,'IOB0000000000000000001',1147642421,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob {\n			\n}	\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob td.odd {\n	background-color:#DADADA;\n}\n.iob td.noBorder {\n	border:none;\n}	\n.iob a {\n	color:#29587E;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}   \n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displaytitle>\n	<tmpl_if linkurl><a href=\"<tmpl_var linkurl>\"></tmpl_if><span class=\"itemTitle\"><tmpl_var title></span><tmpl_if linkurl></a></tmpl_if>\n</tmpl_if>\n\n<tmpl_if attachment.name>\n	<tmpl_if displaytitle> - </tmpl_if>\n	<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /></a></p>\n</tmpl_if>\n\n<tmpl_if description>\n  - <tmpl_var description>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000123',1147642421,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displaytitle>\n	<tmpl_if linkurl><a href=\"#\" onclick=\"window.open(\'<tmpl_var linkurl>\');\"></tmpl_if><span class=\"itemTitle\"><tmpl_var title></span><tmpl_if linkurl></a></tmpl_if>\n</tmpl_if>\n\n<tmpl_if attachment.name>\n	<tmpl_if displaytitle> - </tmpl_if>\n	<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /></a></p>\n</tmpl_if>\n\n<tmpl_if description>\n  - <tmpl_var description>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000129',1147642422,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.isModerator>\n	<div style=\"float: right; font-size: 11px; border: 1px solid #cccccc; padding: 2px; margin: 2px;\">\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n	</div>\n</tmpl_if>	\n\n<tmpl_if content>\n	<b>Job Description</b><br />\n	<p><tmpl_var content></p>\n</tmpl_if>\n\n<tmpl_if userDefined3>\n	<b>Job Requirements</b><br />\n	<p><tmpl_var userDefined3></p>\n</tmpl_if>\n\n<table width=\"100%\">\n<tr>\n	<td class=\"tableHeader\">Date Posted</td>\n	<td class=\"tableData\"><tmpl_var dateSubmitted.human>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Location</td>\n	<td class=\"tableData\"><tmpl_var userDefined2>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Compensation</td>\n	<td class=\"tableData\"><tmpl_var userDefined1>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Views</td>\n	<td class=\"tableData\"><tmpl_var views>&#160;</td>\n</tr>\n</table>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<tmpl_if repliesAllowed>\n\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n								<br />\n								<tmpl_if user.isPoster>\n									<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n								</tmpl_if>	\n						</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n								<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n									<tmpl_if user.isPoster>\n										<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n									</tmpl_if>	\n							</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a> \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>			\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n\n\n','Collaboration/Thread',1,1,'PBtmpl0000000000000098',1147642422,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n	font-size:9pt;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a\n{\n	color:white;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n\n.tableHeader\n{\n	width:20%;\n	background-color:#DADADA;\n	font-family:arial;\n	font-size:9pt;	\n}\n\n.tableData\n{\n	width:80%;\n	border:solid #DADADA 1px;\n	font-family:arial;\n	font-size:9pt;	\n}\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><tmpl_var job.title.label></td>\n	<td class=\"forumHead\"><tmpl_var location.label></td>\n	<td class=\"forumHead\"><tmpl_var compensation.label></td>\n	<td class=\"forumHead\"><tmpl_var date.label></td>\n</tr>\n\n<tmpl_loop post_loop>\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var userDefined2></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var userDefined1></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human></td>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000077',1147642422,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<div class=\"jobSubmissionFormContent\">\n	<tmpl_if preview.title><p><b><tmpl_var preview.title></b></p></tmpl_if>\n	<tmpl_if preview.content><p><tmpl_var preview.content></p></tmpl_if>\n	<tmpl_if preview.userDefined3><p><tmpl_var preview.userDefined3></p></tmpl_if>\n	<tmpl_if preview.userDefined1><p><tmpl_var preview.userDefined1></p></tmpl_if>\n	<tmpl_if preview.userDefined2><p><tmpl_var preview.userDefined2></p></tmpl_if>\n</div>\n\n<tmpl_if isReply>\n	<h2><tmpl_var message.header.label></h2>\n<tmpl_else>\n	<h2><tmpl_var job.header.label></h2>\n</tmpl_if>\n\n<tmpl_var form.header>\n<table class=\"jobSubmissionFormContent\">\n	<tmpl_if isReply>\n		<tr>\n			<td><tmpl_var subject.label></td>\n			<td><tmpl_var title.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var message.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n	<tmpl_else>\n		<tr>\n			<td><tmpl_var job.title.label></td>\n			<td><tmpl_var title.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var synopsis.label></td>\n			<td><tmpl_var synopsis.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var job.description.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var job.requirements.label></td>\n			<td><tmpl_var userDefined3.form.htmlarea></td>\n		</tr>\n		<tr>\n			<td><tmpl_var compensation.label></td>\n			<td><tmpl_var userDefined1.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var location.label></td>\n			<td><tmpl_var userDefined2.form></td>\n		</tr>\n		<tmpl_if attachment.form>\n			<tr>\n				<td><tmpl_var attachment.label></td>\n				<td><tmpl_var attachment.form></td>\n			</tr>\n		</tmpl_if>\n		<tr>\n			<td><tmpl_var startDate.label></td>\n			<td><tmpl_var startDate.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var endDate.label></td>\n			<td><tmpl_var endDate.form></td>\n		</tr>\n	</tmpl_if>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<div class=\"jobSubmissionFormContent\">\n		<b><tmpl_var reply.title></b><br /><br />\n		<tmpl_var reply.content>\n		<tmpl_if reply.userDefined3><p><tmpl_var reply.userDefined3></p></tmpl_if>\n		<tmpl_if reply.userDefined1><p><tmpl_var reply.userDefined1></p></tmpl_if>\n		<tmpl_if reply.userDefined2><p><tmpl_var reply.userDefined2></p></tmpl_if>\n	</div>\n</tmpl_if>\n<p /><p />\n\n\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000122',1147642422,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.jobSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.jobSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"content\">\n	<img src=\"<tmpl_var image.url>\" alt=\"<tmpl_var image.url>\" align=\"left\" border=\"0\" />\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if linkurl>\n	<tmpl_if linktitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n</tmpl_if>\n\n	<tmpl_if attachment.name><p><p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /> <tmpl_var attachment.name></a></p></p></tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	</td></tr></table>\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<p />\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr><td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td></tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000103',1147642422,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<table width=\"100%\" class=\"productCollateral\" border=\"0\">\n<tr><td valign=\"top\"  class=\"firstColumn\">\n^Spacer(100,1);<br />\n<tmpl_if brochure.url>\n	<a href=\"<tmpl_var brochure.url>\"><img src=\"<tmpl_var brochure.icon>\" alt=\"<tmpl_var brochure.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var brochure.label></a><br />\n</tmpl_if>\n<tmpl_if manual.url>\n	<a href=\"<tmpl_var manual.url>\"><img src=\"<tmpl_var manual.icon>\" alt=\"<tmpl_var manual.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var manual.label></a><br />\n</tmpl_if>\n<tmpl_if warranty.url>\n	<a href=\"<tmpl_var warranty.url>\"><img src=\"<tmpl_var warranty.icon>\" alt=\"<tmpl_var warranty.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var warranty.label></a><br />\n</tmpl_if>\n<br />\n<div class=\"centered\">\n<tmpl_if thumbnail1>\n	<a href=\"<tmpl_var image1>\"><img src=\"<tmpl_var thumbnail1>\" alt=\"<tmpl_var thumbnail1>\" class=\"noBorder\" /></a><p />\n</tmpl_if>\n<tmpl_if thumbnail2>\n	<a href=\"<tmpl_var image2>\"><img src=\"<tmpl_var thumbnail2>\" alt=\"<tmpl_var thumbnail2>\" class=\"noBorder\" /></a><p />\n</tmpl_if>\n<tmpl_if thumbnail3>\n	<a href=\"<tmpl_var image3>\"><img src=\"<tmpl_var thumbnail3>\" alt=\"<tmpl_var thumbnail3>\" class=\"noBorder\" /></a><p />\n</tmpl_if>\n</div>\n</td><td valign=\"top\" class=\"content\">\n<tmpl_if description>\n<tmpl_var description><p />\n</tmpl_if>\n\n<b>Specs:</b><br/>\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var addSpecification.url>\"><tmpl_var addSpecification.label></a><p />\n</tmpl_if>\n<tmpl_loop specification_loop>\n	&middot;<tmpl_if session.var.adminOn><tmpl_var specification.controls></tmpl_if><b><tmpl_var specification.label>:</b> <tmpl_var specification.specification> <tmpl_var specification.units><br />\n</tmpl_loop>\n<p />\n\n<b>Features:</b><br/>\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var addfeature.url>\"><tmpl_var addfeature.label></a><p />\n</tmpl_if>\n<tmpl_loop feature_loop>\n	&middot;<tmpl_if session.var.adminOn><tmpl_var feature.controls></tmpl_if><tmpl_var feature.feature><br />\n</tmpl_loop>\n<p />\n\n<b>Options:</b><br />\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var addaccessory.url>\"><tmpl_var addaccessory.label></a><p />\n</tmpl_if>\n<tmpl_loop accessory_loop>\n	&middot;<tmpl_if session.var.adminOn><tmpl_var accessory.controls></tmpl_if><a href=\"<tmpl_var accessory.url>\"><tmpl_var accessory.title></a><br />\n</tmpl_loop>\n\n</td></tr>\n</table>\n\n\n','Product',1,1,'PBtmpl0000000000000119',1147642423,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.productCollateral {\n	border:solid gray 1px;\n}\n.productCollateral td {\n	font-size:9pt;\n	font-family:arial;\n}\n.productCollateral .firstColumn {\n	width:100px;\n	border:solid gray 1px;\n}\n.productCollateral .content {\n	width:100%;\n}\n.productCollateral .centered {\n	text-align:center;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.noBorder {\n	border:none;\n}\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.isModerator>\n	<div style=\"float: right; font-size: 11px; border: 1px solid #cccccc; padding: 2px; margin: 2px;\">\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n	</div>\n</tmpl_if>	\n\n<tmpl_if content>\n	<div class=\"linkContent\">\n	<b>Link Description</b><br /><br />\n	<tmpl_var content><br />\n	\n	<b>Link URL</b><br /><br />\n	<a href=\"<tmpl_var userDefined1>\"><tmpl_var userDefined1></a><br /><br />\n	</div>\n</tmpl_if>\n\n\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<tmpl_if repliesAllowed>\n\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n								<br />\n								<tmpl_if user.isPoster>\n									<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n								</tmpl_if>	\n						</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\">[<tmpl_var reply.label>]</a>\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\">[<tmpl_var edit.label>]</a>\n								<a href=\"<tmpl_var delete.url>\">[<tmpl_var delete.label>]</a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n								<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n									<tmpl_if user.isPoster>\n										<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n									</tmpl_if>	\n							</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\">[<tmpl_var reply.label>]</a>\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\">[<tmpl_var edit.label>]</a>\n									<a href=\"<tmpl_var delete.url>\">[<tmpl_var delete.label>]</a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\">List All Links</a>\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a> \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		&bull;\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n\n\n','Collaboration/Thread',1,1,'PBtmpl0000000000000113',1147642423,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a\n{\n	color:white;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n\n.linkContent\n{\n	height:100px;\n	font-family:arial;\n	font-size:9pt;\n}\n\n.linkContent a\n{\n	color:#29587E;\n}\n\n#mainText > .linkContent\n{\n	height:auto;\n	min-height:100px;\n}\n\nh2\n{\n	font-family:arial;\n}\n\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<div>[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]</div>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<div>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n		</div>\n	</tmpl_if>\n	<p>\n		<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n		<tmpl_if content>\n				  - <tmpl_var content>\n		</tmpl_if>\n	</p>\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000083',1147642423,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<div class=\"linkSubmissionFormContent\">\n	<tmpl_if preview.title><p><b><tmpl_var preview.title></b></p></tmpl_if>\n	<tmpl_if preview.content><p><tmpl_var preview.content></p></tmpl_if>\n	<tmpl_if preview.userDefined1><p><a href=\"<tmpl_var preview.userDefined1>\" <tmpl_if preview.userDefined2>target=\"_blank\"</tmpl_if>><tmpl_var preview.userDefined1></a></p></tmpl_if>\n</div>\n\n<tmpl_if isReply>\n	<h2><tmpl_var message.header.label></h2>\n<tmpl_else>\n	<h2><tmpl_var link.header.label></h2>\n</tmpl_if>\n\n<tmpl_var form.header>\n<table class=\"linkSubmissionForm\">\n	<tmpl_if isReply>\n		<tr>\n			<td><tmpl_var subject.label></td>\n			<td><tmpl_var title.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var message.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n	<tmpl_else>\n		<tr>\n			<td><tmpl_var title.label></td>\n			<td><tmpl_var title.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var url.label></td>\n			<td><tmpl_var userDefined1.form></td>\n		</tr>\n		<tr>\n			<td><tmpl_var newWindow.label></td>\n			<td><tmpl_var userDefined1.form.yesNo></td>\n		</tr>\n		<tr>\n			<td><tmpl_var description.label></td>\n			<td><tmpl_var content.form></td>\n		</tr>\n		<tmpl_if attachment.form>\n			<tr>\n				<td><tmpl_var attachment.label></td>\n				<td><tmpl_var attachment.form></td>\n			</tr>\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_if isNewPost>\n		<tmpl_unless user.isVisitor>\n			<tr>\n				<td><tmpl_var subscribe.label></td>\n				<td><tmpl_var subscribe.form></td>\n			</tr>\n		</tmpl_unless>\n		<tmpl_if isNewThread>\n			<tmpl_if user.isModerator>\n				<tr>\n					<td><tmpl_var lock.label></td>\n					<td><tmpl_var lock.form></td>\n				</tr>\n				<tr>\n					<td><tmpl_var stick.label></td>\n					<td><tmpl_var sticky.form></td>\n				</tr>\n			</tmpl_if>\n		</tmpl_if>\n	</tmpl_if>\n	<tr>\n		<td></td>\n		<td><tmpl_if usePreview><tmpl_var form.preview></tmpl_if><tmpl_var form.submit></td>\n	</tr>\n</table>\n<tmpl_var form.footer>\n\n<tmpl_if isReply>\n	<div class=\"linkSubmissionFormContent\">\n		<b><tmpl_var reply.title></b><br /><br />\n		<tmpl_var reply.content>\n		<tmpl_if reply.userDefined1><p><a href=\"<tmpl_var reply.userDefined1>\" <tmpl_if reply.userDefined2>target=\"_blank\"</tmpl_if>><tmpl_var reply.userDefined1></a></p></tmpl_if>\n	</div>\n</tmpl_if>\n\n\n','Collaboration/PostForm',1,1,'PBtmpl0000000000000114',1147642423,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntable.linkSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"content\">\n		<table align=\"right\">\n		<tr><td align=\"center\">\n			<tmpl_if linkUrl>\n				<a href=\"<tmpl_var linkUrl>\">\n				<img src=\"<tmpl_var image.url>\" alt=\"<tmpl_var image.url>\" border=\"0\" /><br /><tmpl_var linkTitle>\n				</a>\n			<tmpl_else>\n				<img src=\"<tmpl_var image.url>\" alt=\"<tmpl_var image.url>\" border=\"0\" /><br /><tmpl_var linkTitle>\n			</tmpl_if>\n		</td></tr>\n		</table>\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n	<tmpl_if attachment.name><p><p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /> <tmpl_var attachment.name></a></p></p></tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	</td></tr></table>\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<p />\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr><td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" style=\"width:50%;\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td></tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000115',1147642423,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if error_loop>\n<ul class=\"fontSettings\">\n<tmpl_loop error_loop>\n	<li><b><tmpl_var error.message></b>\n</tmpl_loop>\n</ul>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<tmpl_if canEdit>\n	<div class=\"dataControls\">\n		<a href=\"<tmpl_var entryList.url>\"><tmpl_var entryList.label></a>\n		&bull; <a href=\"<tmpl_var export.tab.url>\"><tmpl_var export.tab.label></a>\n		<tmpl_if entryId>\n			&bull; <a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n			&bull; <a href=\"<tmpl_var addField.url>\"><tmpl_var addField.label></a>\n			&bull; <a href=\"<tmpl_var addTab.url>\"><tmpl_var addTab.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_if>\n\n<tmpl_var form.start>\n<table class=\"mailForm\">\n<tmpl_loop field_loop>\n	<tmpl_unless field.isHidden>\n		<tr><td class=\"formDescription\" valign=\"top\">\n		<tmpl_if session.var.adminOn><tmpl_if canEdit><tmpl_var field.controls></tmpl_if></tmpl_if>\n		<tmpl_var field.label>\n		</td><td class=\"tableData\" valign=\"top\">\n		<tmpl_if field.isDisplayed>\n			<tmpl_var field.value>\n		<tmpl_else>\n			<tmpl_var field.form>\n		</tmpl_if>\n		<tmpl_if field.isRequired>*</tmpl_if>\n		<span class=\"formSubtext\"><br /><tmpl_var field.subtext></span>\n		</td></tr>\n	</tmpl_unless>\n</tmpl_loop>\n<tr><td></td><td><tmpl_var form.send></td></tr>\n</table>\n\n<tmpl_var form.end>\n\n\n','DataForm',1,1,'PBtmpl0000000000000020',1147642424,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.mailForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n\n.dataControls a\n{\n	color:white;\n}\n\n</style>'),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n		<html>\n		<head>\n			<title>^Page(title); - <tmpl_var session.setting.companyName></title>\n				\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n	<link rel=\"SHORTCUT ICON\" href=\"^Extras(favicon.ico);\" />\n	<tmpl_var head.tags>\n	\n		<style type=\"text/css\">\n\n.content{\n  background-color: #ffffff;\n  color: #000000;\n  font-family: helvetica, arial;\n  font-size: 10pt;\n  padding: 10pt;\n}\n\nH1 {\n  font-family: helvetica, arial;\n  font-size: 16pt;\n}\n\nA {\n  color: #EF4200;\n}\n\n.pagination {\n  font-family: helvetica, arial;\n  font-size: 8pt;\n  text-align: center;\n}\n\n.formDescription {\n  font-family: helvetica, arial;\n  font-size: 10pt;\n  font-weight: bold;\n}\n\n.formSubtext {\n  font-family: helvetica, arial;\n  font-size: 8pt;\n}\n\n.highlight {\n  background-color: #dddddd;\n}\n\n.tableMenu {\n  background-color: #cccccc;\n  font-size: 8pt;\n  font-family: Helvetica, Arial;\n}\n\n.tableMenu a {\n  text-decoration: none;\n}\n\n.tableHeader {\n  background-color: #cccccc;\n  font-size: 10pt;\n  font-family: Helvetica, Arial;\n}\n\n.tableData {\n  font-size: 10pt;\n  font-family: Helvetica, Arial;\n}\n\n.pollAnswer {\n  font-family: Helvetica, Arial;\n  font-size: 8pt;\n}\n\n.pollColor {\n  background-color: #444444;\n}\n\n.pollQuestion {\n  font-face: Helvetica, Arial;\n  font-weight: bold;\n}\n\n.faqQuestion {\n  font-size: 12pt;\n  font-weight: bold;\n  color: #000000;\n}\n\n</style>\n		</head>\n		^AdminBar(\"\");\n\n<body onload=\"window.print()\">\n<div style=\"text-align:center;\"><a href=\"^PageUrl;\"><img src=\"^Extras(plainblack.gif);\" style=\"border-style:none;\" alt=\"\" /></a></div>\n\n<div>\n			<tmpl_var body.content>\n</div>		\n\n<div style=\"text-align:center;\">? 2001-2004 Plain Black LLC</div>\n</body>\n		</html>\n		\n','style',1,1,'PBtmpl0000000000000111',1147642424,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>Comparison</h2>\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"font-size: 11px; font-family: helvetica, arial, sans-serif;\">\n\n<tr>\n<td valign=\"top\"><tmpl_var compare.form></td>\n<td style=\"width:10px;\">&nbsp;</td>\n<td style=\"width:3px;background-color:silver;\">&nbsp;</td>\n<td style=\"width:10px;\">&nbsp;</td>\n<td valign=\"top\">\n\n<tmpl_if isTooMany>\nYou tried to compare too many listings. Please choose <tmpl_var maxCompares> or less at a time.\n</tmpl_if>\n\n<tmpl_if isTooFew>\nYou must choose at least two products to compare. Less than two isn\'t much of a comparison.\n</tmpl_if>\n\n\n<tmpl_unless isTooFew><tmpl_unless isTooMany>\n\n\n<table style=\"font-size: 11px; font-family: helvetica, arial, sans-serif;\" cellpadding=\"2\" cellspacing=\"2\" border=\"0\">\n<tr>\n  <td style=\"border-bottom:solid gray 1px;font-weight:bold;font-size:13px;\">Product</td>\n  <tmpl_loop product_loop>\n    <td style=\"border-bottom:solid gray 1px;\"><a href=\"<tmpl_var url>\"><tmpl_var name> <tmpl_var version></a></td>\n  </tmpl_loop>\n</tr>\n<tr>\n  <td class=\"lastUpdated\">Last Updated</td>\n  <tmpl_loop lastupdated_loop>\n    <td class=\"lastUpdated\" style=\"text-align:center;\"><tmpl_var lastupdated></td>\n  </tmpl_loop>\n</tr>\n\n<tmpl_loop category_loop>\n <tr><td class=\"category\"><b><tmpl_var category></b></td>\n  <tmpl_loop product_loop>\n    <td align=\"center\"><tmpl_var name></td>\n  </tmpl_loop>\n\n\n</tr>\n  <tmpl_loop row_loop>\n  <tr\n   <tmpl_if __ODD__>\n      class=\"odd\"\n   <tmpl_else>\n      class=\"even\"\n   </tmpl_if>\n   >\n    <tmpl_loop column_loop>\n      <td class=\"<tmpl_var class>\" <tmpl_if description>onmouseover=\"return escape(\'<tmpl_var description>\')\"</tmpl_if>>\n        <tmpl_var value>\n      </td>\n     </tmpl_loop>\n    </tr>\n   </tmpl_loop>\n  </tmpl_loop>\n</table>\n\n\n</tmpl_unless></tmpl_unless>\n\n</td></tr></table>\n','Matrix/Compare',1,1,'matrixtmpl000000000002',1147642424,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	.lastUpdated {\n		background-color:#F0F0F0;\n	}\n	.category {\n		font-size:13px;\n	}\n</style>'),('\n<h2><tmpl_var productName></h2>\n\n\n<table class=\"content\" border=\"0\" cellspacing=\"5\">\n<tr><td valign=\"top\">\n		<table class=\"content\">\n		<tr><td><b>Web Site</b></td><td><a onclick=\"window.open(\'<tmpl_var productUrl.click>\')\" href=\"#\"><tmpl_var productUrl></a></td></tr>\n		<tr><td><b>Version Number</b></td><td><tmpl_var versionNumber></td></tr>\n		<tr><td><b>Manufacturer</b></td><td><a onclick=\"window.open(\'<tmpl_var manufacturerUrl.click>\')\" href=\"#\"><tmpl_var manufacturerName></a></td></tr>\n		<tr><td><b>Last Updated</b></td><td><tmpl_var lastUpdated.date></td></tr>\n		<tr><td><b>Clicks</b></td><td><tmpl_var clicks></td></tr>\n		<tr><td><b>Views</b></td><td><tmpl_var views></td></tr>\n		<tr><td><b>Compares</b></td><td><tmpl_var compares></td></tr>\n		</table>\n	</td>\n	<td valign=\"top\" style=\"background-color:silver;\">&nbsp;</td>\n	<td valign=\"top\">\n		<tmpl_if description>\n			<b>Description</b><br />\n			<tmpl_var description><br /><br />\n		</tmpl_if>\n\n		<b>Contact Maintainer</b><br />\n		<tmpl_if email.wasSent>\n			<div style=\"color: green;\">Message sent.<br /></div>\n		</tmpl_if>\n		<tmpl_var email.form>\n	</td>\n	<td valign=\"top\" style=\"background-color:silver;\">&nbsp;</td>\n	<td valign=\"top\">\n		<tmpl_var ratings>\n	</td>\n</tr>\n</table>\n\n<p />\n\n<table width=\"100%\"  class=\"content\">\n<tr>\n	<td valign=\"top\" style=\"width:50%\">\n		<span class=\"category\">Features</span>\n		<table class=\"content\" width=\"180\">\n		<tmpl_if features>\n		<tmpl_loop features_loop>\n		<tr<tmpl_if __ODD__> class=\"odd\"<tmpl_else> class=\"even\"</tmpl_if>>\n			<td onmouseover=\"return escape(\'<tmpl_var description>\')\"><tmpl_var label></td>\n			<td><tmpl_var value></td>\n		</tr>\n		</tmpl_loop>\n		<tmpl_else>\n			<tr><td>&#160;</td></tr>\n		</tmpl_if>\n		</table>\n		\n		<p />\n	</td>\n	<td valign=\"top\" style=\"width:50%;\">\n		<span class=\"category\">Benefits</span>\n		<table class=\"content\" width=\"180\">\n		<tmpl_if features>\n		<tmpl_loop benefits_loop>\n		<tr<tmpl_if __ODD__> class=\"odd\"<tmpl_else> class=\"even\"</tmpl_if>>\n			<td onmouseover=\"return escape(\'<tmpl_var description>\')\"><tmpl_var label></td>\n			<td class=\"<tmpl_var class>\"><tmpl_var value></td>\n		</tr>\n		</tmpl_loop>\n		<tmpl_else>\n			<tr><td>&#160;</td></tr>\n		</tmpl_if>\n		</table>\n	</td>\n</tr>\n</table>\n\n<p />\n\n<tmpl_var discussion>\n\n<tmpl_if user.canEdit>\n  <br /> <hr /><a href=\"<tmpl_var edit.url>\">Edit this listing.</a> <br />\n</tmpl_if>\n<tmpl_if user.canApprove>\n <tmpl_if isPending>\n   <a href=\"<tmpl_var approve.url>\">Approve this listing.</a><br />\n </tmpl_if>\n   <a href=\"<tmpl_var delete.url>\">Delete this listing.</a><br />\n  \n</tmpl_if>\n','Matrix/Detail',1,1,'matrixtmpl000000000003',1147642424,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.ratingForm {\n font-size: 9px;\n}\n.statBox {\n	width:100%;\n}\n</style>\n\n'),('<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n<h2><tmpl_var title></h2>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<table width=\"100%\" class=\"matrixDefault\">\n<tr><td valign=\"top\" class=\"leftColumn\">\n<p>Use the form below to select up to <tmpl_var maxCompares> listings to compare at once.\n</p>\n\n<div>\n<tmpl_var compare.form>\n</div>\n\n</td><td valign=\"top\">\n\n\n<p class=\"grayBox\">\n<b>Narrow The Matrix</b><br />\nYou can narrow the scope of the matrix by <a href=\"<tmpl_var search.url>\">searching</a> for exactly the criteria you\'re looking for in a listing.\n</p>\n\n\n<p class=\"grayBox\">\n<b>Expand The Matrix</b><br />\n<tmpl_if isLoggedIn>\n   <a href=\"<tmpl_var listing.add.url>\">Click here to add a new listing.</a> Please note that you will be the official maintainer of the listing, and will be responsible for keeping it up to date.\n<tmpl_else>\nIf you are the maker of a product, or are an expert user and are willing to maintain the listing, <a href=\"^a(linkonly);\">create an account</a> so you can register your listing.\n</tmpl_if>\n\n</p>\n\n\n\n<br /><b>Listing Statistics</b><br />\n<table width=\"100%\" border=\"0\" class=\"stats\">\n<tr>\n  <td class=\"columnOne\">Most clicks:</td>\n  <td class=\"columnTwo\"><tmpl_var best.clicks.count></td>\n  <td class=\"columnThree\"><a href=\"<tmpl_var best.clicks.url>\"><tmpl_var best.clicks.name></a></td>\n</tr>\n<tr>\n  <td>Most views:</td>\n  <td><tmpl_var best.views.count></td>\n  <td><a href=\"<tmpl_var best.views.url>\"><tmpl_var best.views.name></a></td>\n</tr>\n<tr>\n  <td>Most compares:</td>\n  <td><tmpl_var best.compares.count></td>\n  <td><a href=\"<tmpl_var best.compares.url>\"><tmpl_var best.compares.name></a></td>\n</tr>\n<tr>\n  <td>Most recently updated:</td>\n  <td><tmpl_var best.updated.date></td>\n  <td><a href=\"<tmpl_var best.updated.url>\"><tmpl_var best.updated.name></a></td>\n</tr>\n<tr>\n  <td colspan=\"3\" class=\"hrStyle\">^Spacer(1,1);</td>\n</tr>\n<tr>\n  <td align=\"center\" colspan=\"3\">Best Rated By Users</td>\n</tr>\n<tmpl_loop best_rating_loop>\n<tr>\n  <td><tmpl_var category></td>\n  <td><tmpl_var mean>/10</td>\n  <td><a href=\"<tmpl_var url>\"><tmpl_var name></a></td>\n</tr>\n</tmpl_loop>\n\n\n<tr>\n  <td colspan=\"3\" class=\"hrStyle\">^Spacer(1,1);</td>\n</tr>\n<tr>\n  <td colspan=\"3\" align=\"center\"><a href=\"<tmpl_var ratings.details.url>\">View Ratings Details</a></td>\n</tr>\n<tr>\n  <td colspan=\"3\" class=\"hrStyle\">^Spacer(1,1);</td>\n</tr>\n\n\n<tr>\n  <td align=\"center\" colspan=\"3\">Worst Rated By Users</td>\n</tr>\n<tmpl_loop worst_rating_loop>\n<tr>\n  <td><tmpl_var category></td>\n  <td><tmpl_var mean>/10</td>\n  <td><a href=\"<tmpl_var url>\"><tmpl_var name></a></td>\n</tr>\n</tmpl_loop>\n\n<tr>\n  <td colspan=\"3\" class=\"hrStyle\">^Spacer(1,1);</td>\n</tr>\n\n</table>\n\n<br />\n<br /><b>Site Statistics</b><br />\n<table class=\"content\">\n<tr>\n  <td>Listing Count:</td>\n  <td><tmpl_var listing.count></td>\n</tr>\n<tr>\n  <td>Current Visitors:</td>\n  <td><tmpl_var current.user.count></td>\n</tr>\n<tr>\n  <td>Registered Users:</td>\n  <td><tmpl_var user.count></td>\n</tr>\n</table>\n\n\n\n\n<tmpl_if session.var.adminOn>\n<p>   <a href=\"<tmpl_var field.list.url>\">List Fields</a> \n</p>\n<tmpl_if pending_list>\n<b>PENDING LISTINGS:</b>\n</tmpl_if>\n<ul>\n<tmpl_loop pending_list>\n<li><a href=\"<tmpl_var url>\"><tmpl_var productName></a></li>\n</tmpl_loop>\n</ul>\n</tmpl_if>\n\n</td></tr></table>\n','Matrix',1,1,'matrixtmpl000000000001',1147642424,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2 {\n	font-family:arial;\n}\n.fontSettings {\n	font-size:9pt;\n	font-family:arial;\n}\n.matrixDefault {\n	\n}\n.matrixDefault td {\n	font-size:9pt;\n	font-family:arial;\n}\n.matrixDefault .leftColumn {\n	width:48%;\n}\n.matrixDefault .grayBox {\n	background-color:#DADADA;\n	padding:3px;\n	-moz-box-sizing:border-box;\n	border-bottom:solid gray 2px;\n}\n.matrixDefault .stats .columnOne{\n	width:30%;\n}\n.matrixDefault .stats .columnTwo{\n	width:20%;\n}\n.matrixDefault .stats .columnThree{\n	width:50%;\n}\n.hrStyle {\n	border-bottom:solid black 1px;\n	height:1px;\n	width:100%;\n}\n\n</style>\n'),('<h2>Rating Detail</h2>\n\n<table class=\"content\" cellpadding=\"5\" width=\"60%\">\n<tbody>\n<tmpl_loop rating_loop>\n<tmpl_if __ODD__>\n<tr>\n</tmpl_if>\n\n	<td style=\"width:50%\" valign=\"top\">\n	<h2><tmpl_var category></h2>\n\n	<table class=\"content\">\n	<tbody>\n	<tr><th>Listing</th><th>Mean</th><th>Median</th><th>Count</th></tr>\n	<tmpl_loop detail_loop>\n\n	<tr>\n	<td><a href=\"<tmpl_var url>\"><tmpl_var name></a></td>\n	<td><tmpl_var mean></td>\n	<td><tmpl_var median></td>\n	<td><tmpl_var count></td>\n	</tr>\n\n	</tmpl_loop>\n	</tbody>\n	</table>\n	</td>\n\n<tmpl_if __EVEN__>\n</tr>\n</tmpl_if>\n</tr>\n</tmpl_loop>\n\n</tbody>\n</table>\n','Matrix/RatingDetail',1,1,'matrixtmpl000000000004',1147642425,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2>Search The Matrix</h2>\n\n<tmpl_if isTooFew>\n	<p class=\"fontSettings\">Your search returned no results. Try specifying a few less criteria.</p>\n</tmpl_if>\n\n<tmpl_if isTooMany>\n<p class=\"fontSettings\">\n	Your search returned too many results. Either select up to <tmpl_var maxCompares> products from the list below, or specify more critera.\n</p>\n</tmpl_if>\n\n\n<table width=\"100%\" class=\"matrixSearch\" border=\"0\">\n<tr>\n	<td valign=\"top\">\n		<tmpl_var compare.form>\n	</td>\n	<td valign=\"top\">\n		<tmpl_var form.header>\n		<tmpl_var form.submit>\n		<table width=\"100%\"  class=\"content\">\n		<tr>\n			<td valign=\"top\" style=\"width:50%;\">\n				<span class=\"category\">Features</span>\n				<table class=\"content\" width=\"180\">\n				<tmpl_if features>\n					<tmpl_loop features_loop>\n					<tr<tmpl_if __ODD__> class=\"odd\"<tmpl_else> class=\"even\"</tmpl_if>>\n						<td onmouseover=\"return escape(\'<tmpl_var description>\')\"><tmpl_var label></td>\n						<td><tmpl_var form></td>\n					</tr>\n					</tmpl_loop>\n				<tmpl_else>\n					<tr><td>&#160;</td></tr>\n				</tmpl_if>\n				</table>\n			</td>\n			<td valign=\"top\" style=\"width:50%;\">\n				<span class=\"category\">Benefits</span>\n				<table class=\"content\">\n				<tmpl_if features>\n					<tmpl_loop benefits_loop>\n					<tr<tmpl_if __ODD__> class=\"odd\"<tmpl_else> class=\"even\"</tmpl_if>>\n						<td onmouseover=\"return escape(\'<tmpl_var description>\')\"><tmpl_var label></td>\n						<td><tmpl_var form></td>\n					</tr>\n					</tmpl_loop>\n				<tmpl_else>\n					<tr><td>&#160;</td></tr>\n				</tmpl_if>\n				</table>\n			</td>\n		</tr>\n</table>\n\n<tmpl_var form.submit>\n</div>\n<tmpl_var form.footer>\n\n\n</td></tr></table>\n','Matrix/Search',1,1,'matrixtmpl000000000005',1147642425,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2 {\n	font-family:arial;\n}\n.fontSettings {\n	font-size:9pt;\n	font-family:arial;\n}\n.matrixSearch td {\n	font-size:9pt;\n	font-family:arial;\n}\n.matrixSearch .leftColumn {\n	width:48%;\n}\n.matrixSearch .grayBox {\n	background-color:#DADADA;\n	padding:3px;\n	-moz-box-sizing:border-box;\n	border-bottom:solid gray 2px;\n}\n.matrixSearch .stats .columnOne{\n	width:30%;\n}\n.matrixSearch .stats .columnTwo{\n	width:20%;\n}\n.matrixSearch .stats .columnThree{\n	width:50%;\n}\n.hrStyle {\n	border-bottom:solid black 1px;\n	height:1px;\n	width:100%;\n}\n\n</style>'),('<a name=\"<tmpl_var assetId>\"></a> \n \n<tmpl_if session.var.adminOn> \n   <p><tmpl_var controls></p> \n</tmpl_if>\n\n<tmpl_if displayTitle>\n    <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n    <tmpl_var description><p />\n</tmpl_if>\n<script type=\"text/javascript\">\nfunction domultisearch() {\nvar sf=document.getElementById(\"multisearchform\");\nvar submitto = sf.sengines.options[sf.sengines.selectedIndex].value + escape(sf.searchterms.value);\nwindow.open(submitto);\nreturn false;\n}\n</script>\n<div style=\"width:100%\">\n<form id=\"multisearchform\" onsubmit=\"return domultisearch();\" action=\"\">\n<table cellpadding=\"2\" cellspacing=\"0\" class=\"multiSearch\" border=\"0\">\n<tr>\n	<td align=\"right\">Search:</td>\n	<td>\n		<select name=\"sengines\">\n			<option value=\"http://www.google.com/search?q=\" selected=\"selected\">Google</option>\n			<option value=\"http://news.google.com/news?q=\">Google News</option>\n			<option value=\"http://www.flickr.com/photos/tags/\">Flickr Photos</option>\n			<option value=\"http://www.digg.com/search?submit=Submit&amp;search=\">Digg.com</option>\n			<option value=\"http://www.altavista.com/web/results?q=\">Alta Vista</option>\n			<option value=\"http://search.yahoo.com/search?p=\">Yahoo!</option>\n		</select>\n	</td>\n</tr>\n<tr>\n	<td align=\"right\">For:</td>\n	<td><input type=\"text\" name=\"searchterms\" />&#160;<input type=\"submit\" name=\"SearchSubmit\" value=\"Search\" /></td>\n</tr>\n</table>\n</form>\n</div>\n','MultiSearch',1,1,'MultiSearchTmpl0000001',1147642425,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.multiSearch {\n	background-color:#DADADA;\n	border:solid gray 1px;	\n}\n</style>\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div>\n\n<!-- end position 1 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<!-- begin position 2 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<!-- begin position 3 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position3\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position3_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div> </div>\n<!-- end position 3 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<!-- begin position 4 -->\n<div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position4\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position4_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div>\n<!-- end position 4 -->\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n	<tmpl_var dragger.init>\n</tmpl_if>\n','Layout',1,1,'PBtmpl0000000000000094',1147642425,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.firstColumn {\n	float: left;\n	width: 50%;\n}\n.secondColumn {\n	float: left;\n	width: auto;\n	max-width: 50%;\n}\n.endFloat {\n	clear: both;\n}\n</style>\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<ol>\n	<tmpl_loop post_loop>\n		<li>\n			<tmpl_if user.isPoster>\n				<tmpl_unless session.var.adminOn>\n					[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n				</tmpl_unless>\n			</tmpl_if>\n			<tmpl_if user.isModerator>\n				<tmpl_if session.var.adminOn>\n					<tmpl_var controls>\n				<tmpl_else>\n					<tmpl_unless user.isPoster>\n						<tmpl_unless session.var.adminOn>\n							[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n						</tmpl_unless>\n					</tmpl_unless>\n				</tmpl_if>\n				(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n			</tmpl_if>\n			<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n			<tmpl_if content>\n					  - <tmpl_var content>\n			</tmpl_if>\n		</li>\n	</tmpl_loop>\n</ol>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000101',1147642426,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<br />\n\n<tmpl_loop post_loop>\n	<div class=\"picture\">\n		<div style=\"text-align: center;\">\n			<tmpl_if user.isPoster><div>(<tmpl_var status>)</div></tmpl_if>\n			<div><a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" alt=\"<tmpl_var title>\" /></a></div>\n			<div><a href=\"<tmpl_var url>\"><tmpl_var title></a></div>\n		</div>\n	</div>\n</tmpl_loop>\n\n<div style=\"clear: both;\"></div>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000121',1147642426,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.picture {\n	padding: 0px;\n	margin: 10px;\n	float: left;\n	width: 150px;\n	font-size: 12px;\n	height: 100px;\n	overflow: hidden;\n}\n\n.picture img\n{\n	border: black solid 0px;\n}\n</style>\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"postControls\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<div>[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]</div>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<div>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n		</div>\n	</tmpl_if>\n	<p class=\"posts\">\n		<b>Q: <tmpl_var title></b>\n		A: <tmpl_var content>\n	</p>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration',1,1,'PBtmpl0000000000000081',1147642426,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.postControls\n{\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}\n\n.posts\n{\n	width:95%;\n	border:solid 1px gray;\n	padding:3px;\n	font-family:arial;\n}\n\n.posts b\n{\n	-moz-box-sizing:border-box;\n	background-color:silver;\n	width:100%;\n	display:block;\n	padding:3px;\n	margin-bottom:3px;\n}\n\n</style>'),('<h2>RandomThread macro debug output:</h2>\n<dl>\n<dt>approve.url:</dt> <dd><tmpl_var approve.url></dd>\n<dt>assetId:</dt> <dd><tmpl_var assetId></dd>\n<dt>assetSize:</dt> <dd><tmpl_var assetSize></dd>\n\n<dt>&lt;tmpl_loop attachment_loop&gt;:</dt>\n<dd><tmpl_loop attachment_loop>\n<dt>filename:</dt> <dd><tmpl_var filename></dd>\n<dt>icon:</dt> <dd><tmpl_var icon></dd>\n<dt>isImage:</dt> <dd><tmpl_var isImage></dd>\n<dt>thumbnail:</dt> <dd><tmpl_var thumbnail></dd>\n<dt>url:</dt> <dd><tmpl_var url></dd>\n</tmpl_loop>&lt;/tmpl_loop&gt;\n</dd>\n\n<dt>attachment.icon:</dt> <dd><tmpl_var attachment.icon></dd>\n<dt>attachment.thumbnail:</dt> <dd><tmpl_var attachment.thumbnail></dd>\n<dt>attachment.url:</dt> <dd><tmpl_var attachment.url></dd>\n<dt>className:</dt> <dd><tmpl_var className></dd>\n<dt>content:</dt> <dd><tmpl_var content></dd>\n<dt>contentType:</dt> <dd><tmpl_var contentType></dd>\n<dt>createdBy:</dt> <dd><tmpl_var createdBy></dd>\n<dt>creationDate:</dt> <dd><tmpl_var creationDate></dd>\n<dt>dateSubmitted:</dt> <dd><tmpl_var dateSubmitted></dd>\n<dt>dateSubmitted.human:</dt> <dd><tmpl_var dateSubmitted.human></dd>\n<dt>dateUpdated:</dt> <dd><tmpl_var dateUpdated></dd>\n<dt>dateUpdated.human:</dt> <dd><tmpl_var dateUpdated.human></dd>\n<dt>delete.url:</dt> <dd><tmpl_var delete.url></dd>\n<dt>deny.url:</dt> <dd><tmpl_var deny.url></dd>\n<dt>edit.url:</dt> <dd><tmpl_var edit.url></dd>\n<dt>encryptPage:</dt> <dd><tmpl_var encryptPage></dd>\n<dt>endDate:</dt> <dd><tmpl_var endDate></dd>\n<dt>extraHeadTags:</dt> <dd><tmpl_var extraHeadTags></dd>\n<dt>groupIdEdit:</dt> <dd><tmpl_var groupIdEdit></dd>\n<dt>groupIdView:</dt> <dd><tmpl_var groupIdView></dd>\n<dt>hasRated:</dt> <dd><tmpl_var hasRated></dd>\n<dt>image.url</dt> <dd><tmpl_var image.url></dd>\n<dt>image.thumbnail</dt> <dd><tmpl_var image.thumbnail></dd>\n<dt>isHidden:</dt> <dd><tmpl_var isHidden></dd>\n<dt>isLocked:</dt> <dd><tmpl_var isLocked></dd>\n<dt>isLockedBy:</dt> <dd><tmpl_var isLockedBy></dd>\n<dt>isMarkedRead:</dt> <dd><tmpl_var isMarkedRead></dd>\n<dt>isPackage:</dt> <dd><tmpl_var isPackage></dd>\n<dt>isPrototype:</dt> <dd><tmpl_var isPrototype></dd>\n<dt>isSticky:</dt> <dd><tmpl_var isSticky></dd>\n<dt>isSystem:</dt> <dd><tmpl_var isSystem></dd>\n<dt>lastPostDate:</dt> <dd><tmpl_var lastPostDate></dd>\n<dt>lastPostId:</dt> <dd><tmpl_var lastPostId></dd>\n<dt>lineage:</dt> <dd><tmpl_var lineage></dd>\n<dt>menuTitle:</dt> <dd><tmpl_var menuTitle></dd>\n<dt>newWindow:</dt> <dd><tmpl_var newWindow></dd>\n<dt>ownerUserId:</dt> <dd><tmpl_var ownerUserId></dd>\n<dt>parentId:</dt> <dd><tmpl_var parentId></dd>\n<dt>rate.url.1:</dt> <dd><tmpl_var rate.url.1></dd>\n<dt>rate.url.2:</dt> <dd><tmpl_var rate.url.2></dd>\n<dt>rate.url.3:</dt> <dd><tmpl_var rate.url.3></dd>\n<dt>rate.url.4:</dt> <dd><tmpl_var rate.url.4></dd>\n<dt>rate.url.5:</dt> <dd><tmpl_var rate.url.5></dd>\n<dt>rating:</dt> <dd><tmpl_var rating></dd>\n<dt>rating.value:</dt> <dd><tmpl_var rating.value></dd>\n<dt>replies:</dt> <dd><tmpl_var replies></dd>\n<dt>reply.url:</dt> <dd><tmpl_var reply.url></dd>\n<dt>reply.withquote.url:</dt> <dd><tmpl_var reply.withquote.url></dd>\n<dt>revisedBy:</dt> <dd><tmpl_var revisedBy></dd>\n<dt>revisionDate:</dt> <dd><tmpl_var revisionDate></dd>\n<dt>startDate:</dt> <dd><tmpl_var startDate></dd>\n<dt>state:</dt> <dd><tmpl_var state></dd>\n<dt>stateChanged:</dt> <dd><tmpl_var stateChanged></dd>\n<dt>stateChangedBy:</dt> <dd><tmpl_var stateChangedBy></dd>\n<dt>status:</dt> <dd><tmpl_var status></dd>\n<dt>storageId:</dt> <dd><tmpl_var storageId></dd>\n<dt>subscriptionGroupId:</dt> <dd><tmpl_var subscriptionGroupId></dd>\n<dt>synopsis:</dt> <dd><tmpl_var synopsis></dd>\n<dt>tagId:</dt> <dd><tmpl_var tagId></dd>\n<dt>threadId:</dt> <dd><tmpl_var threadId></dd>\n<dt>title:</dt> <dd><tmpl_var title></dd>\n<dt>title.short:</dt> <dd><tmpl_var title.short></dd>\n<dt>url:</dt> <dd><tmpl_var url></dd>\n<dt>user.canEdit:</dt> <dd><tmpl_var user.canEdit></dd>\n<dt>user.isPoster:</dt> <dd><tmpl_var user.isPoster></dd>\n<dt>userDefined1:</dt> <dd><tmpl_var userDefined1></dd>\n<dt>userDefined2:</dt> <dd><tmpl_var userDefined2></dd>\n<dt>userDefined3:</dt> <dd><tmpl_var userDefined3></dd>\n<dt>userDefined4:</dt> <dd><tmpl_var userDefined4></dd>\n<dt>userDefined5:</dt> <dd><tmpl_var userDefined5></dd>\n<dt>userId:</dt> <dd><tmpl_var userId></dd>\n<dt>userProfile.url:</dt> <dd><tmpl_var userProfile.url></dd>\n<dt>username:</dt> <dd><tmpl_var username></dd>\n<dt>views:</dt> <dd><tmpl_var views></dd>\n</dl>\n','Macro/RandomThread',1,1,'WVtmpl0000000000000001',1147642426,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n  <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 1 -->\n\n<!-- begin position 2 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n            <tmpl_var dragger.init>\n</tmpl_if>\n','Layout',1,1,'PBtmpl0000000000000131',1147642426,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 65%;\n}\n.secondColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n<tmpl_if showAdmin>\n<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n  <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_var form_header>\n<tmpl_var form_keywords> <tmpl_var form_submit>\n<tmpl_var form_footer>\n\n<tmpl_if session.form.doit>\n	<tmpl_loop result_set>\n		<dl>\n			<dt><a href=\"^/;<tmpl_var url>\"><tmpl_var title></a></dt>\n			<dd><tmpl_var synopsis></dd>\n		</dl>\n	</tmpl_loop>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\">\n			<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n		</div>\n	</tmpl_if>\n</tmpl_if>\n\n','Search',1,1,'PBtmpl0000000000000200',1147642427,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 1 -->\n\n<!-- begin position 2 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n		<tr id=\"td<tmpl_var id>\">\n		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n		</div></td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n	</tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n	<tmpl_var dragger.init>\n</tmpl_if>\n','Layout',1,1,'PBtmpl0000000000000135',1147642427,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.firstColumn {\n	float: left;\n	width: 50%;\n}\n\n.secondColumn {\n	float: left;\n	width: auto;\n	max-width: 50%;\n}\n\n.endFloat {\n	clear: both;\n}\n</style>\n\n'),('<a name=\"<tmpl_var assetId>\"></a> \n \n<tmpl_if session.var.adminOn> \n   <p><tmpl_var controls></p> \n</tmpl_if>\n\n<tmpl_if displayTitle>\n    <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n    <tmpl_var description><p />\n</tmpl_if>\n\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"qmmt_main\" width=\"100%\">\n   <tr>\n      <td colspan=\"3\" style=\"text-align: left\">  \n	     <div class=\"qmmt_header_bar\" style=\"padding-top: 1px; padding-bottom: 1px; border-bottom-width: 1px;\">\n		    <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\">   \n			  <tr>\n			     <td class=\"qmmt_header_text\">Stock Watch</td>\n				 <td class=\"qmmt_header_text\" style=\"text-align: right; padding-right: 3px; font-weight: normal;\">\n				    <div id=\"qm_textChange_7310\">\n					   <span class=\"qmmt_header_text\" style=\"font-weight:normal;\"><b>Last Update: </b> <tmpl_var lastUpdate.default> EDT</span></div>\n					      <script type=\"text/javascript\">\n						     function qm_UpdateText_7310(phase){    \n							   switch (phase)    {        \n							      case 1: document.getElementById(\'qm_textChange_7310\').innerHTML = \'<span class=\"qmmt_header_text\" style=\"font-weight:normal;\">delayed 20 minutes</span>\'; \n                                   setTimeout(\"qm_UpdateText_7310(2)\", 5000); \n								   break;        \n								  case 2: document.getElementById(\'qm_textChange_7310\').innerHTML = \'<span class=\"qmmt_header_text\" style=\"font-weight:normal;\"><b>Last Update:&nbsp;</b> <tmpl_var lastUpdate.default> EDT</span>\'; \n                                   setTimeout(\"qm_UpdateText_7310(3)\", 5000); \n								   break;        \n								  case 3: document.getElementById(\'qm_textChange_7310\').innerHTML = \'<a href=\"http://www.quotemedia.com/\" style=\"text-decoration:none;\"><span class=\"qmmt_header_text\" style=\"font-weight:normal;\">Yahoo Finance</span></a>\';\n                                   setTimeout(\"qm_UpdateText_7310(1)\", 5000); \n								   break;        \n								}        \n							 }\n							 qm_UpdateText_7310(2);\n						 </script> \n    \n				  </td>       \n				</tr>  \n		     </table>  \n	      </div>  \n	   </td> \n	</tr>  \n	<tr>  \n	   <td>       \n	      <script type=\"text/javascript\"> \n		     function openDetail_2961(symbol) {     \n			    var w = 670;   \n				var h = 286;   \n				var winl = (screen.width - w) / 2;   \n				var wint = (screen.height - h) / 2;   \n			    var winprops =\'height=\'+h+\',width=\'+w+\',top=\'+wint+\',left=\'+winl+\',toolbar=0,location=0,directories=0,status=0,menubar=0,scrollbars=0,resizable=1\';   \n				win = window.open(\"<tmpl_var stock.display.url>\" + escape(symbol), \"DetailedQuote\", winprops);\n				if (parseInt(navigator.appVersion) >= 4) {       \n				   win.window.focus();   \n				}   \n		      }\n		   </script>    \n		   <table cellpadding=\"0\" cellspacing=\"0\" style=\"padding: 2px;\" width=\"100%\">   \n		      <tr class=\"qmmt_main\">\n			     <td class=\"qmmt_text\" style=\"font-weight: bold; text-align: left; padding-left: 3px;white-space:nowrap;\"> Name </td>        \n				 <td class=\"qmmt_text\" style=\"font-weight: bold; text-align: left; padding-left: 3px; white-space:nowrap;width:8%;\">Symbol</td>    \n				 <td class=\"qmmt_text\" style=\"font-weight: bold; text-align: right; white-space:nowrap;width:9%;\">Last</td>\n				 <td class=\"qmmt_text\" style=\"font-weight: bold; text-align: center; white-space:nowrap;width:4%\">Tick</td>        \n				 <td class=\"qmmt_text\" style=\"font-weight: bold; text-align: right; white-space:nowrap; width:7%;\">Chg</td>         \n	          </tr>\n			  <tmpl_loop stocks.loop>\n			     <tr class=\'<tmpl_if __ODD__>qmmt_cycle<tmpl_else>qmmt_main</tmpl_if>\'>            \n			        <td class=\"qmmt_text\" style=\"padding-left: 3px;white-space:nowrap;\"><tmpl_var stocks.name></td>\n				    <td class=\"qmmt_text\" style=\"text-align: left; padding-left: 3px;white-space:nowrap;\">\n				       <a class=\"qmmt\" style=\"text-decoration: none;\" href=\"javascript:openDetail_2961(\'<tmpl_var stocks.symbol>\')\"><tmpl_var stocks.symbol></a>\n			        </td>        \n				    <td class=\"qmmt_text\" style=\"text-align: right;white-space:nowrap;\"><tmpl_var stocks.last></td>\n				    <td class=\"qmmt_text\" style=\"text-align: center;white-space:nowrap;\" align=\"right\">\n					   <img src=\"<tmpl_var extrasFolder>/<tmpl_var stocks.net.icon>\" alt=\"\" />            \n				    </td>\n				    <td class=\"qmmt_text<tmpl_if stocks.net.isUp>_up<tmpl_else><tmpl_if stocks.net.isDown>_down</tmpl_if></tmpl_if>\" style=\"text-align: right;whitespace:nowrap;\"><tmpl_var stocks.net></td>\n			     </tr>          \n			  </tmpl_loop>  \n			</table>      \n	     </td> \n	  </tr>\n  </table>\n','StockData',1,1,'StockDataTMPL000000001',1147642427,'WebGUI::Asset::Template::HTMLTemplate','<link rel=\"stylesheet\" type=\"text/css\" href=\"<tmpl_var extrasFolder>/tools.css\" />\n'),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>WebGUI <tmpl_var session.webgui.version>-<tmpl_var session.webgui.status> Admin Console</title>\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n	<link rel=\"shortcut icon\" href=\"^Extras(favicon.ico);\" />\n	<tmpl_var head.tags>\n</head>\n<body>\n	<tmpl_var body.content>\n</body>\n</html>\n','style',1,0,'PBtmpl0000000000000137',1147642427,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<h2><tmpl_var name></h2>\n<tmpl_var description><br>\n<br />\n<br />\n$ <tmpl_var price><br />\n<a href=\"<tmpl_var url>\">Subscribe now</a><br />','Macro/SubscriptionItem',1,1,'PBtmpl0000000000000046',1147642428,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description><p />\n</tmpl_if>\n\n<h2>\n<tmpl_if channel.link>\n	<a href=\"<tmpl_var channel.link>\"><tmpl_var channel.title></a>\n<tmpl_else>\n	<tmpl_var channel.title>\n</tmpl_if>\n</h2>\n\n<tmpl_if channel.description>\n	<tmpl_var channel.description><p />\n</tmpl_if>\n\n<tmpl_loop item_loop>\n	<b><tmpl_var title></b>\n	<tmpl_if description>\n		<br />\n		<tmpl_var description>\n	</tmpl_if>\n	<tmpl_if link>\n		<br />\n		<a href=\"<tmpl_var link>\" style=\"font-size: 9px;\">Read More...</a>\n	</tmpl_if>\n	<br />\n	<br />\n</tmpl_loop>\n','SyndicatedContent',1,1,'GNvjCFQWjY2AF2uf0aCM8Q',1147642428,'WebGUI::Asset::Template::HTMLTemplate',NULL),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<div class=\"synopsis\">\n<tmpl_loop page_loop>\n   <div class=\"synopsis_title\">\n      <a href=\"<tmpl_var page.url>\"><tmpl_var page.menuTitle></a>\n   </div>\n   <tmpl_if page.indent>\n      <div class=\"synopsis_sub\">\n         <tmpl_var page.synopsis>\n      </div>\n   <tmpl_else>\n      <div class=\"synopsis_summary\">\n         <tmpl_var page.synopsis>\n      </div>\n   </tmpl_if>\n</tmpl_loop>\n</div>','Navigation',1,1,'PBtmpl0000000000000136',1147642428,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if error_loop>\n	<ul class=\"fontSettings\">\n		<tmpl_loop error_loop>\n			<li><b><tmpl_var error.message></b></li>\n		</tmpl_loop>\n	</ul>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<tmpl_if canEdit>\n	<div class=\"dataControls\">\n		<a href=\"<tmpl_var entryList.url>\"><tmpl_var entryList.label></a>\n			&bull; <a href=\"<tmpl_var export.tab.url>\"><tmpl_var export.tab.label></a>\n		<tmpl_if entryId>\n			&bull; <a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n			&bull; <a href=\"<tmpl_var addField.url>\"><tmpl_var addField.label></a>\n			&bull; <a href=\"<tmpl_var addTab.url>\"><tmpl_var addTab.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_if>\n<tmpl_var form.start>\n\n<div class=\"tabs\">\n	<tmpl_loop tab_loop>\n		<span onclick=\"toggleTab(<tmpl_var tab.sequence>)\" id=\"tab<tmpl_var tab.sequence>\" class=\"tab\"><tmpl_var tab.label>\n		<tmpl_if session.var.adminOn>\n			<tmpl_if canEdit>\n				<tmpl_var tab.controls>\n			</tmpl_if>\n		</tmpl_if>\n		</span>\n	</tmpl_loop>\n</div>\n<tmpl_loop tab_loop>\n	<tmpl_var tab.start>\n		<table class=\"tabForm\">\n			<tmpl_loop tab.field_loop>\n				<tmpl_unless tab.field.isHidden>\n						<tr>\n							<td class=\"formDescription\" valign=\"top\">\n								<tmpl_if session.var.adminOn>\n									<tmpl_if canEdit>\n										<tmpl_var tab.field.controls>\n									</tmpl_if>\n								</tmpl_if>\n								<tmpl_var tab.field.label>\n							</td>\n							<td class=\"tableData\" valign=\"top\">\n								<tmpl_if tab.field.isDisplayed>\n									<tmpl_var tab.field.value>\n								<tmpl_else>\n									<tmpl_var tab.field.form>\n								</tmpl_if>\n								<tmpl_if tab.field.isRequired>*</tmpl_if>\n								<span class=\"formSubtext\">\n									<br />\n									<tmpl_var tab.field.subtext>\n								</span>\n							</td>\n						</tr>\n				</tmpl_unless>\n			</tmpl_loop>\n			<tr>\n				<td colspan=\"2\">\n					<span class=\"tabSubtext\"><tmpl_var tab.subtext></span>\n				</td>\n			</tr>\n		</table>\n		<br />\n		<tmpl_var form.save>\n	<tmpl_var tab.end>\n</tmpl_loop>\n<tmpl_var tab.init>\n<tmpl_var form.end>\n\n\n','DataForm',1,1,'PBtmpl0000000000000116',1147642428,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.tabForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n\n.dataControls a\n{\n	color:white;\n}\n</style>'),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<tmpl_loop page_loop>\n   <tmpl_if page.isCurrent>\n      <span class=\"rootTabOn\">\n   <tmpl_else>\n      <span class=\"rootTabOff\">\n   </tmpl_if>\n   <a  <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   </span>\n</tmpl_loop>','Navigation',1,1,'PBtmpl0000000000000124',1147642429,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n	<br />\n</tmpl_if>\n\n<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"threeColumns\">\n<tr>\n	<td align=\"center\">\n		<tmpl_if thumbnail1>\n			<a href=\"<tmpl_var image1>\"><img src=\"<tmpl_var thumbnail1>\" alt=\"<tmpl_var thumbnail1>\" class=\"noBorder\" /></a>\n		</tmpl_if>\n	</td>\n	<td align=\"center\">\n		<tmpl_if thumbnail2>\n			<a href=\"<tmpl_var image2>\"><img src=\"<tmpl_var thumbnail2>\" alt=\"<tmpl_var thumbnail2>\" class=\"noBorder\" /></a>\n		</tmpl_if>\n	</td>\n	<td align=\"center\">\n		<tmpl_if thumbnail3>\n			<a href=\"<tmpl_var image3>\"><img src=\"<tmpl_var thumbnail3>\" alt=\"<tmpl_var thumbnail3>\" class=\"noBorder\" /></a>\n		</tmpl_if>\n	</td>\n</tr>\n</table>\n\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"5\" width=\"100%\" class=\"threeColumns\">\n<tr>\n	<td valign=\"top\" class=\"tableData\" width=\"35%\">\n		<b>Features</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addfeature.url>\"><tmpl_var addfeature.label></a><p />\n		</tmpl_if>\n		<tmpl_loop feature_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var feature.controls></tmpl_if><tmpl_var feature.feature><br />\n		</tmpl_loop>\n		<p />\n		<b>Benefits</b><br/>\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addBenefit.url>\"><tmpl_var addBenefit.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop benefit_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var benefit.controls></tmpl_if><tmpl_var benefit.benefit><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td valign=\"top\" class=\"tableData\" width=\"35%\">\n		<b>Specifications</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addSpecification.url>\"><tmpl_var addSpecification.label></a><p />\n		</tmpl_if>\n		<tmpl_loop specification_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var specification.controls></tmpl_if><b><tmpl_var specification.label>:</b> <tmpl_var specification.specification> <tmpl_var specification.units><br />\n		</tmpl_loop>\n		<p />\n		<b>Accessories</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addaccessory.url>\"><tmpl_var addaccessory.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop accessory_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var accessory.controls></tmpl_if><a href=\"<tmpl_var accessory.url>\"><tmpl_var accessory.title></a><br />\n		</tmpl_loop>\n		<p />\n		<b>Related Products</b><br />\n		<tmpl_if session.var.adminOn>\n			<a href=\"<tmpl_var addRelatedProduct.url>\"><tmpl_var addRelatedProduct.label></a>\n			<p />\n		</tmpl_if>\n		<tmpl_loop relatedproduct_loop>\n			&middot;<tmpl_if session.var.adminOn><tmpl_var RelatedProduct.controls></tmpl_if><a href=\"<tmpl_var relatedproduct.url>\"><tmpl_var relatedproduct.title></a><br />\n		</tmpl_loop>\n		<p />\n	</td>\n	<td class=\"tableData\" valign=\"top\" width=\"30%\">\n		<tmpl_if price>\n			<b>Price:</b> <tmpl_var price><br />\n		</tmpl_if>\n		<tmpl_if productnumber>\n			<b>Product Number:</b> <tmpl_var productNumber><br />\n		</tmpl_if>\n		<br />\n		<tmpl_if brochure.url>\n			<a href=\"<tmpl_var brochure.url>\"><img src=\"<tmpl_var brochure.icon>\" alt=\"<tmpl_var brochure.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var brochure.label></a><br />\n		</tmpl_if>\n		<tmpl_if manual.url>\n			<a href=\"<tmpl_var manual.url>\"><img src=\"<tmpl_var manual.icon>\" alt=\"<tmpl_var manual.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var manual.label></a><br />\n		</tmpl_if>\n		<tmpl_if warranty.url>\n			<a href=\"<tmpl_var warranty.url>\"><img src=\"<tmpl_var warranty.icon>\" alt=\"<tmpl_var warranty.icon>\" class=\"noBorder\" align=\"absmiddle\" /><tmpl_var warranty.label></a><br />\n		</tmpl_if>\n	</td>\n</tr>\n</table>\n\n\n','Product',1,1,'PBtmpl0000000000000110',1147642429,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.productFeatureHeader {\n	font-weight: bold;\n	font-size: 15px;\n}\n.productSpecificationHeader {\n	font-weight: bold;\n	font-size: 15px;\n}\n.productRelatedHeader{\n	font-weight: bold;\n	font-size: 15px;\n}\n.productAccessoryHeader {\n	font-weight: bold;\n	font-size: 15px;\n}\n.productBenefitHeader {\n	font-weight: bold;\n	font-size: 15px;\n}\n.productFeature {\n	font-size: 12px;\n}\n.productSpecification {\n	font-size: 12px;\n}\n.productRelated {\n	font-size: 12px;\n}\n.productAccessory {\n	font-size: 12px;\n}\n.productBenefit {\n	font-size: 12px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.noBorder {\n	border:none;\n}\n.threeColumns {\n	border:solid gray 1px;\n}\n.threeColumns td {\n	font-family:arial;\n	font-size:9pt;\n}\n.threeColumns .tableData {\n	border-right:solid gray 1px;\n}\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\n</style>'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if showAdmin>\n<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n  <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<!-- begin position 1 -->\n<div class=\"firstColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position1_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 1 -->\n\n<!-- begin position 2 -->\n<div class=\"secondColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position2_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 2 -->\n\n<!-- begin position 3 -->\n<div class=\"thirdColumn\"><div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position3\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position3_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div></div>\n<!-- end position 3 -->\n\n<div class=\"endFloat\">&nbsp;</div>\n\n<!-- begin position 4 -->\n<div class=\"layoutColumnPadding\">\n<tmpl_if showAdmin>\n	<table border=\"0\" id=\"position4\" class=\"content\"><tbody>\n</tmpl_if>\n\n<tmpl_loop position4_loop>\n	<tmpl_if showAdmin>\n            	<tr id=\"td<tmpl_var id>\">\n            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\n	</tmpl_if>\n\n	<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\n\n	<tmpl_if showAdmin>\n         			</div></td>\n            	</tr>\n	</tmpl_if>\n</tmpl_loop>\n\n<tmpl_if showAdmin>\n            </tbody></table>\n</tmpl_if>\n</div>\n<!-- end position 4 -->\n\n<tmpl_if showAdmin>\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\n            <tmpl_var dragger.init>\n</tmpl_if>\n','Layout',1,1,'PBtmpl0000000000000118',1147642429,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: 33%;\n}\n.thirdColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"postControls\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<div>[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]</div>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<div>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n		</div>\n	</tmpl_if>\n	<h2 class=\"topicsTitle\"><tmpl_var title></h2>\n	<span class=\"topicContent\"><tmpl_var content></span>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration',1,1,'PBtmpl0000000000000079',1147642430,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.postControls \n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}		\n\n.pagination a\n{\n	color:white;\n}\n\n.topicsTitle\n{\n	-moz-box-sizing:border-box;\n	width:95%;\n	border-bottom:solid silver 1px;\n	margin-bottom:3px;\n	font-family:arial;\n}\n\n.topicContent\n{\n	-moz-box-sizing:border-box;\n	font-family:arial;\n	font-size:9pt;\n	width:95%;\n	display:block;\n	border:solid silver 1px;\n	padding:3px;\n}\n\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var title.label></a></td>\n	<td class=\"forumHead\"><tmpl_var thumbnail.label></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var by.label></a></td>\n</tr>\n<tmpl_loop post_loop>\n	<tr>\n		<tmpl_if user.isModerator>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n		</tmpl_if>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"text-align: center;\">\n			<tmpl_if thumbnail>\n				 <a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n			<tmpl_else>\n				 &nbsp;\n			</tmpl_if>\n		</td>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateUpdated.human></td>\n		<tmpl_if user.isVisitor>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n		<tmpl_else>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n		</tmpl_if>\n	</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<br />\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration',1,1,'PBtmpl0000000000000097',1147642430,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.forumHead {\n	background-color: #DADADA;\n	border: 2px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n	font-family:arial;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;	\n	font-family:arial;\n}\n\n.forumHead a\n{\n	color:#29587E;\n}\n\n.oddThread a\n{\n	color:#29587E;\n}\n\n.evenThread a\n{\n	color:#29587E;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n	background-color:#EEEEEE;\n	font-family:arial;\n}\n\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.pagination a\n{\n	color:white;\n}\n\nh2\n{\n	font-family:arial;\n}\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\">[<tmpl_var add.label>]</a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\">[<tmpl_var unsubscribe.label>]</a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\">[<tmpl_var subscribe.label>]</a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\">[<tmpl_var search.label>]</a>\n	</tmpl_if>\n</p>\n\n<ul class=\"unorderedList\">\n	<tmpl_loop post_loop>\n		<li>\n			<tmpl_if user.isPoster>\n				<tmpl_unless session.var.adminOn>\n					[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n				</tmpl_unless>\n			</tmpl_if>\n			<tmpl_if user.isModerator>\n				<tmpl_if session.var.adminOn>\n					<tmpl_var controls>\n				<tmpl_else>\n					<tmpl_unless user.isPoster>\n						<tmpl_unless session.var.adminOn>\n							[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n						</tmpl_unless>\n					</tmpl_unless>\n				</tmpl_if>\n				(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n			</tmpl_if>\n			<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n			<tmpl_if content>\n					  - <tmpl_var content>\n			</tmpl_if>\n		</li>\n	</tmpl_loop>\n</ul>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration',1,1,'PBtmpl0000000000000082',1147642430,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top:3px;\n}\n\n.pagination a\n{\n	color:white;\n}\n\n.unorderedList\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\nh2\n{\n	font-family:arial;\n}\n\n</style>'),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n<tmpl_if session.var.adminOn>\n<tmpl_var controls><br />\n</tmpl_if>\n<span class=\"verticalMenu\">\n<tmpl_loop page_loop>\n<tmpl_var page.indent>\n	<a <tmpl_if page.isCurrent>class=\"selectedMenuItem\"</tmpl_if> <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n	<br />		\n</tmpl_loop>\n</span>\n','Navigation',1,1,'PBtmpl0000000000000048',1147642431,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\"></a> \n \n<tmpl_if session.var.adminOn> \n   <p><tmpl_var controls></p> \n</tmpl_if>\n\n<tmpl_if displayTitle>\n    <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n    <tmpl_var description><p></p>\n</tmpl_if>\n\n<tmpl_loop ourLocations.loop>\n<table border=\"0\" width=\"100%\">\n<tr>\n	<td rowspan=\"3\" style=\"width:55px;\"><img src=\"<tmpl_var iconUrl>\" /></td>\n	<td style=\"background-color:#E0E0E0;\">\n		<div class=\"weatherTitle\">\n			<div style=\"float:left;\">&#160;<b><tmpl_var cityState></b></div>\n\n			<div style=\"float:right;margin-right:1px;margin-top:2px;vertical-align:middle;\">\n				<a href=\"#\" style=\"color:gray;font-weight:bold;\">X</a>\n			</div>\n		</div>\n	</td>\n</tr>\n<tr>\n	<td>\n		<tmpl_var sky><br /><tmpl_var tempF>&deg;F<br />\n	</td>\n</tr>\n<tr>\n	<td><br /></td>\n</tr>\n</table>\n\n</tmpl_loop>\n','WeatherData',1,1,'WeatherDataTmpl0000001',1147642431,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>^Page(title); - <tmpl_var session.setting.companyName></title>\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n	<link rel=\"shortcut icon\" href=\"^Extras(favicon.ico);\" />\n	<tmpl_var head.tags>\n<style type=\"text/css\">\nbody {\n	margin: 0;\n	padding: 0;\n}\n</style>\n</head>\n<body>\n^AdminBar(\"PBtmpl0000000000000090\");\n<tmpl_var body.content>\n\n<p>\n^AdminToggle();\n</p>\n</body>\n</html>\n','style',1,1,'PBtmplBlankStyle000001',1147642431,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<p />\n\n<tmpl_loop post_loop>\n	<div class=\"weblogTitleBar\">\n		<tmpl_var title>\n	</div>\n	<fieldset class=\"weblogSynopsis\">\n		<legend class=\"weblogLegend\" align=\"left\">\n			<tmpl_var by.label> <a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n			-\n			<tmpl_var dateSubmitted.human>\n			<tmpl_if replies>\n				- <tmpl_var replies> <tmpl_var replies.label>\n			</tmpl_if>\n			<tmpl_if user.isPoster>\n				 - <tmpl_var status>\n			<tmpl_else>\n				<tmpl_if user.isModerator>\n					- <tmpl_var status>\n				</tmpl_if>\n			</tmpl_if>\n		</legend>\n		<tmpl_if thumbnail>\n			<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var title>\" align=\"right\" /></a>\n		</tmpl_if>\n		<tmpl_var synopsis>\n		<div class=\"weblogReadMore\">\n			<a href=\"<tmpl_var url>\"><tmpl_var readmore.label></a>\n		</div>\n	</fieldset>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration',1,1,'PBtmpl0000000000000112',1147642431,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top:3px;\n}\n\n.pagination a\n{\n	color:white;\n}\n\n.weblogTitleBar {\n	font-weight: bold;\n	font-size: 14px;\n	font-family:arial;\n}\n\n.weblogLegend {\n	font-size: 9px;\n	color: #999999;\n	font-family:arial;\n}\n\n.weblogLegend a\n{\n	color:#29587E;\n}\n\n.weblogReadMore {\n	text-align: right;\n	font-size: 9px;\n	width: 100%;\n	font-family:arial;\n}\n\n.weblogSynopsis {\n	border: 1px solid #bbbbbb;\n	font-size: 13px;\n	padding: 5px;\n	-moz-border-radius: 6px;\n	font-family:arial;\n}\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if description>\n	<tmpl_var description><br /><br />\n</tmpl_if>\n\n<tmpl_if results>\n	<tmpl_loop results>\n		The current temp is: <tmpl_var result>\n	</tmpl_loop>\n<tmpl_else>\n	Failed to retrieve temp.\n</tmpl_if>\n','WSClient',1,1,'PBtmpl0000000000000069',1147642432,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\n<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if>\n<div><object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"100%\" height=\"*\">\n<param name=\"movie\" value=\"<tmpl_var fileUrl>\" /><param name=\"quality\" value=\"high\" /><embed src=\"<tmpl_var fileUrl>\" quality=\"high\" width=\"100%\" height=\"*\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />\n</object></div>\n		','FileAsset',1,1,'pbtmpl0000000000000220',1147642465,'WebGUI::Asset::Template::HTMLTemplate',NULL),('\n<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if>\n<p><object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"800\" height=\"600\" align=\"middle\">\n<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n<param name=\"movie\" value=\"<tmpl_var fileUrl>\" /><param name=\"quality\" value=\"high\" /><embed src=\"<tmpl_var fileUrl>\" quality=\"high\" width=\"800\" height=\"600\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />\n</object></p>\n		','FileAsset',1,1,'pbtmpl0000000000000221',1147642465,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>^Page(title);</title>\n	<tmpl_var head.tags>	\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n        <link rel=\"SHORTCUT ICON\" href=\"^Extras(favicon.ico);\" />\n	<link href=\"^/;style1/css01.css\" rel=\"stylesheet\" type=\"text/css\" />	\n</head>\n<body>\n	^AdminBar();\n	<div id=\"main\">\n		<div id=\"mainHeader\">\n			<div id=\"title\">\n				^H(^c(););\n			</div>\n			\n			<div id=\"copyright\">\n				&copy; ^D(%y); ^c;\n			</div>			\n		</div>\n\n		<div id=\"mainContent\">\n			<div class=\"mainNav_1\">\n				^AssetProxy(roottab_level0);\n			</div>\n			<div style=\"clear:both;\"></div>\n			<div class=\"mainNav_2\">\n				^AssetProxy(roottab_level1);\n			</div>\n			<div id=\"crumbTrail\">\n				^AssetProxy(crumbtrail);			\n			</div>\n			<div style=\"clear:both;\">&#160;</div>\n			<div id=\"mainText\">\n				<tmpl_var body.content>\n			</div>\n			<div style=\"clear:both;\">&#160;</div>\n		</div>\n		\n		<div id=\"gui\">\n			^L(\"\",\"\",\"PBtmpl0000000000000044\");\n			<div style=\"clear:both;padding-right:12px;\">^AdminToggle;</div>\n			^AssetProxy(style1/gui_bottom.jpg);<br />\n			<a href=\"http://www.webgui.org\"><img src=\"^FileUrl(style1/webgui_btn.jpg);\" style=\"border:none;\" alt=\"WebGUI Button\" /></a>\n		</div>\n	</div>\n</body>\n</html>	\n','style',1,1,'stevestyle000000000001',1147642499,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>			\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>		\n		\n	<span style=\"float:left\">&#160;&#160;&#160;&#160;&#160;&#160;</span>\n	<tmpl_loop page_loop>	\n	<div<tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"navOn\"</tmpl_if>>\n		<span class=\"left\">&#160;</span>\n		<span class=\"center\">\n			<a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n		</span>\n		<span class=\"right\">&#160;</span>\n	</div>	\n	</tmpl_loop>\n\n<div style=\"clear:both;\"></div>\n','Navigation',1,1,'stevenav00000000000001',1147642499,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>			\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>		\n		\n	<span style=\"float:left\">&#160;&#160;&#160;&#160;&#160;&#160;</span>\n	<tmpl_loop page_loop>	\n		<tmpl_unless page.depthIs3>\n	<div<tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"navOn\"</tmpl_if>>\n		<span class=\"left\">&#160;</span>\n		<span class=\"center\">\n			<a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n		</span>\n		<span class=\"right\">&#160;</span>\n	</div>	\n		</tmpl_unless>\n	</tmpl_loop>\n','Navigation',1,1,'PBnav000000style01lvl2',1147642499,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<tmpl_var head.tags>\n	<title>^c; - ^Page(title);</title>\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n        <link rel=\"SHORTCUT ICON\" href=\"^Extras(favicon.ico);\" />\n	<link href=\"^/;style2/css02.css\" rel=\"stylesheet\" type=\"text/css\" />\n</head>\n<body>\r\n^AdminBar();\r\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\" style=\"height:100%\">\n<tr>\n	<td class=\"leftColumn\" valign=\"top\">\n		<div id=\"header\">\n			<div id=\"title\">^H(^c;);</div>\n			<div id=\"title_bg\">^c;</div>\n		</div>\n		<div id=\"pageTitleBG\">\n			<div id=\"pageTitle\"><h2>^Page(title);</h2>\n			</div>\n		</div>\n		<div id=\"context\">\n			<tmpl_var body.content>			\n		</div>			\n	</td>\n	<td class=\"rightColumn\" valign=\"top\">\n		<div id=\"pb_wg_bg\">\n			<div id=\"pb_wg\">\r\n				<a href=\"http://www.plainblack.com\"><img src=\"^FileUrl(style2/pb.jpg);\" style=\"border: 0px;\" alt=\"plain black\" /></a><a href=\"http://www.webgui.org\"><img src=\"^FileUrl(style2/wg.jpg);\" style=\"border: 0px;\" alt=\"webgui\" /></a><br />\n			</div>\n		</div>\n		<br />\n		<table style=\"width:90%;margin-left:auto;margin-right:auto;background: url(\'^FileUrl(style2/navbar_bg.jpg);\') repeat-x;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n		<tr>\n			<td style=\"background: url(\'^FileUrl(style2/navbar_left.jpg);\') no-repeat left;height:9px;width:10%;\" align=\"left\"></td>			\n			<td style=\"background: url(\'^FileUrl(style2/navbar_right.jpg);\') no-repeat right;height:9px;width:90%;\" align=\"right\"></td>\n		</tr>\n		</table>\n		<div id=\"nav\">\n			^AssetProxy(flexmenu);\n		</div>\n		<table style=\"width:90%;margin-left:auto;margin-right:auto;background: url(\'^FileUrl(style2/navbar_bg.jpg);\') repeat-x;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n		<tr>\n			<td style=\"background: url(\'^FileUrl(style2/navbar_left.jpg);\') no-repeat left;height:9px;width:10%;\" align=\"left\"></td>			\n			<td style=\"background: url(\'^FileUrl(style2/navbar_right.jpg);\') no-repeat right;height:9px;width:90%;\" align=\"right\"></td>\n		</tr>\n		</table>\n		<div id=\"loginStyles\">\n			^L(\"\",\"\",\"PBtmpl0000000000000044\");\n			^AdminToggle;\n		</div>			\n	</td>	\n</tr>\r\n<tr>\r\n	<td colspan=\"2\" class=\"copyright\">\r\n		&copy; ^D(%y); ^c;\r\n	</td>\r\n</tr>\n</table>\r\n\n</body>\n</html>\n','style',1,1,'stevestyle000000000002',1147642504,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h1><tmpl_var title></h1>\n</tmpl_if>\n\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n\n<script type=\"text/javascript\">\n/*****************************************************************************\nCopyright (c) 2001 Thomas Brattli (webmaster@dhtmlcentral.com)\n\nDHTML coolMenus - Get it at coolmenus.dhtmlcentral.com\nVersion 4.0_beta\nThis script can be used freely as long as all copyright messages are\nintact.\n\nExtra info - Coolmenus reference/help - Extra links to help files ****\nCSS help: http://coolmenus.dhtmlcentral.com/projects/coolmenus/reference.asp?m=37\nGeneral: http://coolmenus.dhtmlcentral.com/reference.asp?m=35\nMenu properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=47\nLevel properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=48\n\nBackground bar properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=49\nItem properties: http://coolmenus.dhtmlcentral.com/properties.asp?m=50\n******************************************************************************/\n\n/***\nThis is the menu creation code - place it right after you body tag\nFeel free to add this to a stand-alone js file and link it to your page.\n**/\n\n//Menu object creation\ncoolmenu=new makeCM(\"coolmenu\") //Making the menu object. Argument: menuname\n\ncoolmenu.frames = 0\n\n//Menu properties\ncoolmenu.onlineRoot=\"\"\ncoolmenu.pxBetween=2\ncoolmenu.fromLeft=25 \ncoolmenu.fromTop=138  \n<tmpl_if session.var.adminOn>\n	coolmenu.fromLeft=186 \n	coolmenu.fromTop=160  \n</tmpl_if>\ncoolmenu.rows=1\ncoolmenu.menuPlacement=\"left\"   //The whole menu alignment, left, center, or right\n\ncoolmenu.resizeCheck=1\ncoolmenu.wait=250\ncoolmenu.fillImg=\"cm_fill.gif\"\ncoolmenu.zIndex=100\n\n//Background bar properties\ncoolmenu.useBar=0\ncoolmenu.barWidth=\"100%\"\ncoolmenu.barHeight=\"menu\"\ncoolmenu.barClass=\"cBar\"\ncoolmenu.barX=0\ncoolmenu.barY=0\ncoolmenu.barBorderX=0\ncoolmenu.barBorderY=0\ncoolmenu.barBorderClass=\"\"\n\n//Level properties - ALL properties have to be spesified in level 0\ncoolmenu.level[0]=new cm_makeLevel() //Add this for each new level\ncoolmenu.level[0].width=150\ncoolmenu.level[0].height=25\ncoolmenu.level[0].regClass=\"cLevel0\"\ncoolmenu.level[0].overClass=\"cLevel0over\"\ncoolmenu.level[0].borderX=1\ncoolmenu.level[0].borderY=1\ncoolmenu.level[0].borderClass=\"cLevel0border\"\n\ncoolmenu.level[0].offsetX=0\ncoolmenu.level[0].offsetY=0\ncoolmenu.level[0].rows=0\ncoolmenu.level[0].arrow=0\ncoolmenu.level[0].arrowWidth=0\ncoolmenu.level[0].arrowHeight=0\ncoolmenu.level[0].align=\"bottom\"\n\n//EXAMPLE SUB LEVEL[1] PROPERTIES - You have to specify the properties you want different from LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[1]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[1].width=coolmenu.level[0].width //+20\ncoolmenu.level[1].height=25\ncoolmenu.level[1].regClass=\"cLevel1\"\ncoolmenu.level[1].overClass=\"cLevel1over\"\ncoolmenu.level[1].borderX=1\ncoolmenu.level[1].borderY=1\ncoolmenu.level[1].align=\"right\"\ncoolmenu.level[1].offsetX=0\ncoolmenu.level[1].offsetY=0\ncoolmenu.level[1].borderClass=\"cLevel1border\"\n\n//EXAMPLE SUB LEVEL[2] PROPERTIES - You have to specify the properties you want different from LEVEL[1] OR LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[2]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[2].width=coolmenu.level[0].width //+20\ncoolmenu.level[2].height=25\ncoolmenu.level[2].offsetX=0\ncoolmenu.level[2].offsetY=0\ncoolmenu.level[2].regClass=\"cLevel2\"\ncoolmenu.level[2].overClass=\"cLevel2over\"\ncoolmenu.level[2].borderClass=\"cLevel2border\"\n\n//EXAMPLE SUB LEVEL[2] PROPERTIES - You have to specify the properties you want different from LEVEL[1] OR LEVEL[0] - If you want all items to look the same just remove this\ncoolmenu.level[3]=new cm_makeLevel() //Add this for each new level (adding one to the number)\ncoolmenu.level[3].width=coolmenu.level[0].width+20\ncoolmenu.level[3].height=25\ncoolmenu.level[3].offsetX=0\ncoolmenu.level[3].offsetY=0\ncoolmenu.level[3].regClass=\"cLevel2\"\ncoolmenu.level[3].overClass=\"cLevel2over\"\ncoolmenu.level[3].borderClass=\"cLevel2border\"\n\n<tmpl_loop page_loop>\ncoolmenu.makeMenu(\'coolmenu_<tmpl_var page.assetId escape=JS>\'.replace(/\\-/g,\"a\"),\'coolmenu_<tmpl_var page.parent.assetId escape=JS>\'.replace(/\\-/g,\"a\"),\"<tmpl_var page.menuTitle escape=JS>\",\'<tmpl_var page.url escape=JS>\'<tmpl_if page.newWindow>,\'_blank\'</tmpl_if>);\n</tmpl_loop>\n\ncoolmenu.construct();\n\n</script>\n','Navigation',1,1,'stevecoolmenu000000001',1147642505,'WebGUI::Asset::Template::HTMLTemplate','<script src=\"^Extras(coolmenus/coolmenus4.js);\" type=\"text/javascript\"></script>\n<style type=\"text/css\">\n/* CoolMenus 4 - default styles - do not edit */\n.cCMAbs {\n	position: absolute;\n	visibility: hidden;\n	left: 0;\n	top: 0;\n}\n/* CoolMenus 4 - default styles - end */\n\n/*Styles for level 0*/\n.cLevel0,.cLevel0over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 12px;\n	font-weight: bold;\n}\n\n.cLevel0 {\n	color:#ededed;\n	text-align: center;	\n	/*border-left:#353535 solid 1px;\n	border-right:#353535 solid 2px;\n	border-bottom:#353535 solid 2px;*/\n	background: url(\'^FileUrl(style3/spacer.gif);\');\n}\n\n.cLevel0over {	\n	color: gold;	\n	cursor: pointer;\n	text-align: center;\n	/*border-left:#353535 solid 1px;\n	border-right:#353535 solid 2px;\n	border-bottom:#353535 solid 2px;	*/\n	background: url(\'^FileUrl(style3/spacer.gif);\');\n}\n\n.cLevel0border {\n	position: absolute;\n	visibility: hidden;\n	/*background-color: #569635;\n	layer-background-color: #006699;*/\n	\n}\n\n/*Styles for level 1*/\n.cLevel1, .cLevel1over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 11px;\n	font-weight:bold;\n	cursor: pointer;\n}\n\n.cLevel1 {\n	color: white;\n	text-align: center;	\n	border:solid #111 1px;\n}\n\n.cLevel1over {\n	color: black;\n	text-align: center;	\n	border-left:solid #111 1px;\n	border-right:solid #111 1px;\n	border-bottom:solid #111 1px;\n	background-color:#eeeeee;\n	cursor: pointer;	\n}\n\n.cLevel1border {\n	opacity:0.9;\n	-moz-opacity:0.9;\n	-khtml-opacity:0.9;\n	position: absolute;\n	visibility: hidden;\n	background-color: #444;\n	layer-background-color: #444;\n}\n\n/*Styles for level 2*/\n.cLevel2, .cLevel2over {\n	position: absolute;\n	padding: 2px;\n	font-family: tahoma, arial, helvetica;\n	font-size: 11px;\n	font-weight:bold;\n	cursor: pointer;\n}\n\n.cLevel2 {\n	color: white;\n	text-align: center;	\n	border:solid #111 1px;\n}\n\n.cLevel2over {\n	color: black;\n	text-align: center;	\n	border-left:solid #111 1px;\n	border-right:solid #111 1px;\n	border-bottom:solid #111 1px;\n	background-color:#eeeeee;\n	cursor: pointer;	\n}\n\n.cLevel2border {\n	opacity:0.9;\n	-moz-opacity:0.9;\n	-khtml-opacity:0.9;\n	position: absolute;\n	visibility: hidden;\n	background-color: #444;\n	layer-background-color: #444;\n}\n\n</style>\n'),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n        <link rel=\"SHORTCUT ICON\" href=\"^Extras(favicon.ico);\" />\n<link href=\"^/;style3/css03.css\" rel=\"stylesheet\" type=\"text/css\" />\n	<tmpl_var head.tags>\n	<title>^c; - ^Page(title);</title>\n	</head>\n<body>\n^AdminBar();\n\n^AssetProxy(style3_coolmenu);\n\n<div id=\"main\">\n	<div id=\"header\">\n		<div id=\"headerTitle\">\n			<div id=\"headerRight\">\n				<div id=\"login\">\r					^L(\"\",\"\",\"PBtmpl0000000000000092\"); &middot; ^AdminToggle;\r				</div>\n				<div id=\"title\">\n					<h1>^H(^c;);</h1>\n					<h2>^Page(title);</h2>\n				</div>\n				<a href=\"http://www.webgui.org\"><img src=\"^FileUrl(style3/wg.jpg);\" style=\"border: 0px;\" alt=\"webgui\" /></a><br />\n			</div>\n		</div>\n	</div>\n	\n	<div id=\"mainBody\">\n		<div id=\"contentArea\">\n			<tmpl_var body.content>\n		</div>\n		<div id=\"topCorner\">\n			^AssetProxy(style3/main_top.jpg);\n		</div>\n		<div id=\"bottomCorner\"></div>\n	</div>\n	\n	<div id=\"footer\">\n		<div id=\"copyright\">\n			&copy; ^D(%y); ^c;\n		</div>\n		<a href=\"http://www.plainblack.com\"><img src=\"^FileUrl(style3/pb.jpg);\" style=\"border: 0px;\" alt=\"plain black\" /></a><br />\n	</div>\n</div>\n\n\n</body>\n</html>\n','style',1,1,'stevestyle000000000003',1147642510,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n  <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n  <p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_var form_header>\n<tmpl_var form_keywords> <tmpl_var form_submit>\n<tmpl_var form_footer>\n\n<tmpl_if session.form.doit>\n	<tmpl_loop result_set>\n		<dl>\n			<dt><a href=\"^/;<tmpl_var url>\"><tmpl_var title></a></dt>\n			<dd><tmpl_var synopsis></dd>\n		</dl>\n	</tmpl_loop>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\">\n			<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n		</div>\n	</tmpl_if>\n</tmpl_if>\n\n','Search',1,1,'PBtmpl0000000000000200',1147962058,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<table border=\"0\" cellpadding=\"3\">\n<tbody>\n<tr>\n	<td><i><tmpl_var notify.subscription.message></i></td>\n</tr>\n<tr>\n	<td>&nbsp;</td>\n</tr>\n<tr>\n	<td bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\"><a href=\"<tmpl_var url>\"><b><tmpl_var url></a></b></td>\n</tr>\n<tr>\n	<td bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var content></td>\n</tr>\n</tbody>\n</table>','Collaboration/Notification',1,1,'PBtmpl0000000000000027',1147962059,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<div class=\"defaultSubmissionDetails\">\n	<b><tmpl_var user.label>:</b> \n		<tmpl_if user.isVisitor>\n			<tmpl_var username>\n		<tmpl_else>\n			<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n		</tmpl_if>\n		<br />\n	<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n	<b><tmpl_var severity.label>:</b> <tmpl_var userDefined1><br />\n	<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n	<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n		<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n		</tmpl_unless>\n		<br />\n	<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var unarchive.url>\"><tmpl_var open.label></a> <tmpl_else> <tmpl_var open.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var archive.url>\"><tmpl_var close.label></a></tmpl_if> ]<br />\n	<tmpl_else>	\n		<tmpl_if user.isPoster>\n			<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> <tmpl_else> <tmpl_var open.label></tmpl_if><br />\n		</tmpl_if>	\n	</tmpl_if>	\n<tmpl_if karmaIsEnabled>\n	<b><tmpl_var karmaRank.label>:</b> <tmpl_var karmaRank><br />\n<b><tmpl_var transferkarma.label>:</b>\n<tmpl_var transfer.karma.form>\n</tmpl_if>	\n</div>\n\n<div class=\"collaborationThreadContent\">\n<p><b><tmpl_var userDefined2> <tmpl_var userDefined3></b></p>\n	<tmpl_var content>\n</div>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<div style=\"clear:both;\"></div>\n\n<tmpl_if repliesAllowed>\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">	\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if><br />\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>\n	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a>				\n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n	<br />\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000067',1147962059,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData td {\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\ndisplay:block;\n	-moz-box-sizing:border-box;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n\n.postControls a\n{\n	color:white;\n}\n\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n</style>\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n	\n<div style=\"float: left; width: 70%\">\n	<h2><a href=\"<tmpl_var collaboration.url>\"><tmpl_var collaboration.title></a></h2>\n</div>\n<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n</div>\n<div style=\"clear: both;\"></div>\n\n<tmpl_if layout.isFlat>\n<!-- begin flat layout -->\n	<tmpl_loop post_loop>\n		<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n			<a name=\"<tmpl_var assetId>\"></a>\n			<div class=\"postSubject\">\n				<tmpl_var title>\n			</div>\n			<div class=\"postData\">\n				<div style=\"float: left; width: 50%\">\n					<b><tmpl_var user.label>:</b> \n						<tmpl_if user.isVisitor>\n							<tmpl_var username>\n						<tmpl_else>\n							<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n						</tmpl_if>\n						<br />\n					<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n				</div>	\n				<div>\n					<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n					<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n						<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n						</tmpl_unless>\n						<br />\n					<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n					<tmpl_else>	\n						<tmpl_if user.isPoster>\n							<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n						</tmpl_if>	\n					</tmpl_if>	\n				</div>	\n			</div>\n			<div class=\"postMessage\">\n				<tmpl_var content>\n<tmpl_loop attachment_loop>\n	<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n</tmpl_loop>\n<div style=\"clear: both;\"></div>\n\n			</div>\n			<tmpl_unless isLocked>\n				<div class=\"postControls\">\n					<tmpl_if user.canReply>\n						<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a> &bull; \n					</tmpl_if>\n					<tmpl_if user.canEdit>\n						<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a> &bull; \n						<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n					</tmpl_if>\n				</div>\n			</tmpl_unless>\n		</div>\n	</tmpl_loop>\n<!-- end flat layout -->\n</tmpl_if>\n\n<tmpl_if layout.isNested>\n<!-- begin nested layout -->\n	<tmpl_loop post_loop>\n		<div style=\"margin-left: <tmpl_var depthX10>px;\">\n			<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n				<a name=\"<tmpl_var assetId>\"></a>\n				<div class=\"postSubject\">\n					<tmpl_var title>\n				</div>\n				<div class=\"postData\">\n					<div style=\"float: left; width: 50%\">\n						<b><tmpl_var user.label>:</b> \n							<tmpl_if user.isVisitor>\n								<tmpl_var username>\n							<tmpl_else>\n								<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n							</tmpl_if>\n							<br />\n						<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n					</div>	\n					<div>\n						<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n						<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n							<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n							</tmpl_unless>\n							<br />\n							<tmpl_if user.isPoster>\n								<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n							</tmpl_if>	\n					</div>	\n				</div>\n				<div class=\"postMessage\">\n					<tmpl_var content>\n<tmpl_loop attachment_loop>\n	<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n</tmpl_loop>\n<div style=\"clear: both;\"></div>\n\n				</div>\n				<tmpl_unless isLocked>\n					<div class=\"postControls\">\n						<tmpl_if user.canReply>\n							<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a> &bull;\n						</tmpl_if>\n						<tmpl_if user.canEdit>\n							<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a> &bull; \n							<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n						</tmpl_if>\n					</div>\n				</tmpl_unless>\n			</div>\n		</div>\n	</tmpl_loop>\n<!-- end nested layout -->\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\" style=\"margin-top: 20px;\">\n		[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n	</div>\n</tmpl_if>\n\n<div style=\"margin-top: 20px;\" class=\"bottomControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> &bull;\n	</tmpl_if>	\n	<tmpl_if next.url>\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a> &bull; \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a> &bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a> &bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a> &bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a> &bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a> &bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a> &bull;\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000032',1147962059,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	.postBorder {\n		border: 1px solid #cccccc;\n		margin-bottom: 10px;\n	}\n 	.postBorderCurrent {\n		border: 3px dotted black;\n		margin-bottom: 10px;\n	}\n	.postSubject {\n		border-bottom: 1px solid #cccccc;\n		font-weight: bold;\n		padding: 3px;\n	}\n	.postData {\n		border-bottom: 1px solid #cccccc;\n		font-size: 11px;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.postControls {\r\n		border-top: 1px solid #cccccc;\r\n		background-color: #C0C0C0;\r\n		color: black;\r\n		padding: 3px;\r\n		text-align:right;\r\n	}\r\n	.postControls a:visited, .postControls a:link {\r\n		color:white;\r\n	}\r\n	.bottomControls {\r\n		background-color:#C0C0C0;\r\n		padding: 3px;\r\n		text-align:right;\r\n	}\n	.bottomControls a:link, .bottomControls a:visited {\n		color:white;\n	}	\n	.postMessage {\n		padding: 3px;\n	}\n	.currentThread {\n		background-color: #eeeeee;\n	}\n	.threadHead {\n		font-weight: bold;\n		border-bottom: 1px solid #cccccc;\n		font-size: 11px;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.threadData {\n		font-size: 11px;\n		padding: 3px;\n	}\n</style>\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.isModerator>\n	<div style=\"float: right; font-size: 11px; border: 1px solid #cccccc; padding: 2px; margin: 2px;\">\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n	</div>\n</tmpl_if>	\n\n<tmpl_if content>\n	<b>Job Description</b><br />\n	<p><tmpl_var content></p>\n</tmpl_if>\n\n<tmpl_if userDefined3>\n	<b>Job Requirements</b><br />\n	<p><tmpl_var userDefined3></p>\n</tmpl_if>\n\n<table width=\"100%\">\n<tr>\n	<td class=\"tableHeader\">Date Posted</td>\n	<td class=\"tableData\"><tmpl_var dateSubmitted.human>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Location</td>\n	<td class=\"tableData\"><tmpl_var userDefined2>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Compensation</td>\n	<td class=\"tableData\"><tmpl_var userDefined1>&#160;</td>\n</tr>\n<tr>\n	<td class=\"tableHeader\">Views</td>\n	<td class=\"tableData\"><tmpl_var views>&#160;</td>\n</tr>\n</table>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<tmpl_if repliesAllowed>\n\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n								<br />\n								<tmpl_if user.isPoster>\n									<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n								</tmpl_if>	\n						</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n								<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n									<tmpl_if user.isPoster>\n										<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n									</tmpl_if>	\n							</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a> \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>			\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000098',1147962059,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 3px dotted black;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	padding: 3px;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.postControls\r\n{\r\n	background:#C0C0C0;\r\n	display:block;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-top: 1px;	\r\n}\r\n.postControls a:link, .postControls a:visited\r\n{\r\n	color:white;\r\n}\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.threadData {\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	padding: 3px;\r\n}\r\n\r\n.tableHeader\r\n{\r\n	width:20%;\r\n	background-color:#DADADA;\r\n	font-family:arial;\r\n	font-size:9pt;	\r\n}\r\n\r\n.tableData\r\n{\r\n	width:80%;\r\n	border:solid #DADADA 1px;\r\n	font-family:arial;\r\n	font-size:9pt;	\r\n}\r\n\r\n</style>'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<tmpl_if user.isModerator>\n	<div style=\"float: right; font-size: 11px; border: 1px solid #cccccc; padding: 2px; margin: 2px;\">\n		<b><tmpl_var status.label>:</b> <tmpl_var status> &nbsp; &nbsp; [ <tmpl_if isArchived><a href=\"<tmpl_var unarchive.url>\"><tmpl_var unarchive.label></a> <tmpl_else> <a href=\"<tmpl_var archive.url>\"><tmpl_var archive.label></a></tmpl_if> ]<br />\n	</div>\n</tmpl_if>	\n\n<tmpl_if content>\n	<div class=\"linkContent\">\n	<b>Link Description</b><br /><br />\n	<tmpl_var content><br />\n	\n	<b>Link URL</b><br /><br />\n	<a href=\"<tmpl_var userDefined1>\"><tmpl_var userDefined1></a><br /><br />\n	</div>\n</tmpl_if>\n\n\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<tmpl_if repliesAllowed>\n\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<div style=\"float: left; width: 50%\">\n							<b><tmpl_var user.label>:</b> \n								<tmpl_if user.isVisitor>\n									<tmpl_var username>\n								<tmpl_else>\n									<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n								</tmpl_if>\n								<br />\n							<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n						</div>	\n						<div>\n							<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n							<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>\n								<br />\n								<tmpl_if user.isPoster>\n									<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n								</tmpl_if>	\n						</div>	\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a> &bull; \n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a> &bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n							<div style=\"float: left; width: 50%\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n							</div>	\n							<div>\n								<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n									<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n									</tmpl_unless>\n									<br />\n									<tmpl_if user.isPoster>\n										<b><tmpl_var status.label>:</b> <tmpl_var status><br />\n									</tmpl_if>	\n							</div>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a> &bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a> &bull; \n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\">List All Links</a>\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a> \n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		&bull;\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000113',1147962059,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n\n.linkContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n.linkContent a\n{\n	color:#29587E;\n}\n\n\nh2\n{\n	font-family:arial;\n}\n\n\n</style>\n\n\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n	<tmpl_if linkUrl>\n	<tmpl_if linkTitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n	</tmpl_if>\n	<tmpl_loop attachment_loop>\n		<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var url>\"><img src=\"<tmpl_var icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var filename>\" /> <tmpl_var filename></a></p><br />\n	</tmpl_loop>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n<tmpl_if allowDiscussion>\n	<p>\n	<table width=\"100%\" cellspacing=\"2\" cellpadding=\"1\" border=\"0\">\n	<tr>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var replies.URL>\"><tmpl_var replies.label> (<tmpl_var replies.count>)</a></td>\n	<td align=\"center\" width=\"50%\" class=\"tableMenu\"><a href=\"<tmpl_var post.url>\"><tmpl_var post.label></a></td>\n	</tr>\n	</table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000207',1148579524,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n             <label for=\"username_formId\"><tmpl_var username.label></label><br />\n             <tmpl_var username.form><br />\n             <label for=\"identifier_formId\"><tmpl_var password.label></label><br />\n             <tmpl_var password.form><br />\n             <tmpl_var form.login>\n	<tmpl_var form.footer>\n	<tmpl_if session.setting.anonymousRegistration>\n                        <p><a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a></p>\n	</tmpl_if>	\n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000044',1148579524,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n	<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n	<tr>\n		<td><tmpl_var username.form></td>\n		<td><tmpl_var password.form></td>\n		<td><tmpl_var form.login></td>\n	</tr>\n	<tr>\n		<td><label for=\"username_formId\"><tmpl_var username.label></label></td>\n		<td><label for=\"identifier_formId\"><tmpl_var password.label></label></td>\n		<td></td>\n	</tr>\n	</table>             	<tmpl_if session.setting.anonymousRegistration>\n                        <a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a>\n	</tmpl_if>		<tmpl_var form.footer> \n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<br /><tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000092',1148579524,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if session.var.adminOn>\n<tmpl_var controls><br />\n</tmpl_if>\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_loop page_loop>\n<tmpl_if __FIRST__>\n	<ul class=\"bulletList\">\n</tmpl_if>\n\n\n<tmpl_loop page.depthDiff_loop>\n   </ul></li>\n</tmpl_loop>\n\n<li class=\"level<tmpl_var page.relDepth>\"><a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n<tmpl_if page.hasViewableChildren>\n	<ul>\n<tmpl_else>\n	</li>\n</tmpl_if>\n\n<tmpl_if __LAST__> \n	<tmpl_loop page.indent_loop>\n		<tmpl_unless __first__></li></tmpl_unless>\n       		</ul>\n 	</tmpl_loop>\n	</li></ul>\n</tmpl_if>\n</tmpl_loop>\n','Navigation',1,1,'PBnav00000000000bullet',1148579524,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\nul.bulletList li, ul.bulletList ul {\r\n	margin-left:7px;\r\n	padding-left:0px;\r\n	font-size:9px;	\r\n}\r\n\n.bulletList .level0 {\n	font-size:13px;\n}\n\r\n.bulletList .level1 {\r\n	font-size:11px;\r\n}\r\n</style>\n\n'),('<br /><br />\n<tmpl_loop field_loop>\n<table cellpadding=\"3\" cellspacing=\"2\" border=\"0\" width=\"80%\">\n	<tmpl_unless field.isMailField>\n	<tr>\n		<td width=\"23%\" align=\"right\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\"><b><tmpl_var field.label> :</b></td>		\n		<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var field.value></td>\n	</tr>\n	</tmpl_unless>\n</table>\n</tmpl_loop>','DataForm',1,1,'PBtmpl0000000000000085',1148579524,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<table border=\"0\" cellpadding=\"3\" cellspacing=\"2\">\n<tbody>\n<tr>\n	<td colspan=\"2\"><i><tmpl_var notify.subscription.message></i></td>\n</tr>\n<tr>\n	<td colspan=\"2\">&nbsp;</td>\n</tr>\n<tr>\n	<td colspan=\"2\" bgcolor=\"black\" style=\"background-color:black;\"><font color=\"white\"><b style=\"color:white;\"><tmpl_var username> replied to the thread, \'<tmpl_var title>\'</b></font></td>\n</tr>\n<tr>\n	<td colspan=\"2\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\"><a href=\"<tmpl_var url>\"><b style=\"color:#ACACAC;\"><font color=\"#ACACAC\"><tmpl_var url></font></a></b></td>\n</tr>\n<tr>\n	<td colspan=\"2\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var content></td>\n</tr>\n<tr>\n	<td>&nbsp;</td>\n	<td>&nbsp;</td>\n</tr>\n<tmpl_if userDefined1>\n<tr>\n	<td width=\"25%\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\">User Defined 1:</td>\n	<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var userDefined1></td>\n</tr>\n</tmpl_if>\n<tmpl_if userDefined2>\n<tr>\n	<td width=\"25%\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\">User Defined 2:</td>\n	<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var userDefined2></td>\n</tr>\n</tmpl_if>\n<tmpl_if userDefined3>\n<tr>\n	<td width=\"25%\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\">User Defined 3:</td>\n	<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var userDefined3></td>\n</tr>\n</tmpl_if>\n<tmpl_if userDefined4>\n<tr>\n	<td width=\"25%\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\">User Defined 4:</td>\n	<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var userDefined4></td>\n</tr>\n</tmpl_if>\n<tmpl_if userDefined5>\n<tr>\n	<td width=\"25%\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\">User Defined 5:</td>\n	<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var userDefined5></td>\n</tr>\n</tmpl_if>\n</tbody>\n</table>','Collaboration/Notification',1,1,'PBtmpl0000000000000027',1148579524,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<script>\n	var JScolresize=\"1\";\n	var JScolmove=\"1\";\n	var JScolhide=\"1\";\n	var filtered =0;\n	var sortable = new Array (0,0,0,0,0,0);\n	var filterable = new Array (0,0,0,0,0,0);\n	\n	function init(tableName) {\n	   sortableInit(tableName);\n	}\n</script>\n\n<script type=\"text/javascript\">\n    var dayMS = 86400000;\n	\n	var popTitle = \"Add/Edit Task\";\n	\n	var dunits = \"<tmpl_var project.durationUnits>\";\n	var hoursPerDay = <tmpl_var project.hoursPerDay>;\n	var taskLength=<tmpl_var project.task.length>;\n	\n   //--------------------------------------------------------------------------------------	\n	function doCalendar (fieldId) {\n	   Calendar.setup({ \n                         inputField : fieldId, \n                         ifFormat : \"%Y-%m-%d\", \n                         showsTime : false, \n                         step : 1,\n                         timeFormat : \"12\",\n                         firstDay : false\n                    }); \n    }\n	\n   //--------------------------------------------------------------------------------------	\n    function buildMenuUrl (urltype,taskId) {\n       if(urltype == \"edit\") {\n	      alert(\"edit task: \"+taskId);\n	   } else if(urltype == \"insertAbove\") {\n	      alert(\"insert task above: \"+taskId);\n	   } else if(urltype == \"insertBelow\") {\n	      alert(\"insert task below: \"+taskId);\n	   } else if(urltype == \"delete\") {\n	      alert(\"delete task: \"+taskId);\n	   }\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function closeImage() {\n       return \'<tmpl_var extras>/close.gif\';\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function configureMilestone(box) {\n	   var form = box.form;\n	   if(box.checked==true) { \n	      form.end.value=form.start.value; \n		  form.duration.value=0; \n		  form.duration.disabled=true; \n		  form.end.disabled=true;\n		  form.dependants.disabled=true;\n		  form.resource.disabled=true;\n		  form.percentComplete.disabled=true;\n		  form.percentComplete.value=0;\n	   } else { \n	      form.end.disabled=false; \n		  form.duration.disabled=false; \n		  form.dependants.disabled=false;\n		  form.resource.disabled=false;\n		  form.percentComplete.disabled=false;\n		  form.duration.value = (dunits == \"hrs\")?hoursPerDay:1;\n	   }\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function checkEditTaskForm (form) {\n	   if(form.name.value == \"\") {\n	      alert(\"<tmpl_var form.name.error>\");\n		  return;\n	   } else if(form.start.value == \"\") {\n	      alert(\"<tmpl_var form.start.error>\");\n		  return;\n	   } else if(form.milestone.checked==false && form.end.value == \"\") {\n	      alert(\"<tmpl_var form.end.error>\");\n		  return;\n	   }\n	   form.submit();\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function intlDate(dateObj) {\n	   return dateObj.getFullYear()+\"-\"+pad((dateObj.getMonth()+1))+\"-\"+pad(dateObj.getDate());\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function toDateObj(date) {\n	   var to = date.split(\"-\");\n	   var dateObj = new Date(to[0],(to[1]-1),to[2],0,0,1,0);\n	   return dateObj;\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function adjustTaskTimeFromDuration(start, end, duration, isTaskForm, predecessor, origStart, origEnd, seqNum) {\n	   //set the form element\n	   var form = duration.form;\n	   \n	   //get today\'s date\n	   var today = new Date();\n	   var todayIntl = intlDate(today);\n	   //set start and end date if not already set\n	   if(start.value == \"\") start.value = todayIntl;\n	   if(end.value == \"\") end.value = todayIntl;\n	   	   \n	   //Convert predecessor hours to days\n	   var taskDuration = duration.value;\n	   if(dunits == \"hrs\") taskDuration = taskDuration / hoursPerDay;\n	   var durationFloor = Math.floor(taskDuration);\n	   \n	   //Handle task form and main form seperately due to differences in the forms\n	   if(isTaskForm && taskDuration <= 0) {\n	      //Convert to milestone if task is less or equal to zero\n	      if(confirm(\"Zero duration tasks are considered Milestones.  Do you wish to change this task to a milestone?\")) {\n		     form.milestone.checked = true;\n			 configureMilestone(form.milestone);\n		  } else {\n			 duration.value = form.orig_duration.value;\n	      }\n		  return;\n	   } else if (taskDuration <= 0){\n	      //Do not let users zero out tasks\n		  alert(\"Zero duration tasks are considered Milestones.  Please edit the task by clicking the link if you wish to change this task to a milestone\");\n		  return;\n	   }\n	   \n	   //create the start date \n	   var aTo = start.value.split(\"-\");\n	   var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n       \n	   //add new duration days to the start date\n       toDate.setDate(toDate.getDate() + durationFloor);\n			  \n	   //set end date to this date\n	   end.value = intlDate(toDate);\n	   \n	   //Set new duration in taskArray\n	   taskArray[seqNum][\"duration\"] = duration.value;\n	   //Adjust time based on new end date\n	   adjustTaskTimeFromDate(start, end, duration, end, isTaskForm, predecessor, origStart, origEnd, seqNum);\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function adjustTaskTimeFromDate (start, end, duration, element, isTaskForm, predecessor, origStart, origEnd, seqNum) {\n	   //set the form element\n	   var form = element.form;\n	   //set original duration from task form to determine whether or not to continue to set duration\n	   var orig_duration;\n	   \n	   if(isTaskForm) {\n	      if(form.milestone.checked == true) return;\n          orig_duration = form.orig_duration.value;\n	   }\n	   \n	   //Handle case where both start and end are empty\n	   if(start.value == \"\" && end.value == \"\") {\n	      //get today\'s date\n	      var today = new Date();\n	      var todayIntl = intlDate(today);\n	      //set start and end date if not already set\n		  start.value = todayIntl;\n		  end.value = todayIntl;\n	   }\n	   \n	   //Handle case where one is set and the other isn\'t\n	   if (end.value == \"\") end.value = start.value;\n	   if(start.value == \"\") start.value = end.value;\n	   \n	   if(isTaskForm && orig_duration == \"\") {\n	      //Set duration if this is a new record\n		  //Check to make sure start date comes before end date\n		  var startcomp = start.value.replace(/-/g,\"\");\n	      var endcomp = end.value.replace(/-/g,\"\");\n	      if(startcomp > endcomp) {\n	         alert(\"<tmpl_var form.greaterthan.error>\");\n		     if(element.name == \"start\") {\n		        end.value = element.value;\n		     } else {\n		        start.value = element.value;\n		     }\n		     duration.value = (dunits == \"hrs\")?hoursPerDay:1;\n		     return;\n	      }\n	   \n	      var d = getDaysInterval(start.value,end.value);\n		  if(d == 0) d = 1;\n	      if(dunits == \"hrs\") {\n	         d = d * hoursPerDay;\n	      }\n	      duration.value = d;\n	   } else {\n	      //Set start/end if duration has been saved\n		  var d = duration.value; \n		  if(dunits == \"hrs\") {\n		     //Convert to days\n		     d = d / hoursPerDay;\n		  }\n	      //Round off duration or set it to zero if less than 1;\n		  //alert(\"d = \" + d + \" floor = \" + Math.floor(d));\n		  if(d < 1) d = 0;\n		  else d = Math.floor(d);\n		  \n		  if(element.name.indexOf(\"start\") > -1) {\n		     //create the date \n			  var aTo = start.value.split(\"-\");\n			  var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n             //add duration days to the start date\n              toDate.setDate(toDate.getDate() + d);\n			  //set end date to this date\n			  end.value = intlDate(toDate);\n		  } else if(element.name.indexOf(\"end\") > -1) {\n		      //create the date\n			  var aFrom = end.value.split(\"-\");\n			  var fromDate = new Date(aFrom[0],(aFrom[1]-1),aFrom[2],0,0,1,0);\n			  //subtract duration days from the end date\n			  fromDate.setDate(fromDate.getDate() - d);\n			  //set start date to this date\n			  start.value = intlDate(fromDate);\n		  }\n	   }\n	   \n	   //Check Predecessors before moving stuff\n	   var pred = predecessor.value;\n	   if(pred != \"\") {\n		  //Check to make sure that the dependency requirement for this task is still valid\n		  //Get the predecessor end date\n	      var taskStart = toDateObj(start.value);\n		  var predTaskEnd;\n		  if(isTaskForm) {\n		     predTaskEnd = toDateObj(taskArray[pred][\"end\"]);\n		  } else {\n		     var predTaskEndId = \"end_\"+taskArray[pred][\"id\"]+\"_formId\"\n		     predTaskEnd = toDateObj(document.getElementById(predTaskEndId).value);\n		  }\n		  \n		  if(taskStart.getTime() < predTaskEnd.getTime()) {\n		     alert(\"<tmpl_var form.invalidMove.error>\");\n			 start.value = origStart.value;\n			 end.value = origEnd.value;\n			 return;\n		  }\n	   }\n	   \n	   //Check all tasks past this one and move them forward if necessary (this only needs to happen on the main form)\n	   if(!isTaskForm) {\n	      arrangePredecessors(element,seqNum);\n	   }\n	   //reset orig start and end values\n	   origStart.value = start.value;\n	   origEnd.value = end.value;\n	   \n	   if(!isTaskForm) {\n	      //Adjust task form for \n	      paintGanttChart();\n	   }\n	}\n   \n   //--------------------------------------------------------------------------------------\n   function trim(str) {\n      return str.replace(/^\\s+|\\s+$/, \'\');\n   }\n	\n   //--------------------------------------------------------------------------------------\n   function arrangePredecessors (element,seqNum) {\n	  for (var i = 1; i <= taskLength; i++) {\n	     var seq = i;\n		 var task = taskArray[seq];\n		 var taskId = task[\"id\"];\n		 //Calculate duration and duraiton floor\n		 var durationInDays = parseFloat(task[\"duration\"]);\n		 if(dunits == \"hrs\") durationInDays = durationInDays / hoursPerDay;\n		 var durationFloor = Math.floor(durationInDays);\n		 //alert(\"Duration Floor is: \"+durationFloor);\n		 //Get the current elements\n		 var currElementStart = document.getElementById(\"start_\"+taskId+\"_formId\");\n	     var currElementEnd = document.getElementById(\"end_\"+taskId+\"_formId\");\n		 //alert(\"Current Start Date: \"+currElementStart.value+\"   Current End Date: \"+currElementEnd.value);\n		 //Skip the first record as it is the record that was changed\n		 if(seq > 1) {\n		    var predecessor = task[\"predecessor\"];\n			//alert(\"predecessor for \"+i+\" is \"+predecessor);\n			if(predecessor != \"\") {\n			   var pred = taskArray[predecessor];\n			   var predEndDate = toDateObj(pred[\"end\"]);\n			   var startDate = toDateObj(task[\"start\"]);\n			   //alert (\"Pred End Date: \"+intlDate(predEndDate));\n			   //Make sure start date of this task is greater than the end date of the predecessor\n			   if(startDate.getTime() <= predEndDate.getTime()) {\n			      //Change the start and end dates of the task\n				  //Get the day part of the predecessor\n				  var predDayPart = parseFloat(pred[\"dayPart\"]);\n				  //alert(\"predDayPart: \"+predDayPart);\n				  if(predDayPart > 0) {\n				     //The previous task took up part of a day.  Add the additional day part to the duration\n					 durationInDays += predDayPart;\n					 durationFloor = Math.floor(durationInDays);\n				  }\n				  //alert(\"Duration in Days: \"+durationInDays+\" Duration Floor: \"+durationFloor);\n				  //Set the start date of this task to the end date of the predecessor\n				  currElementStart.value = pred[\"end\"];\n				  //Adjust end date for change in start date and update the object - start date is actually predEndDate now, so use the existing date object\n				  predEndDate.setDate(predEndDate.getDate() + durationFloor);\n				  currElementEnd.value = intlDate(predEndDate);\n				 //alert(\"Set seq \"+i+\" to start: \"+pred[\"end\"]+\" end: \"+intlDate(predEndDate));\n			   }\n			}\n		 }\n		  \n		 //Update task array with new start/end values\n		 taskArray[seq][\"start\"] = currElementStart.value;\n		 taskArray[seq][\"end\"] = currElementEnd.value;\n		 taskArray[seq][\"dayPart\"] = (durationInDays - Math.floor(durationInDays));\n	  }\n   }\n	\n   //--------------------------------------------------------------------------------------	\n	function getDaysInterval(from,to) {\n       var aFrom = from.split(\"-\");\n	   var aTo = to.split(\"-\");\n	   var fromDate = new Date(aFrom[0],(aFrom[1]-1),aFrom[2],0,0,1,0);\n	   var toDate = new Date(aTo[0],(aTo[1]-1),aTo[2],0,0,1,0);\n	   var fromEpoch = fromDate.getTime();\n	   var toEpoch = toDate.getTime();\n	  \n	   var seconds = toEpoch - fromEpoch;\n	   if(seconds == 0) return 0;\n	   return (seconds/dayMS);\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function pad(date) {\n       var str = \"\"+date;\n       if(str.length == 1) {\n	      str = \"0\"+str;\n	   }\n	   return str;\n    }\n	\n   //--------------------------------------------------------------------------------------	\n	function paintGanttChart () {\n	   var status = AjaxRequest.submit(document.forms[\'editAll\'],{\n                                      \'onSuccess\':function(req){ document.getElementById(\'gantt\').innerHTML = req.responseText; }\n                                     });\n       \n	   var mwidth = document.getElementById(\"projectTableWidth\").name + \"px\";\n	   var swidth = document.getElementById(\"projectScrollPercentWidth\").name + \"%\";\n	   document.getElementById(\"mastertable\").style.width=mwidth;\n	   document.getElementById(\"scrolltd\").style.width=swidth;\n	}\n	\n   //--------------------------------------------------------------------------------------	\n	function validateDependant(field,origField,seqNum,start,end,duration,isTaskForm,origStart,origEnd) {\n	   var pred = field.value;\n	   var newTask = false;\n	   if(pred != \"\") {\n	      if(seqNum == \"\") seqNum = taskLength+1;\n		  if(pred < 1) {\n	         alert(\"<tmpl_var form.noPredecessor.error>\");\n		     field.value=origField.value;\n		     return;\n	      }\n	      if(pred == seqNum) {\n	         alert(\"<tmpl_var form.samePredecessor.error>\");\n		     field.value=origField.value;\n		     return;\n	      }\n	      if(pred > seqNum) {\n	         alert(\"<tmpl_var form.previousPredecessor.error>\");\n		     field.value = origField.value;\n		     return; \n	      }\n		  \n	      //Set defaults if it\'s a new record and one of the other options hasn\'t been checked.\n	      if(start.value == \"\" || end.value == \"\") {\n             //get today\'s date\n			 newTask = true;\n			 duration.value = (dunits == \"hrs\")?hoursPerDay:1; \n		  }\n	      //Get the predecessor end date and decide where the new start date belongs\n	      var taskStart = start.value;\n		  var taskStartObj = toDateObj(taskStart);\n		  var predTaskEnd = taskArray[pred][\"end\"];\n		  var predTaskEndObj = toDateObj(predTaskEnd);\n		  \n		  //Change start date if it comes before predecessor end date\n		  if(newTask || (taskStartObj.getTime() < predTaskEndObj.getTime())) {\n		     \n			 //Convert predecessor hours to days\n	         var taskDuration = duration.value;\n			 if(dunits == \"hrs\") taskDuration = taskDuration / hoursPerDay;\n			 var durationFloor = Math.floor(taskDuration);\n			 \n			 //Get the predecessor dayPart\n			 var predDayPart = parseFloat(pred[\"dayPart\"]);\n		     if(predDayPart > 0) {\n		        //The previous task took up part of a day.  Add the additional day part to the duration\n			    taskDuration += predDayPart;\n				durationFloor = Math.floor(durationInDays);\n			 }\n	         \n			 //Set the start date of this task to the end date of the predecessor\n		     start.value = predTaskEnd;\n			 //Adjust end date for change in start date\n	         adjustTaskTimeFromDate(start,end,duration,start,isTaskForm,field,origStart,origEnd,seqNum);\n			 return;\n		  }\n	   }\n	   \n	   //Repaint\n	   if(!isTaskForm) {\n	      //Set new predecessor in taskArray\n	      taskArray[seqNum][\"predecessor\"] = pred;\n	      paintGanttChart();\n	   }\n	}\n   \n    addEvent(window, \"load\", initPopUp);\n</script>\n<tmpl_var form.header>\n<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"project\" id=\"mastertable\" style=\"width:<tmpl_var project.table.width>px;\">\n   <tbody>\n      <tr>\n         <td style=\"width:20px;height:20px;\">&nbsp;</td>\n	     <td style=\"width:300px;\" align=\"center\">Task Name</td>\n	     <td style=\"width:70px;\" align=\"center\">Duration</td>\n	     <td style=\"width:70px;\" align=\"center\">Start</td>\n	     <td style=\"width:70px;\" align=\"center\">Finish</td>\n	     <td style=\"width:30px;\" align=\"center\">Pred</td>\n	     <td rowspan=\"<tmpl_var project.gaant.rowspan>\" valign=\"top\" id=\"scrolltd\" style=\"border-style:none;width:<tmpl_var project.scroll.percentWidth>%;\">\n	        <div class=\"scroller\" id=\"gantt\">\n			   <tmpl_var project.ganttChart>\n		    </div>\n	     </td>\n      </tr>\n      <tr>\n	     <td colspan=\"6\">&nbsp;</td>\n      </tr>\n      <tmpl_loop task.loop>\n      <tr id=\"<tmpl_var task.row.id>\">\n	     <td align=\"center\" style=\"height:20px\"><tmpl_var task.number></td>\n	     <td align=\"left\" style=\"height:20px\">\n	        <tmpl_if task.canAdd>\n		       <a href=\"<tmpl_var task.edit.url>\" class=\"submodal\"><tmpl_var task.name></a>\n		    <tmpl_else>\n		       <tmpl_var task.name>\n		    </tmpl_if>\n	     </td>\n	     <td align=\"center\" style=\"height:20px\"><tmpl_var task.duration> <tmpl_var task.duration.units></td>\n	     <td align=\"center\" style=\"height:20px\"><tmpl_var task.start></td>\n	     <td align=\"center\" style=\"height:20px\"><tmpl_var task.end></td>\n	     <td align=\"center\" style=\"height:20px\"><tmpl_var task.dependants></td>	\n      </tr>\n      </tmpl_loop>\n      <tr><td colspan=\"6\" style=\"border-style:none;\">&nbsp;</td></tr>\n      <tr><td colspan=\"6\" style=\"border-style:none;\">&nbsp;</td></tr>\n   </tbody>\n</table>\n<tmpl_var form.footer>\n\n<div id=\"links\">\n<!-- 	<tmpl_if project.canEdit><a href=\"<tmpl_var task.resources.url>\"><tmpl_var task.resources.label></a>&nbsp;|&nbsp;</tmpl_if> -->\n	<tmpl_if task.canAdd><a href=\"<tmpl_var task.add.url>\" class=\"submodal\"><tmpl_var task.add.label></a>&nbsp;|&nbsp;</tmpl_if>\n	<a href=\"<tmpl_var task.back.url>\"><tmpl_var task.back.label></a>\n</div>\n<script type=\"text/javascript\">\n	init(\"mastertable\");\n</script>\n\n','ProjectManager_project',1,1,'ProjectManagerTMPL0002',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n	body, html {\n		margin:0px;\n		padding:0px;\n	}\n	.project {\n		position:relative;\n		margin-top:5px;\n		margin-left:5px;\n	}\n	.project td {\n		border:solid silver 1px;\n		border-bottom:solid gray 1px;\n		font-size:9pt;\n		font-family:arial;		\n	}\n	.project a {\n	    color:#000000;\n		font-weight: normal;\n		font-size: 9pt;\n		text-decoration: none;\n	}\n	\n	.project a:hover {\n	    color:#7AB7E9;\n		font-weight: normal;\n		font-size: 9pt;\n		text-decoration: none;\n	}\n	\n	.taskname {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 295px;\n    }\n	.taskduration {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 25px;\n	}\n	.taskdate {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 68px;\n	}\n	.taskdependant {\n	   font-family: verdana;\n	   font-size: 10px;\n	   font-weight: normal;\n	   color: black;\n	   width: 20px;\n	}\n	tr.monthNames td {		\n		text-align:center;		\n	}\n	tr.dates td {\n		width:16px;\n	}\n	div.scroller {		\n		overflow:scroll;		\n		position:relative;\n		width:400px;		\n	}\n	\n	* html div.scroller {\n		overflow-x:scroll;\n	}\n	\n	td.empty {\n		background-color:transparent;\n		border-style:none;\n		height:20px;\n	}\n	\n	div.barPositions {\n		position:relative;\n	}\n	div.projectBar {\n		background-color:#7AB7E9;\n		position:absolute;\n		height:10px;\n		z-index:2;\n		padding:0px;\n		margin:0px;\n		font-size:1pt;\n	}\n	div.statusBar {	\n		background-color:#000;\n		position:absolute;	\n		height:5px;\n		z-index:3;\n		padding:0px;\n		top:2px;\n		margin:0px;		\n		font-size:1pt;		\n	}\n	\n	div.projectLineH {		\n		background: url(\'images/dot.gif\') top repeat-x;		\n		font-size:1pt;\n		text-align:right;\n		position:absolute;\n	}		\n	div.projectLineV {\n		width:1px;\n		background-color:black;\n		position:relative;\n		font-size:1pt;	\n		height:100%;\n		float:right;\n	}\n	\n	div.projectLabel {\n		position:absolute;\n		margin-top:-3px;\n		white-space:nowrap;\n		font-family: verdana;\n		font-size:8px;\n	}\n	\n	div.milestone {\n		color:#000000;\n		position:absolute;\n		z-index:4;\n		margin:0px;\n		padding:0px;		\n		margin-top:-3px;\n		font-size: 10px;\n		font-family: times;\n	}\n	\n	#links {\n		margin-top:7px;\n		margin-left:5px;\n		font-family:arial;\n		font-size:9pt;\n	}\n	\n	#links a {\n		color:#7AB7E9;\n	}\n</style>\n\n<style>\n.popUp {\n			width:100%;\n			border:solid black 0px;\n			background-color:#F5F5F5;\n		}\n		.popUp td {\n			font-size:9pt;	\n			font-family:arial;\n			border-top:solid #E0E0E0 1px;\n		}	\n		.popUp tr.clear td {\n			border-style:none;\n			background-color:#F0F0F0;\n		}\n		.popUp tr.clearNoBG td {\n			border-style:none;\n		}\n		.popUp td.header {\n			font-weight:bold;\n		}\n		a.saveBtn {\n			width:40px;\n			height:15px;\n			background-color:silver;\n			padding:1px;\n			padding-left:5px;\n			padding-right:5px;\n			color:white;\n			border:solid gray 1px;\n			text-decoration:none;\n			font-weight:bold;\n			display:block;\n			float:right;\n			text-align:center;\n		}\n		a.saveBtn:hover {\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n</style>\n'),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<div class=\"defaultSubmissionDetails\">\n	<b><tmpl_var user.label>:</b> \n		<tmpl_if user.isVisitor>\n			<tmpl_var username>\n		<tmpl_else>\n			<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n		</tmpl_if>\n		<br />\n	<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n	\n	<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n	<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n		<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n		</tmpl_unless>\n		<br />\n	<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var unarchive.url>\"><tmpl_var open.label></a> <tmpl_else> <tmpl_var open.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var archive.url>\"><tmpl_var close.label></a></tmpl_if> ]<br />\n	<tmpl_else>	\n		<tmpl_if user.isPoster>\n			<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> <tmpl_else> <tmpl_var open.label></tmpl_if><br />\n		</tmpl_if>	\n	</tmpl_if>	\n<tmpl_if karmaIsEnabled>\n	<b><tmpl_var karmaRank.label>:</b> <tmpl_var karmaRank><br />\n<b><tmpl_var transferkarma.label>:</b>\n<tmpl_var transfer.karma.form>\n</tmpl_if>	\n</div>\n\n<div class=\"collaborationThreadContent\">\n<p><b><tmpl_var userDefined2> <tmpl_var userDefined3></b></p>\n	<tmpl_var content>\n</div>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<div style=\"clear:both;\"></div>\n\n<tmpl_if repliesAllowed>\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">	\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if><br />\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>\n	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a>				\n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n	<br />\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000067',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	background-color: #eeeeee;\r\n	padding: 3px;\r\n}\r\n.postData td {\r\n	font-size: 9pt;\r\n	color: black;\r\n	font-family:arial;\r\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\ndisplay:block;\n	-moz-box-sizing:border-box;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n}\n\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n</style>\n'),('\n<table class=\"timeTracking02\" cellpadding=\"3\" cellspacing=\"0\">\n<tbody id=\"ttbody\">\n   <tr class=\"tt_title\" id=\"tt_title\">\n      <td colspan=\"4\" align=\"left\"><tmpl_var time.report.header></td>\n	  <td colspan=\"2\" align=\"right\"><tmpl_var time.report.hours.label> <strong style=\"color:red;\" id=\"totalHours\">0</strong></td>\n   </tr>\n   <tr class=\"tt_header\" id=\"tt_header\">\n      <td width=\"10%\"><tmpl_var time.report.date.label></td>\n	  <td width=\"20%\"><tmpl_var time.report.project.label></td>\n	  <td width=\"20%\"><tmpl_var time.report.task.label></td>\n	  <td width=\"10%\"><tmpl_var time.report.hours.label></td>\n	  <td width=\"40%\"><tmpl_var time.report.comments.label></td>\n	  <td>&#160;</td>\n   </tr>\n   <tmpl_loop time.entry.loop>\n      <tr id=\"<tmpl_var row.id>\">\n         <td class=\"cell\"><tmpl_var form.taskEntryId><tmpl_var form.date></td>\n         <td class=\"cell\"><tmpl_var form.project></td>\n         <td class=\"cell\"><tmpl_var form.task></td>\n         <td class=\"cell\"><tmpl_var form.hours></td>\n         <td class=\"cell\"><tmpl_var form.comments></td>\n         <td><img src=\"<tmpl_var extras>/delete.gif\" border=\"0\" onclick=\"removeRow(\'<tmpl_var row.id>\')\" style=\"cursor:pointer\"/></td>\n      </tr>\n   </tmpl_loop>\n </tbody>\n</table>\n\n<div style=\"text-align:left;margin-top:3px;margin-bottom:3px;\">\n<table class=\"timeTracking02\">\n<tbody>\n   <tr class=\"tt_empty\" id=\"tt_empty\">\n      <td colspan=\"6\" style=\"border-top:solid gray 2px;\">\n	      <table width=\"100%\">\n		     <tr>\n			    <td width=\"60%\" align=\"left\">\n				   <tmpl_var time.report.complete.label><tmpl_var form.isComplete>\n				</td>\n				<td width=\"40%\" align=\"right\">\n					<input type=\"button\" value=\"<tmpl_var time.add.row.label>\" onclick=\"addRow();\" /> &#160; <input type=\"submit\" value=\"<tmpl_var time.save.label>\" />\n			    </td>			\n		     </tr>\n	      </table>		\n	   </td>\n   </tr>\n</tbody>\n</table>\n</div>\n\n<table style=\"display:none\" id=\"tt_table\">\n   <tbody>\n      <tr id=\"<tmpl_var row.id>\">\n         <td class=\"cell\"><tmpl_var form.taskEntryId><tmpl_var form.date></td>\n         <td class=\"cell\"><tmpl_var form.project></td>\n         <td class=\"cell\"><tmpl_var form.task></td>\n         <td class=\"cell\"><tmpl_var form.hours></td>\n         <td class=\"cell\"><tmpl_var form.comments></td>\n         <td><img src=\"<tmpl_var extras>/delete.gif\" border=\"0\" onclick=\"removeRow(\'<tmpl_var row.id>\')\" style=\"cursor:pointer\" /></td>\n      </tr>\n   </tbody>\n</table>\n\n\n\n\n','TimeTracking_row',1,1,'TimeTrackingTMPL000003',1148579525,'WebGUI::Asset::Template::HTMLTemplate','	\n'),('<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<script language=\"JavaScript\">\n   var nextRowNum = <tmpl_var time.report.rows.total>;\n   var projectTasks = <tmpl_var project.task.array>  //Do not put a semi colon at the end of this.  The app does it\n   \n   //-----------------------------------------------------------------------------------\n   function changeOptions(proj,task) {\n      var projId = proj.value;\n	  //Remove all options from task list except first one\n	  var optLen = task.options.length;\n	  while (task.options.length > 1) {\n		 var elem = task.options[1];\n		 task.removeChild(elem);\n	  }\n	  \n	  if(projId != \"\") {\n	     //Add new options\n	     var array = projectTasks[projId];\n         for (var word in array) {\n            var opt = document.createElement(\"option\");\n	        opt.setAttribute(\"value\",word);\n	        opt.appendChild(document.createTextNode(array[word]));\n            task.appendChild(opt);\n         }\n      }\n	  \n	  //Fix IE Bug which causes dymamic repopulation to fail\n	  var newtask = task;\n	  var col = task.parentNode;\n	  col.removeChild(task);\n	  col.appendChild(newtask);\n	  \n   }\n   \n   //-----------------------------------------------------------------------------------\n   function recalcHours() {\n	   var newHours = 0;\n	   var rows = document.getElementById(\"ttbody\");\n	   var rowLen = rows.childNodes.length;\n	   \n	   for(var i = 0; i <= rowLen; i++) {\n	      var row = rows.childNodes[i];\n		  if(row && row.id && row.id.indexOf(\"row\") > -1) {\n		     var rowId = row.id;\n		     var idPart = rowId.split(\"_\");\n		     var rowNum = idPart[1];\n		     var hourElem = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n		     if (hourElem) {\n		        newHours += parseFloat(hourElem.value);\n	         }\n	      }\n	   }\n	   document.getElementById(\'totalHours\').innerHTML = newHours;\n   }\n\n   //-----------------------------------------------------------------------------------   \n   function getTarget(e) {\n      var targ;\n      if (!e) var e = window.event;\n      if (e.target) targ = e.target;\n      else if (e.srcElement) targ = e.srcElement;\n      if (targ.nodeType == 3) // defeat Safari bug\n         targ = targ.parentNode;\n      return targ\n   }  \n\n   //-----------------------------------------------------------------------------------    \n   function removeRow(e) {\n      if(!e) e = window.event || window.Event;\n	  var eleId = e;\n      if(typeof(e) == \"object\") {\n	    var targ = getTarget(e);\n		var eleId = targ.parentNode.parentNode.id;\n	  } \n	  var row = document.getElementById(eleId);\n	  var ttbody = document.getElementById(\"ttbody\");\n      var timeRowCount = getTimeRowCount();\n	  if(timeRowCount > 1) {\n	     ttbody.removeChild(row);\n	     recalcHours();\n		 return;\n	  }\n	  alert(\"<tmpl_var js.alert.removeRow.error>\");\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function getTimeRowCount() {\n      var rows = document.getElementById(\"ttbody\");\n      var rowLen = rows.childNodes.length;\n	  var count = 0;\n	  \n	  for(var i = 0; i <= rowLen; i++) {\n	     var row = rows.childNodes[i];\n		 //Skip Text and Attribute Nodes\n		 if(row && row.id && row.id.indexOf(\"row\") > -1) count++;\n	  }\n	  return count;\n   }\n      \n   //-----------------------------------------------------------------------------------  \n   function addRow() {\n      var rowx = document.getElementById(\'row_x\');\n	  var row = rowx.cloneNode(true);\n	  //Insert row into the right place\n	  var ttbody = document.getElementById(\'ttbody\');\n	  ttbody.appendChild(row);\n	  \n	  row.id=\'row_\'+nextRowNum;\n	  //Task Entry Id\n	  var rowLen = row.childNodes.length;\n	  for ( var i = 0; i < rowLen; i++) {\n	     var td = row.childNodes[i];\n		 var colLen = td.childNodes.length;\n		 for ( var j = 0; j < colLen; j++) {\n		    var node = td.childNodes[j];\n//			alert(node + \" \" + node.nodeType);\n			//Skip Text and Attirbute Node Types\n			if(node.nodeType != 1) continue;\n			//alert(node + \" \" + node.tagName);\n			var nodeName = node.name;\n				\n			//Handle Image Node\n			if(node.tagName == \"IMG\") {\n			   var newImg = document.createElement(\'img\');\n			   newImg.setAttribute(\"style\",\"cursor:pointer\");\n			   newImg.src = \"http://frank1.plainblack.net:8084/extras/wobject/TimeTracking/delete.gif\";\n			   newImg.onclick = removeRow;\n			   \n			   childLen = node.childNodes.length;\n			  // alert(\"removing this node\");\n			   td.removeChild(node);\n			   \n			  // alert(\"appending new node: \" + newImg);\n			   td.appendChild(newImg);\n			   continue;\n			}\n			\n			//Skip Nodes that have no names\n			if(nodeName == \"\") continue;\n			var nameParts = nodeName.split(\"_\");\n			var colName = nameParts[0];\n			//Set New Node Name\n			node.name = colName + \"_\" + nextRowNum;\n			//Set New Node ID\n			node.id = colName + \"_\" + nextRowNum + \"_formId\";\n			\n			if(colName == \"projectId\") {\n			   node.onchange = new Function(\'changeOptions(this,document.getElementById(\"taskId_\'+nextRowNum+\'_formId\"));\'); \n			} \n		 }   \n	  \n	  }\n	  nextRowNum++;\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function validateForm(form) {\n      //Set Row Total\n      form.rowTotal.value = (nextRowNum - 1);\n	  if(parseFloat(document.getElementById(\'totalHours\').innerHTML) > 168) {\n	     alert(\"<tmpl_var js.alert.validate.hours.error>\");\n		 return false;\n	  }\n	  \n	  var rows = document.getElementById(\"ttbody\");\n      var rowLen = rows.childNodes.length;\n	  var isValid = true;\n	  	  \n	  for(var i = 0; i <= rowLen; i++) {\n	     var row = rows.childNodes[i];\n		 if(row && row.id && row.id.indexOf(\"row\") > -1) {\n		    var rowId = row.id;\n		    var idPart = rowId.split(\"_\");\n		    var rowNum = idPart[1];\n		    var taskDateElem = document.getElementById(\"taskDate_\"+rowNum+\"_formId\");\n			taskDateElem.style.background=\'#FFFFFF\';\n			var projectElem = document.getElementById(\"projectId_\"+rowNum+\"_formId\");\n			projectElem.style.background=\'#FFFFFF\';\n			var taskElem = document.getElementById(\"taskId_\"+rowNum+\"_formId\");\n			taskElem.style.background=\'#FFFFFF\';\n			var hourElem = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n			hourElem.style.background=\'#FFFFFF\';\n			//Uncomment below if you wish comments to be required\n			//var comments = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n			//comments.style.background=\'#FFFFFF\';\n			\n			//Uncomment below if you wish comments to be required\n			//if(taskDateElem.value != \"\" || projectElem.value != \"\" || taskElem.value != \"\" || hourElem.value != \"\" || comments.value != \"\" ) {\n			//Comment below if you wish comments to be required\n			if(taskDateElem.value != \"\" || projectElem.value != \"\" || taskElem.value != \"\" || (hourElem.value != \"\" && hourElem.value != \"0\")) {\n			   if(taskDateElem.value == \"\") {\n				  taskDateElem.style.background=\'#FFFF99\';\n			      isValid = false;\n			   } \n			   \n			   if(projectElem.value == \"\") {\n			      projectElem.style.background=\'#FFFF99\';\n			      isValid = false;\n			   } \n			   \n			   if(taskElem.value == \"\") {\n			      taskElem.style.background=\'#FFFF99\';\n				  isValid = false;\n			   } \n			   \n			   if(hourElem.value == \"\" || hourElem.value == 0) {\n			      hourElem.style.background=\'#FFFF99\';\n				  isValid = false;\n			   }\n			   \n			   //Uncomment below if you wish comments to be required\n			   /*if(comments.value == \"\") {\n			      commnts.style.background=\'#FFFF99\';\n				  isValid = false;\n			   }*/\n			}\n		 }\n	  }\n	  \n	  if(!isValid) {\n	     alert(\"<tmpl_var js.alert.validate.incomplete.error>\");\n		 return false;\n	  }\n	  \n	  return true;\n   }\n   \n</script>\n\n<p><tmpl_if project.manage.url><a href=\"<tmpl_var project.manage.url>\"><tmpl_var project.manage.label></a></tmpl_if></p>\n<tmpl_var form.header>\n<tmpl_var form.timetracker>\n<tmpl_var form.footer>\n\n','TimeTracking_user',1,1,'TimeTrackingTMPL000001',1148579525,'WebGUI::Asset::Template::HTMLTemplate','	<style type=\"text/css\">\n		.timeTracking02 {			\n			width:850px;\n		}\n		.timeTracking02 td {\n			border:solid silver 1px;\n			border-bottom:solid gray 1px;\n			font-size:9pt;\n			font-family:arial;			\n		}\n		tr.tt_title td {\n			font-weight:bold;			\n			background-color:#F0F0F0;\n			border-style:none;\n			font-size:11pt;\n		}\n		tr.tt_header td {\n			font-weight:bold;\n			text-align:center;		\n		}\n		tr.tt_empty td {\n			border-style:none;\n		}\n		\n		.pt-select {\n	       font-weight: normal;\n	       color: black;\n  	       width: 175px;\n        }\n		.date-select {\n		   font-weight: normal;\n	       color: black;\n  	       width: 100px;\n		}\n	</style>\n'),('<tmpl_if session.var.adminOn>\n	<tmpl_if controls>\n		<p><tmpl_var controls></p>\n	</tmpl_if>\n</tmpl_if>\n\n\n<div>\n	<object type=\"application/x-shockwave-flash\" data=\"<tmpl_var fileUrl>\" style=\"height:auto;min-height:100px;width:100%;display:block;\">\n		<param name=\"movie\" value=\"<tmpl_var fileUrl>\" />		\n	</object>\n</div>','FileAsset',1,1,'pbtmpl0000000000000220',1148579525,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>			\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>		\n		\n<div class=\"mainNav\">\n	<tmpl_loop page_loop>	\n		<div class=\"level<tmpl_var page.relDepth>\">\r\n			<a <tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"anAncestor\" </tmpl_if><tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\r\n		</div>		\n	</tmpl_loop>\n</div>\r\n~~~\r\n<style type=\"text/css\">\r\n.mainNav {\r\n\r\n}\r\n.mainNav a {\r\n	\r\n}\r\na.navOn {\r\n	\r\n}\r\na.anAncestor {\r\n\r\n}\r\ndiv.level0 a {\r\n	margin-left:0px;\r\n	display:block;\r\n}\r\ndiv.level1 a {\r\n	margin-left:15px;\r\n	display:block;	\r\n}\r\ndiv.level2 a {\r\n	margin-left:30px;\r\n	display:block;\r\n}\r\ndiv.level3 a {\r\n	margin-left:45px;\r\n	display:block;\r\n}\r\ndiv.level4 a {\r\n	margin-left:60px;\r\n	display:block;\r\n}\r\n</style>\n','Navigation',1,1,'PBnav00000000indentnav',1148579525,'WebGUI::Asset::Template::HTMLTemplate',NULL),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a> \n\n<tmpl_if session.var.adminOn> \n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<h2><tmpl_var title></h2>\n\n<div class=\"defaultSubmissionDetails\">\n	<b><tmpl_var user.label>:</b> \n		<tmpl_if user.isVisitor>\n			<tmpl_var username>\n		<tmpl_else>\n			<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n		</tmpl_if>\n		<br />\n	<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human><br />\n	<b><tmpl_var severity.label>:</b> <tmpl_var userDefined1><br />\n	<b><tmpl_var views.label>:</b> <tmpl_var views><br />\n	<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n		<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n		</tmpl_unless>\n		<br />\n	<tmpl_if user.isModerator>\n		<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var unarchive.url>\"><tmpl_var open.label></a> <tmpl_else> <tmpl_var open.label> &nbsp; &nbsp; [ <a href=\"<tmpl_var archive.url>\"><tmpl_var close.label></a></tmpl_if> ]<br />\n	<tmpl_else>	\n		<tmpl_if user.isPoster>\n			<b><tmpl_var status.label>:</b> <tmpl_if isArchived><tmpl_var closed.label> <tmpl_else> <tmpl_var open.label></tmpl_if><br />\n		</tmpl_if>	\n	</tmpl_if>	\n<tmpl_if karmaIsEnabled>\n	<b><tmpl_var karmaRank.label>:</b> <tmpl_var karmaRank><br />\n<b><tmpl_var transferkarma.label>:</b>\n<tmpl_var transfer.karma.form>\n</tmpl_if>	\n</div>\n\n<div class=\"collaborationThreadContent\">\n	<tmpl_var content>\n</div>\n\n<tmpl_if attachment_loop>\n	<br />\n		<tmpl_loop attachment_loop>\n			<div style=\"float: left; padding: 5px;\">\n				<a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a>\n			</div>\n		</tmpl_loop>\n		<div style=\"clear: both;\"></div>\n	<br />\n</tmpl_if>\n\n\n\n<tmpl_unless isLocked>\n	<div class=\"postControls\">\n		<tmpl_if user.canReply>\n			<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if user.canEdit>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n			&bull;\n			<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n		</tmpl_if>\n	</div>\n</tmpl_unless>\n\n<div style=\"clear:both;\"></div>\n\n<tmpl_if repliesAllowed>\n	<div style=\"float: left; width: 70%\">\n		<h2><tmpl_var replies.label></h2>\n	</div>\n	<div style=\"width: 30%; float: left; text-align: right;\">\n	<tmpl_if layout.isFlat>\n		<a href=\"<tmpl_var layout.nested.url>\"><tmpl_var layout.nested.label></a>\n	<tmpl_else>\n		<a href=\"<tmpl_var layout.flat.url>\"><tmpl_var layout.flat.label></a>\n	</tmpl_if>\n	</div>\n	<div style=\"clear: both;\"></div>\n	\n	<tmpl_if layout.isFlat>\n	<!-- begin flat layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n					<a name=\"<tmpl_var assetId>\"></a>\n					<div class=\"postSubject\">\n						<tmpl_var title>\n					</div>\n					<div class=\"postData\">\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>\n					</div>\n					<div class=\"postMessage\">\n						<tmpl_var content>\n						<tmpl_loop attachment_loop>\n							<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n						</tmpl_loop>\n						<div style=\"clear: both;\"></div>\n					</div>\n					<tmpl_unless isLocked>\n						<div class=\"postControls\">\n							<tmpl_if user.canReply>\n								<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n								&bull;\n							</tmpl_if>\n							<tmpl_if user.canEdit>\n								<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n								&bull;\n								<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n							</tmpl_if>\n						</div>\n					</tmpl_unless>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end flat layout -->\n	</tmpl_if>\n	\n	<tmpl_if layout.isNested>\n	<!-- begin nested layout -->\n		<tmpl_loop post_loop>\n			<tmpl_unless isThreadRoot>\n				<div style=\"margin-left: <tmpl_var depthX10>px;\">\n					<div class=\"postBorder<tmpl_if isCurrent>Current</tmpl_if>\">\n						<a name=\"<tmpl_var assetId>\"></a>\n						<div class=\"postSubject\">\n							<tmpl_var title>\n						</div>\n						<div class=\"postData\">\n						<table cellpadding=\"0\" cellspacing=\"0\">\n						<tbody>\n						<tr>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var user.label>:</b> \n									<tmpl_if user.isVisitor>\n										<tmpl_var username>\n									<tmpl_else>\n										<a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n									</tmpl_if>\n									<br />\n								<b><tmpl_var date.label>:</b> <tmpl_var dateSubmitted.human>\n							</td>\n							<td style=\"width:50%;text-align:left;\">\n								<b><tmpl_var rating.label>:</b> <tmpl_var rating>\n								<tmpl_unless hasRated>\n								&nbsp; &nbsp;<tmpl_var rate.label> [ <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsUp>\"><img src=\"<tmpl_var thumbsUp.icon.url>\" alt=\"+\" style=\"border: 0px;vertical-align:middle;\" /></a></p> | <p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var rate.url.thumbsDown>\"><img src=\"<tmpl_var thumbsDown.icon.url>\" alt=\"-\" style=\"border: 0px;vertical-align:middle;\" /></a></p> ]\n								</tmpl_unless>														\n							</td>\n						</tr>\n						</table>	\n						</div>\n						<div class=\"postMessage\">\n							<tmpl_var content>\n							<tmpl_loop attachment_loop>\n								<div style=\"float: left; padding: 5px;\"><a href=\"<tmpl_var url>\"><tmpl_if isImage><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var filename>\" /><tmpl_else><img src=\"<tmpl_var icon>\" border=\"0\" alt=\"<tmpl_var filename>\" align=\"middle\" /> <tmpl_var filename></tmpl_if></a></div>\n							</tmpl_loop>\n							<div style=\"clear: both;\"></div>\n						</div>\n						<tmpl_unless isLocked>\n							<div class=\"postControls\">\n								<tmpl_if user.canReply>\n									<a href=\"<tmpl_var reply.url>\"><tmpl_var reply.label></a>\n									&bull;\n								</tmpl_if>\n								<tmpl_if user.canEdit>\n									<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n									&bull;\n									<a href=\"<tmpl_var delete.url>\"><tmpl_var delete.label></a>\n								</tmpl_if>\n							</div>\n						</tmpl_unless>\n					</div>\n				</div>\n			</tmpl_unless>\n		</tmpl_loop>\n	<!-- end nested layout -->\n	</tmpl_if>\n	\n	<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\" style=\"margin-top: 20px;\">\n			[ <tmpl_var pagination.previousPage> | <tmpl_var pagination.pageList.upTo10> | <tmpl_var pagination.nextPage> ]\n		</div>\n	</tmpl_if>\n</tmpl_if>	\n\n<div class=\"postControls\">\n	<tmpl_if previous.url>\n		<a href=\"<tmpl_var previous.url>\"><tmpl_var previous.label></a> \n		&bull;\n	</tmpl_if>	\n	<a href=\"<tmpl_var collaboration.url>\"><tmpl_var back.label></a>\n	\n	<tmpl_if next.url>\n		&bull;\n		<a href=\"<tmpl_var next.url>\"><tmpl_var next.label></a>				\n	</tmpl_if>	\n	<tmpl_if user.canPost>\n		&bull;\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<tmpl_if isSticky>\n			<a href=\"<tmpl_var unstick.url>\"><tmpl_var unstick.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var stick.url>\"><tmpl_var stick.label></a>\n			&bull;\n		</tmpl_if>\n		<tmpl_if isLocked>\n			<a href=\"<tmpl_var unlock.url>\"><tmpl_var unlock.label></a>\n			&bull;\n		<tmpl_else>\n			<a href=\"<tmpl_var lock.url>\"><tmpl_var lock.label></a>\n			&bull;\n		</tmpl_if>\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n</div>\n','Collaboration/Thread',1,1,'PBtmpl0000000000000209',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	background-color: #eeeeee;\n	padding: 3px;\n}\n.postData td {\n	font-size: 9pt;\n	color: black;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\ndisplay:block;\n	-moz-box-sizing:border-box;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#C0C0C0;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n}\n\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n</style>'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\r\r<tmpl_if showAdmin>\r<p><tmpl_var controls></p>\r</tmpl_if>\r\r\r<tmpl_if displayTitle>\r  <h2><tmpl_var title></h2>\r</tmpl_if>\r\n\n<table cellpadding=\"5\">\n<tr>\n	<td class=\"firstColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 1 -->\r		<div class=\"layoutColumnPadding\">\r		<tmpl_if showAdmin>\r			<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\r		</tmpl_if>\r\r		<tmpl_loop position1_loop>\r			<tmpl_if showAdmin>\r		            	<tr id=\"td<tmpl_var id>\">\r		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r			</tmpl_if>\r\r			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\r			<tmpl_if showAdmin>\r		         			</div></td>\r		            	</tr>\r			</tmpl_if>\r		</tmpl_loop>\r\r		<tmpl_if showAdmin>\r		            </tbody></table>\r		</tmpl_if>\r		</div>\r		<!-- end position 1 -->	\n	</td>\n	<td class=\"secondColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 2 -->\r		<div class=\"layoutColumnPadding\">\r		<tmpl_if showAdmin>\r			<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\r		</tmpl_if>\r\r		<tmpl_loop position2_loop>\r			<tmpl_if showAdmin>\r		            	<tr id=\"td<tmpl_var id>\">\r		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r			</tmpl_if>\r\r			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\r			<tmpl_if showAdmin>\r		         			</div></td>\r		            	</tr>\r			</tmpl_if>\r		</tmpl_loop>\r\r		<tmpl_if showAdmin>\r		            </tbody></table>\r		</tmpl_if>\r		</div>\r		<!-- end position 2 -->	\n	\n	</td>\n</tr>\n</table>\n\r<tmpl_if description>\r  <p><tmpl_var description></p>\r</tmpl_if>\r\r<tmpl_if showAdmin>\r	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\r            <tmpl_var dragger.init>\r</tmpl_if>\n','Layout',1,1,'PBtmpl00000000table125',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r.firstColumn {\r  width: 35%;\r}\r.secondColumn {\r        max-width: 65%;\r}\r</style>\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\r\n\r\n<tmpl_if showAdmin>\r\n	<p><tmpl_var controls></p>\r\n</tmpl_if>\r\n\r\n\r\n<tmpl_if displayTitle>\r\n	<h2><tmpl_var title></h2>\r\n</tmpl_if>\r\n\r\n<tmpl_if description>\r\n	<p><tmpl_var description></p>\r\n</tmpl_if>\r\n\n<table cellpadding=\"5\">\n<tr>\n	<td align=\"left\" valign=\"top\" colspan=\"2\">\n		<!-- begin position 1 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n		<tmpl_loop position1_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 1 -->	\n	</td>\n</tr>\n<tr>\n	<td class=\"firstColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 2 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position2_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 2 -->	\n	</td>\n	<td class=\"secondColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 3 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position3\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position3_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 3 -->	\n	</td>\n</tr>	\n<tr>\n	<td align=\"left\" valign=\"top\" colspan=\"2\">\n		<!-- begin position 4 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position4\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position4_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 4 -->	\n	</td>\n</tr>\n</table>\r\n\r\n<tmpl_if showAdmin>\r\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\r\n	<tmpl_var dragger.init>\r\n</tmpl_if>\n','Layout',1,1,'PBtmpl00000000table094',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 50%;\r\n}\r\n.secondColumn {\r\n	width: 50%;\r\n}\r\n</style>\r\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\r\n\r\n<tmpl_if showAdmin>\r\n<p><tmpl_var controls></p>\r\n</tmpl_if>\r\n\r\n<tmpl_if displayTitle>\r\n  <h2><tmpl_var title></h2>\r\n</tmpl_if>\r\n\r\n<tmpl_if description>\r\n  <p><tmpl_var description></p>\r\n</tmpl_if>\r\n\n<table cellspacing=\"5\">\n<tr>\n	<td class=\"firstColumn\" valign=\"top\" align=\"left\">\n		<!-- begin position 1 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position1_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 1 -->	\n	</td>\n	<td class=\"secondColumn\" valign=\"top\" align=\"left\">\n		<!-- begin position 2 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position2_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 2 -->	\n	</td>\n</tr>\n</table>\n\r\n<tmpl_if showAdmin>\r\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\r\n            <tmpl_var dragger.init>\r\n</tmpl_if>\n','Layout',1,1,'PBtmpl00000000table131',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 65%;\r\n}\r\n.secondColumn {\r\n    width: 35%;\r\n}\r\n</style>\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\r\n\r\n<tmpl_if showAdmin>\r\n	<p><tmpl_var controls></p>\r\n</tmpl_if>\r\n\r\n<tmpl_if displayTitle>\r\n	<h2><tmpl_var title></h2>\r\n</tmpl_if>\r\n\r\n<tmpl_if description>\r\n	<p><tmpl_var description></p>\r\n</tmpl_if>\r\n\n<table>\n<tr>\n	<td class=\"firstColumn\" valign=\"top\" align=\"left\">\n		<!-- begin position 1 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position1_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 1 -->	\n	</td>\n	<td class=\"secondColumn\" valign=\"top\" align=\"left\">\n		<!-- begin position 2 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position2_loop>\r\n			<tmpl_if showAdmin>\r\n				<tr id=\"td<tmpl_var id>\">\r\n				<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n				</div></td>\r\n				</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n			</tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 2 -->	\n	</td>\n</tr>\n</table>\r\n\r\n<tmpl_if showAdmin>\r\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\r\n	<tmpl_var dragger.init>\r\n</tmpl_if>\n','Layout',1,1,'PBtmpl00000000table135',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 50%;\r\n}\r\n\r\n.secondColumn {	\r\n	width:50%;\r\n}\r\n</style>\r\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\r\n\r\n<tmpl_if showAdmin>\r\n<p><tmpl_var controls></p>\r\n</tmpl_if>\r\n\r\n\r\n<tmpl_if displayTitle>\r\n  <h2><tmpl_var title></h2>\r\n</tmpl_if>\r\n\r\n<tmpl_if description>\r\n  <p><tmpl_var description></p>\r\n</tmpl_if>\r\n\n<table cellpadding=\"5\">\n<tr>\n	<td class=\"firstColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 1 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position1\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position1_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 1 -->	\n	</td>\n	<td class=\"secondColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 2 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position2\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position2_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 2 -->	\n	</td>	\n	<td class=\"thirdColumn\" align=\"left\" valign=\"top\">\n		<!-- begin position 3 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position3\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position3_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 3 -->	\n	</td>\n</tr>\n<tr>\n	<td align=\"left\" valign=\"top\" colspan=\"3\">\n		<!-- begin position 4 -->\r\n		<div class=\"layoutColumnPadding\">\r\n		<tmpl_if showAdmin>\r\n			<table border=\"0\" id=\"position4\" class=\"content\"><tbody>\r\n		</tmpl_if>\r\n\r\n		<tmpl_loop position4_loop>\r\n			<tmpl_if showAdmin>\r\n		            	<tr id=\"td<tmpl_var id>\">\r\n		            		<td><div id=\"td<tmpl_var id>_div\" class=\"dragable\">\r\n			</tmpl_if>\r\n\r\n			<div class=\"content\"><tmpl_var dragger.icon><tmpl_var content></div>\r\n\r\n			<tmpl_if showAdmin>\r\n		         			</div></td>\r\n		            	</tr>\r\n			</tmpl_if>\r\n		</tmpl_loop>\r\n\r\n		<tmpl_if showAdmin>\r\n		            </tbody></table>\r\n		</tmpl_if>\r\n		</div>\r\n		<!-- end position 4 -->	\n	</td>\n</tr>\n</table>\r\n\r\n<tmpl_if showAdmin>\r\n	<table><tr id=\"blank\" class=\"hidden\"><td><div><div class=\"empty\">&nbsp;</div></div></td></tr></table>\r\n            <tmpl_var dragger.init>\r\n</tmpl_if>\n','Layout',1,1,'PBtmpl00000000table118',1148579525,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 33%;\r\n}\r\n.secondColumn {\r\n    width: 33%;\r\n}\r\n.thirdColumn {\r\n	width: 33%;\r\n}\r\n</style>\r\n'),('<div><a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a></div>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n\n<tmpl_if badgeSelected>\n<table border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\">\n<tr>\n	<td style=\"width:50%;\" valign=\"top\">\n		<div class=\"badge\">\n			<tmpl_loop badgeHolderInfo_loop>\n			<h2><tmpl_var mainEventTitle><br /><tmpl_var firstName> <tmpl_var lastName></h2>\n\n			<!-- USER DATA -->\n			<div class=\"badgeContent\" style=\"background-color:#E5E5E5;\">\n				<table cellpadding=\"1\" cellspacing=\"3\" width=\"100%\" class=\"userData\">\n				<tbody>\n				<tr>\n					<td style=\"width:65px;\">&nbsp;Address</td>\n					<td class=\"data\">&nbsp;<tmpl_var address></td>\n				</tr>\n				<tr>\n					<td>&nbsp;City</td>\n					<td class=\"data\">&nbsp;<tmpl_var city></td>\n				</tr>\n				<tr>\n					<td>&nbsp;State</td>\n					<td class=\"data\">&nbsp;<tmpl_var state></td>\n				</tr>\n				<tr>\n					<td>&nbsp;ZIP</td>\n					<td class=\"data\">&nbsp;<tmpl_var zipCode></td>\n				</tr>\n				<tr>\n					<td>&nbsp;Phone</td>\n					<td class=\"data\">&nbsp;<tmpl_var phone></td>\n				</tr>\n				<tr>\n					<td>&nbsp;Country</td>				\n					<td class=\"data\">&nbsp;<tmpl_var country></td>\n				</tr>			\n				</tbody>\n				</table>\n			</tmpl_loop>\n			</div>\n			<!-- END USER DATA -->\n			\n			<!-- BADGE EVENT -->\n			<tmpl_loop eventsInBadge_loop>\n			<div class=\"badgeContent\">\n				<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n				<tbody>\n				\n				<tr>\n					<td style=\"width:43%;text-align:left;\"><tmpl_var title></td>\n					<td style=\"width:40%;text-align:right;\">^D(\"%W %Z\",<tmpl_var startDate>);</td>\n					<td style=\"width:17%;text-align:right;\"><tmpl_if removeEventFromBadge.url><a href=\"<tmpl_var removeEventFromBadge.url>\">Remove</a></tmpl_if></td>\n				</tr>\n				\n				</tbody>\n				</table>\n			</div>\n			</tmpl_loop>\n			<!-- END BADGE EVENT -->\n			\n\n			<!-- BADGE FOOTER -->\n			<div class=\"badgeFooter\">\n				<table cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n				<tbody>\n				<tr>\n					<td style=\"width:50%;\"><a href=\"<tmpl_var resetScratchCartUrl>\" style=\"float:left;\">Start Over</a></td>\n					<td style=\"width:50%;\"><a href=\"<tmpl_var continue.url>\" style=\"float:right;\">Add Contents to Cart</a></td>					\n				</tr>\n				</tbody>\n				</table>	\n			</div>\n			<!-- END BADGE FOOTER -->\n		</div>\n	</td>\n	<td style=\"width:50%;\" valign=\"top\">			\n			<tmpl_if cart.purchaseLoop>\n			<div class=\"cart\">\n				<h2>Shopping Cart</h2>\n				<tmpl_loop cart.purchaseLoop>\n				<div class=\"cartContent\">\n					<tmpl_var deleteIcon><tmpl_var editIcon> <tmpl_var purchase.mainEventTitle> <br />\n					<tmpl_loop registrantInfoLoop>\n					Name: <tmpl_var firstName> <tmpl_var lastName>\n					</tmpl_loop>\n					<br />Additional Price: $<tmpl_var newPrice> \n				</div>\n				</tmpl_loop>\n				<!-- OEOS -->\n				<div style=\"text-align:right;margin:0px;\">\n					<a href=\"<tmpl_var emptyCart.url>\">Empty Cart</a> &bull; <a href=\"<tmpl_var checkout.url>\">Checkout</a>\n				</div>\n			</div>\n			</tmpl_if>\n			<br />\n			<div class=\"eventSearch\">\n					<h2>Search Instructions</h2>\n			\n					<span style=\"font-style: italic; font-weight: bold\">Basic Search</span> - This is the events search screen. There is a basic search box which allows you to search by event number, event title, and event description.<br /><br />\n\n					<span style=\"font-style: italic; font-weight: bold\">Advanced Search</span> - Click on <span style=\"color: blue\">Advanced Search</span> and you will see a pull-down list appear in the search area. Select which event characteristic you would like to search by and then in the next drop-down box specify what type of search to do (equals, contains, is not, not like, starts with, ends with). Most searches will likely be \"<span style=\"font-style: italic;\">contains</span>.\"\n		</div>\n		<br />\n\n	</td>\n</tr>\n<tr>\n	<td colspan=\"2\">\n		<div class=\"eventSearch\">\n			<h2>Search</h2>\n			\n<script type=\"text/javascript\" src=\"<tmpl_var ems.wobject.dir>/script/dynamicForms.js\"></script>\n\n<script type=\"text/javascript\">\nfunction popUp(URL) {\nday = new Date();\nid = day.getTime();\neval(\"page\" + id + \" = window.open(URL, \'\" + id + \"\', \'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=0,width=500,height=500\')\");\n}\n\n   <tmpl_var search.filters.options>\n   var advanced = 0;\n   var filterCount = 0;\n\n	function setSelectValue(selObj,newValue) {\n		for (var i=0; i<selObj.options.length; i++) {\n			selObj.options[i].selected = (selObj.options[i].value==newValue)?true:false;\n		}\n	}\n	\n\n   function toggleTitle(obj) {\n      if (obj.checked) {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'inline\';\n	  } else {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'none\';\n	  }\n   }\n   \n   function openWin (url, name, param) {\n      var newwin = window.open(url, name, param);\n      newwin.focus();\n   }\n   \n   function buildFilterList() {\n      return \"Custom Filter\";\n   }\n   \n   function stripDelim(value,delim) {\n      value = value.replace(/delim/g,\"\");\n	  return value;\n   }\n\n	function unset(array, valueToUnset){\n		var output=new Array(0);\n		for(var i in array){\n			if(i==valueToUnset){continue;}\n			output[i]=array[i];\n		}\n		return output;\n	}\n</script>\n<div id=\"basicSearch\">\n<tmpl_var advSearch.formHeader>\n<table width=\"100%\" border=\"0\" cellpadding=\"1\" style=\"border-bottom:double gray 5px;border-top:solid gray 1px;margin-bottom:5px;margin-top:5px;\">\n   <tbody id=\"filterbody\">\n   <tr>\n      <td style=\"font-weight:bold;width:80px;\">Search Events:</td>\n	  <td><input name=\"searchKeywords\" /></td>\n   </tr>\n   \n   </tbody>\n</table>\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n<tr>\n	<td align=\"left\" valign=\"top\"><a href=\"javascript:void(addField())\">Advanced Search</a></td>\n	<td align=\"right\"><input type=\"submit\" name=\"filter\" id=\"filter_formId\" value=\"Display Results\" onclick=\"this.value=\'Please wait...\'\" /></td>\n</tr>\n</table>\n<!-- <tmpl_var search.formSubmit> -->\n<tmpl_var search.formFooter>\n</div>\n\n			\n		</div>\n	</td>\n</tr>\n<tr>\n	<td colspan=\"2\">\n		<tmpl_var sortForm.header>\n		<div class=\"EMS_searchFilter\">\n			<table width=\"100%\">\n			<tbody>\n			<tr>\n				<td style=\"width:150px;text-align:left;\"><i>Your search returned <tmpl_var numberOfSearchResults> results.</i></td>\n				<td>\n					<table>\n					<tbody>\n					<tr>\n						<td><tmpl_var sortForm.selectBox.label></td>\n						<td><tmpl_var sortForm.selectBox></td>\n						<td><tmpl_var sortForm.submit></td>\n					</tr>\n					</tbody>\n					</table>\n				</td>\n			</tr>\n			<tr>\n				<td colspan=\"2\" align=\"center\">\n					<div style=\"align: center;\">\n						<tmpl_var pagination.firstPage>&nbsp;&nbsp;<tmpl_var pagination.previousPage>&nbsp;&nbsp;<tmpl_var pagination.pageList.upTo20>&nbsp;&nbsp;<tmpl_var pagination.nextPage>&nbsp;&nbsp;<tmpl_var pagination.lastPage> of <tmpl_var pagination.pageCount>\n					</div>\n				</td>\n			</tr>\n			</tbody>\n			</table>\n		</div>\n		<tmpl_var sortForm.footer>\n		\n		<div class=\"eventList\">\n			<h2>Available Events</h2>\n		\n			<!-- EVENT -->			\n				<table cellpadding=\"2\" cellspacing=\"0\" border=\"0\" class=\"event\">\n				<tbody>\n				<tr>\n					<th>Event<br />Number</th>\n					<th>Event<br />Name</th>\n					<th>Start<br />Date</th>\n					<th>End<br />Date</th>\n					<th>Seats Left/<br />Available</th>\n					<th>Price</th>\n					<th>Add to Badge</th>\n				</tr>\n				<tmpl_loop events_loop>\n				<tr>\n					<td style=\"width:9%;white-space:nowrap\" class=\"left\">\n						<tmpl_if canManageEvents><tmpl_var manageToolbar>\n						<tmpl_unless eventIsApproved><span style=\"color:red;font-size:9pt;font-weight:bold;\">&bull; Not Approved</span><tmpl_else><span style=\"color:green;font-size:9pt;font-weight:bold;\">&bull; Approved</span></tmpl_unless></tmpl_if>\n					</td>\n					<td style=\"width:25%;\"><tmpl_var title></td>\n					<td style=\"width:14%;\">^D(\"%W %Z\",<tmpl_var startDate>);</td>\n					<td style=\"width:14%;\">^D(\"%W %Z\",<tmpl_var endDate>);</td>\n					<td style=\"width:14%;\"><tmpl_var seatsRemaining>/<tmpl_var maximumAttendees></td>\n					<td style=\"width:10%;\"><tmpl_var price></td>\n					<td style=\"width:14%;\" class=\"right\">\n						<tmpl_unless eventIsFull>\n							<a href=\"<tmpl_var purchase.url>\"><tmpl_var purchase.label></a>\n						<tmpl_else>\n							<tmpl_var purchase.label>\n						</tmpl_unless>\n					</td>\n				</tr>\n				</tmpl_loop>\n				</tbody>\n				</table>			\n			<!-- END EVENT -->\n		</div>	\n		<div class=\"EMS_searchFilter\" style=\"height:23px;\">\n			<table width=\"100%\">\n			<tbody>\n			<tr>\n				<td align=\"center\">\n					<div style=\"align: center;\">\n						<tmpl_var pagination.firstPage>&nbsp;&nbsp;<tmpl_var pagination.previousPage>&nbsp;&nbsp;<tmpl_var pagination.pageList.upTo20>&nbsp;&nbsp;<tmpl_var pagination.nextPage>&nbsp;&nbsp;<tmpl_var pagination.lastPage> of <tmpl_var pagination.pageCount>\n					</div>\n				</td>\n			</tr>\n			</tbody>\n			</table>\n		</div>\n		<br />\n	</div>\n	</td>\n</tr>\n</table>\n\n<tmpl_else>\n<ul>\n<tmpl_if canManageEvents>\n   <li><a href=\"<tmpl_var addEvent.url>\"><tmpl_var addEvent.label></a></li>\n   <li><a href=\"<tmpl_var manageRegistrants>\">Manage Registrants</a> (Event Directors and Staff)</li>\n   <li><a href=\"<tmpl_var manageEvents.url>\">Manage Events</a> (Event Directors and Staff)</li></tmpl_if>\n<tmpl_unless badgeSelected>\n   <li><a href=\"^PageUrl;\">Return To Badge List to begin a badge purchase</a></li></tmpl_unless>\n</ul>\n\n<tmpl_if badgeSelected>\n<div><a href=\"<tmpl_var resetScratchCartUrl>\">Click Here to add events to a badge you\'ve already purchased, or to select a different badge. (Start Over)</a></div><br /><br />\n<div><span class=\"StepLabel\">Step 2: </span><h2> Add Events to your Badge</h2></div>\n<tmpl_else>\n<div><span class=\"StepLabel\">Browse Events: </span> You have not selected a Badge.  You cannot add events to your cart until you select a badge.</div>\n</tmpl_if>\n<tmpl_var calendarJS>\n<tmpl_unless noSearchDialog>\n<script type=\"text/javascript\" src=\"<tmpl_var ems.wobject.dir>/script/dynamicForms.js\"></script>\n\n<script type=\"text/javascript\">\nfunction popUp(URL) {\nday = new Date();\nid = day.getTime();\neval(\"page\" + id + \" = window.open(URL, \'\" + id + \"\', \'toolbar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=0,width=500,height=500\')\");\n}\n\n   <tmpl_var search.filters.options>\n   var advanced = 0;\n   var filterCount = 0;\n\n	function setSelectValue(selObj,newValue) {\n		for (var i=0; i<selObj.options.length; i++) {\n			selObj.options[i].selected = (selObj.options[i].value==newValue)?true:false;\n		}\n	}\n	\n\n   function toggleTitle(obj) {\n      if (obj.checked) {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'inline\';\n	  } else {\n	     document.getElementById(\'cs_search_title_td\').style.display=\'none\';\n	  }\n   }\n   \n   function openWin (url, name, param) {\n      var newwin = window.open(url, name, param);\n      newwin.focus();\n   }\n   \n   function buildFilterList() {\n      return \"Custom Filter\";\n   }\n   \n   function stripDelim(value,delim) {\n      value = value.replace(/delim/g,\"\");\n	  return value;\n   }\n\n	function unset(array, valueToUnset){\n		var output=new Array(0);\n		for(var i in array){\n			if(i==valueToUnset){continue;}\n			output[i]=array[i];\n		}\n		return output;\n	}\n</script>\n\n<div id=\"basicSearch\">\n<tmpl_var advSearch.formHeader>\n<h2>How to Use the Events Search</h2>\n<p><span style=\"font-style: italic; font-weight: bold\">Basic Search</span> - This is the events search screen. There is a basic search box which allows you to search by event number, event title, and event description.\n\n<p><span style=\"font-style: italic; font-weight: bold\">Advanced Search</span> - Click on <span style=\"color: blue\">Advanced Search</span> and you will see a pull-down list appear in the search area. Select which event characteristic you would like to search by and then in the next drop-down box specify what type of search to do (equals, contains, is not, not like, starts with, ends with). Most searches will likely be \"<span style=\"font-style: italic;\">contains</span>.\"\n\n<table width=\"100%\" border=\"0\" cellpadding=\"1\" style=\"border-bottom:double gray 5px;border-top:solid gray 1px;margin-bottom:5px;margin-top:5px;\">\n   <tbody id=\"filterbody\">\n   <tr>\n      <td style=\"font-weight:bold;width:80px\">Search Events:</td>\n	  <td><input name=\"searchKeywords\" /></td>\n   </tr>\n   \n   </tbody>\n</table>\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n<tr>\n	<td align=\"left\" valign=\"top\"><a href=\"javascript:void(addField())\">Search By...</a></td>\n	<td align=\"right\"><input type=\"submit\" name=\"filter\" id=\"filter_formId\" value=\"Display Search Results\" onclick=\"this.value=\'Please wait...\'\" /></td>\n</tr>\n</table>\n<!-- <tmpl_var search.formSubmit> -->\n<tmpl_var search.formFooter>\n</div>\n</tmpl_unless><!-- noSearchDialog -->\n<br /><br />\n<tmpl_if badgeSelected>\n<tmpl_if continue.url><table><tr><td align=\"right\"><span class=\"StepLabel\">Go to Step 3:</span><a href=\"<tmpl_var continue.url>\">Add Badge and Events to Cart</a></td></tr><tr><td align=\"right\"><span class=\"StepLabel\">Go to Step 3:</span><a href=\"<tmpl_var checkoutNow.url>\">Add Badge and Events to Cart and Checkout</a></td></tr></table></tmpl_if>\n</tmpl_if>\n\n<p><tmpl_var message></p>\n<tmpl_if badgeSelected>\n<p>Of the events you may add to this badge, your search returned <tmpl_var numberOfSearchResults> results.</p>\n<tmpl_else>\n<p>Your search returned <tmpl_var numberOfSearchResults> results.</p>\n</tmpl_if>\n\n<p><tmpl_var addToBadgeMessage></p>\n<div style=\"text-align: center;\"><tmpl_var pagination.firstPage>&nbsp;&nbsp;<tmpl_var pagination.previousPage>&nbsp;&nbsp;<tmpl_var pagination.pageList.upTo20>&nbsp;&nbsp;<tmpl_var pagination.nextPage>&nbsp;&nbsp;<tmpl_var pagination.lastPage> of <tmpl_var pagination.pageCount></div><br />\n\n<!-- Sort Form -->\n<div style=\"align: right;\">\n<tmpl_var sortForm.header>\n<tmpl_var sortForm.selectBox.label>&nbsp;\n<tmpl_var sortForm.selectBox>\n<tmpl_var sortForm.submit>\n<tmpl_var sortForm.footer>\n</div>\n\n<table width=\"100%\" border=\"0\" cellpadding=\"8\" cellspacing=\"0\" style=\"border-top:solid gray 2px;border-bottom:solid gray 2px;\">\n<tr>\n<th>Event #</th>\n<th><tmpl_var name.label></th>\n<th><tmpl_var starts.label></th>\n<th><tmpl_var ends.label></th>\n<th>Seats<br />(Available/Max)</th>\n<th><tmpl_var price.label></th>\n<tmpl_if badgeSelected>\n<th>Add to Cart</th></tmpl_if>\n</tr>\n<tmpl_loop events_loop>\n  <tr<tmpl_unless __ODD__> class=\"oddRow\"<tmpl_else> class=\"evenRow\"</tmpl_unless>>\n\n  <td style=\"white-space:nowrap;\">\n    <tmpl_if canManageEvents><tmpl_var manageToolbar>\n        <tmpl_unless eventIsApproved><span style=\"color:red;font-size:9pt;font-weight:bold;\">&bull; Not Approved</span><tmpl_else><span style=\"color:green;font-size:9pt;font-weight:bold;\">&bull; Approved</span></tmpl_unless></tmpl_if>\n  </td><td><tmpl_var title>\n  </td><td>^D(\"%W %Z\",<tmpl_var startDate>);\n  </td><td>^D(\"%W %Z\",<tmpl_var endDate>);\n  </td><td style=\"text-align: center;\"><tmpl_var seatsRemaining>/<tmpl_var maximumAttendees>\n  </td><td><tmpl_var price>\n  </td><tmpl_if badgeSelected>\n    <td style=\"text-align: center;\">\n      <tmpl_if canManageEvents>\n		<tmpl_unless eventIsFull>\n			<a href=\"<tmpl_var purchase.url>\"><tmpl_var purchase.label></a>\n		<tmpl_else>\n			<tmpl_var purchase.label>\n		</tmpl_unless>\n      </tmpl_if>\n  </td>\n    </tmpl_if></tr>\n</tmpl_loop>\n\n</table>\n\n<div style=\"text-align: center;\"><tmpl_var pagination.firstPage>&nbsp;&nbsp;<tmpl_var pagination.previousPage>&nbsp;&nbsp;<tmpl_var pagination.pageList.upTo20>&nbsp;&nbsp;<tmpl_var pagination.nextPage>&nbsp;&nbsp;<tmpl_var pagination.lastPage> of <tmpl_var pagination.pageCount></div>\n\n\n\n</tmpl_if>\n','EventManagementSystem_search',1,1,'EventManagerTmpl000006',1149286278,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\n\ntr.oddRow td {\n	background-color:#DADADA;\n	border-right:solid gray 1px;\n}\ntr.evenRow td {\n	background-color:#E8E8E8;\n	border-right:solid gray 1px;\n}\n.manageEvents {\n	margin-top:5px;\n	margin-bottom:5px;\n}\n.datacardtitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:13px;\n}\n\n.leftnav{\n	padding: 1px 1px 1px 1px;\n	background: white;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.leftnavon{\n	padding: 1px 1px 1px 1px;\n	background: yellow;\n	color: black;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n	border: 2px #3D5690 ridge;\n}\n.calendartitle {\n	background: #3D5690;\n	color: white;\n	font-family: verdana;\n	font-weight: bold;\n	font-size:11px;\n}\n.filter-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 105px;\n}\n.compare-select {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 76px;\n}\n.filter-text {\n	font-family: verdana;\n	font-size: 10px;\n	font-weight: normal;\n	color: black;\n	width: 114px;\n}\n.smLink {\n   font-family: verdana;\n   font-size: 10px;\n   font-weight: normal;\n   color: blue;\n}\n\n.StepLabel { font-family: Tahoma; font-size: 14pt; letter-spacing: 2pt; color: #234E9C; \n               font-weight: bold }\n\n/* BADGE CSS */\n		.badge {\n			width:92%;\n			background-color:#F0F0F0;\n			-moz-border-radius:15px;\n			padding:5px;	\n			-moz-box-sizing:border-box;\n			font-family:verdana;\n			font-size:9pt;\n		}\n		.badge h2 {\n			width:100%;\n			font-size:12.5pt;\n			background-color:#E2E2E2;\n			text-align:center;\n			-moz-border-radius-topLeft:15px;\n			-moz-border-radius-topRight:15px;\n			margin:0px;\n			border:solid #E0E0E0 1px;\n			padding:5px;\n			-moz-box-sizing:border-box;			\n			color:gray;			\n		}\n		.badgeContent {\n			width:100%;\n			background-color:#F4F4F4;			\n			margin:0px;\n			margin-top:5px;\n			margin-bottom:5px;\n			border:solid #E0E0E0 1px;\n			padding:5px;\n			-moz-box-sizing:border-box;			\n			font-family:verdana;\n			font-size:9pt;\n		}\n		.badgeContent a {\n			background-color:#CF1D1D;\n			padding:5px;			\n			color:white;\n			border:solid #9C1616 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n			width:40px;\n			font-size:7pt;\n			float:right;\n			margin-left:10px;\n		}\n		.badgeContent a:hover {\n			background-color:#9C1616;\n			color:#CF1D1D;\n			color:white;		\n		}		\n		.badgeFooter {\n			width:100%;\n			background-color:#E2E2E2;			\n			-moz-border-radius-bottomLeft:15px;\n			-moz-border-radius-bottomRight:15px;\n			margin:0px;			\n			border:solid #E0E0E0 1px;\n			padding:5px;\n			-moz-box-sizing:border-box;				\n			text-align:center;\n		}\n		.badgeFooter a {				\n			\n			background-color:#E2E2E2;\n			padding:5px;			\n			color:gray;\n			border:solid #F4F4F4 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n		}\n		.badgeFooter a:hover {\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n		.userData td {\n			background-color:#E2E2E2;\n			font-size:7pt;\n			-moz-border-radius:15px;\n			border:solid #F4F4F4 1px;\n			font-weight:bold;\n			\n		}\n		.userData td.data {\n			background-color:#F4F4F4;\n			border:solid #E2E2E2 1px;\n			font-weight:normal;\n		}	\n		/* END OF BADGE CSS */\n		\n		\n		\n		/* EVENT LIST CSS */\n		.eventList, .eventSearch {\n			width:95%;\n			border:solid #F0F0F0 1px;\n			padding:2px;\n			-moz-border-radius-topLeft:15px;\n			-moz-border-radius-topRight:15px;	\n			font-family:verdana;\n			font-size:9pt;\n		}\n		.eventList h2, .eventSearch h2 {\n			margin:0px;\n			width:100%;\n			font-family:verdana;\n			text-align:center;\n			font-size:11pt;\n			background-color: #F0F0F0;\n			color:gray;\n			-moz-border-radius-topLeft:15px;\n			-moz-border-radius-topRight:15px;\n			-moz-box-sizing:border-box;			\n		}\n		.eventList {	\n			width:98%;\n			border:solid #E0E0E0 1px;			\n			font-size:9pt;\n			font-family:verdana;\n			/*background-color:#F4F4F4;*/\n			margin-top:2px;\n			-moz-box-sizing:border-box;\n			padding-bottom:25px;\n			-moz-border-radius-bottomLeft:15px;\n			-moz-border-radius-bottomRight:15px;									\n		}\n		.event {\n			width:100%;						\n			font-size:9pt;\n			font-family:verdana;\n			background-color:#F4F4F4;\n			margin-top:2px;\n			-moz-box-sizing:border-box;			\n		}\n		.event td {\n			border-top:solid #E0E0E0 1px;\n			border-bottom:solid #E0E0E0 1px;\n			text-align:center;\n		}\n		.event th {\n			font-size:8pt;\n			text-align:center;\n			background:white;\n		}\n		.event td.left {\n			border-left:solid #E0E0E0 1px;\n		}\n		.event td.right {\n			border-right:solid #E0E0E0 1px;\n		}	\n		.event td.empty {\n			background-color:white;\n			border-style:none;\n			font-size:1px;\n		}\n		.event a {\n			background-color:#E2E2E2;\n			padding:5px;			\n			color:gray;\n			border:solid #F4F4F4 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;		\n			width:80%;\n		}\n		.event a:hover {\n			border: solid #E2E2E2 1px;\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n		/* END EVENT LIST CSS */\n		\n		\n		/* INSTRUCTIONS */\n		.instructions {\n			width:95%;\n			border:solid #F0F0F0 1px;\n			padding:5px;\n			-moz-border-radius-topLeft:15px;\n			-moz-border-radius-topRight:15px;	\n			font-family:verdana;\n			font-size:9pt;\n		}\n		/* END INSTRUCTIONS */\n\n		\n		/* SEARCH */\n		.eventSearch form {\n			margin:0px;\n		}\n		.eventSearch .searchBtn {\n			background-color:#E2E2E2;			\n			color:gray;\n			padding-top:1px;\n			padding-bottom:1px;\n			border:solid #F4F4F4 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;		\n		}\n		.searchBtn:hover {\n			border: solid #E2E2E2 1px;\n			background-color:#F0F0F0;\n			color:gray;		\n		}\n		.advSearch input, .advSearch select{\n			font-size:8pt;\n		}\n		.advSearch .button {\n			background-color:#CF1D1D;\n			padding-left:2px;			\n			padding-right:2px;			\n			color:white;\n			border:solid #9C1616 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n			width:30px;\n			font-size:10pt;			\n			margin-left:10px;	\n			height:100%;\n		}\n		.advSearch .button:hover {\n			background-color:#9C1616;\n			color:#CF1D1D;\n			color:white;		\n		}\n		.advSearch .compare-select {\n			width:75px;\n		}		\n		.advSearch .filter-text {\n			width:98%;\n		}\n		* html .advSearch .filter-text {\n			width:97%;\n		}\n		.advSearch tr.border td {\n			font-size:1pt;\n			background-color:#CFCFCF;\n		}\n		/* END SEARCH */\n/* cart CSS */\n		.cart {\n			width:95%;\n			background-color:#F0F0F0;\n			-moz-border-radius:15px;\n			padding:5px;	\n			-moz-box-sizing:border-box;\n			font-family:verdana;\n			font-size:9pt;\n		}\n		.cart h2 {\n			width:100%;\n			font-size:12.5pt;\n			background-color:#E2E2E2;\n			text-align:center;\n			-moz-border-radius-topLeft:15px;\n			-moz-border-radius-topRight:15px;\n			margin:0px;\n			border:solid #E0E0E0 1px;			\n			-moz-box-sizing:border-box;			\n			color:gray;			\n		}\n		.cartContent {\n			width:100%;\n			background-color:#F4F4F4;			\n			margin:0px;\n			margin-top:5px;\n			margin-bottom:5px;\n			border:solid #E0E0E0 1px;\n			padding:5px;\n			-moz-box-sizing:border-box;			\n			font-family:verdana;\n			font-size:9pt;\n		}\n		.cartContent a {\n			background-color:#CF1D1D;\n			padding:5px;			\n			color:white;\n			border:solid #9C1616 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n			width:40px;\n			font-size:7pt;\n			float:right;\n			margin-left:10px;\n		}\n		.cartContent a:hover {\n			background-color:#9C1616;\n			color:#CF1D1D;\n			color:white;		\n		}		\n		.cartFooter {\n			width:100%;\n			background-color:#E2E2E2;			\n			-moz-border-radius-bottomLeft:15px;\n			-moz-border-radius-bottomRight:15px;\n			margin:0px;			\n			border:solid #E0E0E0 1px;\n			padding:5px;\n			-moz-box-sizing:border-box;				\n			text-align:center;\n		}\n		.cartFooter a {				\n			\n			background-color:#E2E2E2;\n			padding:5px;			\n			color:gray;\n			border:solid #F4F4F4 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n		}\n		.cartFooter a:hover {\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n		/* END OF cart CSS */\n\n/* SEARCH FILTER (Sort By)*/\n		.EMS_searchFilter {	\n			width:98%;\n			border:solid #E0E0E0 1px;			\n			font-size:9pt;\n			font-family:verdana;			\n			margin-top:2px;\n			-moz-box-sizing:border-box;			\n			background-color:#E2E2E2;\n			-moz-border-radius:15px;			\n			color:#808080;\n			height:58px;\n		}		\n		.EMS_searchFilter table {\n			float:right;\n			margin-right:5px;\n		}\n		.EMS_searchFilter td, .EMS_searchFilter select {\n			font-size:8pt;\n		}\n		.EMS_searchFilter input {				\n			background-color:#E2E2E2;\n			padding:5px;			\n			color:gray;\n			border:solid #F4F4F4 1px;\n			text-decoration:none;\n			font-weight:bold;						\n			text-align:center;\n			-moz-border-radius:10px;\n			display:block;\n		}\n		.EMS_searchFilter input:hover {\n			background-color:#F0F0F0;\n			color:gray;\n		}		\n		/* END SEARCH FILTER */\n</style>\n\n<link href=\"^Extras;/calendar/calendar-win2k-1.css\" rel=\"stylesheet\" type=\"text/css\" />\n'),('<div class=\"badge\" style=\"width:100%\"> \r\n	<table cellpadding=\"3\" cellspacing=\"0\" style=\"width:100%\">\r\n	<tr>\r\n		<td class=\"description\" valign=\"top\">\r\n			<h2 class=\"title\"><tmpl_var title></h2>\n			<tmpl_var description>\r\n		</td>\n		<td rowspan=\"2\" style=\"width:115px;align:center;\" valign=\"top\">\n			<h2 class=\"price\"><tmpl_var price></h2>\n			\n			<a href=\"<tmpl_var title.url>\">Search Eligible Events</a><br />\r\n			<tmpl_if canManageEvents>\r\n				<a title=\"Begin a Badge Purchase\" style=\"cursor:pointer;\" href=\"<tmpl_var purchase.url>\">ADMIN Purchase</a>\r\n			<tmpl_else>\r\n				<tmpl_unless eventIsFull>\r\n					<a title=\"Begin a Badge Purchase\" style=\"cursor:pointer;\" href=\"<tmpl_var purchase.url>\">Purchase</a>\r\n				<tmpl_else>\r\n					&nbsp;<br />\r\n				</tmpl_unless>\r\n			</tmpl_if>  			\n		</td>\r\n	</tr>\r\n	</table>\r\n</div>\n','EventManagementSystem_product',1,1,'EventManagerTmpl000002',1149286278,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\r\n\r\ntr.oddRow td {\r\n	background-color:#DADADA;\r\n	border-right:solid gray 1px;\r\n}\r\ntr.evenRow td {\r\n	background-color:#E8E8E8;\r\n	border-right:solid gray 1px;\r\n}\r\n.manageEvents {\r\n	margin-top:5px;\r\n	margin-bottom:5px;\r\n}\r\n.datacardtitle {\r\n	background: #3D5690;\r\n	color: white;\r\n	font-family: verdana;\r\n	font-weight: bold;\r\n	font-size:13px;\r\n}\r\n\r\n.leftnav{\r\n	padding: 1px 1px 1px 1px;\r\n	background: white;\r\n	color: black;\r\n	font-family: verdana;\r\n	font-weight: bold;\r\n	font-size:11px;\r\n	border: 2px #3D5690 ridge;\r\n}\r\n.leftnavon{\r\n	padding: 1px 1px 1px 1px;\r\n	background: yellow;\r\n	color: black;\r\n	font-family: verdana;\r\n	font-weight: bold;\r\n	font-size:11px;\r\n	border: 2px #3D5690 ridge;\r\n}\r\n.calendartitle {\r\n	background: #3D5690;\r\n	color: white;\r\n	font-family: verdana;\r\n	font-weight: bold;\r\n	font-size:11px;\r\n}\r\n.filter-select {\r\n	font-family: verdana;\r\n	font-size: 10px;\r\n	font-weight: normal;\r\n	color: black;\r\n	width: 105px;\r\n}\r\n.compare-select {\r\n	font-family: verdana;\r\n	font-size: 10px;\r\n	font-weight: normal;\r\n	color: black;\r\n	width: 76px;\r\n}\r\n.filter-text {\r\n	font-family: verdana;\r\n	font-size: 10px;\r\n	font-weight: normal;\r\n	color: black;\r\n	width: 114px;\r\n}\r\n.smLink {\r\n   font-family: verdana;\r\n   font-size: 10px;\r\n   font-weight: normal;\r\n   color: blue;\r\n}\r\n\r\n.StepLabel { font-family: Tahoma; font-size: 14pt; letter-spacing: 2pt; color: #234E9C; \r\n               font-weight: bold }\r\n\r\n/* BADGE CSS */\r\n		.badge {\r\n			width:92%;\r\n			background-color:#F0F0F0;\r\n			-moz-border-radius:15px;\r\n			padding:5px;	\r\n			-moz-box-sizing:border-box;\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		.badge h2.title {\r\n			font-size:12.5pt;\r\n			background-color:#E2E2E2;\r\n			text-align:center;\r\n			-moz-border-radius-topLeft:15px;			\r\n			margin:0px;\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n			color:gray;	\n			margin-bottom:4px;\r\n		}\n		.badge h2.price {\n			font-size:12.5pt;			\r\n			text-align:center;\r\n			-moz-border-radius-topRight:15px;			\r\n			margin:0px;\r\n			border:solid #E2E2E2 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n			color:gray;	\n			margin-bottom:4px;\n		}\r\n		.badgeContent {\r\n			background-color:#F4F4F4;			\r\n			margin:0px;\r\n			margin-top:5px;\r\n			margin-bottom:5px;\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		.badgeContent a, .badge a {\r\n			width:100px;\r\n			background-color:#E2E2E2;\r\n			padding:5px;			\r\n			color:gray;\r\n			border:solid silver 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;\r\n			font-size:7pt;\r\n			margin-left:10px;\r\n		}\r\n		.badgeContent a:hover, .badge a:hover {\r\n			background-color:#F0F0F0;\r\n			border-color:#E2E2E2;\r\n		}			\r\n		.badgeFooter {\r\n			width:100%;\r\n			background-color:#E2E2E2;			\r\n			-moz-border-radius-bottomLeft:15px;\r\n			-moz-border-radius-bottomRight:15px;\r\n			margin:0px;			\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;	\r\n			box-sizing:border-box;			\r\n			text-align:center;\r\n		}\r\n		.badgeFooter a {				\r\n			\r\n			background-color:#E2E2E2;\r\n			padding:5px;			\r\n			color:gray;\r\n			border:solid #F4F4F4 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;\r\n		}\r\n		.badgeFooter a:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n		.userData td {\r\n			background-color:#E2E2E2;\r\n			font-size:7pt;\r\n			-moz-border-radius:15px;\r\n			border:solid #F4F4F4 1px;\r\n			font-weight:bold;\r\n			\r\n		}\r\n		.userData td.data {\r\n			background-color:#F4F4F4;\r\n			border:solid #E2E2E2 1px;\r\n			font-weight:normal;\r\n		}	\r\n		/* END OF BADGE CSS */\r\n		\r\n		\r\n		\r\n		/* EVENT LIST CSS */\r\n		.eventList, .eventSearch {\r\n			border:solid #F0F0F0 1px;\r\n			padding:2px;\r\n			-moz-border-radius-topLeft:15px;\r\n			-moz-border-radius-topRight:15px;	\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		.eventList h2, .eventSearch h2 {\r\n			margin:0px;\r\n			font-family:verdana;\r\n			text-align:center;\r\n			font-size:12pt;\r\n			background-color: #F0F0F0;\r\n			color:black;\r\n			-moz-border-radius-topLeft:15px;\r\n			-moz-border-radius-topRight:15px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;						\r\n		}\r\n		.eventList {	\r\n			width:98%;\r\n			border:solid #E0E0E0 1px;			\r\n			font-size:9pt;\r\n			font-family:verdana;\r\n			/*background-color:#F4F4F4;*/\r\n			margin-top:2px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n		}\r\n		.event {			\r\n			font-size:9pt;\r\n			font-family:verdana;\r\n			background-color:#F4F4F4;\r\n			margin-top:2px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;		\r\n		}\r\n		.event td {\r\n			border-top:solid #E0E0E0 1px;\r\n			border-bottom:solid #E0E0E0 1px;\r\n			text-align:center;\r\n		}\r\n		.event th {\r\n			font-size:8pt;\r\n			text-align:center;\r\n			background:white;\r\n		}\r\n		.event td.left {\r\n			border-left:solid #E0E0E0 1px;\r\n		}\r\n		.event td.right {\r\n			border-right:solid #E0E0E0 1px;\r\n		}	\r\n		.event td.empty {\r\n			background-color:white;\r\n			border-style:none;\r\n			font-size:1px;\r\n		}\r\n		.event a {\r\n			background-color:#E2E2E2;\r\n			padding:5px;			\r\n			color:gray;\r\n			border:solid #F4F4F4 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;		\r\n			width:80%;\r\n		}\r\n		.event a:hover {\r\n			border: solid #E2E2E2 1px;\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n		/* END EVENT LIST CSS */\r\n		\r\n		\r\n		/* INSTRUCTIONS */\r\n		.instructions {\r\n			width:95%;\r\n			border:solid #F0F0F0 1px;\r\n			padding:5px;\r\n			-moz-border-radius-topLeft:15px;\r\n			-moz-border-radius-topRight:15px;	\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		/* END INSTRUCTIONS */\r\n\r\n		\r\n		/* SEARCH */\r\n		.eventSearch form {\r\n			margin:0px;\r\n		}\r\n		.eventSearch .searchBtn {\r\n			background-color:#E2E2E2;			\r\n			color:gray;\r\n			padding-top:1px;\r\n			padding-bottom:1px;\r\n			border:solid #F4F4F4 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;		\r\n		}\r\n		.searchBtn:hover {\r\n			border: solid #E2E2E2 1px;\r\n			background-color:#F0F0F0;\r\n			color:gray;		\r\n		}\r\n		.advSearch input, .advSearch select{\r\n			font-size:8pt;\r\n		}\r\n		.advSearch .button {\r\n			background-color:#CF1D1D;\r\n			padding-left:2px;			\r\n			padding-right:2px;			\r\n			color:white;\r\n			border:solid #9C1616 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;\r\n			width:30px;\r\n			font-size:10pt;			\r\n			margin-left:10px;	\r\n			height:100%;\r\n		}\r\n		.advSearch .button:hover {\r\n			background-color:#9C1616;\r\n			color:#CF1D1D;\r\n			color:white;		\r\n		}\r\n		.advSearch .compare-select {\r\n			width:75px;\r\n		}		\r\n		.advSearch .filter-text {\r\n			width:98%;\r\n		}\r\n		* html .advSearch .filter-text {\r\n			width:97%;\r\n		}\r\n		.advSearch tr.border td {\r\n			font-size:1pt;\r\n			background-color:#CFCFCF;\r\n		}\r\n		/* END SEARCH */\r\n/* cart CSS */\r\n		.cart {\r\n			width:92%;\r\n			background-color:#F0F0F0;\r\n			-moz-border-radius:15px;\r\n			padding:5px;	\r\n			-moz-box-sizing:border-box;\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		.cart h2 {\r\n			width:100%;\r\n			font-size:12.5pt;\r\n			background-color:#E2E2E2;\r\n			text-align:center;\r\n			-moz-border-radius-topLeft:15px;\r\n			-moz-border-radius-topRight:15px;\r\n			margin:0px;\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n			color:gray;			\r\n		}\r\n		.cartContent {\r\n			width:100%;\r\n			background-color:#F4F4F4;			\r\n			margin:0px;\r\n			margin-top:5px;\r\n			margin-bottom:5px;\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;\r\n			box-sizing:border-box;\r\n			font-family:verdana;\r\n			font-size:9pt;\r\n		}\r\n		.cartContent a {\r\n			background-color:#CF1D1D;\r\n			padding:5px;			\r\n			color:white;\r\n			border:solid #9C1616 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;\r\n			width:40px;\r\n			font-size:7pt;\r\n			float:right;\r\n			margin-left:10px;\r\n		}\r\n		.cartContent a:hover {\r\n			background-color:#9C1616;\r\n			color:#CF1D1D;\r\n			color:white;		\r\n		}		\r\n		.cartFooter {\r\n			width:100%;\r\n			background-color:#E2E2E2;			\r\n			-moz-border-radius-bottomLeft:15px;\r\n			-moz-border-radius-bottomRight:15px;\r\n			margin:0px;			\r\n			border:solid #E0E0E0 1px;\r\n			padding:5px;\r\n			-moz-box-sizing:border-box;	\r\n			box-sizing:border-box;			\r\n			text-align:center;\r\n		}\r\n		.cartFooter a {				\r\n			\r\n			background-color:#E2E2E2;\r\n			padding:5px;			\r\n			color:gray;\r\n			border:solid #F4F4F4 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;						\r\n			text-align:center;\r\n			-moz-border-radius:10px;\r\n			display:block;\r\n		}\r\n		.cartFooter a:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n		/* END OF cart CSS */\r\n\r\n</style>\r\n\r\n<link href=\"^Extras;/calendar/calendar-win2k-1.css\" rel=\"stylesheet\" type=\"text/css\" />'),('<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<h2><tmpl_var managePurchasesTitle></h2>\n<table width=\"100%\" cellspacing=\"2\" cellpadding=\"2\" class=\"EMS_purchase\">\n<tr class=\"header\">\n	<td><tmpl_var purchaseId.label></td>\n	<td><tmpl_var datePurchasedHuman.label></td>\n</tr>\n<tmpl_if purchasesLoop>\n	<tmpl_loop purchasesLoop>\n	<tr<tmpl_unless __ODD__> class=\"evenRow\"<tmpl_else> class=\"oddRow\"</tmpl_unless>>\n		<td>&nbsp;<a href=\"<tmpl_var purchaseUrl>\"><tmpl_var purchaseId></a></td>\n		<td>&nbsp;<tmpl_var datePurchasedHuman></td>\n	</tr>\n	</tmpl_loop>\n<tmpl_else>\n<tr>\n	<td><tmpl_var noPurchasesMessage></td>\n</tr>\n</tmpl_if>\n</table>\n','EventManagementSystem_managePurchas',1,1,'EventManagerTmpl000004',1149286278,'WebGUI::Asset::Template::HTMLTemplate','<style type=\"text/css\">\ntr.oddRow td {\n	background-color:#FFF;	\n}\ntr.evenRow td {\n	background-color:#DADADA;	\n}\n.EMS_purchase {\n	font-size:9pt;\n	font-family:arial;\n	border:solid #E0E0E0 1px;\n	color:black;\n}\n.EMS_purchase tr.header td {\n	background-color:#E2E2E2;\n	color:#808080;\n	font-size:10pt;\n	font-weight:bold;\n}\n</style>\n'),('<script>\nfunction confirmDelete(url) {\nif(confirm(\"Are you sure you wish to delete ALL registrations tied to this purchaseId?\")) {\nlocation.href=url;\n}\n}\n</script>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p><br /><br />\n</tmpl_if>\n<h2><tmpl_var viewPurchaseTitle></h2>\n\n<tmpl_if canReturn><tmpl_if canReturnTransaction>\n	<div style=\"text-align:right;\">\n		(<a href=\"<tmpl_var appUrl>?func=returnItem;tid=<tmpl_var transactionId>\">Return Entire Purchase</a>)\n	</div>\n</tmpl_if></tmpl_if>\n\n<tmpl_loop purchasesLoop>\n<table width=\"100%\" border=\"0\" class=\"v