<?php
/**
 * $Horde: chora/stats.php,v 1.26.8.5 2009/01/06 15:22:34 jan Exp $
 *
 * Copyright 2000-2009 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 *
 * @author  Anil Madhavapeddy <avsm@horde.org>
 */

@define('CHORA_BASE', dirname(__FILE__));
require_once CHORA_BASE . '/lib/base.php';

$fl = &$VC->getFileObject($where, $cache);
Chora::checkError($fl);

$extraLink = Chora::getFileViews();

$author_stats = array();
foreach ($fl->logs as $lg) {
    @$author_stats[$lg->queryAuthor()]++;
}
arsort($author_stats);

$title = sprintf(_("Statistics for %s"), Text::htmlallspaces($where));
Horde::addScriptFile('prototype.js', 'chora', true);
Horde::addScriptFile('tables.js', 'chora', true);
require CHORA_TEMPLATES . '/common-header.inc';
require CHORA_TEMPLATES . '/menu.inc';
require CHORA_TEMPLATES . '/headerbar.inc';
require CHORA_TEMPLATES . '/stats/stats.inc';
require $registry->get('templates', 'horde') . '/common-footer.inc';
