/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GroupFigure;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public class GroupAction
extends AbstractSelectedAction {
    public static final String ID = "edit.groupSelection";
    private CompositeFigure prototype;
    private boolean isGroupingAction;

    public GroupAction(DrawingEditor drawingEditor) {
        this(drawingEditor, new GroupFigure(), true);
    }

    public GroupAction(DrawingEditor drawingEditor, CompositeFigure compositeFigure) {
        this(drawingEditor, compositeFigure, true);
    }

    public GroupAction(DrawingEditor drawingEditor, CompositeFigure compositeFigure, boolean bl) {
        super(drawingEditor);
        this.prototype = compositeFigure;
        this.isGroupingAction = bl;
        this.labels.configureAction(this, ID);
        this.updateEnabledState();
    }

    @Override
    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.isGroupingAction ? this.canGroup() : this.canUngroup());
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canGroup() {
        return this.getView() != null && this.getView().getSelectionCount() > 1;
    }

    protected boolean canUngroup() {
        return this.getView() != null && this.getView().getSelectionCount() == 1 && this.prototype != null && this.getView().getSelectedFigures().iterator().next().getClass().equals(this.prototype.getClass());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isGroupingAction) {
            if (this.canGroup()) {
                final DrawingView drawingView = this.getView();
                final LinkedList<Figure> linkedList = new LinkedList<Figure>(drawingView.getSelectedFigures());
                final CompositeFigure compositeFigure = (CompositeFigure)this.prototype.clone();
                AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        return GroupAction.this.labels.getString("edit.groupSelection.text");
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        GroupAction.this.groupFigures(drawingView, compositeFigure, linkedList);
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        GroupAction.this.ungroupFigures(drawingView, compositeFigure);
                        super.undo();
                    }

                    @Override
                    public boolean addEdit(UndoableEdit undoableEdit) {
                        return super.addEdit(undoableEdit);
                    }
                };
                this.groupFigures(drawingView, compositeFigure, linkedList);
                this.fireUndoableEditHappened(abstractUndoableEdit);
            }
        } else if (this.canUngroup()) {
            final DrawingView drawingView = this.getView();
            final CompositeFigure compositeFigure = (CompositeFigure)this.getView().getSelectedFigures().iterator().next();
            final LinkedList<Figure> linkedList = new LinkedList<Figure>();
            AbstractUndoableEdit abstractUndoableEdit = new AbstractUndoableEdit(){

                @Override
                public String getPresentationName() {
                    return GroupAction.this.labels.getString("edit.ungroupSelection.text");
                }

                @Override
                public void redo() throws CannotRedoException {
                    super.redo();
                    GroupAction.this.ungroupFigures(drawingView, compositeFigure);
                }

                @Override
                public void undo() throws CannotUndoException {
                    GroupAction.this.groupFigures(drawingView, compositeFigure, linkedList);
                    super.undo();
                }
            };
            linkedList.addAll(this.ungroupFigures(drawingView, compositeFigure));
            this.fireUndoableEditHappened(abstractUndoableEdit);
        }
    }

    public Collection<Figure> ungroupFigures(DrawingView drawingView, CompositeFigure compositeFigure) {
        LinkedList<Figure> linkedList = new LinkedList<Figure>(compositeFigure.getChildren());
        drawingView.clearSelection();
        compositeFigure.basicRemoveAllChildren();
        drawingView.getDrawing().basicAddAll(drawingView.getDrawing().indexOf(compositeFigure), linkedList);
        drawingView.getDrawing().remove(compositeFigure);
        drawingView.addToSelection(linkedList);
        return linkedList;
    }

    public void groupFigures(DrawingView drawingView, CompositeFigure compositeFigure, Collection<Figure> collection) {
        List<Figure> list = drawingView.getDrawing().sort(collection);
        int n = drawingView.getDrawing().indexOf((Figure)list.iterator().next());
        drawingView.getDrawing().basicRemoveAll(collection);
        drawingView.clearSelection();
        drawingView.getDrawing().add(n, compositeFigure);
        compositeFigure.willChange();
        for (Figure figure : list) {
            figure.willChange();
            compositeFigure.basicAdd(figure);
        }
        compositeFigure.changed();
        drawingView.addToSelection(compositeFigure);
    }
}

