/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.datatransfer.ImageTransferable;
import org.jhotdraw.io.ExtensionFileFilter;

public class ImageOutputFormat
implements OutputFormat {
    private String description;
    private String fileExtension;
    private String formatName;
    private int imageType;

    public ImageOutputFormat() {
        this("PNG", "Portable Network Graphics (PNG)", "png", 2);
    }

    public ImageOutputFormat(String string, String string2, String string3, int n) {
        this.formatName = string;
        this.description = string2;
        this.fileExtension = string3;
        this.imageType = n;
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, Drawing drawing) throws IOException {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            this.write(filterOutputStream, drawing);
        }
        finally {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
        }
    }

    @Override
    public void write(OutputStream outputStream, Drawing drawing) throws IOException {
        this.write(outputStream, drawing, drawing.getChildren(), null, null);
    }

    public void write(OutputStream outputStream, Drawing drawing, AffineTransform affineTransform, Dimension dimension) throws IOException {
        this.write(outputStream, drawing, drawing.getChildren(), affineTransform, dimension);
    }

    @Override
    public Transferable createTransferable(Drawing drawing, List<Figure> list, double d) throws IOException {
        return new ImageTransferable(this.toImage(drawing, list, d, true));
    }

    public void write(OutputStream outputStream, Drawing drawing, List<Figure> list) throws IOException {
        this.write(outputStream, drawing, list, null, null);
    }

    public void write(OutputStream outputStream, Drawing drawing, List<Figure> list, AffineTransform affineTransform, Dimension dimension) throws IOException {
        BufferedImage bufferedImage = affineTransform == null || dimension == null ? this.toImage(drawing, list, 1.0, false) : this.toImage(drawing, list, affineTransform, dimension);
        ImageIO.write((RenderedImage)bufferedImage, this.formatName, outputStream);
        bufferedImage.flush();
    }

    public BufferedImage toImage(Drawing drawing, List<Figure> list, double d, boolean bl) {
        Object object;
        Rectangle2D.Double double_ = null;
        for (Figure figure : list) {
            if (double_ == null) {
                double_ = figure.getDrawingArea();
                continue;
            }
            double_.add(figure.getDrawingArea());
        }
        if (bl) {
            object = new AffineTransform();
            ((AffineTransform)object).translate(-double_.x * d, -double_.y * d);
            ((AffineTransform)object).scale(d, d);
            return this.toImage(drawing, list, (AffineTransform)object, new Dimension((int)(double_.width * d), (int)(double_.height * d)));
        }
        object = new AffineTransform();
        if (double_.x < 0.0) {
            ((AffineTransform)object).translate(-double_.x * d, 0.0);
        }
        if (double_.y < 0.0) {
            ((AffineTransform)object).translate(0.0, -double_.y * d);
        }
        ((AffineTransform)object).scale(d, d);
        return this.toImage(drawing, list, (AffineTransform)object, new Dimension((int)((Math.max(0.0, double_.x) + double_.width) * d), (int)((Math.max(0.0, double_.y) + double_.height) * d)));
    }

    public BufferedImage toImage(Drawing drawing, List<Figure> list, AffineTransform affineTransform, Dimension dimension) {
        Color color = drawing.get(AttributeKeys.CANVAS_FILL_COLOR);
        double d = drawing.get(AttributeKeys.CANVAS_FILL_OPACITY);
        color = color == null ? new Color(255, 255, 255, 0) : new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * d));
        Object object = new BufferedImage(Math.max(1, dimension.width), Math.max(1, dimension.height), color.getAlpha() == 255 ? 1 : 2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(2));
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight());
        graphics2D.setComposite(composite);
        this.setRenderingHints(graphics2D);
        graphics2D.transform(affineTransform);
        for (Figure figure : list) {
            figure.draw(graphics2D);
        }
        graphics2D.dispose();
        if (this.imageType != 2) {
            BufferedImage bufferedImage = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), this.imageType);
            graphics2D = bufferedImage.createGraphics();
            this.setRenderingHints(graphics2D);
            graphics2D.setComposite(AlphaComposite.getInstance(2));
            graphics2D.drawImage((Image)object, 0, 0, null);
            graphics2D.dispose();
            ((Image)object).flush();
            object = bufferedImage;
        }
        return object;
    }

    protected void setRenderingHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }
}

