##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# http://www.morningstarsecurity.com/research/whatweb
##
Plugin.define "SHOUTcast-Administrator" do
author "Brendan Coles <bcoles@gmail.com>" # 2010-07-03
version "0.1"
description "homepage: http://www.shoutcast.com/"
examples %w|
100.m2radio.fr:8000
128relay1.gothmetal.net:6666
160.79.128.30:7702
192.87.65.59:8200
192.mp3.streams.lsw.evo.hard.fm:8000
193.247.162.45:8080
194.158.114.67:5000
195.151.242.137:8300
195.207.8.205:8020
195.68.152.190:9000
204.12.66.71:8240
204.189.82.10:8000
205.188.215.225:8022
205.188.215.227:8100
205.188.215.230:8012
205.188.215.230:8024
205.188.215.232:8016
207.200.96.225:8010
207.200.96.225:8010
207.200.96.228:8076
207.200.96.229:8030
207.200.96.231:8014
208.111.166.34:8000
208.76.152.74:8000
209.247.146.100:8000
209.247.146.98:8000
209.247.146.98:8000
209.51.161.54:8070
209.51.162.163:2020
212.40.13.22:11000
213.186.41.149:8040
213.251.170.124:9000
213.251.190.165
216.246.51.221
38.117.92.74:8008
38.96.148.19:8300
64.22.115.194:8020
64.62.252.134:3142
64.62.252.134:5100
64.62.252.136:3142
64.62.252.136:5100
64.71.184.99:8010
65.60.11.2:8217
65.60.19.42:8130
65.60.19.42
66.103.27.11:14800
66.197.215.39:8203
66.220.3.52:8035
66.224.103.98:680
66.225.205.4
72.1.140.202:8000
72.26.204.18:6314
74.63.47.82:8300
77.89.128.83:8001
81.88.37.2:8010
81.88.37.2:8030
82.134.68.36:7999
82.197.167.140
87.117.193.142:9728
87.117.193.142:9814
87.117.193.143:9484
87.98.216.140
88.191.102.29:7204
88.191.38.140:8002
88.191.69.43:6104
88.191.69.43:7814
91.121.202.186
91.121.62.121:8130
91.121.62.121:9500
95.211.21.70:4600
animenexus.net:8000
antenaradio.org:4560
aol-relay2.chuckeh.com:8026
aol.streams.bassdrive.com:8012
aol.streams.bassdrive.com:8012
ayeko.com:8000
beton.topstream.net:19558
breakz.us:8000
bruce.springsteenradio.com:9000
cameroonvoice.com:1748
commersant.ge:8000
cozumel.cozumelnetworks.com:8000
crossfader.net:8000
ct5.fast-serv.com:8786
ct5.fast-serv.com:8996
ct5.fast-serv.com:8996
deepeyeradio.com:8034
ecuastream.com:9020
ecuastream.com:9022
edge31.proradiostreaming.com
elfen.com:8000
ffiles.com:8000
fidestarija.serverroom.us:9406
firewall.pulsradio.org
freeradio.streamforyou.info:8084
go2id.net:8000
golden-apple.com:680
gold.neostreams.info:12254
gospelidea.com:9155
gwr.ubk.com:8000
h2kradio.com:8000
hank.koqx.com:8000
heartbeatz.fm:8008
hi.death.fm
hosting5plus.com:8025
hotmixradio80.hotmixradio.com
hu.ah.fm:9010
ibiza.broadstreamer.com:8700
iriefm.net:8760
isdn.tb-stream.net
jbstream.net:8044
jphip.com:8800
komplex2.psyradio.org:8030
krakra.net:4711
live275.com:8006
live2.streamhosting.ch:8040
live.eliberadio.ro:8002
live.gospeliway.com:8022
live.nsbradio.co.uk:8900
live.str3am.com:2010
live.streamhosting.ch:8010
live.zeilsteen.com
lvscanner.no-ip.org:8000
maglaj.net:8000
maliweb.primcast.com:7168
mbs-sa.org:8000
mediastream.my-its.com:9300
media.virtualdj.com:8000
media.yamc.info:443
microeffect.purestream.net:9680
mobile.streamhosting.ch:8042
mp3stream.wfmu.org
mp3stream.wfmu.org:8004
mp3uplink.duplexfx.com:8008
mp3-vr-128.smgradio.com
mp4.97fm.com.br
nashe-radio.com:8000
newstalk.serverroom.us:8354
nl2.ah.fm:9000
nl3.ah.fm:443
ns24907.ovh.net:8000
ns362672.ovh.net:8000
peace.str3am.com:6030
peace.str3am.com:6380
pillar-tunez.com:8002
pink-fm.net:8020
pink-fm.net:8030
pink-fm.net:8050
radiobash.com:8070
radiobash.com:8200
radio.bigupradio.com:8000
radio.classicalarchives.com:8002
radiocommando.com:9004
radiodashuria.com:8000
radio-dzair.net:8000
radio-dzair.net:8006
radio-dzair.net:8008
radio-dzair.net:8012
radio-gusinje.com:8100
radiolatina.info:8482
radiolatina.info:8763
radiolatina.info:9456
radioloyola.serverroom.us:9460
radio.networx-bg.com:8002
radio.nolife-radio.com:8000
radio.radiodardania.com:4000
radios-online.info:3110
radios-online.info:7010
rc.vc:8000
rs1.radiostreamer.com:8080
rs1.radiostreamer.com:8270
rs3.radiostreamer.com:8030
rs4.radiostreamer.com:8370
rs4.radiostreamer.com:8460
rts.fm:8128
rustradio.org:8000
s2.byblosnights.com:6626
s2.myradiostream.com:32754
s2.myradiostream.com:34142
s5.viastreaming.net:7070
s5.viastreaming.net:7150
s6.secondstreams.com:6614
s6.viastreaming.net:7020
s9.viastreaming.net:7330
sams.serverroom.us:5374
sc10.spacialnet.com:24594
sc1-fmt.spacialnet.com:25032
sc1.netstreamer.net:8008
sc1.netstreamer.net:8010
sc1.netstreamer.net:8100
sc1.streamfox.com:8000
sc2.radiocaroline.net:8000
sc3.radiocaroline.net:8030
sc3.radiocaroline.net:8030
sc4.radiocaroline.net:8020
sc5.audiorealm.com:11222
sc5.audiorealm.com:12190
sc5.radioseven.se:8002
sc6.mystreamserver.com:8086
sc8.spacialnet.com:19858
sensimedia.net:8004
sensimedia.net:8004
serv1.beatbasement.com:9622
sfsound.org:8000
sgpc.net:8000
shout2a.gnax.net:5112
shoutcast.dvsoft.org:9008
shoutcastlive.com:8106
shoutcast.omroep.nl:8056
shoutcastunlimited.com:8122
sjrail.no-ip.com:8000
ss3.shoutzone.net:8753
st1.webradioworld.net:8258
steady.somafm.com:8000
steady.somafm.com:8386
steady.somafm.com:8500
stillstream.com:8000
stream101.com:10222
stream101.com:40044
stream2.teknoradio.nl:8124
stream.bollywoodmusicradio.com
stream.electroradio.ch:26630
streamer.psyradio.org:8010
stream.greekradios.gr:2000
stream.greekradios.gr:2016
streaming.planetwideradio.com:8050
streamingpulse.com:8018
streamingpulse.net:8068
streamingrd.com:8999
streamingvip.net:8032
streampanel.biz:8080
streamprinc.musichitzfm.com:8000
stream.pro-fm.net:8250
stream.radiosai.net:8000
stream.radiosai.net:8002
stream.radiosai.net:8006
streams.bigvibez.com:7000
stream.teknoradio.nl:8064
stream.uzic.ch:9010
sun.inlive.co.kr:7000
swifthost.net:8050
swiss1.impek.tv
tatarica.com:8000
theworldnetradio.com:8700
theworldnetradio.com:8704
theworldnetradio.com:8714
theworldnetradio.com:8720
threetenradio.com:8041
trance.uberguilds.org:8128
tristar-whq.net:8000
tropical.wavestreamer.com:8529
tspigot.net:8000
tv12.stream-music.net:8106
tv13.stream-music.net:8012
uplink.duplexfx.com:8014
us.ah.fm:9000
voxsc1.somafm.com:8500
whfr.primcast.com:4184
win1.duamp3.net:8000
www.ameinfo.com:8000
www.andradahosting.com:8018
www.atlanticalliance.org
www.azevedo.ca:8000
www.beatlesradio.com:8088
www.beatlesradio.com:8888
www.clawfinger.net:8000
www.club-lounge-radio.com:8888
www.cwu.edu:8810
www.datafluid.com:8000
www.destroyer.net:8800
www.eastvillageradio.com:8010
www.ecuastream.com:9034
www.ecuastream.com:9044
www.eliteclub10.com:8080
www.epiphanyradio.org:8000
www.googig.com:8000
www.hotgoth.net:8005
www.jungletrain.net:8000
www.kurdland.eu:8881
www.lamegaonline.com:8008
www.magnatune.com:8000
www.mirayafm.org:8080
www.mjmtropical.net:8010
www.partyvibe.com:8000
www.qtlabs.biz:8042
www.rcgoldserver.eu:8253
www.rcgoldserver.eu:8319
www.shoutcastunlimited.com:8144
www.smokin-media.com:8024
www.studiopiu.net:8000
www.subflow.net:8000
www.subflow.net:8010
www.trancemission.fm:6660
xltrax.com:8000
xltrax.com:8140
yage.net:9000
|

matches [

# about 27,000 results for intitle:"SHOUTcast Administrator" @ 2010-07-02
{:text=>'<title>SHOUTcast Administrator</title>' },

{:regexp=>/<tr><td><font class=ltv>Written by Stephen 'Tag Loomis, Tom Pepper and Justin Frankel<\/font><\/td><\/tr><\/table><\/td><\/tr><tr><td nowrap colspan=5 align=center><font class=ST><b><a href="http:\/\/www.shoutcast.com\/disclaimer.phtml">Copyright Nullsoft Inc<\/a>[<a href="\/llamacookie">.<\/a>]* 1998-[0-9]{4}<\/b><\/font><\/td><\/tr><\/table><\/font><\/body><\/html>/ },

]

def passive
        m=[]

        if @body =~ /<tr><td height=14 align=right><font class=ltv><a id=ltv href="http:\/\/www.shoutcast.com\/">SHOUTcast Server Version [0-9a-zA-Z\-\.\/\\_]+<\/a><\/font><\/td><\/tr>/
                version=@body.scan(/<tr><td height=14 align=right><font class=ltv><a id=ltv href="http:\/\/www.shoutcast.com\/">SHOUTcast Server Version ([0-9a-zA-Z\-\.\/\\_]+)<\/a><\/font><\/td><\/tr>/)[0][0]
                m << {:version=>version}
        end

        m

end

end

