# Announce: Rakudo Star Release 2013.05

## A useful, usable, "early adopter" distribution of Perl 6

On behalf of the Rakudo and Perl 6 development teams, I'm happy to
announce the May 2013 release of "Rakudo Star", a useful and usable
distribution of Perl 6. The tarball for the May 2013 release is
available from <http://rakudo.org/downloads/star/>. A Windows .MSI
version of Rakudo star will usually appear in the downloads area
shortly after the tarball release.

In the Perl 6 world, we make a distinction between the language
("Perl 6") and specific implementations of the language such as
"Rakudo Perl".  This Star release includes [release 2013.05] of the
[Rakudo Perl 6 compiler], version 5.2.0 of the [Parrot Virtual
Machine], plus various modules, documentation, and other resources
collected from the Perl 6 community.

[release 2013.05]:
    https://github.com/rakudo/rakudo/blob/nom/docs/announce/2013.05.md
[Rakudo Perl 6 compiler]: http://github.com/rakudo/rakudo
[Parrot Virtual Machine]: http://parrot.org

Some of the new features added to this release include:

* The ?-quantifier on regex captures now returns a single Match object 
  (formerly returned an array).  Use `** 0..1` to get the old behavior.
* Failed matches return Nil instead of a false Match object.
* Rakudo warns when pure expressions are used in sink context
* .substr(...) now correctly accepts whatever-star closures
* Implemented shellwords postcircumfix (%h<< $x 'foo bar' >>)
* Defining operators spelled like the empty string is now illegal
* Array interpolations now properly do LTM
* Autothread "none" and "all" junctions before "any" and "one"
* Helpful error if you write "else if"/"elif" instead of "elsif"
* Throw exception if a Range is used as a Range endpoint
* Corrected argument order in IO.seek
* wrap low level VM objects in ForeignCode, allowing perl6 OO calls on them
* for loops are eager again
* add link and symlink to IO
* add Capture.Bool()
* improvements to DUMP()
* various optimizations in the optimizer and the runtime
* smartmatch against list now supports Whatever wildcards
* IO::Spec, a port of Perl 5's File::Spec
* regex special characters can be used as delimiters
* allow slice with :exists adverb on hashes
* added 125 extra opening/closing bracket-pairs

This release also contains a range of bug fixes, improvements to error
reporting and better failure modes.

The following features have been deprecated or modified from previous
releases due to changes in the Perl 6 specification, and are planned
to be removed or changed as follows:

  * `postcircumfix:<[ ]>` and `postcircumfix:<{ }>` will become
    multi-subs rather than multi-methods. Both at_pos and at_key will
    remain methods.

  * Unary hyper ops currently descend into nested arrays and hashes.
    This will change to make them equivalent to a one-level map.

  * The Str.ucfirst builtin is deprecated; it will be replaced by
    Str.tc.

  * Leading whitespace in rules and under :sigspace will no longer be
    converted to `<.ws>`.  For existing regexes that expect this
    conversion, add a `<?>` in front of leading whitespace to make it
    meta again.

  * The result of failed matches will be Nil instead of a Match
    object returning boolean False.

There are some key features of Perl 6 that Rakudo Star does not yet
handle appropriately, although they will appear in upcoming releases.
Some of the not-quite-there features include:

  * advanced macros
  * threads and concurrency
  * Unicode strings at levels other than codepoints
  * interactive readline that understands Unicode
  * non-blocking I/O
  * much of Synopsis 9

There is an online resource at <http://perl6.org/compilers/features>
that lists the known implemented and missing features of Rakudo and
other Perl 6 implementations.

In many places we've tried to make Rakudo smart enough to inform the
programmer that a given feature isn't implemented, but there are many
that we've missed.  Bug reports about missing and broken features are
welcomed at <rakudobug@perl.org>.

See <http://perl6.org/> for links to much more information about
Perl 6, including documentation, example code, tutorials, reference
materials, specification documents, and other supporting resources.  A
draft of a Perl 6 book is available as docs/UsingPerl6-draft.pdf in
the release tarball.

The development team thanks all of the contributors and sponsors for
making Rakudo Star possible.  If you would like to contribute, see
<http://rakudo.org/how-to-help>, ask on the <perl6-compiler@perl.org>
mailing list, or join us on IRC \#perl6 on freenode.
