/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.grammarcommon.AbstractPythonGrammar;
import org.python.pydev.parser.grammarcommon.IJJTPythonGrammarState;
import org.python.pydev.parser.grammarcommon.ITreeBuilder;
import org.python.pydev.parser.grammarcommon.IntStack;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JJTPythonGrammarState
implements IJJTPythonGrammarState {
    protected final FastStack<SimpleNode> nodes;
    protected final IntStack marks;
    protected final IntStack lines;
    protected final IntStack columns;
    protected int sp;
    protected int mk;
    protected boolean node_created;
    public final ITreeBuilder builder;
    private final AbstractPythonGrammar grammar;

    public JJTPythonGrammarState(Class<?> treeBuilderClass, AbstractPythonGrammar grammar) {
        this.grammar = grammar;
        this.nodes = new FastStack();
        this.marks = new IntStack();
        this.lines = new IntStack();
        this.columns = new IntStack();
        this.sp = 0;
        this.mk = 0;
        try {
            Constructor<?> constructor = treeBuilderClass.getConstructor(ClassLiteral.getClass((String)"org/python/pydev/parser/grammarcommon/JJTPythonGrammarState"));
            this.builder = (ITreeBuilder)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public AbstractPythonGrammar getGrammar() {
        return this.grammar;
    }

    @Override
    public final SimpleNode getLastOpened() {
        return this.builder.getLastOpened();
    }

    public boolean nodeCreated() {
        return this.node_created;
    }

    public void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    public Node rootNode() {
        return (Node)this.nodes.getFirst();
    }

    public void pushNode(SimpleNode n) {
        this.nodes.push((Object)n);
        ++this.sp;
    }

    public SimpleNode popNode() {
        if (--this.sp < this.mk) {
            this.clearMark();
        }
        return (SimpleNode)this.nodes.pop();
    }

    @Override
    public SimpleNode peekNode() {
        return (SimpleNode)this.nodes.peek();
    }

    public SimpleNode peekNode(int i) {
        return (SimpleNode)this.nodes.peek(i);
    }

    public int nodeArity() {
        return this.sp - this.mk;
    }

    @Override
    public void pushNodePos(int line, int col) {
        this.lines.push(line);
        this.columns.push(col);
    }

    @Override
    public SimpleNode setNodePos() {
        SimpleNode n = this.peekNode();
        int popLine = this.lines.pop();
        if (n.beginLine == 0) {
            n.beginLine = popLine;
        }
        int popCol = this.columns.pop();
        if (n.beginColumn == 0) {
            n.beginColumn = popCol;
        }
        return n;
    }

    public void clearNodeScope(Node n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.clearMark();
    }

    public void openNodeScope(Node n) {
        this.marks.push(this.mk);
        this.mk = this.sp;
    }

    public void closeNodeScope(Node n, int num) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        this.clearMark();
        SimpleNode newNode = null;
        try {
            newNode = this.builder.closeNode(sn, num);
        }
        catch (ParseException exc) {
            throw exc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new ParseException(new StringBuffer("Internal error:").append(exc).toString());
        }
        if (newNode == null) {
            throw new ParseException("Internal AST builder error");
        }
        this.pushNode(newNode);
        this.node_created = true;
    }

    public void closeNodeScope(Node n, boolean condition) throws ParseException {
        SimpleNode sn = (SimpleNode)n;
        if (condition) {
            SimpleNode newNode = null;
            try {
                newNode = this.builder.closeNode(sn, this.nodeArity());
            }
            catch (ParseException exc) {
                throw exc;
            }
            catch (ClassCastException exc) {
                if (PyParser.DEBUG_SHOW_PARSE_ERRORS) {
                    exc.printStackTrace();
                }
                throw new ParseException(new StringBuffer("Internal error:").append(exc).toString(), sn);
            }
            catch (Exception exc) {
                if (PyParser.DEBUG_SHOW_PARSE_ERRORS) {
                    exc.printStackTrace();
                }
                throw new ParseException(new StringBuffer("Internal error:").append(exc).toString(), sn);
            }
            if (newNode == null) {
                throw new ParseException(new StringBuffer("Internal AST builder error when closing node:").append(sn).toString());
            }
            this.clearMark();
            this.pushNode(newNode);
            this.node_created = true;
        } else {
            this.clearMark();
            this.node_created = false;
        }
    }

    private void clearMark() {
        this.mk = this.marks.size() > 0 ? this.marks.pop() : 0;
    }

    public boolean lastIsNewScope() {
        int size = this.columns.size();
        if (size > 1) {
            return this.columns.elementAt(size - 1) <= this.columns.elementAt(size - 2);
        }
        return true;
    }
}

