/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterInfo
implements IInterpreterInfo {
    private static String[] LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS = new String[]{"django"};
    public volatile String executableOrJar;
    public final List<String> libs = new ArrayList<String>();
    private final Set<String> forcedLibs = new TreeSet<String>();
    private String[] builtinsCache;
    private ISystemModulesManager modulesManager;
    public static ICallback<Boolean, Tuple<List<String>, List<String>>> configurePathsCallback = null;
    private final String version;
    private String[] envVariables;
    private String name;

    public String getExecutableOrJar() {
        return this.executableOrJar;
    }

    public void setModulesManager(ISystemModulesManager modulesManager) {
        modulesManager.setInfo((Object)this);
        this.modulesManager = modulesManager;
    }

    public ISystemModulesManager getModulesManager() {
        return this.modulesManager;
    }

    public List<String> getPythonPath() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.libs);
        return ret;
    }

    public InterpreterInfo(String version, String exe, Collection<String> libs0) {
        this.executableOrJar = exe;
        this.version = version;
        this.setModulesManager(new SystemModulesManager());
        this.libs.addAll(libs0);
    }

    public InterpreterInfo(String version, String exe, Collection<String> libs0, Collection<String> dlls) {
        this(version, exe, libs0);
    }

    public InterpreterInfo(String version, String exe, List<String> libs0, List<String> dlls, List<String> forced) {
        this(version, exe, libs0, dlls, forced, null);
    }

    public InterpreterInfo(String version, String exe, List<String> libs0, List<String> dlls, List<String> forced, List<String> envVars) {
        this(version, exe, libs0, dlls);
        for (String s : forced) {
            if (this.isForcedLibToIgnore(s)) continue;
            this.forcedLibs.add(s);
        }
        if (envVars == null) {
            this.setEnvVariables(null);
        } else {
            this.setEnvVariables(envVars.toArray(new String[envVars.size()]));
        }
        this.builtinsCache = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InterpreterInfo)) {
            return false;
        }
        InterpreterInfo info = (InterpreterInfo)o;
        if (!info.executableOrJar.equals(this.executableOrJar)) {
            return false;
        }
        if (!info.libs.equals(this.libs)) {
            return false;
        }
        if (!info.forcedLibs.equals(this.forcedLibs)) {
            return false;
        }
        if (this.envVariables != null) {
            if (info.envVariables == null) {
                return false;
            }
            if (!Arrays.equals(this.envVariables, info.envVariables)) {
                return false;
            }
        } else if (info.envVariables != null) {
            return false;
        }
        return true;
    }

    public static InterpreterInfo fromString(String received) {
        return InterpreterInfo.fromString(received, true);
    }

    public static InterpreterInfo fromString(String received, boolean askUserInOutPath) {
        int endNameIndex;
        if (received.toLowerCase().indexOf("executable") == -1) {
            throw new RuntimeException(new StringBuffer("Unable to recreate the Interpreter info (Its format changed. Please, re-create your Interpreter information).Contents found:").append(received).toString());
        }
        received = received.replaceAll("\n", "").replaceAll("\r", "");
        String name = null;
        if (received.startsWith("Name:") && (endNameIndex = received.indexOf(":EndName:")) != -1) {
            name = received.substring("Name:".length(), endNameIndex);
            received = received.substring(endNameIndex + ":EndName:".length());
        }
        Tuple envVarsSplit = StringUtils.splitOnFirst((String)received, (char)'^');
        Tuple forcedSplit = StringUtils.splitOnFirst((String)((String)envVarsSplit.o1), (char)'$');
        Tuple libsSplit = StringUtils.splitOnFirst((String)((String)forcedSplit.o1), (char)'@');
        String exeAndLibs = (String)libsSplit.o1;
        String version = "2.4";
        String[] exeAndLibs1 = exeAndLibs.split("\\|");
        String exeAndVersion = exeAndLibs1[0];
        String lowerExeAndVersion = exeAndVersion.toLowerCase();
        if (lowerExeAndVersion.startsWith("version")) {
            int execut = lowerExeAndVersion.indexOf("executable");
            version = exeAndVersion.substring(0, execut).substring(7);
            exeAndVersion = exeAndVersion.substring(7 + version.length());
        }
        String executable = exeAndVersion.substring(exeAndVersion.indexOf(":") + 1, exeAndVersion.length());
        final ArrayList<String> l = new ArrayList<String>();
        final ArrayList<String> toAsk = new ArrayList<String>();
        int i = 1;
        while (i < exeAndLibs1.length) {
            String trimmed = exeAndLibs1[i].trim();
            if (trimmed.length() > 0) {
                if (trimmed.endsWith("OUT_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                    }
                } else if (trimmed.endsWith("INS_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                        l.add(trimmed);
                    } else {
                        l.add(trimmed);
                    }
                } else {
                    l.add(trimmed);
                }
            }
            ++i;
        }
        final Boolean[] result = new Boolean[]{Autobox.valueOf((boolean)true)};
        if (ProjectModulesManager.IN_TESTS) {
            if (configurePathsCallback != null) {
                configurePathsCallback.call((Object)new Tuple(toAsk, l));
            }
        } else if (toAsk.size() > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ListSelectionDialog dialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)toAsk, new IStructuredContentProvider(){

                        public Object[] getElements(Object inputElement) {
                            List elements = (List)inputElement;
                            return elements.toArray(new String[0]);
                        }

                        public void dispose() {
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }
                    }, new ILabelProvider(){

                        public Image getImage(Object element) {
                            return PydevPlugin.getImageCache().get("icons/jar_l_obj.gif");
                        }

                        public String getText(Object element) {
                            return element.toString();
                        }

                        public void addListener(ILabelProviderListener listener) {
                        }

                        public void dispose() {
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return true;
                        }

                        public void removeListener(ILabelProviderListener listener) {
                        }
                    }, "Select the folders to be added to the SYSTEM pythonpath!\n\nIMPORTANT: The folders for your PROJECTS should NOT be added here, but in your project configuration.\n\nCheck:http://fabioz.com/pydev/manual_101_interpreter.html for more details.");
                    dialog.setInitialSelections((Object[])l.toArray(new String[0]));
                    int i = dialog.open();
                    if (i == 0) {
                        result[0] = Autobox.valueOf((boolean)true);
                        Object[] result2 = dialog.getResult();
                        l.clear();
                        Object[] objectArray = result2;
                        int n = result2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object string = objectArray[n2];
                            l.add((String)string);
                            ++n2;
                        }
                    } else {
                        result[0] = Autobox.valueOf((boolean)false);
                    }
                }
            };
            try {
                RunInUiThread.sync((Runnable)runnable);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        if (!result[0].booleanValue()) {
            return null;
        }
        ArrayList<String> l1 = new ArrayList<String>();
        if (((String)libsSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)libsSplit, l1);
        }
        ArrayList<String> l2 = new ArrayList<String>();
        if (((String)forcedSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)forcedSplit, l2);
        }
        ArrayList<String> l3 = new ArrayList<String>();
        if (((String)envVarsSplit.o2).length() > 1) {
            InterpreterInfo.fillList((Tuple<String, String>)envVarsSplit, l3);
        }
        InterpreterInfo info = new InterpreterInfo(version, executable, l, l1, l2, l3);
        info.setName(name);
        return info;
    }

    private static void fillList(Tuple<String, String> forcedSplit, ArrayList<String> l2) {
        String forcedLibs = (String)forcedSplit.o2;
        for (String trimmed : StringUtils.splitAndRemoveEmptyTrimmed((String)forcedLibs, (char)'|')) {
            if ((trimmed = trimmed.trim()).length() <= 0) continue;
            l2.add(trimmed);
        }
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        if (this.name != null) {
            buffer.append("Name:");
            buffer.append(this.name);
            buffer.append(":EndName:");
        }
        buffer.append("Version");
        buffer.append(this.version);
        buffer.append("Executable:");
        buffer.append(this.executableOrJar);
        Iterator<String> iter = this.libs.iterator();
        while (iter.hasNext()) {
            buffer.append("|");
            buffer.append(iter.next().toString());
        }
        buffer.append("@");
        buffer.append("$");
        if (this.forcedLibs.size() > 0) {
            iter = this.forcedLibs.iterator();
            while (iter.hasNext()) {
                buffer.append("|");
                buffer.append(iter.next().toString());
            }
        }
        if (this.envVariables != null) {
            buffer.append("^");
            String[] stringArray = this.envVariables;
            int n = this.envVariables.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                buffer.append(s);
                buffer.append("|");
                ++n2;
            }
        }
        return buffer.toString();
    }

    public void restoreCompiledLibs(IProgressMonitor monitor) {
        this.forcedLibs.add("os");
        this.forcedLibs.add("os.path");
        if (this.version.startsWith("2") || this.version.startsWith("1")) {
            this.forcedLibs.add("__builtin__");
        }
        this.forcedLibs.add("sys");
        this.forcedLibs.add("email");
        if (this.isJythonInfo()) {
            this.forcedLibs.add("StringIO");
            this.forcedLibs.add("re");
        } else {
            this.forcedLibs.add("OpenGL");
            this.forcedLibs.add("wxPython");
            this.forcedLibs.add("wx");
        }
        this.builtinsCache = null;
    }

    public void restorePythonpath(String path, IProgressMonitor monitor) {
        this.getModulesManager().changePythonPath(path, null, monitor);
    }

    public void restorePythonpath(IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer();
        for (String folder : this.libs) {
            buffer.append(folder);
            buffer.append("|");
        }
        this.restorePythonpath(buffer.toString(), monitor);
    }

    public boolean isJythonInfo() {
        return InterpreterInfo.isJythonExecutable(this.executableOrJar);
    }

    public static boolean isJythonExecutable(String executable) {
        if (executable.endsWith("\"")) {
            return executable.endsWith(".jar\"");
        }
        return executable.endsWith(".jar");
    }

    public String getExeAsFileSystemValidPath() {
        char[] invalidChars = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
        String systemValid = new String(REF.encodeBase64((byte[])this.executableOrJar.getBytes()));
        char[] cArray = invalidChars;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            systemValid = systemValid.replace(c, '_');
            ++n2;
        }
        return systemValid;
    }

    public String getVersion() {
        return this.version;
    }

    public int getGrammarVersion() {
        return PythonNature.getGrammarVersionFromStr(this.version);
    }

    public String[] getBuiltins() {
        if (this.builtinsCache == null) {
            this.builtinsCache = this.forcedLibs.toArray(new String[0]);
        }
        return this.builtinsCache;
    }

    public void addForcedLib(String forcedLib) {
        if (this.isForcedLibToIgnore(forcedLib)) {
            return;
        }
        this.forcedLibs.add(forcedLib);
        this.builtinsCache = null;
    }

    private boolean isForcedLibToIgnore(String forcedLib) {
        if (forcedLib == null) {
            return true;
        }
        String[] stringArray = LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS;
        int n = LIBRARIES_TO_IGNORE_AS_FORCED_BUILTINS.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (forcedLib.equals(s) || forcedLib.startsWith(new StringBuffer(String.valueOf(s)).append(".").toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeForcedLib(String forcedLib) {
        this.forcedLibs.remove(forcedLib);
        this.builtinsCache = null;
    }

    public Iterator<String> forcedLibsIterator() {
        return this.forcedLibs.iterator();
    }

    public void setEnvVariables(String[] env) {
        if (env != null) {
            ArrayList<String> lst = new ArrayList<String>();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Tuple sp = StringUtils.splitOnFirst((String)s, (char)'=');
                if (((String)sp.o1).length() != 0 && ((String)sp.o2).length() != 0 && !InterpreterInfo.checkIfPythonPathEnvVarAndWarnIfIs((String)sp.o1)) {
                    lst.add(s);
                }
                ++n2;
            }
            Collections.sort(lst);
            env = lst.toArray(new String[lst.size()]);
        }
        if (env != null && env.length == 0) {
            env = null;
        }
        this.envVariables = env;
    }

    public String[] getEnvVariables() {
        return this.envVariables;
    }

    public String[] updateEnv(String[] env) {
        return this.updateEnv(env, null);
    }

    public String[] updateEnv(String[] env, Set<String> keysThatShouldNotBeUpdated) {
        if (this.envVariables == null || this.envVariables.length == 0) {
            return env;
        }
        if (env == null || env.length == 0) {
            return this.envVariables;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        InterpreterInfo.fillMapWithEnv(env, hashMap);
        InterpreterInfo.fillMapWithEnv(this.envVariables, hashMap, keysThatShouldNotBeUpdated);
        String[] ret = InterpreterInfo.createEnvWithMap(hashMap);
        return ret;
    }

    public static String[] createEnvWithMap(Map<String, String> hashMap) {
        Set<Map.Entry<String, String>> entrySet = hashMap.entrySet();
        String[] ret = new String[entrySet.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            ret[i] = new StringBuffer(String.valueOf(entry.getKey())).append("=").append(entry.getValue()).toString();
            ++i;
        }
        return ret;
    }

    public static void fillMapWithEnv(String[] env, HashMap<String, String> hashMap) {
        InterpreterInfo.fillMapWithEnv(env, hashMap, null);
    }

    public static void fillMapWithEnv(String[] env, HashMap<String, String> hashMap, Set<String> keysThatShouldNotBeUpdated) {
        if (keysThatShouldNotBeUpdated == null) {
            keysThatShouldNotBeUpdated = new HashSet<String>();
        }
        String[] stringArray = env;
        int n = env.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Tuple sp = StringUtils.splitOnFirst((String)s, (char)'=');
            if (((String)sp.o1).length() != 0 && ((String)sp.o2).length() != 0 && !keysThatShouldNotBeUpdated.contains(sp.o1)) {
                hashMap.put((String)sp.o1, (String)sp.o2);
            }
            ++n2;
        }
    }

    public static void removePythonPathFromEnvMapWithWarning(HashMap<String, String> map) {
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> next = it.next();
            String key = next.getKey();
            if (!InterpreterInfo.checkIfPythonPathEnvVarAndWarnIfIs(key)) continue;
            it.remove();
        }
    }

    public static boolean checkIfPythonPathEnvVarAndWarnIfIs(String key) {
        String keyPlatformDependent;
        boolean isPythonPath = false;
        boolean win32 = REF.isWindowsPlatform();
        if (win32) {
            key = key.toUpperCase();
        }
        if ((keyPlatformDependent = key).equals("PYTHONPATH") || keyPlatformDependent.equals("CLASSPATH")) {
            final String msg = new StringBuffer("Ignoring ").append(keyPlatformDependent).append(" specified in the interpreter info.\n").append("It's managed depending on the project and other configurations and cannot be directly specified in the interpreter.").toString();
            try {
                RunInUiThread.async((Runnable)new Runnable(){

                    public void run() {
                        MessageBox message = new MessageBox(PyAction.getShell(), 34);
                        message.setText("Ignoring " + keyPlatformDependent);
                        message.setMessage(msg);
                        message.open();
                    }
                });
            }
            catch (Throwable throwable) {}
            Log.log((int)2, (String)msg, null);
            isPythonPath = true;
        }
        return isPythonPath;
    }

    public InterpreterInfo makeCopy() {
        return InterpreterInfo.fromString(this.toString());
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.executableOrJar;
    }

    public String getNameForUI() {
        if (this.name != null) {
            return new StringBuffer(String.valueOf(this.name)).append("  (").append(this.executableOrJar).append(")").toString();
        }
        return this.executableOrJar;
    }

    public boolean matchNameBackwardCompatible(String interpreter) {
        if (this.name != null && interpreter.equals(this.name)) {
            return true;
        }
        if (REF.isWindowsPlatform()) {
            return interpreter.equalsIgnoreCase(this.executableOrJar);
        }
        return interpreter.equals(this.executableOrJar);
    }

    public /* synthetic */ IInterpreterInfo makeCopy() {
        return this.makeCopy();
    }
}

