/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTPermission;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Window;
import sun.awt.FullScreenCapable;
import sun.java2d.opengl.CGLGraphicsConfig;

public class CGraphicsDevice
extends GraphicsDevice {
    private final int displayID;
    private final GraphicsConfiguration[] configs;
    private final int DEFAULT_CONFIG = 0;
    private static AWTPermission fullScreenExclusivePermission;
    private DisplayMode originalMode;

    public CGraphicsDevice(int n) {
        this.displayID = n;
        this.configs = new GraphicsConfiguration[]{CGLGraphicsConfig.getConfig(this, 0)};
    }

    public int getCoreGraphicsScreen() {
        return this.displayID;
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        return (GraphicsConfiguration[])this.configs.clone();
    }

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        return this.configs[0];
    }

    @Override
    public String getIDstring() {
        return "Display " + this.displayID;
    }

    @Override
    public int getType() {
        return 0;
    }

    public double getXResolution() {
        return CGraphicsDevice.nativeGetXResolution(this.displayID);
    }

    public double getYResolution() {
        return CGraphicsDevice.nativeGetYResolution(this.displayID);
    }

    public int getScreenResolution() {
        return 72;
    }

    private static native double nativeGetXResolution(int var0);

    private static native double nativeGetYResolution(int var0);

    @Override
    public synchronized void setFullScreenWindow(Window window) {
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        boolean bl = this.isFullScreenSupported();
        if (bl && window2 != null) {
            CGraphicsDevice.exitFullScreenExclusive(window2);
            if (this.originalMode != null) {
                this.setDisplayMode(this.originalMode);
                this.originalMode = null;
            }
        }
        super.setFullScreenWindow(window);
        if (bl && window != null) {
            if (this.isDisplayChangeSupported()) {
                this.originalMode = this.getDisplayMode();
            }
            CGraphicsDevice.enterFullScreenExclusive(window);
        }
    }

    @Override
    public boolean isFullScreenSupported() {
        return CGraphicsDevice.isFSExclusiveModeAllowed();
    }

    private static boolean isFSExclusiveModeAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                securityManager.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    private static void enterFullScreenExclusive(Window window) {
        FullScreenCapable fullScreenCapable = (FullScreenCapable)((Object)window.getPeer());
        if (fullScreenCapable != null) {
            fullScreenCapable.enterFullScreenMode();
        }
    }

    private static void exitFullScreenExclusive(Window window) {
        FullScreenCapable fullScreenCapable = (FullScreenCapable)((Object)window.getPeer());
        if (fullScreenCapable != null) {
            fullScreenCapable.exitFullScreenMode();
        }
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return true;
    }

    @Override
    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            throw new IllegalArgumentException("Attempt to set null as a DisplayMode");
        }
        this.nativeSetDisplayMode(this.displayID, displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        if (this.isFullScreenSupported() && this.getFullScreenWindow() != null) {
            this.getFullScreenWindow().setSize(displayMode.getWidth(), displayMode.getHeight());
        }
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.nativeGetDisplayMode(this.displayID);
    }

    @Override
    public DisplayMode[] getDisplayModes() {
        return this.nativeGetDisplayModes(this.displayID);
    }

    private native void nativeSetDisplayMode(int var1, int var2, int var3, int var4, int var5);

    private native DisplayMode nativeGetDisplayMode(int var1);

    private native DisplayMode[] nativeGetDisplayModes(int var1);
}

