/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MXBean;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;

public class JMX {
    static final JMX proof = new JMX();
    public static final String DEFAULT_VALUE_FIELD = "defaultValue";
    public static final String IMMUTABLE_INFO_FIELD = "immutableInfo";
    public static final String INTERFACE_CLASS_NAME_FIELD = "interfaceClassName";
    public static final String LEGAL_VALUES_FIELD = "legalValues";
    public static final String MAX_VALUE_FIELD = "maxValue";
    public static final String MIN_VALUE_FIELD = "minValue";
    public static final String MXBEAN_FIELD = "mxbean";
    public static final String OPEN_TYPE_FIELD = "openType";
    public static final String ORIGINAL_TYPE_FIELD = "originalType";

    private JMX() {
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        return MBeanServerInvocationHandler.newProxyInstance(mBeanServerConnection, objectName, clazz, bl);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        try {
            Introspector.testComplianceMXBeanInterface(clazz);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
        MBeanServerInvocationHandler mBeanServerInvocationHandler = new MBeanServerInvocationHandler(mBeanServerConnection, objectName, true);
        Class[] classArray = bl ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, mBeanServerInvocationHandler);
        return clazz.cast(object);
    }

    public static boolean isMXBeanInterface(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        MXBean mXBean = clazz.getAnnotation(MXBean.class);
        if (mXBean != null) {
            return mXBean.value();
        }
        return clazz.getName().endsWith("MXBean");
    }
}

