/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunFileReader;
import com.sun.media.sound.WaveFileFormat;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class WaveFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 12;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.WAVE};

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getFMT(inputStream, true);
        inputStream.reset();
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        try (InputStream inputStream = uRL.openStream();){
            audioFileFormat = this.getFMT(inputStream, false);
        }
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            audioFileFormat = this.getFMT(fileInputStream, false);
        }
        return audioFileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getFMT(inputStream, true);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getFMT(inputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                inputStream.close();
            }
        }
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getFMT(fileInputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                fileInputStream.close();
            }
        }
        return new AudioInputStream(fileInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    private AudioFileFormat getFMT(InputStream inputStream, boolean bl) throws UnsupportedAudioFileException, IOException {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        short s = 0;
        AudioFormat.Encoding encoding = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (bl) {
            dataInputStream.mark(12);
        }
        int n5 = dataInputStream.readInt();
        int n6 = this.rllong(dataInputStream);
        int n7 = dataInputStream.readInt();
        if (n6 <= 0) {
            n6 = -1;
            n2 = -1;
        } else {
            n2 = n6 + 8;
        }
        if (n5 != 1380533830 || n7 != 1463899717) {
            if (bl) {
                dataInputStream.reset();
            }
            throw new UnsupportedAudioFileException("not a WAVE file");
        }
        try {
            while (true) {
                int n8 = dataInputStream.readInt();
                n3 += 4;
                if (n8 != 1718449184) {
                    n4 = this.rllong(dataInputStream);
                    n3 += 4;
                    if (n4 % 2 > 0) {
                        ++n4;
                    }
                    n3 += dataInputStream.skipBytes(n4);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n4 = this.rllong(dataInputStream);
        int n9 = (n3 += 4) + n4;
        s = this.rlshort(dataInputStream);
        n3 += 2;
        if (s == 1) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        } else if (s == 6) {
            encoding = AudioFormat.Encoding.ALAW;
        } else if (s == 7) {
            encoding = AudioFormat.Encoding.ULAW;
        } else {
            throw new UnsupportedAudioFileException("Not a supported WAV file");
        }
        short s2 = this.rlshort(dataInputStream);
        n3 += 2;
        long l = this.rllong(dataInputStream);
        n3 += 4;
        long l2 = this.rllong(dataInputStream);
        n3 += 4;
        short s3 = this.rlshort(dataInputStream);
        n3 += 2;
        short s4 = this.rlshort(dataInputStream);
        n3 += 2;
        if (s4 == 8 && encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            encoding = AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (n4 % 2 != 0) {
            ++n4;
        }
        if (n9 > n3) {
            n3 += dataInputStream.skipBytes(n9 - n3);
        }
        n3 = 0;
        try {
            while (true) {
                n = dataInputStream.readInt();
                n3 += 4;
                if (n != 1684108385) {
                    int n10 = this.rllong(dataInputStream);
                    n3 += 4;
                    if (n10 % 2 > 0) {
                        ++n10;
                    }
                    n3 += dataInputStream.skipBytes(n10);
                    continue;
                }
                break;
            }
        }
        catch (EOFException eOFException) {
            throw new UnsupportedAudioFileException("Not a valid WAV file");
        }
        n = this.rllong(dataInputStream);
        n3 += 4;
        AudioFormat audioFormat = new AudioFormat(encoding, l, s4, s2, WaveFileReader.calculatePCMFrameSize(s4, s2), l, false);
        return new WaveFileFormat(AudioFileFormat.Type.WAVE, n2, audioFormat, n / audioFormat.getFrameSize());
    }
}

