/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.MidiInDeviceProvider;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private Thread midiInThread = null;

    MidiInDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    @Override
    protected synchronized void implOpen() throws MidiUnavailableException {
        int n = ((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex();
        this.id = this.nOpen(n);
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        if (this.midiInThread == null) {
            this.midiInThread = JSSecurityManager.createThread(this, "Java Sound MidiInDevice Thread", false, -1, true);
        }
        this.nStart(this.id);
    }

    @Override
    protected synchronized void implClose() {
        long l = this.id;
        this.id = 0L;
        super.implClose();
        this.nStop(l);
        if (this.midiInThread != null) {
            try {
                this.midiInThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.nClose(l);
    }

    @Override
    public long getMicrosecondPosition() {
        long l = -1L;
        if (this.isOpen()) {
            l = this.nGetTimeStamp(this.id);
        }
        return l;
    }

    @Override
    protected boolean hasTransmitters() {
        return true;
    }

    @Override
    protected Transmitter createTransmitter() {
        return new MidiInTransmitter();
    }

    @Override
    public void run() {
        while (this.id != 0L) {
            this.nGetMessages(this.id);
            if (this.id == 0L) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.midiInThread = null;
    }

    void callbackShortMessage(int n, long l) {
        if (n == 0 || this.id == 0L) {
            return;
        }
        this.getTransmitterList().sendMessage(n, l);
    }

    void callbackLongMessage(byte[] byArray, long l) {
        if (this.id == 0L || byArray == null) {
            return;
        }
        this.getTransmitterList().sendMessage(byArray, l);
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nStart(long var1) throws MidiUnavailableException;

    private native void nStop(long var1);

    private native long nGetTimeStamp(long var1);

    private native void nGetMessages(long var1);

    private class MidiInTransmitter
    extends AbstractMidiDevice.BasicTransmitter {
        private MidiInTransmitter() {
        }
    }
}

