/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

final class LdapAttribute
extends BasicAttribute {
    static final long serialVersionUID = -4288716561020779584L;
    private transient DirContext baseCtx = null;
    private Name rdn = new CompositeName();
    private String baseCtxURL;
    private Hashtable baseCtxEnv;

    @Override
    public Object clone() {
        LdapAttribute ldapAttribute = new LdapAttribute(this.attrID, this.baseCtx, this.rdn);
        ldapAttribute.values = (Vector)this.values.clone();
        return ldapAttribute;
    }

    @Override
    public boolean add(Object object) {
        this.values.addElement(object);
        return true;
    }

    LdapAttribute(String string) {
        super(string);
    }

    private LdapAttribute(String string, DirContext dirContext, Name name) {
        super(string);
        this.baseCtx = dirContext;
        this.rdn = name;
    }

    void setParent(DirContext dirContext, Name name) {
        this.baseCtx = dirContext;
        this.rdn = name;
    }

    private DirContext getBaseCtx() throws NamingException {
        if (this.baseCtx == null) {
            if (this.baseCtxEnv == null) {
                this.baseCtxEnv = new Hashtable(3);
            }
            this.baseCtxEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            this.baseCtxEnv.put("java.naming.provider.url", this.baseCtxURL);
            this.baseCtx = new InitialDirContext(this.baseCtxEnv);
        }
        return this.baseCtx;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.setBaseCtxInfo();
        objectOutputStream.defaultWriteObject();
    }

    private void setBaseCtxInfo() {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        if (this.baseCtx != null) {
            hashtable = ((LdapCtx)this.baseCtx).envprops;
            this.baseCtxURL = ((LdapCtx)this.baseCtx).getURL();
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.indexOf("security") == -1) continue;
                if (hashtable2 == null) {
                    hashtable2 = (Hashtable)hashtable.clone();
                }
                hashtable2.remove(string);
            }
        }
        this.baseCtxEnv = hashtable2 == null ? hashtable : hashtable2;
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        DirContext dirContext = this.getBaseCtx().getSchema(this.rdn);
        DirContext dirContext2 = (DirContext)dirContext.lookup("AttributeDefinition/" + this.getID());
        Attribute attribute = dirContext2.getAttributes("").get("SYNTAX");
        if (attribute == null || attribute.size() == 0) {
            throw new NameNotFoundException(this.getID() + "does not have a syntax associated with it");
        }
        String string = (String)attribute.get();
        return (DirContext)dirContext.lookup("SyntaxDefinition/" + string);
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        DirContext dirContext = this.getBaseCtx().getSchema(this.rdn);
        return (DirContext)dirContext.lookup("AttributeDefinition/" + this.getID());
    }
}

