/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.HTMLPane;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.OverviewPanel;
import sun.tools.jconsole.Plotter;
import sun.tools.jconsole.PlotterPanel;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.TimeComboBox;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMPanel;

class ClassTab
extends Tab
implements ActionListener {
    PlotterPanel loadedClassesMeter;
    TimeComboBox timeComboBox;
    private JCheckBox verboseCheckBox;
    private HTMLPane details;
    private ClassOverviewPanel overviewPanel;
    private boolean plotterListening = false;
    private static final String loadedPlotterKey = "loaded";
    private static final String totalLoadedPlotterKey = "totalLoaded";
    private static final String loadedPlotterName = Resources.getText("Loaded", new Object[0]);
    private static final String totalLoadedPlotterName = Resources.getText("Total Loaded", new Object[0]);
    private static final Color loadedPlotterColor = Plotter.defaultColor;
    private static final Color totalLoadedPlotterColor = Color.red;
    private static final String infoLabelFormat = "ClassTab.infoLabelFormat";

    public static String getTabName() {
        return Resources.getText("Classes", new Object[0]);
    }

    public ClassTab(VMPanel vMPanel) {
        super(vMPanel, ClassTab.getTabName());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(new EmptyBorder(4, 4, 3, 4));
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel(new FlowLayout(1, 20, 5));
        jPanel.add((Component)jPanel4, "Center");
        this.verboseCheckBox = new JCheckBox(Resources.getText("Verbose Output", new Object[0]));
        this.verboseCheckBox.addActionListener(this);
        this.verboseCheckBox.setToolTipText(Resources.getText("Verbose Output.toolTip", new Object[0]));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new EmptyBorder(0, 57, 0, 70));
        jPanel5.add(this.verboseCheckBox);
        jPanel.add((Component)jPanel5, "After");
        this.loadedClassesMeter = new PlotterPanel(Resources.getText("Number of Loaded Classes", new Object[0]), Plotter.Unit.NONE, false);
        this.loadedClassesMeter.plotter.createSequence(loadedPlotterKey, loadedPlotterName, loadedPlotterColor, true);
        this.loadedClassesMeter.plotter.createSequence(totalLoadedPlotterKey, totalLoadedPlotterName, totalLoadedPlotterColor, true);
        Utilities.setAccessibleName(this.loadedClassesMeter.plotter, Resources.getText("ClassTab.loadedClassesPlotter.accessibleName", new Object[0]));
        jPanel2.add(this.loadedClassesMeter);
        this.timeComboBox = new TimeComboBox(this.loadedClassesMeter.plotter);
        jPanel4.add(new LabeledComponent(Resources.getText("Time Range:", new Object[0]), Resources.getMnemonicInt("Time Range:"), this.timeComboBox));
        LabeledComponent.layout(jPanel2);
        jPanel3.setBorder(new CompoundBorder(new TitledBorder(Resources.getText("Details", new Object[0])), new EmptyBorder(10, 10, 10, 10)));
        this.details = new HTMLPane();
        Utilities.setAccessibleName(this.details, Resources.getText("Details", new Object[0]));
        JScrollPane jScrollPane = new JScrollPane(this.details);
        jScrollPane.setPreferredSize(new Dimension(0, 150));
        jPanel3.add((Component)jScrollPane, "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        final boolean bl = this.verboseCheckBox.isSelected();
        this.workerAdd(new Runnable(){

            @Override
            public void run() {
                ProxyClient proxyClient = ClassTab.this.vmPanel.getProxyClient();
                try {
                    proxyClient.getClassLoadingMXBean().setVerbose(bl);
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        final ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (!this.plotterListening) {
            proxyClient.addWeakPropertyChangeListener(this.loadedClassesMeter.plotter);
            this.plotterListening = true;
        }
        return new SwingWorker<Boolean, Object>(){
            private long clCount;
            private long cuCount;
            private long ctCount;
            private boolean isVerbose;
            private String detailsStr;
            private long timeStamp;

            @Override
            public Boolean doInBackground() {
                try {
                    ClassLoadingMXBean classLoadingMXBean = proxyClient.getClassLoadingMXBean();
                    this.clCount = classLoadingMXBean.getLoadedClassCount();
                    this.cuCount = classLoadingMXBean.getUnloadedClassCount();
                    this.ctCount = classLoadingMXBean.getTotalLoadedClassCount();
                    this.isVerbose = classLoadingMXBean.isVerbose();
                    this.detailsStr = this.formatDetails();
                    this.timeStamp = System.currentTimeMillis();
                    return true;
                }
                catch (UndeclaredThrowableException undeclaredThrowableException) {
                    proxyClient.markAsDead();
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
            }

            @Override
            protected void done() {
                block5: {
                    try {
                        if (((Boolean)this.get()).booleanValue()) {
                            ClassTab.this.loadedClassesMeter.plotter.addValues(this.timeStamp, this.clCount, this.ctCount);
                            if (ClassTab.this.overviewPanel != null) {
                                ClassTab.this.overviewPanel.updateClassInfo(this.ctCount, this.clCount);
                                ClassTab.this.overviewPanel.getPlotter().addValues(this.timeStamp, this.clCount);
                            }
                            ClassTab.this.loadedClassesMeter.setValueLabel(this.clCount + "");
                            ClassTab.this.verboseCheckBox.setSelected(this.isVerbose);
                            ClassTab.this.details.setText(this.detailsStr);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        if (!JConsole.isDebug()) break block5;
                        executionException.printStackTrace();
                    }
                }
            }

            private String formatDetails() {
                String string = "<table cellspacing=0 cellpadding=0>";
                long l = System.currentTimeMillis();
                String string2 = Formatter.formatDateTime(l);
                string = string + Formatter.newRow(Resources.getText("Time", new Object[0]), string2);
                string = string + Formatter.newRow(Resources.getText("Current classes loaded", new Object[0]), Formatter.justify(this.clCount, 5));
                string = string + Formatter.newRow(Resources.getText("Total classes loaded", new Object[0]), Formatter.justify(this.ctCount, 5));
                string = string + Formatter.newRow(Resources.getText("Total classes unloaded", new Object[0]), Formatter.justify(this.cuCount, 5));
                return string;
            }
        };
    }

    @Override
    OverviewPanel[] getOverviewPanels() {
        if (this.overviewPanel == null) {
            this.overviewPanel = new ClassOverviewPanel();
        }
        return new OverviewPanel[]{this.overviewPanel};
    }

    private static class ClassOverviewPanel
    extends OverviewPanel {
        ClassOverviewPanel() {
            super(Resources.getText("Classes", new Object[0]), ClassTab.loadedPlotterKey, loadedPlotterName, null);
        }

        private void updateClassInfo(long l, long l2) {
            long l3 = l - l2;
            this.getInfoLabel().setText(Resources.getText(ClassTab.infoLabelFormat, l2, l3, l));
        }
    }
}

