/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.Random;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public class RandomLoadBalancer
extends QueueLoadBalancer {
    private static final Random RANDOM = new Random();

    @Override
    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        int size = processors.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return processors.get(0);
        }
        int index = RANDOM.nextInt(size);
        return processors.get(index);
    }

    public String toString() {
        return "RandomLoadBalancer";
    }
}

