/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.converter;

import java.lang.reflect.Method;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.ObjectHelper;

public class EnumTypeConverter
extends TypeConverterSupport {
    @Override
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        if (type.isEnum() && value != null) {
            Method method;
            String text = value.toString();
            try {
                method = type.getMethod("valueOf", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeCamelException("Could not find valueOf method on enum type: " + type.getName());
            }
            return (T)ObjectHelper.invokeMethod(method, null, text);
        }
        return null;
    }
}

