/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.CamelContext;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class DefaultLSResourceResolver
implements LSResourceResolver {
    private final CamelContext camelContext;
    private final String resourceUri;
    private final String resourcePath;

    public DefaultLSResourceResolver(CamelContext camelContext, String resourceUri) {
        this.camelContext = camelContext;
        this.resourceUri = resourceUri;
        this.resourcePath = FileUtil.onlyPath(resourceUri);
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Resource: %s refers an invalid resource without SystemId. Invalid resource has type: %s, namespaceURI: %s, publicId: %s, systemId: %s, baseURI: %s", this.resourceUri, type, namespaceURI, publicId, systemId, baseURI));
        }
        return new DefaultLSInput(publicId, systemId, baseURI);
    }

    private final class DefaultLSInput
    implements LSInput {
        private final String publicId;
        private final String systemId;
        private final String baseURI;
        private final String uri;

        private DefaultLSInput(String publicId, String systemId, String baseURI) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseURI = baseURI;
            this.uri = DefaultLSResourceResolver.this.resourcePath != null ? DefaultLSResourceResolver.this.resourcePath + "/" + systemId : systemId;
        }

        @Override
        public Reader getCharacterStream() {
            InputStream is = this.getByteStream();
            return DefaultLSResourceResolver.this.camelContext.getTypeConverter().convertTo(Reader.class, is);
        }

        @Override
        public void setCharacterStream(Reader reader) {
        }

        @Override
        public InputStream getByteStream() {
            try {
                return ResourceHelper.resolveMandatoryResourceAsInputStream(DefaultLSResourceResolver.this.camelContext.getClassResolver(), this.uri);
            }
            catch (IOException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }

        @Override
        public void setByteStream(InputStream inputStream) {
        }

        @Override
        public String getStringData() {
            InputStream is = this.getByteStream();
            return DefaultLSResourceResolver.this.camelContext.getTypeConverter().convertTo(String.class, is);
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
        }

        @Override
        public String getBaseURI() {
            return this.baseURI;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        public String toString() {
            return "DefaultLSInput[" + this.uri + "]";
        }
    }
}

