/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.AbstractMessageStore;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCMessageStore
extends AbstractMessageStore {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCMessageStore.class);
    protected final WireFormat wireFormat;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;
    protected AtomicLong lastRecoveredSequenceId = new AtomicLong(-1L);
    protected AtomicLong lastRecoveredPriority = new AtomicLong(126L);
    protected ActiveMQMessageAudit audit;

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, ActiveMQDestination destination, ActiveMQMessageAudit audit) throws IOException {
        super(destination);
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.wireFormat = wireFormat;
        this.audit = audit;
        if (destination.isQueue() && persistenceAdapter.getBrokerService().shouldRecordVirtualDestination(destination)) {
            this.recordDestinationCreation(destination);
        }
    }

    private void recordDestinationCreation(ActiveMQDestination destination) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            if (this.adapter.doGetLastAckedDurableSubscriberMessageId(c, destination, destination.getQualifiedName(), destination.getQualifiedName()) < 0L) {
                this.adapter.doRecordDestination(c, destination);
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to record destination: " + destination + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        byte[] data;
        MessageId messageId = message.getMessageId();
        if (this.audit != null && this.audit.isDuplicate((MessageReference)message)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.destination.getPhysicalName() + " ignoring duplicated (add) message, already stored: " + messageId);
            }
            return;
        }
        long sequenceId = this.persistenceAdapter.getNextSequenceId();
        try {
            ByteSequence packet = this.wireFormat.marshal((Object)message);
            data = ByteSequenceData.toByteArray((ByteSequence)packet);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doAddMessage(c, sequenceId, messageId, this.destination, data, message.getExpiration(), this.isPrioritizedMessages() ? message.getPriority() : (byte)0, context != null ? context.getXid() : null);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
        if (context != null && context.getXid() != null) {
            message.getMessageId().setDataLocator((Object)sequenceId);
        } else {
            this.onAdd(messageId, sequenceId, message.getPriority());
        }
    }

    protected void onAdd(MessageId messageId, long sequenceId, byte priority) {
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, long expirationTime, String messageRef) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doAddMessageReference(c, this.persistenceAdapter.getNextSequenceId(), messageId, this.destination, expirationTime, messageRef);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public Message getMessage(MessageId messageId) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            Message answer;
            byte[] data = this.adapter.doGetMessage(c, messageId);
            if (data == null) {
                Message message = null;
                return message;
            }
            Message message = answer = (Message)this.wireFormat.unmarshal(new ByteSequence(data));
            return message;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public String getMessageReference(MessageId messageId) throws IOException {
        long id = messageId.getBrokerSequenceId();
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            String string = this.adapter.doGetMessageReference(c, id);
            return string;
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker message: " + messageId + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        long seq = this.persistenceAdapter.getStoreSequenceIdForMessageId(ack.getLastMessageId(), this.destination)[0];
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveMessage(c, seq, context != null ? context.getXid() : null);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker message: " + ack.getLastMessageId() + " in container: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
        if (context != null && context.getXid() != null) {
            ack.getLastMessageId().setDataLocator((Object)seq);
        }
    }

    public void recover(final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            c = this.persistenceAdapter.getTransactionContext();
            this.adapter.doRecover(c, this.destination, new JDBCMessageRecoveryListener(){

                @Override
                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    Message msg = (Message)JDBCMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                    msg.getMessageId().setBrokerSequenceId(sequenceId);
                    return listener.recoverMessage(msg);
                }

                @Override
                public boolean recoverMessageReference(String reference) throws Exception {
                    return listener.recoverMessageReference(new MessageId(reference));
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to recover container. Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        TransactionContext c = this.persistenceAdapter.getTransactionContext(context);
        try {
            this.adapter.doRemoveAllMessages(c, this.destination);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to broker remove all messages: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
    }

    public int getMessageCount() throws IOException {
        int result = 0;
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            result = this.adapter.doGetMessageCount(c, this.destination);
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
            throw IOExceptionSupport.create((String)("Failed to get Message Count: " + this.destination + ". Reason: " + e), (Exception)e);
        }
        finally {
            c.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverNextMessages(int maxReturned, final MessageRecoveryListener listener) throws Exception {
        TransactionContext c = this.persistenceAdapter.getTransactionContext();
        try {
            this.adapter.doRecoverNextMessages(c, this.destination, this.lastRecoveredSequenceId.get(), this.lastRecoveredPriority.get(), maxReturned, this.isPrioritizedMessages(), new JDBCMessageRecoveryListener(){

                @Override
                public boolean recoverMessage(long sequenceId, byte[] data) throws Exception {
                    if (listener.hasSpace()) {
                        Message msg = (Message)JDBCMessageStore.this.wireFormat.unmarshal(new ByteSequence(data));
                        msg.getMessageId().setBrokerSequenceId(sequenceId);
                        listener.recoverMessage(msg);
                        JDBCMessageStore.this.lastRecoveredSequenceId.set(sequenceId);
                        JDBCMessageStore.this.lastRecoveredPriority.set(msg.getPriority());
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean recoverMessageReference(String reference) throws Exception {
                    if (listener.hasSpace()) {
                        listener.recoverMessageReference(new MessageId(reference));
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("JDBC Failure: ", e);
        }
        finally {
            c.close();
        }
    }

    public void resetBatching() {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " resetBatching, existing last recovered seqId: " + this.lastRecoveredSequenceId.get());
        }
        this.lastRecoveredSequenceId.set(-1L);
        this.lastRecoveredPriority.set(126L);
    }

    public void setBatch(MessageId messageId) {
        try {
            long[] storedValues = this.persistenceAdapter.getStoreSequenceIdForMessageId(messageId, this.destination);
            this.lastRecoveredSequenceId.set(storedValues[0]);
            this.lastRecoveredPriority.set(storedValues[1]);
        }
        catch (IOException ignoredAsAlreadyLogged) {
            this.lastRecoveredSequenceId.set(-1L);
            this.lastRecoveredPriority.set(126L);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.destination.getPhysicalName() + " setBatch: new sequenceId: " + this.lastRecoveredSequenceId.get() + ", priority: " + this.lastRecoveredPriority.get());
        }
    }

    public void setPrioritizedMessages(boolean prioritizedMessages) {
        super.setPrioritizedMessages(prioritizedMessages);
    }

    class Duration {
        static final int LIMIT = 100;
        final long start = System.currentTimeMillis();
        final String name;

        Duration(String name) {
            this.name = name;
        }

        void end() {
            this.end(null);
        }

        void end(Object o) {
            long duration = System.currentTimeMillis() - this.start;
            if (duration > 100L) {
                System.err.println(this.name + " took a long time: " + duration + "ms " + o);
            }
        }
    }
}

