/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.apache.activemq.broker.AbstractLocker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.util.Handler;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseLocker
extends AbstractLocker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDatabaseLocker.class);
    protected DataSource dataSource;
    protected Statements statements;
    protected volatile PreparedStatement lockCreateStatement;
    protected volatile PreparedStatement lockUpdateStatement;
    protected volatile Connection connection;
    protected volatile boolean stopping;
    protected Handler<Exception> exceptionHandler;
    protected int queryTimeout = 10;

    public void configure(PersistenceAdapter adapter) throws IOException {
        if (adapter instanceof JDBCPersistenceAdapter) {
            this.dataSource = ((JDBCPersistenceAdapter)adapter).getLockDataSource();
            this.statements = ((JDBCPersistenceAdapter)adapter).getStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.stopping = false;
        LOG.info("Attempting to acquire the exclusive lock to become the Master broker");
        String sql = this.statements.getLockCreateStatement();
        LOG.debug("Locking Query is " + sql);
        while (true) {
            try {
                this.connection = this.dataSource.getConnection();
                this.connection.setAutoCommit(false);
                this.lockCreateStatement = this.connection.prepareStatement(sql);
                this.lockCreateStatement.execute();
                break;
            }
            catch (Exception e) {
                try {
                    if (this.stopping) {
                        throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                    }
                    if (this.exceptionHandler != null) {
                        try {
                            this.exceptionHandler.handle((Object)e);
                        }
                        catch (Throwable handlerException) {
                            LOG.error("The exception handler " + this.exceptionHandler.getClass().getCanonicalName() + " threw this exception: " + handlerException + " while trying to handle this exception: " + e, handlerException);
                        }
                    } else {
                        LOG.debug("Lock failure: " + e, (Throwable)e);
                    }
                }
                finally {
                    if (null != this.connection) {
                        try {
                            this.connection.rollback();
                        }
                        catch (SQLException e1) {
                            LOG.error("Caught exception during rollback on connection: " + e1, (Throwable)e1);
                        }
                        try {
                            this.connection.close();
                        }
                        catch (SQLException e1) {
                            LOG.error("Caught exception while closing connection: " + e1, (Throwable)e1);
                        }
                        this.connection = null;
                    }
                }
            }
            finally {
                if (null != this.lockCreateStatement) {
                    try {
                        this.lockCreateStatement.close();
                    }
                    catch (SQLException e1) {
                        LOG.debug("Caught while closing statement: " + e1, (Throwable)e1);
                    }
                    this.lockCreateStatement = null;
                }
            }
            LOG.info("Failed to acquire lock.  Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again...");
            try {
                Thread.sleep(this.lockAcquireSleepInterval);
            }
            catch (InterruptedException ie) {
                LOG.warn("Master lock retry sleep interrupted", (Throwable)ie);
            }
        }
        LOG.info("Becoming the master on dataSource: " + this.dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop(ServiceStopper stopper) throws Exception {
        this.stopping = true;
        try {
            if (this.lockCreateStatement != null) {
                this.lockCreateStatement.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            LOG.warn("Failed to cancel locking query on dataSource" + this.dataSource, (Throwable)e);
        }
        try {
            if (this.lockUpdateStatement != null) {
                this.lockUpdateStatement.cancel();
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            LOG.warn("Failed to cancel locking query on dataSource" + this.dataSource, (Throwable)e);
        }
        if (this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (SQLException sqle) {
                LOG.warn("Exception while rollbacking the connection on shutdown. This exception is ignored.", (Throwable)sqle);
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (SQLException ignored) {
                    LOG.debug("Exception while closing connection on shutdown. This exception is ignored.", (Throwable)ignored);
                }
                this.lockCreateStatement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean keepAlive() throws IOException {
        boolean result = false;
        try {
            int rows;
            this.lockUpdateStatement = this.connection.prepareStatement(this.statements.getLockUpdateStatement());
            this.lockUpdateStatement.setLong(1, System.currentTimeMillis());
            if (this.queryTimeout > 0) {
                this.lockUpdateStatement.setQueryTimeout(this.queryTimeout);
            }
            if ((rows = this.lockUpdateStatement.executeUpdate()) == 1) {
                result = true;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to update database lock: " + e, (Throwable)e);
        }
        finally {
            if (this.lockUpdateStatement != null) {
                try {
                    this.lockUpdateStatement.close();
                }
                catch (SQLException e) {
                    LOG.error("Failed to close statement", (Throwable)e);
                }
                this.lockUpdateStatement = null;
            }
        }
        return result;
    }

    public long getLockAcquireSleepInterval() {
        return this.lockAcquireSleepInterval;
    }

    public void setLockAcquireSleepInterval(long lockAcquireSleepInterval) {
        this.lockAcquireSleepInterval = lockAcquireSleepInterval;
    }

    public Handler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Handler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }
}

