/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.http.HttpTransportSupport;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientTransport
extends HttpTransportSupport {
    public static final int MAX_CLIENT_TIMEOUT = 30000;
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private static final IdGenerator CLIENT_ID_GENERATOR = new IdGenerator();
    private HttpClient sendHttpClient;
    private HttpClient receiveHttpClient;
    private final String clientID = CLIENT_ID_GENERATOR.generateId();
    private boolean trace;
    private HttpGet httpMethod;
    private volatile int receiveCounter;
    private int soTimeout = 30000;
    private boolean useCompression = false;
    private boolean canSendCompressed = false;
    private int minSendAsCompressedSize = 0;

    public HttpClientTransport(TextWireFormat wireFormat, URI remoteUrl) {
        super(wireFormat, remoteUrl);
    }

    public FutureResponse asyncRequest(Object command) throws IOException {
        return null;
    }

    public void oneway(Object command) throws IOException {
        if (this.isStopped()) {
            throw new IOException("stopped.");
        }
        HttpPost httpMethod = new HttpPost(this.getRemoteUrl().toString());
        this.configureMethod((AbstractHttpMessage)httpMethod);
        String data = this.getTextWireFormat().marshalText(command);
        byte[] bytes = data.getBytes("UTF-8");
        if (this.useCompression && this.canSendCompressed && bytes.length > this.minSendAsCompressedSize) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            GZIPOutputStream stream = new GZIPOutputStream((OutputStream)bytesOut);
            stream.write(bytes);
            stream.close();
            httpMethod.addHeader("Content-Type", "application/x-gzip");
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sending compressed, size = " + bytes.length + ", compressed size = " + bytesOut.size());
            }
            bytes = bytesOut.toByteArray();
        }
        ByteArrayEntity entity = new ByteArrayEntity(bytes);
        httpMethod.setEntity((HttpEntity)entity);
        HttpClient client = null;
        HttpResponse answer = null;
        try {
            client = this.getSendHttpClient();
            HttpParams params = client.getParams();
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.soTimeout);
            answer = client.execute((HttpUriRequest)httpMethod);
            int status = answer.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new IOException("Failed to post command: " + command + " as response was: " + answer);
            }
            if (command instanceof ShutdownInfo) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    LOG.warn("Error trying to stop HTTP client: " + e, (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            throw IOExceptionSupport.create((String)("Could not post command: " + command + " due to: " + e), (Exception)e);
        }
        finally {
            if (answer != null) {
                EntityUtils.consume((HttpEntity)answer.getEntity());
            }
        }
    }

    public Object request(Object command) throws IOException {
        return null;
    }

    private DataInputStream createDataInputStream(HttpResponse answer) throws IOException {
        Header encoding = answer.getEntity().getContentEncoding();
        if (encoding != null && "gzip".equalsIgnoreCase(encoding.getValue())) {
            return new DataInputStream(new GZIPInputStream(answer.getEntity().getContent()));
        }
        return new DataInputStream(answer.getEntity().getContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP GET consumer thread starting: " + (Object)((Object)this));
        }
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        while (!this.isStopped() && !this.isStopping()) {
            this.httpMethod = new HttpGet(remoteUrl.toString());
            this.configureMethod((AbstractHttpMessage)this.httpMethod);
            HttpResponse answer = null;
            try {
                answer = httpClient.execute((HttpUriRequest)this.httpMethod);
                int status = answer.getStatusLine().getStatusCode();
                if (status != 200) {
                    if (status == 408) {
                        LOG.debug("GET timed out");
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            this.onException(new InterruptedIOException());
                            if (answer == null) break;
                            try {
                                EntityUtils.consume((HttpEntity)answer.getEntity());
                            }
                            catch (IOException e2) {}
                            break;
                        }
                    }
                    this.onException(new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + answer));
                    break;
                }
                ++this.receiveCounter;
                DataInputStream stream = this.createDataInputStream(answer);
                Object command = this.getTextWireFormat().unmarshal(stream);
                if (command == null) {
                    LOG.debug("Received null command from url: " + remoteUrl);
                } else {
                    this.doConsume(command);
                }
                stream.close();
            }
            catch (IOException e) {
                this.onException(IOExceptionSupport.create((String)("Failed to perform GET on: " + remoteUrl + " Reason: " + e.getMessage()), (Exception)e));
                break;
            }
            finally {
                if (answer == null) continue;
                try {
                    EntityUtils.consume((HttpEntity)answer.getEntity());
                }
                catch (IOException e) {}
            }
        }
    }

    public HttpClient getSendHttpClient() {
        if (this.sendHttpClient == null) {
            this.sendHttpClient = this.createHttpClient();
        }
        return this.sendHttpClient;
    }

    public void setSendHttpClient(HttpClient sendHttpClient) {
        this.sendHttpClient = sendHttpClient;
    }

    public HttpClient getReceiveHttpClient() {
        if (this.receiveHttpClient == null) {
            this.receiveHttpClient = this.createHttpClient();
        }
        return this.receiveHttpClient;
    }

    public void setReceiveHttpClient(HttpClient receiveHttpClient) {
        this.receiveHttpClient = receiveHttpClient;
    }

    protected void doStart() throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP GET consumer thread starting: " + (Object)((Object)this));
        }
        HttpClient httpClient = this.getReceiveHttpClient();
        URI remoteUrl = this.getRemoteUrl();
        HttpHead httpMethod = new HttpHead(remoteUrl.toString());
        this.configureMethod((AbstractHttpMessage)httpMethod);
        HttpOptions optionsMethod = new HttpOptions(remoteUrl.toString());
        BasicResponseHandler handler = new BasicResponseHandler(){

            public String handleResponse(HttpResponse response) throws HttpResponseException, IOException {
                for (Header header : response.getAllHeaders()) {
                    if (!header.getName().equals("Accepts-Encoding") || !header.getValue().contains("gzip")) continue;
                    LOG.info("Broker Servlet supports GZip compression.");
                    HttpClientTransport.this.canSendCompressed = true;
                    break;
                }
                return super.handleResponse(response);
            }
        };
        try {
            httpClient.execute((HttpUriRequest)httpMethod, (ResponseHandler)new BasicResponseHandler());
            httpClient.execute((HttpUriRequest)optionsMethod, (ResponseHandler)handler);
        }
        catch (Exception e) {
            throw new IOException("Failed to perform GET on: " + remoteUrl + " as response was: " + e.getMessage());
        }
        super.doStart();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        if (this.httpMethod != null) {
            this.httpMethod.abort();
        }
    }

    protected HttpClient createHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        if (this.useCompression) {
            client.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) {
                    request.addHeader("Accept-Encoding", "gzip");
                }
            });
        }
        if (this.getProxyHost() != null) {
            HttpHost proxy = new HttpHost(this.getProxyHost(), this.getProxyPort());
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (this.getProxyUser() != null && this.getProxyPassword() != null) {
                client.getCredentialsProvider().setCredentials(new AuthScope(this.getProxyHost(), this.getProxyPort()), (Credentials)new UsernamePasswordCredentials(this.getProxyUser(), this.getProxyPassword()));
            }
        }
        return client;
    }

    protected void configureMethod(AbstractHttpMessage method) {
        method.setHeader("clientID", this.clientID);
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public int getMinSendAsCompressedSize() {
        return this.minSendAsCompressedSize;
    }

    public void setMinSendAsCompressedSize(int minSendAsCompressedSize) {
        this.minSendAsCompressedSize = minSendAsCompressedSize;
    }
}

