/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExtractor
implements Extractor {
    @Override
    public Class getType() {
        return Collection.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        Collection collection = (Collection)pValue;
        int length = pConverter.getCollectionLength(collection.size());
        Iterator it = collection.iterator();
        if (!jsonify) {
            return collection;
        }
        JSONArray ret = new JSONArray();
        for (int i = 0; i < length; ++i) {
            Object val = it.next();
            ret.add(pConverter.extractObject(val, null, jsonify));
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A collection (beside Lists and Maps) cannot be modified");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

