/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.activemq.MessageAvailableConsumer;
import org.apache.activemq.MessageAvailableListener;
import org.apache.activemq.web.AjaxListener;
import org.apache.activemq.web.AjaxWebClient;
import org.apache.activemq.web.MessageServletSupport;
import org.apache.activemq.web.UndeliveredAjaxMessage;
import org.apache.activemq.web.WebClient;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageListenerServlet
extends MessageServletSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MessageListenerServlet.class);
    private String readTimeoutParameter = "timeout";
    private long defaultReadTimeout = -1L;
    private long maximumReadTimeout = 25000L;
    private int maximumMessages = 100;
    private Timer clientCleanupTimer = new Timer("ActiveMQ Ajax Client Cleanup Timer", true);
    private HashMap<String, AjaxWebClient> ajaxWebClients = new HashMap();

    public void init() throws ServletException {
        ServletConfig servletConfig = this.getServletConfig();
        String name = servletConfig.getInitParameter("defaultReadTimeout");
        if (name != null) {
            this.defaultReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumReadTimeout")) != null) {
            this.maximumReadTimeout = this.asLong(name);
        }
        if ((name = servletConfig.getInitParameter("maximumMessages")) != null) {
            this.maximumMessages = (int)this.asLong(name);
        }
        this.clientCleanupTimer.schedule((TimerTask)new ClientCleaner(), 5000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AjaxWebClient client = this.getAjaxWebClient(request);
        String messageIds = "";
        AjaxWebClient ajaxWebClient = client;
        synchronized (ajaxWebClient) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("POST client=" + client + " session=" + request.getSession().getId() + " clientId=" + request.getParameter("clientId") + " info=" + request.getPathInfo() + " contentType=" + request.getContentType());
            }
            int messages = 0;
            while (true) {
                String destinationName;
                if ((destinationName = request.getParameter(messages == 0 ? "destination" : "d" + messages)) == null) {
                    destinationName = request.getHeader("destination");
                }
                String message = request.getParameter(messages == 0 ? "message" : "m" + messages);
                String type = request.getParameter(messages == 0 ? "type" : "t" + messages);
                if (destinationName == null || message == null || type == null) break;
                try {
                    Destination destination = this.getDestination(client, request, destinationName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(messages + " destination=" + destinationName + " message=" + message + " type=" + type);
                        LOG.debug(destination + " is a " + destination.getClass().getName());
                    }
                    ++messages;
                    if ("listen".equals(type)) {
                        AjaxListener listener = client.getListener();
                        Map<MessageAvailableConsumer, String> consumerIdMap = client.getIdMap();
                        Map<MessageAvailableConsumer, String> consumerDestinationNameMap = client.getDestinationNameMap();
                        client.closeConsumer(destination);
                        MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination, request.getHeader(WebClient.selectorName));
                        consumer.setAvailableListener((MessageAvailableListener)listener);
                        consumerIdMap.put(consumer, message);
                        consumerDestinationNameMap.put(consumer, destinationName);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Subscribed: " + consumer + " to " + destination + " id=" + message);
                        continue;
                    }
                    if ("unlisten".equals(type)) {
                        Map<MessageAvailableConsumer, String> consumerIdMap = client.getIdMap();
                        Map<MessageAvailableConsumer, String> consumerDestinationNameMap = client.getDestinationNameMap();
                        MessageAvailableConsumer consumer = (MessageAvailableConsumer)client.getConsumer(destination, request.getHeader(WebClient.selectorName));
                        consumer.setAvailableListener(null);
                        consumerIdMap.remove(consumer);
                        consumerDestinationNameMap.remove(consumer);
                        client.closeConsumer(destination);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Unsubscribed: " + consumer);
                        continue;
                    }
                    if ("send".equals(type)) {
                        TextMessage text = client.getSession().createTextMessage(message);
                        this.appendParametersToMessage(request, text);
                        client.send(destination, (Message)text);
                        messageIds = messageIds + text.getJMSMessageID() + "\n";
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Sent " + message + " to " + destination);
                        continue;
                    }
                    LOG.warn("unknown type " + type);
                }
                catch (JMSException e) {
                    LOG.warn("jms", (Throwable)e);
                }
            }
        }
        if ("true".equals(request.getParameter("poll"))) {
            try {
                this.doMessages(client, request, response);
            }
            catch (JMSException e) {
                throw new ServletException("JMS problem: " + (Object)((Object)e), (Throwable)e);
            }
        }
        if (!(request.getContentLength() == 0 || request.getContentType() != null && request.getContentType().toLowerCase().startsWith("application/x-www-form-urlencoded"))) {
            try {
                Destination destination = this.getDestination(client, request);
                String body = this.getPostedMessageBody(request);
                TextMessage message = client.getSession().createTextMessage(body);
                this.appendParametersToMessage(request, message);
                client.send(destination, (Message)message);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Sent to destination: " + destination + " body: " + body);
                }
                messageIds = messageIds + message.getJMSMessageID() + "\n";
            }
            catch (JMSException e) {
                throw new ServletException((Throwable)e);
            }
        }
        response.setContentType("text/plain");
        response.setHeader("Cache-Control", "no-cache");
        response.getWriter().print(messageIds);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            AjaxWebClient client = this.getAjaxWebClient(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("GET client=" + client + " session=" + request.getSession().getId() + " clientId=" + request.getParameter("clientId") + " uri=" + request.getRequestURI() + " query=" + request.getQueryString());
            }
            this.doMessages(client, request, response);
        }
        catch (JMSException e) {
            throw new ServletException("JMS problem: " + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMessages(AjaxWebClient client, HttpServletRequest request, HttpServletResponse response) throws JMSException, IOException {
        int messages = 0;
        long timeout = this.getReadTimeout(request);
        if (LOG.isDebugEnabled()) {
            LOG.debug("doMessage timeout=" + timeout);
        }
        UndeliveredAjaxMessage undelivered_message = null;
        Message message = null;
        undelivered_message = (UndeliveredAjaxMessage)request.getAttribute("undelivered_message");
        if (undelivered_message != null) {
            message = undelivered_message.getMessage();
        }
        AjaxWebClient ajaxWebClient = client;
        synchronized (ajaxWebClient) {
            Object destinationName;
            List<MessageConsumer> consumers = client.getConsumers();
            MessageAvailableConsumer consumer = null;
            if (undelivered_message != null) {
                consumer = (MessageAvailableConsumer)undelivered_message.getConsumer();
            }
            if (message == null) {
                for (int i = 0; message == null && i < consumers.size(); ++i) {
                    consumer = (MessageAvailableConsumer)consumers.get(i);
                    if (consumer.getAvailableListener() == null) continue;
                    message = consumer.receive(10L);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("received " + message + " from " + consumer);
                }
            }
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            if (message == null && client.getListener().getUndeliveredMessages().size() == 0) {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isExpired()) {
                    response.setStatus(200);
                    StringWriter swriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(swriter);
                    writer.println("<ajax-response>");
                    writer.print("</ajax-response>");
                    writer.flush();
                    String m = swriter.toString();
                    response.getWriter().println(m);
                    return;
                }
                continuation.setTimeout(timeout);
                continuation.suspend();
                LOG.debug("Suspending continuation " + continuation);
                AjaxListener listener = client.getListener();
                listener.access();
                listener.setContinuation(continuation);
                return;
            }
            StringWriter swriter = new StringWriter();
            PrintWriter writer = new PrintWriter(swriter);
            Map<MessageAvailableConsumer, String> consumerIdMap = client.getIdMap();
            Map<MessageAvailableConsumer, String> consumerDestinationNameMap = client.getDestinationNameMap();
            response.setStatus(200);
            writer.println("<ajax-response>");
            if (message != null) {
                String id = consumerIdMap.get(consumer);
                destinationName = consumerDestinationNameMap.get(consumer);
                LOG.debug("sending pre-existing message");
                this.writeMessageResponse(writer, message, id, (String)destinationName);
                ++messages;
            }
            LinkedList<UndeliveredAjaxMessage> undeliveredMessages = ((AjaxListener)consumer.getAvailableListener()).getUndeliveredMessages();
            LOG.debug("Send " + undeliveredMessages.size() + " unconsumed messages");
            destinationName = undeliveredMessages;
            synchronized (destinationName) {
                Iterator it = undeliveredMessages.iterator();
                while (it.hasNext()) {
                    ++messages;
                    UndeliveredAjaxMessage undelivered = (UndeliveredAjaxMessage)it.next();
                    Message msg = undelivered.getMessage();
                    consumer = (MessageAvailableConsumer)undelivered.getConsumer();
                    String id = consumerIdMap.get(consumer);
                    String destinationName2 = consumerDestinationNameMap.get(consumer);
                    LOG.debug("sending undelivered/buffered messages");
                    LOG.debug("msg:" + msg + ", id:" + id + ", destinationName:" + destinationName2);
                    this.writeMessageResponse(writer, msg, id, destinationName2);
                    it.remove();
                    if (messages < this.maximumMessages) continue;
                    break;
                }
            }
            for (int i = 0; i < consumers.size() && messages < this.maximumMessages; ++i) {
                consumer = (MessageAvailableConsumer)consumers.get(i);
                if (consumer.getAvailableListener() == null) continue;
                while (messages < this.maximumMessages && (message = consumer.receiveNoWait()) != null) {
                    ++messages;
                    String id = consumerIdMap.get(consumer);
                    String destinationName3 = consumerDestinationNameMap.get(consumer);
                    LOG.debug("sending final available messages");
                    this.writeMessageResponse(writer, message, id, destinationName3);
                }
            }
            writer.print("</ajax-response>");
            writer.flush();
            String m = swriter.toString();
            response.getWriter().println(m);
        }
    }

    protected void writeMessageResponse(PrintWriter writer, Message message, String id, String destinationName) throws JMSException, IOException {
        ObjectMessage objectMsg;
        Serializable object;
        writer.print("<response id='");
        writer.print(id);
        writer.print("'");
        if (destinationName != null) {
            writer.print(" destination='" + destinationName + "' ");
        }
        writer.print(">");
        if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            String txt = textMsg.getText();
            if (txt != null) {
                if (txt.startsWith("<?")) {
                    txt = txt.substring(txt.indexOf("?>") + 2);
                }
                writer.print(txt);
            }
        } else if (message instanceof ObjectMessage && (object = (objectMsg = (ObjectMessage)message).getObject()) != null) {
            writer.print(object.toString());
        }
        writer.println("</response>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AjaxWebClient getAjaxWebClient(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String clientId = request.getParameter("clientId");
        if (clientId == null) {
            clientId = "defaultAjaxWebClient";
        }
        String sessionKey = session.getId() + '-' + clientId;
        AjaxWebClient client = null;
        HashMap<String, AjaxWebClient> hashMap = this.ajaxWebClients;
        synchronized (hashMap) {
            client = this.ajaxWebClients.get(sessionKey);
            if (client == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("creating new AjaxWebClient in " + sessionKey);
                }
                client = new AjaxWebClient(request, this.maximumReadTimeout);
                this.ajaxWebClients.put(sessionKey, client);
            }
            client.updateLastAccessed();
        }
        return client;
    }

    protected long getReadTimeout(HttpServletRequest request) {
        long answer = this.defaultReadTimeout;
        String name = request.getParameter(this.readTimeoutParameter);
        if (name != null) {
            answer = this.asLong(name);
        }
        if (answer < 0L || answer > this.maximumReadTimeout) {
            answer = this.maximumReadTimeout;
        }
        return answer;
    }

    public void destroy() {
        this.clientCleanupTimer.cancel();
        super.destroy();
    }

    private class ClientCleaner
    extends TimerTask {
        private ClientCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cleaning up expired web clients.");
            }
            HashMap hashMap = MessageListenerServlet.this.ajaxWebClients;
            synchronized (hashMap) {
                Iterator it = MessageListenerServlet.this.ajaxWebClients.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    String key = (String)e.getKey();
                    AjaxWebClient val = (AjaxWebClient)e.getValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("AjaxWebClient " + key + " last accessed " + val.getMillisSinceLastAccessed() / 1000L + " seconds ago.");
                    }
                    if (!val.closeIfExpired()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Removing expired AjaxWebClient " + key);
                    }
                    it.remove();
                }
            }
        }
    }
}

