/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v9;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.BaseCommand;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v9.BaseDataStreamMarshaller;

public abstract class BaseCommandMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        BaseCommand info2 = (BaseCommand)o;
        info2.setCommandId(dataIn.readInt());
        info2.setResponseRequired(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BaseCommand info2 = (BaseCommand)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info2.isResponseRequired());
        return rc + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        BaseCommand info2 = (BaseCommand)o;
        dataOut.writeInt(info2.getCommandId());
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        BaseCommand info2 = (BaseCommand)o;
        info2.setCommandId(dataIn.readInt());
        info2.setResponseRequired(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        BaseCommand info2 = (BaseCommand)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info2.getCommandId());
        dataOut.writeBoolean(info2.isResponseRequired());
    }
}

