/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v8;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v8.BaseDataStreamMarshaller;

public class SubscriptionInfoMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 55;
    }

    @Override
    public DataStructure createObject() {
        return new SubscriptionInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        SubscriptionInfo info2 = (SubscriptionInfo)o;
        info2.setClientId(this.tightUnmarshalString(dataIn, bs));
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setSelector(this.tightUnmarshalString(dataIn, bs));
        info2.setSubcriptionName(this.tightUnmarshalString(dataIn, bs));
        info2.setSubscribedDestination((ActiveMQDestination)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        SubscriptionInfo info2 = (SubscriptionInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalString1(info2.getClientId(), bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        rc += this.tightMarshalString1(info2.getSelector(), bs);
        rc += this.tightMarshalString1(info2.getSubcriptionName(), bs);
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getSubscribedDestination(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        SubscriptionInfo info2 = (SubscriptionInfo)o;
        this.tightMarshalString2(info2.getClientId(), dataOut, bs);
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        this.tightMarshalString2(info2.getSelector(), dataOut, bs);
        this.tightMarshalString2(info2.getSubcriptionName(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, info2.getSubscribedDestination(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        SubscriptionInfo info2 = (SubscriptionInfo)o;
        info2.setClientId(this.looseUnmarshalString(dataIn));
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setSelector(this.looseUnmarshalString(dataIn));
        info2.setSubcriptionName(this.looseUnmarshalString(dataIn));
        info2.setSubscribedDestination((ActiveMQDestination)this.looseUnmarsalNestedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        SubscriptionInfo info2 = (SubscriptionInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalString(info2.getClientId(), dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        this.looseMarshalString(info2.getSelector(), dataOut);
        this.looseMarshalString(info2.getSubcriptionName(), dataOut);
        this.looseMarshalNestedObject(wireFormat, info2.getSubscribedDestination(), dataOut);
    }
}

