/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.data;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.data.DataFile;
import org.apache.activemq.kaha.impl.data.DataItem;
import org.apache.activemq.kaha.impl.data.DataManagerImpl;
import org.apache.activemq.util.DataByteArrayOutputStream;

public final class SyncDataFileWriter {
    private DataByteArrayOutputStream buffer;
    private DataManagerImpl dataManager;

    SyncDataFileWriter(DataManagerImpl fileManager) {
        this.dataManager = fileManager;
        this.buffer = new DataByteArrayOutputStream();
    }

    public synchronized DataItem storeItem(Marshaller marshaller, Object payload, byte type) throws IOException {
        this.buffer.reset();
        this.buffer.position(5);
        marshaller.writePayload(payload, this.buffer);
        int size2 = this.buffer.size();
        int payloadSize = size2 - 5;
        this.buffer.reset();
        this.buffer.writeByte(type);
        this.buffer.writeInt(payloadSize);
        DataItem item = new DataItem();
        item.setSize(payloadSize);
        DataFile dataFile = this.dataManager.findSpaceForData(item);
        dataFile.getRandomAccessFile().seek(item.getOffset());
        dataFile.getRandomAccessFile().write(this.buffer.getData(), 0, size2);
        dataFile.setWriterData(Boolean.TRUE);
        this.dataManager.addInterestInFile(dataFile);
        return item;
    }

    public synchronized void updateItem(DataItem item, Marshaller marshaller, Object payload, byte type) throws IOException {
        this.buffer.reset();
        this.buffer.position(5);
        marshaller.writePayload(payload, this.buffer);
        int size2 = this.buffer.size();
        int payloadSize = size2 - 5;
        this.buffer.reset();
        this.buffer.writeByte(type);
        this.buffer.writeInt(payloadSize);
        item.setSize(payloadSize);
        DataFile dataFile = this.dataManager.getDataFile(item);
        RandomAccessFile file = dataFile.getRandomAccessFile();
        file.seek(item.getOffset());
        file.write(this.buffer.getData(), 0, size2);
        dataFile.setWriterData(Boolean.TRUE);
    }

    public synchronized void force(DataFile dataFile) throws IOException {
        if (dataFile.getWriterData() != null && dataFile.isDirty()) {
            dataFile.getRandomAccessFile().getFD().sync();
            dataFile.setWriterData(null);
            dataFile.setDirty(false);
        }
    }

    public void close() throws IOException {
    }
}

