/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ManagementContext
implements Service {
    public static final String DEFAULT_DOMAIN = "org.apache.activemq";
    private static final Logger LOG = LoggerFactory.getLogger(ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = "org.apache.activemq";
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer;
    private boolean createConnector = true;
    private boolean findTigerMbeanServer = true;
    private String connectorHost = "localhost";
    private int connectorPort = 1099;
    private Map<String, ?> environment;
    private int rmiServerPort;
    private String connectorPath = "/jmxrmi";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean connectorStarting = new AtomicBoolean(false);
    private JMXConnectorServer connectorServer;
    private ObjectName namingServiceObjectName;
    private Registry registry;
    private final Map<ObjectName, ObjectName> registeredMBeanNames = new ConcurrentHashMap<ObjectName, ObjectName>();
    private boolean allowRemoteAddressInMBeanNames = true;
    private String brokerName;

    public ManagementContext() {
        this(null);
    }

    public ManagementContext(MBeanServer server) {
        this.beanServer = server;
    }

    @Override
    public void start() throws IOException {
        if (this.started.compareAndSet(false, true)) {
            if (this.connectorHost == null) {
                this.connectorHost = "localhost";
            }
            this.getMBeanServer();
            if (this.connectorServer != null) {
                try {
                    if (this.getMBeanServer().isRegistered(this.namingServiceObjectName)) {
                        LOG.debug("Invoking start on mbean: {}", this.namingServiceObjectName);
                        this.getMBeanServer().invoke(this.namingServiceObjectName, "start", null, null);
                    }
                }
                catch (Throwable ignore) {
                    LOG.debug("Error invoking start on mbean " + this.namingServiceObjectName + ". This exception is ignored.", ignore);
                }
                Thread t = new Thread("JMX connector"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block10: {
                            if (ManagementContext.this.brokerName != null) {
                                MDC.put("activemq.broker", ManagementContext.this.brokerName);
                            }
                            try {
                                JMXConnectorServer server = ManagementContext.this.connectorServer;
                                if (!ManagementContext.this.started.get() || server == null) break block10;
                                LOG.debug("Starting JMXConnectorServer...");
                                ManagementContext.this.connectorStarting.set(true);
                                try {
                                    MDC.remove("activemq.broker");
                                    server.start();
                                }
                                finally {
                                    if (ManagementContext.this.brokerName != null) {
                                        MDC.put("activemq.broker", ManagementContext.this.brokerName);
                                    }
                                    ManagementContext.this.connectorStarting.set(false);
                                }
                                LOG.info("JMX consoles can connect to " + server.getAddress());
                            }
                            catch (IOException e) {
                                LOG.warn("Failed to start jmx connector: " + e.getMessage() + ". Will restart management to re-create jmx connector, trying to remedy this issue.");
                                LOG.debug("Reason for failed jmx connector start", e);
                            }
                            finally {
                                MDC.remove("activemq.broker");
                            }
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.started.compareAndSet(true, false)) {
            ArrayList<MBeanServer> list;
            MBeanServer mbeanServer = this.getMBeanServer();
            if (mbeanServer != null) {
                for (Map.Entry<ObjectName, ObjectName> entry : this.registeredMBeanNames.entrySet()) {
                    ObjectName actualName = entry.getValue();
                    if (actualName == null || !this.beanServer.isRegistered(actualName)) continue;
                    LOG.debug("Unregistering MBean {}", actualName);
                    mbeanServer.unregisterMBean(actualName);
                }
            }
            this.registeredMBeanNames.clear();
            JMXConnectorServer server = this.connectorServer;
            this.connectorServer = null;
            if (server != null) {
                try {
                    if (!this.connectorStarting.get()) {
                        LOG.debug("Stopping jmx connector");
                        server.stop();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to stop jmx connector: " + e.getMessage());
                }
                try {
                    if (this.namingServiceObjectName != null && this.getMBeanServer().isRegistered(this.namingServiceObjectName)) {
                        LOG.debug("Stopping MBean {}", this.namingServiceObjectName);
                        this.getMBeanServer().invoke(this.namingServiceObjectName, "stop", null, null);
                        LOG.debug("Unregistering MBean {}", this.namingServiceObjectName);
                        this.getMBeanServer().unregisterMBean(this.namingServiceObjectName);
                    }
                }
                catch (Throwable ignore) {
                    LOG.warn("Error stopping and unregsitering mbean " + this.namingServiceObjectName + " due " + ignore.getMessage());
                }
                this.namingServiceObjectName = null;
            }
            if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
                LOG.debug("Releasing MBeanServer {}", this.beanServer);
                MBeanServerFactory.releaseMBeanServer(this.beanServer);
            }
            this.beanServer = null;
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
                LOG.debug("Unexported JMX RMI Registry");
            }
            catch (NoSuchObjectException e) {
                LOG.debug("Error occurred while unexporting JMX RMI registry. This exception will be ignored.");
            }
            this.registry = null;
        }
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    protected MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public void setMBeanServer(MBeanServer beanServer) {
        this.beanServer = beanServer;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public boolean isFindTigerMbeanServer() {
        return this.findTigerMbeanServer;
    }

    public boolean isConnectorStarted() {
        return this.connectorStarting.get() || this.connectorServer != null && this.connectorServer.isActive();
    }

    public void setFindTigerMbeanServer(boolean findTigerMbeanServer) {
        this.findTigerMbeanServer = findTigerMbeanServer;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + ManagementContext.sanitizeString(type) + ",name=" + ManagementContext.sanitizeString(name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Couldn't create ObjectName from: " + type + " , " + name);
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class<?> theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + ManagementContext.getRelativeName(containerName, theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class<?> theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public Object newProxyInstance(ObjectName objectName, Class<?> interfaceClass, boolean notificationBroadcaster) {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServer(), objectName, interfaceClass, notificationBroadcaster);
    }

    public Object getAttribute(ObjectName name, String attribute) throws Exception {
        return this.getMBeanServer().getAttribute(name, attribute);
    }

    public ObjectInstance registerMBean(Object bean, ObjectName name) throws Exception {
        ObjectInstance result = this.getMBeanServer().registerMBean(bean, name);
        this.registeredMBeanNames.put(name, result.getObjectName());
        return result;
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws Exception {
        ObjectName actualName;
        if (name != null && (actualName = this.registeredMBeanNames.get(name)) != null) {
            return this.getMBeanServer().queryNames(actualName, query);
        }
        return this.getMBeanServer().queryNames(name, query);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.getMBeanServer().getObjectInstance(name);
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        ObjectName actualName = this.registeredMBeanNames.get(name);
        if (this.beanServer != null && actualName != null && this.beanServer.isRegistered(actualName) && this.registeredMBeanNames.remove(name) != null) {
            LOG.debug("Unregistering MBean {}", actualName);
            this.beanServer.unregisterMBean(actualName);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            if (this.useMBeanServer) {
                ArrayList<MBeanServer> list;
                if (this.findTigerMbeanServer) {
                    result = this.findTigerMBeanServer();
                }
                if (result == null && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                    result = (MBeanServer)list.get(0);
                }
            }
            if (result == null && this.createMBeanServer) {
                result = this.createMBeanServer();
            }
        }
        catch (NoClassDefFoundError e) {
            LOG.error("Could not load MBeanServer", e);
        }
        catch (Throwable e) {
            LOG.error("Failed to initialize MBeanServer", e);
        }
        return result;
    }

    public MBeanServer findTigerMBeanServer() {
        block7: {
            String name = "java.lang.management.ManagementFactory";
            Class<?> type = ManagementContext.loadClass(name, ManagementContext.class.getClassLoader());
            if (type != null) {
                try {
                    Method method = type.getMethod("getPlatformMBeanServer", new Class[0]);
                    if (method != null) {
                        Object answer = method.invoke(null, new Object[0]);
                        if (answer instanceof MBeanServer) {
                            if (this.createConnector) {
                                this.createConnector((MBeanServer)answer);
                            }
                            return (MBeanServer)answer;
                        }
                        LOG.warn("Could not cast: " + answer + " into an MBeanServer. There must be some classloader strangeness in town");
                        break block7;
                    }
                    LOG.warn("Method getPlatformMBeanServer() does not appear visible on type: " + type.getName());
                }
                catch (Exception e) {
                    LOG.warn("Failed to call getPlatformMBeanServer() due to: " + e, e);
                }
            } else {
                LOG.trace("Class not found: " + name + " so probably running on Java 1.4");
            }
        }
        return null;
    }

    private static Class<?> loadClass(String name, ClassLoader loader) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    protected MBeanServer createMBeanServer() throws MalformedObjectNameException, IOException {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
        this.locallyCreateMBeanServer = true;
        if (this.createConnector) {
            this.createConnector(mbeanServer);
        }
        return mbeanServer;
    }

    private void createConnector(MBeanServer mbeanServer) throws MalformedObjectNameException, IOException {
        try {
            if (this.registry == null) {
                LOG.debug("Creating RMIRegistry on port {}", this.connectorPort);
                this.registry = LocateRegistry.createRegistry(this.connectorPort);
            }
            this.namingServiceObjectName = ObjectName.getInstance("naming:type=rmiregistry");
            Class<?> cl = Class.forName("mx4j.tools.naming.NamingService");
            mbeanServer.registerMBean(cl.newInstance(), this.namingServiceObjectName);
            Attribute attr = new Attribute("Port", this.connectorPort);
            mbeanServer.setAttribute(this.namingServiceObjectName, attr);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Probably not using JRE 1.4: " + e.getLocalizedMessage());
        }
        catch (Throwable e) {
            LOG.debug("Failed to create local registry. This exception will be ignored.", e);
        }
        String rmiServer = "";
        if (this.rmiServerPort != 0) {
            rmiServer = "" + this.getConnectorHost() + ":" + this.rmiServerPort;
        }
        String serviceURL = "service:jmx:rmi://" + rmiServer + "/jndi/rmi://" + this.getConnectorHost() + ":" + this.connectorPort + this.connectorPath;
        JMXServiceURL url = new JMXServiceURL(serviceURL);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, this.environment, mbeanServer);
        LOG.debug("Created JMXConnectorServer {}", this.connectorServer);
    }

    public String getConnectorPath() {
        return this.connectorPath;
    }

    public void setConnectorPath(String connectorPath) {
        this.connectorPath = connectorPath;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public int getRmiServerPort() {
        return this.rmiServerPort;
    }

    public void setRmiServerPort(int rmiServerPort) {
        this.rmiServerPort = rmiServerPort;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }

    public String getConnectorHost() {
        return this.connectorHost;
    }

    public void setConnectorHost(String connectorHost) {
        this.connectorHost = connectorHost;
    }

    public Map<String, ?> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, ?> environment) {
        this.environment = environment;
    }

    public boolean isAllowRemoteAddressInMBeanNames() {
        return this.allowRemoteAddressInMBeanNames;
    }

    public void setAllowRemoteAddressInMBeanNames(boolean allowRemoteAddressInMBeanNames) {
        this.allowRemoteAddressInMBeanNames = allowRemoteAddressInMBeanNames;
    }
}

