/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.virtual;

import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.apache.activemq.util.LRUCache;

public class VirtualTopicInterceptor
extends DestinationFilter {
    private String prefix;
    private String postfix;
    private boolean local;
    private LRUCache<ActiveMQDestination, ActiveMQQueue> cache = new LRUCache();

    public VirtualTopicInterceptor(Destination next, String prefix, String postfix, boolean local) {
        super(next);
        this.prefix = prefix;
        this.postfix = postfix;
        this.local = local;
    }

    @Override
    public void send(ProducerBrokerExchange context, Message message) throws Exception {
        if (!(message.isAdvisory() || this.local && message.getBrokerPath() != null)) {
            ActiveMQDestination queueConsumers = this.getQueueConsumersWildcard(message.getDestination());
            this.send(context, message, queueConsumers);
        }
        super.send(context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActiveMQDestination getQueueConsumersWildcard(ActiveMQDestination original) {
        ActiveMQQueue queue;
        LRUCache<ActiveMQDestination, ActiveMQQueue> lRUCache = this.cache;
        synchronized (lRUCache) {
            queue = (ActiveMQQueue)this.cache.get((Object)original);
            if (queue == null) {
                queue = new ActiveMQQueue(this.prefix + original.getPhysicalName() + this.postfix);
                this.cache.put((Object)original, (Object)queue);
            }
        }
        return queue;
    }
}

