/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import java.util.Vector;

public class BufferedRandomFileInputStream
extends InputStream {
    private long currentReadPosition = 0L;
    private RandomAccessFile below = null;
    private long fileLength = 0L;
    private int blocksize = 8192;
    private int maxblocks = 20;
    private Vector buffervector = null;
    private BufferEntry current = null;

    public BufferedRandomFileInputStream(File file) throws IOException {
        this(file.getPath());
    }

    public BufferedRandomFileInputStream(File file, int numblocks) throws IOException {
        this(file);
        this.maxblocks = numblocks;
    }

    public BufferedRandomFileInputStream(File file, int numblocks, int blocklen) throws IOException {
        this(file);
        this.maxblocks = numblocks;
        this.blocksize = blocklen;
    }

    public BufferedRandomFileInputStream(String name) throws IOException {
        this.below = new RandomAccessFile(name, "r");
        this.fileLength = this.below.length();
        this.currentReadPosition = -1L;
        this.buffervector = new Vector();
    }

    public BufferedRandomFileInputStream(String name, int numblocks) throws IOException {
        this(name);
        this.maxblocks = numblocks;
    }

    public BufferedRandomFileInputStream(String name, int numblocks, int blocklen) throws IOException {
        this(name);
        this.blocksize = blocklen;
        this.maxblocks = numblocks;
    }

    public int available() {
        if (this.currentReadPosition == -1L) {
            return 0;
        }
        if (this.currentReadPosition >= this.fileLength) {
            return 0;
        }
        return (int)((long)this.current.length - (this.currentReadPosition - this.current.startPosition));
    }

    public void close() throws IOException {
        this.below.close();
        this.below = null;
        this.buffervector = null;
    }

    public long getFilePointer() {
        if (this.currentReadPosition == -1L) {
            return 0L;
        }
        return this.currentReadPosition;
    }

    public long length() {
        return this.fileLength;
    }

    public static void main(String[] argv) {
        Random r = new Random();
        String filename = "scratchfile.for.test";
        try {
            int n;
            System.out.println("Creating testfile " + filename + ".");
            BufferedOutputStream of = new BufferedOutputStream(new FileOutputStream(filename));
            int i = 0;
            while (i < 409600) {
                of.write(i & 0xFF);
                ++i;
            }
            of.close();
            System.out.println("Starting random access.");
            BufferedRandomFileInputStream raf = new BufferedRandomFileInputStream(filename);
            long fileLength = raf.length();
            System.out.println("Opened file " + filename + ", size is " + fileLength);
            int count = 0;
            int i2 = 0;
            while (i2 < 200) {
                long pos = (long)(r.nextFloat() * (float)fileLength);
                raf.seek(pos);
                n = raf.read();
                if ((pos & 0xFFL) != (long)n) {
                    System.out.println("Bad match at " + pos + ", got " + n + "/" + (pos & 0xFFL));
                } else {
                    ++count;
                }
                ++i2;
            }
            System.out.println("Seeking worked at " + count + " positions.");
            byte[] buf = new byte[1234];
            count = 0;
            raf.seek(0L);
            of = new BufferedOutputStream(new FileOutputStream(String.valueOf(filename) + ".copy"));
            while ((n = raf.read(buf)) > 0) {
                of.write(buf, 0, n);
                ++count;
            }
            of.close();
            System.out.println("Copied file in " + count + " chunks (" + fileLength / 1234L + ")");
        }
        catch (IOException e) {
            System.out.println("Oops, exception " + e);
        }
    }

    public int read() throws IOException {
        if (this.currentReadPosition == -1L) {
            this.seek(0L);
        }
        if (this.currentReadPosition >= this.fileLength) {
            return -1;
        }
        if (this.currentReadPosition >= this.current.startPosition + (long)this.current.length) {
            this.seek(this.currentReadPosition);
        }
        byte data = this.current.buffer[(int)(this.currentReadPosition - this.current.startPosition)];
        ++this.currentReadPosition;
        return data & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toread;
        int returncode = -1;
        if (this.currentReadPosition == -1L) {
            this.seek(0L);
        }
        if (this.currentReadPosition >= this.fileLength) {
            return -1;
        }
        if (this.currentReadPosition >= this.current.startPosition + (long)this.current.length) {
            this.seek(this.currentReadPosition);
        }
        if (len < (toread = (int)((long)this.current.length - (this.currentReadPosition - this.current.startPosition)))) {
            toread = len;
        }
        if (off + b.length < toread) {
            toread = b.length - off;
        }
        System.arraycopy(this.current.buffer, (int)(this.currentReadPosition - this.current.startPosition), b, off, toread);
        this.currentReadPosition += (long)toread;
        return toread;
    }

    public void seek(long pos) throws IOException {
        long startPosition = pos / (long)this.blocksize * (long)this.blocksize;
        boolean notfound = true;
        if (pos < 0L) {
            throw new IOException("invalid position " + pos + " for seek");
        }
        int i = 0;
        while (i < this.buffervector.size()) {
            if (((BufferEntry)this.buffervector.elementAt((int)i)).startPosition == startPosition) {
                this.current = (BufferEntry)this.buffervector.elementAt(i);
                this.buffervector.removeElementAt(i);
                this.buffervector.insertElementAt(this.current, 0);
                notfound = false;
                break;
            }
            ++i;
        }
        if (notfound) {
            if (this.buffervector.size() >= this.maxblocks) {
                this.current = (BufferEntry)this.buffervector.elementAt(this.buffervector.size() - 1);
                this.buffervector.removeElementAt(this.buffervector.size() - 1);
            } else {
                this.current = new BufferEntry();
                this.current.buffer = new byte[this.blocksize];
            }
            this.current.startPosition = startPosition;
            this.below.seek(startPosition);
            int readlength = this.blocksize;
            if (startPosition + (long)readlength > this.fileLength) {
                readlength = (int)(this.fileLength - startPosition);
            }
            this.current.length = readlength;
            this.below.readFully(this.current.buffer, 0, readlength);
            this.buffervector.insertElementAt(this.current, 0);
        }
        this.currentReadPosition = pos;
    }

    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        if (this.currentReadPosition == -1L) {
            this.seek(0L);
        }
        this.currentReadPosition += n;
        if (this.currentReadPosition > this.fileLength) {
            n -= this.currentReadPosition - this.fileLength;
            this.currentReadPosition = this.fileLength;
        }
        return n;
    }

    private class BufferEntry {
        long startPosition;
        int length;
        byte[] buffer;

        BufferEntry() {
        }
    }
}

