/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pp4;

import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInputStream;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFOutputStream;
import de.tu_darmstadt.sp.paul.PDFReal;
import de.tu_darmstadt.sp.paul.PDFStream;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.pencil.CommandChanger;
import de.tu_darmstadt.sp.pencil.EnsureStatus;
import de.tu_darmstadt.sp.pencil.PageCommand;
import de.tu_darmstadt.sp.pencil.PageDescription;
import de.tu_darmstadt.sp.pencil.PositionTracker;
import de.tu_darmstadt.sp.pencil.commands.DoCmd;
import de.tu_darmstadt.sp.pencil.commands.QCmd;
import de.tu_darmstadt.sp.pencil.commands.cmCmd;
import de.tu_darmstadt.sp.pencil.commands.qCmd;
import de.tu_darmstadt.sp.pp4.Chunk;
import de.tu_darmstadt.sp.pp4.PP4Exception;
import de.tu_darmstadt.sp.pudl.Document;
import de.tu_darmstadt.sp.pudl.Page;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class PP4Chunks {
    private Chunk chunk = new Chunk();
    private PDFStream bgStream = null;
    private PDFDictionary xDict = null;
    private CommandChanger colorChanger1 = null;
    private CommandChanger colorChanger2 = null;
    private Document inpdf;
    private PDFArray destNames;
    private String number;
    private int count;
    private boolean build = true;
    private boolean trace = false;
    private LinkedList chunks = null;
    private int prevlevel = 0;
    private int prevnumber = 0;
    private EnsureStatus statusKeeper = null;
    private AffineTransform curat = null;
    private PDFDictionary transition = null;
    private int minLevel = 0;
    private int maxLevel = 0;
    private int compress = 9;
    private int currLevel = 1;
    private int currIncr = 1;
    private int currEnd = 0;

    public PP4Chunks(Document inPdf, PDFArray destnames, int compresslevel) {
        this.inpdf = inPdf;
        this.destNames = destnames;
        this.compress = compresslevel;
        this.reset();
    }

    public void addArguments(String argums) {
        this.chunk.transition = this.makeTransition(argums);
    }

    public void addBG(PDFStream stream) {
        this.bgStream = stream;
    }

    public void addColorChange(PageCommand col, PageCommand normal, PageCommand high) {
        if (this.colorChanger1 == null) {
            this.colorChanger1 = new CommandChanger();
            this.colorChanger2 = new CommandChanger();
        }
        this.colorChanger1.addChange(col, normal);
        this.colorChanger2.addChange(col, high);
    }

    public void addNumber(String curnum) {
        this.number = curnum;
    }

    public void addStream(Page thepage, StringBuffer streambuf) {
        this.chunk.level = this.currLevel;
        if (this.currLevel > this.maxLevel) {
            this.maxLevel = this.currLevel;
        }
        if (this.currLevel < this.minLevel) {
            this.minLevel = this.currLevel;
        }
        this.chunk.endlevel = this.currEnd;
        this.currLevel += this.currIncr;
        this.currEnd = 0;
        this.statusKeeper.resetColor();
        PositionTracker posTrack = new PositionTracker();
        PageDescription pageContents = null;
        try {
            pageContents = new PageDescription(new StringReader(streambuf.toString()));
            if (this.curat != null) {
                pageContents.addCommand(0, new cmCmd(this.curat));
            }
            pageContents.addCommand(0, new qCmd());
            pageContents.accept(posTrack);
        }
        catch (Exception e) {
            System.out.print(e.toString());
        }
        this.curat = posTrack.getCurCM();
        pageContents.addCommand(new QCmd());
        pageContents.accept(this.statusKeeper);
        pageContents = this.statusKeeper.getResult();
        if (this.colorChanger1 == null) {
            this.chunk.normal = this.makeStream(pageContents);
            this.chunk.highlighted = null;
        } else {
            PDFObject o;
            if (this.xDict == null && (o = thepage.getAttribute(PDFName.RESOURCES)) != null && o instanceof PDFDictionary && (o = ((PDFDictionary)o).get(PDFName.XOBJECT)) != null && o instanceof PDFDictionary) {
                this.xDict = (PDFDictionary)o;
            }
            if (this.xDict != null) {
                ListIterator commandList = pageContents.getIterator();
                while (commandList.hasNext()) {
                    PageCommand p = (PageCommand)commandList.next();
                    if (!(p instanceof DoCmd)) continue;
                    PDFName thisXObj = ((DoCmd)p).getArgument();
                    PDFObject xo = this.xDict.get(thisXObj);
                    Object typ = null;
                    PDFObject subtyp = null;
                    PDFDictionary xd = null;
                    PDFDictionary d2 = null;
                    if (xo != null && xo instanceof PDFStream) {
                        xd = ((PDFStream)xo).getDictionary();
                        typ = xd.get(PDFName.TYPE);
                        subtyp = xd.get(PDFName.SUBTYPE);
                        d2 = (PDFDictionary)xd.get(PDFName.RESOURCES);
                    }
                    if (typ == null || !(typ instanceof PDFName) || !typ.equals(PDFName.XOBJECT) || !(subtyp instanceof PDFName) || !subtyp.equals(PDFName.forString("Form")) || d2 == null || d2.get(PDFName.forString("XObject")) != null || d2.get(PDFName.forString("ExtGState")) != null || d2.get(PDFName.forString("Font")) != null) continue;
                    commandList.set(new qCmd());
                    try {
                        PDFArray pa = (PDFArray)xd.get("Matrix");
                        PageDescription xObjContents = new PageDescription(((PDFInputStream)xo).getInputStream());
                        if (pa != null) {
                            commandList.add(new cmCmd(new PDFReal(pa.get(0).toString()), new PDFReal(pa.get(1).toString()), new PDFReal(pa.get(2).toString()), new PDFReal(pa.get(3).toString()), new PDFReal(pa.get(4).toString()), new PDFReal(pa.get(5).toString())));
                        }
                        ListIterator xObjList = xObjContents.getIterator();
                        while (xObjList.hasNext()) {
                            commandList.add((PageCommand)xObjList.next());
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("Could not embed XObject " + thisXObj);
                    }
                    commandList.add(new QCmd());
                }
            }
            pageContents.accept(this.colorChanger1);
            pageContents.accept(this.colorChanger2);
            this.chunk.normal = this.makeStream(this.colorChanger1.getResult());
            this.chunk.highlighted = this.makeStream(this.colorChanger2.getResult());
        }
    }

    public void doBuild() {
        this.build = true;
    }

    public void doFlip() {
        this.build = false;
    }

    private void dump() {
        Chunk thischunk = null;
        ListIterator iter = this.chunks.listIterator();
        System.out.println("Chunks from " + this.minLevel + " to " + this.maxLevel + ":");
        while (iter.hasNext()) {
            thischunk = (Chunk)iter.next();
            while (thischunk != null) {
                System.out.println(String.valueOf(thischunk.level) + " " + thischunk.endlevel + " " + thischunk.appear + " " + thischunk.highlight);
                thischunk = thischunk.next;
            }
        }
    }

    private PDFOutputStream makeStream(PageDescription pd) {
        PDFOutputStream os = new PDFOutputStream();
        if (this.compress > 0) {
            os.setFilter(PDFName.FLATEDECODE);
        }
        OutputStream out = os.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(out);
        try {
            pd.write(osw);
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        os.closeOutputStream();
        return os;
    }

    private PDFDictionary makeTransition(String pageArguments) {
        String subType;
        PDFDictionary transition = new PDFDictionary();
        int parStartPos = 0;
        int parEndPos = pageArguments.indexOf(44);
        int index = -1;
        String[] param = new String[3];
        if (parEndPos < 0) {
            subType = pageArguments;
        } else {
            subType = pageArguments.substring(0, parEndPos);
            parStartPos = parEndPos + 1;
            index = -1;
            while (parStartPos > 0) {
                parEndPos = pageArguments.indexOf(44, parStartPos);
                if (index < 2) {
                    param[++index] = parEndPos < 0 ? pageArguments.substring(parStartPos) : pageArguments.substring(parStartPos, parEndPos);
                }
                parStartPos = parEndPos + 1;
            }
        }
        if (subType != null && subType.length() > 0) {
            transition.put(PDFName.forString("S"), (PDFObject)PDFName.forString(subType));
        }
        int defIndex = -1;
        if (subType.compareTo("Split") == 0) {
            defIndex = 1;
            if (index < 1 || param[0].length() < 1 || param[1].length() < 1) {
                System.out.println("Warning: missing argument: " + pageArguments + ".");
                return null;
            }
            transition.put(PDFName.forString("Dm"), (PDFObject)PDFName.forString(param[0]));
            transition.put(PDFName.forString("M"), (PDFObject)PDFName.forString(param[1]));
        } else if (subType.compareTo("Box") == 0) {
            defIndex = 0;
            if (index < 0 || param[0].length() < 1) {
                System.out.println("Warning: missing argument: " + pageArguments + ".");
                return null;
            }
            transition.put(PDFName.forString("M"), (PDFObject)PDFName.forString(param[0]));
        } else if (subType.compareTo("Blinds") == 0) {
            defIndex = 0;
            if (index < 0 || param[0].length() < 1) {
                System.out.println("Warning: missing argument: " + pageArguments + ".");
                return null;
            }
            transition.put(PDFName.forString("Dm"), (PDFObject)PDFName.forString(param[0]));
        } else if (subType.compareTo("Glitter") == 0 || subType.compareTo("Wipe") == 0) {
            defIndex = 0;
            if (index < 0 || param[0].length() < 1) {
                System.out.println("Warning: missing argument: " + pageArguments + ".");
                return null;
            }
            try {
                transition.put(PDFName.forString("Di"), (PDFObject)new PDFReal(param[0]));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Warning: expected number, got " + param[0]);
            }
        } else if (subType.compareTo("Dissolve") != 0 && subType.compareTo("Replace") != 0) {
            System.out.println("Warning: Unknown transition effect: " + pageArguments + ".");
            return null;
        }
        if (index > defIndex) {
            try {
                transition.put(PDFName.forString("D"), (PDFObject)new PDFReal(param[defIndex + 1]));
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Warning: expected number, got " + param[index]);
            }
            if (index > defIndex + 1) {
                System.out.println("Warning: too many arguments for " + subType);
            }
        }
        return transition;
    }

    public void next() {
        ++this.count;
        this.chunks.add(this.chunk);
        this.chunk = new Chunk();
    }

    private void putPageDestNum(Page page, String number) {
        if (this.destNames == null) {
            return;
        }
        if (page == null) {
            return;
        }
        PDFDictionary dict = new PDFDictionary();
        PDFArray entries = new PDFArray();
        dict.put("D", (PDFObject)entries);
        dict.setIndirect();
        entries.add(page.getRepresentation());
        entries.add(PDFName.forString("XYZ"));
        entries.add(new PDFReal(0));
        entries.add(new PDFReal(0));
        entries.add(PDFObject.NULL);
        int numelem = this.destNames.size();
        int inx = 0;
        while (inx < numelem) {
            PDFObject o = this.destNames.get(inx);
            if (o instanceof PDFTextString && ((PDFTextString)o).toString().equals(number)) {
                this.destNames.remove(inx + 1);
                this.destNames.add(inx + 1, dict);
                return;
            }
            inx += 2;
        }
    }

    private boolean putchunks(Page newPage, int level) {
        boolean foundAny = false;
        int curnumber = 0;
        Chunk thischunk = null;
        newPage.removeAllStreams();
        if (this.bgStream != null) {
            newPage.addStream(this.bgStream);
        }
        ListIterator iter = this.chunks.listIterator();
        while (iter.hasNext()) {
            Chunk curChunk = thischunk = (Chunk)iter.next();
            while (curChunk != null) {
                if (curChunk.level == level) {
                    foundAny = true;
                    if (this.trace) {
                        System.out.print("> ");
                    }
                    if (thischunk.transition == null) break;
                    this.transition = thischunk.transition;
                    break;
                }
                curChunk = curChunk.next;
            }
            curChunk = thischunk;
            PDFOutputStream curstream = null;
            if (this.trace) {
                System.out.println("check " + thischunk.level + " at " + level);
            }
            if (this.build) {
                boolean hasHighlight = thischunk.hasHighlight();
                while (curChunk != null) {
                    if (curChunk.highlight && thischunk.highlighted != null) {
                        if (curChunk.level == level && curChunk.endlevel == 0 || curChunk.level <= level && curChunk.endlevel >= level) {
                            curstream = thischunk.highlighted;
                            break;
                        }
                        if (thischunk.next == null) {
                            curstream = thischunk.normal;
                            break;
                        }
                    } else if (curChunk.level <= level && (curChunk.endlevel == 0 || curChunk.endlevel >= level)) {
                        curstream = curChunk.level == level && !hasHighlight && thischunk.highlighted != null ? thischunk.highlighted : thischunk.normal;
                        break;
                    }
                    curChunk = curChunk.next;
                }
            } else {
                boolean hasBuild = thischunk.hasBuild();
                while (curChunk != null) {
                    if (curChunk.appear) {
                        if (curChunk.level <= level && (curChunk.endlevel == 0 || curChunk.endlevel >= level)) {
                            if (this.trace) {
                                System.out.println("norm " + curChunk.level + " at " + level);
                            }
                            curstream = thischunk.normal;
                            break;
                        }
                    } else {
                        if (curChunk.level == level && curChunk.endlevel == 0 || curChunk.level <= level && curChunk.endlevel >= level) {
                            if (this.trace) {
                                System.out.println("high " + curChunk.level + " at " + level);
                            }
                            curstream = thischunk.highlighted;
                            break;
                        }
                        if (curChunk.next == null && !hasBuild) {
                            if (this.trace) {
                                System.out.println("dflt " + curChunk.level + " at " + level);
                            }
                            curstream = thischunk.normal;
                            break;
                        }
                    }
                    curChunk = curChunk.next;
                }
            }
            if (curstream == null) continue;
            newPage.addStream(curstream);
            ++curnumber;
        }
        if (this.transition != null) {
            this.setTransition(newPage, this.transition);
        }
        if (!foundAny) {
            foundAny = level > this.prevlevel & curnumber < this.prevnumber;
        }
        this.prevnumber = curnumber;
        this.prevlevel = level;
        return foundAny;
    }

    private void reset() {
        this.number = null;
        this.count = 1;
        this.minLevel = Short.MAX_VALUE;
        this.maxLevel = 0;
        this.transition = null;
        this.chunks = new LinkedList();
        this.curat = null;
        this.currLevel = 1;
        this.currIncr = 1;
        this.currEnd = 0;
        this.statusKeeper = new EnsureStatus();
        this.xDict = null;
    }

    public void resetColorChange() {
        this.colorChanger1 = null;
        this.colorChanger2 = null;
    }

    private int scanValue(StringTokenizer st, String t, int index) throws PP4Exception {
        int num;
        block4: {
            num = -1;
            int len = t.length();
            try {
                if (len > index) {
                    num = Integer.valueOf(t.substring(index));
                    break block4;
                }
                if (st.hasMoreTokens()) {
                    t = st.nextToken();
                    num = Integer.valueOf(t);
                    break block4;
                }
                throw new PP4Exception("Incomplete specification: ");
            }
            catch (NumberFormatException numberFormatException) {
                throw new PP4Exception("Bad format " + t + " : ");
            }
        }
        return num;
    }

    public void setLevel(String arguments) throws PP4Exception {
        int start = 0;
        int startLevel = this.currLevel;
        while (start >= 0) {
            String section;
            int oldstart = start;
            if (oldstart > 0) {
                if (this.trace) {
                    System.out.println("make additional entry (" + startLevel + ") " + this.currLevel + "/" + this.currEnd);
                }
                this.chunk.level = this.currLevel;
                this.chunk.endlevel = this.currEnd;
                Chunk old = this.chunk;
                this.chunk = new Chunk();
                this.chunk.transition = old.transition;
                this.chunk.next = old;
                ++this.count;
            }
            if ((start = arguments.indexOf(44, oldstart)) > 0) {
                section = arguments.substring(oldstart, start);
                ++start;
            } else {
                section = oldstart == 0 ? arguments : arguments.substring(oldstart);
            }
            StringTokenizer st = new StringTokenizer(section, " \t\n\r\f");
            this.currEnd = 0;
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.equals("traceoff")) {
                    this.trace = false;
                    continue;
                }
                if (t.equals("traceon")) {
                    this.trace = true;
                    continue;
                }
                if (t.equals("build")) {
                    this.chunk.appear = true;
                    continue;
                }
                if (t.equals("highlight")) {
                    this.chunk.highlight = true;
                    continue;
                }
                try {
                    if (t.startsWith("=+")) {
                        this.currLevel = startLevel + this.scanValue(st, t, 2);
                        if (this.currLevel > this.maxLevel) {
                            this.maxLevel = this.currLevel;
                        }
                        if (this.currLevel >= this.minLevel) continue;
                        this.minLevel = this.currLevel;
                        continue;
                    }
                    if (t.startsWith("=-")) {
                        this.currLevel = startLevel - this.scanValue(st, t, 2);
                        if (this.currLevel < 1) {
                            this.currLevel = 1;
                        }
                        if (this.currLevel >= this.minLevel) continue;
                        this.minLevel = this.currLevel;
                        continue;
                    }
                    if (t.startsWith("=")) {
                        this.currLevel = this.scanValue(st, t, 1);
                        if (this.currLevel > this.maxLevel) {
                            this.maxLevel = this.currLevel;
                        }
                        if (this.currLevel >= this.minLevel) continue;
                        this.minLevel = this.currLevel;
                        continue;
                    }
                    if (t.startsWith(":+")) {
                        this.currEnd = startLevel + this.scanValue(st, t, 2);
                        if (this.currEnd <= this.maxLevel) continue;
                        this.maxLevel = this.currEnd;
                        continue;
                    }
                    if (t.startsWith(":-")) {
                        this.currEnd = startLevel - this.scanValue(st, t, 2);
                        if (this.currEnd >= 0) continue;
                        this.currEnd = 0;
                        continue;
                    }
                    if (t.startsWith(":")) {
                        this.currEnd = this.scanValue(st, t, 1);
                        continue;
                    }
                    if (t.startsWith("+")) {
                        this.currIncr = this.scanValue(st, t, 1);
                        continue;
                    }
                    if (t.startsWith("-")) {
                        this.currIncr = -this.scanValue(st, t, 1);
                        continue;
                    }
                    this.currIncr = this.scanValue(st, t, 0);
                }
                catch (PP4Exception ppe) {
                    throw new PP4Exception(String.valueOf(ppe.getMessage()) + arguments);
                }
            }
        }
    }

    private void setTransition(Page page, PDFDictionary transition) {
        ((PDFDictionary)page.getRepresentation()).put(PDFName.TRANS, (PDFObject)transition);
    }

    public void write(Page page) {
        Page lastPage = null;
        Object thischunk = null;
        this.chunks.add(this.chunk);
        if (this.trace) {
            this.dump();
        }
        int num = this.minLevel;
        while (num < this.maxLevel) {
            Page newPage = new Page(page);
            if (this.putchunks(newPage, num)) {
                this.inpdf.addPage(newPage);
                if (lastPage == null && this.number != null) {
                    this.putPageDestNum(newPage, this.number);
                }
                lastPage = newPage;
            }
            ++num;
        }
        if (this.putchunks(page, this.maxLevel)) {
            this.inpdf.addPage(page);
        } else if (lastPage != null) {
            ListIterator iter = lastPage.getContents().listIterator();
            page.removeAllStreams();
            while (iter.hasNext()) {
                page.addStream((PDFStream)iter.next());
            }
            this.inpdf.addPage(page);
        }
        if (lastPage == null && this.number != null) {
            this.putPageDestNum(page, this.number);
        }
        this.reset();
    }
}

