/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul.filter;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCII85InputFilter
extends FilterInputStream {
    private int[] buf = new int[4];
    private int counter = 4;
    private int n = 4;

    public ASCII85InputFilter(InputStream in) {
        super(in);
    }

    private void fillbuffer() throws IOException {
        this.counter = 0;
        int[] readbuf = new int[4];
        int first = this.nwRead();
        if (first == 122) {
            this.buf[3] = 0;
            this.buf[2] = 0;
            this.buf[1] = 0;
            this.buf[0] = 0;
            return;
        }
        if (first == 126) {
            this.n = 0;
            this.nwRead();
            return;
        }
        int i = 0;
        while (i < 4) {
            readbuf[i] = this.nwRead();
            if (i != 3 && readbuf[i] == -1) {
                throw new EOFException("ASCII85: unexpected end of input");
            }
            ++i;
        }
        this.n = 1;
        while (this.n < 4) {
            if (readbuf[this.n] == 126) break;
            ++this.n;
        }
        int i2 = this.n + 2;
        while (i2 < 4) {
            readbuf[i2] = 33;
            ++i2;
        }
        if (first < 33 || first > 118) {
            System.err.println("WARNING" + first);
        }
        long help = (first - 33) * 85;
        int i3 = 0;
        while (i3 < 3) {
            help = (help + (long)(readbuf[i3] - 33)) * 85L;
            ++i3;
        }
        help += (long)(readbuf[3] - 33);
        int i4 = 3;
        while (i4 >= 0) {
            this.buf[i4] = (int)(help % 256L);
            help /= 256L;
            --i4;
        }
        if (this.n == 3) {
            this.nwRead();
        }
    }

    private int nwRead() throws IOException {
        int c = this.in.read();
        while (c != -1 && c != 122 && c != 126 && c != 62 && (c < 33 || c > 117)) {
            c = this.in.read();
        }
        return c;
    }

    public int read() throws IOException {
        if (this.counter == 4) {
            this.fillbuffer();
        }
        if (this.counter >= this.n) {
            return -1;
        }
        return this.buf[this.counter++];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    if (b != null) {
                        b[off + i] = (byte)c;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i;
    }
}

