;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; MSP430 - Generic I/O include
; Copyright 2010 - Michael Kohn
; http://www.mikekohn.net/
;
; This is a part of the naken430asm package.
; http://www.mikekohn.net/micro/naken430asm_msp430_assembler.php
;
; This define should be common for msp430g2x31 chips
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; SR
OSCOFF equ 32

;; SFR
IE1     equ 0x0000
IE2     equ 0x0001
IFG1    equ 0x0002
IFG2    equ 0x0003
ME1     equ 0x0004
ME2     equ 0x0005

;; Basic Clock
BCSCTL3 equ 0x0053
BCSCTL2 equ 0x0058
BCSCTL1 equ 0x0057
DCOCTL  equ 0x0056

XT2OFF  equ 128
XTS     equ 64
OFIFG   equ 2
SELS    equ 8
SELM_0  equ 0
SELM_1  equ 64
SELM_2  equ 128
SELM_3  equ 192

;; Port P1
P1IN    equ 0x0020
P1OUT   equ 0x0021
P1DIR   equ 0x0022
P1IFG   equ 0x0023
P1IES   equ 0x0024
P1IE    equ 0x0025
P1SEL   equ 0x0026

;; USI
USICTL0  equ 0x0078
USICTL1  equ 0x0079
USICKCTL equ 0x007a
USICNT   equ 0x007b
USISRL   equ 0x007c
USISRH   equ 0x007d

USIPE7   equ 128
USIPE6   equ 64
USIPE5   equ 32
USILSB   equ 16
USIMST   equ 8
USIGE    equ 4
USIOE    equ 2
USISWRST equ 1

USICKPH  equ 128
USII2C   equ 64
USISTTIE equ 32
USIIE    equ 16
USIAL    equ 8
USISTP   equ 4
USISTTIFG equ 2
USIIFG   equ 1

USIDIV_1 equ 0x00
USIDIV_2 equ 0x20
USIDIV_4 equ 0x40
USIDIV_8 equ 0x60
USIDIV_16 equ 0x80
USIDIV_32 equ 0xa0
USIDIV_64 equ 0xc0
USIDIV_128 equ 0xe0

USISSEL_0 equ 0x00
USISSEL_1 equ 0x04
USISSEL_2 equ 0x08
USISSEL_3 equ 0x0c
USISSEL_4 equ 0x10
USISSEL_5 equ 0x14
USISSEL_6 equ 0x18
USISSEL_7 equ 0x1c

USICKPL  equ 2
USISWCLK equ 1

USISCLREL equ 128
USI16B    equ 64
USIIFGCC  equ 32

;; Watchdog Timer
WDTPW   equ (0x5A<<8)
WDTHOLD equ (1<<7)
WDTCTL  equ 0x0120

;; Timer_A
TACTL   equ 0x0160
TAR     equ 0x0170
TACCTL0 equ 0x0162
TACCTL1 equ 0x0164
TACCTL2 equ 0x0166
TACCR0  equ 0x0172
TACCR1  equ 0x0174
TACCR2  equ 0x0176
TAIV    equ 0x012e

;; ADC10
ADC10AE   equ 0x004a
ADC10CTL0 equ 0x01b0
ADC10CTL1 equ 0x01b2
ADC10MEM  equ 0x01b4



