/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: taskswitch.h,v 1.3 2003/02/16 15:32:34 bad Exp $
 * **********************************************************/


/*
 * taskswitch.h
 *
 * Routines to switch back and forth between the host (module)
 * context and the monitor context. 
 *
 */


#ifndef _TASK_SWITCH_H
#define _TASK_SWITCH_H

#define INCLUDE_ALLOW_USERLEVEL
#define INCLUDE_ALLOW_MONITOR
#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"

#include "vm_asm.h"
#include "x86.h"



/*
 *----------------------------------------------------------------------
 *
 * SwitchToMonitor  --
 *
 *      Wrapper that calls code to switch from the host to the monitor.
 * 
 *      The wrapper ends with a long jump after having
 *      pushed EAX and EBX on the stack. Compensate for these
 *      two registers, and then for the retval and argument on
 *      on the stack
 *
 *      Note the dummy 4th argument on the stack compensates
 *      for the absence of segment information pushed on a 
 *      near jump. 
 *
 * Side effects:
 *      None for the module
 *
 * Bugs: EAX is caller-saved, no need to save/restore
 *       should use caller-saved EDX rather than EBX as temp
 *       (in task.c)
 *
 *
 *----------------------------------------------------------------------
 */


static INLINE void
SwitchToMonitor(char *codePtr,
                ContextInfo *src, 
                ContextInfo *dst,
                uint32 newDstVA)
{
   
#ifdef __GNUC__
   __asm__ __volatile("pushl %0" :: "r" (newDstVA) : "%esp", "memory");
   __asm__ __volatile("pushl %0" :: "r" (dst) : "%esp", "memory");
   __asm__ __volatile("pushl %0" :: "r" (src) : "%esp", "memory");
   __asm__ __volatile("pushl %0" :: "r" (0) : "%esp", "memory");
   __asm__ __volatile("call *%0" :: "r" (codePtr) : "%esp");
   __asm__ __volatile("popl %%ebx\n\t"
                      "popl %%eax\n\t"
                      "add $0x14,%%esp"::: "%esp"); /* 4 args + retval */
#elif _MSC_VER
   __asm push newDstVA
   __asm push dst
   __asm push src
     __asm xor esi,esi __asm push esi    /* pushl 0 */
   __asm call codePtr
   __asm pop ebx
   __asm pop eax
   __asm add esp, 0x14  
#else
#error
#endif
   
}




#endif /* _TASK_SWITCH_H  */
