/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

#ifndef __VMMONINT_H__
#define __VMMONINT_H__


/*
 * Hide all kernel compatibility stuff in those macros
 */


#ifdef KERNEL_2_1
#   define compat_fop_set_poll(_pFop, _pFunc) do { \
   (_pFop)->poll = (_pFunc);                       \
} while (0)
#else
#   define compat_fop_set_poll(_pFop, _pFunc) do { \
   (_pFop)->select = (_pFunc);                     \
} while (0)
#endif


#ifdef KERNEL_2_4_0
#   define compat_fop_set_owner(_pFop) do { \
   (_pFop)->owner = THIS_MODULE;            \
} while (0)
#   define compat_mod_inc_refcount
#   define compat_mod_dec_refcount
#else
#   define compat_fop_set_owner(_pFop)
#   define compat_mod_inc_refcount do { \
   MOD_INC_USE_COUNT;                   \
} while (0)
#   define compat_mod_dec_refcount do { \
   MOD_DEC_USE_COUNT;                   \
} while (0)
#endif


#ifndef KERNEL_2_4_0
#   define get_page(p) atomic_inc(&(p)->count)
#   ifdef KERNEL_2_1
#      define put_page(p) __free_page(p)
#   else
/*     2.0 kernels don't export __free_page() */
#      define put_page(p) free_page(((p) - mem_map) << PAGE_SHIFT)
#   endif
#endif


#endif /* __VMMONINT_H__ */
