/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

#ifndef __DRIVER_H__
#define __DRIVER_H__

#include <linux/sched.h>
#include <linux/miscdevice.h>

#include "x86.h"
#include "vm_types.h"

#define NUM_PASSTHROUGH_IRQS 10
#define DRIVER_MAX_PIDS      16


struct VMDriver;

typedef struct VMLinux {
   struct VMLinux *next;
   struct VMDriver *vm;
   /*
    * for LinuxDriver_Select()
    */

   Bool selectWaiting;
#ifndef KERNEL_2_3_1
   struct wait_queue *selectQueue;
#else
   wait_queue_head_t selectQueue;
#endif
   struct timer_list selectTimer;

#ifdef SUPPORT_PASSTHROUGH
   /* When Passthrough IRQs fire, we buffer them here until queried */
   int numPendingPassthroughIRQs;
   unsigned char pendingPassthroughIRQs[NUM_PASSTHROUGH_IRQS];
#endif

} VMLinux;

#define DEVICE_BUFFER_SIZE 32
#define LINUXLOG_BUFFER_SIZE  1024

struct vmx_linux_state {
   int major;
   int minor;
   struct miscdevice misc;
   char deviceBuf[DEVICE_BUFFER_SIZE];
   char buf[LINUXLOG_BUFFER_SIZE];
   VMLinux *head;
};

#endif


