/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * $Id: hostif.h,v 1.2 2003/02/16 01:29:49 bad Exp $
 * **********************************************************/

/*
 *  hostif.h - Platform dependent interface for supporting 
 *             the vmx86 device driver. 
 */


#ifndef VMX86P_H
#define VMX86P_H

#include "vmx86.h"

/*
 * Host-specific definitions. 
 */
#if !defined(linux) && !defined(WINNT_DDK) && !defined(__FreeBSD__) && \
    !defined(__NetBSD__)
#error "ONLY Linux, NT, FreeBSD or NetBSD defined for now "
#endif


 /*
 * Linux as a host
 */

#ifdef linux
#include "linux-version.h"

#ifdef KERNEL_2_1
# ifndef __PAGE_OFFSET
#  define __PAGE_OFFSET (0xC0000000)
# endif
# define HOST_KERNEL_PA_2_VA(_x)  ((_x) | __PAGE_OFFSET)
# define HOST_KERNEL_VA_2_LA(_x)  (_x)
# define HOST_KERNEL_LA_2_VA(_x)  (_x)
#else
# define HOST_KERNEL_PA_2_VA(_x)  (_x)
# define HOST_KERNEL_VA_2_LA(_x)  ((_x) | 0xc0000000)
# define HOST_KERNEL_LA_2_VA(_x)  ((_x) & 0x0fffffff)
#endif

#define IRQ_HOST_INTR1_BASE 0x20
#define IRQ_HOST_INTR2_BASE 0x28

#ifdef KERNEL_2_1
// see /usr/src/linux/arch/i386/kernel/irq.h
#define IRQ0_TRAP_VECTOR 0x51
#endif

#endif /* linux */
 
/*
 * FreeBSD/NetBSD as a host
 */

#if defined(__FreeBSD__) || defined(__NetBSD__)

# define HOST_KERNEL_VA_2_LA(_x)  (_x)
# define HOST_KERNEL_LA_2_VA(_x)  (_x)

#define IRQ_HOST_INTR1_BASE 0x20 /* NRSVIDT from /sys/i386/include/segments.h */
#define IRQ_HOST_INTR2_BASE 0x28 /* the same + 8 */

#endif /* __FreeBSD__ */

/*
 * NT as host.
 */

#ifdef WINNT_DDK

#define HOST_KERNEL_VA_2_LA(_addr) ((LA)(_addr))
#define HOST_KERNEL_LA_2_VA(_addr) ((VA)(_addr))

#define IRQ_HOST_INTR1_BASE 0x30
#define IRQ_HOST_INTR2_BASE 0x38

#endif

EXTERN void  HostIF_InitSpinLock(void);
EXTERN int   HostIF_Init(VMDriver *vm);
EXTERN Bool  HostIF_IsSystemSMP(void);
EXTERN MPN   HostIF_LookupUserMPN(VMDriver *vm, char * addr);
EXTERN void *HostIF_UserToDriverPtr(VMDriver *vm, void *addr);
EXTERN void  HostIF_InitFP(VMDriver *vm);

EXTERN void *HostIF_AllocKernelMem(int size, int wired);
EXTERN void  HostIF_FreeKernelMem(void *ptr);

EXTERN void *HostIF_AllocPage(int wired);
EXTERN void  HostIF_FreePage(void *ptr);

EXTERN int   HostIF_CopyFromUser(void *dst, void *src, int len);
EXTERN int   HostIF_CopyToUser(void *dst, void *src, int len);
EXTERN MPN   HostIF_LockPage(VMDriver *vm, void *addr);
EXTERN int   HostIF_UnlockPage(VMDriver *vm, void *addr);
EXTERN int   HostIF_FreeAllResources(VMDriver *vm);
EXTERN VA    HostIF_CheckMemory(VMDriver *vm);
EXTERN int   HostIF_IsMPNLocked(VMDriver *vm, MPN mpn);
EXTERN VmTimeRealClock HostIF_ReadTime(void);
EXTERN uint32 HostIF_MhzRating(VMDriver *vm);

EXTERN void  HostIF_GlobalVMLock(int callerID);
EXTERN void  HostIF_GlobalVMUnLock(int callerID);

EXTERN MA    HostIF_APIC_Base(VMDriver *vm, Bool setVMPtr);
EXTERN MA    HostIF_IOAPIC_Base(VMDriver *vm);

EXTERN void  HostIF_LockKernel(void);
EXTERN void  HostIF_UnLockKernel(void);

#endif 
