#ifndef EXTERN_H_
#define EXTERN_H_

/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 */

#ifdef RCSID
#ifndef lint
static const char *extern_rcsid = "$Header: /usr/local/src/mm/mm-0.94/mm/RCS/extern.h,v 1.3 2005/05/31 14:43:11 beebe Exp beebe $";
#endif
#endif /* RCSID */

/*
 * extern.h - miscellaneous external declarations
 *
 * see parse.h for other definitions used only by command-parsing routines
 */

/* globals declared in version.c */

extern const char *mm_version;		/* program version */
extern const char *mm_compiled;
extern int mm_major_version;
extern int mm_minor_version;
extern int mm_edit_number;
extern const char *OStype;

/* global variables declared in mm.c */

extern int debug;			/* 1 if debugging */
extern int mode;			/* command mode */
extern const char *progname;		/* pointer basename(argv[0]) */
extern msgvec *cf;			/* current mail file */
extern int minutes_west;

/* globals declared in init.c */

extern int PID;				/* process id */
extern int UID;				/* user id */
extern char *HOME;			/* user's home directory */
extern char *real_personal_name;	/* user's real name */

/* globals in compat.c */

extern char shorthostname[], fullhostname[], *mailhostname;

/* global variables declared in set.c */

extern
int	aliases_use_groups,
	auto_startup_get,
        autowrap_column,
        clear_screen,
	control_n_abort,
        control_d_automatic_send,
	control_e_editor,
	crt,
	directory_folders,
	display_flagged_messages,
  	display_outgoing_message,
	escape_automatic_send,
        fast_init_file,
  	gnuemacs_mmail,
  	list_include_headers,
	list_on_separate_pages,
    	modify_read_only,
	new_file_mode,
	prompt_for_bcc,
        reply_all,
        reply_include_me,
    	reply_initial_display,
	reply_insert,
  	send_verbose,
  	sendmail_verbose,
        suspend_on_exit,
        suspend_on_quit,
        terse_text_prompt,
	use_editor_always,		/* fdc */
        keep_tmp_files,			/* fdc */
        use_pop,			/* fdc */
        nocheck;			/* fdc */
extern
string
	crt_filter,
	download_filter,
	header_options_file,
/*	keywords,*/
	mail_directory,
	mail_file,
        mmail_path,
        mime_filter,			/* fdc */
	personal_name,
	print_filter,
	read_prompt,
	reply_indent,
	saved_messages_file,
	send_prompt,
	temp_directory,
	top_level_prompt,
	user_name;

extern
addresslist
	default_bcc_list,
	default_cc_list;

extern
keylist	dont_print_headers,
    	dont_type_headers,
	default_fcc_list,
	user_keywords,
    	only_print_headers,
	only_type_headers,
	user_headers,
        incoming_mail,
	speller,
	editor;

/* miscellaneous C library routines/variables */

#if !defined(__alpha) && !defined(HAVE_NEW_BSD)
extern long time ARGS((long *));		/* really, time_t, NOT long */
#endif

/* miscellaneous utility routines defined in mm modules */

extern FILE *mm_popen ARGS((const char *command_, const char *type_));
extern FILE *more_pipe_open ARGS((FILE *out_, char *filter));
extern addresslist *lookup_alias ARGS((const char *name_));
extern char **parse_filelist ARGS((int count_, int nbytes_, const char *help_, int del_));
extern char **parse_keylist ARGS((int count_, int nbytes_, const char *help_));
extern char **split_args ARGS((const char *str_));
extern char *cdate ARGS((time_t it_));
extern char *create_sender ARGS((void));
extern char *ctad ARGS((time_t it_));
extern char *daytime ARGS((time_t it_));
extern char *evalpipe ARGS((const char *cmd_, char *result_, int maxlen_));
extern char *fdate ARGS((time_t it_));
extern char *fgetline ARGS((FILE *filep_));
extern char *fmt_message ARGS((message *m_, char **only_, char **dont_));
extern char *getlocalhostname ARGS((void));
extern char *getspecialname ARGS((dev_t filedev_));
extern char *getwd ARGS((char *buf_));
extern char *hdate ARGS((time_t it_));
extern char *hfind ARGS((const char *h_, const char *s_));
extern char *hname ARGS((void));
extern char *htext ARGS((const char *h_, const char *s_));
extern char *local_backup_file ARGS((const char *filename_));
extern char *make_backup_file ARGS((const char *filename_));
extern char *mktempfile ARGS((const char *pref_, int usetmp_));
extern char *next_header ARGS((char **s_, int *next_));
extern char *parse_directory ARGS((const char *help_, const char *def_));
extern char *parse_field ARGS((const char *help_, const char *def_));
extern char *parse_input_file ARGS((const char *help_, const char *def_, int allowdir_));
extern char *parse_output_file ARGS((const char *help_, const char *def_, int allowdir_));
extern char *parse_prompt ARGS((const char *help_));
extern char *parse_quoted ARGS((const char *help_, const char *def_));
extern char *parse_text ARGS((const char *help_, const char *def_));
extern char *parse_username ARGS((const char *help_, const char *def_));
extern char *read_from_temp ARGS((const char *fname_));
extern char *rfctime ARGS((time_t it_));
extern char *safe_strcat ARGS((char *dest_, const char *src_, int usespace_));
extern char *safe_strcpy ARGS((const char *str_));
extern char *safe_strncat ARGS((char *dest_, const char *src_, int n_));
extern char *search ARGS((const char *s_, const char *t_));
extern char *skipheader ARGS((const char *s_));
extern char *stripspaces ARGS((char *s_));
extern char *tilde_expand ARGS((const char *dirname_));
extern char *whoami ARGS((void));
extern const char *errstr ARGS((int err_));
extern const char *get_default_temp_dir ARGS((void));
extern const char *parse_old_keywords ARGS((void));
extern int alreadyTransformed ARGS((const char *mail_));
extern int apnd_update ARGS((msgvec **pf_, int cnt_));
extern int babyl_open ARGS((msgvec *mail_, int flags_));
extern int babyl_probe ARGS((const char *file_));
extern int babyl_rdmsg ARGS((msgvec *mail_, int num_));
extern int babyl_wrmsg ARGS((msgvec *mail_, message *msg_, int num_, int flags_));
extern int browse_message ARGS((void));
extern int ccmd_error ARGS((int err_, const char *str_, int flags_));
extern int check_cf ARGS((int modify_));
extern int check_mtime ARGS((msgvec *mf_, int *upd_result_));
extern int cmd_copy ARGS((int n_));
extern int cmd_exit ARGS((int n_));
extern int cmd_get ARGS((int n_));
extern int cmd_help ARGS((int n_));
extern int cmd_list ARGS((int n_));
extern int cmd_next ARGS((int cmd_));
extern int cmd_previous ARGS((int n_));
extern int cmd_print ARGS((int n_));
extern int cmd_push ARGS((int n_));
extern int cmd_quit ARGS((int n_));
extern int cmd_read ARGS((int n_));
extern int cmd_set ARGS((int n_));
extern int cmd_show ARGS((int n_));
extern int cmd_who ARGS((int n_));
extern int collect_process ARGS((int pid_));
extern int display_message ARGS((FILE *out_, message *m_, int maybeclear_, char **only_, char **dont_));
extern int exist ARGS((const char *fname_));
extern int hdrcmp ARGS((const char *s1_, const char *s2_));
extern int ignore ARGS((int n_));
extern int ishead ARGS((const char *str_));
extern int isourhost ARGS((char *host_));
extern int local_contig_open ARGS((msgvec *mail_, int flags_));
extern int local_contig_proben ARGS((const char *file_, FILE **fpp_));
extern int local_same_file ARGS((const char *name1_, const char *name2_));
extern int lock_file ARGS((const char *name_, int fd_));
extern int logical_lines ARGS((const char *s_, int max_));
extern int lookup_keyword ARGS((const char *str_, keylist kl_));
extern int mail_probe ARGS((const char *file_, int *typep_));
extern int mbox_open ARGS((msgvec *mail_, int flags_));
extern int mbox_probe ARGS((const char *file_));
extern int mbox_rdmsg ARGS((msgvec *mail_, int num_));
extern int mbox_wrmsg ARGS((msgvec *mail_, message *msg_, int num_, int flags_));
extern int mh_close ARGS((FILE *fp_));
extern int mh_open ARGS((msgvec *mail_));
extern int mh_probe ARGS((const char *file_));
extern int mh_rdmsg ARGS((void));
extern int mh_wrmsg ARGS((void));
extern int mm_execute ARGS((const char *file_, char * const *argv_));
extern int mm_pclose ARGS((FILE *stream_));
extern int mtxt_open ARGS((msgvec *mail_, int flags_));
extern int mtxt_probe ARGS((const char *file_));
extern int mtxt_rdmsg ARGS((msgvec *mail_, int num_));
extern int mtxt_wrmsg ARGS((msgvec *mail_, message *msg_, int num_, int flags_));
extern int new_mail ARGS((int quiet_));
extern int next_current ARGS((int up_));
extern int p_num ARGS((const char *help_));
extern int parse_alias ARGS((const char *help_, const char *def_));
extern int parse_number ARGS((int radix_, const char *help_, const char *def_));
extern int parse_yesno ARGS((const char *def_));
extern int parse_yesnoask ARGS((const char *def_));
extern int pop2_close ARGS((FILE *fp_));
extern int pop2_open ARGS((msgvec *mail_));
extern int pop2_probe ARGS((const char *file_));
extern int pop2_rdmsg ARGS((void));
extern int pop2_wrmsg ARGS((void));
extern int pop3_close ARGS((FILE *fp_));
extern int pop3_open ARGS((msgvec *mail_));
extern int pop3_probe ARGS((const char *file_));
extern int pop3_rdmsg ARGS((void));
extern int pop3_wrmsg ARGS((void));
extern int pop_input ARGS((void));
extern int prevcmd ARGS((void));
extern int read_fast_init_file ARGS((void));
extern int real_type ARGS((int n_, int real_seq_));

#ifdef rename
extern int rename ARGS((const char *from_, const char *to_));
#endif

extern int same_file ARGS((const char *name1_, const char *name2_));
extern int scanversion ARGS((void));
extern int search_header ARGS((const char *h_, const char *s_, message *m_));
extern int search_text ARGS((const char *s_, message *m_));
extern int seq_next ARGS((int n_));
extern int seq_print ARGS((int nl_));
extern int sequence_init ARGS((msgvec *cf_));
extern int sequence_next ARGS((sequence_t S_));
extern int sequence_prev ARGS((sequence_t S_));
extern int sequence_start ARGS((sequence_t S_));
extern int shell ARGS((const char *cmd_));
extern int show_variable ARGS((FILE *fp_, int n_, int verbose_));
extern int sorry ARGS((const char *fmt, ...));
extern int span ARGS((const char *s1_, const char *s2_));
extern int sys_read ARGS((int fd_, char *buf_, int count_));
extern int sys_write ARGS((int fd_, const char *buf_, int count_));
extern int system_init ARGS((void));
extern int take_file ARGS((const char *s_, int (*take_parser_) ARGS((void)), int echo_));
extern int top_level_parser ARGS((void));
extern int unlock ARGS((FILE *fp_, const char *fname_));
extern int unlock_file ARGS((const char *name_, int fd_));
extern int update ARGS((msgvec **pf_, int updflags_));
extern int user_init ARGS((void));
extern int user_rc ARGS((void));
extern int ustrcmp ARGS((const char *s1_, const char *s2_));
extern int ustrncmp ARGS((const char *str1_, const char *str2_, int n_));
extern int valid_from_field ARGS((const char *str_));
extern int var_not_empty ARGS((int n_));
extern int wait_for_process ARGS((int pid_));
extern int write_fast_init_file ARGS((void));
extern int writeaccess_dir ARGS((char *fname_));
extern int xstrcmp ARGS((char **a_, char **b_));
extern int yesno ARGS((const char *promptstring_, const char *def_));
extern keylist add_keyword ARGS((const char *str_, keylist kl_));
extern keylist free_keylist ARGS((keylist kl_));
extern keylist keylist_copy ARGS((keylist kl_));
extern keylist match_keylist ARGS((char *s_));
extern keylist rem_keyword ARGS((const char *str_, keylist kl_));
extern long block_signals ARGS((void));
extern msgvec *getdestfile ARGS((const char *name_, int format_, int inter_));
extern msgvec *getfile ARGS((const char *file_, int flag_));
extern signalhandler sighup_handler ARGS((void));
extern signalhandler sigint_handler ARGS((void));
extern signalhandler sigxcpu_handler ARGS((void));
extern struct hostent *gethostbyname ARGS((const char *name_));
extern time_t babyl_date ARGS((const char *str_));
extern time_t itime ARGS((struct tm *t_));
extern time_t key2time ARGS((int n_));
extern time_t mbox_date ARGS((const char *str_));
extern time_t mtxt_date ARGS((const char *str_));
extern time_t p_date ARGS((const char *help_));
extern time_t stringtotime ARGS((const char *s_));
extern void add_addresslist ARGS((addresslist *a_, const char *str_, int type_));
extern void babyl_close ARGS((FILE *fp_));
extern void blank ARGS((void));
extern void ccmd_errmsg ARGS((const char *str_));
extern void ccmd_errnp ARGS((int err_));
extern void change_flag ARGS((int n_, int what_));
extern void check_mark ARGS((void));
extern void clear_modified ARGS((void));
extern void cmd_alias ARGS((int n_));
extern void cmd_bcc ARGS((int n_));
extern void cmd_blank ARGS((int cmd_));
extern void cmd_browse ARGS((int n_));
extern void cmd_bug ARGS((int n_));
extern void cmd_cc ARGS((int n_));
extern void cmd_cd ARGS((int n_));
extern void cmd_check ARGS((int n_));
extern void cmd_content_type ARGS((int n_));
extern void cmd_continue ARGS((int n_));
extern void cmd_count ARGS((int cmd_));
extern void cmd_create_init ARGS((int n_));
extern void cmd_daytime ARGS((int n_));
extern void cmd_debug ARGS((int n_));
extern void cmd_debug_memory ARGS((int n_));
extern void cmd_define ARGS((int n_));
extern void cmd_display ARGS((int n_));
extern int cmd_download ARGS((int n_));
extern void cmd_echo ARGS((int n_));
extern void cmd_edit ARGS((int n_));
extern void cmd_erase ARGS((int n_));
extern void cmd_expunge ARGS((int n_));
extern void cmd_fcc ARGS((int n_));
extern void cmd_finger ARGS((int n_));
extern void cmd_forward ARGS((int n_));
extern void cmd_from ARGS((int n_));
extern void cmd_headers ARGS((int n_));
extern void cmd_in_reply_to ARGS((int n_));
extern void cmd_insert ARGS((int n_));
extern void cmd_jump ARGS((int n_));
extern void cmd_keyword ARGS((int n_));
extern void cmd_literal ARGS((int n_));
extern void cmd_mark ARGS((int cmd_));
extern void cmd_mime_version ARGS((int n_));
extern void cmd_profile ARGS((int n_));
extern void cmd_pwd ARGS((int n_));
extern void cmd_remail ARGS((int n_));
extern void cmd_remove ARGS((int n_));
extern void cmd_reply ARGS((int n_));
extern void cmd_reply_to ARGS((int n_));
extern void cmd_restore_draft ARGS((int n_));
extern void cmd_route ARGS((int n_));
extern void cmd_save_draft ARGS((int n_));
extern void cmd_send ARGS((int n_));
extern void cmd_smail ARGS((int n_));
extern void cmd_sort ARGS((int n_));
extern void cmd_spell ARGS((int n_));
extern void cmd_status ARGS((int n_));
extern void cmd_subject ARGS((int n_));
extern void cmd_suspend ARGS((int n_));
extern void cmd_take ARGS((int n_));
extern void cmd_text ARGS((int n_));
extern void cmd_to ARGS((int n_));
extern void cmd_transfer_encoding ARGS((int n_));
extern void cmd_type ARGS((int n_));
extern void cmd_unkeyword ARGS((int n_));
extern void cmd_user_header ARGS((int n_));
extern void cmd_version ARGS((int n_));
extern void cmd_write ARGS((int n_));
extern void cmerr ARGS((const char *fmt, ...));
extern void confirmit ARGS((const char *promptstring_));
extern void copy_sequence ARGS((sequence_t S1_, sequence_t S2_));
extern void debug_validate_msgvec ARGS((const char *str_));
extern void deliver ARGS((void));
extern void disp_addresses ARGS((FILE *fp_, const char *prefix_, addresslist *a_,
				 int expand_, int newline_, int smail_,
				 int file_asterix_));
extern void disp_alias ARGS((FILE *fp_, int n_, int verbose_, int newline_));
extern void do_flagged ARGS((void));
extern void do_keyword ARGS((void));
extern void do_reply ARGS((int msgno_, int all_, int include_));
extern void do_reply_many ARGS((void));
extern void done ARGS((int n_));
extern void edit_outgoing ARGS((int p_));
extern void fail ARGS((int num_));
extern void fail_msg ARGS((int num_));
extern void fix_signals_for_fork ARGS((int before_the_fork_));
extern void fix_signals_for_wait ARGS((int before_the_wait_));
extern void free_addresslist ARGS((addresslist *a_));
extern void get_incoming_keywords ARGS((msgvec *cf_, message *m_));
extern void group_init ARGS((void));
extern void header_print ARGS((int n_));
extern void header_summary ARGS((int n_, FILE *fp_, int longfmt_));
extern void hold ARGS((void));
extern void init ARGS((void));
extern void init_signals ARGS((void));
extern void initialize ARGS((char **argv_));
extern void local_close ARGS((FILE *fp_));
extern void local_get_size ARGS((msgvec *mail_));
extern void local_record_mtime ARGS((msgvec *mf_));
extern void m_checkranges ARGS((void));
extern void m_done ARGS((void));
extern void m_init ARGS((void));
extern void mailrc ARGS((void));
extern void match_addresses ARGS((addresslist *a_, const char **buf_,
	int len_));
extern void maybe_abort ARGS((const char *str_));
extern void maybe_wait_for_process ARGS((int pid_));
extern void mbox_close ARGS((FILE *fp_));
extern void merge_addresses ARGS((addresslist *a1_, addresslist *a2_));
extern void more_pipe_close ARGS((FILE *fp_));
extern void mtxt_close ARGS((FILE *fp_));
extern void novice_banner ARGS((int mode_));
extern void outgoing_keyword ARGS((const char *key_));
extern void p_file ARGS((const char *deflt_, int input_));
extern void panic ARGS((const char *s_));
extern void parse_address ARGS((addresslist *a_));
extern void parse_addresses ARGS((addresslist *a_));
extern void parse_define ARGS((addresslist *a_));
extern void parse_file ARGS((const char *hlp_, const char *dir_));
extern void printhelp ARGS((const char *command_, int level_, int topic_mode_));
extern void prompt_address ARGS((const char *pstr_, addresslist *a_));
extern void prompt_fcc ARGS((const char *pstr_, addresslist *a_));
extern void queue_signal ARGS((int sig_));
extern void redisplay_line ARGS((void));
extern void release_signals ARGS((long m_));
extern void remove_addr ARGS((addresslist *a1_, addresslist *a2_));
extern void sequence_free ARGS((msgvec *cf_));
extern void sequence_loop ARGS((void (*fn_ ) ARGS((int n_))));
extern void set_alias ARGS((const char *name_, addresslist *addr_, int type_));
extern void set_msg_keywords ARGS((message *m_));
extern void sethome ARGS((char *name_));
extern void show_route ARGS((int verbose_));
extern void skip_spaces ARGS((char **str_));
extern void stack_input ARGS((FILE *fd_));
extern void suspend ARGS((int updflags_));
extern void unoutgoing_keyword ARGS((const char *key_));
extern void usage_start ARGS((void));
extern void usage_stop ARGS((const char *logfile_));
extern void write_sender ARGS((FILE *tfp_));
extern void *safe_free ARGS((void *str_));
extern void *safe_realloc ARGS((void *cp_, int size_));

extern int allow_aborts;
extern Mail_aliases mail_aliases;

#endif /* EXTERN_H_ */
