#include "config.h"
/*
 * Copyright (c) 1986, 2014 by The Trustees of Columbia University in
 * the City of New York.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  + Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  + Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 *  + Neither the name of Columbia University nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.

*/
/*
 * generate the cmkeyval.h file.
 *
 * figure out what is the largest native type on the system,
 * and typedef keyval to that type.
 */

#include <stdio.h>

typedef struct {
    int size;
    const char *name;
} type;

typedef int (* cmprocptr)();
static type typetab[] = {
    { sizeof(int), "int" },
    { sizeof(char *), "char *" },
    { sizeof(int *), "int *" },
    { sizeof(cmprocptr), "cmprocptr" },
    { sizeof(void *), "void *" },
};

static int typetablen = sizeof(typetab)/sizeof(type);

int
main(VOID)
{
    int i;
    int max = 0;
    for(i = 0; i < typetablen; i++)
	if (typetab[max].size < typetab[i].size)
	    max = i;
    printf("typedef int (* cmprocptr)();\n");
    printf("typedef %s keyval;\n",typetab[max].name);
    return(0);
}
