#!/bin/sh

#optimize="-release"
optimize="-debug"

#exceptions="-exceptions"
exceptions="-no-exceptions"

#accessibility="-accessibility"
accessibility="-no-accessibility"

#stl="-stl"
stl="-no-stl"

sql=""
sql_drivers="ibase mysql odbc psql sqlite sqlite2"
for drv in $sql_drivers; do
    sql="$sql -no-sql-$drv"
done

gfx="-qt-gfx-wsfb"
gfx_drivers="linuxfb transformed qvfb vnc multiscreen"
for drv in $gfx_drivers; do
    gfx="$gfx -no-gfx-$drv"
done

kbd="-qt-kbd-wskbd"
kbd_drivers="tty usb sl5000 yopy vr41xx qvfb"
for drv in $kbd_drivers; do
    kbd="$kbd -no-kbd-$drv"
done

mouse="-qt-mouse-wsmouse"
mouse_drivers="pc bus linuxtp yopy vr41xx tslib qvfb"
for drv in $mouse_drivers; do
    mouse="$mouse -no-mouse-$drv"
done


set -x
echo yes | \
./configure \
    --prefix-install \
    \
    $optimize \
    -shared \
    -no-fast \
    -largefile \
    $exceptions \
    $accessibility \
    $stl \
    $sql \
    -no-qt3support \
    -no-xmlpatterns \
    -no-phonon \
    -no-phonon-backend \
    -svg \
    -webkit \
    \
    -system-zlib \
    -qt-gif \
    -system-libtiff \
    -system-libpng \
    -qt-libmng \
    -system-libjpeg \
    -openssl \
    \
    --enable-rpath \
    -verbose \
    -optimized-qmake \
    -no-nis \
    -no-cups \
    -iconv \
    -no-pch \
    -no-dbus \
    -no-separate-debug-info \
    \
    -system-freetype \
    -no-glib \
    $gfx $kbd $mouse
