// -*- mode: c++; indent-tabs-mode: nil; -*-
#include "qkbdwskbd_qws.h"

#ifndef QT_NO_QWS_KBD_WSKBD

#include <sys/cdefs.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>

#include <dev/wscons/wsconsio.h>
#include <dev/wscons/wsksymdef.h>
#include <dev/wscons/wsksymvar.h>

#include "qsocketnotifier.h"
#include "qscreen_qws.h"


QT_BEGIN_NAMESPACE

/* *sigh*, i hate keyboard mappings since awt days ... */

struct wstoq_mapping {
    keysym_t wsksym;
    Qt::Key qkey;
}; 

static const struct wstoq_mapping KeyTbl[] = {
    { KS_BackSpace,     Qt::Key_Backspace },
    { KS_Tab,           Qt::Key_Tab},
    { KS_Linefeed,      Qt::Key_Enter },
    { KS_Clear,         Qt::Key_Clear },
    { KS_Return,        Qt::Key_Return },
    { KS_Escape,        Qt::Key_Escape },
    { KS_space,         Qt::Key_Space },
    { KS_exclam,        Qt::Key_Exclam },
    { KS_quotedbl,      Qt::Key_QuoteDbl },
    { KS_numbersign,    Qt::Key_NumberSign },
    { KS_dollar,        Qt::Key_Dollar },
    { KS_percent,       Qt::Key_Percent },
    { KS_ampersand,     Qt::Key_Ampersand },
    { KS_apostrophe,    Qt::Key_Apostrophe },
    { KS_parenleft,     Qt::Key_ParenLeft },
    { KS_parenright,    Qt::Key_ParenRight },
    { KS_asterisk,      Qt::Key_Asterisk },
    { KS_plus,          Qt::Key_Plus },
    { KS_comma,         Qt::Key_Comma },
    { KS_minus,         Qt::Key_Minus },
    { KS_period,        Qt::Key_Period },
    { KS_slash,         Qt::Key_Slash },
    { KS_0,             Qt::Key_0 },
    { KS_1,             Qt::Key_1 },
    { KS_2,             Qt::Key_2 },
    { KS_3,             Qt::Key_3 },
    { KS_4,             Qt::Key_4 },
    { KS_5,             Qt::Key_5 },
    { KS_6,             Qt::Key_6 },
    { KS_7,             Qt::Key_7 },
    { KS_8,             Qt::Key_8 },
    { KS_9,             Qt::Key_9 },
    { KS_colon,         Qt::Key_Colon },
    { KS_semicolon,     Qt::Key_Semicolon },
    { KS_less,          Qt::Key_Less },
    { KS_equal,         Qt::Key_Equal },
    { KS_greater,       Qt::Key_Greater },
    { KS_question,      Qt::Key_Question },
    { KS_at,            Qt::Key_At },
    { KS_A,             Qt::Key_A },
    { KS_B,             Qt::Key_B },
    { KS_C,             Qt::Key_C },
    { KS_D,             Qt::Key_D },
    { KS_E,             Qt::Key_E },
    { KS_F,             Qt::Key_F },
    { KS_G,             Qt::Key_G },
    { KS_H,             Qt::Key_H },
    { KS_I,             Qt::Key_I },
    { KS_J,             Qt::Key_J },
    { KS_K,             Qt::Key_K },
    { KS_L,             Qt::Key_L },
    { KS_M,             Qt::Key_M },
    { KS_N,             Qt::Key_N },
    { KS_O,             Qt::Key_O },
    { KS_P,             Qt::Key_P },
    { KS_Q,             Qt::Key_Q },
    { KS_R,             Qt::Key_R },
    { KS_S,             Qt::Key_S },
    { KS_T,             Qt::Key_T },
    { KS_U,             Qt::Key_U },
    { KS_V,             Qt::Key_V },
    { KS_W,             Qt::Key_W },
    { KS_X,             Qt::Key_X },
    { KS_Y,             Qt::Key_Y },
    { KS_Z,             Qt::Key_Z },
    { KS_bracketleft,   Qt::Key_BracketLeft },
    { KS_backslash,     Qt::Key_Backslash },
    { KS_bracketright,  Qt::Key_BracketRight},
    { KS_asciicircum,   Qt::Key_AsciiCircum },
    { KS_underscore,    Qt::Key_Underscore },
    { KS_grave,         Qt::Key_QuoteLeft }, // XXX
    { KS_a,             Qt::Key_A },
    { KS_b,             Qt::Key_B },
    { KS_c,             Qt::Key_C },
    { KS_d,             Qt::Key_D },
    { KS_e,             Qt::Key_E },
    { KS_f,             Qt::Key_F },
    { KS_g,             Qt::Key_G },
    { KS_h,             Qt::Key_H },
    { KS_i,             Qt::Key_I },
    { KS_j,             Qt::Key_J },
    { KS_k,             Qt::Key_K },
    { KS_l,             Qt::Key_L },
    { KS_m,             Qt::Key_M },
    { KS_n,             Qt::Key_N },
    { KS_o,             Qt::Key_O },
    { KS_p,             Qt::Key_P },
    { KS_q,             Qt::Key_Q },
    { KS_r,             Qt::Key_R },
    { KS_s,             Qt::Key_S },
    { KS_t,             Qt::Key_T },
    { KS_u,             Qt::Key_U },
    { KS_v,             Qt::Key_V },
    { KS_w,             Qt::Key_W },
    { KS_x,             Qt::Key_X },
    { KS_y,             Qt::Key_Y },
    { KS_z,             Qt::Key_Z },
    { KS_braceleft,     Qt::Key_BraceLeft },
    { KS_bar,           Qt::Key_Bar },
    { KS_braceright,    Qt::Key_BraceRight },
    { KS_asciitilde,    Qt::Key_AsciiTilde },
    { KS_Delete,        Qt::Key_Delete },

    { KS_nobreakspace,  Qt::Key_nobreakspace },
    { KS_exclamdown,    Qt::Key_exclamdown },
    { KS_cent,          Qt::Key_cent },
    { KS_sterling,      Qt::Key_sterling },
    { KS_currency,      Qt::Key_currency },
    { KS_yen,           Qt::Key_yen },
    { KS_brokenbar,     Qt::Key_brokenbar },
    { KS_section,       Qt::Key_section },
    { KS_diaeresis,     Qt::Key_diaeresis },
    { KS_copyright,     Qt::Key_copyright },
    { KS_ordfeminine,   Qt::Key_ordfeminine },
    { KS_guillemotleft, Qt::Key_guillemotleft },
    { KS_notsign,       Qt::Key_notsign },
    { KS_hyphen,        Qt::Key_hyphen },
    { KS_registered,    Qt::Key_registered },
    { KS_macron,        Qt::Key_macron },
    { KS_degree,        Qt::Key_degree },
    { KS_plusminus,     Qt::Key_plusminus },
    { KS_twosuperior,   Qt::Key_twosuperior },
    { KS_threesuperior, Qt::Key_threesuperior },
    { KS_acute,         Qt::Key_acute },
    { KS_mu,            Qt::Key_mu },
    { KS_paragraph,     Qt::Key_paragraph },
    { KS_periodcentered,Qt::Key_periodcentered },
    { KS_cedilla,       Qt::Key_cedilla },
    { KS_onesuperior,   Qt::Key_onesuperior },
    { KS_masculine,     Qt::Key_masculine },
    { KS_guillemotright,Qt::Key_guillemotleft },
    { KS_onequarter,    Qt::Key_onequarter },
    { KS_onehalf,       Qt::Key_onehalf },
    { KS_threequarters, Qt::Key_threequarters },
    { KS_questiondown,  Qt::Key_questiondown },
    { KS_Agrave,        Qt::Key_Agrave },
    { KS_Aacute,        Qt::Key_Aacute },
    { KS_Acircumflex,   Qt::Key_Acircumflex },
    { KS_Atilde,        Qt::Key_Atilde },
    { KS_Adiaeresis,    Qt::Key_Adiaeresis },
    { KS_Aring,         Qt::Key_Aring },
    { KS_AE,            Qt::Key_AE },
    { KS_Ccedilla,      Qt::Key_Ccedilla },
    { KS_Egrave,        Qt::Key_Egrave },
    { KS_Eacute,        Qt::Key_Eacute },
    { KS_Ecircumflex,   Qt::Key_Ecircumflex },
    { KS_Ediaeresis,    Qt::Key_Ediaeresis },
    { KS_Igrave,        Qt::Key_Igrave },
    { KS_Iacute,        Qt::Key_Iacute },
    { KS_Icircumflex,   Qt::Key_Icircumflex },
    { KS_Idiaeresis,    Qt::Key_Idiaeresis },
    { KS_ETH,           Qt::Key_ETH },
    { KS_Ntilde,        Qt::Key_Ntilde },
    { KS_Ograve,        Qt::Key_Ograve },
    { KS_Oacute,        Qt::Key_Oacute },
    { KS_Ocircumflex,   Qt::Key_Ocircumflex },
    { KS_Otilde,        Qt::Key_Otilde },
    { KS_Odiaeresis,    Qt::Key_Odiaeresis },
    { KS_multiply,      Qt::Key_multiply },
    { KS_Ooblique,      Qt::Key_Ooblique },
    { KS_Ugrave,        Qt::Key_Ugrave },
    { KS_Uacute,        Qt::Key_Uacute },
    { KS_Ucircumflex,   Qt::Key_Ucircumflex },
    { KS_Udiaeresis,    Qt::Key_Udiaeresis },
    { KS_Yacute,        Qt::Key_Yacute },
    { KS_THORN,         Qt::Key_THORN },
    { KS_ssharp,        Qt::Key_ssharp },
    { KS_agrave,        Qt::Key_Agrave },
    { KS_aacute,        Qt::Key_Aacute },
    { KS_acircumflex,   Qt::Key_Acircumflex },
    { KS_atilde,        Qt::Key_Atilde },
    { KS_adiaeresis,    Qt::Key_Adiaeresis },
    { KS_aring,         Qt::Key_Aring },
    { KS_ae,            Qt::Key_AE },
    { KS_ccedilla,      Qt::Key_Ccedilla },
    { KS_egrave,        Qt::Key_Egrave },
    { KS_eacute,        Qt::Key_Eacute },
    { KS_ecircumflex,   Qt::Key_Ecircumflex },
    { KS_ediaeresis,    Qt::Key_Ediaeresis },
    { KS_igrave,        Qt::Key_Igrave },
    { KS_iacute,        Qt::Key_Iacute },
    { KS_icircumflex,   Qt::Key_Icircumflex },
    { KS_idiaeresis,    Qt::Key_Idiaeresis },
    { KS_eth,           Qt::Key_ETH },
    { KS_ntilde,        Qt::Key_Ntilde },
    { KS_ograve,        Qt::Key_Ograve },
    { KS_oacute,        Qt::Key_Oacute },
    { KS_ocircumflex,   Qt::Key_Ocircumflex },
    { KS_otilde,        Qt::Key_Otilde },
    { KS_odiaeresis,    Qt::Key_Odiaeresis },
    { KS_division,      Qt::Key_division },
    { KS_oslash,        Qt::Key_Ooblique },
    { KS_ugrave,        Qt::Key_Ugrave },
    { KS_uacute,        Qt::Key_Uacute },
    { KS_ucircumflex,   Qt::Key_Ucircumflex },
    { KS_udiaeresis,    Qt::Key_Udiaeresis },
    { KS_yacute,        Qt::Key_Yacute },
    { KS_thorn,         Qt::Key_THORN },
    { KS_ydiaeresis,    Qt::Key_ydiaeresis },

    { KS_dead_grave,    Qt::Key_Dead_Grave },
    { KS_dead_acute,    Qt::Key_Dead_Acute },
    { KS_dead_circumflex, Qt::Key_Dead_Circumflex },
    { KS_dead_tilde,    Qt::Key_Dead_Tilde },
    { KS_dead_diaeresis,Qt::Key_Dead_Diaeresis },
    { KS_dead_abovering,Qt::Key_Dead_Abovering },
    { KS_dead_cedilla,  Qt::Key_Dead_Cedilla },
    { KS_dead_semi,     Qt::Key_Dead_Semivoiced_Sound },
    { KS_dead_colon,    Qt::Key_unknown }, // XXX

    { KS_Shift_L,       Qt::Key_Shift },
    { KS_Shift_R,       Qt::Key_Shift },
    { KS_Control_L,     Qt::Key_Control },
    { KS_Control_R,     Qt::Key_Control },
    { KS_Caps_Lock,     Qt::Key_CapsLock },
    { KS_Shift_Lock,    Qt::Key_unknown },
    { KS_Alt_L,         Qt::Key_Alt },
    { KS_Alt_R,         Qt::Key_Alt },
    { KS_Multi_key,     Qt::Key_Multi_key },
    { KS_Mode_switch,   Qt::Key_Mode_switch },
    { KS_Num_Lock,      Qt::Key_NumLock },
    { KS_Hold_Screen,   Qt::Key_ScrollLock },
    { KS_Cmd,           Qt::Key_unknown },
    { KS_Cmd1,          Qt::Key_unknown },
    { KS_Cmd2,          Qt::Key_unknown },
    { KS_Meta_L,        Qt::Key_Meta },
    { KS_Meta_R,        Qt::Key_Meta },
    { KS_Zenkaku_Hankaku, Qt::Key_Zenkaku_Hankaku },
    { KS_Hiragana_Katakana, Qt::Key_Hiragana_Katakana },
    { KS_Henkan_Mode,   Qt::Key_Henkan },
    { KS_Henkan,        Qt::Key_Henkan },
    { KS_Muhenkan,      Qt::Key_Muhenkan },

    { KS_f1,            Qt::Key_F1 },
    { KS_f2,            Qt::Key_F2 },
    { KS_f3,            Qt::Key_F3 },
    { KS_f4,            Qt::Key_F4 },
    { KS_f5,            Qt::Key_F5 },
    { KS_f6,            Qt::Key_F6 },
    { KS_f7,            Qt::Key_F7 },
    { KS_f8,            Qt::Key_F8 },
    { KS_f9,            Qt::Key_F9 },
    { KS_f10,           Qt::Key_F10 },
    { KS_f11,           Qt::Key_F11},
    { KS_f12,           Qt::Key_F12 },
    { KS_f13,           Qt::Key_F13 },
    { KS_f14,           Qt::Key_F14 },
    { KS_f15,           Qt::Key_F15 },
    { KS_f16,           Qt::Key_F16 },
    { KS_f17,           Qt::Key_F17 },
    { KS_f18,           Qt::Key_F18 },
    { KS_f19,           Qt::Key_F19 },
    { KS_f20,           Qt::Key_F20 },

    { KS_F1,            Qt::Key_F1 },
    { KS_F2,            Qt::Key_F2 },
    { KS_F3,            Qt::Key_F3 },
    { KS_F4,            Qt::Key_F4 },
    { KS_F5,            Qt::Key_F5 },
    { KS_F6,            Qt::Key_F6 },
    { KS_F7,            Qt::Key_F7 },
    { KS_F8,            Qt::Key_F8 },
    { KS_F9,            Qt::Key_F9 },
    { KS_F10,           Qt::Key_F10 },
    { KS_F11,           Qt::Key_F11},
    { KS_F12,           Qt::Key_F12 },
    { KS_F13,           Qt::Key_F13 },
    { KS_F14,           Qt::Key_F14 },
    { KS_F15,           Qt::Key_F15 },
    { KS_F16,           Qt::Key_F16 },
    { KS_F17,           Qt::Key_F17 },
    { KS_F18,           Qt::Key_F18 },
    { KS_F19,           Qt::Key_F19 },
    { KS_F20,           Qt::Key_F20 },

    { KS_Home,          Qt::Key_Home },
    { KS_Prior,         Qt::Key_PageUp },
    { KS_Next,          Qt::Key_PageDown },
    { KS_Up,            Qt::Key_Up },
    { KS_Down,          Qt::Key_Down },
    { KS_Left,          Qt::Key_Left },
    { KS_Right,         Qt::Key_Right },
    { KS_End,           Qt::Key_End },
    { KS_Insert,        Qt::Key_Insert },
    { KS_Help,          Qt::Key_Help },
    { KS_Execute,       Qt::Key_Execute },
    { KS_Find,          Qt::Key_Search },
    { KS_Select,        Qt::Key_Select },
    { KS_Again,         Qt::Key_unknown }, // XXX
    { KS_Props,         Qt::Key_unknown }, // XXX
    { KS_Undo,          Qt::Key_unknown }, // XXX
    { KS_Front,         Qt::Key_unknown }, // XXX
    { KS_Copy,          Qt::Key_unknown }, // XXX
    { KS_Open,          Qt::Key_unknown }, // XXX
    { KS_Paste,         Qt::Key_unknown }, // XXX
    { KS_Cut,           Qt::Key_unknown }, // XXX

    { KS_Menu,          Qt::Key_Menu },
    { KS_Pause,         Qt::Key_Pause },
    { KS_Print_Screen,  Qt::Key_Print },
};


struct qws_keymap {
    Qt::Key qkey;
    keysym_t command;
    int group1[2];
    int group2[2];
};


class QWSWSKbdKeyboardPrivate : public QObject
{
    Q_OBJECT

public:
    QWSWSKbdKeyboardPrivate(QWSWSKbdKeyboardHandler &handler,
                            const QString &device);
    virtual ~QWSWSKbdKeyboardPrivate();

private:
    int keyWStoUnicode(keysym_t);

private:
    QWSWSKbdKeyboardHandler &handler;

    int fd;
    QSocketNotifier *notifier;

    struct qws_keymap *keymap;
    size_t keymaplen;

    Qt::KeyboardModifiers mods;

private slots:
    void readKeyboardData();
    void handleTtySwitch(int);
};


QWSWSKbdKeyboardHandler::QWSWSKbdKeyboardHandler(const QString &device)
  : d(new QWSWSKbdKeyboardPrivate(*this, device))
{
    return;
}


QWSWSKbdKeyboardHandler::~QWSWSKbdKeyboardHandler()
{
    delete d;
}


QWSWSKbdKeyboardPrivate::QWSWSKbdKeyboardPrivate(
    QWSWSKbdKeyboardHandler &handler,
    const QString &device)
  : handler(handler),
    fd(-1),
    notifier(NULL),
    mods(Qt::NoModifier)
{
    QString kbddev;
    if (device.isEmpty()) {
        kbddev = QLatin1String("/dev/wskbd");
    }
    else {
        kbddev = device;
    }

    fd = open(kbddev.toLatin1().constData(), O_RDONLY | O_NDELAY);
    if (fd < 0) {
        qWarning("Cannot open %s (%s)", qPrintable(kbddev), strerror(errno));
        return;
    }
    fcntl(fd, F_SETFD, FD_CLOEXEC | fcntl(fd, F_GETFD, 0));

#ifdef WSKBDIO_SETVERSION
    int version = WSKBDIO_EVENT_VERSION;
    if (ioctl(fd, WSKBDIO_SETVERSION, &version) < 0) {
        qWarning("WSKBDIO_SETVERSION: %s", strerror(errno));
        return;
    }
#endif

    struct wskbd_map_data wskbdmap;
    wskbdmap.maplen = KS_NUMKEYCODES;
    wskbdmap.map
        = (struct wscons_keymap *)malloc(wskbdmap.maplen
                                         * sizeof(struct wscons_keymap));
    if (ioctl(fd, WSKBDIO_GETMAP, &wskbdmap) < 0) {
        qWarning("WSKBDIO_GETMAP: %s", strerror(errno));
        return;
    }

    // XXX: don't bother if we pre-translate to Qt keycodes
    if (wskbdmap.maplen < KS_NUMKEYCODES) {
        // save a few KBs
        struct wscons_keymap *shortened_map =
            (struct wscons_keymap *)realloc(wskbdmap.map,
                                            wskbdmap.maplen
                                            * sizeof(struct wscons_keymap));
        if (shortened_map != NULL) {
            wskbdmap.map = shortened_map;
        }
    }

    keymaplen = wskbdmap.maplen;
    keymap = (struct qws_keymap *)malloc(keymaplen * sizeof(struct qws_keymap));

    for (unsigned int i = 0; i < wskbdmap.maplen; ++i) {
        keymap[i].qkey = Qt::Key_unknown;
        for (unsigned int j = 0; j < __arraycount(KeyTbl); ++j) {
            if (KeyTbl[j].wsksym == wskbdmap.map[i].group1[0]) {
                keymap[i].qkey = KeyTbl[j].qkey;
                break;
            }
        }

        keymap[i].command = wskbdmap.map[i].command;

        keymap[i].group1[0] = keyWStoUnicode(wskbdmap.map[i].group1[0]);
        keymap[i].group1[1] = keyWStoUnicode(wskbdmap.map[i].group1[1]);
        keymap[i].group2[0] = keyWStoUnicode(wskbdmap.map[i].group2[0]);
        keymap[i].group2[1] = keyWStoUnicode(wskbdmap.map[i].group2[1]);
    }

    notifier = new QSocketNotifier(fd, QSocketNotifier::Read, this);
    connect(notifier, SIGNAL(activated(int)), this, SLOT(readKeyboardData()));
}


QWSWSKbdKeyboardPrivate::~QWSWSKbdKeyboardPrivate()
{
    if (notifier != NULL) {
        notifier->setEnabled(false);
        delete notifier;
    }

    if (fd >=0) {
        close(fd);
    }
}


int QWSWSKbdKeyboardPrivate::keyWStoUnicode(keysym_t ksym)
{
    int unicode = -1;

    // XXX: rely on numerology
    if (ksym < 0x100)
        unicode = ksym;
    
    return unicode;
}


void QWSWSKbdKeyboardPrivate::readKeyboardData()
{
    if(!qt_screen)
        return;

    for (;;) {
        struct wscons_event wsevent;
        ssize_t nread = read(fd, &wsevent, sizeof(wsevent));
        if (nread != sizeof(wsevent)) {
            return;
        }

        unsigned int keycode = wsevent.value;
        if (keycode >= keymaplen) {
            continue;
        }

        bool isPress = false;
        switch (wsevent.type) {
        case WSCONS_EVENT_KEY_UP:
#if 0
            qDebug("up 0x%x (%d)", keycode, keycode);
#endif
            isPress = false;
            break;

        case WSCONS_EVENT_KEY_DOWN:
#if 0
            qDebug("dn 0x%x (%d)", keycode, keycode);
#endif
            isPress = true;
            break;

        case WSCONS_EVENT_ALL_KEYS_UP:
            qDebug("ALL_KEYS_UP");
            break;

        default:
            qDebug("Unknown WSEVENT %u = 0x%x (%d)",
                   wsevent.type,
                   wsevent.value, wsevent.value);
            break;
        }

        // XXX: qws doesn't like events that has Key_unknown and no text
        Qt::Key qkey = keymap[keycode].qkey;
        if (qkey == Qt::Key_unknown) {
            continue;
        }

        if (qkey == Qt::Key_Shift) {
            if (isPress) {
                mods |= Qt::ShiftModifier;
            }
            else {
                mods &= ~Qt::ShiftModifier;
            }
        }
        else if (qkey == Qt::Key_Control) {
            if (isPress) {
                mods |= Qt::ControlModifier;
            }
            else {
                mods &= ~Qt::ControlModifier;
            }
        }

        int unicode = -1;
        if (mods == Qt::NoModifier) {
            unicode = keymap[keycode].group1[0];
        }
        else if (mods == Qt::ShiftModifier) {
            unicode = keymap[keycode].group1[1];
        }

        handler.processKeyEvent(unicode, qkey, mods, isPress, false);
    }
}


void QWSWSKbdKeyboardPrivate::handleTtySwitch(int)
{
}


QT_END_NAMESPACE

#include "qkbdwskbd_qws.moc"

#endif // QT_NO_QWS_KBD_WSKBD
