#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <err.h>

#define MACLEN 6
#define MACS   174762

int
main(int argc, char **argv)
{
    int fd, cnt, i;
    u_int32_t crc;
    char *etherdata;

    if (argc != 2) errx(1, "Iteration count required.");

    cnt = atoi(argv[1]) * 2;	/* raw test does 1MB of data TWICE */

    etherdata = malloc(MACLEN * MACS);
    if (!etherdata) err(2, "Can't allocate %d bytes", MACLEN * MACS);

    fd = open("etherdata", O_RDONLY, (mode_t)0);
    if (fd == -1) err(3, "Can't open binary data for crc32");

    if(read(fd, etherdata, MACLEN * MACS) != MACLEN * MACS) {
	err(4, "Can't read data for crc32");
    }

    close(fd);
    
    for(i = 0; i < cnt; i++) {
	char *addr;
	for(addr = etherdata + MACLEN * (MACS - 1); addr > etherdata;
	    addr -= MACLEN) {
	    crc = crc32((u_int32_t)0, addr, MACLEN);
	}
    }
}
